const connections = {};

// const nativePort = chrome.runtime.connectNative("com.schneider_digital.pluraview_extension");

chrome.runtime.onConnect.addListener(port => {
  // @TODO: release connection when disconnected

  port.onMessage.addListener((message, sender, reply) => {
    const tabId = message.tabId !== undefined ? message.tabId : sender.sender.tab.id;

    if (connections[tabId] === undefined) {
      connections[tabId] = {};
    }

    const portMap = connections[tabId];

    // Can be multiple content scripts per tab
    // for example if a web page includes iframe.
    // So manage ports as an array.
    if (!portMap[port.name]) {
      portMap[port.name] = [];
    }

    if (!portMap[port.name].includes(port)) {
      portMap[port.name].push(port);
      port.onDisconnect.addListener(() => {
        if (portMap[port.name].includes(port)) {
          portMap[port.name].splice(portMap[port.name].indexOf(port), 1);
        }
        if (portMap[port.name].length === 0) {
          delete portMap[port.name]
        }
        if (Object.keys(portMap).length === 0) {
          delete connections[tabId];
        }
      });
    }

    // transfer message between panel and contentScripts of the same tab

    if (port.name === 'panel') {
      postMessageToPorts(portMap.contentScript, message);
    }
    if (port.name === 'contentScript') {
      postMessageToPorts(portMap.panel, message);
    }

    console.log(message.action);
    switch (message.action) {
      case 'pluraview-prepare-displays':
        chrome.tabs.get(tabId, tab => {
          chrome.runtime.sendNativeMessage("com.schneider_digital.pluraview_extension", {
            action: 'device-enter-immersive',
            title: tab.title,
          }, response => {
            setTimeout(() => {
              chrome.windows.get(tab.windowId, window => {
                chrome.windows.update(tab.windowId, {
                  state: 'normal',
                  width: screen.width * 2,
                  height: screen.height,
                  top: 0,
                  left: 0
                });

                postMessageToPorts(portMap.contentScript, {
                  action: 'pluraview-displays-ready'
                });
              });
            }, 1000);
          });
        });

        break;

      case 'device-leave-immersive':
        chrome.tabs.get(tabId, tab => {
          chrome.runtime.sendNativeMessage("com.schneider_digital.pluraview_extension", {
            action: 'device-leave-immersive',
            title: tab.title,
          }, response => {
            chrome.windows.get(tab.windowId, window => {
              chrome.windows.update(tab.windowId, {
                state: 'maximized',
              });
            });
          });
        });
        break;
    }
  });
});

const postMessageToPorts = (ports, message) => {
  ports && ports.forEach(port => {
    port.postMessage(message);
  });
};
