
// Application developed in C++ with freeGLUT, Visual Studio 2022 envoronment
// Created by Octavian Balota, Geodetic Engineer and Mathematicien, PHd in Photogrammetry
// Teacher in Geodesy and Photogrammetry (University USAMV Bucharest)

#include <stdlib.h>
#include <math.h>
#include <glut.h>
#include <iostream>

using namespace std;

#ifndef PI
#define PI 3.14159265358979323846
#endif
GLenum ER;
double vv=0.0;
bool stop, rot, codepass, coderot;
bool codeLoop = 0;
double poz, lastStop, lastpoz, lastRot, rotstatus, lastincrement;
float r = 0.4, g = 0.2, b = 0.2;   // used for controling the 3D object color
int codeK = 0;               // used for controling the background color
int codeObject = 0;          // used for controling the 3D objects 
void init(void);
void KeyboardFunc(unsigned char key, int x, int y);
void MenuFunc(int value);
void IdleFunc(void);
void ReshapeFunc(int w, int h);
void DisplayFunc(void);
void CheckErrors(void);

double rad(double a)
{
    return a * PI / 180.0;
}

struct ProgramState
{
    int w;
    int h;
    GLdouble RotationX;
    GLdouble RotationY;
    double eye;
    double zscreen;
    double znear;
    double zfar;
    double RotationIncrementX;
    double RotationIncrementY;
    int solidmode;
};
struct ProgramState ps;

const double PIXELS_PER_INCH = 100.0;

void init(void)
{
    glDisable(GL_DITHER);
    glClearColor(0.0, 0.0, 0.0, 1.0);
    glShadeModel(GL_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glEnable(GL_NORMALIZE);
    glEnable(GL_CULL_FACE);
    glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);

    ps.eye = 0.80;
    ps.zscreen = 12.0;
    ps.znear = 1.0;
    ps.zfar = 25.0;
    ps.RotationY = -90.0;
    ps.RotationX = -90.0;
    ps.RotationIncrementX = 0.5;
    ps.RotationIncrementY = 0.5;
    ps.solidmode = 1;
    codepass = 0;
    coderot = 1;
    stop = 0;
    rot = 1;
    lastincrement = 0.5;
    lastRot = -90.0;
    lastStop = -90.0;
    lastpoz = 5 * sin(rad(lastRot));
}

void initColor(float r, float g, float b) // set the colors for the 3D oject
{
    GLfloat mat_ambient[] = { r, g, b,1.0 };
    GLfloat mat_diffuse[] = { 0.3,0.4,0.5,1.0 };
    GLfloat mat_specular[] = { 0.2,0.3,0.4,1.0 };
    GLfloat mat_shininess[] = { 30.0 };

    GLfloat light_position[] = { 5.0,10.0,30.0,1.0 };

    GLfloat light_ambient0[] = { 1.0,1.0,1.0,1.0 };
    GLfloat light_diffuse0[] = { 1.0,1.0,1.0,1.0 };
    GLfloat light_specular0[] = { 1.0,1.0,1.0,1.0 };

    GLfloat light_ambient1[] = { 0.0,0.0,1.0,1.0 };
    GLfloat light_diffuse1[] = { 0.0,0.0,1.0,1.0 };
    GLfloat light_specular1[] = { 0.0,0.0,1.0,1.0 };


    glMaterialfv(GL_FRONT, GL_AMBIENT, mat_ambient);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
    glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
    glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);

    glLightfv(GL_LIGHT0, GL_POSITION, light_position);
    glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient0);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse0);
    glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular0);
      
    glLightfv(GL_LIGHT1, GL_POSITION, light_position);
    glLightfv(GL_LIGHT1, GL_AMBIENT, light_ambient1);
    glLightfv(GL_LIGHT1, GL_DIFFUSE, light_diffuse1);
    glLightfv(GL_LIGHT1, GL_SPECULAR, light_specular1);
    glEnable(GL_LIGHTING);
}
void help(void) // Is writing a message help for all commands
{
    cout << endl << "    Use < and > for changing the moving speed";
    cout << endl << "    Use V and B for changing the rotation speed";
    cout << endl << "    Use N and M for changing the eye distance";
    cout << endl << "    Use SPACE bar for stop movement and continue movement";
    cout << endl << "    Use R for stop Rotation and continue rotation";
    cout << endl << "    Use K for changing background color - 7 colors preseted";
    cout << endl << "    Use Q and A, W and S, E and D for changing up and down ambient parameters" << endl;
    cout << endl << "    Use Z for reset to the default color parameters";
    cout << endl << "    Use X for reset to the default eye and speed parameters" << endl;
    cout << endl << "    Use C for checking for system errors" ;
    cout << endl << "    Use L for control the changes between the 3D objects" << endl;
    cout << endl << "    Use H for reprint this help message" << endl;
    cout << endl << "    Use I or ? for application information" << endl;
    cout << endl << "    Use ESC for exit" << endl;
}
void coutInfo(float rr, float gg, float bb) 
{
    int i;
    for (i = 0;i < 30;++i) cout << "   ";
    for (i = 0;i < 60;++i) cout << "\b\b\b";
    cout << " r = " << rr << ", g = " << gg << ", b = " << bb << "   ";

}
void KeyboardFunc(unsigned char key, int x, int y) // Control the keyboard
{
     switch (key)
    {
    case 27:  /* escape */
        exit(0);
        break;
    case 'q':
    case 'Q':
        r -= 0.05;
        if (r < 0.01) r = 0;
        coutInfo(r,g,b);
        break;
    case 'a':
    case 'A':
        r += 0.05;
        if (r > 5) r = 5;
        coutInfo(r, g, b);
        break;
    case 'w':
    case 'W':
        g += 0.05;
        if (g > 5) g = 5;
        coutInfo(r, g, b);
        break;
    case 's':
    case 'S':
        g -= 0.05;
        if (g < 0.01) g = 0;
        coutInfo(r, g, b);
        break;
    case 'e':
    case 'E':
        b += 0.05;
        if (b > 5) b = 5;
        coutInfo(r, g, b);
        break;
    case 'd':
    case 'D':
        b -= 0.05;
        if (b < 0.01) b = 0;
        coutInfo(r, g, b);
        break;
    case 'z':
        r = 0.4; g = 0.2; b = 0.2;
        coutInfo(r, g, b);
        break;
    case 'x':
        ps.eye=0.8;
        ps.RotationIncrementX = 0.5;
        ps.RotationIncrementY = 0.5;
        cout << endl << " Eye = " << ps.eye;
        break;
    case 32:
        stop = !stop;
        break;
    case 'r':
    case 'R':
        rot = !rot;
        break;
    case '.':
    case '>':
        ps.RotationIncrementY+=0.2;
        break;
    case ',':
    case '<':
        ps.RotationIncrementY -= 0.2;
        if(ps.RotationIncrementY < 0.2) ps.RotationIncrementY = 0.2;
        break;
    case 'v':
    case 'V':
        ps.RotationIncrementX -= 0.2;
        if (ps.RotationIncrementX < 0.2) ps.RotationIncrementX = 0.2;
        break;
    case 'b':
    case 'B':
        ps.RotationIncrementX += 0.2;
        break;
    case 'n':
    case 'N':
        ps.eye -= 0.05;
        if (ps.eye < 0.001) ps.eye = 0.0;
        cout << endl << " Eye = " << ps.eye;
        break;
    case 'm':
    case 'M':
        ps.eye += 0.05;
        if (ps.eye > 1.2) ps.eye = 1.2;
        cout << endl << " Eye = " << ps.eye;
        break;
    case 'h':
    case 'H':
        help();
        break;
    case 'c':
    case 'C':
        CheckErrors();
        break;
    case 'l':
    case 'L':
    {
        if (codeObject < 2) codeObject += 1; else codeObject = 0;
        if (codeObject && codeObject != ps.solidmode) ps.solidmode = codeObject;
    }
        break;
    case '?':
    case '/':
    case 'i':
    case 'I':
        MessageBoxA(NULL, (LPCSTR)"Created by Octavian Balota, August 2022, C++, freeGLUT       email: octavian.balota@tehnogis.ro",
            (LPCSTR)"Application for testing Quad Buffer facilities in OpenGL 4.6",MB_OK | MB_ICONEXCLAMATION);
        break;
    case 'k':
    case 'K':
    {
        if (codeK <= 5) codeK += 1; else codeK = 0;
        switch (codeK)
        {
        case 0: 
            glClearColor(0.0, 0.0, 0.0, 1.0);
            break;
        case 1:
            glClearColor(0.0, 0.0, 0.7, 1.0);
            break;
        case 2:
            glClearColor(0.0, 0.5, 0.5, 1.0);
            break;
        case 3:
            glClearColor(0.3, 0.1, 0.3, 1.0);
            break;
        case 4:
            glClearColor(0.1, 0.6, 0.2, 1.0);
            break;
        case 5:
            glClearColor(0.4, 0.6, 0.8, 1.0);
            break;
        case 6:
            glClearColor(1.0, 1.0, 1.0, 1.0);
            break;
        }
    }
    break;
    }
}

void CheckErrors(void)
{
    int iPF;
    HDC hdc;
    ER = glGetError();
    cout << endl;
    switch (ER)
    {
    case GL_NO_ERROR:
    {
        cout << endl << "NO ERRORS!" << endl;
        break;
    }
    case GL_INVALID_ENUM:
    {
        cout << "Invalid Value " << endl;
        break;
    }
    case GL_INVALID_OPERATION:
    {
        cout << " <<< No OpenGL QuadBuffer is supported by the system >>>" << endl;
        break;
    }
    case GL_STACK_OVERFLOW:
    {
        cout << "stack overflow" << endl;
        break;
    }
    case GL_STACK_UNDERFLOW:
    {
        cout << "stack underflow" << endl;
        break;
    }
    case GL_OUT_OF_MEMORY:
    {
        cout << "No memory" << endl;
        break;
    }
    //hdc = GetDC(hWnd);
    //iPF=DescribePixelFormat(hdc,1, sizeof (PIXELFORMATDESCRIPTOR),&pfd)
    cout << "Cod de eroare = " << ER;
    }
}

void IdleFunc(void)
{
    if(!stop) ps.RotationY += ps.RotationIncrementY; 
    if (rot) ps.RotationX += ps.RotationIncrementX;
    glutPostRedisplay();
}

void ReshapeFunc(int w, int h)
{
    glViewport(0, 0, w, h);
    ps.w = w;
    ps.h = h;
}

void DisplayFunc(void)
{
    double xfactor = 1.0, yfactor = 1.0;
    double Eye = 0.0;
    int i;
    initColor(r,g,b);
    if (ps.w < ps.h)
    {
        xfactor = 1.0;
        yfactor = ps.h / ps.w;
    }
    else if (ps.h < ps.w)
    {
        xfactor = ps.w / ps.h;
        yfactor = 1.0;
    }

    for (i = 0;i < 2;i++)
    {
        //glEnable(GL_LIGHT0+ i);
        glEnable(GL_LIGHT0);
        glClear(GL_DEPTH_BUFFER_BIT);
        if (i == 0) /* left eye - RED */
        {
            Eye = ps.eye;
            glDrawBuffer(GL_BACK_LEFT);
            glClear(GL_COLOR_BUFFER_BIT);  // clearing buffer
        }
        else /* if(i==1) right eye - GREEN */
        {
            Eye = -ps.eye;
            glDrawBuffer(GL_BACK_RIGHT);
            glClear(GL_COLOR_BUFFER_BIT); // clearing buffer
        }
        
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        glFrustum(
            (-(ps.w / (2.0 * PIXELS_PER_INCH)) + Eye) * (ps.znear / ps.zscreen) * xfactor,
            (ps.w / (2.0 * PIXELS_PER_INCH) + Eye) * (ps.znear / ps.zscreen) * xfactor,
            -(ps.h / (2.0 * PIXELS_PER_INCH)) * (ps.znear / ps.zscreen) * yfactor,
            (ps.h / (2.0 * PIXELS_PER_INCH)) * (ps.znear / ps.zscreen) * yfactor,
            ps.znear, ps.zfar);
        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        glTranslatef(Eye, 0.0, 0.0);
        glTranslated(0, 0, -ps.zscreen);
        glEnable(GL_LIGHTING);
      if (stop)
        {
            if (!codepass) {
                lastStop = ps.RotationY;
                poz = 5 * sin(rad(lastStop));
                codepass = 1;
            }
       }
       else {
            if(codepass)
            {
               ps.RotationY = lastStop;
               poz = 5 * sin(rad(ps.RotationY));
               codepass = 0;
            }
        }
      if (rot)
      {
          if (coderot) {
              ps.RotationX=lastRot;
             // poz = 5 * sin(rad(ps.RotationX));
              coderot = 0;
          }
      }
      else {
          if (!coderot)
          {
             // ps.RotationY = lastRot;
              lastRot = ps.RotationX;
              // poz = 5 * sin(rad(lastRot));
              coderot = 1;
          }
      }

              
        switch (ps.solidmode)
        {
        case 1:
        {
            if(!stop) glTranslated(0.0, 0.0, 5 * sin(rad(ps.RotationY)));
            else glTranslated(0.0, 0.0, poz);
            if(!rot) glRotated(lastRot, 0.1, 0.2, 0.0);
            else glRotated(ps.RotationX, 0.1, 0.2, 0.0);
            glPushMatrix();
            glScalef(0.5, 0.5, 0.5);
            glutSolidSphere(2.0f, 60, 60);
            glPopMatrix();
            break;
        }
        case 2:
        {
            if (!stop) glTranslated(0.0, 0.0, 5 * sin(rad(ps.RotationY)));
            else glTranslated(0.0, 0.0, poz);
            if (!rot) glRotated(lastRot, 0.1, 0.2, 0.0);
            else glRotated(ps.RotationX, 0.1, 0.2, 0.0);
            glPushMatrix();
            glutSolidCube(1.0);
            glPopMatrix();
            break;
        }
        }
        glDisable(GL_LIGHT0 + i);
    }
    glColorMask(GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
    glutSwapBuffers();
    if (!codeLoop)
    {
        CheckErrors();
        codeLoop = 1;
    }
 
        if ((ps.RotationY <= -90) || (ps.RotationY >= 270))
        {
           if(!codeObject) ps.solidmode++;
            if (ps.solidmode > 2)
            {
                ps.solidmode = 1;
            }
            ps.RotationY = -90.0;
        }
        if ((ps.RotationX <= -90) || (ps.RotationX >= 270))
        {
            ps.RotationX = -90.0;
        }
 
}
void VisibilityFunc(int vis)
{
    if (vis == GLUT_VISIBLE) {
        glutIdleFunc(IdleFunc);
    }
    else {
        glutIdleFunc(NULL);
    }
}
int main(int argc, char** argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_STEREO);
    ps.w = 512;
    ps.h = 512;
    glutInitWindowSize(ps.w, ps.h);
    glutInitWindowPosition(300, 250);
    glutCreateWindow("Quad Buffer Stereo Test Application");
    help();
    init();
    glutVisibilityFunc(VisibilityFunc);
    glutDisplayFunc(DisplayFunc);
    glutReshapeFunc(ReshapeFunc);
    glutKeyboardFunc(KeyboardFunc);
    glutMainLoop();
    return 0;
}

// Bibliography:  
// - 3D Stereo rendering using Open GL snd GLUT (Paul Bourke 2002)
// - Implementing stereoscopic 3D in your application (Samuel Gateau , Steve Nash - NVIDIA, 2010)
// - OpenGL 4.6 Quick reference card
// - RedBlue stereo test application (Walter Vanini 1998)