/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.database;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.database.DrivJDBC;
import com.mathworks.util.ClassLoaderBridge;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;

public class databaseConnect
implements AutoConvertStringToMatlabChar {
    String databaseName;
    String userName;
    String password;
    String queryStatement;
    String databaseUrl;
    String jdbcDriver;
    Connection conn;

    public databaseConnect(String string, String string2, String string3, String string4, String string5) {
        this.databaseUrl = string5;
        this.jdbcDriver = string4;
        this.databaseName = string;
        this.userName = string2;
        this.password = string3;
    }

    public databaseConnect(String string, String string2, String string3) {
        this.databaseName = string;
        this.userName = string2;
        this.password = string3;
        this.databaseUrl = "jdbc:odbc:" + this.databaseName;
    }

    public databaseConnect(String string) {
        this.jdbcDriver = string;
    }

    public databaseConnect() {
    }

    public Vector makeDatabaseConnection() {
        Vector<Object> vector = new Vector<Object>();
        String string = "";
        if (this.jdbcDriver != null) {
            try {
                Driver driver = null;
                driver = (Driver)ClassLoaderBridge.findClass((String)this.jdbcDriver).newInstance();
                DriverManager.registerDriver(new DrivJDBC(driver));
            }
            catch (Exception exception) {
                Boolean bl = new Boolean(false);
                this.conn = null;
                string = "Driver was not loaded!";
                vector.addElement(bl);
                vector.addElement(this.conn);
                vector.addElement(string);
                return vector;
            }
            try {
                if (!this.databaseUrl.endsWith(this.databaseName)) {
                    this.databaseUrl = this.databaseUrl + this.databaseName;
                }
                this.conn = DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
                Boolean bl = new Boolean(true);
                vector.addElement(bl);
                vector.addElement(this.conn);
                return vector;
            }
            catch (Exception exception) {
                Boolean bl = new Boolean(false);
                this.conn = null;
                string = "Connection failed!";
                vector.addElement(bl);
                vector.addElement(this.conn);
                vector.addElement(string);
                return vector;
            }
        }
        try {
            Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception exception) {
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            catch (Exception exception2) {
                Boolean bl = new Boolean(false);
                this.conn = null;
                string = "JDBC/ODBC driver not found or loaded!";
                vector.addElement(bl);
                vector.addElement(this.conn);
                vector.addElement(string);
                return vector;
            }
        }
        try {
            this.conn = DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
            Boolean bl = new Boolean(true);
            vector.addElement(bl);
            vector.addElement(this.conn);
        }
        catch (SQLException sQLException) {
            Boolean bl = new Boolean(false);
            this.conn = null;
            string = "Unable to connect with JDBC/ODBC bridge!";
            vector.addElement(bl);
            vector.addElement(this.conn);
            vector.addElement(string);
        }
        return vector;
    }

    public boolean validConnectionMade(Vector vector) {
        Boolean bl = (Boolean)vector.elementAt(0);
        boolean bl2 = false;
        bl2 = bl;
        return bl2;
    }

    public Connection getValidConnection(Vector vector) {
        Connection connection = (Connection)vector.elementAt(1);
        return connection;
    }

    public String getConnectionMessage(Vector vector) {
        String string = (String)vector.elementAt(2);
        return string;
    }

    public int connectionTimeOut() {
        int n;
        try {
            Class.forName(this.jdbcDriver);
            n = DriverManager.getLoginTimeout();
        }
        catch (Exception exception) {
            try {
                Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
                n = DriverManager.getLoginTimeout();
            }
            catch (Exception exception2) {
                try {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                    n = DriverManager.getLoginTimeout();
                }
                catch (Exception exception3) {
                    return -1;
                }
            }
        }
        return n;
    }

    public int connectionTimeOut(int n) {
        int n2;
        try {
            Class.forName(this.jdbcDriver);
            DriverManager.setLoginTimeout(n);
            n2 = DriverManager.getLoginTimeout();
        }
        catch (Exception exception) {
            try {
                Class.forName("com.ms.jdbc.odbc.JdbcOdbcDriver");
                DriverManager.setLoginTimeout(n);
                n2 = DriverManager.getLoginTimeout();
            }
            catch (Exception exception2) {
                try {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                    DriverManager.setLoginTimeout(n);
                    n2 = DriverManager.getLoginTimeout();
                }
                catch (Exception exception3) {
                    return -1;
                }
            }
        }
        return n2;
    }

    public String toggleAutoCommit(Connection connection) {
        boolean bl;
        String string = "";
        try {
            bl = connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            string = sQLException.getMessage();
            return string;
        }
        if (bl) {
            return "true";
        }
        return "false";
    }

    public String toggleAutoCommit(Connection connection, String string) {
        boolean bl;
        String string2 = "";
        try {
            if (string.equals("false")) {
                connection.setAutoCommit(false);
            } else {
                connection.setAutoCommit(true);
            }
            bl = connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            string2 = sQLException.getMessage();
            return string2;
        }
        if (bl) {
            return "true";
        }
        return "false";
    }

    public String getTheErrorMessage() {
        String string = "";
        if (this.jdbcDriver != null) {
            try {
                Class.forName(this.jdbcDriver);
            }
            catch (Exception exception) {
                string = "JDBC Driver Error: " + exception.getMessage() + ". Driver Not Found/Loaded.";
                return string;
            }
            try {
                this.conn = DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
            }
            catch (Exception exception) {
                string = exception.getMessage();
            }
        } else {
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
            catch (Exception exception) {
                string = exception.getMessage();
                return string;
            }
            try {
                this.conn = DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
            }
            catch (SQLException sQLException) {
                string = sQLException.getMessage();
            }
        }
        return string;
    }

    public String getTheUrl(Connection connection) {
        String string = "";
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            string = databaseMetaData.getURL();
        }
        catch (SQLException sQLException) {
            string = sQLException.getMessage();
        }
        return string;
    }

    public boolean loadDriver() {
        boolean bl = false;
        try {
            Class.forName(this.jdbcDriver);
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public String errorLoadingDriver() {
        String string = "";
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = classNotFoundException.getMessage();
        }
        return string;
    }

    public String driver() {
        return this.jdbcDriver;
    }

    public String urlStringCreated() {
        this.databaseUrl = this.databaseUrl + this.databaseName;
        return this.databaseUrl;
    }

    public String getTheNativeErrorMessage() {
        String string = "";
        try {
            Class.forName(this.jdbcDriver);
            string = "Driver loaded";
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = classNotFoundException.getMessage();
        }
        try {
            this.conn = DriverManager.getConnection(this.databaseUrl, this.userName, this.password);
        }
        catch (SQLException sQLException) {
            string = sQLException.getMessage();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        databaseConnect databaseConnect2 = new databaseConnect("oracle", "scott", "tiger", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci7:");
        Vector vector = databaseConnect2.makeDatabaseConnection();
    }
}

