/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CoordinateConversion {
    private static int toScreenCoordinates(double d, double d2, double d3, int n) {
        double d4 = (double)n - d3 * d2;
        return (int)Math.round(d * d2 + d4);
    }

    public static Point toScreenCoordinates(double d, double d2, Rectangle2D rectangle2D, Rectangle rectangle) {
        double d3 = CoordinateConversion.getScreenPerImagePixel(rectangle2D, rectangle);
        return new Point(CoordinateConversion.toScreenCoordinates(d, d3, rectangle2D.getX(), rectangle.x), CoordinateConversion.toScreenCoordinates(d2, d3, rectangle2D.getY(), rectangle.y));
    }

    public static Rectangle toScreenCoordinates(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle rectangle) {
        double d = CoordinateConversion.getScreenPerImagePixel(rectangle2D2, rectangle);
        int n = (int)Math.round(d * rectangle2D.getWidth());
        int n2 = (int)Math.round(d * rectangle2D.getHeight());
        int n3 = CoordinateConversion.toScreenCoordinates(rectangle2D.getX(), d, rectangle2D2.getX(), rectangle.x);
        int n4 = CoordinateConversion.toScreenCoordinates(rectangle2D.getY(), d, rectangle2D2.getY(), rectangle.y);
        return new Rectangle(n3, n4, n, n2);
    }

    public static double getScreenPerImagePixel(Rectangle2D rectangle2D, Rectangle rectangle) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        int n = rectangle.width;
        int n2 = rectangle.height;
        return Math.max((double)n / d, (double)n2 / d2);
    }

    private static double toImageCoordinates(int n, double d, double d2, int n2) {
        double d3 = (double)n2 - d2 * d;
        return ((double)n - d3) / d;
    }

    public static Point2D toImageCoordinates(int n, int n2, Rectangle2D rectangle2D, Rectangle rectangle) {
        double d = CoordinateConversion.getScreenPerImagePixel(rectangle2D, rectangle);
        double d2 = CoordinateConversion.toImageCoordinates(n, d, rectangle2D.getX(), rectangle.x);
        double d3 = CoordinateConversion.toImageCoordinates(n2, d, rectangle2D.getY(), rectangle.y);
        return new Point2D.Double(d2, d3);
    }

    public static Point2D toMatlabCoordinates(int n, int n2, Rectangle2D rectangle2D, Rectangle rectangle) {
        double d = CoordinateConversion.getScreenPerImagePixel(rectangle2D, rectangle);
        Point2D point2D = CoordinateConversion.toImageCoordinates(n, n2, rectangle2D, rectangle);
        double d2 = 0.5 / d;
        point2D.setLocation(point2D.getX() + d2 + 0.5, point2D.getY() + d2 + 0.5);
        return point2D;
    }
}

