/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DrawableRect {
    private static final int STROKE_THICKNESS = 1;
    private static final Stroke RECT_STROKE = new BasicStroke(1.0f);
    static final float XHAIR_LENGTH = 15.0f;
    private static final int XHAIR_MIN_RECT_SIDE = 10;
    private static final int NUM_WHITE_LINES = 4;
    private static final int NUM_BLACK_LINES = 8;
    private static Line2D[] whiteXHairLines = new Line2D[4];
    private static Line2D[] blackXHairLines = new Line2D[8];

    static void draw(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        Rectangle2D rectangle2D2 = DrawableRect.findRectInside(rectangle2D);
        graphics2D.setPaint(Color.white);
        graphics2D.setStroke(RECT_STROKE);
        graphics2D.draw(rectangle2D2);
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(RECT_STROKE);
        graphics2D.draw(DrawableRect.findRectOutside(rectangle2D2));
    }

    static void drawRectWithXHair(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        DrawableRect.draw(rectangle2D, graphics2D);
        DrawableRect.setXHairLines(DrawableRect.findRectOutside(DrawableRect.findRectInside(rectangle2D)));
        graphics2D.setPaint(Color.white);
        graphics2D.setStroke(RECT_STROKE);
        DrawableRect.drawXHairLines(graphics2D, whiteXHairLines);
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(RECT_STROKE);
        DrawableRect.drawXHairLines(graphics2D, blackXHairLines);
    }

    private static void setXHairLines(Rectangle2D rectangle2D) {
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_4 = new Point2D.Double(0.0, 0.0);
        double d = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
        double d2 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getY() + rectangle2D.getHeight();
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getX() + rectangle2D.getWidth();
        ((Point2D)double_).setLocation(d, d3);
        ((Point2D)double_2).setLocation(d, d3 - 15.0);
        DrawableRect.whiteXHairLines[0] = new Line2D.Double(double_, double_2);
        ((Point2D)double_).setLocation(d - 1.0, d3);
        ((Point2D)double_2).setLocation(d - 1.0, d3 - 15.0);
        ((Point2D)double_3).setLocation(d + 1.0, d3);
        ((Point2D)double_4).setLocation(d + 1.0, d3 - 15.0);
        DrawableRect.blackXHairLines[0] = new Line2D.Double(double_, double_2);
        DrawableRect.blackXHairLines[1] = new Line2D.Double(double_3, double_4);
        ((Point2D)double_).setLocation(d, d4);
        ((Point2D)double_2).setLocation(d, d4 + 15.0);
        DrawableRect.whiteXHairLines[1] = new Line2D.Double(double_, double_2);
        ((Point2D)double_).setLocation(d - 1.0, d4);
        ((Point2D)double_2).setLocation(d - 1.0, d4 + 15.0);
        ((Point2D)double_3).setLocation(d + 1.0, d4);
        ((Point2D)double_4).setLocation(d + 1.0, d4 + 15.0);
        DrawableRect.blackXHairLines[2] = new Line2D.Double(double_, double_2);
        DrawableRect.blackXHairLines[3] = new Line2D.Double(double_3, double_4);
        ((Point2D)double_).setLocation(d5, d2);
        ((Point2D)double_2).setLocation(d5 - 15.0, d2);
        DrawableRect.whiteXHairLines[2] = new Line2D.Double(double_, double_2);
        ((Point2D)double_).setLocation(d5, d2 - 1.0);
        ((Point2D)double_2).setLocation(d5 - 15.0, d2 - 1.0);
        ((Point2D)double_3).setLocation(d5, d2 + 1.0);
        ((Point2D)double_4).setLocation(d5 - 15.0, d2 + 1.0);
        DrawableRect.blackXHairLines[4] = new Line2D.Double(double_, double_2);
        DrawableRect.blackXHairLines[5] = new Line2D.Double(double_3, double_4);
        ((Point2D)double_).setLocation(d6, d2);
        ((Point2D)double_2).setLocation(d6 + 15.0, d2);
        DrawableRect.whiteXHairLines[3] = new Line2D.Double(double_, double_2);
        ((Point2D)double_).setLocation(d6, d2 - 1.0);
        ((Point2D)double_2).setLocation(d6 + 15.0, d2 - 1.0);
        ((Point2D)double_3).setLocation(d6, d2 + 1.0);
        ((Point2D)double_4).setLocation(d6 + 15.0, d2 + 1.0);
        DrawableRect.blackXHairLines[6] = new Line2D.Double(double_, double_2);
        DrawableRect.blackXHairLines[7] = new Line2D.Double(double_3, double_4);
    }

    private static void drawXHairLines(Graphics2D graphics2D, Line2D[] line2DArray) {
        int n = 0;
        while (n < line2DArray.length) {
            graphics2D.draw(line2DArray[n]);
            ++n;
        }
    }

    static boolean isRectTiny(Rectangle2D rectangle2D) {
        return rectangle2D.getWidth() < 10.0 && rectangle2D.getHeight() < 10.0;
    }

    private static Rectangle2D findRectInside(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - 1.0, rectangle2D.getHeight() - 1.0);
    }

    private static Rectangle2D findRectOutside(Rectangle2D rectangle2D) {
        return new Rectangle2D.Double(rectangle2D.getX() - 1.0, rectangle2D.getY() - 1.0, rectangle2D.getWidth() + 2.0, rectangle2D.getHeight() + 2.0);
    }

    static Rectangle2D findXHairBoundingBox(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = DrawableRect.findRectOutside(rectangle2D);
        return new Rectangle2D.Double(rectangle2D2.getX() - 15.0, rectangle2D2.getY() - 15.0, rectangle2D2.getWidth() + 30.0, rectangle2D2.getHeight() + 30.0);
    }
}

