/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;

public class ImformatsFileFilter
extends FileFilter {
    public static final int ACCEPT_ALL_IMFORMATS = 1000;
    private int fID;
    private static String[] sDescriptions;
    private static Vector sExtensions;
    private static int sNumFormats;

    public ImformatsFileFilter(int n) {
        this.fID = n == 1000 ? sNumFormats : n;
    }

    public static void initializeFormats(int n, String[] stringArray, Vector vector) {
        ImformatsFileFilter.setNumFormats(n);
        ImformatsFileFilter.setDescriptions(stringArray);
        ImformatsFileFilter.setExtensions(vector);
    }

    private static void setNumFormats(int n) {
        sNumFormats = n;
    }

    private static void setDescriptions(String[] stringArray) {
        sDescriptions = stringArray;
    }

    private static void setExtensions(Vector vector) {
        sExtensions = vector;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = ImformatsFileFilter.getExtension(file);
        if (string != null) {
            String[] stringArray = (String[])sExtensions.elementAt(this.fID);
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public String getDescription() {
        return sDescriptions[this.fID];
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }
}

