/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images;

import com.mathworks.toolbox.images.AbstractModeHandler;
import com.mathworks.toolbox.images.ImagePanel;
import com.mathworks.toolbox.images.ImageScrollPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class PanModeHandler
extends AbstractModeHandler {
    public PanModeHandler(ImageScrollPane imageScrollPane) {
        super(imageScrollPane);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        ImageScrollPane imageScrollPane = this.getScrollPane();
        Component component = imageScrollPane.getClient();
        if (imageScrollPane.getScreenPerImagePixel() > imageScrollPane.findFitMag()) {
            component.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            component.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D = imagePanel.toImageCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.dragImage(point2D);
    }

    private void dragImage(Point2D point2D) {
        double d;
        double d2;
        double d3;
        ImagePanel imagePanel = this.getScrollPane().getImPanel();
        Point2D point2D2 = imagePanel.getVisibleCenterInImageCoords();
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - this.getMousePress().getX(), point2D.getY() - this.getMousePress().getY());
        double d4 = point2D2.getX() - ((Point2D)double_).getX();
        double d5 = point2D2.getY() - ((Point2D)double_).getY();
        Dimension dimension = imagePanel.getOnScreenImageSize();
        Dimension dimension2 = this.getScrollPane().getViewport().getExtentSize();
        double d6 = imagePanel.getScreenPerImagePixel();
        if (dimension.width <= dimension2.width) {
            d4 = point2D2.getX();
        } else {
            d2 = d3 = (double)dimension2.width / 2.0 / d6;
            d = (double)imagePanel.getImageWidth() - d3;
            d4 = Math.min(Math.max(d4, d2), d);
        }
        if (dimension.height <= dimension2.height) {
            d5 = point2D2.getY();
        } else {
            d2 = d3 = (double)dimension2.height / 2.0 / d6;
            d = (double)imagePanel.getImageHeight() - d3;
            d5 = Math.min(Math.max(d5, d2), d);
        }
        if (d4 != point2D2.getX() || d5 != point2D2.getY()) {
            this.getScrollPane().updateView(new Point2D.Double(d4, d5));
        }
    }

    public void setCursor() {
        this.getScrollPane().getClient().setCursor(Cursor.getPredefinedCursor(13));
    }
}

