/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.toolbox.images.ContextRect;
import com.mathworks.toolbox.images.ContextRectMouseListener;
import com.mathworks.toolbox.images.ImagePanel;
import com.mathworks.toolbox.images.PlainContextRectMouseListener;
import com.mathworks.toolbox.images.cpselect.CPVector;
import com.mathworks.toolbox.images.cpselect.UpdateDetailListener;
import com.mathworks.toolbox.images.cpselect.UpdateOverviewListener;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeListener;

public class CPPanel
extends ImagePanel {
    private CPVector fPoints;
    private ContextRect fDetailRect = null;
    private UpdateDetailListener fUpdateDetailListener = null;
    private UpdateOverviewListener fUpdateOverviewListener = null;
    private ContextRectMouseListener fOverviewRectMouseListener = null;
    private ChangeListener fOverviewChangeListener = null;

    public CPPanel(CPVector cPVector) {
        this.setPoints(cPVector);
        this.setDetailRect(new ContextRect(new Point(0, 0), 0.0, 0.0, this));
        this.setOverviewRectMouseListener(new PlainContextRectMouseListener(this, this.getDetailRect()));
    }

    void setPoints(CPVector cPVector) {
        this.fPoints = cPVector;
    }

    public CPVector getPoints() {
        return this.fPoints;
    }

    private void setDetailRect(ContextRect contextRect) {
        this.fDetailRect = contextRect;
    }

    ContextRect getDetailRect() {
        return this.fDetailRect;
    }

    private void setOverviewRectMouseListener(ContextRectMouseListener contextRectMouseListener) {
        this.fOverviewRectMouseListener = contextRectMouseListener;
    }

    ContextRectMouseListener getOverviewRectMouseListener() {
        return this.fOverviewRectMouseListener;
    }

    void setUpdateDetailListener(UpdateDetailListener updateDetailListener) {
        this.fUpdateDetailListener = updateDetailListener;
    }

    void setUpdateOverviewListener(UpdateOverviewListener updateOverviewListener) {
        this.fUpdateOverviewListener = updateOverviewListener;
        this.fUpdateOverviewListener.enable();
    }

    void enableOverviewRect() {
        this.disableOverviewRect();
        this.addMouseMotionListener(this.getOverviewRectMouseListener());
        this.addMouseListener(this.getOverviewRectMouseListener());
        this.fUpdateDetailListener.enableMouseMotionListener();
        this.fUpdateDetailListener.enableOverviewChangeListener();
    }

    void disableOverviewRect() {
        this.removeMouseMotionListener(this.getOverviewRectMouseListener());
        this.removeMouseListener(this.getOverviewRectMouseListener());
        this.fUpdateDetailListener.disableMouseMotionListener();
        this.fUpdateDetailListener.disableOverviewChangeListener();
    }

    public void setDetailImageRect(Rectangle2D rectangle2D) {
        this.getDetailRect().setRect(rectangle2D);
    }

    Rectangle2D getDetailImageRect() {
        return this.getDetailRect().getFrame();
    }

    private void drawDetailRect(Graphics2D graphics2D) {
        this.getDetailRect().drawRect(graphics2D);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        this.getPoints().paintControlPoints(graphics2D, this);
        if (this.getDetailRect().getWidth() > 0.0 && this.getDetailRect().getHeight() > 0.0) {
            this.drawDetailRect(graphics2D);
        }
    }
}

