/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.toolbox.images.cpselect.CPPanel;
import com.mathworks.toolbox.images.cpselect.CPScrollPane;
import com.mathworks.toolbox.images.cpselect.CPSymbol;
import com.mathworks.toolbox.images.cpselect.ControlPointPair;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class ControlPoint
extends Point2D.Double {
    private ControlPointPair fPair = null;

    public ControlPoint(double d, double d2) {
        this.setLocation(d, d2);
    }

    public ControlPoint(Point2D point2D) {
        this.setLocation(point2D);
    }

    public static int getRadius() {
        return CPSymbol.getRadius();
    }

    public void setPair(ControlPointPair controlPointPair) {
        this.fPair = controlPointPair;
    }

    public ControlPointPair getPair() {
        return this.fPair;
    }

    public boolean hit(double d, double d2) {
        return (double)(ControlPoint.getRadius() + 1) >= this.distance(d, d2);
    }

    public void move(double d, double d2, JComponent jComponent) {
        this.x = d;
        this.y = d2;
        jComponent.repaint();
    }

    void dragPoint(double d, double d2, CPScrollPane cPScrollPane) {
        ControlPointPair controlPointPair;
        if (d >= 0.0 && d <= (double)cPScrollPane.getImPanel().getImageWidth() && d2 >= 0.0 && d2 <= (double)cPScrollPane.getImPanel().getImageHeight()) {
            this.move(d, d2, (JComponent)((Object)cPScrollPane.getImPanel()));
        }
        if ((controlPointPair = this.getPair()).isPredicted(this)) {
            controlPointPair.setPredictedPoint(null);
        }
    }

    public void paintComponent(Graphics graphics, CPPanel cPPanel) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point point = cPPanel.toScreenCoordinates(this);
        this.fPair.getCPSymbol(this).paintSymbol(graphics2D, point, this.fPair.isActive());
    }
}

