/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.images.cpselect;

import com.mathworks.toolbox.images.cpselect.CPSymbol;
import com.mathworks.toolbox.images.cpselect.ControlPoint;

public class ControlPointPair {
    public static final int ERROR = -1;
    private int fPairId;
    private boolean fActive;
    private ControlPoint fInputPoint = null;
    private ControlPoint fBasePoint = null;
    private ControlPoint fPredictedPoint = null;

    public ControlPointPair(int n) {
        this.fPairId = n;
        this.fActive = false;
        this.fInputPoint = null;
        this.fBasePoint = null;
        this.fPredictedPoint = null;
    }

    public CPSymbol getCPSymbol(ControlPoint controlPoint) {
        CPSymbol cPSymbol = null;
        cPSymbol = this.isPredicted(controlPoint) ? CPSymbol.PREDICTED : (this.isMatched(controlPoint) ? CPSymbol.MATCHED : CPSymbol.UNMATCHED);
        return cPSymbol;
    }

    public void setActive(boolean bl) {
        this.fActive = bl;
    }

    public boolean isActive() {
        return this.fActive;
    }

    public boolean isPredicted(ControlPoint controlPoint) {
        return controlPoint.equals(this.fPredictedPoint);
    }

    public boolean isMatched() {
        return this.fInputPoint != null & this.fBasePoint != null;
    }

    private boolean isMatched(ControlPoint controlPoint) {
        boolean bl = this.isInput(controlPoint) & this.fBasePoint != null ? true : this.isBase(controlPoint) & this.fInputPoint != null;
        return bl;
    }

    public boolean isInput(ControlPoint controlPoint) {
        return controlPoint == this.fInputPoint;
    }

    public boolean isBase(ControlPoint controlPoint) {
        return controlPoint == this.fBasePoint;
    }

    public boolean hasInputPoint() {
        return this.fInputPoint != null;
    }

    public boolean hasBasePoint() {
        return this.fBasePoint != null;
    }

    public boolean hasPredictedPoint() {
        return this.fPredictedPoint != null;
    }

    public int getPairId() {
        return this.fPairId;
    }

    public void setInputPoint(ControlPoint controlPoint) {
        this.fInputPoint = controlPoint;
    }

    public void setBasePoint(ControlPoint controlPoint) {
        this.fBasePoint = controlPoint;
    }

    public ControlPoint getInputPoint() {
        return this.fInputPoint;
    }

    public ControlPoint getBasePoint() {
        return this.fBasePoint;
    }

    public void setPredictedPoint(ControlPoint controlPoint) {
        this.fPredictedPoint = controlPoint;
    }

    public ControlPoint getPredictedPoint() {
        return this.fPredictedPoint;
    }
}

