//
// HG basic fur effect 
// started from Glow Effect
// multiplass "FURR"
// texture from rendermonkey
//
//	 1 base layer
//   + 15 layers of transparent	offset shape
//	 per path differences are automatically computed view CURRENTPASS variable passed by Contact




// furr texture with alpha 
texture Tex0;

// transforms
float4x4 WorldView  : WORLDVIEW; 
float4x4 Projection : PROJECTION;

// light direction (view space)
float3 LightDir < string UIDirectional = "Light Direction"; > = normalize(float3(0.0f, 0.0f, 1.0f));

// glow parameters
float4 GlowColor     = float4(0.5f, 0.5f, 0.5f, 0.2f);
float4 GlowAmbient   = float4(0.1f, 0.1f, 0.1f, 0.1f);
float  GlowThickness = 0.75f; // distance between layers in world 

float  currentpass  : CURRENTPASS; // the current effect rendering path 


struct VSTEXTURE_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR;
    float2 TexCoord : TEXCOORD0;
};

// draws unskinned object with one texture and one directional light.
VSTEXTURE_OUTPUT VSTexture
    (
    float4 Position : POSITION, 
    float3 Normal   : NORMAL,
    float2 TexCoord : TEXCOORD0
    )
{
    VSTEXTURE_OUTPUT Out = (VSTEXTURE_OUTPUT)0;


    float3 L = -LightDir;                                   // light direction (view space)

    float3 P = mul(Position, (float4x3)WorldView);        // position (view space)
    float3 N = normalize(mul(Normal, (float3x3)WorldView)); // normal (view space)
   
    Out.Position = mul(float4(P, 1), Projection);  	  // projected position
    Out.Diffuse  = 1.0f*max(1, dot(N, L));               // diffuse 
    Out.TexCoord = TexCoord;                             // texture coordinates
    
    return Out;    
}

struct VSGLOW_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR;
    float2 TexCoord : TEXCOORD0;
};

// draws a transparent hull of the unskinned object.
VSGLOW_OUTPUT VSGlow
    (
    float4 Position : POSITION, 
    float3 Normal   : NORMAL,
	float2 TexCoord : TEXCOORD0
    )
{
    VSGLOW_OUTPUT Out = (VSGLOW_OUTPUT)0;

    float displacement = GlowThickness * currentpass;

    float3 P = mul(Position, (float4x3)WorldView);        // position (view space)
    float3 N = normalize(mul(Normal, (float3x3)WorldView)); // normal (view space)
  
    P += N*displacement;

    Out.Position = mul(float4(P, 1),Projection);   // projected position

	if (false)  // glow lighting
	{
    	float3 A = float3(0, 0, 1);         // glow axis

    	float Power;

    	Power  = dot(N, A);
    	Power *= Power;
    	Power -= 1;
    	Power *= Power;     // Power = (1 - (N.A)^2)^2 [ = ((N.A)^2 - 1)^2 ]
    
    	Out.Diffuse  = GlowColor * Power ; // modulated glow color + glow ambient
	}
	else 
	if (true) { // simple lighting 
    	float3 L = -LightDir;                                   // light direction (view space)
		Out.Diffuse  =  GlowColor*max(0, dot(N, L)) ;    // diffuse 
	}	
	else {
		// no lighting 
		Out.Diffuse =  GlowColor;
	}

    Out.TexCoord = 1.0f*TexCoord;                   // texture coordinates
	// some tweaks :
    Out.TexCoord.x += 0.01 * currentpass / 50.0;
	Out.Diffuse.b *= 1.0;
	Out.Diffuse.w *=  1.0 ;
   
    return Out;    
}



technique TGlowAndTexture
{

    pass PTexture
    {   
        // single texture/one directional light shader
        VertexShader = compile vs_1_1 VSTexture();
        PixelShader  = NULL;
        
        // texture
        Texture[0] = (Tex0);

        // sampler states
        MinFilter[0] = POINT; // LINEAR
        MagFilter[0] = LINEAR;
        MipFilter[0] = NONE; // LINEAR

        // set up texture stage states for single texture modulated by diffuse 
		AlphaBlendEnable = TRUE; //fait disparaitre la map de la fenetre
        ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = CURRENT;
        AlphaOp[0]   = DISABLE;

        ColorOp[1]   = DISABLE;
        AlphaOp[1]   = DISABLE;
        
    }

    pass PGlow0
    {   
        // glow shader
        VertexShader = compile vs_1_1 VSGlow();
        PixelShader  = NULL;
        
        Texture[0] = (Tex0);

        // enable alpha blending
        AlphaBlendEnable = TRUE;
        SrcBlend         = SRCALPHA;//INVSRCALPHA;// ONE;     
        DestBlend        = ONE; // SRCALPHA;
								  
        // set up texture stage
        ColorOp[0]   = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = CURRENT;

        AlphaOp[0]   = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = CURRENT;
		
		ZWriteEnable = FALSE; // no need to update z-buffer
		AlphaTestEnable = TRUE; // can skip transparent pixels
    }
	// many more passes , re-use settings (but need to set shader, FX- BUG ?)
    pass PGlow1 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow2 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow3 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow4 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow5 { VertexShader = compile vs_1_1 VSGlow();}
	   pass PGlow6 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow7 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow8 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow9 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow10 { VertexShader = compile vs_1_1 VSGlow();}
  
	    pass PGlow11 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow12 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow13 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow14 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow15 { VertexShader = compile vs_1_1 VSGlow();}
	pass PGlow16 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow17 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow18 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow19 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow20 { VertexShader = compile vs_1_1 VSGlow();}

	pass PGlow21 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow22 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow23 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow24 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow25 { VertexShader = compile vs_1_1 VSGlow();}
	pass PGlow26 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow27 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow28 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow29 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow30 { VertexShader = compile vs_1_1 VSGlow();}

    pass PGlow31 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow32 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow33 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow34 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow35 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow36 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow37 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow38 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow39 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow40 { VertexShader = compile vs_1_1 VSGlow();}

	pass PGlow41 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow42 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow43 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow44 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow45 { VertexShader = compile vs_1_1 VSGlow();}
	pass PGlow46 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow47 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow48 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow49 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow50 { VertexShader = compile vs_1_1 VSGlow();}

  	pass PGlow51 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow52 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow53 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow54 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow55 { VertexShader = compile vs_1_1 VSGlow();}
	pass PGlow56 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow57 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow58 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow59 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow60 { VertexShader = compile vs_1_1 VSGlow();}

	pass PGlow61 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow62 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow63 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow64 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow65 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow66 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow67 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow68 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow69 { VertexShader = compile vs_1_1 VSGlow();}
    pass PGlow70 { VertexShader = compile vs_1_1 VSGlow();}


}

/*
technique TGlowOnly
{
    pass PGlow
    {   
        // glow shader
        VertexShader = compile vs_1_1 VSGlow();
        PixelShader  = NULL;
        
        // no texture
        Texture[0] = NULL;

        // enable alpha blending
        AlphaBlendEnable = TRUE;
        SrcBlend         = ONE;
        DestBlend        = ONE;

        // set up texture stage states to use the diffuse color
        ColorOp[0]   = SELECTARG2;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0]   = SELECTARG2;
        AlphaArg2[0] = DIFFUSE;

        ColorOp[1]   = DISABLE;
        AlphaOp[1]   = DISABLE;
   }
}
*/
