USE ecad_guid_info;

-- guid info for: view depth material
DROP TABLE IF EXISTS ecad_guid_info_depthmat;
CREATE TABLE ecad_guid_info_depthmat (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
    username varchar(255) DEFAULT NULL,
    mode INT DEFAULT NULL,    
    add_info VARCHAR(255) DEFAULT NULL,	-- e.g. for any logical grouping
    modify_datetime datetime DEFAULT NULL,
    de VARCHAR(160) DEFAULT NULL,
    cz VARCHAR(160) DEFAULT NULL,
    en VARCHAR(160) DEFAULT NULL,
    es VARCHAR(160) DEFAULT NULL,
    fr VARCHAR(160) DEFAULT NULL,
    gr VARCHAR(160) DEFAULT NULL,
    it VARCHAR(160) DEFAULT NULL,
    ne VARCHAR(160) DEFAULT NULL,
    pl VARCHAR(160) DEFAULT NULL,
    ru VARCHAR(160) DEFAULT NULL,
    sl VARCHAR(160) DEFAULT NULL,
    user_default_lang VARCHAR(8) DEFAULT NULL,	-- e.g. 'de_at', language and region, use within alias and/or language columns
    aliases VARCHAR(2047) DEFAULT NULL,	        -- e.g. 'de_de=Alias1;;de_ch=Alias2;;fr_ch=Alias3', optional dynamic alias list for any region differences
    PRIMARY KEY (guid)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70AC921A-8552-4B95-8770-92812B0516D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdeckprofil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6F80ED60-7902-443A-8904-8E9744E9D378}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdichtungsbeschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D511756B-8654-4B0A-809E-AE11FC4C3D1F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdichtungsbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31D178A0-8F81-4915-A7BE-3F1F7B7432E2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdichtungsfolie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{32B84027-B581-4B0A-8172-CBD0C2CD3693}', 'global', '255', 'material', '2024-04-22 08:00:00', 'abgerieben');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6EBDBBC-AAB8-4AD5-84D7-196C77C3C842}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abgesperrtes Parkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65567C9C-2A60-466B-9B57-6FCB541CFB4D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abhänger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abhängung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A120080-40E6-49C1-A06F-D07FA284CFDC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8B09CF88-A66F-4406-8E9B-F08ECC953D44}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb / Renovation Maler');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D24CC6C9-1DB7-4A87-8B68-8FE2647178D3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb gestr.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9D420AD-CAA9-4D82-B011-F991BD336759}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{196317D5-6E03-48F9-B155-EB555C2DC71B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18B860FF-25AC-4EE4-A76B-0D3CC42CDD38}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb neu gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9B294F2F-9B9C-4E50-A0D8-BDA367BC5079}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{28944F81-E75B-4E6E-A481-74AF79B5BCD6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E973045-2110-452A-8C5F-8B6BE958E57D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{75BD6374-85B8-4DD7-9495-CB4AEFF3DC40}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abrieb-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A28121FE-0F01-42F8-9CD1-9C70F287F9A0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Absperrparkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C61D7015-1F40-4E23-AFAE-783508C75427}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45598954-1C67-4A84-9F2B-90DFE43FE043}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem / 120');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7F9C0D9C-0CBA-4FC8-BBBB-4ED5272A4D5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem-Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{13AB4089-6B23-4B7F-8CC1-A4E733CABF3E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem-Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31ADED99-69B0-4363-9DAC-376B6B42B162}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC B H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D8AE086E-2D1B-4799-8830-A2B6B84ED48A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC B S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F6E960B-173E-4722-A96F-C657EC3A8DC8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{342FB140-311D-47B0-8DB3-46CC2402CEDD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14D2B822-00EE-4E96-BB40-7D4EB232C771}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60BA90C9-D251-4CA4-9EF8-E3D2FDF20396}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC N');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A2FC678-A6A9-48E6-83D6-C70E3EE2DBA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58B89DE7-0938-4A54-9FF8-93E073576FD8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC T');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7AF0155F-EF01-4193-B6F7-91F6626B820D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC T H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{608A572E-3BB7-4C78-AAA1-1E04ED34C7A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC T L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63F7AF86-7068-422C-A6DB-0553BB041866}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AC T S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2CE4759C-C91B-4247-B974-B4855D66FDED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Acryldecklack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14A560E4-27C0-4520-A4CF-CAF533181827}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Acryllasur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{50592DD2-C882-4AD0-A64E-45E07B1CFEEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Acrylparkettlack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{80A88E58-7541-48FE-90CB-2FD040D516C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35A9F886-9B96-4FFF-91B6-2C26104B6551}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD Mineralfaser');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{69032C3F-134D-4B1E-8B84-27819EEC0A9A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD Mineralwollplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{320464DE-97CE-414C-9576-8EB44C7FD6AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD Mineralwollplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0A6B0DAA-1A45-445B-8509-25798C91978E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD PIR');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F0B11D1D-9657-4414-B92A-82BE0B050B9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD PUR');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4432B74C-2161-4553-AA59-2F80192CB8B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'AD XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{383EBA89-0ABD-48ED-82B8-75E30DA7910F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustik-Deckenpaneele');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A01B28E9-53BF-4483-8991-ED0FFE54B0E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustik-Doppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{30ED3D25-7F93-4BB6-8B30-577F1FF97010}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustik-Hinterlage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D463032C-F3B8-4CAD-880F-E36EE8881DAC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustik-Mineralfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{590AD895-8DE2-489A-8798-730C0787AB3F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EBE4677A-9016-4CB4-A34F-49E31E3D7FBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikdeckenplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3D753236-6EC6-49FD-A171-9BC0754A65B8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikdeckenplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0865A54A-C9C9-4E59-87B9-3B2628D53B13}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikdoppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ECA8484E-3F15-43DE-BD11-A29FED68500C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{490EB12E-B1F0-4FB8-9AD4-8BA971E0DF86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikhinterlage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FE06406D-E0EC-4FAA-A979-691FDA8E1DBE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BCFD3E2C-B50A-4CC0-B201-2E2084CF0A2D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B9613779-1B9B-49A6-9756-6E6644705862}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81AF0F83-0108-4244-8FCA-1D33F93B24E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustiktäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67A5B4A2-9918-456F-B5F0-7376A4A762ED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alba');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1DED524F-0B26-4D1B-A75D-2D0908FEF033}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alba hydro');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73D82317-A75D-4EE6-84A3-6AA1B75C865A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Albaphon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE45BDD7-8D5C-4391-890B-AC2196A219E3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Albatherm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9066742-AFD2-4130-858E-B2FEC02E13E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alkydharzfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B079AB23-6F0B-4507-A0FE-076730771D41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alkydharzlack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ACE31795-E491-4D34-8921-31B0A7DB5A60}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Bekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7929F923-53D3-4815-818D-E159C87C1E66}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Bekleidung Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{426C148E-9FD2-4C82-8158-446722ABA8AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Bekleidung Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29413B0F-DA84-4FE8-9E3E-05A653EEE897}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Konstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{039BAAEF-E26E-4FB0-B04F-23855F302759}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Konstruktion Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0552941A-D28A-4041-B38A-088F98BC8A1B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Konstruktion Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5023077A-8154-4385-B789-5A0CCCC1B3D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Unterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F33AE1DA-04E4-413A-B1EF-9C99A5686825}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Unterkonstruktion Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{004DC850-8457-43ED-956B-A4A82F7ECAE6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Allgemein, Unterkonstruktion Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{775518E7-C636-4C24-AAB3-8F8EFD16FFA5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{90902E28-AA0B-4BF8-B426-80BB428B9034}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alu-Paneele');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FB5FDB3D-6BD6-453E-B391-56846FDA8381}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alu-Paneelen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F7160EC4-DF42-42D6-AA37-8D953E8386AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Alublech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{230F3439-05DF-4317-BBCE-DAA3BEDB7038}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA4790DD-4085-4C5E-A54F-68C60A954D77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anhydritfliessmörtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{82FAB99F-2B3E-4447-A8F4-A0C1B156C612}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anhydritmörtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F1940FC6-EC8B-4A22-B1B1-C170B36E9848}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF3FDC30-FE4A-4240-A3D8-0CED58E4C68D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD06F747-DAFE-4C19-A627-FA11ACB7B4C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E2D3FCB1-9C3D-42AD-B4DB-EFCD98A78474}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich roh');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B0473DD-4B0C-40F2-9161-138611D38B81}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD11FD53-C2C6-45FC-932E-2F5E86F34617}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{99B49391-9CF5-4206-9635-ABA2605A827A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A238640E-6C4E-4AC5-828B-F9A37AD05593}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Asphalt / 120');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0EABD763-E8B8-4D7C-AB13-FE2AB5053A48}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Auflager');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7BA5787-D74F-4FB2-ACC4-DA0F9BE9F610}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ausbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3BA866E4-7100-4C8C-91F4-259B920D57A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ausbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7C890C61-09E1-4F47-BE42-BBB2C887CC7F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussendämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31A8982B-F401-4340-AA2E-98ECE2AF4CCC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussendämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9583EF44-F77E-45CC-A786-2DB3DA374F65}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussendämmung / 760');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{86DA5A97-5BE3-44AE-845D-CF1CA195EFE1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussenisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E6CB485-781E-44D3-AA54-0F153FA075E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussenputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EC943ED-C356-4D99-BE33-1B086A82D021}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussenputz-hinterlüftet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8102E3B2-6D9D-4987-AFA7-BCBC53EC30B5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'B-Inside');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B421925E-03C4-4283-95D6-A98FD9330FAD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'B-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{80490C25-7C08-4D14-AAEE-552ACC44E284}', 'global', '255', 'material', '2024-04-22 08:00:00', 'B.Mant.ST');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3CC5AF81-026E-4E67-B741-38F0562E407B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'B.Schalst.Mwk.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DEFF40D1-0075-4E88-9718-547D4C164375}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3587B67-F089-4F32-99BA-4408E95B4A67}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein / 630');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F78B960A-6BE9-43C6-BD86-3C3AB0606140}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein / 720');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{489B528C-580C-4B98-A32F-354D0BC7F219}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6AD49B72-66F2-4F45-BB38-3B3F53EF8F36}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein MB bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B76385F9-27A8-4E9D-84C2-CE8CA169A4EA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein MB nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{34E6BB5A-1E90-4A86-9C9D-29302FD5582C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C72BAA54-0FEC-490F-8E85-66F074E163A0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7576E11-4A1F-4430-9BB4-7D61CB17161B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein-Fertigdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C2EAA1D9-F8A6-437A-94DA-5FF88226B165}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein-Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{78CE591B-D023-4164-AFBE-1A1B342E8FBA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein-Wandplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9D57AEFE-A5C9-4B23-AF72-98F185D75102}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein, Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1B4F59B3-EE64-420D-BECA-4AE977100EA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein, Sichtmauerwerk / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A011D29-D7C4-442B-B9D8-899E8700CB69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backsteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{891BAAF1-FE3C-4C48-9D5A-E445301AB46B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backsteinfertigdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5DFCC6A-2B0A-44D0-918A-D09CD6412335}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Balken-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0ED14911-C57E-40DF-A524-9CBEF1EE1E0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7D50FC3B-219A-4947-8148-C9614425FA25}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{61C5F456-03F6-46AA-B8F4-4A7C40513933}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Begrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E7E8E6DA-D5E6-4F98-9263-AD0329085231}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beize');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{311D06DB-9798-4809-9AFB-E9D816720563}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{66E20559-6C13-4B44-BEF8-1465FE22536A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung-Verschiedene-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{043DAEF4-8741-480E-BBA0-968BAC87A09F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Aussenwand / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F425A564-1006-41D2-AA52-B91EF8079E72}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Aussenwand / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4F01041D-C288-42F6-80B0-EE19D10B4B77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Decke oben / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2D02FAA4-47D4-4788-A38E-6D4D6EBA626F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Decke unten / 330');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3CE60949-FF81-4246-B8AC-B84A71438938}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Innenwand / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B54FC8B8-3122-4891-BC30-A55CC903A579}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung, Metall / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BA520875-BEA2-40BF-B366-8227B3A745CF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Belag, Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CEE0A9A2-9DCB-44A0-A083-8A2E7AC5652D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Belag, Bodenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDCB4127-7D2F-4647-B3D4-459A5887BB78}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Belag, Kies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3FFE6AC-754D-47F0-8595-4837FA34C995}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Belag, Pflaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DBAA3F05-2D98-45B9-AA43-D4DD49A8F47B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bepflanzung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E11C5196-E554-4409-80B5-B3870914E518}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bepflanzungsfläche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3E4DA0D5-7F5B-4F07-B40C-622D488AD094}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8C63912-956F-4F6B-9D49-5BD2B0A6BF27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0169DCE8-D84F-42F4-B7A5-4A48A22E8328}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung-Verschiedene-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EF877A9C-D56B-462A-8839-686A996F88C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung, Aussenwand / 520');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7FD3A3CD-6A15-40AD-B618-5255CDCFF2E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung, Aussenwand / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0888A360-C29A-4373-828E-DC32831A3CBD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung, Innenwand / 500');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E460374-53FF-447C-B61D-53FEFF243104}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Besenstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{32490CA6-28AC-4AC4-8226-7B21497011DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton - Estrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25512A20-A9D6-4B48-966E-9C044245B7A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton - Ortbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{96684CBE-84F0-4F79-8553-08754A35B7BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton - unbewehrt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7B433578-9E1A-4EB8-A205-E1DFF2257147}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{72B7C6B9-163B-43D6-A0A5-C3E2A1735C94}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C100/115');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E75B4BB8-BDBF-4F41-B6AC-F0D07D05C690}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C12/15');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D0D6BB45-AC9A-45A8-9187-A09DEE2C61BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C16/20');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC18A93C-A165-4DD5-97F6-6C905773DB8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C20/25');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7905A39F-DE8B-42C7-9513-719D2F56BE61}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C25/30');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{51DEE2CD-3282-4250-B2EA-12E7B9E5F71F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C30/37');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DB24ED80-E7E0-4605-B355-94BBA69A0D80}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C35/45');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0E3E86EC-B23F-4FDE-BA36-440AE9E10A9D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C40/50');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4844FF4D-17D2-4FB6-8195-784EF9AAE1B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C45/55');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9AE4552F-F747-43A0-B9DB-0D8B8C5F08DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C50/60');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CCA8C06E-4DC1-4AD3-8748-5EBF0F19E527}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C55/67');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A3D6102-7A38-4C3E-B3E4-19F2C234F2B0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C60/75');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B29E6C2-F65B-48C6-8EE3-946FBE59EE92}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C70/85');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A73400C2-DB7B-4542-8D3E-8AC7312B3755}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C8/10');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{42D71C90-E15D-49D1-AADA-FFBF5F42FE16}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C80/95');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7112CEB4-C1BC-4799-A545-4F93ED55F96C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton C90/105');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D824B8A-94D4-483C-B636-87543EFB3B00}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton roh');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FDF295C2-C6D9-492D-A127-EABDAAC68A40}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{04B5CA9B-70CB-4AF2-8178-C543C797D573}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Sichtbeton, hellgrau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{666EC72F-ADE7-4E0C-B015-45E1CF708872}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Vorfabriziert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{57F8DD2C-6797-40AF-9F5A-2D1F298D73C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton wasserdicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_Estrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_LB_WD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_STB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C82E8085-1A98-460E-A0C8-AAE45B8337C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC13C0AE-807A-4D55-989A-D21BF42B57DD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Fertigelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9ADA293B-5021-4CFE-95FC-C83DFF8B60A1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Flachziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0CC48003-6EAB-4BC6-B900-5BF2C3254283}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-HBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C72FDA64-F02F-478F-A446-407352E5409D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Hohlblock');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4E1726C-2089-4DE7-9183-A90C1905A48F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Mantelsteinen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E5136CB-AE15-4FCF-846E-F463DD53E6BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Pfannenziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D08B7D10-1E89-45A6-BC5E-AC01EA55DC2A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Pflasterstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5116EDD-1677-44DB-AC88-D0AFEE24DC46}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Schalungssteinen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D0BCD64-D32C-4E4B-BBBB-DAA04D4468C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7ED3DF3-8090-42FF-A531-EE320746C1CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Sickerleitung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA5806FC-7194-4C3E-9CD4-0AC5D23F5025}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton-Wandplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEA330B3-DFBA-4CF7-9F57-2564A749C5A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, bewehrt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31536532-D74B-424C-B23B-DC285FB99D77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2714EED5-A9FA-4568-ACD7-804820114566}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Bodenplatte / 780');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27ED91D2-3858-4318-8FD1-23FAA65458E4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Erdbebenscheibe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6CDABDA5-DC41-4EBC-82EB-59DA88A49DFF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Erdbebenscheibe / 795');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{95ECA58F-C526-444F-BB5F-D7CFA271ED59}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Estrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED842117-EAE0-40CB-8C6A-719BDDEA8E41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Magerbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{213D5EEA-2361-4CD5-9094-083427438084}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Magerbeton / 740');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{44F43A3E-F013-49AB-BF66-F3ADD6647653}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Sichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC136D2E-4DB8-4B13-8F6C-71937FF8AA49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Sichtbeton / 780');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B2489F0-207F-4AE9-921A-DA5E435E4C24}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Stahlbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D51F881-557C-40E4-BECC-B6ADFD2A965C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, Stahlbeton / 750');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDF83941-2C6D-4CED-AF3B-C7C6FEBCF461}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, unbewehrt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9A135002-3986-495B-B74F-1FEA7E963E04}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton, unbewehrt / 730');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B0576EC-E063-420F-A3B2-70B4635A590B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F1AD63C-540C-43DF-B1B3-BAEB04C5B54D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{442A56BC-F7F0-49BB-A2A4-20506CC0295A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonhohlblockstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8BD95407-46FE-461B-B47B-6ABDFB0E65AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonhohlstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EECFC826-B81B-46AD-B652-C5F0E196D30B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonoberflächenbehandlung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41AABD05-7051-4CE4-897E-AB730417F1AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonpflasterstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EF4C714-1A45-441D-950D-83DC9E080806}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{890F2D6A-4BF3-42DB-BF4B-C61BFDD328EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonplatten / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D50DF60F-FB5D-468D-AEC4-4696A2CF5C90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonplatten / 405');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7FDB3206-6600-44FF-9B32-3795349E9476}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{82DAC5A8-15BA-48D7-8451-5CF69798E00F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonrohr B-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDA2C2D8-3DA6-4D3F-9D6C-FA41E8EE2C4C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{49FA248C-95A2-4B3B-AE5E-39F12F45E307}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonrohre B-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{75F62622-400E-493A-A5DE-0C806490A3C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonsandwich-Wandplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4736E05A-567B-43E9-AFCA-09A0EDF6AF7B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonsickerrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{234501B8-2602-4055-B22B-A3E025F7C910}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonsickerrohr B-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{285CA767-1746-4024-B7F6-52598369D214}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonsickerrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18F73C89-3BA4-43B6-8E9A-696EB61AF947}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonsickerrohre B-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{654B2532-349B-4617-9BCA-94F05447CA05}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DD5AC7A7-168C-4409-98DB-C80D17486222}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonverbund');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D54B669E-FC58-465A-A6C3-A4058B0AAD13}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonverbundstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DAC05403-DD8C-4F82-B45E-D6DFED9F11C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonvollstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2D5462F4-2458-4E62-A5B2-13F950DC34E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonwerkstein Kunststein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C9FEDF3A-F477-4A40-B42B-BEB8F82824D3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD332A8C-CDED-4C4B-908C-76AE3BB82B20}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bewegliche Trennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{606F5259-4C7A-4101-B84B-3DCCF865DC3F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Binderschicht AC B H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5D4BB2B-29DC-47AC-918B-981C46DBD9CA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Binderschicht AC B S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D06A0200-A87E-422E-B9E8-7D33C2F7E1AC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Binderschichten AC B S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{149F9FD9-FF02-4F59-AFAB-AB7EB31AECE8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D67DAC3E-679A-4319-BA5F-F8A10C52242A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumen-Dichtungsbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2F3245F0-9F80-4F63-B8F8-939CBF02D9AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumenbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD8F9ABD-6C20-4FC8-87B6-6FA2AEC5CD8D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumenbahnen 2-lagig');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{724F1669-609B-4725-9063-F579F059B791}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumenbahnen 3-lagig');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F38A674E-2E3B-47A1-98FB-3393BDF480D8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bitumenbeschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F49F6B49-C534-47DC-98A2-187FF0F4A76F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blechverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7BADAA3-4258-4567-B03A-B9D1C67DB67F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blindboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4E63FEA7-D608-4259-9F6E-042A364CB047}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blindboden / 420');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6F06C7AE-52C6-4B3B-944D-2ABFC8B4C2F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blockwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93FA25D7-6FAB-4620-90DE-6279C096105C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blockziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9EEB9A23-C474-4CFC-98E5-688516AC6288}', 'global', '255', 'material', '2024-04-22 08:00:00', 'BLZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D29D7B7-892D-48DB-882A-318B52EAE3A6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'bn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{42C31E28-243D-42CB-8E84-A297D41932BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'bns');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{24FDB761-489D-4279-9D9B-EB95068A6357}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenaufbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2DEA0182-5EBF-43AF-BB50-4806873F94B7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1EB1AF79-9945-41A0-A39C-EBBD8B0B5D33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag / 200');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56EA6A9D-388F-4F16-A172-45EE3958460F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag / 405');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8C14E768-9CDA-411A-83E3-609FC9DCE60C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FAACA8D-E075-465E-8DD2-14DF62F465C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodendaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{143045E7-6490-44C7-99F6-3F6280474C8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D836DB2C-AB88-4479-8D5C-4F52B6CE3BAE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7C9B6B0D-2A57-4740-B050-17F66B8A9854}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenlager');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2CBC45AF-CF3B-4760-B56C-A23423E7F326}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{531C89B1-2E1A-437A-9C2C-9A1ADCAF1136}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bretter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F9509E1-342B-4E2C-991F-138A1751767C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bretterstapel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F07E9525-3ECF-4855-B306-9D80703A01F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bretterstapeln');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F50131A0-97A2-472A-917B-659C84E9168C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtholz / 750');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3B905648-7F51-4B6F-A1A4-E30EC5040A62}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtholz / 810');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC18F38F-9966-43A3-80FE-4DA04D00DA57}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtholz2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A611DAD1-6EF3-4EF7-AAA9-7A0941519333}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtsperrholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D85D5B87-B70B-4011-9EF0-F30D7EB69D86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtsperrholz2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtträger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB71F999-849F-43C8-A8B0-7032471935D8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettsperrholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{266D303B-760B-49AA-8905-47926869B1F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettsperrholz-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{69BF17B0-992A-4EEE-9884-A99358695491}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstapel-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA039E61-8BF8-4CBD-8070-FC8402A2A4D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstapel-Wand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{603CC39B-5F83-4205-BDEE-1FB5B0F58B0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstapel-Wandelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{783CCD83-C913-45FE-911F-8278802555A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstapelelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C57FC432-C029-4656-8FF7-4A6EE9797571}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstapeln');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4754FA40-A345-4C46-ABDC-4888328E92F1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettstappeldecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{715F9799-A082-4D5F-A52F-CA85BDD9C6DB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'BSH');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4C0792A7-A0E6-456C-AFB5-650E5BB30F29}', 'global', '255', 'material', '2024-04-22 08:00:00', 'C-Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18AB325C-4270-4E70-ABDD-1B35F677A1DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calciumsulfat-Fliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60454BC5-FFFB-45EB-9490-F30B302AA734}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calciumsulfatestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{928F0623-8D15-4031-8955-2C28F3792AC0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calciumsulfatestrich CA');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D9D6119-FB49-4B79-9191-BE2B4E9BAD8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calicot');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{857BCEA0-E46C-4E17-99EB-9DEAD7C47253}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calmo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD800E23-71DB-4CBA-85BA-86B6530430AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calziumsulfat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B9D3295-C3EA-493B-B84E-0DA415005C7A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calziumsulfat-Platte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{77ADE360-F3A8-42F0-AFB9-A7D8934B4A16}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calziumsulfat-Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D73F2EE-59E2-496A-8ACE-C23DC481EEB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calziumsulfatplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A1E76ED2-72A4-4FAA-BAD4-346C4AE9318C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Calziumsulfatplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6F45D49F-5C51-4E07-9A1F-2FEDC86DC502}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Backstein MNSC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45A94D9E-CFE4-4858-AC79-9B18FADFD9A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Backstein verputzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25B1FD42-916B-4B11-B31A-EEB2F2C2E026}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Beton Magerbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE540EAA-97D3-4E0B-A0CC-A6C8948F0A66}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Beton verputzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3F86CCE1-B350-476C-B80F-44E635AE8607}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Betonwerkstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{91FC6476-4F5A-417D-9FEC-75A2003AED64}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FDED4253-824B-4E21-8D7E-D1BB81C7969F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Erdbebenscheibe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{665F4E56-7CF9-45B6-8212-563AD483763F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Feuerbeständige Ziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{42CB72D0-1C4E-4E96-806F-C6EEDEA81610}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Feuerfeste Steine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8BFA00AD-31F2-49FA-926C-3215F9FD6CEA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Gips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FBA64ABA-CF74-47BF-BDA9-E01278B11EF5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Holz_Sperrholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1609D04-2E4C-48E6-9E5A-4470DB78C38D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Holzwerkstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB85CD87-AC9E-404C-851E-B465E8F75E18}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Innenputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45F336A5-4A59-4F2C-8C3B-55FB0903CED9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Kalksandstein verputzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D18FF1A-BF91-443C-9290-1B70A6577A04}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Sichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{229CA218-F0C1-4A31-9B8A-090B9C5CB84F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Sichtziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8CF3791C-9E5D-4119-B4B3-15A77D29277D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E5BDB5E-AD24-4970-B259-306164C2FD17}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Trittschalldämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD33F420-1BBA-4014-B7C8-BC5C7722F725}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Wärmedämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6EF4AABB-BEA0-476B-8756-DF9BD058A7C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'CH_Ziegel verputzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0759AA9F-D741-432B-BF9E-4856FDB1D536}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Chamotte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6BEDD69-7D88-41BD-A575-A3B737CA2509}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Chromnickelstahlblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4AF082B1-EA21-4E72-97D4-FE14099F1906}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Chromstahlblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A4AAC9F4-2BF0-4DB5-94D7-CD4F024A30AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Cupolux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E1F01C0-6FA1-4660-8A2A-A7EC37EF3BD5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Blechdeckung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FB7625D8-7C58-4EB7-BEFD-68BC72F76EBD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Holzverschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDA51DAA-0F91-48AF-8367-9F0BA90B3867}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Latten/Verkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6B2907C-4954-47CB-A74F-E8CE644DF5B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Titanzink');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{843FA539-59E0-40FC-98E0-E430E3A7CDD1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Zementfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DCD2B981-33A6-402F-A469-9BCEFFAAF4F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dach - Ziegeldeckung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{82D09EA7-2C80-455F-BCCC-FE5C06E6D33A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbegrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{46926B70-61C7-4A0E-8760-4AD3317D5C52}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbegrünung / 100');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6032F2EF-CFEE-4A74-BCE8-D50296D080B7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A8684EC4-F543-43D6-B1D0-29EDE35C91ED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbekleidung / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{356FADF1-2C61-4BD4-B30C-7AA2A059DC31}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbekleidung-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{74404702-95B0-4636-B5CC-3A436D650A79}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachboden-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FAA0426D-B212-4751-824F-06ED172F2178}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbodenelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C332A67-84A0-4577-9D2F-B27B0AE6D93E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachdeckung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5F11D03-D7C1-4081-9E29-35B98053C9F2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachflächenfenster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9594308C-51E7-4C80-BE5F-40BED09A96EA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachlatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED5C7E42-DD3C-42C9-96C8-4F9D3AD8ECC8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachlatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7861717E-13DA-4305-8DBB-A63E5ADB6055}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D27A4338-5DEE-41E7-A252-19C5DDBA8D1F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachlattung / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A2F862D8-81A7-41C2-B57D-2BC6CE01F3AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachpappe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7B1100B8-85A7-4ECD-A74E-EF81F44F0FEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EC8F84F0-286B-4A91-8785-7623610AA18E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachuntersicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F4FB539B-D1CE-4618-8AD9-411C1BDF0230}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachuntersicht-Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB72DC65-B695-426A-919E-0DDC4A0F5DFB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachziegel / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6892A4DA-A181-418F-9324-D67A1F9EC2D0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmflocken');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7EACB81B-37B1-4C03-952F-8530B601694C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DD04E4FE-27C1-46D5-9C80-F289BB7C031A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D52B538A-B0C2-495A-A100-57D28D357CB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB87DC25-01A6-4DEF-8592-0CD2A3ED5783}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67AE0FBE-5442-42A9-8661-855B5AB09D98}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung Perimeter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DEC69D2D-F701-4FEF-8483-291298DC4C5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung Staender');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8ED7AAAC-500A-495C-B261-84D71F7F7F27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{545275AF-3D74-4836-9173-824D57ADB3E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung Trockenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D63E97C0-7F14-48E0-AB10-998638C713C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8208CDB1-951C-4721-87AD-8619194DD0E4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Balken');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B4D93FD8-0C28-4CB7-9C7E-DA5A5D32F197}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{50479C61-19D0-460C-9DA1-4860F1C4EA3D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Decke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D020B4EB-3513-4827-98F2-77F5C3FC5B61}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Fassadenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E8C7F8CD-467F-41AD-BB17-E0644F3F88D0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Flachdach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{51B07A89-0AEF-47D8-9ECA-AA9FBD2FB4AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Hohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{596CACF0-C25F-494E-8DA4-A68817B861A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Holzstaender');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A8D47A4-DC47-4D74-B523-7875E76C48D8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Holzwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D0A4F254-097D-4892-9C2D-EA2998552A08}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Lattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{22A45AD3-EB48-4830-9144-4005C410222F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Perimeter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DEBD2865-6E88-409D-8D31-BD6D538774CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Staender');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C78AAF8E-C25C-4A22-9EF5-32992BF698EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE2438D7-E7A0-47A5-9E30-DE10DDBC5B8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung-Trockenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DA94DA9D-028E-4616-9D73-07C79A3FF083}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, Flachdach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CC0AC3B-4E96-49A8-B7B7-1221773C79B0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3A854BF-21E3-4E7C-9197-60E8679F1F2F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1C3E422-EEFB-413F-8048-5311470115B3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, Konstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{483BD2CE-846D-4184-B484-6C3A81220FE7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{86DA03F0-CA63-4C86-AEA5-D618F7D64556}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung, weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7080459-9868-41B5-9D97-3660BA51B8F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D63D069E-7309-4C02-A9BB-B0C6EA4109CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmflocken');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D40B3D2C-DED1-450F-9CD5-42FB34FCB988}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC272CFD-B021-4965-832F-EAD01DE60B0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmstoff horizontal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D712EBB8-ACAA-4633-84C8-CD9303D22E56}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmstoff vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0D819BC-1B29-4E56-8170-27FE75B4EAE9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 08cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6F1B3B6-3FB5-4466-B411-5A9549D4C5EF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 10cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E98CB20A-864C-4FCB-A30C-100CC1FE8C7F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 12cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60C614F0-484E-4275-A476-5F0DF5BF1BC9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 14cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DB31DE0-2F48-41A3-9693-810D59BBCAA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 16cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1030D209-0665-4A4C-8A80-D09C3EEAEA33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 18cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB8549ED-3964-4F8F-AA65-E040A424ED27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung 20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{87FD9BED-2364-4B99-A9E1-B87981CDB8DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Aussen hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Aussen weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Balken');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5CF34EF5-75E0-4D96-B836-34089E50BD97}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Bodenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2BD74C5-74F3-4684-AC8F-F1271A54352E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Gefälle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58DF0089-C547-403D-BBDF-AE311D853044}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Linien');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC231139-94F8-467A-9674-6D23573BD7AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Perimeter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Ständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Trockenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3B21355B-470F-4516-8430-337052A3C562}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung UB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7CD86EBF-B039-4A01-B593-0F8099CE3F9A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Unterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA278F00-FD96-47B3-A6F8-8A3FDAB6DCA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC8836DD-53B7-4313-B46D-A67529A51B05}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 06cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{46D343E2-DC9B-474D-8C09-FF4E24F8DB9B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 08cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D30E7332-3469-4401-B242-3C3AD2F23A27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 10cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{280E4DA3-A4D1-40BE-8AD5-30E1F2C7C34A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 12cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6530B73F-4773-415E-BB98-34D48513FBFC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 14cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{11A33B81-0169-45B6-B2FB-F34197A730E2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 16cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{452FF1A9-95DE-487F-94B8-23C0EF7CCBC6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 18cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C65FC843-E475-4D99-BF83-F9C409B4D0C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_hart 20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{609C66F0-2D58-414D-86A8-AD63329EBBFE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{066721B8-6B1F-4B02-81AC-E8292AD30277}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_Ständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9334461-BB39-43DF-80EE-27DE3D1A1992}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 08cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B9ADD7F-27C7-4711-B917-A9BF65DAE5C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 10cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A2850BE-FA76-43FC-994C-140A0BF15CE3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 12cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E63FFC82-3F20-4D91-B113-68457FACE6EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 14cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DACA8BB6-3A26-4984-A902-65C5B3F663E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 16cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9065B507-CE11-4799-BE6C-8CE1EE60B36F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 18cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA3B1C4B-5114-4FD3-AADC-4BF06757BDAF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung_weich 20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{61220357-111E-4D88-B413-5A81F26A26B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Balken');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{50308F99-6F5F-402C-AAA0-5F4F828A6EB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Balken / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC6A6C37-DC46-4109-AB83-EA35988DC3A6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{301F94B3-AC22-4E77-9E42-39947B6A600D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Decke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D97AE1E8-AAD0-43B6-B29D-31364B71589A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Fassadenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06CB14EA-90AB-406E-AD5F-373DDA414141}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Fassadenbau / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D9CDD63-1A58-4462-97D7-74DC97F2C72D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Flachdach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E45F9E4A-830B-4C64-9AD4-7DDF4D647259}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Gefälle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FADC230E-09CD-4200-9D61-383D3AF9FA69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Hohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{43010DCC-A5DD-4B6C-895B-6EAAD12D6880}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Hohlraum / 510');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{95161056-69CD-4B90-8854-3203EB683A47}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Hohlraum-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{05AEFD54-4E7A-4679-B6F0-1E238FC41E9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Holzständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ADB33B55-A46B-4AE6-A5FB-6000F559B57F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Holzständer / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{262F27AE-2967-43E1-A091-3CC6A119DB28}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Holzwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25AD412F-2322-42DA-97F2-21D867D9DF25}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2E39BE02-D354-4C5A-9345-8DA451D16CAD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Lattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7804C52A-4BD3-42B2-806A-E61B6BC9132F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Lattung / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Perimeter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{913EBF85-8C98-49F0-958E-F3837BAEA937}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Pfosten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E758803-10B3-412A-8968-93E05D86E7F8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Ständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4CDF5B00-938C-44BB-8D9A-E0D29DB4DA63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Ständer / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A8B67552-F7BE-40D4-A460-A3D99EDDD773}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{084BA81F-8754-4DE0-82AC-880F64F03293}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trockenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5CA842C0-BB57-48DC-8866-1E515D2BF746}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trockenbau / 510');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8344B0CF-F41C-4272-8A10-25D374C766C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trockenbau / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{932ACFF9-49D5-4DA8-9952-0C5C0F8F9D26}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{05B1342C-C8A6-4EA6-A524-B37C95BAF9E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D6785972-9B2B-4B95-861A-E04C4B4768B2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE142802-9FC9-4DA4-B154-E7C5BEBAB398}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Bodenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A72EC37-697D-4809-AC33-962A44310E90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Fassadenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA06567B-D5FF-4379-82BA-048937AF5427}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Flachdach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{47E0D279-6811-462B-AAF0-54F28522436D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A39EACD1-51A0-4B4E-9F1C-D46980248BC6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, hart / 760');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8C520D72-A5C5-49B6-B5D0-101435816BC4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, hart EPS / 765');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BEEA767B-B87B-4675-9ED1-171467497A27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB4B6875-9112-40D2-BBFD-26A72E4DC51A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Konstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3BE8EDAE-5D75-4F41-B037-B8FD567B7FFD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Perimeter horizontal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{03B215D2-3D0C-43D0-9B91-A7CA4C9EF187}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Perimeter vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6273FF38-C148-4A35-897B-D1190BB23D6B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Schalldämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CEEED4AA-0B75-4E37-ADCD-34B5056387A1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Steildach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D6C21F7-B00B-49C7-BC7E-A73B3C6533F5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A6C1DCCD-59AD-451F-B198-9BB53A621369}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, Unterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6DCA46C5-BCBF-447D-9AD8-8EF8D48BA545}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0065E743-168E-4A22-88E6-38926D8F392A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung, weich / 700');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FDBE7FA-70AC-4287-8009-CBAC9E9A06C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung/Holzständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EFBF3AD6-86FC-42ED-8DA5-367BA856E1AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung/Pfosten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{910AE78E-E3F8-4522-AE34-F3A52A43F6B2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfbremse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CDCE7B81-7B1A-486D-94FF-60299FFA9A59}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperrbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29E896B3-665C-45B9-8BF5-9FE0C320E0D1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A54E937E-EF3A-4A7E-82C8-D22B2B445D21}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperre / 800');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C8CC0740-5AF6-4E6F-AD9D-C584FB661402}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperrlage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{78CB753D-D72F-4C0E-9352-259FC08ED920}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperrschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BA4021AA-E890-4555-A321-3D71FBCB37C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decke - Gipskarton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2ADB590-494E-4678-BE23-A4DAFCCB9DDC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decken-Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7447C93-46E9-4E86-A50D-3C3F8E58C1CC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decken-Schalldämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D01C7F9-7B20-4094-AAD2-3FF0B3847A2A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decken-Schalldämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{44E09DC3-AC12-4B2C-B514-B0A2D645593B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decken-Ziegelstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{338AE0A0-FC06-425B-81EB-77CBD6EAC70D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckenhohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56771EDC-6C90-42C6-8287-CC2E86B4577B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckenputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2060F1DC-05FD-41F1-827D-60506901C571}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckenstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E043215A-8E25-4AEB-9E44-0DD862E1E323}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckleiste');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{469078B2-CD95-48E9-900F-13FA77F3D325}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckleisten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3CAB62DC-0509-4E7F-8BD2-838036E4DDE5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD6E676E-4870-4C7F-B4E1-0060A0DE8A8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz / Renovation Maler');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{11B1430A-C18A-40D7-8C3A-1BBE8F690379}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C151DC2-4A8C-4B19-BE98-8EA4590A904B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz neu gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{12684143-D1D5-445D-A4F7-76F4F1EA7C20}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6D10C998-8690-404C-8A1C-FB2C79ACEF01}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7DB2A4E3-8CBC-4747-97B2-C16CDC7708DA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3DBF5D73-EFC5-42DC-AB7E-8A804B682188}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E5658C54-1349-4825-B76B-90166654E27E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63B143E9-30E8-4CFD-A682-B662CC2D4137}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckschicht AC L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DF99EB05-DB4D-4214-9458-6C7231AF5714}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckschicht AC S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5C4FD198-50AD-4B1B-9349-A82ED9D32337}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckschichten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0E61F05C-2DB1-42AF-9A40-51D21DD324B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckschichten AC L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{55245288-331F-40DA-9101-523D37332BE5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decor-Hartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{207217A5-C9CB-42C0-BF40-E7BD5CB4A56A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decor-Hartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A1D85444-4A44-4B66-85E0-7CFCAB62C8E3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Decorbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCC4ABE8-0D0B-4173-8CDA-5B0D0312FBEA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dekor-Gussasphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{54CD6194-08ED-4F8D-BD6A-DE83D51C5B92}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dekor-Hartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{75928713-2870-4310-8E63-4AF65952F6EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dekor-Hartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65FF2BC2-3A47-4778-949C-A89CD7EDDB38}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dekorbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA1330F9-1FD5-4168-A90B-F6237DECF550}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Destillationsbitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F4391BE4-3DBA-40E4-A244-2C3C716D32CA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtungsbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1FBEEE7-DFC2-4102-94E5-D50436B919C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtungsbahn / 800');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8725130A-6A67-4C62-BF66-053864E38879}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtungsbahn-Kunststoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C560AA37-A840-464D-8B83-67686AA8670E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dispersionsfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD902F89-8567-4185-8B3A-4C52ED65156F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dispersionssilicatfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4000C445-B739-4779-8207-B9742EB2D535}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dispersionssilicatlasur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{71FAC7F9-C184-4378-AD08-21C49F3718FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Doppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0FCA57F8-A535-4CAE-8043-CEDA63BABD82}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Doppelbodenplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A332456B-A095-4F8D-B7D5-44FA6060C6E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Doppelbodenplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5CB320B3-DA76-40E5-9595-B220E2C6B0FC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Doppelrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{125CB03B-4DCF-4750-995E-27218B836006}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A498F3F2-16A9-486A-B15A-EB0BDEB1F5AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainage-Schicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AFD4CB07-3FCA-47ED-8802-777A8CE23522}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainagematte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C952DA14-65E1-46AA-9B48-A4938FC31C9F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainageschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1EE29CE-1F2D-4E74-83FE-980CBEBBF6DE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C4007F1A-BA2D-45CE-B45B-8350882639FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dränage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70AC4085-88B5-45DD-AA9B-62879D017B1B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dränschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E323AB1C-558C-4C25-B2E6-CF763B6FF7B1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dreischichtplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7D67C8CF-08B8-40DB-AD4E-9E0FE1FF341C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dreischichtplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0D632B82-3D2E-42A4-AD9C-4F2DA13DD092}', 'global', '255', 'material', '2024-04-22 08:00:00', 'DSP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73B14AEB-BAB7-4978-9122-CBD33D2A9CBD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Duplo-Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3E8AC76F-596C-44F4-A997-4A31946D64BB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Duripanel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7307A32C-8BB8-4F2F-BECE-5AD88C0A6506}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Duripanel-Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{87E0A940-B61F-460E-925D-54A49DCF53A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Duripanel-Sichtplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29C87571-B494-4DBF-A8BA-F1B6617355B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'DWD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{71E0B550-D0AE-4A3F-A573-C4EDCAE57D97}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Edelstahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0087C144-E873-4653-B3CD-48E8E1E8F2FC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Einfachrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F95E2DC9-D038-40B0-8B19-A655DEA209A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Einstiegschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF9AD521-06E3-4D8C-A82C-68CD7D0C8A8D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Einstreubelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC525EED-EE76-43C4-9563-89011E25CA98}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eisen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D14278FB-B879-4D4A-8C9F-721CDBD57C82}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eisenbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{20C6C4E2-12BD-431F-B69B-40A02E7AC2A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eisenglimmerfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{39C410BB-2C4E-4F5D-9808-23571B9CD8EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01042161-AF47-4653-8DF0-2DFB22C25B21}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Gummi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0BA87327-C6D8-4181-950E-8E2D21E03450}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Linol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8181245F-E5B9-4008-B92D-FA5E7AB53F6F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4FE84A8F-ABDF-460E-9817-DC0A21167C12}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{09B2682D-88AD-440A-B8F3-58E8A30CAF63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B9268A79-566E-4922-9AC7-BF935D20D780}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB37673F-7932-42A4-8C9C-837AD457A8F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastomerbitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{99F07431-2976-4FA9-B5AF-F62E11F94DC0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Element-Doppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{39F11DCE-6FDC-4A66-A9E7-778168D5DD4B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E074FC0-82C8-4AC9-80CA-0696619D4FFC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau Sichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1BE9C88-AFAC-404A-8C29-79E4CE69BD69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau Ziegelstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE726D90-E0CF-4841-B354-1A61A73B83AC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A25A5713-0A27-482E-AAF4-C317E26C8F0A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1053130-23F9-4D5E-9BF9-36DBFBC4522A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Porenbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0BB9E72F-11A0-42E1-989B-DBCC862AFDC0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Sichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8F005611-17C6-4468-AC07-0439E318CD63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4C451960-1EB3-41D6-8B4A-2BB7F699BAD4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementdoppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81173146-E95C-41C4-90FE-B0A8B2DA360F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58E837B1-A035-4866-A4E6-3AE3F6EE110E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C15F24C1-E832-4C67-9E03-6C59CF16F6D8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Epoxidharzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{34701D7C-EE48-4EEC-AF69-441FF4D2BA2C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{120744C8-E03A-4493-BBF4-F5A52157EDB3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Erdbereich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{91EE1E10-8636-4324-B5D9-CF04B40FFA90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Erdbereich / 100');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Erde');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1ED221D-E26C-4FC3-8200-A1441FEE3A70}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Erdreich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Erdschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0ED7346-2040-4A89-97DF-F45E4DFD31C9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E09977FC-67BA-44C6-8D11-6542C0B611FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ACE82C94-D38B-46D0-A3A1-86F79B287452}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58E3BB84-F251-4B1A-805D-0376F26F98BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich-Bodenelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4FD2A875-1E69-43AA-9C7B-058C98116C87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B8B6B837-438F-4405-985F-B1824FA53D99}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich+Fliesen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{11DC53EE-ED75-49F2-9461-F2BACD3074CC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich+Parkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65EABE19-D976-45BB-9189-639552A24C37}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich+Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{36C7D5C7-00C1-4B20-9DE7-33D2902E584D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich+Teppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14A6BD8B-03E0-4C99-8995-2A5BCD683A39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrichboden-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7EA5052C-446A-4D4E-A8DC-5C9D2F014F14}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrichbodenelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7F9A91A9-90D4-4AFB-961F-1D7D9C6EC65F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrichelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{92D85FAB-7A29-486A-BE03-F54C96056FBA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternit / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD4B2B8C-C93F-461F-8EFF-12A99664C12B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternit / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A787A56-2463-496F-89E3-9A363F13862B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternit / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27BCF732-F6B8-4C91-9A06-A786245F0414}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternitrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9008A68A-8FEE-498E-BC8C-287269D1AB30}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Eternitrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0C5743CD-AFF5-4D3D-8A2F-A83683A17141}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Expandierte Polystyroplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{144468C2-C9E3-4485-A510-A86BDBAB1E60}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ext Begrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6A5650B8-21DA-4969-99F2-F9D4638FEF51}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Extensivbegrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEF1F0B6-8782-4D77-95EB-24591CA3AD34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Extensive Begrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{431CADBB-4406-4189-89E9-E3A1DBEBD9B8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'extensive Dachbegrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{69F0E3D9-850B-453A-BCFA-003D3FA21723}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faltschiebewand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A1331C04-9287-4B3F-84CE-6D4BA369923E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faltwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E93F63A3-B2D4-42E0-AD6B-96112B44CF49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Falzziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2AAB7ECF-8159-417E-B5B1-2811D723A3AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Farbanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3267ADD8-D9D3-4C5C-BA37-887C16C6504C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25AF8E8F-FC0F-4BFA-B609-0FE77D254E79}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{89A8064B-A84B-4F13-8632-60C5E93C0C6D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzement / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D612567-A822-4709-865B-62BB3C426931}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzement / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01A63D8A-E4C7-43BC-8900-321CD9529FD2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzement / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE30037E-2369-494B-B2BA-D6ED29B681DD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A37411BB-966F-451D-86EB-01DE85182265}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{16EEFCD9-690D-4F05-B668-4F6B1F65BCA2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{004FD344-4579-4DB3-BBC3-55BE2AF568CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementrohr FZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F96F7B19-3BA3-4192-AF63-A1D3CB05BDCD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7D65CC53-D9CD-4A4B-B401-34D2E0FD95B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementrohre FZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{76CA8E8B-5C42-47A4-ACD7-B49D919CF9DD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzementschiefer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E947DEC-BE81-4407-8236-2528F03476A2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fassade - Holzverschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A69A4FA9-BE34-48F9-ABE5-BE9E5B523C2E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fassade - Metallpaneel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{567CCF42-21C7-4FD6-85BD-DAE8D52C7BA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fassadenbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C38DF9AC-1F6C-4317-A2AC-8E822C87A56B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fassadenbekleidung / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{10490FA5-F422-4B9B-B5EE-AA135BAFBAAF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fastäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3E348405-D2A1-44CF-ADC9-69E973018887}', 'global', '255', 'material', '2024-04-22 08:00:00', 'FB_15cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A8060292-8E3E-4672-932B-6DBEE3A83A87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'FB_18cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{746207F2-7184-4435-B151-E61AE9B68547}', 'global', '255', 'material', '2024-04-22 08:00:00', 'FB_20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{32B0693E-9E27-4663-86F2-DFAA60BA203D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Feinmörtelbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9AADB5D4-1847-47CC-B7FF-2E107DAF6BE6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Glas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7D1D3406-01B0-4985-8D09-4457EC4FC0FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B6B2298-5B92-40F5-9681-F25C43632E2D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Holz 1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52058ADA-515E-40AB-BD2A-F8C51311F64E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Kunststoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED5DD910-9798-45A7-9791-52A1CE53ACB9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Kunststoff weiß');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3B3E298-71F7-4F4B-A4D4-E59143DA8A72}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fenster - Rahmen Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C41885D5-F941-495E-970F-8908313793E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fermacell');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{23193933-4E63-47B8-8E30-4F80C032C2AB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fermacell2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E44A9C9C-B68C-4CE7-8A7F-98713951979B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D6C10AF3-49EB-4C4C-9FB1-066EAB0E48DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A7DD0EF-363F-4178-AB77-5A183EF8543D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0284B695-F766-455A-B467-67D23A3641CF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CC9EB88C-BF38-4E5C-B0A9-FB0FDC0CEB87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5F2AAC1-7A1A-474E-995B-F744E7D04DA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A1FC7271-0348-465D-B771-6003AF5E9E03}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ECBE07EA-E6F8-4F06-BF8E-C6EBCA5A5F44}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9D75C698-4292-4E56-829F-50CE11A9BEF5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkett-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1B028862-D4E8-4672-9C67-85A226E52CBE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigparkettboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigteil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58C0946A-88BC-47A3-BDEC-352997A64146}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{80DD810C-53AE-4E4E-AD97-AC5A955F641E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fertigwand / 120');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEA42F3D-BA13-4333-9736-6CAD464D4F27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Feuerfeste Steine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{71EC64B5-D0A7-4905-832C-225045D93C08}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Filtermatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE905362-6500-42F2-8EAB-1D2B3BC08772}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Filtermatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3FE92E47-E3CC-4F73-BD2D-11F7E1BF553D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Filterplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7012C65D-D9B5-437B-B7C0-560C519933F2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Filterplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31A2A877-B990-4A2F-BC06-4F6F1D164E4C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18BD6D18-053E-457B-A77C-FDDDAE9BAEA1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachbelag / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E9A6115-8EFF-4981-BC0C-AC01A3B291B5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachbelag / 405');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A8D57DFA-F7C2-4144-A819-EE9FBD08CA1D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachbelag-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{288796DF-1EE6-4F85-B9CC-7D6CB88D190D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachbelag-Verschiedene / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41C3F008-2AE1-4821-9A69-75D96A45B227}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachdaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1471AB7C-6B27-4E89-A495-43106AEC0783}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9C045DFE-3891-418C-956E-3A5194E459A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2571DA7B-AD18-48F2-9F5F-2AC5E612BBFA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliesen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C56FACA3-353A-4A0D-86EA-603122C5083B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{551FD34A-F3BD-45B2-B29F-D9AFF7A5BC74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7BE29165-E11A-41B3-AE94-EB597CF41C5E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A8F0AEC-7C21-463D-9A02-01516D047E3D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich 2K-Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{108D9C61-0E0D-452E-9E5F-9BBB6B2A48F3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56F60509-30BC-4C69-898B-462557D43E6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B9A56B63-5AEE-4699-AB53-C4370FEA47D0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1809BF34-7400-4F87-8338-391FF6E99BB3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich CAF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01F204C5-2121-49D6-B2F2-8A2903EECCBA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F88E679E-A3A3-4A2A-97C0-1C720EB9B2DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EFA06C63-D40E-41AA-8EC2-2CF0C0DAABE4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BE0E5C7D-C8A8-404A-9EEB-F2DE1C580921}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich-Bodenheizung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{561C80E5-A38F-4A57-8370-F0977B76B840}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flüssigkunststoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5038E65B-08D1-4C27-8911-81069EBBED8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flüssigkunststoffabdichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{758BEC58-62EA-49DA-B9A2-F0A99C331153}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Folie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{532233DC-9A37-4817-89E3-5517BF7B50CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fugenlose Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{53FDE63B-9534-4FE6-A4D5-592E74DA36F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fundationsschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8C6BEFF7-DB76-49E4-8DC1-E928EE48B721}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fundationsschicht AC F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C6AF3AB2-6063-4147-AB83-869D2E5FD7D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fundationsschichten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{243EE2E0-8A38-479F-BD38-86A9D9E039E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fundationsschichten AC F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{195FC903-5E34-4726-B908-33535A31C402}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fussbodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{64A0A59F-0DB3-4E85-85B1-E197F4C2EB84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'FZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BBF33FB9-C70D-4082-8C7A-AA493B53AFF9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'G2 Bodenbelag / 200');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F440F262-54B6-4867-B5E2-A48CACC40C33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gasbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED5D0950-A825-4CFB-9BD3-90B19461641E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gasbetonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6E904830-E8D9-4E0C-948F-7674475CD49D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gaupenschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5CE4F94-782E-4536-97D2-5C08DBEE8ED7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gaupenverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DDA2548F-5498-4EC4-99F0-3B60F9EE5D46}', 'global', '255', 'material', '2024-04-22 08:00:00', 'gebeizt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FDC7C037-9ED7-4D80-B9EE-50D9FD6E68F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Geberit Installationssystem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD54DF3F-BA3E-4F25-8FEF-CB75319CB3FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Geländer - Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{099AB91A-252F-4BC4-96A9-550999FD61EC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Geländer - Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0364DA24-9C5F-4C2E-8F38-DCCE7AFC89F2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gelochte Gipskartonplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0303A666-CBB4-4A39-BEC5-9A0B6AF2FFDF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Geröll');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{66797BA2-0656-493C-8338-E82DC5C1D572}', 'global', '255', 'material', '2024-04-22 08:00:00', 'geschlämmt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{233D35B6-2A21-41C0-AC28-A265D662B15B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Geschlitzte Gipskartonplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD964F3D-B22E-41C0-B45A-EC55E6BED2E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'gespachtelt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{888D767C-0A70-4347-9FEA-3A6E7E5B83C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB7BFA80-D4A0-4A08-BECF-34781DDB2952}', 'global', '255', 'material', '2024-04-22 08:00:00', 'gestrichen renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5650D327-7B90-4BB1-A20C-2028AE6B133A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gewebe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BB6E64A-2D87-4DC2-9BF1-51F2D1A0A1CC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3FBB6342-5C72-4E7A-93FA-EBF186C65A4A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GFK-UP-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7890AC45-9FDB-4863-BA0B-5A2903086406}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GGG-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{633E88BC-D251-446F-BFD3-0C260E115380}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{09A207BE-4BD0-4905-B4A2-83CAA3F1ACCB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips / 450');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BF0C0DEE-F581-4447-B6A0-799F27382FBC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips-Wandbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B302DF1-AADD-405D-BA1C-18A14B06E2A3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips-Wandbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E124A5A8-0939-4B24-A0DF-6589914173CC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsausbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{552C7847-38F0-4858-818C-BC8BF0351746}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsausbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6222EFC0-B64C-476E-9116-6CA15A53EED2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F803419A-E940-47BF-A7B3-BFCA58DB8324}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{006DF2B9-6961-4B0D-A88A-6F37C83E7B87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsbauplatten / 450');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BA5B9CF1-05E6-4047-9BA2-4535A2E2C156}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsdecke gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DBDB2A00-E574-40D1-BBAE-A0E5562B64C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE81AE5A-F24F-4158-8F1B-F5F40F565A9B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatte / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B987F2EC-FC71-415A-B981-27F238F0EA4A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatte / 330');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{853BB6ED-6580-4CDC-B6C3-7CECAC8BBC14}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatte2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED62C039-21E6-4A23-8193-58CBE2454988}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC7E395F-6248-416B-AE36-2FBAA8A0AFB9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatten2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E763BD5D-C41A-4277-B1DE-47224145E3E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1BA867B-0353-44BF-8AF5-C284BD8733E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsgrundputz geglättet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7B89A134-8A54-4241-9B3B-8BD31FEE0A58}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskalkgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{779D8106-0E63-49DE-BFF9-954FC4EB82B5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskalkputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27903630-783C-45AE-9E5C-E30160073F66}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskarton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{286F2714-72CE-4CDA-8C86-4B3F483E375B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskarton / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC66926A-9FE6-42EB-A43F-84D09632823D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskarton gelocht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2BF6A62-64C4-4215-A708-73F27263240C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskarton2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3DAC9A5A-B27B-43A0-9336-CBF07A76BF6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatte gelocht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6A772FB0-896B-4BC7-933F-51C884A11C0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatte geschlitzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6DF4DFDC-70F3-405E-AAF8-AAF112F77570}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatte2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5352110-11A7-4C65-B9E7-B10B99B5BDD4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC3DB159-5C7C-4746-9C2F-5C1930B21234}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatten geschlitzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{91681745-9631-480C-BDA1-06E493334DA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonplatten2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1A4BADB7-5EC0-4C72-9D3D-3F9531E0B65C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D3FA9E5-BDF9-447E-86A5-89B9607D8C3E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskartonwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{46D5DBD5-4632-4429-BDF1-E3820D53C013}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipslochplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA518AE6-BE92-4163-ACE9-598D67852A63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipslochplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B2093A3C-6AAF-4998-AB62-40A3D18DDE08}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FDEBBB66-7577-4835-9944-A0F4931197DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatte horizontal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D919F4C0-5507-4B7F-A7F1-FFC69A480FA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatte imprägniert horizontal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{368E8A74-4D17-4F8A-A1D3-605C94BE2103}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatte imprägniert vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BAAE82C7-43E1-4713-B6E3-46CBCB375273}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatte vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2714E3B1-BDF8-4284-8835-D03EE613C3CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F56A6298-916C-4051-B239-1EAE2421C39F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5FB34047-7EAB-4CE9-B7E8-05349F82D42F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsspachtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{447E76A7-3474-4B53-A9A3-4784069B6A5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsspachtelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A2C3CBA-CF19-4BDB-9A2A-E0D5E6601DAC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipswandbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E1BB9AE4-4D1A-4C4A-B9B6-A7A982259B5F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipswandbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4CF646F0-E00A-44B0-A496-3EDCDC8288E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GIS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F1E63549-57DA-45EF-932B-B116299E82C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GIS / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48CB7CFD-7722-4D21-A206-B1E51623339A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gitterrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7DBD558F-79DA-4B23-9913-66D9CA681F87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gittertrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{90647797-38F9-4D05-A752-8F1127E7D426}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gitterwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5537C23-04E2-4AB9-B47C-0B8095877D13}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GKFI');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9879AB0-142F-46C0-BD26-9BA9C565C3A1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'GKP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{588030C7-EDED-4175-AAF0-97944777168F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas - Glasbaustein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58AD2F75-D09A-4ADC-B82C-2AF7CE0475F8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas - Klarglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{87A382E9-F74A-4A0B-9B56-DB646E5EF9AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas - Mattglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AEF855B1-5DAC-4FE1-864C-F3EC30C7BD7A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas / 530');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48560052-DA1F-436D-A408-0F3CFDE6B6C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas Normalglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5FE606D8-0495-465E-BA6D-4FB02BBFB8BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasbaustein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{636C649D-3677-45B0-9CCC-E651B8D6F107}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glaselement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C767AE06-964A-4883-A923-E2D2B3AECEFB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glaselementwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B97977C0-A51E-4ADD-98BC-4719DA696A90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasfasergewebe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4221BF01-6ADB-4B46-BDF1-06CE27B13F43}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasfasertapete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DD97D5D2-1F28-43EC-9137-8223D04E02C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasoberlicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC3E5615-5004-46C4-86B8-AAD969409883}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glastrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B731876C-CC8A-4A96-AAAA-401D4CA9C272}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasvlies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3D1300C-BDC1-4EE6-B16D-BC38715B84C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glaswolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B3CFBDC1-A153-4716-AF3D-C49BB4159D77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glattputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CDEB2534-8EB6-4EDF-8276-7FF15B588CDD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{551F70C1-2656-40E5-9A3E-25C7C3F28DEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{36F58DEB-19CF-49BF-A2A6-9034CC3C0D0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{51ACE1F5-4652-4B32-A54D-651D916C131E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9C159D3-17B8-42D3-A1C7-745247320573}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE5B3A39-7993-4110-8E30-47C1175C69E4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C22B6FF5-C2DA-4581-81A2-BD854D0FAEB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8ED8C31F-6936-4D24-9982-79457DC72845}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granit-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC5D448D-D7EE-40FC-9BDB-E8E7F4939746}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3833DB62-79C0-422B-A218-0E1EC66855A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FDEFA3F8-125A-4E3B-8693-70434543FA5D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5EFA1EE2-C62F-4D4E-8650-62E0754ECF63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1FF75DAE-A56A-4341-A884-69D7BEA70E3E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA36B42B-3A1C-45FB-BC47-ED65234CA624}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F77BD13E-0871-4BB9-846A-6C2A5E8A804B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEBCDF0B-4E8F-4964-B5BE-F206567CBDB8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF85E39A-237D-4D74-A68D-72975A71B797}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Granitplatten-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F62148B0-1B81-4F5B-A301-5B9565CEA3E4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gras');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CBC9CF6C-2BD1-4B16-AF23-E30472509ECA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grasfläche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F2B6CD4-5C3C-4929-B35D-610A63D0D58A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grobspanplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4C28D272-2952-46AD-A260-F52E4A86A951}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grobspanplatte-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D272A15F-C169-4B37-BEA2-4E5440287879}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grobspanplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4814E05-0B0B-4D3F-8440-C751AB22C690}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grobspanplatten-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8A7DEE5-3559-41E2-BA29-E5D96A41DF55}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8C5B12C3-14B9-44F3-9893-B1CD0AD0224E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gummibelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C5BE2344-9C05-4AB8-9A20-F1F05F465112}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A3188AD-288D-4B43-A482-681958D667C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4F9ED15B-2E9A-4585-B5D5-D003DA512006}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0D7F9727-3B41-457E-AA17-1C4A2CD48593}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{279E7C9B-8656-471F-B4B4-700FEB82D22F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9B08FA8-EF13-4D9A-9371-F43DDE399589}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E00C80CC-E3D3-45FF-BB9C-8F45BA8C43C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67A2DB4F-C2B3-4A89-8190-66DE1CB8752B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppen-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DB28071D-34AC-4E9F-8A59-8A3E75A21F33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gumminoppenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{209DC80F-F315-4618-8219-4D3B705C4423}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Guss');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EF46056-12EF-489C-BCAF-68FCF9040FE0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Guss GGG-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C2A935F0-2BBC-462B-9D8A-E275F9BF3956}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gussasphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{655B28BC-9793-4637-AE6F-9BE8C44BCC07}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gussasphalt-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5553AFB1-A9FF-4348-94A2-45B45E0A1E0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gussasphaltbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5579BDE-7F21-4C85-A701-2736D772F7BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gussrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A4DB100C-51A2-4057-AF5A-83F33BD22154}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gussrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7182FFF7-782D-477F-8814-4AD91A5B4851}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hallen-Hubfaltwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EB4FE04E-A4C6-4DD0-AC09-7319F652A76F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8F1E5B50-4AB8-4E0D-A531-23466B190844}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbeton / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EA22A6A-D59B-415A-A48F-34FF9A62E3C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbeton kunstharzvergütet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FE6E28D9-9A2D-4202-96BF-5C4C81FA7E6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{16C97787-A481-4065-AB84-CE0688F6C7A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbetonbelag kunstharzvergütet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C5314DD7-EF25-4B5E-97C4-C685B7169F84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{954226D6-0A78-42C5-A387-18EADE6AC2E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartgipsplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartsteinholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7BB03256-F97B-41CD-AB55-D1DFA2AED5B1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartsteinholz-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2DA360DB-59CD-4A50-83E8-61DF8247837B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartsteinholzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{03BDBF8B-BFE5-4343-A03F-57234382DFDD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Haushaltsküche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{362AAC94-1220-4BDF-B35C-F5A573E20EF2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{23B23BD7-FC54-40C6-9312-ABA04EC45816}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HDF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hinterlüftung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{379088D1-1960-456C-BC28-FCFC65478BC2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4E646160-C744-4ACD-9435-B9324BC78E39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLz-Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{64A4A086-82A0-48D9-829B-0B2CDE872A14}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ-Mwk.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{30B50FA3-B492-4C03-A8A1-B11FBE294BBF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ-Mwk.Schallschutz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D86EA59-AF6E-4058-B196-3C8139A64932}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ-Mwk.Wärmeschutz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BBDEABD5-8967-4DF5-B369-A4A9369B4D8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLz-Plan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{86F50DB4-F537-4B85-A036-31D047715E09}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ-Plan-Mwk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B3A4FB7E-C7E5-4F5A-8DD6-61E88B38FB0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLzB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1C114AC3-8DE9-47A1-99C0-010A1ECE33F9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HMT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A74BC454-E316-4158-B23B-FFBE40AB0072}', 'global', '255', 'material', '2024-04-22 08:00:00', 'hochlochz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E5B84FBC-EFB2-48BF-9767-83C12810D232}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hochlochziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF4EC6A2-318A-47E4-B131-88D86A0ACC30}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hochvakuumbitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2585F4DA-2DD7-45ED-8F85-BE1BE81D50BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlblockziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC141699-CF21-4640-B313-BE3A55F4D406}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlkasten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F7DEFB80-4B6A-4DB8-A164-7934A8D70B96}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlkastensystem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0900F429-407D-449F-89FB-CCD610390FB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlkörperdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E1DC2E2-16A4-4A15-AA32-FBA8EB30DFFF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B0A3E65-0740-422D-961D-57A3173F1719}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraumdaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8B3EDFA-5A2C-4BB1-A6D5-858CB85DB8F8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraumdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CC917823-C809-4788-80AE-10B5A3419747}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraumschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A4E2CFDE-6808-4676-9F6E-3C1CCA3EE0E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holländerstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E13AC55-0060-4972-873A-F67DEDBFA46B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz - Dielen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DFDC917B-2BFF-4CCF-A222-31D4D3B86C55}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz - Kirschbaum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A10AC3A-A338-44C2-A1A8-2810A5FD9598}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz - Kirsche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5DDCABB-FB75-467E-9504-141F4B8D8B57}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz - Sperrholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{480374F9-7395-4214-A5C3-0021988C79EF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz - Sperrholz1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE6FDAAA-A997-403E-90ED-A32C64376062}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz / 600');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE09697D-680A-46E1-8009-583F00DAB853}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Ahorn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8DE83F3-D914-4D86-BB1C-099D3B1CBE96}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Buche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{543DBADE-896C-42F0-9C17-95CC18A33BB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Eiche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC2A05DB-7B16-4AA0-83E5-7F1C3266799C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Esche Olive');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCA23E63-F03B-46D3-9CE7-97F9DD70FECA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Fichte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{88284F30-6AF1-475C-A662-CFD6E4B5F3E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Kiefer Ast');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9376B1FF-328A-4843-B4D2-BD1DF3EF7274}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Kirsche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7F1E3279-6D8B-49E0-BAB2-42A9DB182CD7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Lärche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D0DBAA00-EAE0-4718-877C-0CDAFBFFB951}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz Nussbaum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B889CED-23D5-4EFC-B426-399995C6C65F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz verleimt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD24AFDF-9D56-4956-9FDA-C616360E9C0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz_massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D67BDE7-4111-40A4-B66D-A7D59BFA7C85}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0AEBA150-A369-499F-A7E0-D7D0A3DE94E2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A464856-1A9A-4ACD-B727-BFDE8FDBE45C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ACCD88A7-77C1-404A-A6ED-05D1B54E86B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Paneelen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14DC65AE-FE01-4B85-902D-904A1FAFF5B4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{85F6DC17-F255-449F-8139-FAA08815BF79}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FCBF469-DDBD-47A3-9A5E-E8655FE0EA6B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion-Konter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DFA4A536-FB5D-420A-AF98-FE2D680EC71B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz, Konstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BFCB598-C337-46EC-A957-6CDBC50D0205}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz, Konstruktion / 550');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D5184ECF-46AD-4776-9F8E-080BA795225A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz, Konstruktion / 750');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E8E1FCA2-34C9-4E7E-84F0-884F75A7075C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz, massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BF33C59A-FD1F-402E-8E13-7C692049DE49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz/Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E42E0BD9-14EA-419C-82A6-F4F5B4734A56}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz/Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0A80D25-D070-4A43-A7EA-C800A6410625}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz/Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5AE5514-E0B4-4312-8951-E5F353332854}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbau massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AEF39A4F-A454-4196-90C8-503D4459B786}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbausystem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE32C99B-A34A-4F6C-8D20-480B8FAD84C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbausystem-massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7DD91E66-77A3-4930-8401-BBBC1612D9D6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzblocktafel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5520DB60-0FCC-4750-ADA1-E95DDB876756}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63E8CA51-D60A-42CA-ADF5-E01CE243BBF5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B3AC649-6973-4974-982D-FA124F21C698}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8B7942E3-293E-4118-81D3-4E2FBF958628}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{68A22DE9-53F0-43A0-8F90-8FF4A2C131EA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B467DD3-E7AD-4458-9C1F-BC880AF184C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D281A27-F150-44D3-BF87-045C7D956270}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CDDED0B4-6BF4-4B5F-977F-FCFF126DB4BD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{47AB55D5-DD5F-4459-9FBC-88D043125EEB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzdielen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45343160-EC11-41F3-BADD-CF223D414DE4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzfaserplatte / 500');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9BDDFFE-E073-40DB-BD20-B045A0F30215}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{72588056-5804-460D-9C63-320B4B699879}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzkastenplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7ACF84B1-9616-4161-8996-1C3057853D17}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzlatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AE79EA22-AB44-41A7-9309-C8C6517C97CF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzlatten-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5B2D677A-920D-422F-8E7A-12E4DAFC09A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{37B08A22-A83D-41AF-9B08-CBEDD7F7EF04}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzlattung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97EA83C3-2ABE-45AC-96F8-05C4F1AADE82}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzmetall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{10976E94-439E-48A2-A6EE-A5A1FEB45EBD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzpflasterboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{332A0923-5807-440A-83FE-918A48C2582E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzrahmenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0301E547-F442-4B54-85AC-0783919D9E6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzrahmenwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3A6D932B-6996-4181-B667-AF781C2CD93C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzriemen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB0C0643-3C9C-4CFD-98AA-67C24793EC55}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzriemen / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{114D715B-2B00-4BA4-A935-BC64D6A327BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzrippenplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BBC86339-D568-4069-9C31-016626F62E24}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27214A90-4EDC-493A-B1EA-214BEEEF5DCF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzschalung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8F40174D-0BFB-4E61-A5D0-17CDB7BFC194}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzschichtplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9B137B6-05FD-4150-8249-3A9C151B71D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzschindeln');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{15333D2F-1B56-40DA-B213-45517CBDAAC4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BE339D61-FC09-44B7-B9D1-41A98FD58BB6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{434CCD74-E8E1-4935-AE96-EE4B1CBA97D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer-Hohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25211CB6-ABC4-4E07-82F1-FE2DF403BCF9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer-Luft');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{499F536D-EB6D-44E5-93FE-0030FAA1AE2F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer/Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45B323C2-A99A-4C86-8BE4-564121501153}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA0FCDC1-4017-4745-BE85-50EC3D61B6AC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holztafelbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{04FA3D29-7A94-4B08-9364-5AED9614F1C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holztrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6DC76042-BF36-4735-A766-0DBE9D7C7C2F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE91D0E8-6E45-48D2-9F08-BD238D8C1FDB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung / 520');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5722F2AE-6460-4BDE-8C50-9CC001725A59}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung / 550');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A38C97AA-8F0A-403C-960C-1F96472D718E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5BE096FE-555E-4FDE-A2D1-837DB398BABA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{23BD2221-1B7A-484A-B68B-C8680EB25110}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung-Innen / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E6F63506-2630-455A-86F4-14BE9966EE5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9143540D-E35C-4419-8430-BD7B3B6B7CFD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff MDF, natur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B3B02ED-EDC8-4DF1-96BE-BA77929C8D1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{399A87B1-067E-4E28-A3E5-B6CE3F4C57C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff-Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CC3C5AC2-D400-4255-9873-70752E98A33A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoffplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6F4359EA-6EC3-4E4D-B063-412374F8E387}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwoll-Daemmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7AE22BE-951E-4797-ABCD-0E2ED48FD808}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwoll-Dämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D0E57A90-4434-4535-B101-5A62AA409B02}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwoll-Dämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0C5667DE-B543-4622-8B78-647E11A4FD0C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7C6DBC2-6F0D-4B21-9A1E-7345C7ABC6BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Dämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8586B8CE-3B60-4B25-8BA3-EA45EF95510E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Dämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B7271F48-B7DB-4E68-A7F0-20F66D6E22D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Leichtbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BEC52677-D67A-4717-B4F4-46A712A303D6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Leichtbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8BC94010-B17F-421F-B125-597FCCA6D692}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Mehrschicht-Dämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B7E28E52-0CA4-4804-BD97-7C4E2FAD534F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Mehrschicht-Dämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18BB4CB5-4554-4D45-A52F-16FB734DA30A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwolle-Verbundplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1C99070A-251A-4699-9785-6346DA2B7CE4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzzementplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35FA6333-B4D7-4ACA-8B4E-72212C6213B8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzzementplatte-Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{150A1016-58D2-46E1-BEB9-C585F3EE5754}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzzementplatte-Sichtplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D39DA7A-82C6-435F-94E7-A6761514CCCB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzzementsichtplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA270471-9DCA-4C3C-909B-62545D6E094E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Homogen Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{43291F2D-C538-42EF-BFF3-B6CF08825EA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Homogenbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5AF9423-0408-4103-8FFE-5E950896DEA2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Horizontallattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA315943-FFC0-43E0-897E-150A486F355D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Horizontallattung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D60341F-A47C-4DE7-AE25-121AC4F86246}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hourdisdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7914DF6D-038C-4532-98C5-989CBC06E9FD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hubfaltwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{491D74AD-1139-41DB-8F37-D1B7D77B8F87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Humus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A2E3769-7402-478E-B96F-FB587C0CAB3A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'I + L Stein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{641F80DA-11D4-4DFD-BFBD-16B9D3F987F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'I+L-Sichtbackstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC817390-C7F8-45A3-A835-1655A9061DE9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'I+L-Stein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29416189-5C20-4529-A7FC-9433D71BB1B3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Innendaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E5E70EE-2EA6-4F27-A225-DB86B337E75A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Innendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{20E3580F-567D-4966-95F1-4D94CD08A314}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Innendämmung / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9EB4F04-B492-4FE8-8ACD-7BBC24DD09CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Innenisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A867CA08-A5CE-43D4-93A6-DAB23B760E50}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Inside');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67F032C0-8B48-4615-8DAA-882CAB130229}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Installationselement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{12FCF449-A239-4AFC-8C69-D0660D670EC0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Installationssystem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{072B0962-355D-46DA-9921-DDD9904E3AFC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2AAC3162-F401-430F-8142-AC1484466346}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Isolation-Trockenbau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0161F27F-B09B-4D8E-A874-30467B6C1014}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Isoroof');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7A906D11-5FCE-409B-8647-42EB0E3F12F3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Jute');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6C6C0A90-CE64-4691-A724-0BB639716BB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kabinentrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27144E9D-6C08-4E82-9E03-E8018A8A211C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kabinentrennwand / 320');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{59868D05-6C49-4E2F-9D88-6E0B8E05E131}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB29B77F-D255-49A5-8E29-235BA8E1DE5F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkgipsgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B3CAE0C-1237-4192-B7FE-58EECADC66A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkgipsputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D066A71E-5C54-4E3E-9199-6B5735E606EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{19212EB8-216E-46DC-B935-460B2CE46A9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkkaseinfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7CA4264-50A9-4D8F-BFF1-636ECC67398E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CA16DADA-4E87-4120-8ECD-578551BA6918}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4E8E3D28-C544-4D4B-8014-8B28F7F116C9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein / Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9D20778-46A5-47D7-B6BC-EBE28897BFA6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{966D4C0E-81E1-4AA9-A660-6BAC880AD13B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein MK bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EAEF315D-560A-45D1-98FD-C78E4A2E8D85}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein MK nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF370821-C1A8-42B8-8001-41A6E8546805}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4E13694C-FA60-462E-B171-8E50674966CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BCB7B6EB-132B-42E1-A260-C5FED3618CCB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandsteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B371EFD6-F3D1-48E3-A9A2-5CF13A05200F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F88BB350-04CF-4CE7-AC0B-90EDFEECF37E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksteinplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F23233D3-BBD3-4EC7-BB31-4B9460BE8FA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksteinplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81DC2B42-4B9F-4139-AA03-B819B8CA1F97}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkzementgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F7993446-DF96-4771-B2DB-0DAE4C4F645A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalkzementputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{471A22AB-BF17-4531-8FCB-B7FACAD63F69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaltbitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D496F2EB-4F75-4EB2-9712-6E5EA59D7A0A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaltbitumen-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2776A87B-EEDF-49A9-B36E-68AAD2BE9F56}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaltbitumenbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{10129DF9-D081-48BB-9BD9-5FA3F45D674E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalziumsulfatplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D8BCA64E-E351-456F-A414-3388A085EFBC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalziumsulfatplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70FBCAF5-0686-4317-9750-748A8143F704}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaminstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8DEBCC2B-F7AF-46D3-BAF6-E11613DA9F55}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kanalisationsschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BCA9219-45C2-44A8-8EEE-098A571FB101}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kastenelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4F6C8463-63FC-430D-BCC1-69ADDD670176}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kelesto');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C741431-9A0C-42E9-BCBE-9BC90F7C7DA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keller-PLZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06C38178-21DD-49DD-8065-8106AF3DE130}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kellerboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F93FC7B-128C-4D4D-A9A1-91E4895919F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kemano');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{54BDC799-0090-4606-BFA9-4F8D07316C29}', 'global', '255', 'material', '2024-04-22 08:00:00', 'keram.Ziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2D6BC8ED-D9D4-4CA1-806E-9523965BF2CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C6C3333A-27B6-45C1-A9C8-58D013E87235}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramik-Mosaik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0071598B-15A3-4E50-A335-A2483C496AD5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikmosaik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6DB4D983-7C1D-4635-B81C-8F05DB27D7E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{21D56327-FE21-4F52-8F8E-CADECBB8BE7D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E9A8C3B-98D1-41B0-8776-8B8F1F1829AB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DA2E3849-1B94-4E18-969D-3C5C87D93797}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0A368DB0-1879-4899-AF9D-8A692069EDF2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B8F04DA1-11AA-4045-87D4-AD30B7370287}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE3C2765-8F50-4EDA-A075-2B1515995E53}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramische Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{562AFD5B-C5A8-4159-B958-28B91A7DE78C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KHLz B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E51F636-F8C1-4FDA-8C3F-705AF34E33CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kies / 674');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kieskoffer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7531F70-FB95-4DCD-86AA-3771AE309CBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klebeparkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{196F2751-ECB6-4D05-A6E6-89E78B05EBC8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kleinküche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E612A5B2-C6F2-4975-821C-98D10C8FC41B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kleinmosaik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{98336CB8-C70D-4977-B867-09F5383BE414}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinker');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9F8AEC6-BF48-4FAE-A215-84565F3A1A22}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinker-Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{77D192B5-736B-4CAC-905D-6A2E37F11063}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinker-Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4662C4E8-035F-4B9B-90CC-E68C4BC0DEBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkermwk.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9361DB32-D6E5-4A12-8260-0FCFB43270F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerriemchen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{253001AE-614E-43C5-BB35-AA191785AA91}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerriemen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A8B95938-7C89-486C-9B1D-8C9ECB8A1805}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkersichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F5686A7-78B6-445C-84FC-29CDC7DE029A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0001AB0D-E69E-4AED-B013-63A9C1252E80}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3A1B8AA-2808-489E-915D-DC5E73EA0E57}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkersteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93BA73BA-64A2-43FD-A2D7-475C05DBAFBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkervormauer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{79EA5ECE-7986-43E8-821D-CB280B634230}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkervorsatzschale');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F3C902BF-C28A-4EA3-A782-BA4357CEB466}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25621FF8-BF53-4280-968B-00556BC57F3F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klosterputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5CB0B2C0-780F-484C-80CC-79F873965516}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klosterziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA60AC1C-C255-4BD9-9D10-00207ECEF3BD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochbereich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F514BD80-E142-44E7-8F78-ECA7533273ED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{07D9390E-A856-4C61-B202-820795928A15}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochnische');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D6A5F4F5-7D11-4A31-AF04-EC9FA04E6785}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4BDA730D-9627-43BB-9CAF-41751F8299C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochstelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6C9F131A-0121-4096-B7C1-6423E4BE23C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kochzelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA5F0B33-E246-4922-AD18-3964E95DEF76}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konstruktion-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B2AF7AD1-47C0-4543-9858-868314DA6634}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konterlatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29392127-022E-4EDA-8EDD-C4A0232C7EC1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konterlatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3A3457C6-22E5-43CA-80B2-F0ED64BFC862}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konterlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEED4BF6-49F1-477A-9E4B-5F61812BC0E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konterlattung / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FFD6DEDA-A994-45C9-9D2E-15B04F4750F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kontrollschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2453B764-E90F-49DB-BC91-70696C55209D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A02FDEC5-5B41-452F-BDAB-16555A1710A2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork / 405');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B768EA5D-37B2-48D7-BAEB-D7AD401439CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B0430BA8-1EEC-49D8-9BE2-A7BAE0DEFAAA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E560B389-CF2A-4D08-B32C-44B74C230034}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FB83E087-FC1A-4D9E-8FEE-F54AD40B6A5D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{866AFAA2-3A42-453E-BE38-6FE3A6F29D84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B63ED404-96D3-4325-B112-94D8CF1D9B81}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2834FD80-6B82-41AA-8AD8-23FD4CBE90C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{34D75C35-F5AC-4F98-86E0-BA0F6940FA14}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC62DE5F-38CE-473D-ACB4-CB5D99A44D53}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D6869BA-F41A-4660-8746-E1046066ACB0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DD51D35B-FD67-4980-941E-26AFB088ADBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EF33C5AC-B715-41B4-80B2-8E9159E84C6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D1D43E4-C404-46AB-8165-877098165248}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8466C90-D97E-4A07-8B6D-F37C52764B58}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkboden-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7AA7422-3629-466B-9325-8CC81FF426B1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkdämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{80028D4B-9D90-4E3A-96F8-C1A6825D21A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{59A14B9F-DBF8-41BC-87FC-DDE93839DA07}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3F6C9D76-4B45-45AF-8F38-891FBC3D8217}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Korkplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6CAAE48D-F3E7-4C95-896A-493D10E7A8BB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ks');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3B00C761-93B2-472E-A9ED-DC797E2C84B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{15ACB5DE-3509-4C4B-8407-2541A1DBB65E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS BP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67648A2C-2A2C-454E-BDC2-16EBAB1524AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B3BEF710-4379-4B9A-A594-257F99E6B27F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7BCC7EFD-A677-4CDA-8431-CE6B8C24EE7B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS L-R P');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{490ADF78-1485-4368-A70A-2D5758B071B1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS L-R SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{26CBA128-CB60-4530-8647-23184FF4534E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS n.bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA6A4355-7300-4C24-BC68-ACAE7CD7B34D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65957822-1400-41C1-BFFA-9BCD2113927E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Plus-Planelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{20F646C3-4C89-4713-84B6-FE6007B2804B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F486D21F-EE36-47E2-9014-755C7CDB8E5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{969A0A55-2D5D-4300-89C4-09183EB927B8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Sichtm.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7BE7C75-4E3A-4A80-9E9D-CFEE30488511}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DEEEFDD1-9A76-462C-929E-513F3B665057}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Vb');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{55FEC788-5EB8-4818-A5F7-C9EE5839D200}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Vb SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC246BED-3FEF-480B-B697-2A64DF25D608}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS VbL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC18F1CD-A7CB-4F56-AC23-F79663CBBA5B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS Vm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{32FD95C8-1F5F-4965-8DF5-FDC48D9A535A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS VmL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0FE6286F-DC6E-47EB-8945-9A12786717FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS XL-PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{53A42BEE-8E97-495B-A653-B93AEA733BBD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS XL-PE SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01917345-5B14-4E7C-BD8F-C717562B9551}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS XL-Planelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2415F81B-8F27-410B-A58B-2583D48F7977}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS XL-Rasterelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{115D1D47-B6AF-4083-99A3-C5184C3C2F1B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS XL-RE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D36FC7F6-7485-40A6-844F-AA6F3E2E4E5D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Fasenstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9B54F810-DB09-43FD-A047-5AB131CEB9DB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Planstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F45EC8B-82FE-4957-9DE7-1AD10EC4DEF4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Quadro');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{993527DF-0E5B-4BD8-A791-1543F8BB6AFD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Quadro E');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{98EA6F96-ACEA-43A2-8F36-32A89C96EEB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4F9B7B5E-AA1F-4D40-B8BA-58BEAAD3E169}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-R P');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{670DDAF7-7C96-4DAD-A2D2-1E5F133B9841}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-R P SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4ECEAE8-B32F-4848-9167-10101627D949}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-R SFK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FBBE94AA-C4F2-43B6-AF23-EE0B0C719EC4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Verblender');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F00D1C61-DBD8-4D7F-A2BA-1EFB9F565148}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS-Verblendmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A331962-7D4B-47C7-92E0-A858E64C4363}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63478874-D744-47CA-AFD7-5FCC5706AAA6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küche / Essen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9D33C82-0306-46B0-9653-3E0687110422}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küche / Wohnen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{399C7211-8053-4083-8BE8-E4BB645CD24B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küchennische');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{298DDCA1-8414-4087-B2CA-81A138CC77C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küchenraumzelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2E04C589-FE72-46BC-BD8E-C060979E6321}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharz-Einstreubelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0F500F3B-380F-4874-BBF9-3BD40EB8BC20}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharz-Fliessbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDAD41E8-5035-4BD7-B9E2-311816713022}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharz-Hartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{167785CD-D5A0-4390-9709-C28E661B3EA6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharz-Hartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F0BBCE11-7AF7-4DF2-9747-B79D0BCC8C91}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharz-Mörtelbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81308FA0-594B-4C0C-B088-7C99E52C008D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52A9CDC5-2A31-410E-A250-9343E2ABDA86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharzbelag / 420');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{284A0321-7C47-471D-A0D8-047F3CA2A19F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststein, Betonwerkstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0731D62D-82AF-4DBA-8F0D-B4601EB84678}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststein, Betonwerkstein / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BC350B3-9CE7-4825-BB2B-33BFCD516FC8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststeinplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{62D18FB1-526E-4D71-831A-7B00BB6FFB5B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6D876CEB-67AB-42AE-9728-71930A20EC30}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2F6F1739-14F4-42E5-9333-791817353751}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff-Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E645CF51-F792-48F1-9DD6-7838B1A69769}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff-Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F657EDD5-05A7-4705-92C0-87C6BAE2FA54}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff-Dichtungsbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0ACE9B11-3858-4196-AB0D-46AA1BDAA88F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff-Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9A438D5D-3A27-478E-811D-DEF17E84085B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff/Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF26325A-D2FA-474D-A5C2-0AB9CA6E59C9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff/Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7B11E85-3EAB-4F8D-9E8B-3F2E8D167CAB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff/Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4685D8C6-A669-4DA0-A29B-0118F9778337}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25DBA129-9259-4E1A-AD78-ACDD644D04E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8AF0C3A-6D7C-404C-8AAC-C10FC8F568BD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8040CE96-0AB3-4978-9046-1A908A99BF41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2F823BD-1D05-4164-B6F6-C51D6630B698}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5024F7CC-1445-461E-99BD-AE3EF1F1E8D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D995C11A-EDA5-4BCE-BAD1-4DAD34B31782}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BF69BA9-5D4D-4D3F-A88E-8101553FDBC1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffbelag-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73DDDBD8-7625-41EC-A1B2-27847FD1E595}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffdichtungsbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{86DB35AC-2FE0-4F59-8588-DDAA5F2E61F3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffmetall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{54236FE2-5C14-4653-B991-4437F05E43BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B63FE963-FD37-43AE-BC31-D84D163309BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffspachtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A308454A-D81E-4F60-ABCD-A3A1A24C9F5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffspachtelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B4E9E5DD-7777-45BC-BC88-901DE1140E1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kupfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7F910534-B4FB-40F7-B609-DC34AE9F6292}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kupferblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E86B7457-4FAE-4CA5-995D-BC7D0B856C0F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8CADBAA3-3650-4812-A019-2FEEAFE44023}', 'global', '255', 'material', '2024-04-22 08:00:00', 'lakiert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0A5A17AA-FBE2-40D1-9117-5DAD3E6EE9F8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B76D45A0-2984-4821-94CF-A53FBC3A4320}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE4A5A66-B94F-47CA-AAB1-61A27C3CEDF7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A41A9CA5-0DE7-4A90-8615-11E99E46DA03}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{83E9B1A6-9CC4-4BA4-934A-B736E0A096A1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B58E4C1C-BA4C-4C3F-B868-2265E86D1F56}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{96FF1A0F-D302-4DAE-A4D9-FBD74CEE6978}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6766BC0-4FDE-43F4-BEE4-FA8F94A71F49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminat-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BCE341F9-676E-4430-9309-42730D2812BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Laminatboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{229FC656-1FE6-48A2-A361-3EAFF108B856}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Landhaustäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C87900EA-E6CE-403A-8876-4A145672EBC0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lasur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BA292C8-B9B4-4582-A928-7CE733E78E3B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Latte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{830F085F-ACC6-4142-9B5A-00C2DF73A715}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Latte-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A1ABDF75-600E-446E-984C-BC9C998E7A3B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Latten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{36F53CEB-258E-4720-8354-ECBB4CE51BF8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Latten-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B83E0EC7-6CDD-4634-97CF-E4B7E76A76D6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattenverschlag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{316A773B-97FD-4230-9C51-08065B16A225}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{75189DF2-3DA9-4BAB-AC72-BE90D5F8CE51}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FED2418A-C765-4241-AB74-560DBDF96C69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung-Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DBAF0E9F-6324-4EB8-919B-BD87D6DFD1B6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3D91C063-C76F-40D1-B77A-139FAC54C686}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD4BB187-E700-4DB5-875E-1F7B6C77703B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung-Innen / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B97289B-DCE5-4989-9DC0-863F05DBC3CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lattung/Hinterlüftung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{92EA8C90-96D1-448D-AF28-C1CE057B7AF6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'LB-HBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CC9EA840-897C-4920-AFA1-A1F86FF3E142}', 'global', '255', 'material', '2024-04-22 08:00:00', 'LB-Schallschutz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{664C17E3-FAD5-4F3E-802A-607CCAA93EE2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'LB1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5C476E3B-E05F-4AD6-9973-411631B9AEDC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'leer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3400ADD4-D23A-4FBD-A733-1369EA142F0B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leer2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B7864122-F1E6-4C00-8460-5D546493A910}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leerraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{92332AE0-269E-45C3-9939-48973DB07C6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leerschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CAB5BE4-8DD7-41D7-BCDF-476A3A244EFA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leicht-Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7734DC72-C7EC-4A9E-91D0-45D14C8F0C33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leicht-Backstein MBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29158DFB-A342-40BE-89D6-4A8587A1787F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leicht-Backstein MBLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DB2391A9-3C7B-430F-A878-94C9DBFBB9D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leicht-Porenbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{898EEA58-AB33-4CC9-A30D-9FB27581B29B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leicht-Porenbetonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06FFDC2D-167F-4A52-917F-1F34DDD14B4C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbackstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E36AF328-BF56-4B7E-A511-6A4071E600AB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbau_Ständer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbau-Scheibe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AF89323E-B0D9-47F2-94EE-8074EC19C131}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CCCE1C5F-E1ED-4801-914E-826CD5F3D4AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbeton-Hohlblock');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A5E66C5-7B5B-4CA8-A399-D597C05A173A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbeton-Wandplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD19FDBC-6B43-49D4-A97C-EF8822C4C63C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtbetonelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E8C782C1-D024-4176-AFC3-F46A89D8F6EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichthochlochziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1CA5C230-B720-4CA9-9749-B4A9CF2DF020}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtmetall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18BE6BC5-3680-4F42-A01D-7095B5C0F010}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leimfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F3BA5AD3-8E9B-4E72-BA51-ED36EF8A5C4E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leinen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDC85A3A-42CB-4C19-8959-3CF5E0387BE1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'LHLzW');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4C68B3CA-0B0E-46FF-B59B-8F05ADC806EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lichtband');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C95DEA8-1B4D-45CA-89E7-C21AA5A2E2DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lichtkuppel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{91CA3C8A-8206-43BE-B0B3-5077DC543593}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Limestone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FB7BAA79-066B-483C-84BE-505032BED4E2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35BECE8C-67E4-4524-A60D-84CCF812C1B7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8FDD1CB2-A33B-423F-9ACE-519E2275BF44}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{94FBBB36-FB63-43D0-8CAA-8B233F0FC355}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{24A9220A-E646-4468-AC61-4B2B286127EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EF9AF865-B7B3-4ED1-8020-3F2077276839}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{025A9B9D-B2F7-4F22-A35B-265EF449EDCA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{081BA7A0-E748-4684-A3E8-CF610E394C41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7DFF161B-CA8B-4327-9B17-8298D8388AE9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linol-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCE05644-168E-4C92-A8E5-109452D0C23C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{619B7D69-DCAF-4EC9-A14B-DCDA64A5448C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{47EA1F18-8D56-45A3-9142-273893540977}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA8D5799-F219-4BA7-989A-DDB1A704A0F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BE60A01C-E274-45A1-862B-2F1693242A5F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4502CC9-6C63-4509-88D8-1D5F3492F6EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5EF426BB-0D6A-4B98-9646-8B4FA085791F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DAFE732C-E1F5-4061-B296-6E3AC98840E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Linoleum-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56D5EFFF-16E4-41AE-9AEA-BDF48C2BCC49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CAA9BB07-84D1-4E93-A3E1-7F96C696895C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft / Holzlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{547BC560-3238-46D4-AFF2-D041809D4E2D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BA3889C9-C4DB-46A4-9C7B-8FCC35EF9A85}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft, horizontal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BF85DDB2-F06D-46F0-849C-41968B46AFA4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft, horizontal / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9AD18FBA-3AE1-46D5-91FE-9B40F73B903A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft, vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{07E62B4B-0D5B-41A6-A958-55069FC66F0F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luft, vertikal / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A56842B-6A11-4CE6-A761-5638DF6AA0F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luftraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C6B1EAFA-1D56-4E99-B329-1427A159FB64}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luftschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93E9EF92-60F4-4E26-B7A1-CB669F0EFF69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luftschicht vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8B6209D9-6734-4B5A-97FF-4D26EFA334F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Luftschicht, vertikal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B8AB0639-F900-4C70-88B0-C468B81D1A6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lukarnenschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{40501B63-59EE-4DF5-9F43-9B6AA0FA624C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lukarnenverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{37497C36-0319-4960-BF01-D10271D579C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'M.Stw.GKB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7CF6DC62-16EC-49E2-8D71-EAD4291627C9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'M.Stw.GKF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{154865CF-D3B8-4A84-A79C-B08982857291}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magerbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58EA0674-6004-4FDC-9F7F-90C27B1A2C16}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magerbeton / 730');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6989478E-8B86-419B-B086-48F87549B194}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magnesiabelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DA041090-18BC-4CF8-80DA-87D9AE5B4305}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magnetdeckputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5AFB18E-C81E-4F07-BC4F-DD067482D851}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magnetputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6E98307B-2E70-4F10-ADA7-F585BAB4E63A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'mantelbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29F14CF4-9731-49F5-AE2C-CB5101DB6DA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Markise');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81D6B700-E328-4DF9-AACB-3A5DC32468CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E7E9B55F-6F6B-4DA2-BD14-8B593A78802A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B615CA3-A034-4226-8EAE-AD3B0B2F073C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45E1EA4A-7784-4169-8E80-57A3DEAD89D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F292AF37-2A31-4DC0-946D-4FC5BE8764F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A74BF2B0-DF8E-4C3C-BEAC-88CE1B059C9F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{78B6E665-CA7E-4687-ABDD-8E9FB0D1F8AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmor-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{16DD0D52-AD64-4104-91AF-B020E3566B30}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmorplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9FC75224-A3C1-4E4F-8539-68FCC2564CEF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Marmorplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18E0E3FB-2306-405E-B276-61A799856480}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B94AD0A-5DF4-451F-9A46-8479F332CF56}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massiv-Holz-Mauer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC502D3B-298D-4C74-864B-BD1513EBD106}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B6DC91B1-EB09-472E-8C60-452C30D554E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivholz verleimt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4A49EA5C-BC01-4454-85CD-14639EF6EB45}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5C3FF34-B113-4D18-AD91-877E21E7FAC7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C8900B71-5E9D-4502-B39D-CA741FCE592F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1329F312-488A-4C67-9D0F-DC5A66F4B75D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0CB2B68-692D-4D91-B803-A7E33B383FFD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B306FB9F-1FB3-45EC-85B6-066679776784}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC68A852-254C-42F9-96FD-D0E3A9753A6F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E283BA25-C1BF-46C6-BD0D-0BB9A2AED737}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Massivparkett-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9ECEA7E8-4160-4C7F-85EF-E393FC92F55B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mauerwerk - Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4606337-0F6B-4CE0-8233-CF3CEB9F7E0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mauerziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5B8FD02F-11A6-4705-BC48-E381DAB592FA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{267F55C6-0A35-45A3-84FA-57FB59AAB64A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MB bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EAD37732-8EEE-41E2-B432-0A42D0FA4823}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MB n.bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{350EFAF6-0147-4A2A-8325-948BE1F58A88}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MB nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0A4D9F0C-EFEF-4138-8EF9-1BA86273477E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MB Sicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{43808B34-1D70-4E6B-8C5D-C908E1207BBC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MBD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D25BF7EF-F9F5-4088-BFE0-78FC3F47F782}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DBF095A-8DF2-4466-957F-71EB0992CBD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MBLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{884DD3B4-7661-46B7-BBF7-1A74A03EA701}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{215309D5-FDF6-4BB2-99DA-212E91DF855E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MC bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FBAFC16F-B990-45BC-BD1B-4C55BE9D3B90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MC n.bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D4855FB-2E95-4A00-84CC-73A0DE1EE4BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MC nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{934E3914-0C69-47E7-81A7-D44A23B9F8E2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MCD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ACC38D44-3001-42B6-B348-D402F89E7B35}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MDF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1400C179-749E-44CE-8820-A1F32E6B6933}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mehrschicht-Dämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6A892FB7-ABBC-4A8C-9616-2518130A7A15}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mehrschicht-Dämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D60CC148-6A78-4C25-9773-BC0937F1B36B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Met.2-f.Stw.Gp.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{449FD875-004A-4E0F-9D62-3D860E2A5B17}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Met.Stw.Gp');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{15B6DC31-7DC7-47B5-8334-EE13872ADA80}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ECE86A28-09EC-41D3-8397-60A9F503C64E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Chrom');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27B21E5D-D8AA-4803-A6F9-83DD0EB67073}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Edelstahl, poliert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F7A7DF47-8D93-418B-9092-B08B54CD6E96}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Kupfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{325F877E-F536-4749-9824-F932D296DDC8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Paneel, Kupfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{084487FB-0B09-45EB-B643-76AFD661A056}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Profil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6C13989D-6FF3-4D24-884A-1DC9B4CD3C9F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE496009-EB7A-46CC-9A2E-6FB5490DCB8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall - Trapezblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9B07AF1B-B1E3-4313-9812-A3CA4D7B5BC3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall Aluminium, matt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{116D11C0-C669-43C4-81F3-F5036F6C72E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall Kupfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AE4CDFDC-8AC2-4565-8030-E0310D98F2C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall TitanZink');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1507B7FA-2597-4250-90F0-74FD889F5AB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall Unterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E935BAFF-4E2B-4DD0-82BC-92B4F6992C34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall-Unterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9FF374C-0D82-4938-AAD4-210ABD2BF187}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall, Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F205CC7-B910-42BF-8CA8-9DC801C971B5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall, Aluminium / 910');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2DAA01C-D4A7-49A4-BA03-DEA83FF2BC77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall, Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{348DD50B-0295-4EE0-AFED-E3E6B04BE5C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall, Stahl / 900');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56877A49-7294-4D30-8B26-E9630208151B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall, Unterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{695626CB-F118-4B19-A2F2-BC3057EE7E34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metalldecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF556654-C3AD-4E33-8548-5D817EF6841E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallpaneele');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0FF35FE6-7792-4503-A92C-EC6288CFD689}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6EDB39EE-B5DA-423F-89CA-5B5B1E3E4091}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{277BEA66-484D-4C66-9553-065640387938}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallplatten profiliert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F775933E-1D3E-440D-8EF6-4A44E6B02683}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6EB081D-E1E9-4F24-8EDB-920B10332EBA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B5511FB-E3B6-48D7-97E8-76CC4DE5C607}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metalltrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EC7E571E-B222-4EC3-B768-0961A0511F04}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallunterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{13D9DE86-A75E-493F-9858-08D28262B75B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{429DA01E-9986-45BA-9398-6E17FFE2F731}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallverkleidung / 940');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D19045F-7BB9-46F9-8104-094BBB4DEB5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Methylmethacrylat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97D6CD7C-2616-4740-9EE3-D5737153F0A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Methylmethacrylat-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D15DFD35-A7E5-4382-84AA-144003FC28CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MHM');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01EBF9FB-0436-4893-A9CF-825537D060C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mineralfaser');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FA145FF-F02B-432E-B5B5-2C76CF79E194}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mineralischer Putz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{87A5EB36-7DDD-481E-A06A-254FC3C1C024}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mineralölabscheider');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9E2B16D0-870D-4322-B608-ABE574E904A3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mineralwollplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6B86C878-3C6D-47C6-B09C-B60F1F0C2773}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mitteldichte Faserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{44AA48B3-2740-49D9-BBBB-49807A35E3A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mitteldichte Holzfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E09B925F-D8C2-424D-9DC9-8B7B6AD724D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mittelmosaik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9C764258-C639-49C2-A805-363322294EFE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AFA6EEB7-310C-4465-B1EA-4AA10EC1BA87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MK n.bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{037CF6E8-ECF2-417E-B68D-57918021D4F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MK nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EA347B62-ED48-4219-928A-2A2B2EF2AE0F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MKD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5ECD45BD-9224-4887-95CF-8C563ADC74AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Monobeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EAA22D0F-81EE-4591-BF0C-255A731A8EDF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mörtel wasserdicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{04933A42-D479-48BB-8600-779687B4B58C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mörtelbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2D8BE6EA-9A3D-4958-9615-30A9030B57C9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mosaik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1A1A2F9D-A29F-4400-94DC-1DB046FAE7E3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9853AD2D-7CB3-4EB6-BBDE-66C3E6705A41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MPD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D203C57A-DC68-4FE8-A059-F3E9B08AEB03}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MPL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65F2DF6C-FB63-4C85-A621-0E1793B8C0AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MW, Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63876025-0C7D-4B0A-90A8-C8F5061DBDA1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MW, Backstein, Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BEA27C7D-5194-4655-90C7-ECC5EB8159F1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MW, Kalksandstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D8F69BA1-10B6-40AB-B13B-B238718042EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MW, Leichtbackstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5744DA90-E0B1-4821-866D-2252A08D46E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MW, Zementstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5C5DFCC-8222-4405-B0A9-423D9360AE6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'MZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD04DD60-BD21-489D-A1FE-8F8AE47E2F51}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Nadelvlies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{169ADF23-2470-495E-AEEA-313F7D477742}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturharzdispersion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B45DE141-D833-48BC-AE9B-B17E818294DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturharzöllack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58A5B3F5-8881-4E6A-BCA1-FBD5E2DE1B88}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein - Kies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3AB33292-A394-46D1-B65A-E34028EA5704}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein - Treppe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9810A067-707A-4EB1-A750-50C054870234}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BBB8A0DE-C32B-41BB-B87A-D240D8B1D049}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein allgemein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70C69577-B0CB-491F-B7EA-EA8FCCDE6AA8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein Kalkstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E70245F-F0AE-4743-9BCE-F68C652BBF9F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3CBFADF7-128F-4391-93E8-20694002C24B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C19C51B6-9ACF-4081-A2AE-98DB707AC68C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC365583-C36F-441C-9EE1-921167CF5A78}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{79805E76-F834-4013-B248-5366C5F43A2A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3E22F62-A8EF-4C12-AF47-C4EDBF458E5B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31F24EEA-D478-4CEB-882C-72ACFEF26823}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Natursteinplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Natursteinplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC84551F-7A7F-4701-939F-5FD939FAC340}', 'global', '255', 'material', '2024-04-22 08:00:00', 'neu gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4FB7DEB7-4EF9-471D-936B-CFEFDF74BD41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'neu tapeziert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3A029AE4-ADF8-44CF-AD6E-C38AAD57A3B1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NF Ziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F161BC4B-3677-438E-B5D3-D263082173E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppen-Bahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14878589-AC28-48BE-B2E7-A6C16E277486}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppenbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D67763B-A405-440A-A35E-B2ED0AD9947E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppenbahnen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{79ABACA6-65F3-4E8C-AB86-AE2103206224}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppenfolie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97301D60-40C9-4B64-AD75-162554953672}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppenmatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{34DA8D95-362F-4BFC-8D67-2C3B14F65700}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK A');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5FB22FB4-EA56-490B-8182-E5EC61D484B4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{939FD42A-01D2-4CB3-A905-2F609F04A6DE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK C');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ECFD050E-5342-4775-96DC-AE534E068416}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK D');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD9F3528-6023-4E91-A2EC-7806EDA3F102}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK E');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3FBC26BF-C723-461D-AA84-EAEEE0565815}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F286E636-E65E-44BA-9B2E-2D118EC7D1AC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'NPK G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0E454439-4731-491D-8264-E92FF5C7522E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Oberlicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{815F799F-68A4-4818-B0BF-E5BEF37C0D5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Oelfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1167B778-4AA5-4843-A6AB-03C95B48BC70}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Oellasur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27CD7BC9-32BB-430F-B897-E52C32489FCF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'OSB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'OSB Platte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5F28321F-26B4-483F-99BD-5FC51BD33960}', 'global', '255', 'material', '2024-04-22 08:00:00', 'OSB-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E57B29C6-080F-4A2E-9D18-D1555743B636}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Paneelen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{545FF061-953D-47D7-B30F-127F3F97837A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Papierwandbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DE79FD5-E185-421C-9C36-A5567CA64525}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{19768296-27A2-4F6E-89C3-E1D2B93B37B4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{49260ED6-1EC9-465F-8611-05932F81E207}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC5680B8-0A76-4226-8522-4D29B736E971}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{389C0071-2365-4889-A721-43A223110955}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED2D5102-0D31-452F-BD1A-EE743718A309}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7650A7B9-AFCF-4CBA-B33C-EFC1F7F73A0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5B6D3BFB-6392-452E-9CB3-346BF28C8596}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkett-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3D524258-9D7A-49B3-830F-20576A161813}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Parkettboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{92AA9062-3F81-4125-9775-E79164DB4667}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pavatex');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EC4DA7AD-63AC-4B75-8C9C-6151FFEDE722}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pavatherm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{369B7C01-C87D-41A3-9E2C-D725DEA5AFBC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PD EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1E52917-5A80-4CC9-93BE-1F0ECDBD7233}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PD Schaumglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{660C88E5-BD92-4C06-BF47-19BEEA80C1D3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PD Schaumglasplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A48575D-A0F1-4991-A0DB-DB29F915BDF0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PD XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BFBBA9DD-A9EB-4FFA-84CA-5A7C8D42C82B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73595AC8-EC0A-4A3A-9E4E-3D619F10F244}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PE-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BEFD037E-ABE4-4336-B407-889E9D487D00}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PE-Rohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48ACC5F2-5E35-4F78-B2B4-1992A2BF6957}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PE-Rohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B105E0A9-96A5-41BF-A5D9-D2E24A1C1897}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PE-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F8F3C272-241F-4888-9716-D33B3B4793C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeter-Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{09B8B6D2-305C-42E7-B9F9-8F4A60D1DA45}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeter-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{76643463-6D7B-4496-985D-88D2B2FB5612}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeterdaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD8A58FD-9606-49AA-A057-A95DFC80C78F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeterdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25941452-8376-4D3E-8A3C-38070B4D8ECF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeterdämmung / 755');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9C502AC-F2E6-4D0B-BEC3-127411D2AFD5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Perimeterdämmung / 757');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{803BCB4F-86A2-489E-AF7A-1EFF535F7A1C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfannenziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8B3D72F8-CA5C-4350-BCAA-972C10BFBAD6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflanzen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{129C23CA-866D-4B3F-8D90-6BEE8591B7AB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflasterstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1FF0B020-3237-4EFB-B411-9D1DC3217D5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflasterstein / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2E2571FC-3834-467A-9D67-836F6E8A0E0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflastersteine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{768E22B9-4F48-4800-BC3F-763155B4375A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflästerung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{21EBF8A2-007C-4B69-88A7-B637F4F92373}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{95DB5753-1850-4A78-BF27-38398479003E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten-Riegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3B37F528-C350-4160-A195-53899B4D01C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten-Riegel-Konstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{553BA438-2E77-4D60-9D0F-2F504CE63B1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten/Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4707B74B-3F1D-4A70-8DBA-673BAC86395E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten/Riegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{092BF66B-812F-423B-989B-D275F6AAB7E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PFZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{109D7DDE-D317-4141-B8EB-18448956DCF5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Planblock PPW');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5963F8F-AA83-4F40-82B8-D1CA4051EA34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Planfüllziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E23F8A51-D5CD-40D1-BC00-2EECC7D2A8AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Planziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C34150AB-E8DD-468A-92EE-5E05090FB323}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5EBA1CF0-581D-4897-8CDE-CE90D68377A6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten 20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67CAB312-7403-44FB-8D6A-7502AFEAFBBB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten 50cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD3E6779-5C98-4490-883D-617C7495AD7A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ECD3CF2B-F0A4-4394-A759-9BE34A977191}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{78F07F35-6307-47C3-9B38-54BBD028B6C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58F2BF9E-0C0C-4E60-A272-E9E41F9FB2B4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB793CBF-AF17-464A-8A40-9DF29BED9C2B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten Sanitär');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{40CF6403-1651-4BEC-8087-723CDDD30BBC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten Treppe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C1C3B3AE-A8D2-4E8A-9447-B14E2CE08949}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Platten-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{458B0053-FF8E-482B-92FB-12A5F6647580}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattendecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{80F37F2B-3C2D-4F1D-92D3-B720988F5488}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C5BA4C9C-C457-47E2-B374-5E184B86F9DA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenmauerwerk Betonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F41E219-3D8E-4D93-A06B-B327AC9EEC49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenmauerwerk Zementstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C39BDFA1-55CE-4468-ABDA-5FFA1CF781CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BECFEE7B-F9C1-4865-9C91-900BDAE934B8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plättli');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B23DDA7-57DD-4AD5-BE8D-BFDCCC312A5E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plättli neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B06591A1-B8DA-4EDA-9477-4C13288BF05E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plättli saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{21480C67-E303-4218-9ECC-515BFC2A0914}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PLZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9A51E69-CE02-4F28-963F-DD2496BF969F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polvlies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{251F2D0D-9A74-45FA-B287-1799CD4B76F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4F6BBF66-4EF9-4547-9DD9-540F025C11F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylen-Sickerrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4737459-ECB1-4422-8AC1-A086699192BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylen-Sickerrohr PE-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B4A4B8C6-68C1-4811-BAF8-B463857FC219}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylen-Sickerrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{243EFA37-DDBA-457C-BDE5-613D224157E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylen-Sickerrohre PE-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52DC750C-A3C2-485F-9529-2079C09A6C8D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylenrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{015056D8-1993-40D3-9028-22B737ADF0DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylenrohr PE-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{165FA69B-7750-4ADC-9FAF-D5089A361C2E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylenrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D5E8572E-4BAA-4DAF-B406-D3D7DFCF24CF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyethylenrohre PE-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ABEFEE75-718B-4E51-8B41-539D2019D0C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymer-Bitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E9F7F0B-4AAD-4E16-AAE0-F0DFC8DB83EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymer-Bitumenbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD089977-55FB-4903-A94A-A157B9832E8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymerbitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D27ED6B0-D5AD-4FC2-99DE-99F4D558582D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymerbitumen-Bahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D792D039-7637-435D-A0C3-DC88EA43F674}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymerbitumen-Dichtungsbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7E7E0A43-9E9F-48E0-951F-C0DC3125C273}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polymerisatharzfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CF6085A-EF6D-4B0D-9A43-B5016ABBF4D4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{68EE78E0-950B-4866-9D05-91180C12EA58}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylen-Sickerrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9E8C6D0-6E3C-4AE9-BEBE-A65BF3A8D0D5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylen-Sickerrohr PP-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC222062-4D81-4A9D-9C35-DDDFB78E7C24}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylen-Sickerrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE46D8B2-7476-4AB2-A8F1-3876376FFFF4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylen-Sickerrohre PP-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB69E835-0EEB-452F-AB9F-9F69C3E7767A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylenrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D291F356-8759-4C7D-8B15-FB3B0A8AE10C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylenrohr PP-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9C1704C2-FA0F-44B7-BD2C-3186F1F94178}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylenrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BAC6EE0D-15CE-4B85-99B4-AE5473DC811D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polypropylenrohre PP-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1C02B22C-96C3-45E5-81C2-60DEA512B67C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polystyroplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EB7B0BE-2846-49FF-85F5-E73E69200523}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyurethanharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{24ACDC2C-762C-492F-9348-2840F618568F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyurethanharzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{266A276A-26EA-48BA-90DF-221D85EBA343}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyurethanlack');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4BF5F9A7-999A-44FD-9215-93B74DB55957}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Polyvinilchlorid');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B9D7C6E0-8CDD-4B89-86FB-A988A66FC841}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbet.Verb.ST');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A185C41B-6B21-4150-8EB0-16382E0D55C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbeton-Verbundstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CFA084DE-2FA3-4A64-AD27-B9AFA8EED01F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbeton-Wandplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{470D6786-E8DA-47E4-9577-8AD49D00708D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbetonelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCD9318A-A44A-4651-8B36-2C58593B8E83}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbetonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{102AED3F-6DC8-4DCA-832B-F47DE6160873}', 'global', '255', 'material', '2024-04-22 08:00:00', 'POROTHERM');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{13A473B8-C0D8-4EDD-94EA-5C20F79B83EC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'POROTHERM SBZ.i Plan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{770C99AB-1889-48C9-8735-8CBA02404D87}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Poroton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3DA4E40-8C4F-4636-A491-DEB64F2772A7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{54A8C603-63F8-4B6F-8928-4EFC2678A002}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PP-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4CC88CB-D630-417C-8E9F-E6C3C1FBDFE2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PP-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0EF630C1-D179-435D-84D8-B7959A676B94}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PPEW');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD20526D-8406-49BC-8CA3-97C3AE03FDD6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PPN');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9711DF1-3434-46CA-98FA-79DBE838009B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PPpl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2C649729-53D8-4CC6-BA82-86BC4BB96421}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PPSW');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6EE0A71A-8763-4C9B-B22C-80B7D4042E77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PPW');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6E1530D0-4BED-4531-9D4D-C8B95EE80FDB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Preton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C888FC5A-8D78-4668-B26A-ED578B798D72}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profil-Holz-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14B38291-E4A4-4CD6-A119-67E59232CD40}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profilblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A12CFDFF-5285-457D-9551-F0014E8181BD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profilholz-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D329FFB5-267C-4190-BBAC-0F948723A5E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profilholzelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{739F0247-BF6F-406A-A45F-FDEC5B04E0EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profilierte Metallplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CBCD2AB5-A3BF-443D-ADFB-772950B20F89}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Profilrost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7C08C49A-4DE3-43B5-BA1F-BEFBB53E072A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B835B0E1-4558-4519-B7C8-9DA34169D483}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pumpenschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{894FC435-DDFD-43DF-8E35-2B8D5D45BFD6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0208A676-3331-410F-91B3-A53B2AF070D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putz wassericht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7AADE7C8-1DB2-45AC-B380-1CAF5CD427E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putzträger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6682226D-0B08-4C35-9B28-7C50C5389A14}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putzträgerplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF8E7AF2-BD73-46E6-8B19-7F403B53F35D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putzträgerplatte hinterlüftet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{197873F6-E769-40FA-A2A5-4236E0987AD3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CBBDA334-343C-423E-B87F-26DC012BD051}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-Rohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED9E6FC5-4777-484E-B601-3CDB1AEBFC68}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-Rohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{597F1C73-478A-4E99-9022-7BA692C9E905}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-Sickerleitung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D767FC27-356D-4A19-8404-1ADAB9709D9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-Sickerrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{94C9AB27-ACF4-4DE4-B1EF-5C0317CD1AF1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-Sickerrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{22E96804-A1D8-41F7-81FA-8DF948CC5636}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-U-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DDCF6B1-9A08-417F-BBFC-89A870C67CA4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'PVC-U-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4EA3C08F-AC4A-4DA4-B6BD-C52564E21C2D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Quarzith');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{23C49DB1-1EC5-404E-B1CF-597C7EEAB234}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Quarzithplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B03BF4A4-B9E8-40D1-A7CA-CFD5DCB8C5FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Quarzithplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E1238352-29B6-48CF-8EF4-C1A3834281D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Quattro-Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35659FF6-B868-4D54-B1E6-D1F07BCD049F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Querlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C468FF4F-6BFB-4FAB-AD01-19A3662E7AAA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Querlattung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AEDF15FB-4BF0-4175-BA79-CDF7D8ED3989}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rahmen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{74B3A49D-C985-4579-A6C2-0D14F720C847}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rasen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63D41082-CCF1-4A3B-BAF6-576C04DB69EA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rasen / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0276211A-BEFB-4432-86B7-48FD21F64573}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Raufaser');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3FCB313F-17A2-4B83-B5B8-B8AE7BFAA8E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Raufaserpapier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC76EDBF-504B-4EC2-8A05-12F885700F2F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rechteckschiefer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B2CAD27-6544-4F3B-BB8F-993C2F2FEEF9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Recycling-Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CEDE3AC6-EF25-427A-B0B2-A953BD5DCE39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Recyclingbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{461AFBA3-CB2F-4A38-9544-9FE8C7B1CEFF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Recyclingkies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4164EA41-A33A-4167-AB7E-92AFA8F128D3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Riegelwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{010019A2-A0B2-404B-BA86-56F2DA8C2878}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Riemen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D50A602B-AB65-43E8-B1B0-AC7CE0240181}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Riemenboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{62E0F9BA-E14F-4DED-AD9F-3D9B6A44D91B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rigidur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5388106C-A36B-45A8-B0AA-57A5E3FDEB20}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rigips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{816D3731-4453-43D1-A5E2-DBDF8DC94C39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rigips2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{824F0081-AE28-4664-B6D6-31AD4CC22BAA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rippenelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{72E4AEF3-B74F-4E10-8E6F-ACFF085CBB3C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Roh');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9858FBB-2D58-462A-95F2-3DDB4880A5BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'roh gestr.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BE6D4B3E-FD8B-4EDD-B401-DAF6E72A307D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Roh gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CEB569A5-D367-4A75-AEAD-51F1FA3167B7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Roh/gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CBDFDBF0-3F70-4998-B5F3-3B516812FFCA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rollierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0ECDE985-4339-4321-9A65-FBC4DE9E21F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rollrasen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{563F3B68-1748-43C5-B638-0B3D7CF2BF62}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rost');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F74CADE4-2118-4182-B57B-B8FF3A55EDC1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rundkies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{19A06F69-F366-4F54-9552-AC6718ACF661}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rundprofiltäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3AA81746-338E-40E2-A2BF-4A1BFEE2ED63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B8D3039-5BFA-4344-A892-74B809996DD7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sanitärtrennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3995491D-D4DA-4D86-BDAA-2FF9B63F7B20}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Santro');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{62991E1B-D512-411B-9AAB-2C18EA008384}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sarnafil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sauberkeitsschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3CF35A2-BD31-4923-8A01-B67B1F5FBA62}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{07C81235-AF4F-4397-A1AB-B770527A3FCA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBK 1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B2872EB8-71A9-413F-B324-C8F72CD09C74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBK 2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3557CA5-5A80-4703-8F95-06BA5D58BD1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBK 3');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67330277-CC75-452F-84A9-8AAFC776AAC9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBK S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A2CBB18E-0E70-4413-9242-1945C73C4935}', 'global', '255', 'material', '2024-04-22 08:00:00', 'SBR');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4B3D42C-39EE-4AC6-AD19-7814A2850425}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schallabsorbierende Wandpaneele');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D20FFAAF-DD73-43A3-AB76-3715E3E85371}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6087B2E7-BC79-427B-AF3C-458114039055}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldämmpaneele');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{035990DB-C856-4836-AFD5-B7F36A078680}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldämmplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{51B7E1B3-2885-432F-99D4-7B399A3E6AA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A2DED2AD-1EBA-4F92-8948-40884C11AEBF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldämmung / 500');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E18D5849-7863-409E-A790-3BD1D7AD2796}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalldämmung / 510');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{300D93C9-1696-4F53-8FD8-74CCC6FBBC85}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schallschutzziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35F80E9A-869E-4FCF-BFBC-D68231281552}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B0ABDF7B-247F-408B-8C6D-2C54B42561B5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalungen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C85DA4DA-6FF0-4A2B-B76F-A07BD3A0FC5F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schalungs-Betonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{96B9CF73-4977-409D-A27B-ACB251CE2C3E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schattenfugtäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1BC30DFD-2B2D-4D8C-AAF5-4F5CCA44FBE7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schaumglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E09D8AC5-B817-4994-9CE0-7EFAB2FD6975}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schaumglasplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9755C4B-5C75-4D2D-BF72-0921982DB1D6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schichtex');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A2EA0D58-EAC0-4484-B1D6-73403A698B67}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiebewand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35C7B94D-CA6C-48ED-952A-B282B4BA2673}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CE05F37-6B8A-4521-9DB0-8776D437EEEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9336A9D3-6FBB-43CE-845C-E3AFDA7B91F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{239FCD26-EF3A-4C59-BEEB-194D0A745F46}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DF97B188-32DE-455D-859C-06456B672309}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2077D467-0298-4F79-8374-8E75300996E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E8A6D207-99DC-4568-8A0E-5037B0CB7D1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiefer-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{338F78F4-99AF-48D7-96DB-51D4993F3C9B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schieferplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{392BC9EE-A6B7-4AF2-827E-9FB4BAED4EDB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schieferplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD808C70-C14A-4562-92EF-A38EF363195A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiftlattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{20657590-C620-486A-9BBF-5B4723CDC9CA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schiftlattung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5F7A8ACF-1C44-46C8-B2CF-60E5BD79C51A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schilfrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{03170400-4CA2-4C56-9A7F-A785CA60CA11}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schilfrohrdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5C276057-AAA5-4EFC-98C9-006FB277F887}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schlämmputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06EE1650-FF12-4FC7-9C56-6379F6106222}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schlammsammler');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35E79C68-FDBD-4E93-B6A8-FBDCBDEA1CDD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schlämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{906E136A-4EA3-4414-B847-951F9475FD9A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schlingenpolteppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52BBD30B-6E9D-47FF-9FDF-EADEB174B645}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzfang');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{86D2A1E0-8E58-41B2-8078-6F69E3B9E969}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzfangmatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4AFD89BA-1F99-4C04-87F7-940E6AE947E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzfangteppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{965525C1-6327-429C-BB05-50A48E5C0505}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzschleuse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D5028E47-9D89-4ED0-BBEB-F62023B8EB64}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzschleusenteppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C9F1218C-9DF9-42CC-A130-281F1CA33E5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzteppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EC443148-F77B-4C83-A28E-B8666DFDD5EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzwasserleitung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF14AA4C-5E5E-4188-8645-B4A635E271AB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schnell-Zementestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E6438141-35D3-4538-B458-0A08F9CD3CDF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schnell-Zementestrich CT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D74C95DD-B621-42CD-931A-D880CB17E263}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schnittpolteppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6AFE65A5-ED5B-4BEF-B88B-1F496798485A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schotter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3090D571-3B41-46BF-9522-F0C8E2128529}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schutzbeschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A11BBB5B-4A73-4E2A-A6FB-CFC047C7EE1E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schutzmatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60C8728E-5711-4117-B619-61428FCFBA6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schwarzanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B2525947-231A-420E-BC85-DA38E251F648}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schwimmender Unterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FB3ED15F-1019-40E2-9C90-DA17C6D4CEE2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sicht KS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5088E5F2-3E3D-4D64-B1F6-26FA45554916}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sicht MB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AF49F7CB-1725-409B-9C3F-8B22AF7DB142}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sicht ZS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F94BDD00-67CF-48D5-B253-DEE3AC5B2A11}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbackstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0354D5B7-0694-4EA0-B6F8-5289CD9BCC3A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbackstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0F80F3A0-0F74-479E-9209-E346E2A48744}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbacksteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8FCE5383-58E0-42D2-A839-3339A4CDC440}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5D12830C-86AF-4457-AE07-742E53337813}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbeton-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2565AD1D-6160-41B8-AC97-C72B4F9D6969}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbetonelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BADF56DF-9170-4F6F-9737-96F14EDC187F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtkalksandst.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6ED12D39-7307-4B7C-95E5-EBAC9FB21BEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtkalksandstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B2827D17-4BE9-4D0E-8828-431CDB4C68A3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtmauerwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B174DFA3-14F3-4F72-9221-2EAA16E09044}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DDEA4183-BAA2-4058-9606-71A52364F0A3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtsteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{23258567-FFC4-431E-9FB3-EE0B947060EE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtzementst.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{343E6211-72C9-4556-B8BC-7980014FF4EC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtzementstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B531B72E-8EF3-43A7-8692-7914EE5AAD6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtziegelstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A2E47E30-75C0-4C24-9FA5-0AC629E7264D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtziegelsteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C22BE2DE-3AA9-4D1D-A734-8A6C0C493F41}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE5B8F7B-9D80-45B2-9782-AA7FA2B9BF2D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerleitung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DCB6DAF8-807D-4868-923F-347B50645B74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{041134DD-3107-41C5-B4E4-535F72673B40}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerplatte / 760');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DEC42027-148F-4085-8FD4-B0769791F2BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{765177E7-ABEF-4611-ADD9-74B492BA352B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerrohr PVC-U-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{46D955EF-D20F-4909-AEF3-5A6A882E62A8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerrohre PVC-U-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EB83C433-E79D-44F2-B109-356AA487F6FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E83A163E-3F1B-4CE6-8A2D-8CAD55377369}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Silicatputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97936607-C025-4B79-9BCE-DE8BE8FBDF54}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Siliconharzputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{37EA8C06-6A79-44F1-B5A2-B653C85111E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C70721A5-BE5D-4C15-95AC-05BE4EE39494}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AFF84FF8-1CB1-4FA9-BBF4-86D408D3FA36}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{90FBA2BF-3EFF-4274-B538-A8D0892AE4AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48800E42-4842-443C-81DA-57F4E7CC1718}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{07543FFB-BB05-4D8A-BAC8-6C6913D67B59}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{54190888-CC5E-487B-94C3-849505B1B398}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Solnhofer-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B3C40AAD-DF07-4A8D-9AA7-3E288A125CFB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sonnenkollektor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1856BDC9-FDBC-4C69-93C8-918422B0FA23}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spachtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8325B93B-BC7D-4C16-87B4-B01AC7D5030A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spachtel-Überzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F04735A3-D4C5-4864-AC68-D03D42C74925}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spachtelüberzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ADC382FC-BA7B-4206-ABB2-1AB33E24E300}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatte / 560');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3A88F034-3971-4F5D-AED4-00EA19AC7277}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatte furniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7B102907-228F-4E89-89BB-9B498EF1541A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatte-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3EE25F9D-B49E-487C-A3B1-56DAA7D0A620}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3DE1AA4-8306-4063-8772-DC8168E4A3B2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatten furniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D12A8BC0-8C59-4667-A619-CDF803A5187E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spanplatten-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D714135-EAAF-429C-BF5C-11B8ED973DAB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9BA76771-C779-4C74-A151-854471B1C409}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrbeton / 750');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{390BCFC2-5749-4AE7-9180-37B41C34A229}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{26D73B71-AFFD-4053-9147-CC1FBB0C0A0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrholzplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3CAC208-E3F4-4E8C-A23F-B10B1F65062B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrholzplatte / 560');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{031AD4D6-6C29-4D81-902F-B7915F0EFAFE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrholzplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A33136B7-6DF1-483F-A416-AC920F9CB18E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC3C0C84-7E79-430A-AEC8-67EF04CF145F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2ADAF7EB-9074-433E-A235-F3D385C6DC3A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrschicht, eng');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3074D51B-2647-42F4-B045-702459A7D696}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrschicht, eng / 800');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{481E685E-3700-40C9-9700-D89A910D13C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrschicht, weit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F9DE969-726B-4CAD-9F16-F7FDE60B19AA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sperrschicht, weit / 800');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4E514C6-5AEC-44C6-8871-5C494F63716B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Splitt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{305C18E5-8860-4C29-BD46-8E38E9241F91}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Splittschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F3BE5972-4879-4A18-98B7-EA54BE1DEABE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Spritz-Akustikputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{44A33F96-33A3-4CD5-8588-780E7A15DCD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Staender_Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{940F55D6-80CE-4A05-845C-2268C9986246}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Staender-Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{96DC5B54-9BE1-4D83-864B-B2123638C7ED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahlbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FFA9AAFA-59F9-4C35-B477-8A47C80674EC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahlbeton - Fertigbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C22065D8-9875-4200-BD06-807027BB1FFB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahlbeton - Ortbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4257630E-4A37-43D0-8F85-AC82D371D426}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahlblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5CD422B-3077-4F77-AD82-B8C780B37732}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahlblechprofil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{51712219-2A66-488D-9F56-C43F214BDB3F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Standard - Dampfsperre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41C6F6A6-9560-4232-BDAC-69D678432AED}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Standard - Luftschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{04992482-68B3-43AD-B8EB-A3F116F50320}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständer_Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{771ED246-1F87-44E3-ADF2-62F2EB7F9CF6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständer-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3B5C393-8FA3-444D-BE9E-822FF84CD1A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständer-Hohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{441BDC96-7F8E-4AD1-BD29-5B5128DB7C6A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständer-Hohlraum / 300');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{612BFE3B-318F-4D0B-BC67-0F3FE3C97D0B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständer-Luft');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{66DE9B08-02F4-4D53-8452-D17C6B9E574B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständerbau-Wand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED820211-7AE4-4959-A5BC-839A663653CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{39D28E6E-1F2E-40F5-9B7F-4B2EA4F77676}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steilfastäfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{14E43E27-EC29-4D30-9551-FA2521C549EB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5ABCE0F-14D4-4267-A826-79253FD07FE5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinholz-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3556BDC5-C8BB-4793-95BD-308165793B37}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinholzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AFCC74A6-15A1-4BA9-8176-2808391228D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0A2BBD7-AD25-419C-B6EF-F58BB8504865}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinwollplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5542832A-4AED-4801-8044-CB2013B3A3E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{109EA659-79F4-43E7-9BD4-9BF7BE84E1FC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BACF32F9-4AB9-43F3-9241-D3DE1DE0AD9D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugrohr STZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{818AFA1B-A7A0-4139-9248-71633A2CBC86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41BE3449-9A0D-4D6C-A180-0AEB8B209058}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugrohre STZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06EC3EEA-024D-49A2-8BB4-3D942D851C98}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugsickerrohr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7CA580BF-BC51-45EC-9475-2BA01CB6136D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugsickerrohr STZ-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0FAA8B35-3581-407F-815A-A82A69278C22}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugsickerrohre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7157F17D-3273-4BF3-ACBB-0D987E7073BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinzeugsickerrohre STZ-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{00E2B1B3-81AF-4D81-AE73-8712994B75AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stelzlager');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FD752C8C-BCF1-4CBD-B3BF-499F44203DE2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stirnholzparkett');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8F535D44-8B8E-4E53-9F04-22009B7E67E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F9FEC927-9AE6-42BC-9F08-44FD9EDD175B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Strahlenschutz-Grundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6F181667-6025-4F01-B467-C8EB0C09E691}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Strahlenschutz-Spachtelputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F06DA951-B563-4F49-B459-BDABB046FB03}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stülpschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9E95064A-DAF6-4C5C-B161-594CC7A5DB64}', 'global', '255', 'material', '2024-04-22 08:00:00', 'STZ-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41AFAA54-1609-422D-9186-C69FF32E2106}', 'global', '255', 'material', '2024-04-22 08:00:00', 'STZ-S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BCA4D010-58E4-40D6-88FA-BEFFA4DBB56B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Substrat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EBFE82D5-6471-47F5-BF21-28403C6FE9DD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D412D067-324E-480D-8646-DD698F030477}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearl / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A61632A6-2F72-46F3-A67E-8E4FA9494BA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearl / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{028BF596-620B-4ECE-B325-1CEE72C2D390}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearl / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3DD2738D-41CB-4149-B95D-CF74A45061AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearlplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{24F3650C-9A62-4177-9BDF-E480C059A549}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearlplatte / 650');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D25C8AEA-27E7-4AB4-91BD-B5714E230470}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Swisspearlplatte / 970');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F312D21C-5B13-4202-97FB-1935E0BE8E49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Systemwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{56691433-47E1-4F6A-8F1D-9B910910507D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Täfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3F4D8FA3-B242-4021-ACE8-9AD6B8046E22}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{336CDFC4-031F-4491-BC9A-3A8BF135D3B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{812852A6-72BA-4DD5-B5C7-C4928213428E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8ADE7956-C38A-484C-A1B4-0BBADD4661A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F7E7CF1A-617C-4DA2-A637-837F0A09CBB1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41222F42-894B-4F67-99BD-C1004F30C43C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1284DE67-843E-470D-A3C5-52046CE13C5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Taptete neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A39118BD-A20C-4093-A5C9-5DB9703B012E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{08D38778-D085-4EF5-B588-129B46BE724B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A9792D27-DE13-4539-86D8-4B1AB1F60A01}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{91209099-0AB8-4E6F-ADFF-8A41A988BC45}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E8E2D3C-40C1-4D05-8F0E-F7321BAC178D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2DDF28E4-B35A-49AE-80ED-6746B29BF752}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0DDE4686-07EA-4C2A-BFDA-40F5FA7FC353}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{275C53E7-B03A-4627-BB01-3F190CA36C69}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2401A546-87EB-417C-A650-BEA99BAE0582}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7919A21-BFF1-46DA-B38E-19B6879DC8C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCCFFB3E-C4B6-4BF5-92CF-8EBB3F7D8BB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo-Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A6D5BD35-1E9F-4AAD-978D-CB17296B198A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo-Verbund');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{83622CC5-358F-4CC1-B405-4DFA6B8137D1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo-Verbundbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{88F2B27A-0856-4714-8E0B-92E7EEA75726}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzoboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58B62C2E-037F-413C-8AD5-31881D7F6F48}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzoplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{84C10AE5-4B56-4345-8B04-CD6D18A9A4F2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Textiler Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9DF61ABC-C301-4CBF-A753-EFF3D00A4836}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Thermo-Doppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C1C5B06A-DD2E-47C6-82A9-FA8D8C10AA47}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Thermodoppelboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F19974C8-16F2-4E20-BA8E-2D0145C03D9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Titanzinkblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{144FBF47-CEC6-4CCB-8927-176118F32C47}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ton-Biberschwanzziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0600DE71-A806-47F8-9A73-108678ABEBD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ton-Falzziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B01581C3-D661-4A81-B9DB-78DC447F59A7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ton-Klosterziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{821F432E-46C0-4695-AE42-140672592963}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ton-Pfannenziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EE275049-3EBF-4F8C-9A4E-3CA4C5A9C686}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tonfertigdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{85841BF7-716C-4BA6-83BB-7E3804D9BF31}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tonplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1CB7D687-C625-4FCC-91D6-8358318103F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tonziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D687BA7D-C70F-4812-8EF3-89D0AD3D0564}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragprofil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{50981DAD-7BFA-4BCC-8AB8-0D998DA8AE04}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A534CC07-DB30-4540-82F2-5678E538533C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschicht AC T H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{111D9C91-5942-41A2-B514-A9D039044281}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschicht AC T L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9D620BD-37A9-463E-BF48-112F7F4104B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschicht AC T S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F66501D8-2AF2-42FD-A3D2-6426EA1A8D76}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschichten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2C8ACCAE-F538-4ECF-83CE-147B7AFD9C0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschichten AC T H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD756A1E-39C8-4641-B283-822028A1E807}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschichten AC T L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A28BC8A2-52DD-4CC5-BC14-0F23D19E1DB0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragschichten AC T S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{99981932-7AB4-429A-A6A5-6E6CBECE9041}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragwerk - Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C13F7FEA-2625-4F2A-98B3-CA5701025832}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragwerk - Holz 1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6A1D168C-FA7D-4779-8703-B9EE0D9EFB76}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragwerk - Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{823711A9-9029-4389-9BA9-475635C493D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tragwerk - Stahl 1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F68084C5-38EC-4619-8DF5-2C917A28DF83}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trapezblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trennlage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9C4C53FC-3666-4DD9-B8A3-55F81A259925}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A325F8F9-DB01-494E-82D9-1F072F6B7510}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trennwand beweglich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{39051091-E62E-44EA-8466-CE68635BCB5C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Treppe - Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{28922387-1772-4C5A-ACD3-3278A2280DD2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Treppe - Naturstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FAA7F3BD-1FC6-49C9-BA2B-5FA571731B77}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Treppe - Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8ED6B8F8-20FB-461A-81C4-5B57D747808B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{19067D88-21D9-4015-BDC3-697D7DA2C213}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschall-Daemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{742E85F6-AA1D-438B-9CF0-83704536CA9B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschall-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{89EAD867-BB48-4E3B-BE8F-5EA62B02061A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschall-Isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0AB56E78-855C-4E7D-82CF-2F5D9FB21A89}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschalldaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{88A153CD-C694-4B1F-9381-1B5311EC761C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschalldämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5BCBF214-244F-4144-BA7D-0A72A7915C0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschalldämmung / 400');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC6DD3F8-0DEA-475B-9500-3DAA969ACFDD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschalldämmung Schaumstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{639C4733-C6F9-485F-9770-DD0F41335BAB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trittschallisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B04DF626-9724-4918-9FCB-A81A03DC5585}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trockenbaudaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B3EE36D0-77D3-466B-80E1-56C5EBD788D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trockenbaudämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01BBE83E-C872-47FF-8093-57115B016248}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trockenbauisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD73AE81-524C-4712-9E8D-544D8653BD90}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tuch');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{925D8704-D265-4BDC-955C-90CF62059451}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tür - Glas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{486E8795-7FBA-45BF-8539-5377EBDCA455}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tür - Holzrahmen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AC862169-B7A6-4C5B-85BC-0B48860D315C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tür - Holztürblatt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FBCD7E58-BE85-4951-9998-9F6EA96BA2A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tür - Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5F1C5DE3-FC2B-48BC-9492-9025C2D20CD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tür - Stahlzarge');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D175A78E-1F6D-4697-9CBF-A58B6095A14D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'U-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EA6F13CE-EB53-420F-A812-6A2951972F9F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'UB-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9B84A9D2-448F-4651-9DBC-19220A618871}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Überzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{09A79E8A-7ED2-4DC0-946E-EF1CC24E899A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Überzug gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E3DEE73D-164D-4AED-8C8C-544C6FC0B08B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung - Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E53C0A15-8041-469E-A871-48BA331F45BF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung - Erde');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0BD169E2-7E59-43CB-A97C-31BBE3C55528}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung - Gras');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{38C408F1-E378-4910-925B-990B0674F5D8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung - Sand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31AF80FD-1B5F-4C85-B3F0-BE9947768C33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung Geröll');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EEC5095D-3606-474E-A4B3-879CDDA9F3C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung Kofferung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E09888D8-B48E-4B39-92CD-0B42A698BC7C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung Rundkies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C36E121F-9EBA-447D-851D-E3BA09924442}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Umgebung Splitt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D92E9257-4A62-4CC5-8B63-6F5201352322}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterdachbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{79F62756-F1F8-4500-B086-7FF28A824AF8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterkonstruktion-Verschiedene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1C2D5C06-DCAB-4FFF-ADD1-18F19EA106BE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterkonstruktion-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6657F209-2B66-4CBC-A43E-6ACDE0F0D466}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterkonstruktion-Verschiedene-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{291C650B-9A8B-4CD3-B30E-C1F618BBFBD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E0AB25A-F5FB-4ACA-93A5-B0E4A88917CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C0800A7A-91F7-4244-A5E6-2B48700C4F17}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden / 420');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5DCC2096-169E-451D-973C-2EFC6E333DC3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden Anhydrit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D06459BF-4CAC-48AE-854E-F5FCD171229E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden10');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B4539A83-C591-4B7D-AE08-3EA485776B44}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden12');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{448EA2DD-6C84-4D0B-9EFA-07A1122722FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden14');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{98185D54-80C6-4B81-BB9B-0A89C9BB86D1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterlagsboden16');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{65BE6FF0-BDCA-4C59-A5D6-016405EB7DFC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vacuumbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{297956B8-263E-452D-8104-B9DD399A5CC3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vakuumbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3001C337-71A9-46C7-80E1-B8120C67376B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vegetationsschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5EA2C98C-359A-4CAE-9462-04E2367B5717}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Velux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EB49E88A-7AA9-4480-830A-79DE7D0037CE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbandmauerwerk Backstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1428FFC-6490-493D-974F-CFFD4AA9792A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verblender');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5B42B77-660C-476A-B1D4-B9C2FC6306F5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verblendziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DC9BE4D-0C1C-4BAC-BA76-4F816345FCDA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbund-Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58E34F6D-C536-4AE6-BE69-E0890982452C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70693F55-E31B-415D-B960-6971F3A0F406}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbunddecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{445EED45-8D0C-4429-A418-531B391CC656}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DBE8514C-DD50-4402-A662-F3E9E89178AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundestrich gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{778FF5BC-C2DB-4795-ADA4-6849FB61B1DE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93E60701-0351-4D85-A56C-B9D854423EB0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundsteinplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5C0DF7FE-D87C-4116-A08C-4AACB93D289C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbundunterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A163C0B-1851-4847-882F-A081CF649818}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verfüllziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1CC38CF0-034F-43D9-86E0-D836D1E32756}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verglastes Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A19D51D-C386-43DD-B477-C4C3F5BC9D99}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8FD8AC14-1C67-4F8A-8EB9-FFF52EC6DD17}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputz, Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD2C9F0E-4788-42BC-B73C-1C36EBAAC595}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputz, Aussen / 530');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8123628C-F88A-4A44-9219-37399CAA583D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputz, Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A637809A-EEC4-4E1C-9809-DB8F93E7D438}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputz, Innen / 150');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DB7A6368-8DA1-4B1D-B2EF-43ECB29541CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'verputzt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D1989DCC-8BBD-4FFB-BAB2-A44BA751636C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verputzte Aussendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9A621BDE-393C-4AAD-83BA-9D3370C9AEE3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Versickerungsschacht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48F39C21-BFA6-4DD9-BCD2-B233F1467162}', 'global', '255', 'material', '2024-04-22 08:00:00', 'VHLz B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{63E44B77-689F-4591-916C-E8296B6011BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vidiwall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{583B4073-AB7D-477E-974A-AF7E809C547B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vinyl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A41C974F-E5AE-4B00-BFBD-82A63138C731}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vlies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{87F39495-A764-4996-9555-5416326C0B0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vlieswandbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E3759B04-6A5E-4180-9FD6-9970C0D39C12}', 'global', '255', 'material', '2024-04-22 08:00:00', 'VMz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2649424F-9988-4A12-8F6B-74933169212C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollgips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{75D16018-9787-4750-B3CB-B7FBCE87027D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollgipsplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7084AFE-5E75-49A8-802B-930AA3CE5B4D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollgipsplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D44D28D2-AA01-4931-8C5C-05169F2D1FC2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollgipsständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{671C5A45-1893-4A7B-BFF5-5021693CBF0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholz-Decke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E65054FF-6350-47D1-9C78-459D8EA76B4D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholz-Wand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73708D42-5E46-4828-B446-74A45619BA05}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholzdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A37649C9-F829-48A6-9B1B-710B8A1FBB60}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholzwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{99EAA439-5781-41A8-AC9B-70BC5DEAB0AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholzwerkstoff');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5DE8B2B-4B56-4B65-8667-17DA8E4BF1D0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollwandelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5D031C8-FFA6-4EA4-B5C9-71117B26A8FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vorfabrikation in Beton + künstl. Steinen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{73E4570E-9344-487F-B73C-2F8EC7CF96E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vormauerziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{924FDE12-5283-4B25-8511-05302950202A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wabenschiefer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BED98CB2-DC3E-4040-8548-5FDEE7160416}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Waermedaemmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2CF01EF4-CE54-47D4-99FA-4ECB0E9A3CCD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Waermedämmung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{00417AEB-1BCB-4323-8460-2520265B5ADF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Waermeisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E8275477-ED6E-423E-B8C6-B55659CEC437}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wandkies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{331C800A-4B4C-42AD-91E1-C1B1F7DEDE11}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B86CBF6C-A04E-4A06-BCDC-8E6A4AF44AC3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B8C3F0F-D4B6-4EC0-9093-427A7AACFC65}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmung - hart');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{16F61F28-B1BB-40B1-A3D2-311CACA69F95}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmung - weich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67BBC4CD-456B-4CE8-BCB1-90C46C8E62A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmung XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5CB063B5-03A5-402F-8A1E-09272BE5A678}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmedämmung-Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2C89B08F-E589-463F-B255-1759BC75F62F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wärmeisolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E962EA34-CA7C-424D-88DE-95D58448132C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Waschbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B010390-AC8F-48DF-8EA0-CC391114BE18}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wasserdichte Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{317E4B2B-B058-47E3-8ACA-DC7FB9DB3A34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wasserdichter Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CD424CD9-8801-47C6-97AE-BB0AA91DCDCD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wasserdichter Mörtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8968FC08-CCED-40C8-A577-BDE862FA5F12}', 'global', '255', 'material', '2024-04-22 08:00:00', 'WC-Trennwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{74213C7E-2F47-406B-B4B4-09769868CE4A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'WDVS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weichfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F10D92FD-5622-4F85-A965-78B439B7CBCE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weichfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9D992CC0-489E-481C-B640-ACD8F335040D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F9D1DC2-FBB5-4E40-8773-CC5DB312EA4C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz / Renovation Maler');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1E41A0F-14B5-4125-807C-A3C887B94145}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz gestr.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B8B8F240-A9AC-40C7-B246-FD61563A69D7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2915A061-2489-4395-BD99-F8BD2174C60D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz neu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3000705F-CF9A-48CA-9673-7C31C2F0EFE6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz neu gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4C6248E-1B56-44DC-AC04-26FB98E8992F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB39A8E5-147C-4257-889C-F6B2A5B879F8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz renoviert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5AAC5131-E647-416D-B2C0-8D150222C4CB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz saniert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9890AA7A-6C95-439D-87CA-D2BC610BEAF6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5F6C6597-9B44-4B08-82A5-BB7FB4BD94F0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz-Renovation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70FE334D-D152-43A5-97CC-E3A436AF26C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Weissputz-Sanierung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{98F9ED0E-1FFB-400E-9E55-9E89A954D7B3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wellplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{01362BB8-573C-4C01-B165-A947661712A7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wellplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EA88D7FD-8F73-4635-9043-6A2ADAB354E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Wohnküche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{38884E5D-C799-4981-920D-D7AE14956C27}', 'global', '255', 'material', '2024-04-22 08:00:00', 'WP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{70AE21FB-1BA3-421E-A7A2-644A5DB5B91D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06EB0D32-D438-4E41-B5CD-54C94D7A4E1A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ytong');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{602B9087-04DC-496E-AAA0-F85CDD45632D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Z-Überzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB6495E4-DCE1-49F7-8C3A-1B4A5BE201F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zellstoffvlies');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7ADB1C34-D3A6-475E-A2C4-27155C3BCD8E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zellton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{987B2F8B-6BB7-44CD-BCCC-445D40913C09}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zelltonplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{22DCC37A-600E-4F2E-9FFF-FA6A44A1E336}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zement-Kunstharz-Belag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{85E2593F-4E2B-465A-AA96-50A125EEC323}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zement-Kunstharz-Fliessbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{49C4FACE-72F4-4E88-8DD3-C83A430E9218}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F60D5EB0-22D8-4A9F-BABB-7B03E4BB407C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich 2K-Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{328A6EA9-C18A-42E7-A7F7-A38A8A5E680B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{643D417C-7B21-4966-9B38-84E26991E06F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9737723B-2A12-49D2-B896-116D68FDA0F1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7AA9BBF-1F38-4661-AC55-B2043E8EF18C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7EA2956D-E7C7-44A1-9B67-C6C81FE77E94}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich CT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9DDDCD82-FFB6-4CFF-89C9-476E7EE77AEE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9F38EDF3-F5EF-4CF9-B415-0B9592802E85}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C19D084-1372-4A1D-8983-28CFDEAAA437}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8D43D177-AD27-4DD7-B979-9652A7624207}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich-Bodenheizung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1150F312-A137-45EA-BEC0-95447C34CDA2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementfliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0A05E26A-91EE-40E9-8E2A-6C6E61D41E48}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementfliessestrich CTF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B023EA49-F408-4BD2-9DAE-ED68EEDAA185}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementgrundputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{18AB395D-53F7-4E4C-9B5E-FFFAE8E7C87B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementhohlstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{393AE909-BCCB-47C8-AEDD-5407293A6840}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6935236D-9960-4C9E-8DDE-95B902C50E57}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementplatten / 140');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EA0B6E2D-8F82-4462-81C2-49FEB9AF6C8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementplatten / 405');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{30D60592-599E-4BE8-8D1A-28D8F3859CF1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7192F1DE-686F-4037-AED8-E8BDDD37A331}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementspachtel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3435B91-A403-4D1E-8D61-8B6656BC7240}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementspachtelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{77868A0D-D2C3-4B0A-9728-877A9FC66D49}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{67936FB1-7288-4361-81B3-A482E41379E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2D793E28-9C9D-4AD8-945D-05BB543224A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein MC bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5FAF22EB-E8B5-4BED-BC19-ABFAD6E1D4C2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein MC nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DF890EFF-A489-4BCC-94A8-79A13C6AB84C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein n.bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{29478EA0-E563-45D0-9E0A-DB96E5B9A3CA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein nicht bewittert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{065306E1-22A7-410F-8763-E60F35961770}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug 2K-Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6EADDCF9-7179-410B-AC03-B7FCC19EE144}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C092C44E-1D5E-450B-B6A6-5C22F3FBCC86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{69274D1B-12E7-469E-8395-7F79433C8F46}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1E8A8447-C3E9-40EE-BAD3-F5F377FEBFFD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{469D85BA-8D19-417A-8926-E24B4F3564FB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E9C716A-5266-4399-B759-21ADB179F217}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug Epoxidharzanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E59BC94-903A-4417-B384-9D1A7F6DD396}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3DEAA91-B4EF-429E-AAD7-5EDA7CD04024}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug mit Beschichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CACBBA53-20E8-4370-A0BD-1A0AB08D49C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementüberzug PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{253B6D5A-1BF1-433D-B908-4A0364A621C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementunterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2F8848A8-8B2F-4722-9CC8-108725A8C37C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementvollstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegel_HLZ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegel_HLZ_WD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegel_NF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2235E068-40F1-4B30-B1F1-1E88BE82EE8E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{37F799E3-EF78-44C3-9125-A30DA8469753}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegellattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{322D0687-8579-41B0-8679-0F604C6E0458}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{560DF9E7-2CEA-48ED-9CDE-52C08C3A5464}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelstein-Element');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CE314BC0-F79C-41D9-A2C9-1B4360F0B52B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelstein-Fertigdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{82912D28-1A48-4146-83C0-9E7DE9DE6746}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelsteinelement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{878FA7C3-A29F-40F2-A5E2-0E0C377B8D5A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelsteinfertigdecke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{788F570E-262D-4156-983A-36B9C5A3F963}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegelwandbauplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FEBF62AF-F328-4A1D-A878-A897034E977A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zinkblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{15BD6645-3410-4B42-9B85-1CC26AB12ACD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0CC2CA26-700F-4A04-9443-AA91CA75F730}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich 2K-Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{663FBC72-DA02-4847-B37F-42D0BE1CE5D9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E71DCCA6-25E5-4579-B4E4-79CB2E09FD57}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E2D9C23B-FA87-4EFC-A262-4D6F738DED0D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D0638A57-5EAC-416D-A644-30F8AEA5D335}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B842C586-AE6F-41E9-BDAC-80504646FAB6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich Epoxidharzanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BB3D56A2-F84C-480C-9CA3-CD91618079D2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0983B07A-AF46-4CCD-912C-B5C342D72094}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Estrich PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E7554EF4-891D-450B-AD47-5DF2918F1DF7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Platten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{26DCD9CD-AAB5-44D0-BE5F-6EF0308584A6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-U-Boden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{462F3BB3-92D5-4FC9-847E-96FE79178BA6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A084D83-4DC2-469E-B60C-9C77A90FC3E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug 2K-Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6166A4CA-4AA5-461F-9223-B2931976ADDC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug Anstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97235C98-8B74-4681-99E9-1474B0602CA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug Bodenanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{84537C3F-8DBE-46FA-9EB8-F29078D76993}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{33728BD6-BBD8-4FE4-B6D6-1984FDA7D805}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug Epoxidharz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1D64BA11-E339-4651-8B5A-9A94231C77F5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug Epoxidharzanstrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F953187E-845F-49DE-8EB3-958AE8E78523}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug gestr.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4DB5F1C0-C8D7-41B2-8C0B-FE3CAF1174C6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E9B069EB-C061-4B8F-9C3E-68C4B56AA175}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Überzug PU-Bodenfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{60A33708-47BC-42F4-BC5C-92921E6908BB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZM-Unterlagsboden');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3C809DA1-6EBF-44AF-B485-BE0689241FB7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E7098E0E-BF87-4207-8BB6-5C5AF45EBE6C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'zs');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB0275CF-5677-4D6D-9DC8-84DC3FCA185F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zw-Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{41CC20BA-76FE-4745-A797-D0170D34309B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zw-Leichtb.-Schallschutz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{996E3754-6A20-44D1-8EBE-35CFCA75EC39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zw-Leichtb.HBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7254BEB9-AD02-4B41-900B-77A7B0C8C0A4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zw-NF Ziegel-Mwk.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A0FE1387-1032-49F8-8035-9D82DCFEFF84}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zwischenraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{08FCF00E-57DE-44E6-B323-D104574A0880}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZWP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{08B6D180-A974-45DA-938C-5C85BC0D91F1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ZWP-Plan-T');
-- missing synonyms `de_at`
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_FT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C3D8439E-D4BD-4113-BC5A-87E6CA387A47}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_FT_WD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BAF76D13-435B-4201-A502-9260E1765450}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_HBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7728153-6E6A-404F-B12C-7E834AFC5E79}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rollierung ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A19FCFB5-0C13-4F32-90C5-183F2E46277D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton_STB_WU');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D529C3DF-FA1F-4D21-B1BA-6124CA41CB5B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung Fassadenbau');
-- missing synonyms `de_de`
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FE0CB650-5385-41A5-8030-0238F6B45CCB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Fertigteil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4D382E1-049E-436C-A155-23BC18CD3061}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton Ortbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF87E3CC-CBF8-4EE4-8456-FB1C8B7E0311}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton SB1');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7635C017-F07E-4538-B8ED-152F15A6B694}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton SB2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ADBCE8EA-5130-425B-B0BC-093B7693BDF8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton SB3');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B8A643AC-55E6-4D25-B258-49E8DF4E0B3A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton SB4');
-- missing synonyms `de%` due to former DISTINCT clause
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{35D96946-4D7B-489B-9A33-427CBE5BB5B3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'gestrichen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0AC08B75-94EA-4697-96A5-42C6F6BDF804}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-aussen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C09AF3A0-23AB-49D3-977A-9F8385F920E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{26F279CB-FF4D-4A49-9BA2-82CF131430E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'stahlbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3D13F4B9-00AC-4A68-B591-6E9F45F11570}', 'global', '255', 'material', '2024-04-22 08:00:00', 'extensive Begrünung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D7CC9452-4E75-4F99-9959-97CB520FD96E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'velux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{ED5B4918-4BD4-48A8-B575-7B72D78F58B9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Daemmung Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{544DD228-C85A-4058-809D-8287631181FA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93DF009B-BAEB-490D-8DF4-737385991A3C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton vorfabriziert');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B25A1F1D-D74B-4FAD-8D71-9864496F8A48}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbausystem-Massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7797028E-4066-4904-9A80-DF496B314258}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D2BC112C-2D08-4951-BCB2-BAF39AB231F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KÜCHE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A03B6BB0-A954-4E06-BC88-721C5DDFCDCB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KÜCHE / ESSEN');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{28D372C9-6C1B-4C95-A212-3D0C597361CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'KÜCHE / WOHNEN');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{799CD5E9-44BA-4B5D-9DE4-D7E5F97C3CD1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'roh');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2C9988B4-62D8-4A17-8B55-E0389A596C3E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vmz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B6286362-C0F8-439E-A9CA-07B3F7F30F92}', 'global', '255', 'material', '2024-04-22 08:00:00', 'HLZ-Plan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27F7B99F-E002-4ECB-8625-59CD62229312}', 'global', '255', 'material', '2024-04-22 08:00:00', 'ziegel');
-- wrong depth code values -- to be removed again
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E72AAA8F-A0AB-4FB6-99B6-2359CCCADAD6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'findesign');
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BDA8C7D0-2689-40B3-A334-089467246E63}', 'global', '255', 'material', '2024-04-22 08:00:00', 'drawing');
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{57689F63-67BE-4F4F-85A6-45F45596C2C7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'predesign');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D020610E-BEE1-43AD-B9B1-B75197633382}', 'global', '255', 'material', '2024-11-13 15:18:08', 'AD Mineralfaserplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E5A6C884-1FA7-4668-85C4-65622942E264}', 'global', '255', 'material', '2024-11-13 15:23:25', 'AD Mineralfaserplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{656C96E0-7597-4A7E-9A40-FA493A99A580}', 'global', '255', 'material', '2024-11-13 15:25:11', 'Beton_FT_WU');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D44E2AB7-1338-4A21-B61C-3B4DF74A6C6E}', 'global', '255', 'material', '2024-11-13 15:26:05', 'Stahlbeton - Sichtbeton');
-- values `en_uk`
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CE61BA9F-DDE7-4635-AE24-E9400649E10F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Acoustic board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E4571228-698E-4876-9014-DF0ED9DD9443}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Artificial stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7764444D-6DC5-463F-8B68-8CE3EB67A9EE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B5B097CD-4005-45AB-876F-1CF879B6C23F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Carpet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{28384D4C-0E6D-4D76-BC62-077E0FF36662}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cast');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{689AF5DF-E252-47E0-8781-685F72D8AA4A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cellar-partition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EE997DD8-7358-4774-BD87-B4B15AEA423C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{87F5E0A0-9CA2-42CA-87F1-AD0A3DC648CA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Chimney unit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E180167F-900A-4F49-9D27-84B1D52038C8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Clearance');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{526D41EC-EE52-4E2D-AB0A-A2D55D36AE6F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cold bitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{30A04671-84E7-4BC0-884C-CCD2AAA90B97}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Composite floor slab');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4F8522ED-D282-4502-816C-F3A85EC41EF7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Concrete block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F6F8B943-1AD3-4685-A110-65A3C75B6F9B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cork');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{858240B8-6917-4D02-8A83-7721EBC9C20B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cross laminated timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5BB1AC14-F4F6-4CC2-A258-6BB8793E1A60}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cubicle partition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{71A45A6C-FCF8-4304-9BDD-FA3659301A8D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Derived Timber Product');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BC5C6841-0B1D-4F67-AEC7-1335B20F8423}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Double bottom');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AA20D622-40B4-4713-93A3-95D3FE19830E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Drywall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E2497F59-2A80-42BB-8909-1100A49E6B03}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Expanded Concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CCE9CDF8-1ABA-4FC7-B0F8-9C92E08BA1B9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Exposed masonry');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9D41B523-E7AD-470A-A1FF-2BB2AD08BD32}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Exterior Insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3965B543-D571-4A34-8630-5046A0D23068}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fabric');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{308B06C0-37AD-4449-90D8-97CF9A96176C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Facade lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{99C2B5C4-7E48-4CAC-93CD-A7BEDC290D99}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibre Cement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{862CD1DD-A6A7-4C0F-94A9-BAD070FB8903}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibreboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F6BA2C62-3EB4-4810-82C6-702ECF257F20}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibrous plaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{205057DD-14D7-4FD6-BA98-5455142F5E79}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Filter panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C0348BBC-2859-465E-A90C-D599CE6E45A6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Final rendering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{31B8E1C7-0A84-4A2F-9C7B-785AF5761B0C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Floating screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{050A297D-5076-436C-876E-28D4B5AC1FC8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Footfall-insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3136A95D-3651-4F13-9009-CD2B927F3448}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gipsum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{567A5ACE-0F50-4C37-9A3F-3B8E5AA9ECEF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C64F108F-3B2D-48B3-8012-D70B4071A492}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Granolithic');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7C96088A-6134-42B3-8161-A800F010E130}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gravel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F17827F1-EC12-433F-9761-82F03CB25A78}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CCB46BE9-743D-4D82-9A30-1CA1649A519C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-beam');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1C3AE1DE-8CDB-4382-84EA-8E2A62902FA0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-drywall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3062767A-C0B1-4BBD-9F43-F2F1B27AD058}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-flat-roof');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F3EA56A9-EEC8-451C-B4B6-86E3EBD2BF32}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ACD29843-D130-4B34-A4D4-EEAFFD03DD43}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-post');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{61F5AA46-0961-49CF-B5AA-1FAA8BB5BBDB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Jointless covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6D31C8EE-EC02-4011-82FF-51B165CAE06A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminated wood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{890C2FF4-3161-4B13-B918-6E99A56661D7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lawn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CA061D13-1700-4C9E-A2EE-EF0276915CFC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lean concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DE526208-345D-425F-876B-A7735AE13A83}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Light metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{620B327D-9D05-4D8D-940B-6F1DDD92699B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime-Sand Brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{35BEDD7C-8A99-4332-B850-D3B5EB209588}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Manhole');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DE75B0BF-E8B5-4AB7-8C31-8F25B0AE29FD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{19C602B3-ED79-49F6-BEDB-5B7B15F13438}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7D1A460C-9BE9-47A4-A16A-FDA19D09803B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Natural stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E4DFBCE5-BD24-4A01-B7C1-7CFF44BF9675}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Painting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4424AB80-D9EF-4A0B-B63A-049964781F9D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Panel wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E97FDEA5-C2FE-46D1-9F29-E8FB17436757}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Pavement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9D92396B-9FEC-4CA3-AE34-56A18E6E2DFB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Planting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9090CFE3-FFC1-473F-A7B3-76407AB6371B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plasterboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F0B32297-4DD5-4459-9432-83386CE62608}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EB86DACD-9993-4745-9185-6071C47955D5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4CBD3CAF-582A-412A-B27A-A6480E4F0CD7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Prefabrication massive');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4919CA1C-337A-4986-AC05-5E28333BA171}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Raw');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D3C27D35-A600-4D8B-AA0A-12A08108943E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Resin flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DFD6FCF1-BBC9-423A-BF15-A50A07BE2FCF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof greening');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F2809147-73B9-42BB-A50B-D5C0BDD1BED7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof window');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5C272ED3-2109-47FC-945E-9F75B228E5C6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Screed flooring panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Seal sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FCF76425-6FC4-4171-B889-DAFA2499A2F6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Skylight');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{88F5CE32-496C-4B55-8E15-ADB260E08570}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Solid wood construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E1ED1E4B-73B1-4F96-AC5D-8FAF00CCC72F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Steel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F8220394-369B-46FA-95B2-A2D0E1993851}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Stone-wood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{373A91CA-DA75-4D8C-961E-A3F7DE0221F7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Substructure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4675E9C7-1166-484A-9495-C9024D45F7A4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Undercoat plaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D6F0B95A-F681-4915-AF71-2DD9E4F6C605}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vacuum concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{86D2896D-8E27-4E29-ACA8-A5A01981C1E1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapour barrier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{586A6564-938E-4CE5-84DB-1AB099ABE585}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wallpaper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BC0735F2-F750-4320-A7BF-26BE711A1FFD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{420CF4CB-DA22-4083-A698-264A9F161E92}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof-coating');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{818FC492-E17C-4C2B-97F3-38AA975C6F9A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F1EFE294-B358-4A38-8A00-90F81C67997F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood-metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CB48F04B-5AC4-4594-8E33-18FE9A5F7F0A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden subfloor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{47E4F374-0BBE-47B4-8669-218DACC35704}', 'global', '255', 'material', '2024-11-14 13:06:06', 'artif.stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D247A510-145D-41BD-8C40-4AB9B0115668}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Artif.stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{15ED5C54-988E-464B-846B-CE3A9EDA7DC2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'artificial stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8AC0CEB1-F328-45E4-B3D8-B649932E6287}', 'global', '255', 'material', '2024-11-14 13:06:06', 'HMT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C7D370F0-31C2-4BD0-BFF5-B5C3E9394063}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Hot mix pavement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{26EED3E1-3118-452D-90E2-C383C0393EC2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tar concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{71613984-3528-4E77-9D26-4C4B15D07741}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Baked brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3DCE3C86-32B2-4A74-92CD-F0C47D2A0122}', 'global', '255', 'material', '2024-11-14 13:06:06', 'baked brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4E6128D8-E277-4025-B97A-FD5ADC3D952E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DBCC6895-9B56-4919-9612-FFD8EBFEA6D9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3F756AAF-6B77-4A48-A372-F4195630CDAF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'burned brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E86C59F0-A2D7-4D77-A686-711B822CF12A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Burned brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{31B3D7ED-EEA0-41A7-9D03-A8120FD5930F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Burnt brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FE6A19B5-CAB3-4F34-A525-6AA699B2EBD6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'burnt brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{40755677-94B4-400C-80E7-E00577468070}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Burnt clay brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BCA9292D-AE3D-465F-B311-A9E9146574CA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'burnt clay brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E4B49DEC-E2D1-4B89-B857-CCBB8AC50BEF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lath-partition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F595D63D-0C82-4182-B597-F175C1137186}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{884F434D-FDAE-4B98-94B7-085E7DB1C22B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic floor tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AE70D357-1006-4567-A300-B4CCC3567109}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic mosaic');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FCEDE338-867C-4F81-BD60-37DA8EBADAA6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic wall tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5C0F0F88-5F54-47C7-A161-001F353BE1DF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Clay tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5BCC5EC6-C201-41C2-9B9B-E9261D35803C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Floor pavement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0A275983-0A46-47A8-83B1-ABB32DE38705}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile finish');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{77B0AEFC-C5AF-43A9-9BFC-05B339B42303}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{31047C5A-BD47-4F93-9A4C-F87678B21412}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5314D3C8-F50C-42B2-B9D4-E5F8A556E978}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile pavement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F06F7CC2-FC34-4753-8FBC-0254B07539C6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile surface');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EE68EFE5-6A8D-4426-9B94-6567E825A024}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tiled floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D00C53D9-18F1-41EC-971D-553C6F2B8615}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tilework');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{68BDAEA7-DFB1-4CDE-ADDF-371477DAA96D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tiling');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{16A8DF36-E23B-4D15-B85A-E8854D8F747D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Air');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{98E774A3-1C40-44DE-B743-BBCF30F68970}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Empty');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5A566178-D941-479E-B8DF-03DA28B828A0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gap');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0AE88A27-7307-4AC4-A5C2-FB6FFC0C38E0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'gap');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4BDB38B1-6B08-416E-9F91-92BB9AD3FA25}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Play');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5A384FCA-81BA-411B-BE90-AC988246F75B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Armored concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E1CF95F5-C37C-4110-AEC4-43B3ED2BBB61}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Armoured concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{109E95B4-E4DD-4F5B-9733-B05AA2C18632}', 'global', '255', 'material', '2024-11-14 13:06:06', 'concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6AA525CD-6426-4334-8699-313BC0F55178}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ferro-concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{69E07C32-EEE3-498A-BB06-BAC4C6ABD52B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ferroconcrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{81CD4683-51F3-4CA4-965B-7EC679F9BCF4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Reinforced concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{778051E9-88FA-4204-B7FF-72290D7054E3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Steel concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{37D3F9D3-9CE0-4F9C-801A-3525354AF359}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Unreinforced concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E88AA43F-8CFA-4E30-AC4A-262CCD1CB8CF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'cement block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F703FA86-0F60-4C4C-A1EA-AA1198CB50B5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cement Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6532CAFD-7224-4B88-8A99-319D08630F4E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'CMU');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{562D17E3-9C3E-41E6-AAEB-82A12C5D3070}', 'global', '255', 'material', '2024-11-14 13:06:06', 'concrete block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A0EB7828-80B0-419E-9C6D-1A127DF78B93}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Concrete masonry units');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{37FACB4C-B497-48A4-8645-571C8645C437}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Precast Concrete Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1C1F6145-1270-4E8C-ADBA-F5FA1041E6A6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'precast concrete block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FEF79B61-ACDF-41D4-BECF-290E6CEA38D7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'precast stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1A5A18D0-2D36-4931-9EB2-016CBD014833}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Precast Stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F160BF6B-F44C-432E-A17E-63D680DEFC10}', 'global', '255', 'material', '2024-11-14 13:06:06', 'solid concrete block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3BD4A27F-EE6F-424E-8760-5C24B246C15D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Solid Concrete Block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DDA57F19-05AF-4139-8C7D-09DCC4D836C6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cork flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FCF82EB6-A7B1-40D6-B93C-BFF49131AF85}', 'global', '255', 'material', '2024-11-14 13:06:06', 'CLT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FE308F7A-6415-4EE1-9CB1-B36E3DFEBAB9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cross-laminated timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{60F2B609-E648-4AFA-BF2D-289197CDB736}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Chipboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{11AB53B9-B412-4691-87C8-2BDF3EA158B8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Composite woodwool slab');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8E01CA10-D80C-47CC-949B-03978C6D90F2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Derived timber product');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{339EF220-B635-4884-B6EA-90B31C24B883}', 'global', '255', 'material', '2024-11-14 13:06:06', 'derived timber product');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CA4F72D8-76CF-4C65-B657-7C06449EFB29}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Engineered Wood Product');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{93DC93CA-A97C-4FC2-AA5B-D1E8545EB523}', 'global', '255', 'material', '2024-11-14 13:06:06', 'engineered wood product');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{528A0348-DC52-4B44-831B-9AD7F88063F8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Esin-bound chipboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5928355A-FC5A-4526-B478-79853AA2694D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'EWP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Particle board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{703EB95B-2831-4FE1-A957-082815B8165B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Particleboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{499F85B7-8F2C-40AC-A335-9F78FD1C638E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ply wood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BCBBB77D-06A0-4905-A241-ECB8A1761DFE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plywood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9FF5ABA6-C5B9-4817-8C70-D178EF908FBF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Resin-bound fibreboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D478BB33-F49B-4F1A-9558-764B47AA74B3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wallboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{45535389-7D4D-4953-B5F8-65C7101103AB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'wood composite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{18926EF9-BE72-4189-BAD5-CD0660E3E4EA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood composite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A2342EDE-2EE6-401B-8B8D-9B0F3D2BBD2A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood-wool board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9F1AC1D8-3B23-4398-9037-C952D9C7230C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Woodwool');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{37EF02C4-BA66-4CB9-9B52-C782D48BF8C6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Woodwool slab');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EAA34794-925C-4A69-B746-40D295127ABD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'False bottom');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D5D3A268-CB78-4140-8231-C4D1A2750A1F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lightweight wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EA39E223-BF12-4ED7-B19C-42B4D6EA932B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Aerated cement block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DD7D2720-CEA0-46ED-9355-2E265CEB4D07}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Aerated concrete block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F15D0D16-90FF-456F-9B11-41EF94706445}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Expanded concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{30FCFF93-41DB-49E2-9690-5E81634A994F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gas concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CE1EDB00-3019-4A5A-A052-13AD0B688EB1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ytong');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E3E1570B-4859-41F4-AB6B-98E3A6F803BF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ext.insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D4FA9921-5ADF-4ACC-A577-2345E2E81BB3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Exterior insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{985FDA10-70BF-4BA1-A87F-3E44F54B7D89}', 'global', '255', 'material', '2024-11-14 13:06:06', 'exterior insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ED5C8A51-DBA5-4838-8804-42EEC3687F25}', 'global', '255', 'material', '2024-11-14 13:06:06', 'External insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{19C934D3-FFD9-449E-9C2A-2653DECE981F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-exterior');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{736D1708-DE6D-488B-82B9-46B36AAA9952}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Outer insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C7E5F053-D7C5-4143-ADD0-150404498029}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Thermal insulation composite system');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{918E306B-D6E6-48DC-A66B-E73AF75ED1EC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'TICS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C7C76D03-4A09-45F5-BE26-1740938F22BA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Façade lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{37FB99B8-62A2-4E60-ABD9-FA4301ED2590}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Façade surfacing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{968EA69E-1EF5-4F71-B991-D9D62132A908}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Facade surfacing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CCA340D0-2804-4DA3-87D2-ABBCF609EE4E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Eternit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1DCEE00E-DE47-4E59-9013-F062908CAA89}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fiber cement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A32D9798-08D9-43B0-BF5C-C4DC8A6D36F2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibre cement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B193B2AD-C295-4430-9531-E29E7E92F69A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Slate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7C349332-B7B8-4189-802B-7F2DF23B9B54}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fiberboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{69562DFD-A74C-40CF-AC42-65C70E403FFC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Hardboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BDCA75C3-6A26-4417-859C-845F491CE01E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulating board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E4FFE747-865D-47DC-89AA-BAF5803C3751}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Masonite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7E68D61D-62DB-4F88-84A0-40421F8F10C5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'MDF');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AB75CC70-521A-4385-9BBA-36E4CFDFAADD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Soft board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D071021D-F75D-4E99-BD77-DA68AB86AFE7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibrous plaster sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D96F7AA3-86DE-43B7-B929-4AD6FB08DFD9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fair-faced plaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9098A8C4-C1C1-4932-90D8-D7EDD39CFA1E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Finish coat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{060E0CD1-2AB6-473C-A3D1-9D0A41CD8473}', 'global', '255', 'material', '2024-11-14 13:06:06', 'plaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7B41A1E1-D89B-44CE-A49A-57A35238C7BD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster facing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{05C7C14E-F086-4D95-8069-25261B9E04F0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster stucco');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{643B9A8A-5424-44A3-A293-CA8EEBE8F081}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Smooth finish');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{43AA4F8D-B420-4BB7-A801-F7189DB2FD44}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Smooth plaster, stucco');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0BEB97A5-E0B9-475A-9605-A0541DE4588A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Stucco');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{67CE1EFB-F690-4126-B5A2-925E94BF6E9B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Anhydrite floor screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{85D5BED0-BAEE-4088-ACA3-33D261F94DCE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Floating floor screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D3DEAC6F-A05D-4D63-AA32-A83D930E1A69}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Liquid screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D4BA22E9-4E6D-482A-8A8F-971EA366BDBD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Footfall sound insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7218900D-76A1-4A65-A189-761ECCE01000}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Footfall-iso');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E8531B1D-611A-446B-88AC-F70DCD564644}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Footstep sound insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2029927B-4111-4549-A940-41D70129C552}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Impact sound insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8FDDD3BF-A60B-447D-BFD5-D824FA668C90}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-footfall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{10BA94D6-AF16-4E29-B987-12D8041B09D6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Granolithic concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DFABAB85-0186-42D5-9B32-414602E747A6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Hard concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{91A5B3CA-6252-4A45-9B5A-B9F3FBBFADC9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bank gravel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{46FB9356-6BFE-418C-9552-2FF97988AD74}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Boulders');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9783418F-EACB-4C9A-BD42-261D232DE41A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Detritus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E9597A07-E4B6-4476-A02F-40A494F5113F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gravel layer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{897C7696-9470-4242-A0BC-E3440728D23B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Pebble stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AD399FF8-AC83-4D5A-8B04-3699DE3ACF87}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Pebbles');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5DE47FBF-E4B5-46AC-AE01-DD2856A462C4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Quarry gravel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{592C51C7-C39E-4620-94EB-99EC7A2A9AD7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Round gravel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{527D58B6-EAAD-4D86-9B4B-31DFBC11A8CA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Rubble');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{935EC0D9-6CE7-4E8E-999F-99C2A5127676}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Run-of-bank');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EC15722D-52AD-43C6-BE05-5336407BB6A8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{09413ED6-5C4D-4B6B-89CA-2B33F976A4D6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cellular glass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7385E673-4B51-4C54-A13C-86F9B59BA423}', 'global', '255', 'material', '2024-11-14 13:06:06', 'EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BEDCACF8-31B2-4796-8B5D-987D4A2AAD5D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Expanded glass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{300D2EC4-43DF-4F3D-B600-2EBE2818EE36}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Foamglass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FC2BBE8C-4745-48F0-803F-BDB81B6CE62F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glass wool');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6A5D740D-BDF9-4BDE-9A67-7D7B46B6408C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glass-wool');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9BA95755-240E-48AF-87AA-C39CA834C456}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Heat insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E750742D-3F01-42DA-9160-8DE5B24EFA67}', 'global', '255', 'material', '2024-11-14 13:06:06', 'insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{63875D4A-A1B6-496B-B05B-AD6BC470CE44}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B292906D-0E68-4F0B-88BF-0407768D8943}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Polystyrene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{54BFC118-637A-4806-B33C-D285DD24CB25}', 'global', '255', 'material', '2024-11-14 13:06:06', 'pun glass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2FC1C78C-F410-4354-9FE0-A52044B35A6B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Rock wool');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F5EB9F76-4FC2-4F2F-BF12-A250E74FBCA3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Spun glass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{647D6933-0D22-4D69-9F2A-AD3D3BF8E8EB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Thermal Insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6BCCFD67-1BBE-4538-98E1-E43D6A64CD13}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-balk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E26D1EB2-CA74-44BD-B436-5B1F8737A3F4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-baulk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3BECBD92-2128-4247-899D-C3FDAC29A882}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iso-balk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A6F44F2F-A4E6-4832-850D-1E17D603407E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iso-baulk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2F346D31-7664-4EC9-87AB-35733597EC3E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Drywall-Insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4B0BDE23-5D96-455E-A5D9-C9D377FAD91A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Drywall-Iso');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1F7972AB-B926-47C8-8E92-A50FC562089D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iso-drywall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F53DA758-BCA7-4AE7-98B5-F88C0F8137DA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iso-flat-roof');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{33922986-7C62-48BB-9BD1-BF0C7AFDDF27}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iso-lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1F6639E9-950A-47AD-8C6B-872B7C712B45}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Post-Insulation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4A487CF1-7C36-4E7D-A469-B6A5784AC8AC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Jointless wall covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2B15D267-BE94-473C-83E3-BE2879610150}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glued laminated timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{15105665-0A55-476C-98FF-67B23AC0BE08}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminated beam');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0789DE43-7FD1-4A7A-BBE2-B6DB20658166}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminated lumber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B8234665-5211-4CC5-B93A-D70C6CAF1795}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminated rafter');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{98B773DE-4B87-44C4-B735-BB2976C785F8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Grass');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{93F2BD6A-A924-40B7-A0EA-64A6BC37A9C5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Green');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6F6CF7B9-3A31-46B3-8F4C-A5CE78611ADE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Blinding');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{57DBE498-7AA2-44FB-924B-A8AA024718F2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Blinding concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ECCF2E7A-B870-4D49-9601-CC01C4E3992B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Porous concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6207721B-D274-41C3-8739-662D8A58F181}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Subbase');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{596B6922-473B-4841-BE28-5F78FE5DB42F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0969320E-B6D6-4233-99DC-E310558FFDC1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5F3116BD-7E85-4845-A137-9285BFF0B115}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Aluminum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1D451920-35F6-4B10-933C-194D6D3B1015}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Arenaceous lime');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4AC9373F-B9C2-4CE0-B86E-50BB75822910}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Calcareous sandstone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2599D30F-A1DA-4464-82D5-3AF00D48C235}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Calcium silicate brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{658BB632-BA74-4C0C-91DE-648483502030}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Chalky sandstone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FDF177C2-0826-4346-B311-FF34218D5E8A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime sand brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{61224232-30A1-4EC0-B3F1-D3F963A5CE3B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime sandstone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{217C6AED-00DD-47BA-BFD7-C895955E655A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'lime-sand brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C0E1A743-1003-4437-9458-8EF3D7C3ED51}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime-sand brick');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3C30B8F9-8DA5-4622-8ED3-6AF9268DE99B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime-sand stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{99B3A421-7AC7-47F7-B84D-1FF748222EC7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sand-lime block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B54D7BE5-835C-49A0-A0DB-C7D9D8542D25}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sandy limestone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2461E31F-7073-42A3-B0D6-6DB029ED9006}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Chromium-nickel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{447F0B79-EEFC-41B1-ACAD-8BF44A7012A9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Copper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CEAFF1C9-A899-491C-B414-FC632034920A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'metal sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D6045824-492E-4321-A782-5AC9C592A0A4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sectional sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{798A071B-11DE-4E73-BB85-05C50B0C689A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'sheet metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{34102B89-0827-48D8-85A7-156DF8A61241}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sheet metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ED92E9C8-A397-4E4A-B808-07C0838FCC19}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sheet zinc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C806C5C6-8C71-4479-A652-43CFEFACFD90}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sheet-steel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FFD4C9F8-4105-4617-B7DB-27D46396DE90}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Steel sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{59CF1D43-07FB-4750-9D06-2A37E237FB2D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Troughed sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C9EFF3D2-2CE7-4DC1-97D0-EFF03D6EB518}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Zinc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8CA8E080-A226-4F35-886F-0D29B25C0F53}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Zinc-coated sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AED9F263-0035-46EF-9080-9A8313DD2D5C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Zinc-titanium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A8589DDC-9C68-4342-94FC-153FED1ED1B4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Granite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{12F0870F-C154-486C-96CF-AE15EE0536FF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Marble');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DCD3F69C-368F-4F36-958A-3409A9689452}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Natural slate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{778BDD47-A15A-4D4A-8172-2D1430409847}', 'global', '255', 'material', '2024-11-14 13:06:06', 'natural stone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1CD20EE5-F05A-41BD-B730-73868591CDAD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Quartzite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CBDECA33-B3AB-4BE7-AEC1-EAE62D86B9F2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Coated');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5E434CA0-E62E-4E42-9F5A-763E18B89887}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Dispersion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4E8FD09F-238D-4736-BE39-CFBBB88A6F72}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Distemper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8E2378A3-498E-41F9-ABFF-8AC9841C8CB0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Natural finish');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AC15DFEE-0509-44FC-BC8F-A33896EFF4C7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Paint');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{00DFC14A-F241-4FD2-A562-68665ED24EE4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Stain');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{87A81D4C-7F7D-4E24-8D5C-C62BF03CC4D7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gipsum block');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{80615414-B196-478C-ACEA-F70FB787CB35}', 'global', '255', 'material', '2024-11-14 13:06:06', 'panel wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E61AA80F-7265-4C00-BD6A-39BF206DC673}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AFC91465-F5B7-4043-B58D-F47B6464BF02}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster slab');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B103CAD2-4349-49EB-8386-B8C857AA0D9E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plaster slab partition wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{225B1407-43DA-4D90-A767-20EC1D822CA2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Slab wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{099CA5B2-AAC4-4891-83DE-FEC58D8DC329}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Stonework');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{174B68E4-A226-4E82-AAAC-95B00E199914}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Soil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{67F339B3-3028-4A69-8570-5C698F9D4DC7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Coreboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{18925D52-D7D6-4918-99F5-6DE067C9F6A9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'GWB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A514B99D-F920-4BD2-919F-3062C5DDA2EB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gypsum backerboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{462814EB-FDC2-4764-8F8D-716A0804466B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gypsum board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4F858EAE-4491-4266-8F19-0FF23FBAFC6E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gypsum plasterboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{434ED820-9ECB-4A2C-87E4-3E180E1EFD1F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gypsum wallboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{42AEEB4D-161A-44F8-B399-36F0F737C937}', 'global', '255', 'material', '2024-11-14 13:06:06', 'plasterboard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8933865A-DB06-433E-9664-533F839E0F98}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Linoleum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F8FB43FA-A2C3-46B2-ABDF-0CFFDB4D301B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic floor covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AB4E7678-BCBB-4EDE-B300-8B9BAC88F27D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vinyl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B766DB68-4DAB-41EC-A77F-E7400F150538}', 'global', '255', 'material', '2024-11-14 13:06:06', 'raw');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1BEDD5E9-5974-4F92-8BBF-A5E4BE8524BF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Acrylic resin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D5EF9BEF-2D41-469C-A37F-66521D23E3BE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Alkyd resin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3EB08241-8BBD-45E9-8846-146CE61FA66E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Epoxy resin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BFF1B784-E792-4D99-A8DC-034F9A6E8BEF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Polyurethane resin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{53736092-0D3D-40D5-9543-1BA747AD545E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Synthetic resin flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4B782718-8137-47B0-AB5B-E97DEC07B971}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Velux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3C1C0D10-60DE-4926-9A50-61F010E0B45B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Floor screed');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F9701B1E-1E2A-4043-8DE5-7AFBD09530E6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Screed topping');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5A088C65-B1B5-4E08-A204-509C34FA8577}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Seamless floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1D907D2B-C674-4925-9815-F4FED90EDE0B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Seamless flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6A596964-5660-4B86-BDEA-CCF1B793431A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Dry screed flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AA83DC01-CD7A-4BAE-A2E3-B8F9641A662B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{23B84B31-AD57-438F-86E2-DAD6C5FBA66B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bitumen sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BD122630-453F-4B0E-96B5-3D2BC589C9E9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bituminous felt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6B147E27-7DDF-49AD-AEB7-84B00B599391}', 'global', '255', 'material', '2024-11-14 13:06:06', 'bituminous sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{24C4881C-541B-4701-A8B0-9B321B463A04}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bituminous sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D1A72238-709E-40A5-A7AB-7E9EF52BB5C2}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Liner sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{19C7E6E1-B860-41AA-B233-2E6F16FEFD42}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic foil sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B1EEDD10-C63D-4225-9697-B35E4667AB0A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Polymer bitumen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B98F266E-05B0-43F4-AD09-AAD3319689BB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Rag felt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{115D2570-E642-4D22-8984-E8584DC898D6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ready roofing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C65BD167-BDC6-4762-84ED-135E40D55AA7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roofing felt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CF76B025-7B87-4FBD-9550-1357DCC4B879}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roofing paper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{77C72105-444A-46C8-8F4C-42AF0C74FA9D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sealing sheet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{998B98DA-E821-41FE-9C33-4111BA80D9FD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sealing sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FE3808D3-F538-4466-866F-3CED60FA5075}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sheathing felt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3FCDBC16-EABD-4BDF-9DBA-75621534B225}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof sheeting');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C00E7608-55DA-43EF-92D0-CFAD1B27587B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Daylight');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EB4B485D-3C3B-4544-86B6-63683AB4506C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Domelight');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4C8EDFFB-AA9A-4FF0-9ACA-48343E58B0CC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Rooflight');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{61962EE1-6957-41C1-9713-8B85AA281B25}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Log wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B8EDF3B4-55F9-42FB-B061-25F03ABD8293}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Iron');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9DAEA003-BAA2-45AC-9D14-4608F67D2BCC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Counter battens');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{26D4C6C6-5C7D-488D-BCCF-AE91B1352C1F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Counterlathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0B421B5A-4DEF-4770-AF83-C71B4CA0EA5B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cross lathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0F6392B4-98C0-41BA-99B3-C6C0E0918A94}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8BC207AF-65DA-429A-B03B-1C478B6BB261}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof battening');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F06E72D3-4176-42AD-BB7C-07898E7E6800}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof lathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{715033C7-193C-4156-B720-9F42395D77A5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'substructure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4B37F4F6-7153-460C-915D-B43AF113C690}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile battens');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7401AFEF-3EA1-487F-A05C-23567560A253}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Clay Plain tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{05DED94D-FC45-45A8-8874-BF55AC96D55D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Clay roofing tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{885C3AFF-4574-4ACA-B5CE-7A0F63244406}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Flat clay roof tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7BC300F3-FCE2-4ADC-93A0-5191D7FBA2D1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Pantile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{50C09079-C683-428D-A127-8CA8D63E00D7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plain tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9B99DF45-E62B-4CE5-AE4B-224C7DCF9F1A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roofing Tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5F0A1F15-9971-49A9-A9CF-BEAED5366165}', 'global', '255', 'material', '2024-11-14 13:06:06', 'roofing tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5358E47D-AF41-4227-9F7B-E0862EB72FE3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Basecoat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{72E4D20A-9515-452E-81EC-632D701941FD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Brown coat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FA08D032-3069-4FC5-BD61-7091580D7BE1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'First plaster undercoat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{26571AA9-7A56-412C-A271-BEF2F49EB41E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Undercoat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3C1E395C-B3FE-4735-BAF2-2CA03A3B5533}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapor barrier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{66DA0A3B-3EBF-49F2-9D3C-9BE7F304A972}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapor seal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9F1EFDB1-D164-4EBC-9F4C-9CF374B2915C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapour barrier membrane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D6357AE1-A833-4740-9AC5-E19A0AE153D4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapour seal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5862204D-85C7-4C68-B06E-0CEDD1AFF0B9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glass-fibre felt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{02EDDA2C-6965-4CA1-B7DA-42F7ED6C6AFF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Hanging');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{966CB362-8DC5-4E6C-8082-A8EE018BA943}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Jute');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A35D9662-1289-4065-BCD3-24141B21DC12}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Paper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7AEED72C-8863-4CF5-8C46-693B59781B46}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Dampproof concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AEF98DF3-7F86-4D95-80CA-5F61EDD66B46}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Water-repellent concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{76F7A34E-C0D5-4A60-A263-BF2603D5B0C7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Watertight concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{86DCFF40-17A1-4915-AED8-3F8EEE1E5BEC}', 'global', '255', 'material', '2025-01-15 15:13:44', 'waterproof coating');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{34469938-9D5C-404D-AC03-ED1765D2F163}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof coating');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{60EBA0D9-244A-4696-B851-927EBCD97866}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9B74FA77-F147-4949-B07D-8620EFC316CA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1AC40E7E-F54E-4C72-82B8-4199928025EA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'wood');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CF934104-602E-4062-BE56-3A2A793A685C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B3AC3569-AE97-4343-9C5F-6BC5672EBEDD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber-framed construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0CE5C30D-DD82-460C-A17A-8F8CE890934F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber-framed structure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CB90A19E-08B9-4DB6-8D50-5B9CFDFB4B5A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber-framed wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B6002AB3-913C-452B-8406-1818EFE18717}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timbering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CF3E8BEF-3CED-4C61-AE2A-4352F3F9753A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Trussed partition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B4C93487-5491-4C31-A193-1D7B31204B87}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{04F28513-2486-4ACB-88E9-3A70DE94863B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood-frame construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{62537B33-1E1E-4967-BAF9-C9597D12E6A8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4B899CC2-7D68-46B8-BA05-08F7583EFC6E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden framework wall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{73A43961-A316-4ACC-8259-16A763C66349}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden panel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{59E21868-692D-4BC5-8570-58FDB6299154}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bevel siding');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{30FE8D15-3367-405C-9BE9-06A9B6E69E63}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Board sheathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1FF6D791-5077-4460-B694-5F7606A97B6F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lap siding');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ADC21147-EED9-4EF2-AF8B-C8D04C615DDB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Profiled timber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1DDAE0C7-2C4D-44E1-9B8A-2CD81B5B0517}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof boarding');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5CA62483-8AD8-42BD-B250-334A8F04E9A3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof sheathing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{14949710-AF5E-4257-BC6F-E5E66833850C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Sarking board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0A4EB7F8-C050-4BB0-B6BD-E1BB89AA9D03}', 'global', '255', 'material', '2024-11-14 13:06:06', 'timber lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{442A7B50-7B60-45FF-9687-C498E7D86486}', 'global', '255', 'material', '2024-11-14 13:06:06', 'timber surfacing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2B29592B-F964-4B20-95CC-2719BB2F555D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'V jointed board');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{51397FBF-D6A8-43E3-A648-40C7CA52872D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'wood board lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ACDFDD31-A8E1-4C25-B32B-0026B99C21E6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'wood covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{99C887F1-C457-40DA-98BB-17F0FEAA3FD4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Bar parquet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1A97546A-BDC4-42DA-BE3D-EA935D965F88}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Board parquet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{608370CC-6465-413C-8D0A-27E278FCA2E8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Boarded floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8D345A37-4371-49ED-8630-7747872F78A4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Finished parquet deals');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D02C9779-D786-4EE3-8AEA-BEA842EDB666}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EE7E3201-1198-4AD8-BF04-E2CB82DF2459}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Mosaic parquet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E3CD7593-4368-46D4-B0A6-E34AF5DA0613}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Parquet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{35352294-1488-4ED4-B700-9F73C8F4C6D9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Parquet panel flooring');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{57E86498-DBA0-46DF-B1AA-08C6F614F100}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Parquetry');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B465E3B8-C594-4F0B-973F-791D8B707B92}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Planking');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DE996098-8918-4257-A1FE-1E3324179E65}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{20FC965D-3F87-4158-8962-18F6D2CED361}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Timber flooring finish');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0D7514F9-5A4A-4765-8780-6822632561B7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood strip');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3F09DBEB-51A5-45AB-A719-767297DFB066}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden floor covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6B803A2B-04BC-4766-86D5-44BD66F6011A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Dead floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4DC97BF3-FF8F-4A54-A800-E28C92EDAF21}', 'global', '255', 'material', '2024-11-14 13:06:06', 'False floor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{32D497CC-EB20-41C2-AAD0-5B968488856B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Spaced timber subfloor');
-- values `fr_fr`
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Acier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{66D375E3-65EF-4C51-BD95-BC98F78D8A3A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A7A07123-CDD4-4EEA-AE43-9619AB85CE12}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EED946E1-2E6E-46B6-BE91-860E37C2F468}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F8E42185-71BF-42DF-AA02-8B7D1CF86934}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8B9BF69D-22E0-4C0A-BF8C-F7C66C2F4FB3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Barrière-vapeur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{93215B39-99A0-4A93-9590-02D17F3445B7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton maigre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{10819925-1CF9-420D-97E9-FBA457A2BB44}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-celluraire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{938E52E7-9CEB-4493-BA85-7B13D1E2CC7D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-dur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{813AE174-47A3-4160-AD54-4EF81B55AA67}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-étanche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8145EBD4-2FE3-4B79-AC70-C9E2F5CDA55C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-sous-vide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{123A70B4-9D09-44B1-AF7D-07D35B31DA6F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bitume-froid');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{504BD567-B748-4C49-BBF7-681AD8812202}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0CF49364-94C7-4196-B051-262DDF177255}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois lamellé-collé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FF188BCF-5F18-4E93-AA5B-30E1D7D61F77}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois-Métal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique s-c');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique t-c');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7B68DB35-D03E-4467-8135-C061DD44755C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique-béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7CAF2DD3-7530-40C6-ADCA-E18CBA80F591}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6CCDB136-7753-4D64-A332-9AF769971AA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut-application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A43B747F-39DE-47B1-A1DF-6D47217F9802}', 'global', '255', 'material', '2024-11-14 14:23:10', 'C-béton-mançonnerie-préfabriqués');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4D4899C9-DB69-42E0-9974-83D72F7B47E3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Canalisation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6A23C638-0EFB-48FB-BF26-F15DCC98E9B8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau-métallique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{51A8CBF7-F6B7-4064-9ADD-BF09B97768C5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreaux t-c');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C2DDAF5D-26BB-479D-82EA-0E9290CD377F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carrelage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8208505B-79BD-4002-9245-81FBFC78AA0F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape fluide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FA732F26-2691-41AA-A605-3996D725095D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9002111F-10ED-4503-B9E8-BF6632C4F0F1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape-ciment-application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4D32674C-59A4-4D8F-9525-571473530B7D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Charpente-iso');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CEBDEC3F-C089-46E8-9957-125ED85F1D66}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chauffage-sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{45684AE9-65FD-44C9-912E-9E3E19482C17}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9A4C50F5-1AE2-40E3-9C83-DE3B603DE781}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-cabine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0EC0F9F4-36EA-4D93-8BD6-59197A16822B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-carreaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{92244F82-C4A2-403E-A3D6-5298E3EE6A8E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-claire-voie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{493DE1E6-E61B-4466-B1E6-1F3751319D2E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-légère');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7D47751F-CDCE-4671-AEF0-80BB790205B2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-mobile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F6A288DF-A8A4-4785-A395-061660949690}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{43D71A25-D40F-4CCE-B0E5-3A03BF7817CD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction-bois-massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A205D5C6-0D8E-4DBB-872F-06323A5AA742}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contreplaqué massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FCAF280F-152E-4A3F-BBD7-D37D21144BD3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Couche-finition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A29229A2-4D50-4767-8F92-35C90C2FDEA1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cuisine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{25DEA72B-0D9D-4663-8A23-95FCABBB14EE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Drain');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E5E5CBB1-0318-4518-85D9-277CFB509E5A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Élément-chape-sèche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4E294F45-6B56-4316-BFE2-509CC3381B69}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit-fond');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{803A22E9-DE76-4217-887F-0DE14C2E55EB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit-synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8D7553CC-C3A3-4426-B98B-C6FDD7EC932C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1D05865A-2215-415E-BBDE-66026FC6722A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faux-plancher');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E5D80C16-CEE4-4D8A-A3E2-F79687C09218}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faux-planchers techniques');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{185A17B1-2282-4FEF-A85C-6F1CC6C1A166}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fibres-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EC6384BD-85BE-4FE5-A7EB-B456616323AF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fonte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{60337298-38EB-44F8-8457-4D2952D2B8A6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gazon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gravier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5282B47E-ED1B-431B-8A0F-A278A1574DC3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso façade');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8C464613-50EB-43C0-A8D9-F101E4E00B1A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso poutre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5BC572C5-1EE9-40E3-98E4-1BE15D69242D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-bruit-chocs');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3723BE0A-F958-4CBC-9487-542E78C1934F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-pente');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6E0ED961-8ADE-421D-B750-A1A16735FB11}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{40867852-1B7D-4745-ABAB-DE907F1FF2E4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolant pl.d.plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BA936C3C-C9F5-42D2-9FD3-69BF0C1C7927}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation-extérieure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F308C9E3-FF0A-492A-91E6-927942843135}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lambrissage-plénum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0C1318A0-20A7-4306-B42E-AAF17256ECDC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lanterneaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{92B88334-4500-4EBF-9E26-D8B210BE282A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lé-étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DB35A850-E850-4757-9B27-3072148A17CF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{13C75F99-D541-41E9-B910-659EF0D68984}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lucarne-lambrissage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{602766C4-FB19-49C7-BBD6-9AC2F54B6AB3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Maçonnerie-parement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{761CBD3A-1AB5-4AE1-8EA3-BFCACD619684}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Matière synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3CB53B5A-A8F2-4EDC-957E-3C9E360A11DF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Métal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{83438D0B-645E-41C5-AD43-DCC5443DB775}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Métal-léger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AFA4AE24-0EE2-48D4-8AA0-C086861DB6E9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau solaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CA897DB0-ACDB-49E0-99CF-33244EA92111}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau-fibres-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{01DEDBD4-6469-496A-81EC-26EF0EEE07EF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau-insonorisant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C62DA86C-8D05-4FEB-93D6-4C58F87AC953}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pavage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E412AC24-5677-4088-9A1B-241F0E7F0F37}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-artificielle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FA14F30B-5887-43E0-8E31-5264A2E0C8CB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-naturelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E9AB9B81-51BB-44D4-999F-529386858E36}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-réfractaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B911312A-B11A-4345-8FEB-3F5624AF1B5E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plancher-mixte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D91BC45D-19E7-46E7-AEA7-BF82DDFBF455}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plantation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{81EE5064-E14F-4051-92F6-CE3ECB0A0ECF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque-filtrante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0956256C-EBCF-40E6-B32E-F6EC9123126F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque-plâtre-fibres');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0A891D45-D04F-46D5-AAB1-97A917A485BE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1FADC367-7C96-485A-8419-5CD5DF34333C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plâtre-cartoné');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A265C466-3DDC-4674-BD67-3EFAADAD91E3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plenum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7D8D041D-CE45-4E83-8593-BF8CA3508984}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Produit-dérivé-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0EA9C493-7022-4686-A289-F2EF73EF93D8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Regard');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BE244C39-BB39-4434-A75C-CCA312A018E0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revt-sans-joints');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F72DBA11-C0EC-4869-9322-762B30EB37EC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revt-sol-synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{07B9B859-06CD-4BFD-AAD9-0000877D7D63}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2EC46512-7ECC-43A3-985B-54208CDD9AAA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Support-bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4C6EB41F-EBF8-4051-9588-2C3DCA5B6481}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C35F4DFE-3178-4BE8-99E7-234784B37D1C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapisserie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{662D1329-57DB-46D3-8EFE-7383413509C3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tissu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BC89B42F-37C1-42CD-BCFA-AE4682391014}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Végétalisation de toiture');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{07BDCDC7-C21D-4DE8-9630-BFEFBE14DDB2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Velux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7C233D59-3200-412C-8F51-E7443767F1C1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Verre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E358324A-4A5A-4FD5-A4BE-5B612CA861DE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Xylolithe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA319486-CA79-49B1-BA29-C9D0560278A8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'acier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C7C0BC70-99B9-46CF-AC41-F132FB8D793D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F7F7BDF3-360F-4223-9BC8-16FAE0BA1CA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Adigeon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BAE32058-C975-44FD-B8D2-27B06733D557}', 'global', '255', 'material', '2024-11-14 14:23:10', 'application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0B3F8EF2-005D-46B4-B242-C55C1E4C2A3B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dispersion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6469F660-4EE1-436D-9E34-B87089AE8C75}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Glacis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{97B26F83-5DE6-4680-A891-028CE09B71C6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Glacis à l\'huile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C30929F5-9012-470D-B164-772666D75E63}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Glacis acrylique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{68A47539-7041-4B46-8AF4-8A93684685E6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Glacis dispersion au silicate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ECC749BE-9C60-4D39-B7F4-FCACBC18135A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Mordant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{013A55F6-4000-4ACB-99EC-C29C1781A7DB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peint');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{450BD1DE-CDD3-4F9C-9567-B8E9C4AB5560}', 'global', '255', 'material', '2024-11-14 14:23:10', 'peint');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3F2306FD-1C1B-4C52-A305-45EC5338932A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DBC79D3B-922F-4EB7-9126-F70721E7C526}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture à l\'huile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CD69F29B-C442-420F-B829-E95AC2F46C53}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture à la chaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3CC8B132-B288-44B9-811E-08467256B241}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture à la résine alkyde');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F18B04F8-F2E9-4E3F-BABE-2764BBDEA7E6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture acrylique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{254E5D09-FCD0-40EB-B962-AB2E1D144367}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture dispersion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{598B66B0-D625-4D65-9A62-81EEED3EE7EC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture dispersion au silicate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B3C22394-DDE7-40E6-B761-0ABBD985674C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture micacée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B7B9257F-ECF2-44C3-9059-680716367BA9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Peinture pour sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{42526318-0B04-4D0C-B6BD-4962BFEEF76A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Résine époxy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D76D0964-4190-44B2-8AFB-0D7CD79A616B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Verni');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{86750902-10F6-48A4-9323-9699DE631450}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vernis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{876E98E8-B56C-45BF-8AF1-81EC4CE9EB88}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vernis à l\'huile et à la résine naturelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{329A9EDD-FD2E-4063-B3D1-AC966F9EC6BA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vernis à la résine alkyde');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9272C2DB-9EDC-416B-816B-05FBA304693A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vernis acrylique pour parquets');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EE1B1F3B-FF17-467F-82E7-6B133C9BA99B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vernis au polyuréthane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{51AA6B7D-1372-45A7-83F7-24DE8A2A9A5E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC B H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{93C79FD2-05E9-46F6-AB01-B8E1739067DC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC B S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{59E0D40E-A446-4E7E-9E5A-3F220A417D10}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8EF2ED7C-9024-4836-A71C-BCF6544C63D3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{985C04F2-C56F-4B9B-8FE2-40E4EEBA8B8D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{375EEC21-A84B-4915-923A-5C69C83CA98C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC N');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{083FE056-F1DF-466F-B067-7D245341F99A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{41D6EB02-5631-4544-A588-5E68499E6505}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC T');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{58A4F0BE-CBA8-4D62-A2C3-954630049A54}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC T H');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{34F7EE02-EC98-4086-9C03-5E5CD7A2D76D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC T L');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EBBE5855-6B6B-48A4-90E7-0E581B4F452D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'AC T S');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F7C665DE-A6A1-4FCF-BD33-C95E81047D27}', 'global', '255', 'material', '2024-11-14 14:23:10', 'asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C0DF20C5-336D-4EDE-9BEE-E8850541E834}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Asphalte coulé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{804AB273-52BE-421A-9F3F-A8D0FAFDC33B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Asphalte coulé routier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{52F00B0A-C54E-48BB-BB99-F4BE62C71EE9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Couche bitumineuse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1082A102-EDC2-49BC-8AF3-7C83008DA823}', 'global', '255', 'material', '2024-11-14 14:23:10', 'HMT');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EDDD7D81-AE9D-42EB-B291-25C7068E429F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'bardage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{778FBBB0-B4D7-4916-B9CF-C79F2B131944}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E12A0345-BACB-4C30-855A-A339653D5578}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage en planches');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D289591E-7635-4DFD-A00E-0DCF6628DF8B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Frisette pin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9AA4E2B3-09A5-4FA7-886C-D834760024C2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lambrissage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{31DC0CF3-BA61-4E92-AA86-7B9A9EB73645}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lambrissage à clin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B3F8086C-B903-4002-885D-EC5056853640}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lame à chanfrein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{812F48DC-B907-4998-B21F-44CACC469697}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lame de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E52D609B-C8AB-44AF-A313-650ACA757EFB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lame pour pose à clin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C75BAE23-BE41-4A34-BEB9-402633B93BDF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D0258F2A-4FF6-4E90-A690-A463258BD6DF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{85CF75CC-7475-43A2-A87E-AFE9C120728E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Planche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{16D12E0A-D4E8-4BE5-A27E-5F4289C1CF8F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Planches');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C2BD4489-D7E9-41DC-BEBA-C60DFAF51FA4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tavillon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{815DDBEE-CB9D-48D8-8D20-D617EE6E5E5D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tavillons');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EFCD0775-E660-4AF4-8C8D-AF9BE4583CEB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Voligeage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B9F8C849-30EB-4E35-8C3C-9540A3FC4551}', 'global', '255', 'material', '2024-11-14 14:23:10', 'barrière-vapeur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{59E5DEFC-3323-463E-907B-4BD9C58F6F41}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pare-vapeur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BAB1D88C-15B1-4FC1-8ABC-312370D89DBE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1088BE88-C64E-427E-8005-048A12FC38C6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton à air occlus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{21A96072-8BF3-4686-A319-91CD708DFF2A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton aéré');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EB8CE300-98DC-43E7-89F6-DA6050FD16F2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton allégé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1486BEDA-91AA-489E-BF20-187849B58657}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton alvéolé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B4560241-B2BE-45D6-8A0D-8C7D34236A50}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton armé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FEE09835-9AFF-47A5-9DA8-3712990837BD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton de recyclage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{639929FF-6EC2-41A7-A4CD-081E59EA1A41}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK A');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5574F3A3-8CA2-48FD-BF11-A22C11958A4A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{543059E7-0E1C-4684-B76D-AEA0205B05F0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK C');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{60BF2A85-1CDD-45E2-8BFD-0252A5C41F65}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK D');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E9C0E8F5-638A-46AB-ACDC-5E074FC6903D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK E');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7DA88453-9636-492C-AE12-0375F4A0E046}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK F');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E6A1C6D0-AE14-4FCE-8B3B-CC5494B82AEB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'NPK G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{95B50FC1-4F55-4716-A897-974E7FB9593B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton de propreté');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2A32D430-6200-41E7-A4CF-811A87C1E90F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'béton de propreté');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E65A1DB5-3CEB-494D-BE91-FDAA60E485E1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'couche de propreté');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{784845FB-8235-4035-8F4C-C9FB5CFC8300}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Couche de propreté');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{32E69993-59C5-4A58-9389-95C685602E53}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8E19D3FF-3C57-4735-8C53-2CCF37411BD0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire légere');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EDD0BCDA-5E64-4A4F-AC46-C5EC0A7F9D04}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire légere MPL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{99573DBE-B4E2-4292-B834-2367FBB2EDE8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire légere MPLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A4889965-5A1A-422C-84D0-0BAA0DAAD99D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire MP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5426C1F2-E402-4450-ABE1-5AB16F072470}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton celluraire MPD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3CE357B9-D109-4E95-9266-F57CFA0B4E71}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A2BB9283-151C-483F-A691-E9924F976FA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MPD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A62B27A6-CD06-40CC-B5C3-7E98DF1A1F02}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MPL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BE640FD0-B116-4B0C-ADC8-F124ECC2AD95}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MPLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5EEE467D-BDF1-4D1A-947E-1D3129BFF6F9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Ytong');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B39ED600-A99B-4F59-9CD8-26E60C76D2B4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton dur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3711A6A9-DD71-4AA7-B408-7EE295613382}', 'global', '255', 'material', '2024-11-14 14:23:10', 'béton dur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3350B229-77E2-433E-8BDA-DA9E00E5CDF9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement de sol en béton dur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9DC03E67-9C03-4C8E-A0AF-8E2C2B98ABA3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement en béton dur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2D9B62FB-B29E-4C8F-9BFE-E8EB443AC451}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton étanche à l\'eau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5031376D-AF83-4460-AF39-748CD596F3BC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'béton étanche à l\'eau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C40CD3EA-61D9-4ADF-8F5F-5666030F6713}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton densifié sous vide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0D2D3309-2B65-4DDA-8BE3-9AE386AC02E8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Monobeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{89E52080-8511-457E-A5BB-B06608AE6947}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bitume à froid');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{189147C2-3AC6-43DF-948B-410C24AC6351}', 'global', '255', 'material', '2024-11-14 14:23:10', 'bitume à froid');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EFD4063E-99B7-46E0-840B-338BE91B7D88}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement de sol au bitume à froid');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1A0ED450-5A69-47C1-B36F-EFCD6B9EB3D7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FFCD7994-238B-4812-8E59-D79ACE613A62}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois lamellé collé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{94F02505-0A59-4DCA-B7B9-AE27D22321FA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'bois lamellé-collé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BB084D08-D737-43FD-82C4-EECA5659090A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'bois-métal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1BB5213F-2CAB-405F-A2F3-69654C64A73B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois-métal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7B444EC9-1221-4964-B653-0BEB65024D3C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique silico-calcaires');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D7796927-29A0-4D6A-9D08-E625E4635A8A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique silico-calcaires MK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{765484F1-938D-47D5-9C91-81B5BAA5FFBC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique silico-calcaires MKD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5EC79F2F-C83D-4230-AABF-D983CAE0130C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MK');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4ACC7C48-A1CD-4C51-8DD6-BCC2F7868420}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MKD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{165ABBDD-C32C-4BB5-B547-32FED8C367F4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bloc creuse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F32BFE32-F91B-497A-8093-B51AE9B5D40F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bloc perforé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0EDA4523-6AE2-4F49-888E-4E5C65DD8105}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bloc perforé t-c');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4533F347-DE17-42EA-9193-500FD35AFB44}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bloc pleine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{22211E3C-94AE-4C16-81BC-EE11F5C9652D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Blocs creux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7853E799-6091-4BB2-8A3F-B71E9B040ECB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Blocs peins');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3222CD3F-71A4-4682-AE71-136DB65ACB0B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique creuse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{325F34ED-8A77-4685-971E-1953209B4172}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de structure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9404D72B-223F-44FA-BE5E-8629E82B3E5A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de terre cuite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B5577D0B-F1BB-426F-973D-C029858AAFED}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brique de terre cuite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{09B585A2-8B20-4AD6-83A9-40F1B5A2F593}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de terre cuite légères');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EE84F66A-73E9-438B-8B68-416167F2297A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brique de terre cuite légères');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CA93B71C-6477-4CE3-8310-D6956F2C619C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brique de terre cuite légères MBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7F2BF1AE-B2E6-4D6D-89FD-DA49306AB310}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de terre cuite légères MBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{818A2AA4-DC4A-4D9C-9766-BB4C638A1A71}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de terre cuite légères MBLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3F40B4FE-D57C-4F42-BBC7-08D995F80B12}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brique de terre cuite légères MBLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{58127D79-FC94-44B2-8BE5-34E64E558A9F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique isolante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8FC52B7D-ECE9-440C-B220-D026C50CCB1B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique perforée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5780EF7A-4496-446C-89A1-7FB802E25932}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique perforée t-c');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1A07A875-A3CB-4036-ABF4-D70E150DF98E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique pleine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A98CDCD3-6859-4698-A970-A2C708796067}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique RJ');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4CC57D0B-0A66-436E-A566-E8A5D0B51D29}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Calmo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{53849377-F66B-48FD-9741-FF1747CCDD18}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{476AEB7E-18C3-4D55-8C77-0288ABFAA852}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MBD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{639E002D-F129-47C4-AC18-B940518ECAFA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MBL');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{00AA2899-57D2-4CE7-BDBE-1DA370A84EAB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MBLD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FC7C057F-1A19-4FA9-94AE-C615ADF2D170}', 'global', '255', 'material', '2024-11-14 14:23:10', 'monomur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E3C23DEB-02A5-4CAB-8A8F-2A4D97D40A4F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Monomur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B0B3D907-8417-4906-AC84-631A9F611BAB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Agglomérés de ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F7C7F02D-5456-47CF-8A90-94A45AC732A9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bloc coffrants de ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{52477A94-71EB-47FC-BC83-46CAF3B4ADE9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de coffrage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{419DAF6F-269B-4275-B13F-220789D62AD7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2A2C00F6-2D2B-4897-8189-2F3419153D33}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique en ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6B73ED38-9734-4A47-B468-ED3F8D4AA742}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5E7777D1-C3A7-4BEB-918F-1D27C5F08748}', 'global', '255', 'material', '2024-11-14 14:23:10', 'MCD');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{65A21CE4-1853-42B7-BF36-4237180823BA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plot ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BF90E5FC-44F0-4F88-B06D-E2EE019900F8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brut');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B8FF254B-9412-4364-8B86-94DFB348A276}', 'global', '255', 'material', '2024-11-14 14:23:10', 'brut application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A369DCCE-6304-4B7E-9A9C-BE771AC8B240}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AB4E8CFF-7E01-4941-9B90-69F8A4CF8311}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut peint');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B4C05CDE-A412-4F4A-9C86-7DA06003699C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut/application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{14E927E0-28AA-4461-B27E-AAFCF91C5056}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Construction préfabriqués en béton et en mançonnerie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{278590EA-2289-488B-9F12-B76023B51080}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Elément en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{15F7D634-88F3-46B7-AD08-57817352DC58}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Elément en béton cellulaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C5DCBE07-BE3B-4FD3-A16F-8157D0800867}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Elément en béton légère');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1E106A14-D6DE-4447-A1D6-4EF365E5F8ED}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux en maçonnerie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8B609566-2AC2-4AEF-BED6-8B4D821628D0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'EN-GJS-R');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{64B5C253-EF99-4574-B3BF-59689C15D3D4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'FC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D3C95F7D-24B4-421E-8A06-77ED9338F7EF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{792CB3D8-ADAE-400A-9379-A2EFB9D27D05}', 'global', '255', 'material', '2024-11-14 14:23:10', 'pvc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{02BFB7E6-B415-44CF-8A47-4DDBC548BD05}', 'global', '255', 'material', '2024-11-14 14:23:10', 'PVC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CD0E2E88-8FB0-4A65-9C4D-256454BC1A0E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3673E3A7-F5B3-46EF-8C04-BCFCD8C71B86}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-B armé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A7F80B82-5EA1-4546-9695-A496F4F9B248}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-B non armé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B0CA7021-5D71-45B0-A95A-796EFC499F75}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-FC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1EB99C43-0FB4-4430-9B4F-30D2D931D514}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8F9547B2-D293-4173-9490-A762DF9F1143}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4B29A292-1B1D-42B7-BF8B-A3878331B3A5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-PP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{607AF520-E16C-4986-A1E0-27AC43B843C0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-PRV');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A8965A79-F9FE-41FD-BE74-5D5308483787}', 'global', '255', 'material', '2024-11-14 14:23:10', 'T-PVC-U');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9B0B0F7C-AF2D-4B09-9D09-F6144F8439F9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tubes T-PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CC614A5C-1193-4A85-937A-6872E5FF5A48}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tubes T-PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5E85FED7-885E-41B2-B856-885FA1070E0A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tubes T-PP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3249AD93-2FFD-41FB-BFB2-30EC2F142229}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tubes T-PRV');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2DFC433F-63E0-481F-9EA6-C49E7D242DD6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tubes T-PVC-U');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8B18BA07-6877-43E4-8E45-6BFE8BA2368E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyau en fonte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{60AB10E7-4BD5-4825-910D-E814176889AF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tuyaux en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{252BAC70-D557-44E1-8323-3E07E02D517A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EBC70B60-3B02-4340-8886-9B4EF7AAF9B8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux en béton T-B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7465C201-EE34-4ACA-998C-2542AE71A902}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux fibres-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C217A71C-69E5-48A8-BB69-43A668D0423B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux fibres-ciment T-FC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CB82231D-0B21-48D0-B0CE-16C9123EFC28}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux fonte ductile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0D9048C6-A344-40AF-8D18-DC5D95CE7D3C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux grès');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F4C3AAD3-25C3-4C87-80E2-5E332E2AA8C9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux grès T-G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C19E0EC7-0217-4C7F-8960-BF578272C730}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bacs métalliques');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7C16DA38-9E51-47D3-BBE8-FDEE60D74CE3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau métallique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BD42EDCC-8BB4-47AC-AAA6-CC5297A6C635}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lame métallique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6A72116F-EB2B-40AD-81E6-BF45AA782716}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique plâtrière');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B8714D24-C4EF-4AD8-9770-BA02E79D45DF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreaux en terre cuite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{128F362C-D510-42EE-ADD7-A2EFDBB02508}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreaux terre cuite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B11B65F7-E741-4087-B181-A176074EA037}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Zellton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5BB5B4B2-A9D4-484F-8F63-CC9401D24855}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau céramique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DC74C392-8B1F-4B7A-86A4-EF55182FBEF0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau clinker');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8E5743F6-3C67-4911-817A-E1A346C7B466}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau de faïence');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BAA95E61-E796-4B79-9E9E-0BA22E94BBAA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carrelage céramique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CA16C89E-FD52-44CF-BD64-C6DC85B7DA34}', 'global', '255', 'material', '2024-11-14 14:23:10', 'carrelage céramique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{67360D97-0ADA-47C6-9614-6304506A16CA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carrelage en terre cuite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E0E51FB9-B590-4ADD-AF36-11B6B194891D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'faïence');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{94BCA705-F366-421F-A594-A82DC639DF6E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faïence');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0AD5B426-A284-44F8-8156-D3A2824A1717}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Paque de céramique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{05348E99-05BB-425A-B32C-D80A7F9F1905}', 'global', '255', 'material', '2024-11-14 14:23:10', 'chape fluide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F7073CD9-E0F9-446B-9797-800473083DE7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape à base de ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E39595A2-FB59-4CD6-8E2F-351BADDD7F27}', 'global', '255', 'material', '2024-11-14 14:23:10', 'chape à base de ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8C42D108-ECD4-49FC-AA95-B9D0CC17D7BE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape adhérente');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BF4C8F92-A451-464F-AD54-D5AC3BC59649}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5B839D9A-FF78-43AD-9883-63B3979D0457}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape flottante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0F0070C3-98C1-4D4B-9A3D-01EE4912FD66}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape à base de ciment/application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6DD14FCB-6AEB-4D15-B4F1-ECACEBA3E2FB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'chape à base de ciment/application');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3590628E-C3DD-4623-8D65-052EFC3286C3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation charpente');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BE1EECAA-F68C-4A2A-BFD4-57F20141DBB4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'chauffage par le sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{635FE4EA-4634-4730-A4FF-48408D1EAA32}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chauffage par le sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A7F88127-3531-4DAF-B7E3-4F70CE7EAC22}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5F87F34B-051A-4411-BB01-3A0F365A568C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison en éléments');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D25E8DFE-E5A1-4C0F-8942-B9FFB4DA7AA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Séparation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7B5D8F6E-20C6-4F28-8D95-409B6863F56E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison de cabine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E262A864-23D1-4C28-90D4-E3DBA6819D77}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison de cabine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DD8959F6-24AC-4758-BA05-C90D0D8E1C15}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Séparation de WC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{56731B30-7D33-4A4C-BEFF-9AAF41AB7D99}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Alba');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1C8B1E3E-57D8-436C-B1CB-F163B5232998}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Alba hydro');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1CC077C4-316B-44DA-8E20-7593F4ACB275}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Albaphon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{982A6091-D47A-4072-A02A-0B7F41370AFC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Albatherm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EF2B6E80-4904-45D0-A9B9-A858EABE2AB0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreaux de plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6BCAF8CD-636C-4E34-89F5-A4FC20CCA49C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison en carreaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{45502421-10D2-4857-ABA1-71097253EBFC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison en carreaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{55BCF770-CEE7-463D-99AC-7DFFA0F40BD5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison en carreaux de plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{84B4F24E-C567-4B33-B00B-BBA3C5137AC2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plaque de plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8E5280DE-8F30-4AC9-BFF2-94809EB7ECE1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque de plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EFE09DF8-B624-4182-9444-831CC3022ACE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison à claire-voie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C61058EC-CB5A-4A82-BF4E-70A2535F5D29}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison à claire-voie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7C9D1296-75B4-4948-AC9B-2314FBD8F47B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison à claire-voie en lattes');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{447AF20B-9A6C-447F-BE3A-0FF18E032B8F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison grillagée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9A0715B2-05A8-44FB-AC83-EF5F2CF80E9C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Clôture en grillage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{907913F9-63A5-4D89-B507-F477B7E596FE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison de distribution');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{47585E30-EF01-4949-B527-2360697ACEDD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison de doublage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{65A573EC-012C-48C9-89C2-5F5F36DC6EB5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison légère');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FB23F251-104A-4236-B120-FFDEB1D51677}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison légère sur montants métalliques');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{77D3F184-7717-4291-ACF1-7BD440009535}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison séparative');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C643FDF1-7BC9-4C64-B291-2AB16FBC728F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison coulissante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CF276236-22D5-4C4F-9D5D-72E141BC1468}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison mobile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A84D0AD6-7083-4870-9A1C-F2CB9E501ED5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison mobile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FE7E70AF-71E9-43C0-8704-567FF1B3EA81}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-accordéon coulissante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8382012A-5DB5-48D7-8CA9-F98F11D10B61}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-accordéon repliable');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D5B9D33A-CAB3-44EA-A53F-0B355D8670EB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cadre en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E17319C6-32C4-4A35-97DD-EF5E4046238A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison à montants en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B78EFFBA-4AE8-4248-883F-CB0C0778FD71}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison à montants en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4D01325A-291B-4D13-8A1E-BE21D991F393}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cloison à ossature horizontale');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5B30D489-BEC5-4BB0-A0C0-735540B431FC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison à ossature horizontale');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FD1DFCCF-942A-46F3-B442-F5D0F0969E48}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Construction à pans de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{32A986AD-037B-46F3-BA69-976C257A0334}', 'global', '255', 'material', '2024-11-14 14:23:10', 'construction à pans de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA6A7431-CB20-47D7-9015-DEA056E53BB4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Construction en éléments préassemblés à cadre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{36F4E6E6-EF90-4377-A57B-678AA55D90DA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'construction en panneaux de bois préfabriqués');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5FD1D0DB-355B-4F49-A311-D80FB2D36D98}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Construction en panneaux de bois préfabriqués');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C59F24C5-E1FE-4F1F-A7AE-0D6C93B230C9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'constuction en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FE109040-C990-49C0-8C2B-B4DE45CF272E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7C1190C4-1C1B-4BFE-8E2E-8C5B0B2CADCC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pan de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{455F14F4-CD2F-4C73-8D7E-D3D207B7959C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'pan de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FAF934BD-0D93-4945-91E5-B860BADA9B1D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison avec ossature à montants');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4A2D5DF9-7F32-4945-A847-7A2C39B51165}', 'global', '255', 'material', '2024-11-14 14:23:10', 'constuction en bois massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ADF8554C-71DB-4158-AD89-5B7B49DD1B6D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction en bois massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3FEFC426-F428-4DD3-92FE-F3526EE7AFCB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lamellé-cloué');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FF599303-AC90-46EC-A8DB-430E7C8135A4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lamellé-tourillonné');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BCD62094-60C2-4392-AC4B-E4094D520DF9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pan de bois massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D3226FC0-5487-47D0-AD6A-C5099C159541}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Paroi en madriers empilés');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B60D264F-AA63-48BD-A710-0648878A034D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'paroi en madriers empilés');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{33B8D962-3175-4028-88F9-318C790D014E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parois en bois massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{91723F16-64F6-40AF-96B4-CC595C313834}', 'global', '255', 'material', '2024-11-14 14:23:10', 'parois en bois massiv');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0D99E988-D842-4651-9D5D-63C0C86E4796}', 'global', '255', 'material', '2024-11-14 14:23:10', 'panneau de contreplaqué massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A7F2E903-B656-4EF0-9B76-A51FE6A5761C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'couche de finition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA0EE3B7-CC8D-4A97-84F3-07708699095C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Couche de finition');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7DCE3B42-B189-4697-AA87-AE25F3004172}', 'global', '255', 'material', '2024-11-14 14:23:10', 'crépi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6C1C51EB-61D2-4B0F-BCCA-7757CCDF116F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9413835E-1EAB-408C-B463-A3EE166C7B12}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi au silicate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D51D7359-7B32-4917-A2E6-D9685ECF8EAE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi minéral');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{88705A04-16AD-4A7E-A0C5-BD3EA3E14003}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi ribbé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8953C11C-41D8-41A7-B221-4DE307EAD2AE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E8F50454-ECED-4E25-A1CD-B384B17DFA92}', 'global', '255', 'material', '2024-11-14 14:23:10', 'crépis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{810331EC-4ADD-4D06-8D43-6DE54DC899AF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8E4B1D15-16FE-4B72-B12D-3C1690C04A3B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépis a la résine silicone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8A6FD0C6-A92C-409E-9EBD-32C1842AC4A9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit au plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A8176A03-FDB2-49A0-81C7-503964F4BA98}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cuisine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AF0AA43D-B846-4F7F-B391-648BC94B703A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cuisinette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A5B0B937-A8D4-4EE1-9EF6-CD798C737FA6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cuisinette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9C70FA2D-84CE-4342-9874-02F5B11E1F48}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Kitchenette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA5BB312-A688-4011-B2A0-323EB6FBA6FB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'kitchenette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{201F2790-E4FB-4745-9135-338BC2F1D1BB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Zone de cuisson');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{420CEBD6-9760-4761-B7A3-724FE8743952}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7161F599-090E-4660-965F-E0CDCC2B767B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-B armé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5FB983A8-BB57-401A-B5F5-7F7CB115BAB3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-B non armé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3917E742-0636-4124-888D-BBD1182EE00B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BE20D980-9935-4DCA-90A7-2C6D7AE555A6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-PE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{01B8729C-406A-47B8-82B5-B5621E7428E2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-PP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A748CE42-351D-4B91-824A-223D7C031400}', 'global', '255', 'material', '2024-11-14 14:23:10', 'D-PVC-U');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B1DCAF03-E201-4A8E-8BD3-4B9996FA94B2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'drain');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7F41D0C4-A848-4B15-9AA9-98D9B74587BE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Drains grès D-G');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C2942EC3-0A5B-40D7-AB68-C9A6D61E0F11}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuyaux en béton D-B');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C25C770B-730C-44F9-A846-3020177F7AFB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4B4CF12D-CA3D-43FB-931F-1C7FB87794D8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Élément pour chape sèche');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FA532D1A-69D7-4A8E-B9BB-108A03344457}', 'global', '255', 'material', '2024-11-14 14:23:10', 'enduit de fond');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2C061F80-4E19-4659-BDE2-CA0AE9E2B1A7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit de fond');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA904835-9828-4ACB-923C-1B77615ECF26}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit de résine synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{05DFCD64-1151-42E1-8F3E-376C6B1E88AC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'enduit de résine synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{379B5480-B36F-4AE3-92CE-FEC0D81260AD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement fluide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E2695100-8BD1-4665-8DB0-2640B79B59D8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Crépi hydrofug');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{058F0689-8EFD-45BD-8CB8-0FBCAAF25E3F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit hydrofuge');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{77069B61-B743-4226-B9E7-EDD2EB1E116A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A1F23CF5-F8EB-4296-B75A-55F8D262EF66}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Feuille d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{93F1B0F6-2A21-4DF0-ABB1-ACB97C98A386}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Système d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4F471332-CE48-4861-A4C1-48D502B8C8BD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'système d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faux plancher');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{64820016-06AE-429A-8855-FCB5AF682DA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'faux-plancher');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B3E8168A-B5C0-4D44-A83A-E7699B48D1E7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dalle de faux-plancher technique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{453A37FA-212B-4037-88A2-EB4B355AB1AB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Ardoise de fibres-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Eternit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3B7CB639-F696-47E4-AF44-53CEC2C18B59}', 'global', '255', 'material', '2024-11-14 14:23:10', 'fibres-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5A93015C-60AD-4226-B736-7896733254C3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de façade');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3965A62E-AA5C-41D9-A3A5-A7FB149B3B95}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque de fibres-ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8100ECE0-5892-4A50-BA51-F280645C686C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque ondulée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3B87E3A7-1A5E-4A2B-AA0C-2B306CC3DFEF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'fonte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F0675C86-6536-44A2-9A95-525B9A1A43AC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'engazonnement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{396627CF-585B-45FF-A95E-E60430313FE5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'gazon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{031D5C42-5779-4F51-9420-5E040C9A6486}', 'global', '255', 'material', '2024-11-14 14:23:10', 'graminée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA703329-716B-4CDB-A8A3-F1076E488861}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Blocage en pierres');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DE4B57F7-CF8C-49AF-96BF-FFAFD0DF67A5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Galet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0EC26EA7-5DD3-45B2-9EA3-A86BB1C5F129}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Ganulat recyclé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E0C30B7C-8CEE-463F-AC9B-7A27F0FFA199}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Grave tout-venant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DA282BE6-F7D1-462B-9600-74C68513AB13}', 'global', '255', 'material', '2024-11-14 14:23:10', 'gravier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{848D2DEF-DDF0-4A1F-AF77-6B7A1E03E231}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gravillon');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{90A90C81-BE96-42B2-A5C5-443B4394353D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gravillons roulées');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{023F0137-4B1C-4976-8BE2-27DC8225291F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Hérisson');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{665FC43A-510F-49B7-A148-E7440D252961}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lit de gravier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{345826EB-C148-423A-8F88-A97B9068B506}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sable');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{20394B8E-F36A-448E-8D22-29E35156C798}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation façade');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{95288D2D-85C8-4830-ACE1-57D6B3886E2B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chevron-iso');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B9DCB46D-01B7-4CAF-AEA7-62092B327B2B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chevron-isolant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9198583B-0F70-44A9-BB2C-0153CEC9E7A3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chevron-isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3A8485B5-8107-4D84-ADBC-68846F716798}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-poutre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B27CE8DC-8D1B-4A6B-B59B-BB80308383A5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-solive');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0E7B5219-EF3F-4A36-8B92-A14FD0E650E4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolant-solive');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation poutre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CB60CFEB-8603-44FB-A9FF-F517655030DA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Solive-isolant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ECC619D6-21E9-41DD-B54A-2BA5D62D6C80}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Solive-isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FBD41200-41BF-4DAA-8547-0B5EC5ACE67F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation bruit d.c.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{98A4AA64-3ABD-48EB-A143-EE06E34C9D12}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation en pente');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FD4D15F8-AB1B-4205-A537-860DC6369B1B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D8AF7510-FEF3-41A7-A860-FA0E04EDEFD7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'isolant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D8467653-3AED-44F1-84A1-D11A8AFF9E02}', 'global', '255', 'material', '2024-11-14 14:23:10', 'isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AC17DCA3-779B-4E78-A4AD-8700D5F2F0BD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau d\'isolation en Matieère synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{107B3BFE-3B72-49DC-9BA2-ECE74023DFB9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de laine de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6371FEFB-8D9F-4425-B38F-9C930AEFDB21}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de laine minérale');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5749427C-6FA0-4315-957B-7FB88808D903}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de verre cellulaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AD2D0064-5FD7-42A1-AE38-5346C9C2F13D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau isolant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{52672D77-4E78-46C0-9316-2CD7E079373F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux isolants');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D95E4D14-B8C2-42DF-BD50-60B0D070D648}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux-sandwichs');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D4EA8EA7-654D-4BB3-9605-229349F4A043}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Polystyrène expansé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{92A67EE4-2D86-4B91-A261-FAE231B79653}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Verre cellulaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C5849AE8-C526-40B5-BC51-B24FBCA467E0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{58919727-32AE-42CD-A13B-407F43743152}', 'global', '255', 'material', '2024-11-14 14:23:10', 'I.T.E');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation extérieure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{23EF0B0F-F040-40E9-9E90-3BCD590E0D0E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation themique extérieure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{51EEFE67-BE92-4669-996F-1C15E215700E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'ITE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{99F2ED0B-12A9-42CC-9974-8A524651FAA6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Coupole');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A0FBD942-1EAC-4A5F-8BFF-D0534EA2EAF7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lanterneau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ABFCFCA3-192F-4537-AB92-8594D5BECF7D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lanterneau-coupole');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3CB26AA2-98F8-49CA-8D0C-3D3DA3C0E928}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bitume élastomère');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{259047A9-D1AE-4215-9745-C82947BBBFED}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bitume-polymère');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2BC8CDAA-587B-4628-A132-E8E59AF407B3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carton bitumé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1FE32AE5-67CB-4D52-A98C-63F610106D1D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Étanchéité bitumeuse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3A0E810D-459D-4016-BDB0-526932CEEB76}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Feutre bitumé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{369701D6-4D30-45AE-A139-64DBF7D56681}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Film polyéthylène');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6FEF1539-BE05-4629-971F-62705859CFF7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lé d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lé d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9B1EEBDB-49DF-4D61-B1F9-931DE7831492}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lé d\'étanchéité en matière synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AAC7EECF-D680-44FF-9CD7-DE05EF84877D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Membrane d\'étanchéité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E53E1375-DFE3-4046-9392-A9FF7893BFD8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sarnafil');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8128B37C-4AFC-47C7-8828-FFDB7AF81585}', 'global', '255', 'material', '2024-11-14 14:23:10', 'liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4585E783-628C-4FD6-8565-F07FF7A9DA31}', 'global', '255', 'material', '2024-11-14 14:23:10', 'panneau de liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{50533D05-FD9E-4ACA-B598-9D07A5B0B777}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C1304ED6-020A-49BB-A915-2E8309DF0FF6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'parquet en liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{73237BE5-12B2-449C-9555-5ADAE0C1DC75}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet en liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{06CE08CA-FB5B-459F-B4A1-0C0E1B8BC56A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol en liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E92C87C5-D139-4625-9C8F-18D04DB6B0D6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'sol en liège');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5ABC1F63-716C-4A0D-A737-EF6E89B236A2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'béton maigre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EEC40DF0-E696-4BBE-A169-F9C5B6B586F9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Agglomérés MC,parem.exposé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{89685A64-57EA-4C05-9B68-550CC46D73CA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique de terre cuîte pour parement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A84E97BF-7EFE-4F69-BAE6-91659A5BA7DA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique s-c parement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{71015ADC-29B0-4C2B-BC38-FBD6730AFBB8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique t-c parement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{96FCCB87-1733-4CA2-9964-F59CFB1E0AA1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Briques MB,parem.exp.intemp.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{03C0FD9A-367A-42C0-A7A6-6E013B4DE4EB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Briques MK,exp.intemp.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{16EF5E6B-B353-44A4-B860-0BDA014CD82F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Maçonnerie de parement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2C1218D7-20F4-43B5-A62A-C43B0D5D3735}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Maçonnerie parem.MB,clinker');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2CD3E2C7-47D9-438C-BEA3-652D0674D51F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Maçonnerie parem.MC');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{618E8CB7-69DF-4C5D-81FA-BAE170EC943A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'matière synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C7047950-3E0C-402F-8DCC-DD70966894AF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'métal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E3165801-B0FC-4EB7-96CB-9F24A1175645}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Alu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D53973A2-8A16-4554-9A94-A4D961A477FF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{30FF6C10-2047-4F8E-B7E8-71BEEE581DBB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Métal léger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{68EBC788-7FCA-450D-BF1A-CCAB04027653}', 'global', '255', 'material', '2024-11-14 14:23:10', 'métal léger');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FD12ADF1-DF9B-424A-AB35-DA8CAEB8D3EE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'capteur solaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E0670956-BE3C-43CF-AFB1-79C7AB24F043}', 'global', '255', 'material', '2024-11-14 14:23:10', 'panneau solaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{48AFDA6E-57C3-439A-8513-C765BB71797D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isoroof');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{876B4E43-CE8F-4937-8BB4-0C129C052785}', 'global', '255', 'material', '2024-11-14 14:23:10', 'panneau de fibres de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C7FFF338-6CDA-43FD-B6DD-63FB7FD65B75}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de fibres de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{32F8BFD7-BC40-47C5-9543-0A946BCFA57A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau dur en fibres de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau fibres bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{21AE8AA4-F2FD-46FC-8D89-DD2E72F2783C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau tendre en fibres de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7F52FFAC-82AF-4B97-903A-1225C2CDB243}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pavatex');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{16A3B296-E60A-4B42-9887-8F49D920BEB4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pavatherm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6F8BC682-F8E3-42D3-B4AA-31B9378DB596}', 'global', '255', 'material', '2024-11-14 14:23:10', 'panneau insonorisant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0C5E10EA-8D7D-4419-B4A1-29ED37A5912D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau insonorisant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{99F2B469-455B-4D9A-A519-126D440E5026}', 'global', '255', 'material', '2024-11-14 14:23:10', 'pavage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{76971A77-5E5F-4BC8-AC49-887CFFC13ED2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dallage en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{14D15918-246D-4D3A-930A-F0F8F5044B31}', 'global', '255', 'material', '2024-11-14 14:23:10', 'dallage en béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B1752315-6F05-47A2-9D61-FE51A0A9F2A1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dallage en pierre artificielle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B0CD45F4-D1C6-4F65-AD10-E4BFD83075B7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre artificielle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3369592F-BAB7-4D01-B033-3EE9520BA7BC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque de pierre artificielle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9151535F-02AC-4DAD-AFC5-E40ABB61D48D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'ardoise');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{25CB502D-3E3E-47CE-B969-F2F6F549403C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Ardoise');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2FD5CA78-114A-4F9E-8FBD-1E2A81E38F6F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Calcaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7765E69E-EB2D-4ACD-819C-7CEB800CF950}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dalle de pierre naturelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{92DDC4B8-AA3D-491D-AEA0-CA6A1FDB8517}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Granit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EAC6EA8F-B372-443F-A503-5AF6F55E15A4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lauze en granit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B7A09602-A506-4CB0-B133-66C17C3E441F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Marbre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7BF3D21F-53F7-43E0-AA08-05D70C4163B1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre naturelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B51DBD64-5D41-4CD4-B096-67705D7FF096}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque de pierre naturelle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A5192EA7-AC0A-40B8-BDC4-69025E55133D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Quarzit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ECD1BAF6-4060-46E0-B788-DC26336982FE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Solnhofer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FECBEC41-A715-4538-BA9A-0C43B2F98BE4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre réfractaire');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{91D4F5A0-279C-4684-8EBB-75C32DA85915}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton coulé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4BD2709B-0FD2-4B85-8C9F-9ABF7DBB8C93}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Dalle à hourdis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9EF8502E-A5CD-48DE-8406-B4A6D1D63116}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Hourdis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{03B795EB-FE06-4675-B42A-14D9E148476B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plancher mixte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8EA57574-D023-4EFA-A887-EBB3DF8034CF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plancher mixte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6DBC00D2-3696-443B-A755-B959CF53F576}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Prédalle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Argile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D41A448B-2219-41C9-BFE0-A8B3B05081B3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plantation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9699A615-E3E3-48AB-8047-FE1E21504B8E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Nattes filtrante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9C426CC1-A720-4F28-836A-083A32D99055}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque filtrante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{99A3ADE9-B3F4-49FA-A04C-595CD8E0FC5E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plaque filtrante');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ED2E55FB-0C49-4A01-99B1-898B281B1638}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fermacell');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FD249322-C193-4C91-B552-5620F5888F40}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque de plâtre armé de fibres');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{70A5D4D3-9BBC-4E02-AA0B-D4A0161BE3BC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque plâtre fibres');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C048BD2C-7459-43F8-AE03-8AE60F47D071}', 'global', '255', 'material', '2024-11-14 14:23:10', 'PLÂTRE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1AAAF178-44B0-4B38-8F96-3DC7ED69A04A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{45B56DD7-E158-4B07-BF26-A1D02B339535}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Placoplâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plâtre cartoné');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6A920A49-23E1-491D-AF71-6C02F02E7967}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Rigips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2777702F-9926-4083-A3DF-46A14E9896B8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'air');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E8A3A523-4263-46B1-B64A-1B0DA5564CA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Air');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D761C071-1709-41C7-8FEB-446A94F60662}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cavet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8969BCE4-FE61-4EF0-8C97-D653EBB2D70F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cavité');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C0E58FEF-29C1-4FD0-92F2-89AEAE0850A3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'plenum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Vide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5680D2C7-B8E1-4A57-9EFB-1D1A19C69DA4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'vide');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6F88F0F9-A57B-498B-B794-0E828B5CEA54}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contreplaqué');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C440CE4A-605F-4469-8261-797FC6AABD1C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Laine de bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{53E77D18-4E97-4846-995F-D48199A240BD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'OSB');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9044C7E4-EFDF-4101-BF12-41E6BF9C3A4F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau de fibres du bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5D2C973D-8125-4E39-A1FB-548025262464}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux de fibres du bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{62605FE4-38D0-4EDB-ACD4-67F6F4475909}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneaux de particules');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C1B8AEE9-151C-48C2-878E-3F9AB23CF96A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Produit dérivé du bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A2D62CC2-09FC-430A-9380-CF69F8B32A88}', 'global', '255', 'material', '2024-11-14 14:23:10', 'CE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EDA28E96-AAB1-46B7-A77B-1FFEF860966B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cheminée d\'évacuation');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B3B857F3-25E7-45CA-A912-9D058CD1C0B1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cheminée évac');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B9BDA79E-7CA2-48ED-8051-CAC167E2E7C3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Installation épuration');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{827E6FEA-0237-42CB-9E75-D2F0D6415C06}', 'global', '255', 'material', '2024-11-14 14:23:10', 'PP');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{554AA962-50E8-418C-A1E8-39CD1756D31C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Puit perdus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A757D97F-9597-4E45-9C13-08840FB7DA1C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Regard de visite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EEBE077F-E15D-4D0B-A984-4BC83D99C003}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Regard de visite de canaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C53EA29D-9450-4EEF-A92F-DF2C2D0455F7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'RV');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2A5C988A-70F9-4DEB-9C81-CDAEC2303A48}', 'global', '255', 'material', '2024-11-14 14:23:10', 'RV de canaux');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{512F92E0-EBA6-4159-A231-E948DE3B7C54}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Barbotine');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{84EA04DF-B4D7-4FAD-A551-C2FD48956DA5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Égalisation au ciment');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{CB9D0A0E-242F-4EE4-858A-025A7921FFC7}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduisage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DFB7D180-79F3-4512-9A85-D9CB4F105FA0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lissage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2784E67B-7258-48B0-98C4-6FF00DFE7C3C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lissage au plâtre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{593C37E5-2FA7-4D6C-916D-CE0F0C9A8608}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lissage avec enduit synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{88A43A04-F782-4D23-BA7B-7E5031B002D6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Masticage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F67B3B22-903F-49D6-8983-976CAA1B7376}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Ragréage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{85641B10-465C-4478-8BC7-16C4E2879069}', 'global', '255', 'material', '2024-11-14 14:23:10', 'revêtement sans joints');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F68E9B87-702F-466B-A76F-D7FB61B2288B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement sans joints');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{4EF731D5-4A7A-4245-AF6E-D9A8E0060855}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Caoutchouc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{381584D4-A6CC-47B4-9B52-13CFEFF918B9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Linoléum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7ADD2B0B-BF77-4BDE-8B52-7AA508A44425}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plastique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0AD87B46-E68D-449C-BE15-11AD8FBCFC43}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement en caoutchouc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7410FF6F-CE02-4C14-8144-2E01DC1D5CE9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtements de sols en matière synthétique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{3AAC0000-FEA1-4009-A27A-0F17A31D9ACD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtements de sols en plastique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5B61F5E2-A0DD-4F7F-B1C5-192416C26D79}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9ABB46B5-F8DB-48EB-ABF1-98AD9AF7446D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet à bâtons rompus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9C9F9418-B54F-47D6-B914-494C2A64622F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet à coller');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7DD58DD6-6B51-4215-8B9B-5800CDA6016D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet à l\'anglaise');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{574AC0F9-3B7F-4CFD-9F64-0A69C8F73D7A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet en bois massif');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2FDA7CFA-4859-4059-9C35-904D4B975C6E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet en lames');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{063C6A0F-AD91-4C67-83FE-60736EAF63CE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet en point de Hongrie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{92BB3948-2EE7-4A85-92A2-8D676F52B765}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet en stratifié');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0688522D-2761-49CD-BC37-501C9CE1F2DC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet fini');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7951BB0A-9F48-4121-A3FA-BEA063A058F9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet flottant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F2843F1E-29B7-49F5-A024-76600F57428E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Parquet mosaïque');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C6457428-EC5F-4905-BC67-708EE7CE1B1E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plancher en lames');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1873AEE1-CAAC-49AD-A082-B6D2D62E0555}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6217FBFE-CF69-4403-9A93-0ABF18D5E349}', 'global', '255', 'material', '2024-11-14 14:23:10', 'sol en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1CDD0386-45E8-4CD2-A3E7-337DB8E8BDBD}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9D6B0966-4A40-43C9-A3D8-770766D7C5C5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol en stratifé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{84AFF4CF-3F3B-4C58-8C5D-FFAC813E06D4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Stratifié');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C09359AE-CFB1-48C1-9A6A-7EC55DFEDE47}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chevron');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{FC83166B-243E-4049-945D-61A48973F305}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contre lattage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5BD77517-0266-43B1-8B36-6C09C5E8C854}', 'global', '255', 'material', '2024-11-14 14:23:10', 'contre-lattage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{97C5C812-E717-4AB0-8CC5-0F9CD83EACE1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contre-lattage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6D35993B-C750-455C-9D19-78F8FECC255C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contre-liteau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6192EF9B-04F5-450E-98D1-D2DE4BE42E36}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lambourde');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{386A07A8-529C-4A52-A79F-ACBF41EE9511}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lattage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0AA7A0A5-F5B5-4268-8E50-2EF292840CA2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lattage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lattage à tuile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0453B249-D9FF-4C5E-9E1C-7C0E818A0C50}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lattage à tuile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D5C3D348-FA28-4856-8819-5B095B1B3AF3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Latte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F497258D-C01C-49C9-B90C-7B56F081A1D5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lattis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{76E692DC-A046-440E-9658-E038B2D0BF6D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'lattis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E3E90D85-A006-4D60-9C68-F330A04A1D0B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Liteau');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Support bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{0971C7B9-2618-4F14-9B8B-7B28DA0EA5CF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'support en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2290DE9F-9C0E-489F-A530-BF5435A14EFB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Support en bois');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F6A3374F-B710-4315-8377-BE53B6745B55}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Volige');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2344E331-515C-4F13-AF07-AD93A175A6C6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Moquette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DDA5BCCF-EDB2-4474-BD5F-EFA9DE54B87F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'moquette');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{06FA404F-F696-42D0-BE27-E98F17F004A6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Moquette à velours bouclé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A25A7494-0451-4726-895B-7ED7F97D201E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Moquette à velours coupé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A60C3856-FCE4-462F-90FD-1289607D3CBB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Moquette aiguilletée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{EDBC8F51-0164-4291-B821-16EE2A26C834}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Moquette tuftée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7C182F70-28D4-47BE-8F85-25EDD115D9FF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtements de sols textiles');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{79820EA5-049D-4FF2-8305-0CC19DE96D10}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tapis');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A622D361-D637-4CF1-A969-A2F8D2BC00E9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapis aiguilleté');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2704793B-9C4A-444B-955E-16D6C5243578}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapis antisalissure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{25378106-9905-4407-9954-7B2E21A37B18}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tapis antisalissure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BC2C7D6D-4C62-4EBD-B5DB-3B0945EB6258}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapis-brosse');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{034F2D8C-CB94-433F-88C7-091EEF6CC96E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Calicot');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{BE6935B3-945B-4E5C-B298-B3BBCA2F559C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Jute');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{157340F5-2BC2-4EDB-9D2F-D40E4516DD27}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{132B8143-3261-4E6A-A232-A2E0257C968A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Non-tissé');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7442A778-81C9-46EE-8BC6-72E129000601}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Non-tissé de cellulose');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2796CCB4-EB20-419C-AFB7-A14658D080AA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Papier ingrain');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{10140701-2314-433F-8EB0-094F7647821F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tapisserie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D232FF65-C798-43FE-956B-58F2B1DD0A2D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tissu de fibres de verre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1C7E162A-45F3-4069-BC12-4EF8646A8045}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Voile de fibres de verre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{652ACB35-6DE2-477B-A5FE-55A007B42A21}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tissu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{7607871E-6D9B-49E8-9E85-2043093F232E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'cuivre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C85EF661-D847-4F6D-AE9B-598B522F5ACB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cuivre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{ED1DCA5A-3541-4FD2-A91B-C9AC2A33EF31}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle d\'acier');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D0766575-F2E9-44A4-8A18-2AB18C093B6F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle d\'acier au chrom-nickel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8DAB21C8-D35E-4CB2-B19F-6A91939C43ED}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle d\'acier au chrome');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{DAEDECD3-765D-4C9B-B790-F30B2A96978E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle d\'aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{AAFD8BC4-B2BD-4354-9D61-4A341FECE947}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle de cuivre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2849378B-3585-4541-995E-8974967B7FBB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle profilée');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8372D589-D2A5-444C-A3F6-1FE0B0C2DD82}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Zinc');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{A8F0D4A8-38AC-407E-A8D7-CC0AA1A82C7A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Zinc-titane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D765132D-E29A-4701-94F1-0FBC9C3614C5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'tuile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{8EE0EE6A-1B34-462E-9D9B-4081E0BD27EE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile à emboîtement');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{6E8246A9-359F-4DE8-997A-F921BB5E9F86}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile canal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{612C9C33-BE02-4FB6-957E-123D831FF7D9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile de béton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2F3EC7FE-1A9F-4207-887F-4B00E6A3940E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile flamande');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F59DD05C-4397-430C-8147-3D77556FB3FA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile plate');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{E1BECE8F-AE8C-47C3-80F4-B84ED408EB16}', 'global', '255', 'material', '2024-11-14 14:23:10', 'végétalisation de toiture');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D9F3D36C-52BF-4674-9BAA-F6E3D7E5EA4A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'fenêtre de toit en pente');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{2D35B4B6-D647-4E37-B6B1-BE3BDAAC2D19}', 'global', '255', 'material', '2024-11-14 14:23:10', 'verre');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{C3A129EC-ADE2-4E58-8D0D-07316751D2A1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revêtement xylolithe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{1ABEDEF5-532C-4D8D-912F-022C6E427C7D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'xylolithe');
-- values
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9BC7A6E3-4060-4674-8E3A-B41BB6B12B44}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Rebuilt');
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6FB82898-0BCE-4840-A93C-1DC95AC9B64B}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Demolition');
-- INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{BE34130A-80B3-4772-9626-57BB7A648F50}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Existing');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{676F629B-1B6F-4BF9-8830-4028861194EE}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Floor covering');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F7F5817E-A469-413A-A25D-6A1ABDB52515}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Subfloor construction');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{53374301-6498-4077-8812-D9D26484C748}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Plastic-Aluminium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CBCC9D35-E35C-4ADE-B7B7-125309C4C9AA}', 'global', '255', 'material', '2024-11-20 11:33:21', 'Wood-Metal');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{47AD893A-5A07-4CD7-86E7-76F04E577B37}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Isolation toit plat');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{723A7C9F-6A7C-490E-B91C-2EC48ABE6723}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Sans hachure');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{D2489132-BA93-4815-A19C-78ABC9417A6F}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Existant');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{9B3D2F20-3855-43D6-97C7-15EFDD36A9B3}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Sans hachure 2');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{795521D3-A7FA-48DA-9406-E601E803EDAD}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Isolation périmétrique');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{5B8E715C-FCBA-4523-9E90-84A73D0057E7}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Struc. revt. sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Revêt. de sol');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, fr) VALUES ('DM-{F51CA4BF-6614-4714-853E-66909E6E5D53}', 'global', '255', 'material', '2024-11-20 15:37:46', 'Isolation pl.d.plâtre');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A79A9EB9-0F61-42AA-9072-94300C8E8D31}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Bentonitmatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EB2D5562-6638-4046-8E0A-1F68A720D52F}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Ethylen-Propylen-Dien-Kautschuk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{768F7C16-B435-4DDB-AAD4-4686510A7DC3}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lehmbasierte Abdichtung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{678C169D-B56C-477B-8B62-DBB072B5487E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Mineralischer Dichtungsschlamm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F41B45CC-D814-4539-81A9-19AD613A9A4D}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Thermoplastisches Polyolefin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{609AC8F6-FCFE-4F38-846B-56AEEE6845E0}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Abtrennsystem Holz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF0A19FA-4586-4899-BAE5-4742E3334BE4}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Abtrennsystem Metall');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8E501A4C-6271-46F2-8D15-E63DB914C168}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Schalldämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E89B7972-0316-457A-87AE-A590FB07EFBC}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lehmfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F5A6BF1-DCB1-46EC-AB92-3FDA2BFAB052}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Ölfarbe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{367DBA57-91E5-40AA-8EF0-B34EA76A9D81}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Öllasur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4BBFA414-77A7-4D50-A32C-38807BE08CC9}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Binderschicht');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1204D132-F428-4C43-81F4-F7468B886977}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Biomodifizierter Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CD4785A-12C4-4D56-BA0E-4E9541897A13}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Recycelter Asphalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3483AEBF-B1F8-422A-8E88-5DADAC925789}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Expandierte Korkdämmplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6C39864D-2892-4A9E-BE3E-95398FD26156}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Polyisocyanurat-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D61A0399-9BAE-4A90-B70A-FC3EB8AFDD3C}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Polyurethan-Dämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4B7DAA06-5201-4EC8-B9EE-5EDE0C6D0375}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Aussenputz hinterlüftet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D6282B63-6ADB-4783-98A3-9FE17E531106}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Außenbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AF166FAA-7BD9-441D-9CBC-890E7B7C7FA5}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Innenbekleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lehmbauplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9A5B4D6B-B8EF-4E5F-B743-AA9F4E0289D3}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Außenbeplankung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9E835B1C-0054-4A06-8B42-D99C3667C791}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Innenbeplankung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C369DA26-6ED4-4C90-A3C6-7B0ADF9DB351}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Fertigteilbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9C6AA5CD-7CD3-46EF-ADEC-D85A1D86A884}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Ortbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA85F24D-5CC1-48A7-BF69-B3AB0F30971E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Betonmantelstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FA218E55-967B-4915-9DC0-8179A355AA70}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Betonschalstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B504045-621B-45AB-8C31-F7577A1CEC1B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Leichtbetonhohlblockstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6BE7175C-2FD3-4C64-A3F0-9902666338FA}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Aluminiumblech');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D4AD0C31-E704-4975-8765-E32739EF4A9D}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Titanzink');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{201FE7BC-320F-4B82-AC00-F7D8B315C7B6}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Dachuntersicht Außen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B46160CC-651B-4F36-9B9E-654617B9707B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Hanf');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2555C259-BA6B-41DA-9183-603C9CF8ACFC}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lehm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5E336947-1AE4-42FF-92D7-07F56B85EF66}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Mineralfaserdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AF220C79-A9F3-4EC7-805A-3D4A0315D388}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Mineralschaumplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{68D1F59E-18A0-458A-BA82-9191BAF8B647}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Mineralwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52028111-6F23-4555-98C4-79E565009A02}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Schafwolle');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{241DE528-D03E-4E6A-A965-BB34F9169CFD}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Stroh');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0B2BA224-4CB1-4195-83F1-064148F2025E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Zellulose');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D6D7E268-7471-4374-A453-CCB79AA34998}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Balkendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5FD5C0F-7FFD-49D2-BBBF-214E5B63531A}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Sparrenunterdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{78E8AC1D-FF9B-43F2-8467-3B62FA429688}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Zwischensparrendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{345D1773-77CA-4B04-B017-D3B49652B92E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Deckendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FF19B1D3-9EC2-4122-A700-4DA0EB09C72B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Gefälledämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D5194B1D-A3D4-4F1E-B46A-57E9DAB804FE}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzständerdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BFC72B9B-6286-481E-B617-A60DCB72FDD6}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Pfostendämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3916CB90-E296-4A5A-AC8F-F0B60CD6FBD8}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzwolledämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0925B528-8522-49A0-9B53-EEA71CB30C69}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Dämmung Lattung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C7E512AD-4D86-4B24-8C01-B24B108208DA}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Perimeterdämmung EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{02894DC8-F7D6-4AE5-8F82-CB474A20A0F0}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Perimeterdämmung Schaumglas');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{533C1ABC-33A4-40ED-A226-5EB05A405DD8}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Perimeterdämmung XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{585CD8D4-0C33-4645-9724-CEA76CEE7EB6}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Edelputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9ED27B13-66B6-4F88-AE4A-8A7A4857E9B2}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Hanfputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B5FE1E24-7BFA-4B59-9BB6-D1A782E3FB38}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Innenputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{45B9820E-17AB-4FAE-B9FD-74DBFE884CAB}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lehmputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3E18CCC5-9902-4516-BB66-DFD21CA94C87}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Silikatputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A4EC2644-B0C5-4540-926C-EA6ED42B5983}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Tonputz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{021E1190-DA04-48A5-B656-1322B6705196}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Unterdeckbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5AFA4179-D904-4798-B0FC-C5784CAF1DA8}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Unterspannbahn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{61A15942-5FFF-41F0-9A9A-52D6AA6FB5FD}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Flachdachbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7CCC4D83-82ED-4086-842B-99DFD8A3A10B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Calciumsulfatfliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1D7C370-704C-4F44-9ADD-AD087F3EFAE4}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Kunstharzfliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{52C695FB-0503-40F9-A861-D2288979C701}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Zementkunstharzfliessestrich');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA5D5E31-E64B-4FFF-9A26-C66401C46C5E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Spachtelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{31709897-80B0-4110-A56E-77CFD4B0840B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Kunstharzhartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E1008D2B-6D08-4FCE-8105-07EFAA59DF48}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Kunstharzhartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6DEFE768-215F-4837-AFF9-451315801959}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C54E958E-3205-4A9A-8CC6-F59A7FD48D0C}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzunterkonstruktion');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8C813C80-92FB-4A59-A4D3-491631E7C58B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Lattung hinterlüftet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2B701457-3A9C-4D28-90C1-2821D1BE29DA}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzunterkonstruktion Innen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{520F1261-05D6-4C15-AD0B-83C0596B8798}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzrahmen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3EA0ECA-ACFE-42F8-BEF2-D370EC0030F9}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holztragwerk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{053BF56B-E3F1-4CFB-BA3F-1C2FE8CA14F2}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzblocktafelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{472446CB-2673-44EC-8F63-7DEC34BD731D}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzpflaster');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{446162F5-FB3F-4486-AFC6-ED898FC079E7}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzschichtplatte');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{64406BD1-95FC-4E99-884E-D8351C47AF99}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzständerhohlraum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{93220622-69DF-43FD-B822-E492256687A8}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzpaneel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{48ECAB8D-4C00-42E1-8964-A0EBF4A03857}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Holzverschalung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{3E108672-7248-42CD-A0B8-0970E3B08809}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Täfelung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DC731B0B-C467-4367-9785-AC5579C11A62}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Innenholzverkleidung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{40B11739-37B2-41AA-A4C3-2C0E131BACE7}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Klinkerplatten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB311F3C-4272-4A79-AFA6-61ACC4F6186D}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Schüttung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A6E39608-E248-4F82-9794-C248C61DF97A}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Verschiedene Konstruktionen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{49F61648-85AA-4944-8ABA-D87343943988}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Methylmethacrylatbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5906B1E0-FFB2-400F-809E-065EFC4F81D5}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Zementkunstharzbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7ABD6DD9-13E8-40E8-82FD-6AE5391E4F69}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Alupaneel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9CCE2AA3-5132-4229-BFB6-7433FAB7FEF3}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Metallpaneel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AD4017BB-BE59-44B5-B3FB-6555A4BB7C78}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Paneel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D66518C-E043-421E-9A29-25F87E1E959B}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Porenbetonverbundstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E118B37C-EC1D-4186-864C-4006CC66E5D2}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Porenleichtbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE330FC6-694E-44DA-B1BC-B6846D3301DD}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Porenleichtbetonstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9215EB28-7A78-434D-B4BE-928963FB8044}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Chrom');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E4EF9232-04EC-42F3-8F11-F48EE7B864E6}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Leichtbauscheibenwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F98501D0-38F6-4341-99DE-AF798F2CF1D9}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Leichtbauständerwand');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{201F732E-02CF-44FC-987F-3B90661531EA}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Textilbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{03C7D990-53E7-4A2D-9A38-DFECB7838B01}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Dekorhartbeton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{68B1034C-2F06-426A-BBA5-34EB1CC11E5A}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Dekorhartbetonbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FC3A9A8D-4AB8-4542-9BDB-E49C90199BBA}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Terrazzobelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25B72455-5E95-43CD-8636-05B56548C96E}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Terrazzoverbund');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{64CEED94-8536-490C-8BBC-9011736A34F7}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Terrazzoverbundbelag');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{154DC50D-7255-484F-916A-4D7C596145E9}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Verschiedene Aussenkonstruktionen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C90A63AA-7180-40A9-B83D-BCD72B07C2E6}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Verschiedene Innenkonstruktionen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CECCB58C-85EF-4738-957C-CFD9406189B1}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Deckenbackstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2A5DFAE4-AD42-4357-8487-9114B26B13E4}', 'global', '255', 'material', '2024-11-22 14:19:30', 'Deckenziegelstein');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{419795D5-265A-4EE6-B04B-7F95D4F3D9D6}', 'global', '255', 'material', '2024-12-18 07:01:16', 'PE-Folie');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8A97C0E0-2BE5-47A2-8B93-96F43830FFEE}', 'global', '255', 'material', '2024-12-18 08:27:49', 'Mineral wool');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3629CB40-A703-4023-846B-DF25D2AE2E25}', 'global', '255', 'material', '2024-12-18 08:28:09', 'Insulation EPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{965DEA2A-14E0-475A-817F-47DF28BABC24}', 'global', '255', 'material', '2024-12-18 08:28:31', 'Insulation XPS');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0D972377-A913-484A-A515-4C35FAA33089}', 'global', '255', 'material', '2024-12-18 08:29:45', 'Timber cladding');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B6E61991-F36A-44CE-9E81-C42974347120}', 'global', '255', 'material', '2024-12-18 08:30:37', 'Fill');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{90806837-C190-4012-A3CB-1B2FA2FFE6E2}', 'global', '255', 'material', '2024-12-18 08:30:46', 'Drainage');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2F6D6A7F-FAA7-4AA1-9436-B6149B4A026E}', 'global', '255', 'material', '2024-12-18 08:31:20', 'Suspension');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{40DEE984-8C43-40FD-9F72-46103E556C83}', 'global', '255', 'material', '2024-12-18 08:32:08', 'Granular subbase');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AE7E2AE7-AA6D-4473-B353-C3CD1B7ABF5A}', 'global', '255', 'material', '2024-12-18 08:32:29', 'Paving');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8CFCB0E9-B6BE-4907-8875-272DFC3E5E1A}', 'global', '255', 'material', '2024-12-18 08:32:53', 'Battens');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8105275E-CD7F-4AC8-BD76-C5DBF62D84C5}', 'global', '255', 'material', '2025-01-10 10:25:31', 'Holzfaserdämmung');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{088E30FD-2830-49FA-A757-DB189F7105A5}', 'global', '255', 'material', '2025-01-10 12:05:09', 'Coating');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7D7D7E9C-860A-4159-8A3F-FAC53A218211}', 'global', '255', 'material', '2025-01-10 12:05:09', 'Roof Tile');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{455D793D-8BE7-405E-B2CF-DC470AA01DDE}', 'global', '255', 'material', '2025-01-10 12:05:09', 'Timber surfacing');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E0972291-E859-463D-9EFF-06BEB40BC2EF}', 'global', '255', 'material', '2025-03-10 14:27:04', 'Arkusz blachy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5B903E2E-ABF0-41B2-A146-C46F5018944E}', 'global', '255', 'material', '2025-03-10 14:29:05', 'Arkusz uszczelniający');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{CC4ABFCB-B25F-4D1C-8B3C-DD5A5F4A69B1}', 'global', '255', 'material', '2025-03-10 14:29:12', 'Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5F1BB300-2A49-4770-B7F9-3A6FD4FF7E16}', 'global', '255', 'material', '2025-03-10 14:29:17', 'Beton podkładowo-wyrównawczy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{46F6357F-3E59-47EE-B927-6A2F800C700B}', 'global', '255', 'material', '2025-03-10 14:29:24', 'Blok betonu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{10530458-13C5-454C-982E-FC04C97EDF61}', 'global', '255', 'material', '2025-03-10 14:29:31', 'Cegła');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2AF9D4C2-0719-4878-99D0-E969ADB2FCF3}', 'global', '255', 'material', '2025-03-10 14:29:36', 'Cegła silikatowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{FE267BE2-8F81-45E3-A753-5CB8E025C05D}', 'global', '255', 'material', '2025-03-10 14:29:42', 'Deski');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{BD2065D1-4B74-4F1E-8DD3-7B752CA435F4}', 'global', '255', 'material', '2025-03-10 14:29:50', 'Drewno');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AE20B4D7-7B17-460E-88C5-41CEFC17CC7B}', 'global', '255', 'material', '2025-03-10 14:29:57', 'Drewno laminowane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{72858D3D-1E45-4CB3-A9CF-E991B9600E31}', 'global', '255', 'material', '2025-03-10 14:30:03', 'Eternit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{66CE7C22-2789-476E-B6DC-347674B594A4}', 'global', '255', 'material', '2025-03-10 14:30:09', 'Fundament');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{62675907-565A-4285-B542-5394D9C406A4}', 'global', '255', 'material', '2025-03-10 14:30:23', 'Gips');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{08FDF5EA-2E99-452A-88E0-D3397A79C02F}', 'global', '255', 'material', '2025-03-10 14:30:29', 'Gleba');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{876BB116-C8B7-434B-A2A2-1FC2982CE7F4}', 'global', '255', 'material', '2025-03-10 14:30:35', 'Izolacja');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F67370B0-0F4F-45C4-9F32-92361A21F3EB}', 'global', '255', 'material', '2025-03-10 14:30:42', 'Izolacja belki');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{62F27761-5E90-4171-A66B-F340DD88AD7A}', 'global', '255', 'material', '2025-03-10 14:30:49', 'Izolacja płaskiego dachu');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{3F81FF86-236F-4E31-856D-2D6595042CEF}', 'global', '255', 'material', '2025-03-10 14:30:56', 'Izolacja płyty gipsowo-kart.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{10EEAAD0-859E-4095-8E8C-CB125DE43174}', 'global', '255', 'material', '2025-03-10 14:31:02', 'Izolacja słupa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2041B98F-7D51-4D98-877F-D54E990FC80C}', 'global', '255', 'material', '2025-03-10 14:31:07', 'Izolacja zewnętrzna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{82C8D85D-6733-4037-9B7A-1FA8F751A85E}', 'global', '255', 'material', '2025-03-10 14:31:13', 'Jastrych');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5CBB45DC-9141-4C0B-91A2-24B7FB9E7EEC}', 'global', '255', 'material', '2025-03-10 14:31:20', 'Kamień naturalny');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AB1BF0D7-7049-455C-9368-B010D4646AF2}', 'global', '255', 'material', '2025-03-10 14:31:26', 'Kamień sztuczny');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{97E1FB6F-DF0A-46A0-BB92-EF9BE1C06823}', 'global', '255', 'material', '2025-03-10 14:31:32', 'Listwy przeciwległe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{943B8FCE-15A2-4862-AC33-AB003A8D1A68}', 'global', '255', 'material', '2025-03-10 14:31:38', 'Listwy płytek');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{860FD203-59C8-4075-8C7E-F561488AA29C}', 'global', '255', 'material', '2025-03-10 14:31:44', 'Okładzina drewniana');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5123055A-2ADB-4FBF-A6F6-D68AEAE99EF6}', 'global', '255', 'material', '2025-03-10 14:31:50', 'Okładzina elewacji');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E3F9EFD5-C592-4B9E-8CE9-3642055303DB}', 'global', '255', 'material', '2025-03-10 14:31:55', 'Okładzina izolująca');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{25E7C47E-9A04-498A-A300-34C59B5A4629}', 'global', '255', 'material', '2025-03-10 14:32:01', 'Piasek');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{C3BCA9F8-95C5-4863-9151-0BDCAF0F2BF0}', 'global', '255', 'material', '2025-03-10 14:32:06', 'Podłoga drewniana');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{BD51CC31-CB17-4839-8105-26BB842C6485}', 'global', '255', 'material', '2025-03-10 14:32:12', 'Podłoże budowlane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{DDFFCF01-2038-4F54-80CF-AEC2D6640ADD}', 'global', '255', 'material', '2025-03-10 14:32:21', 'Podłoże drewniane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2A52DF66-C0B1-476E-944E-FE5216AB507B}', 'global', '255', 'material', '2025-03-10 14:32:26', 'Pusty');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{FCFD165B-EEAA-4E4A-90A4-492C52A7564C}', 'global', '255', 'material', '2025-03-10 14:32:32', 'Płyta gipsowo-kartonowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{7C0EB0B5-BF8C-4D03-9224-08A78CD58F42}', 'global', '255', 'material', '2025-03-10 14:32:39', 'Płyta pilśniowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E38AB04E-1C1D-46B3-AFAF-804E50E8FCE7}', 'global', '255', 'material', '2025-03-10 14:32:44', 'Płyta wiórowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{9F328AE4-CDE2-4479-A040-100256590D32}', 'global', '255', 'material', '2025-03-10 14:32:50', 'Płytka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{B9BFCB20-E049-4031-83DD-9FECDC9F8A97}', 'global', '255', 'material', '2025-03-10 14:32:56', 'Szkło');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F5BF9532-7516-4DC3-A874-C2CE7CEDA9A5}', 'global', '255', 'material', '2025-03-10 14:33:02', 'Tynk');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{740D9549-4F98-4C37-B046-9FA06EC75EA5}', 'global', '255', 'material', '2025-03-10 14:33:08', 'Tynk włóknisty');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{7018309C-DEEF-4EC7-98A0-87164211CC60}', 'global', '255', 'material', '2025-03-10 14:33:13', 'Warstwa żwiru');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{46F7FC78-9DDA-47F6-849F-FA62D86FCD0D}', 'global', '255', 'material', '2025-03-10 14:33:19', 'Wykładzina podłogowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AC027437-9275-4F5C-87D8-F7FA3A778CCF}', 'global', '255', 'material', '2025-03-10 14:33:26', 'Wytłumienie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{4EFD0DED-9C68-41CC-8888-49526991AA1F}', 'global', '255', 'material', '2025-03-10 14:33:32', 'Żelazo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{3EA3F88B-9F87-48AC-BA85-03CA8D06D120}', 'global', '255', 'material', '2025-03-10 14:33:37', 'Żwir');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{16FD5A51-5341-4C83-8580-BD6A66D4A8BD}', 'global', '255', 'material', '2025-03-10 14:33:44', 'Aluminum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F1A44DEE-AA93-4EFC-8C91-D0E0361D5F6B}', 'global', '255', 'material', '2025-03-10 14:33:51', 'Metal');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{77895E4C-FFB0-47A1-9D8F-33F25932B0D2}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Arkusz metalowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{A35190A1-7523-4C47-8824-7BA15E7CE21F}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Asfalt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F2CBC62D-36B4-40F3-8F6B-B58462673F13}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Asfalt na zimno');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{0599EA7A-9A2E-4B87-B63A-764C5CF979D0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton komórkowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{C65ECE18-EAD9-4E9F-B5C6-BE6BF1ECE686}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton próżniowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E917B2D3-77AD-4AB5-94B0-C552A87FEEE0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton wodnoszczelny');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{7010329C-85AC-45DC-A5F8-5FB0AEEB4A2B}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Bezspoinowe pokrycie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{43B30DFE-CEE2-4D78-9D37-8B47FBB61F90}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Blok betonowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F7D92108-F8C4-440F-AF77-B1BB40958E45}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Cegły');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{C94A973F-C5A5-4F8C-994F-779326AC62BC}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Chodnik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{73D35D63-2DD8-47EA-95DC-6A7EC7D4DC5E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewniana okładzina');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AF095A95-4880-4809-8C42-6182F22124E2}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewniany podkład');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{CDD6C404-4F37-47E0-A287-8E63CBB1430C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewno klejone');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{DF004DFC-BB25-49B2-B8C1-55C238746624}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewno-metal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{026D1EE3-9912-4AE5-88AC-3E2833470EC1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Dywan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{CAE3A0B7-66D4-481F-B5F0-125D7C9820B0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Farby');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5CCE4EFB-F43A-4B77-9E51-AE0171D1376D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Filtry');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E81DEFB6-F3B2-42B8-A66C-2F5604AE1F07}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Granit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AE1B7AEE-7A19-4830-8835-503DA9005A7C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - belka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{878F81A0-6394-4DA0-BC7D-0A40F5DD6839}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - dach płaski');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{8D3775BF-616D-424C-A2C5-49B9BA63CAB5}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - okładzina');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{D622038E-D61A-4BC8-A602-AAE7255DDD99}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - słup');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{D0B16434-D288-4061-BF34-E6A757390EAF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - sucha zabudowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{0B620929-A375-4291-8270-9349D9D6D089}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja podstawy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2ECF82C6-8288-4323-AFC2-7E3035D047CE}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Jastrychowa wylewka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{D0626AAC-817C-4ED8-A461-BDD424AE4BE3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Kamień');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2ABF1109-0F8D-4F32-B12E-0B0CECF87B2D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Komin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{4FCAE0D8-9F3F-4312-AA80-3705EB43FC50}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Konstrukcja drewniana');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{F27B67EB-D87D-4F21-BA70-411C1A48719F}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Konstrukcje drewniane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{7F425FFE-7936-4CFA-B8E9-D4A3BD778FE4}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Korek');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{3A825C97-A0F4-414E-B891-483CCD92A082}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Laminowane drewno');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{711A5246-AF96-42D7-8558-236FBACBBE51}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Lekkie metale');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{8B1DEE5E-88F1-43A7-8D1D-FE73B302E71A}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Lukarna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{28ED6CBA-7B90-4ECC-AA55-52A17F10464E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Naturalny kamień');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{D2295ED9-F1EC-41B8-9310-481024D417C3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Odsłonięty mur');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{CDE0C1B8-A777-4835-8FB7-14999185F1B3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina betonowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{93AFC8BD-2939-4F76-AFCA-BB86F8AC20D6}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina elewacyjna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AC0B4CB2-38B6-4800-B50E-A1C58AD406DE}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okłądzina plastikowa podłogi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{BD29D038-CCBD-4EC8-BDF9-6A8BA6DF9C32}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina podłogowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{83B58971-8B89-4677-BCB4-93E0A0238DB0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okno dachowe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5393C0D1-E63C-4B02-8920-182F05F0F967}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Panel metalowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2CE4D7E7-214A-4D57-B4C0-15AAB3966AAF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Paroizolacja');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{03EE0533-BF34-4ACB-B0D7-78112C354065}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Pilśniowa płyta');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5CCEB502-1EEA-418C-BBE8-7B0E8D1419AA}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Piwnica - podział');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{14242F90-9E86-49DC-8D4B-68277F9ADDAD}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Plastik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{42BA6BFB-AC33-4BF7-A8DE-9A40F80B1DF6}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyta akustyczna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{88DFCAB8-BB8F-4711-9FE3-93EADF4592A7}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyta kompozytowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{7AC4F406-A414-4E79-BF3C-00494D57E5CE}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płytki');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{27FC9B90-26AF-4281-8F7E-F1D760767232}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płytki ceramiczne');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{9B847553-7730-420B-B86D-94AB9BA45F19}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyty');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{1196390A-810A-445F-813F-7671D7357E3C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Pochodny produkt drzewny');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{71FF638A-21A7-4ED5-BF7A-4E309D4BCBA0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podkonstrukcja');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{903180FB-02FF-405B-A184-AACC77F8F7E1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłogi drewniane');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AD58670D-026F-4D89-8DBE-A246384DB5AA}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłogi żywiczne');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5E43F0AD-E564-4061-B624-BD03AEDF8772}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłoże');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{C1801052-0714-4575-BE81-1229F8F1C592}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podwójny spód');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{344D0B07-66AA-465F-8F58-EFE75B37B45D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Powłoka wodoodporna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{3B4EAC5C-719F-44CF-848A-519429FD54FA}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Prefabrykaty');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2214AC02-5F8B-4031-AA1B-751F1132150D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Prześwit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{6B4962DF-A05E-499A-8411-3490784B8384}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Renderowanie');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{4522A0E2-02FD-4F81-8BCC-C8A14554A6E1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Ściana działowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{475029A7-014F-4758-98EE-0272E509FA86}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Ściana panelowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{8C15D845-781B-49C8-A021-2D4A6CE9F4E5}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Stal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{9F86BADF-11B2-4004-B16B-419EAD955CFE}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Stan surowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{33049E71-00E4-4968-848B-B381FB4DE6FC}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Sucha zabudowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{2F7A66F5-9C9D-40E3-9638-15F70C308646}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Sztuczny kamień');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AA5EAFE2-971F-4C40-9981-CADE250C0B42}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tapety');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{6B7EB3A6-9E18-4DBC-A38D-7BE8C4B89B0C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tkanina');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{4C209C69-E748-4EF1-9CE4-63B7B8F5F518}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Trawnik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{928E61E7-75AE-4500-9360-9D687A7AAF4C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tynk podkładowy');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{5DFF3CE1-52B8-4694-8A8F-6768F69BC660}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tynk z włóknem');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{85FA0139-F1D0-4476-A678-C19505FB9E94}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Właz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{9868732F-0F32-4424-A57D-55C007ACA1C0}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Włókno cementowe');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{D3D4EB87-4DF2-4E1A-A6DA-C09C0162694E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Wylewka jastrychowa');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{279C1086-3E7A-43C1-81FB-93290919F308}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Zew. izolacja');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{04EE0401-B08B-499F-A0DC-342E3E050DE7}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Zielony dach');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{51D2AC1D-CC41-4C70-BF6E-5F634E6B87EF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Istniejący');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{646CCD46-3E86-4D1C-BA71-3B9F0CD50B3D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Przebudowany');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{E337DC77-226B-44DB-92D2-4CEE3052E2AF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Rozbiórka');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{D8CC9BC3-93D3-4656-AF8C-F415F61E9368}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Φυσική πέτρα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{F6BE2421-6488-4F9C-8A2E-47E4B42BAAD7}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Αερας');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{16A6E301-C546-487B-99F1-FBDC2D5466FD}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Ασβεστόλιθος');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{C34A19C3-7EB8-443F-B5A4-6335EB4A9988}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Γυψοσανίδα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{8BA118EC-D72F-4989-985D-D5E1831358A7}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Κενό');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{BBECC938-8646-4AD8-89A4-D5EB1BEFC52B}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Κεραμιδι');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{0681B6BE-51FD-4CFB-B263-933BB5D8970A}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Κονιαμα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{BAD7835D-3D68-48B3-826D-8B7A70E24096}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Ξύλο');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{E84EB013-B980-499E-A8C4-84889A2E685D}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Χώμα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{A4FC1653-A9D2-497E-9498-599D91E687F0}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Μέταλλο');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{7B021FBF-BE75-441F-9CFC-6EBE8DB5D241}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Μόνωση');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{D9559D84-7CB1-4F94-B4D5-FEEDC9912E1F}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Μεταλλικη επενδυση τουβλο');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{0206045F-1E1B-4927-B4B8-65EB9E8D2E2F}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Πλακιδιο');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{0C2959A6-C7D8-48F3-81D3-E83BCF776E2D}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Πλαστικό');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{6426E56C-01F8-4929-A5E7-9AC44AC06C08}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Σκυρόδεμα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{AD505A3A-3983-4429-A0A1-262226B1BB9D}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Τεχνητή πέτρα');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{C75C20C0-780B-43BC-9DA0-42476CA5F236}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Τούβλο');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{4911B942-75E2-4958-A78A-E0D54E98704E}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Φυλλο στεγανοποιησης');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{28632D83-4102-402B-9BA0-C331AF9F76FA}', 'global', '255', 'material', '2025-03-11 13:26:33', 'Χαλικι');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D84BE864-DCF7-4AAF-9324-5F4B5A04DE91}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Kovina');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{EB063B84-71E4-4F28-83AE-B7E8E357BF73}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Zrak');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{26DE1009-ADD6-4B71-B367-D28FED93CE99}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Jeklo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{3154B497-E7CF-4A22-80C6-54B47AA802A5}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Talna obloga');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{F8498867-381D-4CA3-8202-289D4E2E13C9}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Lesonitna plošča');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{3A073816-38AD-459F-B871-2C76B87797DF}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Zemeljski sloj');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{7DDCA022-6800-4628-80A1-FB472FD3AD82}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Masivni les');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{28D9DED2-1B3A-44F6-9170-1E442EBF34B8}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{86ADDE04-6466-45B1-8952-0AE42AB8750D}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Purobetonski blok - stena');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{5594FD21-67FF-45A4-BC36-6B09BF0BDCEB}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Betonski blok');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{C6FED6BD-5B53-46F6-AB76-EF62CED7910F}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Plošče');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{F921F97E-0A16-45A2-B378-4F1568FCA76D}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Les-jeklo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{ED5484F6-989E-4CBA-BBF9-EDED7D194645}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Lahka konstrukcija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{02151618-B960-49D9-A095-72E7977599FD}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Plošče 20cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{89FB0C7D-B671-41B8-9423-D4303FFEE6B0}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Plošče 50cm');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{E36BD789-D810-4EA6-BE84-3102955C0206}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Prod');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{26E47630-8EFB-43C2-86A1-AC33987EB56F}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Prečna letev');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D2ED04D0-7938-4BA7-842A-C2FEF2BE8194}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Mehka plošča');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{19F8975F-95D4-4E6B-9533-0B84C1E1E8F0}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Opečni zidak');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{31CC1553-C136-4D38-AA91-F14B52DED814}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Opečni zidak - izolativni');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D0AF1CA3-2878-4F0A-821B-65F748A2D595}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Razraščen teren');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{FCF783F0-BB88-406C-9B1A-9AC4F586E6D9}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Izolacija mehka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{72488830-B412-4869-B522-5B57B08129C8}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Mavec');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{8AD022A5-57AC-4A7F-80B0-6A0C8DF5CD04}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Mavčno vlaknena plošča');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{162FE5DD-D9C2-46A1-9649-9983719E974A}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Mavčno kartonska plošča');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{1842F682-5BD4-4E6F-AFAE-D3778B5B05E0}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Lepljen nosilec');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{75BFAD1B-ABD0-4244-AC39-D23EC57AB86D}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Steklo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{F40D9EAB-0CC4-4447-9008-68D27DB54BA8}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Plošče iz naravnega kamna');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{DE45C552-1F57-4700-AE77-0AA6F6E9F101}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Armiran beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{64924CAE-4998-4C74-80B8-4FAC4620DE46}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Iverna plošča');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{FBE57BE6-DD31-4665-ABC5-99A17B2ADF7C}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Armiran beton (vodonepropusten');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{75436788-5919-40AF-9776-A969CA2D51D1}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Lesena podkonstrukcija tal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{DDE4EBA3-4E2C-40FF-915D-C938464AA4B4}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Lesen opaž');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{A30EB426-CCA2-49EE-838B-1A16F166C3BC}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Prefabriciran beton stena');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{A0E8F476-1234-4F55-933D-004516F69638}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Sestava tal');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{4EBC963B-9B62-481E-8A66-A08B398F29B4}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Strešnik');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{49A1B611-AA41-48C6-8645-91460172A3C4}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Vlaknene plošče');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{97CB0F49-C6DB-430B-B5EA-0299FDD8592F}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Opečni zidak - votli');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{8414D2AB-F354-4AA7-81BB-AF4F84252B29}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Prefabriciran beton');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{B89518AE-774B-43D5-BCB0-D82248ED9128}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Les');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{93BCAB12-8635-4287-99BA-820DF00F1339}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Naravni kamen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D926BB11-387D-4480-8D9D-8918349CE4A1}', 'global', '255', 'material', '2025-03-13 10:59:17', 'Obloga');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{B17C559F-E9A7-40CB-BF3D-9B86AB727D28}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Tesnilo');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{751BD657-C4A7-4743-9B20-7F7AFEF6EEA7}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Izolacijski omet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{1EB0CFBE-D47E-40D7-B4F2-0BDF2AE7B8D5}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Zunanja izolacija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{B4545C27-30DD-4FEF-8EC8-F792F24A1DE1}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Lamelna talna obloga');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{4CD12EAC-3E50-49B0-AE2D-DDA37569E954}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Umetni material');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{6171A5C2-FD8A-44BE-9BC1-D5CAF28E4982}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Drenažni pesek');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{DFF7891D-6C38-46AB-BC27-A4FC46AD3906}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Umetni material - Aluminij');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{9806F637-F7CE-441D-BFB0-B60DABCF268E}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Betonski estrih');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{3AE9A304-2411-4449-8468-62E17BC6ED16}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Zunanja izolacija trda');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{FD0032C5-8298-4933-A0C1-CED6FECC9CF7}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Letve');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{C4F1B645-1E6D-4AF8-A1D8-D2F8F83784B9}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Fasadna izolacija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{CDA0C57F-462E-4442-9EE6-DD66CCE161A2}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Zunanja izolacija mehka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{2F2915EB-BE8D-442C-8C08-E9BE2B832892}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Izolacijska prečka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{12B073DC-3EF0-4FC7-B800-8DCA9E4E7D76}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Izolacija med suhomontažnimi p');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{B3A0CB4A-59D5-4D74-997C-CE80D92FBDEF}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Naklon izolacije');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{58D610E6-3B42-4E19-A31D-E73030284C87}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Izolacijska stojka');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{4956156F-BF24-4977-9C46-75472081ED2E}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Zvočna izolacija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{10B74D67-81DD-4454-BB98-186E8CAF18A1}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Izolacija trda');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{F7619807-80A4-4A69-B302-40F6CDF04635}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Prazen prostor');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{95488335-D140-4401-BB69-3C745563859F}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Eternit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{BA978CE0-90D3-4D5A-BA52-54279079520E}', 'global', '255', 'material', '2025-03-13 10:59:18', 'Aluminij');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{DAB30105-515F-4243-AB13-D5A67D1533D4}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Ytong');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{61D0E0B1-0BEC-4AFD-8F21-11E2D7BC6162}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Façade lining');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{996A98EA-BA3B-4BC5-8878-95EEC0A1FEC8}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Masonite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{8F2F5374-351D-494E-AEE7-9443EE03FC58}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Granolithic concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{BBC4E7B7-588A-482B-A4FD-E577E6027FBA}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Hard concrete');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{AA2E23C5-046D-47AE-A5A3-6B582A42B83D}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Detritus');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{1F011785-0D50-4643-AFF9-F7DB73BD7E29}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Polystyrene');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{76C1D89E-9BEC-43F3-8E05-633CD0DB7406}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Chromium-nickel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, pl) VALUES ('DM-{0E1A3077-2408-4926-9DF2-886027AD3C4B}', 'global', '255', 'material', '2025-03-13 15:06:16', 'Velux');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{0EF6E4E6-91ED-454B-A824-7515BFE6980D}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Beton vodotesen');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D5770FBE-D9B5-4F35-B82C-26C65B250BB0}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Opeke');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{D55AD896-3D13-4047-A705-2D336A00E7E1}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Ploščice');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{ECA0EAEC-DD48-41D5-A1BE-D259B5B29936}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Estrih');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{6101872C-AB34-4DA4-AF41-B37CD4DBE707}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Purobetonski');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{0C1E6128-5FF5-4EF1-A2A6-83388A23F95F}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Gramoz');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{577638DF-31BE-4BA6-93FF-76956B03728A}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{3A5DA562-2C5E-4B0D-A042-A08A59FE4DFD}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacija med suhomontažnimi ploščami');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{B4CEB5D4-78E5-4CB9-B23B-AC10F5512089}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lahka kovina');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{1302F157-7390-4972-ACB4-4DFA598B632D}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesena konstrukcija');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{4D008E6D-02B8-465E-870D-7043722E96B8}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesena tla');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{CBC679E8-0498-424D-8195-AAFCA8F3489D}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Tesnilni trak');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, sl) VALUES ('DM-{E1936FB0-F79C-4B35-8D76-6410E1708A58}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Prefabriciran beton - stena');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{9D97B6E7-FE15-4DCD-A55B-F930F568B448}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Αδειάζω');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{008F86F9-C5CD-4A2E-8812-C9B4C83C034D}', 'global', '255', 'material', '2025-03-21 07:06:42', 'γύψος');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, gr) VALUES ('DM-{2F62F8D3-6CD6-4424-B557-C4F45DD51249}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Φύτεμα');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D15C44EA-AC6E-4492-B618-AB20B57176A7}', 'global', '255', 'material', '2025-04-24 13:38:45', '0.6025 (EN-GJL-250)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F2B0297C-EF90-4B52-A274-973F63C9FBDE}', 'global', '255', 'material', '2025-04-24 13:38:45', '0.7050 (EN-GJS-500-7)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0DF14730-7CC8-4A97-92A5-06609E848183}', 'global', '255', 'material', '2025-04-24 13:38:45', '0.8040 (GTW40-05)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BC1CBD12-F62B-4145-9013-3AE9B7124DD4}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0030 (St00)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{891020D1-F8CF-4ECE-829A-E18667F8B77A}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0035 (S185)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{95298244-B266-495C-BA0C-CA8096FA4E10}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0037 (S235JR/S235JR+CR)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{628FE910-1BD6-47C6-8A02-542ADA5342AE}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0038 (S235JRG2)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{85F5CBFF-E352-4563-951D-8AAA6551A3E9}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0111 (P245NB)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{395F5F64-F8EA-4288-B430-870C6367C681}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0140 (S275J0C)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C17F36EF-9A19-468F-A52E-45A7C23ECB53}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0308 (S235G2T  / E235)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A0457B2D-FB2C-45EC-AFFD-23685E5F5523}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0401 (C15)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{84F5C2AF-369E-4C85-8875-6C706F1F1BB4}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0408 (S255GT / E255)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{EED2F2D3-0A30-4911-A664-F1CE6AF30487}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0501 (C35)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DE5327E2-9477-455D-B057-AA35F506B917}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0503 (C45)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9774B3A0-73F8-481B-A373-4123326BD73E}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0507 (S355J0Cu)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8BA7B8FA-D51E-498E-9123-B6802A403BCE}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0570 (S355J2G3+CR)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5003324C-D232-44EE-8260-B652945E8C67}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0580 (S355GT)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DA941352-CF3D-4D05-8B3C-B6BD6EF2BA56}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0601 (C60E)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6731C0F2-1A2F-43ED-BF1E-124346677408}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0603 (C67)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{608BA154-DF86-4324-B300-104B29EB8134}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0605 (C75)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{489F08E1-75B7-4B4C-9E5A-642D2D657EDE}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.0718 (11SMnPb30)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BD639F4B-0E7F-4FFD-9BEA-50E2EEB5EC8E}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.1191 (C45E)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4324DDC3-F5A9-4EF7-B513-07178BC97163}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4006 (X12Cr13)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{69AC108F-81D8-44F2-8F89-ED0CBB4EBCAC}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4300 (X12CrNi188)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{FCAB9F31-9A4A-40D3-9BC9-56CBBF76D677}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4301 (X5CrNi1810)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{475A5C2D-B344-40D8-8CB8-6E0955F6468D}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4408 (GX5CrNiMo19-11)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{44444D2B-49C5-4B82-AC62-9CCC0268E789}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4436 (X4CrNiMo17-13-3)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{38E479BC-139E-4066-B6AB-8A1357CF5B2D}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4541 (X6CrNiTi18-10)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AAC0CD49-DE8F-4B5B-8711-D1A4974E12E7}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4571 (X6CrNiMoTi17-12-2)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A5B6B96B-5E1D-4E3A-B6D3-82F3051F2705}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.4878 (X8CrNiTi18-10)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{9678BCFA-FB6C-41BA-8456-19AA54B4578C}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.5026 (56Si7)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{25F39060-38E0-4FCE-8749-5D24F3FDB4B2}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.5415 (16Mo3)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{094C7DC9-D17D-4ED3-A2C5-7B32B04FB8CE}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.7035 (41Cr4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{42E30308-178B-4586-8FAF-4A2A3F6112FB}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.7218 (25CrMo4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{0AA914A8-D617-40B6-852F-25C831D47DA7}', 'global', '255', 'material', '2025-04-24 13:38:45', '1.7321 (20MoCr4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CECD0688-2D86-4C08-B49F-83F3810D8970}', 'global', '255', 'material', '2025-04-24 13:38:45', '2.0261 (Ms72)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{27AB0E09-0628-4AD7-8775-50316F1C8BBD}', 'global', '255', 'material', '2025-04-24 13:38:45', '2.0360 (Ms60)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CF1B43A4-8BD3-49DE-ABC2-829F2B7D51CF}', 'global', '255', 'material', '2025-04-24 13:38:45', '2.0401 (Ms58)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F5111110-5988-484F-AD36-97ECD29C70E2}', 'global', '255', 'material', '2025-04-24 13:38:45', '2.0975 (G-SnBz12)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C24A0B89-6BAE-41F2-B017-0A9D43F7FC74}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.1325 (AW-2017A)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F6A0EF5B-B70B-4C24-A457-B6305028455C}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.2315 (AW-6082)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C6F7B0EE-1C81-443F-BD4D-A0A2958C1AAC}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.2381.01 (AC-43000)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{34EA6C95-F87F-46A6-B5B3-F4E44D71AA45}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.2381.61 (G-AlSi10M)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{615CA962-6DB0-4797-8B9F-3F7B6F66B518}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.2581.01 (AC-44100)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{407E2440-B280-471A-90E5-3BB9CD10A6A1}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.3206 (AW-6060)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A7719D03-7C4F-4664-B7F3-0277192B7548}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.3555 (EN AW-5019)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5BFF0683-F4AD-4424-A1E4-D4D5481D89B9}', 'global', '255', 'material', '2025-04-24 13:38:45', '3.4365 (AW-7075)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{250C2398-5FBD-42B0-8BA8-D98A5203AA5D}', 'global', '255', 'material', '2025-04-24 13:38:45', 'CW300G (CuAl5As)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{04AADF4F-3177-4519-B19F-DEFE488E9330}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Ni-St,36%');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6524F66B-D31F-4E52-B6E2-054F5C1BA965}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Nickel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{06AE4B71-7A41-47A9-97EE-656C2A81C1EB}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Pb');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{040D5EA6-9188-4ABA-A2FD-852DF7ADF850}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Platin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{97070477-87FA-4071-9F76-54543EB92FCC}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Silber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DA2417DB-D262-43F7-B93F-5A03594B8D02}', 'global', '255', 'material', '2025-04-24 13:39:12', 'SnBz6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{07B2671B-11BF-4BD5-9F22-6E11F32AF3BD}', 'global', '255', 'material', '2025-04-24 13:39:12', 'ST');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1F30C1DE-6911-4065-8187-145DE85128BA}', 'global', '255', 'material', '2025-04-24 13:39:12', 'ST-gehärtet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{74405653-1BB9-4C34-9D21-331DB400FE61}', 'global', '255', 'material', '2025-04-24 13:39:12', 'ST-verzinkt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{403E3042-E917-43DF-B7A6-DA6A365DECA5}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Titan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6E6E1B9C-357F-4188-B806-5607FA9F32B1}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Zink');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{8A9F7904-1516-4566-9F01-FEAD7DECC1AD}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Zinn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{202B28F9-4EE4-4A90-B3D7-8F354D112F0B}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Cr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{CB88FC2E-883F-498C-97CF-82AEAB8A9EA3}', 'global', '255', 'material', '2025-04-24 13:39:12', 'Gummi');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E556806E-ADF4-47BA-A0A5-1C5DAF7A98B3}', 'global', '255', 'material', '2025-04-25 07:20:03', '1.4541 / Graphit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{552E9ADB-D8C3-41C2-99CC-2DCECB505DB6}', 'global', '255', 'material', '2025-04-25 07:20:03', '1.4541 / PTFE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E195FB4F-9F1D-49B7-93CA-1C147C5D74E5}', 'global', '255', 'material', '2025-04-25 07:20:03', '1.4571 / Graphit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{7BC3EDA1-1331-47BB-BE7E-E63C177586B3}', 'global', '255', 'material', '2025-04-25 07:20:03', '1.4571 / PTFE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B1DA4432-BF1D-4672-83D2-657C3B30CF0B}', 'global', '255', 'material', '2025-04-25 07:20:03', '10');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DDF1D2FC-35C6-44F3-A9E6-692D59B8EE82}', 'global', '255', 'material', '2025-04-25 07:20:03', '10.9');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{00CE2756-2437-4FB6-A871-6AF92F2E9E8D}', 'global', '255', 'material', '2025-04-25 07:20:03', '12');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A3735132-BF0E-4931-8F6B-A022586E0C34}', 'global', '255', 'material', '2025-04-25 07:20:03', '12.9');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{DFD6AD0D-6D0E-4698-BA89-F5231D9BEB7C}', 'global', '255', 'material', '2025-04-25 07:20:03', '3.5');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D3EF1FB4-BCC1-47C3-A04E-B272470D5202}', 'global', '255', 'material', '2025-04-25 07:20:03', '4');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4900D5B4-6685-460C-B0C1-187F01B6C3AC}', 'global', '255', 'material', '2025-04-25 07:20:03', '4.6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BBA9E739-D390-4A3D-98A9-6AA901463633}', 'global', '255', 'material', '2025-04-25 07:20:03', '4.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C4291051-3D00-4F49-8CC3-749DA7C67B98}', 'global', '255', 'material', '2025-04-25 07:20:03', '5');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4FFD0D86-A1DF-4058-B27D-8795B7E1F70F}', 'global', '255', 'material', '2025-04-25 07:20:03', '5.6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA40BF14-215C-4988-B7C4-A90751A90DCD}', 'global', '255', 'material', '2025-04-25 07:20:03', '5.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4226FCDB-2714-4F2D-9DBE-5C7943DFB455}', 'global', '255', 'material', '2025-04-25 07:20:03', '6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{A13C3BDA-BE7B-4B6D-A9F9-CF8E89A29EC0}', 'global', '255', 'material', '2025-04-25 07:20:03', '6.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BAACFFFE-7011-492F-9DF6-C95636806996}', 'global', '255', 'material', '2025-04-25 07:20:03', '8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{276F6801-F1CF-4F97-A051-60BAF6425C40}', 'global', '255', 'material', '2025-04-25 07:20:03', '8.8');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5F5A2666-6113-49AA-A71E-71EB5F4D4248}', 'global', '255', 'material', '2025-10-13 06:37:43', '10');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E3A5A32C-57D5-43BA-B376-C70ED5EFD05B}', 'global', '255', 'material', '2025-10-13 06:37:43', '10.9');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B325DFF5-BE69-4476-BEEB-513039A0581C}', 'global', '255', 'material', '2025-10-13 06:37:43', '12');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A7564CEE-C777-4AEE-A52F-7EB6D96C6443}', 'global', '255', 'material', '2025-10-13 06:37:43', '12.9');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2FDBDF9A-EFF1-4A61-8538-CA01798B28FE}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.5');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6793ACF4-2077-4FD7-B83E-C810453A6B04}', 'global', '255', 'material', '2025-10-13 06:37:43', '4');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{86DA804D-82F9-4D4F-BA6C-78F1F5A4F7EE}', 'global', '255', 'material', '2025-10-13 06:37:43', '4.6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C9A6B5AF-6477-4508-BBFC-9BBCE65812FB}', 'global', '255', 'material', '2025-10-13 06:37:43', '4.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6C69529B-D871-4D76-A1F1-AB97D2185A1D}', 'global', '255', 'material', '2025-10-13 06:37:43', '5');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{45EAD9A4-7F28-4211-A449-60260537805B}', 'global', '255', 'material', '2025-10-13 06:37:43', '5.6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{95DA744D-CB2D-498E-9297-184EDA641209}', 'global', '255', 'material', '2025-10-13 06:37:43', '5.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B78FCF27-E1E8-49F5-9FD5-C0151C029AD8}', 'global', '255', 'material', '2025-10-13 06:37:43', '6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7CAC0E6C-A371-4157-B302-B2D2227CD39C}', 'global', '255', 'material', '2025-10-13 06:37:43', '6.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{71A0C7D9-A8B3-4FF1-88CE-B24212C82E05}', 'global', '255', 'material', '2025-10-13 06:37:43', '8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0E8CD943-A885-4B33-916D-215A4A99F254}', 'global', '255', 'material', '2025-10-13 06:37:43', '8.8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5A907409-5BD5-432B-A49A-D539846CC26D}', 'global', '255', 'material', '2025-10-13 06:37:43', 'AlBz8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E144A3CF-22F3-4CBB-9633-1FA840FDA7BD}', 'global', '255', 'material', '2025-10-13 06:37:43', 'AlCuNi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CBEE3C80-36A2-443A-84F1-8B332147A355}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Aluminium,allg.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4EFB1211-1160-4314-9DD5-FF3B8E8DE6FF}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Au');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{45E4BFB2-D459-47C1-BFC9-CBD0DC49DEC8}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Cr');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DB755C7C-BB6D-48F2-95FF-5C6EEDDB9E71}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Kupfer');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9468B355-9B5A-4F99-ADD6-E64F41F59691}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Ni-St,36%');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8BC13D09-325A-49CC-A441-C662307EC243}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Nickel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EE997D7A-9F9F-4B19-B6D4-16C3D10FC4DD}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Pb');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7379937C-0132-4462-93F6-ED1707E6D3AE}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Platin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E513958A-42CA-4765-91F9-9038959DDE83}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Silber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3B57B705-BB02-474D-8F9E-AA0032F1EBDC}', 'global', '255', 'material', '2025-10-13 06:37:43', 'SnBz6');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C71D3FD8-30EF-4ED1-AA40-74D372A774DD}', 'global', '255', 'material', '2025-10-13 06:37:43', 'ST');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7D04BF73-788F-41D0-BD46-1AA6098C7F5B}', 'global', '255', 'material', '2025-10-13 06:37:43', 'ST-gehärtet');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4C3CE93B-A010-4CDC-8338-D06A97872A96}', 'global', '255', 'material', '2025-10-13 06:37:43', 'ST-verzinkt');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{134ECD3F-DE58-400F-852C-8FB5BA4921A6}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Stahl');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{CBC82ECC-75EE-48F6-B341-F6B807BCB7A2}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Titan');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1769D74E-84EF-412B-99AB-B85689F4B713}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Zink');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3CC2D9F9-7B56-4656-B94C-947948DA1E56}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Zinn');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F0175A9A-71B1-4A81-81DF-A39572EC15DE}', 'global', '255', 'material', '2025-10-13 06:37:43', 'Gummi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{8504C8DC-66C3-44E5-A40C-9D9F2620E933}', 'global', '255', 'material', '2025-10-13 06:37:43', '0.6025 (EN-GJL-250)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{ED6E2E68-B5EA-4210-B911-94C584CEF256}', 'global', '255', 'material', '2025-10-13 06:37:43', '0.7050 (EN-GJS-500-7)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E00D5C75-FA0F-4DD2-8C78-139E379F1544}', 'global', '255', 'material', '2025-10-13 06:37:43', '0.8040 (GTW40-05)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C13D9AF0-D6F1-4376-B7DF-5FBE42D661F2}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0030 (St00)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C4A68DED-4CC8-4323-B613-EB8DA7E15172}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0035 (S185)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{20E8E6B8-7906-4024-A0EE-68FC8028FFC9}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0037 (S235JR/S235JR+CR)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{D4F32580-AC5E-4A68-893C-33DE43ED1EA2}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0038 (S235JRG2)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9031E81A-15B5-40C2-A1FA-C58F06D3CBA0}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0111 (P245NB)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2E882FC2-7D77-4CBA-8F21-E3AF3F70766C}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0140 (S275J0C)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B14A369B-E224-4D8C-9889-432F932DC937}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0308 (S235G2T  / E235)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5DA4AF9E-6302-4651-B35E-0D4BD4EE620A}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0401 (C15)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F18CA1C5-15B4-4D61-986B-AB639036B321}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0408 (S255GT / E255)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{99CC848C-7EF9-4D12-9D98-AB2E9EA9DC8A}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0501 (C35)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9F7D86AC-FB0B-4BD9-BFC5-35AE3C0F9571}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0503 (C45)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{583500E1-9B14-45F8-A34A-2CD701488F71}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0507 (S355J0Cu)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{83451AD2-D136-4DF1-9D05-866BEB912D4F}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0570 (S355J2G3+CR)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{2E9EF127-85BB-41D5-90C8-A5F7D91E67FB}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0580 (S355GT)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{A678AD33-9BF1-41BD-A2EA-68BAF5750509}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0601 (C60E)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{74AC6794-89B0-444A-8515-0C5109411619}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0603 (C67)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EAB94FFD-7D11-4D1C-9C60-472856876D28}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0605 (C75)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C04BD81E-E6BD-442F-A105-F9F902CA468D}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.0718 (11SMnPb30)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FF7BF33C-C2F2-4569-85C9-C7FAB6BB3543}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.1191 (C45E)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{23D7F459-6C36-4393-B079-2A0BBDFD5DBB}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4006 (X12Cr13)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{AEE1DB89-077B-4EE1-B353-6C01CFFEB490}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4300 (X12CrNi188)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{6AB22951-640B-42EB-B1E9-3FEFD23F7BC0}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4301 (X5CrNi1810)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{54ADFBC4-B0D4-4804-BB4A-023270C6F175}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4408 (GX5CrNiMo19-11)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{B7344576-6869-40E4-9BD5-5F6AAE0C7C52}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4436 (X4CrNiMo17-13-3)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{70118169-8B7E-43B8-B057-7D828E8EBB13}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4541 (X6CrNiTi18-10)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DFF6F3FE-53B5-4B34-82F5-B68FA8FC41A5}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4571 (X6CrNiMoTi17-12-2)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{22E3A409-647B-41B3-8D46-78C58C7D2D08}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.4878 (X8CrNiTi18-10)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F911576B-50B4-4DD4-AC71-CA7C2547AB9E}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.5026 (56Si7)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{3FD60823-ACB3-4B4F-AA79-FACF2085FE9C}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.5415 (16Mo3)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EAFD0CC3-892B-4B8E-97E5-055D20C49137}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.7035 (41Cr4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C9115AB9-6156-470D-8ED0-1D403CC8C54A}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.7218 (25CrMo4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{9D62B2B7-CE6A-482E-AC28-13E93B3DC4F9}', 'global', '255', 'material', '2025-10-13 06:37:43', '1.7321 (20MoCr4)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EA11C4EA-B5BE-42EE-A0D9-0E60C37376F7}', 'global', '255', 'material', '2025-10-13 06:37:43', '2.0261 (Ms72)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{EACE8071-7DA2-4865-87E5-2A988B17F7B4}', 'global', '255', 'material', '2025-10-13 06:37:43', '2.0360 (Ms60)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4C72414E-167C-48E7-B693-DD118568B22B}', 'global', '255', 'material', '2025-10-13 06:37:43', '2.0401 (Ms58)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5BEF6047-B5B3-4A48-8FEF-A48E381D73F5}', 'global', '255', 'material', '2025-10-13 06:37:43', '2.0975 (G-SnBz12)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{466D8277-184F-4A41-A051-223A26E19525}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.1325 (AW-2017A)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{7DCB4F43-AA62-451C-BBEB-360653DE2BB5}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.2315 (AW-6082)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{68A8E6BC-253A-4896-876A-112431F5357E}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.2381.01 (AC-43000)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5E57F877-8F50-44DA-B78D-29CABF14CBD1}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.2381.61 (G-AlSi10M)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{30A27149-9664-4895-B06E-1022CFCB659F}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.2581.01 (AC-44100)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{DADCC7BA-5DA4-480F-95E2-4D8232BC7C85}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.3206 (AW-6060)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4D77032B-B683-4C88-B4FB-18429B2B451E}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.3555 (EN AW-5019)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C6DE35FF-79BC-4E9A-956C-7AC7F53DA90C}', 'global', '255', 'material', '2025-10-13 06:37:43', '3.4365 (AW-7075)');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{0086F477-AD27-4B4D-BEE5-D38F2B7976B3}', 'global', '255', 'material', '2025-10-13 06:37:44', 'CW300G (CuAl5As)');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C37465BB-62C5-46D6-8EA5-75786E642B0B}', 'global', '255', 'material', '2025-10-13 07:58:32', 'AlBz8');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4D5863EE-6923-4B2E-BFA6-1A930FE09457}', 'global', '255', 'material', '2025-10-13 07:58:32', 'AlCuNi');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{B617FF9D-DF80-4055-886C-C44ED3F8CAFF}', 'global', '255', 'material', '2025-10-13 07:58:32', 'Aluminium,allg.');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{847368D5-1085-4C7A-AC20-A30CD1C64E27}', 'global', '255', 'material', '2025-10-13 07:58:32', 'Au');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{5E1E9E5E-D8AF-45EC-BC42-F82AB845BEAB}', 'global', '255', 'material', '2025-10-13 08:10:50', '1.4541 / Graphit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{78275199-35C7-4D31-A074-838DA04C8C97}', 'global', '255', 'material', '2025-10-13 08:10:51', '1.4541 / PTFE');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{F4F8AEDF-0337-40E7-A610-FF175BF643CF}', 'global', '255', 'material', '2025-10-13 08:10:52', '1.4571 / Graphit');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{1B150A6A-4E32-4230-9B72-7D2BDF77C80F}', 'global', '255', 'material', '2025-10-13 08:10:54', '1.4571 / PTFE');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{541F31A1-13F6-4A69-B3BE-3E6A24C19AE6}', 'global', '255', 'material', '2025-10-20 13:11:45', '1.4541 / Graphite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{4774B747-54D3-4201-9B7B-023B025FDCC9}', 'global', '255', 'material', '2025-10-20 13:11:45', '1.4571 / Graphite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{C7C7E916-90CF-4591-8C10-BC6BEF110324}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Aluminium, general');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{52FD9684-5644-4EFF-9F01-10F523A308C7}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Platinum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{17CF9FB5-6A3D-4258-9D9A-0DFF47CFB0C4}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Rubber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{FAFF8AE9-7733-4501-8F1D-5A659056A8CE}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Silver');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{934EC4F8-CD9D-4664-B4F1-68F8A8AE4559}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Steel-galvanised');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{62FA72E4-D69F-4EDA-A350-CF80F0E4D143}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Steel-hardened');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{E3198496-98E1-439B-88E6-4826E1E835FE}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Tin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, en) VALUES ('DM-{34D0C3FE-44FF-4255-89FA-F2452DAF9E85}', 'global', '255', 'material', '2025-10-20 13:11:45', 'Titanium');
-- values
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{5A0B5609-38F4-46C5-BC23-D8B86CC1F13D}', 'global', '255', 'material', '2025-10-20 13:30:36', '1.4541 / Graphite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{4542D8BE-5652-4BBB-A785-8239CAEA201B}', 'global', '255', 'material', '2025-10-20 13:30:36', '1.4571 / Graphite');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{483A1984-E384-4532-8703-2ED351F87793}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Aluminium, general');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{D9F7DAEB-A4F9-4B45-B4B0-8EE3668605EA}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Copper');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{2157D049-996C-432B-B216-7504031C83FB}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Platinum');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{E3367E84-5E6F-4C53-AB01-7F6C812D04D1}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Rubber');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{6BBFB844-739E-4FBD-8670-C5A86E9CA780}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Silver');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{F35FFFFA-5957-4164-B88E-5D438BBCB5D9}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Steel');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{1B4BEB54-20BC-407F-9FF5-19CF49CF3D16}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Steel-galvanised');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{AA36A50B-F9D6-4F92-A3E7-2C16CAE6EE04}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Steel-hardened');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{C46E8ECB-A964-4F10-9A11-1CE30F2E6255}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Tin');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{BA6B9072-16C0-40DA-9C2E-888339C83DE2}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Titanium');
INSERT INTO ecad_guid_info_depthmat (guid, username, mode, add_info, modify_datetime, de) VALUES ('DM-{347EAC14-8E45-45F4-844F-2F923ABD3821}', 'global', '255', 'material', '2025-10-20 13:30:36', 'Zinc');
