USE ecad_guid_info;

-- guid info for: assoc table for mapping guid <-> hierarchy (n:n)
DROP TABLE IF EXISTS ecad_guid_info_depthmat_assoc;
CREATE TABLE ecad_guid_info_depthmat_assoc (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,         -- guid (DM-GUIDs)
    assoc_guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,   -- assoc guid (DM-GUIDs)
    region varchar(255) DEFAULT '' NOT NULL,                                     -- e.g. 'de_at', 'de_de' ...
    username varchar(255) NOT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,                                          -- e.g. for any logical grouping    
    modify_datetime datetime DEFAULT NULL,
    PRIMARY KEY (guid, assoc_guid, region, username)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values (de_at)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7905A39F-DE8B-42C7-9513-719D2F56BE61}', 'DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}', 'de_at', 'global', '255', 'material', '2024-09-24 08:00:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96DC5B54-9BE1-4D83-864B-B2123638C7ED}', 'DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}', 'de_at', 'global', '255', 'material', '2024-09-24 08:00:00');
-- values (de_at)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}', 'DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'de_at', 'global', '255', 'material', '2024-12-17 15:39:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BD74C5-74F3-4684-AC8F-F1271A54352E}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_at', 'global', '255', 'material', '2024-12-17 15:41:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA278F00-FD96-47B3-A6F8-8A3FDAB6DCA8}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_at', 'global', '255', 'material', '2024-12-17 15:42:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C952DA14-65E1-46AA-9B48-A4938FC31C9F}', 'DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_at', 'global', '255', 'material', '2024-12-17 15:42:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}', 'DM-{56D5EFFF-16E4-41AE-9AEA-BDF48C2BCC49}', 'de_at', 'global', '255', 'material', '2024-12-17 15:43:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}', 'DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_at', 'global', '255', 'material', '2024-12-17 15:43:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68D1F59E-18A0-458A-BA82-9191BAF8B647}', 'DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'de_at', 'global', '255', 'material', '2024-12-17 15:46:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}', 'DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'de_at', 'global', '255', 'material', '2024-12-17 15:46:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB311F3C-4272-4A79-AFA6-61ACC4F6186D}', 'DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_at', 'global', '255', 'material', '2024-12-17 15:48:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF220C79-A9F3-4EC7-805A-3D4A0315D388}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_at', 'global', '255', 'material', '2024-12-17 16:03:57');
-- values (de_at)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C369DA26-6ED4-4C90-A3C6-7B0ADF9DB351}', 'DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}', 'de_at', 'global', '255', 'material', '2024-12-18 06:59:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3245F0-9F80-4F63-B8F8-939CBF02D9AA}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:00:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{910AE78E-E3F8-4522-AE34-F3A52A43F6B2}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:00:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29E896B3-665C-45B9-8BF5-9FE0C320E0D1}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:00:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4391BE4-3DBA-40E4-A244-2C3C716D32CA}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:01:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{419795D5-265A-4EE6-B04B-7F95D4F3D9D6}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:01:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:01:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AFA4179-D904-4798-B0FC-C5784CAF1DA8}', 'DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'de_at', 'global', '255', 'material', '2024-12-18 07:01:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}', 'DM-{56D5EFFF-16E4-41AE-9AEA-BDF48C2BCC49}', 'de_at', 'global', '255', 'material', '2024-12-18 07:03:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82D09EA7-2C80-455F-BCCC-FE5C06E6D33A}', 'DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}', 'de_at', 'global', '255', 'material', '2024-12-18 07:03:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}', 'DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}', 'de_at', 'global', '255', 'material', '2024-12-18 07:04:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2585F4DA-2DD7-45ED-8F85-BE1BE81D50BF}', 'DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}', 'de_at', 'global', '255', 'material', '2024-12-18 07:04:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98336CB8-C70D-4977-B867-09F5383BE414}', 'DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}', 'de_at', 'global', '255', 'material', '2024-12-18 07:05:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF89323E-B0D9-47F2-94EE-8074EC19C131}', 'DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}', 'de_at', 'global', '255', 'material', '2024-12-18 07:07:22');
-- values (de_de)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3245F0-9F80-4F63-B8F8-939CBF02D9AA}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2024-12-18 08:08:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{910AE78E-E3F8-4522-AE34-F3A52A43F6B2}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2024-12-18 08:10:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29E896B3-665C-45B9-8BF5-9FE0C320E0D1}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2024-12-18 08:10:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4391BE4-3DBA-40E4-A244-2C3C716D32CA}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2024-12-18 08:10:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AFA4179-D904-4798-B0FC-C5784CAF1DA8}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2024-12-18 08:10:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82D09EA7-2C80-455F-BCCC-FE5C06E6D33A}', 'DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'de_de', 'global', '255', 'material', '2024-12-18 08:11:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C369DA26-6ED4-4C90-A3C6-7B0ADF9DB351}', 'DM-{FE0CB650-5385-41A5-8030-0238F6B45CCB}', 'de_de', 'global', '255', 'material', '2024-12-18 08:11:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98336CB8-C70D-4977-B867-09F5383BE414}', 'DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}', 'de_de', 'global', '255', 'material', '2024-12-18 08:12:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}', 'DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_de', 'global', '255', 'material', '2024-12-18 08:12:23');
-- values (de_de)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}', 'DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'de_de', 'global', '255', 'material', '2024-12-17 15:39:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BD74C5-74F3-4684-AC8F-F1271A54352E}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'global', '255', 'material', '2024-12-17 15:41:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA278F00-FD96-47B3-A6F8-8A3FDAB6DCA8}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'global', '255', 'material', '2024-12-17 15:42:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C952DA14-65E1-46AA-9B48-A4938FC31C9F}', 'DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_de', 'global', '255', 'material', '2024-12-17 15:42:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}', 'DM-{56D5EFFF-16E4-41AE-9AEA-BDF48C2BCC49}', 'de_de', 'global', '255', 'material', '2024-12-17 15:43:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}', 'DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_de', 'global', '255', 'material', '2024-12-17 15:43:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68D1F59E-18A0-458A-BA82-9191BAF8B647}', 'DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'de_de', 'global', '255', 'material', '2024-12-17 15:46:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}', 'DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'de_de', 'global', '255', 'material', '2024-12-17 15:46:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB311F3C-4272-4A79-AFA6-61ACC4F6186D}', 'DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_de', 'global', '255', 'material', '2024-12-17 15:48:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF220C79-A9F3-4EC7-805A-3D4A0315D388}', 'DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'global', '255', 'material', '2024-12-17 16:03:57');
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-01-20 09:45 -- de_de -- global --
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0071598B-15A3-4E50-A335-A2483C496AD5}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:55:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0087C144-E873-4653-B3CD-48E8E1E8F2FC}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01BBE83E-C872-47FF-8093-57115B016248}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:46:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{021E1190-DA04-48A5-B656-1322B6705196}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:11:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{02894DC8-F7D6-4AE5-8F82-CB474A20A0F0}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:40:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0301E547-F442-4B54-85AC-0783919D9E6E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:25:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0303A666-CBB4-4A39-BEC5-9A0B6AF2FFDF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:37:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04FA3D29-7A94-4B08-9364-5AED9614F1C8}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:27:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{053BF56B-E3F1-4CFB-BA3F-1C2FE8CA14F2}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_de','global',255,'material','2025-01-16 14:42:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EB0D32-D438-4E41-B5CD-54C94D7A4E1A}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:01:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{072B0962-355D-46DA-9921-DDD9904E3AFC}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:36:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0759AA9F-D741-432B-BF9E-4856FDB1D536}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:00:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0865A54A-C9C9-4E59-87B9-3B2628D53B13}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:11:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0900F429-407D-449F-89FB-CCD610390FB5}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:01:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0925B528-8522-49A0-9B53-EEA71CB30C69}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:45:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A5A17AA-FBE2-40D1-9117-5DAD3E6EE9F8}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:21:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AEBA150-A369-499F-A7E0-D7D0A3DE94E2}','DM-{7A464856-1A9A-4ACD-B727-BFDE8FDBE45C}','de_de','global',255,'material','2025-01-16 14:28:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2BA224-4CB1-4195-83F1-064148F2025E}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:43:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5667DE-B543-4622-8B78-647E11A4FD0C}','DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}','de_de','global',255,'material','2025-01-16 15:22:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E3E86EC-B23F-4FDE-BA36-440AE9E10A9D}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ECDE985-4339-4321-9A65-FBC4DE9E21F0}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:48:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ED14911-C57E-40DF-A524-9CBEF1EE1E0E}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:41:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F80F3A0-0F74-479E-9209-E346E2A48744}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:24:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FCA57F8-A535-4CAE-8043-CEDA63BABD82}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:12:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FF35FE6-7792-4503-A92C-EC6288CFD689}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:05:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{114D715B-2B00-4BA4-A935-BC64D6A327BA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:20:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1150F312-A137-45EA-BEC0-95447C34CDA2}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:54:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{125CB03B-4DCF-4750-995E-27218B836006}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:33:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{129C23CA-866D-4B3F-8D90-6BEE8591B7AB}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:53:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13D9DE86-A75E-493F-9858-08D28262B75B}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:07:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{143045E7-6490-44C7-99F6-3F6280474C8B}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:38:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1471AB7C-6B27-4E89-A495-43106AEC0783}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:38:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14878589-AC28-48BE-B2E7-A6C16E277486}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:12:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{149F9FD9-FF02-4F59-AFAB-AB7EB31AECE8}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:09:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14B38291-E4A4-4CD6-A119-67E59232CD40}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:08:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16DD0D52-AD64-4104-91AF-B020E3566B30}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:51:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BC30DFD-2B2D-4D8C-AAF5-4F5CCA44FBE7}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:37:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CA5C230-B720-4CA9-9749-B4A9CF2DF020}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:03:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CB7D687-C625-4FCC-91D6-8358318103F4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_de','global',255,'material','2025-01-16 13:25:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D714135-EAAF-429C-BF5C-11B8ED973DAB}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-17 09:52:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:18:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F1AD63C-540C-43DF-B1B3-BAEB04C5B54D}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:58:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F5686A7-78B6-445C-84FC-29CDC7DE029A}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:27:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9509E1-342B-4E2C-991F-138A1751767C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:13:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201F732E-02CF-44FC-987F-3B90661531EA}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:17:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201FE7BC-320F-4B82-AC00-F7D8B315C7B6}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:24:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2060F1DC-05FD-41F1-827D-60506901C571}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:01:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{209DC80F-F315-4618-8219-4D3B705C4423}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:03:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2235E068-40F1-4B30-B1F1-1E88BE82EE8E}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:28:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23C49DB1-1EC5-404E-B1CF-597C7EEAB234}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:52:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{241DE528-D03E-4E6A-A965-BB34F9169CFD}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:43:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253001AE-614E-43C5-BB35-AA191785AA91}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:56:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253B6D5A-1BF1-433D-B908-4A0364A621C0}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:18:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2555C259-BA6B-41DA-9183-603C9CF8ACFC}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:37:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25621FF8-BF53-4280-968B-00556BC57F3F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:29:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2565AD1D-6160-41B8-AC97-C72B4F9D6969}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:58:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2571DA7B-AD18-48F2-9F5F-2AC5E612BBFA}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:54:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25AF8E8F-FC0F-4BFA-B609-0FE77D254E79}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:57:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2649424F-9988-4A12-8F6B-74933169212C}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_de','global',255,'material','2025-01-16 14:16:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26D73B71-AFFD-4053-9147-CC1FBB0C0A0E}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_de','global',255,'material','2025-01-16 13:23:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{291C650B-9A8B-4CD3-B30E-C1F618BBFBD0}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_de','global',255,'material','2025-01-16 14:50:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{297956B8-263E-452D-8104-B9DD399A5CC3}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:58:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A120080-40E6-49C1-A06F-D07FA284CFDC}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:26:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A19D51D-C386-43DD-B477-C4C3F5BC9D99}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:30:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A5DFAE4-AD42-4357-8487-9114B26B13E4}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:30:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B0576EC-E063-420F-A3B2-70B4635A590B}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_de','global',255,'material','2025-01-16 14:49:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B29E6C2-F65B-48C6-8EE3-946FBE59EE92}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B467DD3-E7AD-4458-9C1F-BC880AF184C0}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:19:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B504045-621B-45AB-8C31-F7577A1CEC1B}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 14:59:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B701457-3A9C-4D28-90C1-2821D1BE29DA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:15:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CBC45AF-CF3B-4760-B56C-A23423E7F326}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:21:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D6BC8ED-D9D4-4CA1-806E-9523965BF2CB}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:55:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D8BE6EA-9A3D-4958-9615-30A9030B57C9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:56:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DDF28E4-B35A-49AE-80ED-6746B29BF752}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:17:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FA145FF-F02B-432E-B5B5-2C76CF79E194}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:29:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3001C337-71A9-46C7-80E1-B8120C67376B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:47:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{300D93C9-1696-4F53-8FD8-74CCC6FBBC85}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:32:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3090D571-3B41-46BF-9522-F0C8E2128529}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:39:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30D60592-599E-4BE8-8D1A-28D8F3859CF1}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:30:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31709897-80B0-4110-A56E-77CFD4B0840B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:15:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31D178A0-8F81-4915-A7BE-3F1F7B7432E2}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:09:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{322D0687-8579-41B0-8679-0F604C6E0458}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:23:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3267ADD8-D9D3-4C5C-BA37-887C16C6504C}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:57:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{332A0923-5807-440A-83FE-918A48C2582E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:25:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338AE0A0-FC06-425B-81EB-77CBD6EAC70D}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:42:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338F78F4-99AF-48D7-96DB-51D4993F3C9B}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:52:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{343E6211-72C9-4556-B8BC-7980014FF4EC}','DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}','de_de','global',255,'material','2025-01-16 14:38:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345D1773-77CA-4B04-B017-D3B49652B92E}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:38:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3483AEBF-B1F8-422A-8E88-5DADAC925789}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:35:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35659FF6-B868-4D54-B1E6-D1F07BCD049F}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_de','global',255,'material','2025-01-16 14:40:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35C7B94D-CA6C-48ED-952A-B282B4BA2673}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:52:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35F80E9A-869E-4FCF-BFBC-D68231281552}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:29:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3916CB90-E296-4A5A-AC8F-F0B60CD6FBD8}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:45:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{393AE909-BCCB-47C8-AEDD-5407293A6840}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:58:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39C410BB-2C4E-4F5D-9808-23571B9CD8EB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:13:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A6D932B-6996-4181-B667-AF781C2CD93C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:20:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A88F034-3971-4F5D-AED4-00EA19AC7277}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_de','global',255,'material','2025-01-16 15:03:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AA81746-338E-40E2-A2BF-4A1BFEE2ED63}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:34:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B37F528-C350-4160-A195-53899B4D01C5}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:21:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C332A67-84A0-4577-9D2F-B27B0AE6D93E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:10:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CAB62DC-0509-4E7F-8BD2-838036E4DDE5}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:27:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DAC9A5A-B27B-43A0-9336-CBF07A76BF6A}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_de','global',255,'material','2025-01-16 14:18:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E108672-7248-42CD-A0B8-0970E3B08809}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:30:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E18CCC5-9902-4516-BB66-DFD21CA94C87}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:31:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FE92E47-E3CC-4F73-BD2D-11F7E1BF553D}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:35:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40501B63-59EE-4DF5-9F43-9B6AA0FA624C}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:31:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_de','global',255,'material','2025-01-16 14:49:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40B11739-37B2-41AA-A4C3-2C0E131BACE7}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:57:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4164EA41-A33A-4167-AB7E-92AFA8F128D3}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:26:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AABD05-7051-4CE4-897E-AB730417F1AD}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:59:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4257630E-4A37-43D0-8F85-AC82D371D426}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:08:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42D71C90-E15D-49D1-AADA-FFBF5F42FE16}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:57:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{442A56BC-F7F0-49BB-A2A4-20506CC0295A}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:03:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{445EED45-8D0C-4429-A418-531B391CC656}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:55:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{446162F5-FB3F-4486-AFC6-ED898FC079E7}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_de','global',255,'material','2025-01-16 13:23:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{458B0053-FF8E-482B-92FB-12A5F6647580}','DM-{FE0CB650-5385-41A5-8030-0238F6B45CCB}','de_de','global',255,'material','2025-01-16 13:06:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B323C2-A99A-4C86-8BE4-564121501153}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:26:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B9820E-17AB-4FAE-B9FD-74DBFE884CAB}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:31:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{461AFBA3-CB2F-4A38-9544-9FE8C7B1CEFF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:34:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4685D8C6-A669-4DA0-A29B-0118F9778337}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:13:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{470D6786-E8DA-47E4-9577-8AD49D00708D}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:00:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{471A22AB-BF17-4531-8FCB-B7FACAD63F69}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:12:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{472446CB-2673-44EC-8F63-7DEC34BD731D}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:19:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47AB55D5-DD5F-4459-9FBC-88D043125EEB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:18:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4844FF4D-17D2-4FB6-8195-784EF9AAE1B6}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48CB7CFD-7722-4D21-A206-B1E51623339A}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:05:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ECAB8D-4C00-42E1-8964-A0EBF4A03857}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:29:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{491D74AD-1139-41DB-8F37-D1B7D77B8F87}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:46:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2C3CBA-CF19-4BDB-9A2A-E0D5E6601DAC}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_de','global',255,'material','2025-01-16 14:19:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A49EA5C-BC01-4454-85CD-14639EF6EB45}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:18:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AF082B1-EA21-4E72-97D4-FE14099F1906}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:07:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B7DAA06-5201-4EC8-B9EE-5EDE0C6D0375}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:26:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C451960-1EB3-41D6-8B4A-2BB7F699BAD4}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:12:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D39DA7A-82C6-435F-94E7-A6761514CCCB}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_de','global',255,'material','2025-01-16 15:02:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D66518C-E043-421E-9A29-25F87E1E959B}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:01:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D73F2EE-59E2-496A-8ACE-C23DC481EEB5}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:11:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DE79FD5-E185-421C-9C36-A5567CA64525}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:19:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA3C08F-AC4A-4DA4-B6BD-C52564E21C2D}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:52:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF4C714-1A45-441D-950D-83DC9E080806}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:59:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5038E65B-08D1-4C27-8911-81069EBBED8F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:38:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51DEE2CD-3282-4250-B2EA-12E7B9E5F71F}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:55:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52028111-6F23-4555-98C4-79E565009A02}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:43:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{520F1261-05D6-4C15-AD0B-83C0596B8798}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:26:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52C695FB-0503-40F9-A861-D2288979C701}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:55:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{533C1ABC-33A4-40ED-A226-5EB05A405DD8}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:39:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54236FE2-5C14-4653-B991-4437F05E43BE}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:29:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551FD34A-F3BD-45B2-B29F-D9AFF7A5BC74}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:53:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5520DB60-0FCC-4750-ADA1-E95DDB876756}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:18:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5542832A-4AED-4801-8044-CB2013B3A3E0}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:56:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{563F3B68-1748-43C5-B638-0B3D7CF2BF62}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{567CCF42-21C7-4FD6-85BD-DAE8D52C7BA9}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:58:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{583B4073-AB7D-477E-974A-AF7E809C547B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:13:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{585CD8D4-0C33-4645-9724-CEA76CEE7EB6}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:31:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B62C2E-037F-413C-8AD5-31881D7F6F48}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:58:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B2D677A-920D-422F-8E7A-12E4DAFC09A8}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:14:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C0DF7FE-D87C-4116-A08C-4AACB93D289C}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:55:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB0B2C0-780F-484C-80CC-79F873965516}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_de','global',255,'material','2025-01-16 13:25:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB320B3-DA76-40E5-9595-B220E2C6B0FC}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E336947-1AE4-42FF-92D7-07F56B85EF66}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:42:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E5E70EE-2EA6-4F27-A225-DB86B337E75A}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:38:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F7A8ACF-1C44-46C8-B2CF-60E5BD79C51A}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:47:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FE606D8-0495-465E-BA6D-4FB02BBFB8BC}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_de','global',255,'material','2025-01-16 14:20:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6032F2EF-CFEE-4A74-BCE8-D50296D080B7}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:09:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60454BC5-FFFB-45EB-9490-F30B302AA734}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 14:17:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609AC8F6-FCFE-4F38-846B-56AEEE6845E0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:24:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C8728E-5711-4117-B619-61428FCFBA6E}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:39:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61A15942-5FFF-41F0-9A9A-52D6AA6FB5FD}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:15:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61C5F456-03F6-46AA-B8F4-4A7C40513933}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:48:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{636C649D-3677-45B0-9CCC-E651B8D6F107}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_de','global',255,'material','2025-01-16 14:20:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{639C4733-C6F9-485F-9770-DD0F41335BAB}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:40:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{654B2532-349B-4617-9BCA-94F05447CA05}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:00:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65FF2BC2-3A47-4778-949C-A89CD7EDDB38}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:17:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{678C169D-B56C-477B-8B62-DBB072B5487E}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:41:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A5650B8-21DA-4969-99F2-F9D4638FEF51}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:47:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A772FB0-896B-4BC7-933F-51C884A11C0D}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_de','global',255,'material','2025-01-16 14:18:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AFE65A5-ED5B-4BEF-B88B-1F496798485A}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:34:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BE7175C-2FD3-4C64-A3F0-9902666338FA}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:09:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C39864D-2892-4A9E-BE3E-95398FD26156}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:34:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D10C998-8690-404C-8A1C-FB2C79ACEF01}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:32:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DB4D983-7C1D-4635-B81C-8F05DB27D7E1}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:55:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DC76042-BF36-4735-A766-0DBE9D7C7C2F}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:29:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DEFE768-215F-4837-AFF9-451315801959}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:14:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E904830-E8D9-4E0C-948F-7674475CD49D}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:30:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6ED12D39-7307-4B7C-95E5-EBAC9FB21BEE}','DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}','de_de','global',255,'material','2025-01-16 14:32:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F06C7AE-52C6-4B3B-944D-2ABFC8B4C2F0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:27:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F80ED60-7902-443A-8904-8E9744E9D378}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:37:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC921A-8552-4B95-8770-92812B0516D9}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:13:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FBCAF5-0686-4317-9750-748A8143F704}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:59:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7112CEB4-C1BC-4799-A545-4F93ED55F96C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:57:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71E0B550-D0AE-4A3F-A573-C4EDCAE57D97}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:06:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71EC64B5-D0A7-4905-832C-225045D93C08}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:35:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71FAC7F9-C184-4378-AD08-21C49F3718FF}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:12:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72588056-5804-460D-9C63-320B4B699879}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:20:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72B7C6B9-163B-43D6-A0A5-C3E2A1735C94}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:54:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73DDDBD8-7625-41EC-A1B2-27847FD1E595}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:11:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E4570E-9344-487F-B73C-2F8EC7CF96E9}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:29:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74213C7E-2F47-406B-B4B4-09769868CE4A}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:34:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74B3A49D-C985-4579-A6C2-0D14F720C847}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:48:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{758BEC58-62EA-49DA-B9A2-F0A99C331153}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:10:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75D16018-9787-4750-B3CB-B7FBCE87027D}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_de','global',255,'material','2025-01-16 14:16:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{768F7C16-B435-4DDB-AAD4-4686510A7DC3}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:41:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76CA8E8B-5C42-47A4-ACD7-B49D919CF9DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:57:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{770C99AB-1889-48C9-8735-8CBA02404D87}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:32:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FF5BC-C2DB-4795-ADA4-6849FB61B1DE}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:58:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{779D8106-0E63-49DE-BFF9-954FC4EB82B5}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:28:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7861717E-13DA-4305-8DBB-A63E5ADB6055}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:14:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78E8AC1D-FF9B-43F2-8467-3B62FA429688}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:44:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7905A39F-DE8B-42C7-9513-719D2F56BE61}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:55:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79EA5ECE-7986-43E8-821D-CB280B634230}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:27:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ABD6DD9-13E8-40E8-82FD-6AE5391E4F69}','DM-{230F3439-05DF-4317-BBCE-DAA3BEDB7038}','de_de','global',255,'material','2025-01-16 12:52:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADB1C34-D3A6-475E-A2C4-27155C3BCD8E}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:28:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B1100B8-85A7-4ECD-A74E-EF81F44F0FEE}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:28:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CCC4D83-82ED-4086-842B-99DFD8A3A10B}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:54:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EA5052C-446A-4D4E-A8DC-5C9D2F014F14}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:52:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F910534-B4FB-40F7-B609-DC34AE9F6292}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:07:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80028D4B-9D90-4E3A-96F8-C1A6825D21A4}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:36:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803BCB4F-86A2-489E-AF7A-1EFF535F7A1C}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_de','global',255,'material','2025-01-16 13:25:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80F37F2B-3C2D-4F1D-92D3-B720988F5488}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:53:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:57:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81D6B700-E328-4DF9-AACB-3A5DC32468CE}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:51:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81DC2B42-4B9F-4139-AA03-B819B8CA1F97}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:33:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82912D28-1A48-4146-83C0-9E7DE9DE6746}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:25:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82FAB99F-2B3E-4447-A8F4-A0C1B156C612}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_de','global',255,'material','2025-01-16 14:16:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85841BF7-716C-4BA6-83BB-7E3804D9BF31}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:56:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA5A97-5BE3-44AE-845D-CF1CA195EFE1}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:34:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{878FA7C3-A29F-40F2-A5E2-0E0C377B8D5A}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:30:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88A153CD-C694-4B1F-9381-1B5311EC761C}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:40:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{891BAAF1-FE3C-4C48-9D5A-E445301AB46B}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:29:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{894FC435-DDFD-43DF-8E35-2B8D5D45BFD6}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:30:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A011D29-D7C4-442B-B9D8-899E8700CB69}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:24:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A3D6102-7A38-4C3E-B3E4-19F2C234F2B0}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B3D72F8-CA5C-4350-BCAA-972C10BFBAD6}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:47:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C5B12C3-14B9-44F3-9893-B1CD0AD0224E}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:14:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C813C80-92FB-4A59-A4D3-491631E7C58B}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_de','global',255,'material','2025-01-16 14:41:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E0AB25A-F5FB-4ACA-93A5-B0E4A88917CB}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:55:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E1DC2E2-16A4-4A15-AA32-FBA8EB30DFFF}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:43:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E501A4C-6271-46F2-8D15-E63DB914C168}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:41:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E6CB485-781E-44D3-AA54-0F153FA075E1}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:27:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:42:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FCE5383-58E0-42D2-A839-3339A4CDC440}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:01:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{906E136A-4EA3-4414-B847-951F9475FD9A}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:16:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9215EB28-7A78-434D-B4BE-928963FB8044}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:06:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{924FDE12-5283-4B25-8511-05302950202A}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:58:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93220622-69DF-43FD-B822-E492256687A8}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:30:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93BA73BA-64A2-43FD-A2D7-475C05DBAFBB}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:27:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E60701-0351-4D85-A56C-B9D854423EB0}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:58:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93FA25D7-6FAB-4620-90DE-6279C096105C}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:30:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{954226D6-0A78-42C5-A387-18EADE6AC2E7}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_de','global',255,'material','2025-01-16 14:19:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96DC5B54-9BE1-4D83-864B-B2123638C7ED}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:02:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97301D60-40C9-4B64-AD75-162554953672}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:12:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98336CB8-C70D-4977-B867-09F5383BE414}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:26:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{987B2F8B-6BB7-44CD-BCCC-445D40913C09}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:28:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98F9ED0E-1FFB-400E-9E55-9E89A954D7B3}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:58:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99EAA439-5781-41A8-AC9B-70BC5DEAB0AE}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:13:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A5B4D6B-B8EF-4E5F-B743-AA9F4E0289D3}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:47:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AE4552F-F747-43A0-B9DB-0D8B8C5F08DF}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B84A9D2-448F-4651-9DBC-19220A618871}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:18:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BC350B3-9CE7-4825-BB2B-33BFCD516FC8}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:58:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C045DFE-3891-418C-956E-3A5194E459A4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_de','global',255,'material','2025-01-16 13:25:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C6AA5CD-7CD3-46EF-ADEC-D85A1D86A884}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:03:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D992CC0-489E-481C-B640-ACD8F335040D}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:30:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E835B1C-0054-4A06-8B42-D99C3667C791}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:48:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ED27B13-66B6-4F88-AE4A-8A7A4857E9B2}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:31:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FE1387-1032-49F8-8035-9D82DCFEFF84}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:44:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A11BBB5B-4A73-4E2A-A6FB-CFC047C7EE1E}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:35:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2E47E30-75C0-4C24-9FA5-0AC629E7264D}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:25:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2F862D8-81A7-41C2-B57D-2BC6CE01F3AA}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:10:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A33136B7-6DF1-483F-A416-AC920F9CB18E}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:33:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A39118BD-A20C-4093-A5C9-5DB9703B012E}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:16:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3D1300C-BDC1-4EE6-B16D-BC38715B84C5}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:36:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3EA0ECA-ACFE-42F8-BEF2-D370EC0030F9}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:26:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4E2CFDE-6808-4676-9F6E-3C1CCA3EE0E6}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:28:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4EC2644-B0C5-4540-926C-EA6ED42B5983}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:31:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B42B77-660C-476A-B1D4-B9C2FC6306F5}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:29:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5CD422B-3077-4F77-AD82-B8C780B37732}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:05:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5FD5C0F-7FFD-49D2-BBBF-214E5B63531A}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:44:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A611DAD1-6EF3-4EF7-AAA9-7A0941519333}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_de','global',255,'material','2025-01-16 13:24:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7080459-9868-41B5-9D97-3660BA51B8F0}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:00:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A73400C2-DB7B-4542-8D3E-8AC7312B3755}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:57:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A79A9EB9-0F61-42AA-9072-94300C8E8D31}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:40:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7CA4264-50A9-4D8F-BFF1-636ECC67398E}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:28:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8B95938-7C89-486C-9B1D-8C9ECB8A1805}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:26:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9EB4F04-B492-4FE8-8ACD-7BBC24DD09CE}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:39:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA0FCDC1-4017-4745-BE85-50EC3D61B6AC}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:26:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA4790DD-4085-4C5E-A54F-68C60A954D77}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:53:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA85F24D-5CC1-48A7-BF69-B3AB0F30971E}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:58:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB29B77F-D255-49A5-8E29-235BA8E1DE5F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:32:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC365583-C36F-441C-9EE1-921167CF5A78}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:53:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC525EED-EE76-43C4-9563-89011E25CA98}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:06:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC5D448D-D7EE-40FC-9BDB-E8E7F4939746}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:50:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD19FDBC-6B43-49D4-A97C-EF8822C4C63C}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 14:59:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD4017BB-BE59-44B5-B3FB-6555A4BB7C78}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:06:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF39A4F-A454-4196-90C8-503D4459B786}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_de','global',255,'material','2025-01-16 14:25:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF166FAA-7BD9-441D-9CBC-890E7B7C7FA5}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:47:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF89323E-B0D9-47F2-94EE-8074EC19C131}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 14:59:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFCC74A6-15A1-4BA9-8176-2808391228D2}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:42:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFD4CB07-3FCA-47ED-8802-777A8CE23522}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:33:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B023EA49-F408-4BD2-9DAE-ED68EEDAA185}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:33:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1428FFC-6490-493D-974F-CFFD4AA9792A}','DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}','de_de','global',255,'material','2025-01-16 14:39:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1D7C370-704C-4F44-9ADD-AD087F3EFAE4}','DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','de_de','global',255,'material','2025-01-16 13:54:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2827D17-4BE9-4D0E-8828-431CDB4C68A3}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:28:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B371EFD6-F3D1-48E3-A9A2-5CF13A05200F}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:51:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3CFBDC1-A153-4716-AF3D-C49BB4159D77}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:28:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3EE36D0-77D3-466B-80E1-56C5EBD788D7}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:45:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B46160CC-651B-4F36-9B9E-654617B9707B}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:43:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E9E5DD-7777-45BC-BC88-901DE1140E1E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:07:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5963F8F-AA83-4F40-82B8-D1CA4051EA34}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:32:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AF9423-0408-4103-8FFE-5E950896DEA2}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:15:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5FE1E24-7BFA-4B59-9BB6-D1A782E3FB38}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:30:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:36:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8AB0639-F900-4C70-88B0-C468B81D1A6A}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:31:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9268A79-566E-4922-9AC7-BF935D20D780}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:14:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9613779-1B9B-49A6-9756-6E6644705862}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:27:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB37673F-7932-42A4-8C9C-837AD457A8F7}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:10:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBC86339-D568-4069-9C31-016626F62E24}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:18:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCA4D010-58E4-40D6-88FA-BEFFA4DBB56B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:47:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCB7B6EB-132B-42E1-A260-C5FED3618CCB}','DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}','de_de','global',255,'material','2025-01-16 13:59:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFC72B9B-6286-481E-B617-A60DCB72FDD6}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:45:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C5B06A-DD2E-47C6-82A9-FA8D8C10AA47}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:12:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22BE2DE-3AA9-4D1D-A734-8A6C0C493F41}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_de','global',255,'material','2025-01-16 14:49:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C39BDFA1-55CE-4468-ABDA-5FFA1CF781CE}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:48:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A1B8AA-2808-489E-915D-DC5E73EA0E57}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:25:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C54E958E-3205-4A9A-8CC6-F59A7FD48D0C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:15:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6B1EAFA-1D56-4E99-B329-1427A159FB64}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:44:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C767AE06-964A-4883-A923-E2D2B3AECEFB}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_de','global',255,'material','2025-01-16 14:20:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7BA5787-D74F-4FB2-ACC4-DA0F9BE9F610}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:48:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7E512AD-4D86-4B24-8C01-B24B108208DA}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:39:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9FEDF3A-F477-4A40-B42B-BEB8F82824D3}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:05:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBCD2AB5-A3BF-443D-ADFB-772950B20F89}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBDFDBF0-3F70-4998-B5F3-3B516812FFCA}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:38:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC3C5AC2-D400-4255-9873-70752E98A33A}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_de','global',255,'material','2025-01-16 15:02:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CCA8C06E-4DC1-4AD3-8748-5EBF0F19E527}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:56:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CECCB58C-85EF-4738-957C-CFD9406189B1}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:30:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEDE3AC6-EF25-427A-B0B2-A953BD5DCE39}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:57:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF0A19FA-4586-4899-BAE5-4742E3334BE4}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:03:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0D6BB45-AC9A-45A8-9187-A09DEE2C61BC}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:55:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}','DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}','de_de','global',255,'material','2025-01-16 14:21:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D329FFB5-267C-4190-BBAC-0F948723A5E0}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:13:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4AD0C31-E704-4975-8765-E32739EF4A9D}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:09:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4E514C6-5AEC-44C6-8871-5C494F63716B}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:34:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D511756B-8654-4B0A-809E-AE11FC4C3D1F}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:54:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5194B1D-A3D4-4F1E-B46A-57E9DAB804FE}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:45:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D54B669E-FC58-465A-A6C3-A4058B0AAD13}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:00:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D61A0399-9BAE-4A90-B70A-FC3EB8AFDD3C}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:35:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6282B63-6ADB-4783-98A3-9FE17E531106}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:47:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63D069E-7309-4C02-A9BB-B0C6EA4109CD}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:42:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D687BA7D-C70F-4812-8EF3-89D0AD3D0564}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:05:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6C10AF3-49EB-4C4C-9FB1-066EAB0E48DC}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:20:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6D7E268-7471-4374-A453-CCB79AA34998}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:44:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D74C95DD-B621-42CD-931A-D880CB17E263}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:16:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7531F70-FB95-4DCD-86AA-3771AE309CBB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:20:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D92E9257-4A62-4CC5-8B63-6F5201352322}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:11:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D420AD-CAA9-4D82-B011-F991BD336759}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:27:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA041090-18BC-4CF8-80DA-87D9AE5B4305}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:29:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA2E3849-1B94-4E18-969D-3C5C87D93797}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:57:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAC05403-DD8C-4F82-B45E-D6DFED9F11C6}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:04:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}','DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','de_de','global',255,'material','2025-01-16 14:47:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB24ED80-E7E0-4605-B355-94BBA69A0D80}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:55:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB28071D-34AC-4E9F-8A59-8A3E75A21F33}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:14:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAA3F05-2D98-45B9-AA43-D4DD49A8F47B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:46:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3C0C84-7E79-430A-AEC8-67EF04CF145F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 15:11:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3E5615-5004-46C4-86B8-AAD969409883}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_de','global',255,'material','2025-01-16 14:20:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC502D3B-298D-4C74-864B-BD1513EBD106}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:21:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC731B0B-C467-4367-9785-AC5579C11A62}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:30:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC76EDBF-504B-4EC2-8A05-12F885700F2F}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:58:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCB6DAF8-807D-4868-923F-347B50645B74}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:36:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDEA4183-BAA2-4058-9606-71A52364F0A3}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:25:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_de','global',255,'material','2025-01-16 14:43:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE30037E-2369-494B-B2BA-D6ED29B681DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_de','global',255,'material','2025-01-16 13:57:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE330FC6-694E-44DA-B1BC-B6846D3301DD}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:01:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E043215A-8E25-4AEB-9E44-0DD862E1E323}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_de','global',255,'material','2025-01-16 15:13:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09B925F-D8C2-424D-9DC9-8B7B6AD724D9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:56:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1008D2B-6D08-4FCE-8105-07EFAA59DF48}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:16:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E118B37C-EC1D-4186-864C-4006CC66E5D2}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:01:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E23F8A51-D5CD-40D1-BC00-2EECC7D2A8AA}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:32:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E323AB1C-558C-4C25-B2E6-CF763B6FF7B1}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_de','global',255,'material','2025-01-16 13:23:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5B84FBC-EFB2-48BF-9767-83C12810D232}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:31:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E612A5B2-C6F2-4975-821C-98D10C8FC41B}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_de','global',255,'material','2025-01-16 14:55:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E75B4BB8-BDBF-4F41-B6AC-F0D07D05C690}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:54:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E763BD5D-C41A-4277-B1DE-47224145E3E0}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:32:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8C782C1-D024-4176-AFC3-F46A89D8F6EB}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:31:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E93F63A3-B2D4-42E0-AD6B-96112B44CF49}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_de','global',255,'material','2025-01-16 13:25:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E962EA34-CA7C-424D-88DE-95D58448132C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:03:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B137B6-05FD-4150-8249-3A9C151B71D9}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:29:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB2D5562-6638-4046-8E0A-1F68A720D52F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:39:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB4FE04E-A4C6-4DD0-AC09-7319F652A76F}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:15:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC7E571E-B222-4EC3-B768-0961A0511F04}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC8F84F0-286B-4A91-8785-7623610AA18E}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:28:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5D0950-A825-4CFB-9BD3-90B19461641E}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:00:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE275049-3EBF-4F8C-9A4E-3CA4C5A9C686}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:29:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F06DA951-B563-4F49-B459-BDABB046FB03}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:29:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F19974C8-16F2-4E20-BA8E-2D0145C03D9E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:08:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F38A674E-2E3B-47A1-98FB-3393BDF480D8}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:38:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3C902BF-C28A-4EA3-A782-BA4357CEB466}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:27:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F41B45CC-D814-4539-81A9-19AD613A9A4D}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:40:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F440F262-54B6-4867-B5E2-A48CACC40C33}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:00:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F49F6B49-C534-47DC-98A2-187FF0F4A76F}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:06:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F56A6298-916C-4051-B239-1EAE2421C39F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:28:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5CE4F94-782E-4536-97D2-5C08DBEE8ED7}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_de','global',255,'material','2025-01-16 14:30:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F62148B0-1B81-4F5B-A301-5B9565CEA3E4}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_de','global',255,'material','2025-01-16 13:48:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68084C5-38EC-4619-8DF5-2C917A28DF83}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:09:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6BEDD69-7D88-41BD-A575-A3B737CA2509}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:07:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F74CADE4-2118-4182-B57B-B8FF3A55EDC1}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_de','global',255,'material','2025-01-16 14:34:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F775933E-1D3E-440D-8EF6-4A44E6B02683}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_de','global',255,'material','2025-01-16 15:04:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7993446-DF96-4771-B2DB-0DAE4C4F645A}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:28:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7DEFB80-4B6A-4DB8-A164-7934A8D70B96}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_de','global',255,'material','2025-01-16 13:22:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F88BB350-04CF-4CE7-AC0B-90EDFEECF37E}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_de','global',255,'material','2025-01-16 14:51:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8A7DEE5-3559-41E2-BA29-E5D96A41DF55}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_de','global',255,'material','2025-01-16 13:32:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8B3EDFA-5A2C-4BB1-A6D5-858CB85DB8F8}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:44:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F94BDD00-67CF-48D5-B253-DEE3AC5B2A11}','DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','de_de','global',255,'material','2025-01-16 15:24:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA218E55-967B-4915-9DC0-8179A355AA70}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 13:04:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC18A93C-A165-4DD5-97F6-6C905773DB8B}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_de','global',255,'material','2025-01-16 12:55:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCD9318A-A44A-4651-8B36-2C58593B8E83}','DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','de_de','global',255,'material','2025-01-16 15:01:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCE05644-168E-4C92-A8E5-109452D0C23C}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:14:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD089977-55FB-4903-A94A-A157B9832E8B}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_de','global',255,'material','2025-01-16 12:39:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD752C8C-BCF1-4CBD-B3BF-499F44203DE2}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 15:19:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD800E23-71DB-4CBA-85BA-86B6530430AE}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_de','global',255,'material','2025-01-16 13:11:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD808C70-C14A-4562-92EF-A38EF363195A}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_de','global',255,'material','2025-01-16 14:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD8A58FD-9606-49AA-A057-A95DFC80C78F}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:39:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE06406D-E0EC-4FAA-A979-691FDA8E1DBE}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_de','global',255,'material','2025-01-16 13:41:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE6E28D9-9A2D-4202-96BF-5C4C81FA7E6A}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_de','global',255,'material','2025-01-16 13:15:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEBF62AF-F328-4A1D-A878-A897034E977A}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_de','global',255,'material','2025-01-16 13:09:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF19B1D3-9EC2-4122-A700-4DA0EB09C72B}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_de','global',255,'material','2025-01-16 13:38:43');
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-01-22 10:26 -- de_at -- global --
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0071598B-15A3-4E50-A335-A2483C496AD5}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:31:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0087C144-E873-4653-B3CD-48E8E1E8F2FC}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:41:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01BBE83E-C872-47FF-8093-57115B016248}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:41:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{021E1190-DA04-48A5-B656-1322B6705196}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:52:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{02894DC8-F7D6-4AE5-8F82-CB474A20A0F0}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:35:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0301E547-F442-4B54-85AC-0783919D9E6E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:06:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0303A666-CBB4-4A39-BEC5-9A0B6AF2FFDF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:17:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04FA3D29-7A94-4B08-9364-5AED9614F1C8}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:08:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{053BF56B-E3F1-4CFB-BA3F-1C2FE8CA14F2}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_at','global',255,'material','2025-01-21 14:19:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EB0D32-D438-4E41-B5CD-54C94D7A4E1A}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 14:37:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{072B0962-355D-46DA-9921-DDD9904E3AFC}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:32:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0759AA9F-D741-432B-BF9E-4856FDB1D536}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:35:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0865A54A-C9C9-4E59-87B9-3B2628D53B13}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:11:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0900F429-407D-449F-89FB-CCD610390FB5}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:03:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0925B528-8522-49A0-9B53-EEA71CB30C69}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:41:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A5A17AA-FBE2-40D1-9117-5DAD3E6EE9F8}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:19:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AEBA150-A369-499F-A7E0-D7D0A3DE94E2}','DM-{7A464856-1A9A-4ACD-B727-BFDE8FDBE45C}','de_at','global',255,'material','2025-01-21 14:09:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 15:11:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2BA224-4CB1-4195-83F1-064148F2025E}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:38:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5667DE-B543-4622-8B78-647E11A4FD0C}','DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}','de_at','global',255,'material','2025-01-21 14:59:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E3E86EC-B23F-4FDE-BA36-440AE9E10A9D}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:55:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ECDE985-4339-4321-9A65-FBC4DE9E21F0}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:54:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ED14911-C57E-40DF-A524-9CBEF1EE1E0E}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:36:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F80F3A0-0F74-479E-9209-E346E2A48744}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:02:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FCA57F8-A535-4CAE-8043-CEDA63BABD82}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:12:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FF35FE6-7792-4503-A92C-EC6288CFD689}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:43:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{114D715B-2B00-4BA4-A935-BC64D6A327BA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:57:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1150F312-A137-45EA-BEC0-95447C34CDA2}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:55:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{125CB03B-4DCF-4750-995E-27218B836006}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:14:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{129C23CA-866D-4B3F-8D90-6BEE8591B7AB}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:29:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13D9DE86-A75E-493F-9858-08D28262B75B}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:08:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{143045E7-6490-44C7-99F6-3F6280474C8B}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1471AB7C-6B27-4E89-A495-43106AEC0783}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14878589-AC28-48BE-B2E7-A6C16E277486}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:53:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{149F9FD9-FF02-4F59-AFAB-AB7EB31AECE8}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:50:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14B38291-E4A4-4CD6-A119-67E59232CD40}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:08:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16DD0D52-AD64-4104-91AF-B020E3566B30}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BC30DFD-2B2D-4D8C-AAF5-4F5CCA44FBE7}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:33:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CA5C230-B720-4CA9-9749-B4A9CF2DF020}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:41:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CB7D687-C625-4FCC-91D6-8358318103F4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_at','global',255,'material','2025-01-21 13:21:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D714135-EAAF-429C-BF5C-11B8ED973DAB}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 12:52:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:17:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F1AD63C-540C-43DF-B1B3-BAEB04C5B54D}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:01:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F5686A7-78B6-445C-84FC-29CDC7DE029A}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:03:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9509E1-342B-4E2C-991F-138A1751767C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:53:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201F732E-02CF-44FC-987F-3B90661531EA}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:16:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2060F1DC-05FD-41F1-827D-60506901C571}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:03:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{209DC80F-F315-4618-8219-4D3B705C4423}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_at','global',255,'material','2025-01-21 14:40:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2235E068-40F1-4B30-B1F1-1E88BE82EE8E}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:08:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23C49DB1-1EC5-404E-B1CF-597C7EEAB234}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:28:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{241DE528-D03E-4E6A-A965-BB34F9169CFD}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:38:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253001AE-614E-43C5-BB35-AA191785AA91}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2555C259-BA6B-41DA-9183-603C9CF8ACFC}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:33:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25621FF8-BF53-4280-968B-00556BC57F3F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:24:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2565AD1D-6160-41B8-AC97-C72B4F9D6969}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 13:00:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2571DA7B-AD18-48F2-9F5F-2AC5E612BBFA}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:30:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25AF8E8F-FC0F-4BFA-B609-0FE77D254E79}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:58:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2649424F-9988-4A12-8F6B-74933169212C}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_at','global',255,'material','2025-01-21 14:00:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26D73B71-AFFD-4053-9147-CC1FBB0C0A0E}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_at','global',255,'material','2025-01-21 13:20:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{291C650B-9A8B-4CD3-B30E-C1F618BBFBD0}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 14:26:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{297956B8-263E-452D-8104-B9DD399A5CC3}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:59:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A120080-40E6-49C1-A06F-D07FA284CFDC}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A163C0B-1851-4847-882F-A081CF649818}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:10:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A19D51D-C386-43DD-B477-C4C3F5BC9D99}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A5DFAE4-AD42-4357-8487-9114B26B13E4}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:06:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B0576EC-E063-420F-A3B2-70B4635A590B}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 14:26:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B29E6C2-F65B-48C6-8EE3-946FBE59EE92}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:55:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B467DD3-E7AD-4458-9C1F-BC880AF184C0}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 15:00:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B504045-621B-45AB-8C31-F7577A1CEC1B}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:34:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B701457-3A9C-4D28-90C1-2821D1BE29DA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:56:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CBC45AF-CF3B-4760-B56C-A23423E7F326}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:57:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D6BC8ED-D9D4-4CA1-806E-9523965BF2CB}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:31:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D8BE6EA-9A3D-4958-9615-30A9030B57C9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DDF28E4-B35A-49AE-80ED-6746B29BF752}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:16:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FA145FF-F02B-432E-B5B5-2C76CF79E194}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 15:18:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3001C337-71A9-46C7-80E1-B8120C67376B}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:53:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3090D571-3B41-46BF-9522-F0C8E2128529}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:46:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30D60592-599E-4BE8-8D1A-28D8F3859CF1}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31709897-80B0-4110-A56E-77CFD4B0840B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:15:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31D178A0-8F81-4915-A7BE-3F1F7B7432E2}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:50:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3267ADD8-D9D3-4C5C-BA37-887C16C6504C}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:58:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 15:19:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{332A0923-5807-440A-83FE-918A48C2582E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:06:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338AE0A0-FC06-425B-81EB-77CBD6EAC70D}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:21:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338F78F4-99AF-48D7-96DB-51D4993F3C9B}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:29:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{343E6211-72C9-4556-B8BC-7980014FF4EC}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 14:17:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345D1773-77CA-4B04-B017-D3B49652B92E}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3483AEBF-B1F8-422A-8E88-5DADAC925789}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:30:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35659FF6-B868-4D54-B1E6-D1F07BCD049F}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_at','global',255,'material','2025-01-21 14:19:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35C7B94D-CA6C-48ED-952A-B282B4BA2673}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:29:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35F80E9A-869E-4FCF-BFBC-D68231281552}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:11:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3916CB90-E296-4A5A-AC8F-F0B60CD6FBD8}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:40:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{393AE909-BCCB-47C8-AEDD-5407293A6840}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:34:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39C410BB-2C4E-4F5D-9808-23571B9CD8EB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:13:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A6D932B-6996-4181-B667-AF781C2CD93C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:57:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A88F034-3971-4F5D-AED4-00EA19AC7277}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_at','global',255,'material','2025-01-21 14:39:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AA81746-338E-40E2-A2BF-4A1BFEE2ED63}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:15:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B37F528-C350-4160-A195-53899B4D01C5}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:58:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C332A67-84A0-4577-9D2F-B27B0AE6D93E}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:10:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CAB62DC-0509-4E7F-8BD2-838036E4DDE5}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DAC9A5A-B27B-43A0-9336-CBF07A76BF6A}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:02:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E108672-7248-42CD-A0B8-0970E3B08809}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:12:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E18CCC5-9902-4516-BB66-DFD21CA94C87}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FE92E47-E3CC-4F73-BD2D-11F7E1BF553D}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:16:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40501B63-59EE-4DF5-9F43-9B6AA0FA624C}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:13:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40B11739-37B2-41AA-A4C3-2C0E131BACE7}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4164EA41-A33A-4167-AB7E-92AFA8F128D3}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:07:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AABD05-7051-4CE4-897E-AB730417F1AD}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:02:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4257630E-4A37-43D0-8F85-AC82D371D426}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:08:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42D71C90-E15D-49D1-AADA-FFBF5F42FE16}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:56:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{442A56BC-F7F0-49BB-A2A4-20506CC0295A}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:04:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{445EED45-8D0C-4429-A418-531B391CC656}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:57:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{458B0053-FF8E-482B-92FB-12A5F6647580}','DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}','de_at','global',255,'material','2025-01-21 13:06:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B323C2-A99A-4C86-8BE4-564121501153}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:07:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B9820E-17AB-4FAE-B9FD-74DBFE884CAB}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{461AFBA3-CB2F-4A38-9544-9FE8C7B1CEFF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:15:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4685D8C6-A669-4DA0-A29B-0118F9778337}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:13:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{470D6786-E8DA-47E4-9577-8AD49D00708D}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:35:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{471A22AB-BF17-4531-8FCB-B7FACAD63F69}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:52:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47AB55D5-DD5F-4459-9FBC-88D043125EEB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 14:59:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48CB7CFD-7722-4D21-A206-B1E51623339A}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ECAB8D-4C00-42E1-8964-A0EBF4A03857}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:11:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{491D74AD-1139-41DB-8F37-D1B7D77B8F87}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:52:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49C4FACE-72F4-4E88-8DD3-C83A430E9218}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 15:20:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2C3CBA-CF19-4BDB-9A2A-E0D5E6601DAC}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:03:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A49EA5C-BC01-4454-85CD-14639EF6EB45}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 15:00:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AF082B1-EA21-4E72-97D4-FE14099F1906}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:07:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B7DAA06-5201-4EC8-B9EE-5EDE0C6D0375}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C451960-1EB3-41D6-8B4A-2BB7F699BAD4}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:12:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D39DA7A-82C6-435F-94E7-A6761514CCCB}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_at','global',255,'material','2025-01-21 14:39:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D66518C-E043-421E-9A29-25F87E1E959B}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:38:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA3C08F-AC4A-4DA4-B6BD-C52564E21C2D}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:28:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF4C714-1A45-441D-950D-83DC9E080806}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:02:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5038E65B-08D1-4C27-8911-81069EBBED8F}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:45:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51DEE2CD-3282-4250-B2EA-12E7B9E5F71F}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:54:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52028111-6F23-4555-98C4-79E565009A02}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:38:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{520F1261-05D6-4C15-AD0B-83C0596B8798}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:08:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52C695FB-0503-40F9-A861-D2288979C701}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:56:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{533C1ABC-33A4-40ED-A226-5EB05A405DD8}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:35:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54236FE2-5C14-4653-B991-4437F05E43BE}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:24:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551FD34A-F3BD-45B2-B29F-D9AFF7A5BC74}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:55:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5520DB60-0FCC-4750-ADA1-E95DDB876756}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 14:59:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5542832A-4AED-4801-8044-CB2013B3A3E0}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}','DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}','de_at','global',255,'material','2025-01-21 15:17:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{563F3B68-1748-43C5-B638-0B3D7CF2BF62}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{567CCF42-21C7-4FD6-85BD-DAE8D52C7BA9}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:59:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{583B4073-AB7D-477E-974A-AF7E809C547B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:13:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{585CD8D4-0C33-4645-9724-CEA76CEE7EB6}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B62C2E-037F-413C-8AD5-31881D7F6F48}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B2D677A-920D-422F-8E7A-12E4DAFC09A8}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:55:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C0DF7FE-D87C-4116-A08C-4AACB93D289C}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:57:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB0B2C0-780F-484C-80CC-79F873965516}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_at','global',255,'material','2025-01-21 13:21:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB320B3-DA76-40E5-9595-B220E2C6B0FC}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:41:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E336947-1AE4-42FF-92D7-07F56B85EF66}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:37:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E5E70EE-2EA6-4F27-A225-DB86B337E75A}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F7A8ACF-1C44-46C8-B2CF-60E5BD79C51A}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:23:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FE606D8-0495-465E-BA6D-4FB02BBFB8BC}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_at','global',255,'material','2025-01-21 14:03:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6032F2EF-CFEE-4A74-BCE8-D50296D080B7}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:10:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60454BC5-FFFB-45EB-9490-F30B302AA734}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 14:01:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609AC8F6-FCFE-4F38-846B-56AEEE6845E0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:05:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C8728E-5711-4117-B619-61428FCFBA6E}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:46:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61220357-111E-4D88-B413-5A81F26A26B9}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 15:14:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61A15942-5FFF-41F0-9A9A-52D6AA6FB5FD}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:14:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61C5F456-03F6-46AA-B8F4-4A7C40513933}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:53:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{636C649D-3677-45B0-9CCC-E651B8D6F107}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_at','global',255,'material','2025-01-21 14:04:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{639C4733-C6F9-485F-9770-DD0F41335BAB}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:36:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{654B2532-349B-4617-9BCA-94F05447CA05}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:04:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65FF2BC2-3A47-4778-949C-A89CD7EDDB38}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:17:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{678C169D-B56C-477B-8B62-DBB072B5487E}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:48:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A5650B8-21DA-4969-99F2-F9D4638FEF51}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:53:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A772FB0-896B-4BC7-933F-51C884A11C0D}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:02:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AFE65A5-ED5B-4BEF-B88B-1F496798485A}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:16:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BE7175C-2FD3-4C64-A3F0-9902666338FA}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:10:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D10C998-8690-404C-8A1C-FB2C79ACEF01}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DB4D983-7C1D-4635-B81C-8F05DB27D7E1}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:31:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DC76042-BF36-4735-A766-0DBE9D7C7C2F}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:11:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DEFE768-215F-4837-AFF9-451315801959}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:55:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E904830-E8D9-4E0C-948F-7674475CD49D}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:12:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6ED12D39-7307-4B7C-95E5-EBAC9FB21BEE}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:13:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F06C7AE-52C6-4B3B-944D-2ABFC8B4C2F0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:08:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F80ED60-7902-443A-8904-8E9744E9D378}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:45:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC921A-8552-4B95-8770-92812B0516D9}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:54:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FBCAF5-0686-4317-9750-748A8143F704}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:02:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7112CEB4-C1BC-4799-A545-4F93ED55F96C}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:56:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71E0B550-D0AE-4A3F-A573-C4EDCAE57D97}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_at','global',255,'material','2025-01-21 14:40:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71EC64B5-D0A7-4905-832C-225045D93C08}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:16:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71FAC7F9-C184-4378-AD08-21C49F3718FF}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:11:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72588056-5804-460D-9C63-320B4B699879}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:57:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72B7C6B9-163B-43D6-A0A5-C3E2A1735C94}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:53:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73DDDBD8-7625-41EC-A1B2-27847FD1E595}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:52:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E4570E-9344-487F-B73C-2F8EC7CF96E9}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:05:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74213C7E-2F47-406B-B4B4-09769868CE4A}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:28:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74B3A49D-C985-4579-A6C2-0D14F720C847}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:54:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{758BEC58-62EA-49DA-B9A2-F0A99C331153}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:51:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75D16018-9787-4750-B3CB-B7FBCE87027D}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_at','global',255,'material','2025-01-21 14:00:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{768F7C16-B435-4DDB-AAD4-4686510A7DC3}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:48:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76CA8E8B-5C42-47A4-ACD7-B49D919CF9DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:58:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FF5BC-C2DB-4795-ADA4-6849FB61B1DE}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{779D8106-0E63-49DE-BFF9-954FC4EB82B5}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:23:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7861717E-13DA-4305-8DBB-A63E5ADB6055}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:55:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78E8AC1D-FF9B-43F2-8467-3B62FA429688}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:39:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79ABACA6-65F3-4E8C-AB86-AE2103206224}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:53:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79EA5ECE-7986-43E8-821D-CB280B634230}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:04:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ABD6DD9-13E8-40E8-82FD-6AE5391E4F69}','DM-{230F3439-05DF-4317-BBCE-DAA3BEDB7038}','de_at','global',255,'material','2025-01-21 12:47:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADB1C34-D3A6-475E-A2C4-27155C3BCD8E}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:07:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B1100B8-85A7-4ECD-A74E-EF81F44F0FEE}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:10:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CCC4D83-82ED-4086-842B-99DFD8A3A10B}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:55:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EA5052C-446A-4D4E-A8DC-5C9D2F014F14}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:54:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F910534-B4FB-40F7-B609-DC34AE9F6292}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:08:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80028D4B-9D90-4E3A-96F8-C1A6825D21A4}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:32:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803BCB4F-86A2-489E-AF7A-1EFF535F7A1C}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_at','global',255,'material','2025-01-21 13:21:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80F37F2B-3C2D-4F1D-92D3-B720988F5488}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:29:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81D6B700-E328-4DF9-AACB-3A5DC32468CE}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81DC2B42-4B9F-4139-AA03-B819B8CA1F97}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:27:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82912D28-1A48-4146-83C0-9E7DE9DE6746}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:03:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82FAB99F-2B3E-4447-A8F4-A0C1B156C612}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_at','global',255,'material','2025-01-21 14:01:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85841BF7-716C-4BA6-83BB-7E3804D9BF31}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA5A97-5BE3-44AE-845D-CF1CA195EFE1}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:28:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{878FA7C3-A29F-40F2-A5E2-0E0C377B8D5A}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:05:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88A153CD-C694-4B1F-9381-1B5311EC761C}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:36:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{891BAAF1-FE3C-4C48-9D5A-E445301AB46B}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:05:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{894FC435-DDFD-43DF-8E35-2B8D5D45BFD6}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A011D29-D7C4-442B-B9D8-899E8700CB69}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:02:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A3D6102-7A38-4C3E-B3E4-19F2C234F2B0}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:55:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B3D72F8-CA5C-4350-BCAA-972C10BFBAD6}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:52:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C5B12C3-14B9-44F3-9893-B1CD0AD0224E}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:13:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C813C80-92FB-4A59-A4D3-491631E7C58B}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_at','global',255,'material','2025-01-21 14:19:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E0AB25A-F5FB-4ACA-93A5-B0E4A88917CB}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:57:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E1DC2E2-16A4-4A15-AA32-FBA8EB30DFFF}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:21:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E501A4C-6271-46F2-8D15-E63DB914C168}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:37:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E6CB485-781E-44D3-AA54-0F153FA075E1}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:20:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FCE5383-58E0-42D2-A839-3339A4CDC440}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 13:00:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{906E136A-4EA3-4414-B847-951F9475FD9A}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:16:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9215EB28-7A78-434D-B4BE-928963FB8044}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_at','global',255,'material','2025-01-21 14:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{924FDE12-5283-4B25-8511-05302950202A}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:59:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93220622-69DF-43FD-B822-E492256687A8}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:12:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93BA73BA-64A2-43FD-A2D7-475C05DBAFBB}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:03:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E60701-0351-4D85-A56C-B9D854423EB0}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','DM-{D1ED221D-E26C-4FC3-8200-A1441FEE3A70}','de_at','global',255,'material','2025-01-21 15:14:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{954226D6-0A78-42C5-A387-18EADE6AC2E7}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:02:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97301D60-40C9-4B64-AD75-162554953672}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:53:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{987B2F8B-6BB7-44CD-BCCC-445D40913C09}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:07:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98AA9124-420C-488D-B0D6-CAA9F16654F5}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:06:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98F9ED0E-1FFB-400E-9E55-9E89A954D7B3}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:59:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99EAA439-5781-41A8-AC9B-70BC5DEAB0AE}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:54:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A5B4D6B-B8EF-4E5F-B743-AA9F4E0289D3}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:25:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B84A9D2-448F-4651-9DBC-19220A618871}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:17:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BC350B3-9CE7-4825-BB2B-33BFCD516FC8}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C045DFE-3891-418C-956E-3A5194E459A4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_at','global',255,'material','2025-01-21 13:21:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C6AA5CD-7CD3-46EF-ADEC-D85A1D86A884}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 13:01:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CCE2AA3-5132-4229-BFB6-7433FAB7FEF3}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:43:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D992CC0-489E-481C-B640-ACD8F335040D}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E835B1C-0054-4A06-8B42-D99C3667C791}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:25:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ED27B13-66B6-4F88-AE4A-8A7A4857E9B2}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FE1387-1032-49F8-8035-9D82DCFEFF84}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:22:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A11BBB5B-4A73-4E2A-A6FB-CFC047C7EE1E}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:17:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2E47E30-75C0-4C24-9FA5-0AC629E7264D}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:02:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2F862D8-81A7-41C2-B57D-2BC6CE01F3AA}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:50:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A33136B7-6DF1-483F-A416-AC920F9CB18E}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:28:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A39118BD-A20C-4093-A5C9-5DB9703B012E}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:16:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3D1300C-BDC1-4EE6-B16D-BC38715B84C5}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:32:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3EA0ECA-ACFE-42F8-BEF2-D370EC0030F9}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:08:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4E2CFDE-6808-4676-9F6E-3C1CCA3EE0E6}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:04:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4EC2644-B0C5-4540-926C-EA6ED42B5983}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:26:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B42B77-660C-476A-B1D4-B9C2FC6306F5}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:05:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5CD422B-3077-4F77-AD82-B8C780B37732}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5FD5C0F-7FFD-49D2-BBBF-214E5B63531A}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:39:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A611DAD1-6EF3-4EF7-AAA9-7A0941519333}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_at','global',255,'material','2025-01-21 13:20:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6E39608-E248-4F82-9794-C248C61DF97A}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:22:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7080459-9868-41B5-9D97-3660BA51B8F0}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 14:36:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A73400C2-DB7B-4542-8D3E-8AC7312B3755}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:56:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A79A9EB9-0F61-42AA-9072-94300C8E8D31}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:48:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7CA4264-50A9-4D8F-BFF1-636ECC67398E}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:23:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8B95938-7C89-486C-9B1D-8C9ECB8A1805}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:03:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9EB4F04-B492-4FE8-8ACD-7BBC24DD09CE}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA0FCDC1-4017-4745-BE85-50EC3D61B6AC}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:07:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA4790DD-4085-4C5E-A54F-68C60A954D77}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:55:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA85F24D-5CC1-48A7-BF69-B3AB0F30971E}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:01:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB29B77F-D255-49A5-8E29-235BA8E1DE5F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:27:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC365583-C36F-441C-9EE1-921167CF5A78}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:29:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC525EED-EE76-43C4-9563-89011E25CA98}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_at','global',255,'material','2025-01-21 14:40:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC5D448D-D7EE-40FC-9BDB-E8E7F4939746}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACE82C94-D38B-46D0-A3A1-86F79B287452}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:18:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD19FDBC-6B43-49D4-A97C-EF8822C4C63C}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:35:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD4017BB-BE59-44B5-B3FB-6555A4BB7C78}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:43:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF39A4F-A454-4196-90C8-503D4459B786}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_at','global',255,'material','2025-01-21 14:06:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF166FAA-7BD9-441D-9CBC-890E7B7C7FA5}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:23:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFCC74A6-15A1-4BA9-8176-2808391228D2}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:37:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFD4CB07-3FCA-47ED-8802-777A8CE23522}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:15:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B023EA49-F408-4BD2-9DAE-ED68EEDAA185}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:28:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1428FFC-6490-493D-974F-CFFD4AA9792A}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 14:18:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1D7C370-704C-4F44-9ADD-AD087F3EFAE4}','DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','de_at','global',255,'material','2025-01-21 13:56:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2827D17-4BE9-4D0E-8828-431CDB4C68A3}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:04:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B371EFD6-F3D1-48E3-A9A2-5CF13A05200F}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3CFBDC1-A153-4716-AF3D-C49BB4159D77}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:23:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3EE36D0-77D3-466B-80E1-56C5EBD788D7}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:41:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B46160CC-651B-4F36-9B9E-654617B9707B}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:38:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E9E5DD-7777-45BC-BC88-901DE1140E1E}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:07:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AF9423-0408-4103-8FFE-5E950896DEA2}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:55:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5FE1E24-7BFA-4B59-9BB6-D1A782E3FB38}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:25:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:30:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8AB0639-F900-4C70-88B0-C468B81D1A6A}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:13:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9268A79-566E-4922-9AC7-BF935D20D780}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:14:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9613779-1B9B-49A6-9756-6E6644705862}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9A96F18-8517-474E-BB50-B2E703DB3C5D}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:02:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB37673F-7932-42A4-8C9C-837AD457A8F7}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:51:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBC86339-D568-4069-9C31-016626F62E24}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 15:00:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCA4D010-58E4-40D6-88FA-BEFFA4DBB56B}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:53:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCB7B6EB-132B-42E1-A260-C5FED3618CCB}','DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}','de_at','global',255,'material','2025-01-21 14:00:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFC72B9B-6286-481E-B617-A60DCB72FDD6}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:40:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0ED7346-2040-4A89-97DF-F45E4DFD31C9}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:18:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C5B06A-DD2E-47C6-82A9-FA8D8C10AA47}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:12:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22BE2DE-3AA9-4D1D-A734-8A6C0C493F41}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 14:26:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C39BDFA1-55CE-4468-ABDA-5FFA1CF781CE}','DM-{E36AF328-BF56-4B7E-A511-6A4071E600AB}','de_at','global',255,'material','2025-01-21 14:25:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A1B8AA-2808-489E-915D-DC5E73EA0E57}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:02:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C54E958E-3205-4A9A-8CC6-F59A7FD48D0C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:56:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6B1EAFA-1D56-4E99-B329-1427A159FB64}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:22:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C767AE06-964A-4883-A923-E2D2B3AECEFB}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_at','global',255,'material','2025-01-21 14:04:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7BA5787-D74F-4FB2-ACC4-DA0F9BE9F610}','DM-{E36AF328-BF56-4B7E-A511-6A4071E600AB}','de_at','global',255,'material','2025-01-21 14:25:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7E512AD-4D86-4B24-8C01-B24B108208DA}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:35:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9FEDF3A-F477-4A40-B42B-BEB8F82824D3}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:05:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBCD2AB5-A3BF-443D-ADFB-772950B20F89}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBDFDBF0-3F70-4998-B5F3-3B516812FFCA}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:17:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC3C5AC2-D400-4255-9873-70752E98A33A}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_at','global',255,'material','2025-01-21 14:38:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CCA8C06E-4DC1-4AD3-8748-5EBF0F19E527}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:55:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDEB2534-8EB6-4EDF-8276-7FF15B588CDD}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CECCB58C-85EF-4738-957C-CFD9406189B1}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:06:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEDE3AC6-EF25-427A-B0B2-A953BD5DCE39}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:56:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF0A19FA-4586-4899-BAE5-4742E3334BE4}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:41:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0D6BB45-AC9A-45A8-9187-A09DEE2C61BC}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:54:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}','DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}','de_at','global',255,'material','2025-01-21 14:04:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D329FFB5-267C-4190-BBAC-0F948723A5E0}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:54:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4AD0C31-E704-4975-8765-E32739EF4A9D}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:10:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4E514C6-5AEC-44C6-8871-5C494F63716B}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:16:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D511756B-8654-4B0A-809E-AE11FC4C3D1F}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 12:51:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5194B1D-A3D4-4F1E-B46A-57E9DAB804FE}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:39:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D54B669E-FC58-465A-A6C3-A4058B0AAD13}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:02:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D61A0399-9BAE-4A90-B70A-FC3EB8AFDD3C}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:30:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63D069E-7309-4C02-A9BB-B0C6EA4109CD}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:37:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D687BA7D-C70F-4812-8EF3-89D0AD3D0564}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6C10AF3-49EB-4C4C-9FB1-066EAB0E48DC}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:18:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6D7E268-7471-4374-A453-CCB79AA34998}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:39:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D74C95DD-B621-42CD-931A-D880CB17E263}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:16:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D92E9257-4A62-4CC5-8B63-6F5201352322}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:51:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D420AD-CAA9-4D82-B011-F991BD336759}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:22:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA041090-18BC-4CF8-80DA-87D9AE5B4305}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:24:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA2E3849-1B94-4E18-969D-3C5C87D93797}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:33:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAC05403-DD8C-4F82-B45E-D6DFED9F11C6}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:04:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:24:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB24ED80-E7E0-4605-B355-94BBA69A0D80}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:55:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB28071D-34AC-4E9F-8A59-8A3E75A21F33}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:14:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAA3F05-2D98-45B9-AA43-D4DD49A8F47B}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:52:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 15:16:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3C0C84-7E79-430A-AEC8-67EF04CF145F}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:51:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3E5615-5004-46C4-86B8-AAD969409883}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_at','global',255,'material','2025-01-21 14:03:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC731B0B-C467-4367-9785-AC5579C11A62}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:12:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC76EDBF-504B-4EC2-8A05-12F885700F2F}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:59:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCB6DAF8-807D-4868-923F-347B50645B74}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:17:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDEA4183-BAA2-4058-9606-71A52364F0A3}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:02:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_at','global',255,'material','2025-01-21 14:21:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE30037E-2369-494B-B2BA-D6ED29B681DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_at','global',255,'material','2025-01-21 13:58:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE330FC6-694E-44DA-B1BC-B6846D3301DD}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:38:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E043215A-8E25-4AEB-9E44-0DD862E1E323}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_at','global',255,'material','2025-01-21 14:54:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09977FC-67BA-44C6-8D11-6542C0B611FB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:18:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09B925F-D8C2-424D-9DC9-8B7B6AD724D9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:32:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1008D2B-6D08-4FCE-8105-07EFAA59DF48}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:15:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E118B37C-EC1D-4186-864C-4006CC66E5D2}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:37:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E124A5A8-0939-4B24-A0DF-6589914173CC}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_at','global',255,'material','2025-01-21 14:03:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E23F8A51-D5CD-40D1-BC00-2EECC7D2A8AA}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:09:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E323AB1C-558C-4C25-B2E6-CF763B6FF7B1}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_at','global',255,'material','2025-01-21 13:19:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4606337-0F6B-4CE0-8233-CF3CEB9F7E0D}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:06:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5B84FBC-EFB2-48BF-9767-83C12810D232}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:08:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E612A5B2-C6F2-4975-821C-98D10C8FC41B}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_at','global',255,'material','2025-01-21 14:31:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E75B4BB8-BDBF-4F41-B6AC-F0D07D05C690}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:53:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E763BD5D-C41A-4277-B1DE-47224145E3E0}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:27:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E93F63A3-B2D4-42E0-AD6B-96112B44CF49}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_at','global',255,'material','2025-01-21 13:20:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E962EA34-CA7C-424D-88DE-95D58448132C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:04:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B137B6-05FD-4150-8249-3A9C151B71D9}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:10:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:16:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB2D5562-6638-4046-8E0A-1F68A720D52F}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:47:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB4FE04E-A4C6-4DD0-AC09-7319F652A76F}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:15:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC7E571E-B222-4EC3-B768-0961A0511F04}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:42:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC8F84F0-286B-4A91-8785-7623610AA18E}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:10:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECC6F39A-847B-44EA-B726-FEB04265F58C}','DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','de_at','global',255,'material','2025-01-21 14:23:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5D0950-A825-4CFB-9BD3-90B19461641E}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 14:36:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE275049-3EBF-4F8C-9A4E-3CA4C5A9C686}','DM-{768503DD-5BC1-4783-A623-45BCA81F49A7}','de_at','global',255,'material','2025-01-21 15:08:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EED52C2F-9592-4385-AE4D-9578315D1131}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:29:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F06DA951-B563-4F49-B459-BDABB046FB03}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:11:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F19974C8-16F2-4E20-BA8E-2D0145C03D9E}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:08:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F38A674E-2E3B-47A1-98FB-3393BDF480D8}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:45:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3C902BF-C28A-4EA3-A782-BA4357CEB466}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:04:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F41B45CC-D814-4539-81A9-19AD613A9A4D}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:47:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F440F262-54B6-4867-B5E2-A48CACC40C33}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 14:36:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F49F6B49-C534-47DC-98A2-187FF0F4A76F}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:07:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F56A6298-916C-4051-B239-1EAE2421C39F}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:23:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5CE4F94-782E-4536-97D2-5C08DBEE8ED7}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_at','global',255,'material','2025-01-21 14:12:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F61DB497-3BD5-4F6E-B810-6BF94D513D73}','DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','de_at','global',255,'material','2025-01-21 14:35:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F62148B0-1B81-4F5B-A301-5B9565CEA3E4}','DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','de_at','global',255,'material','2025-01-21 13:53:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68084C5-38EC-4619-8DF5-2C917A28DF83}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:09:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6BEDD69-7D88-41BD-A575-A3B737CA2509}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:07:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F74CADE4-2118-4182-B57B-B8FF3A55EDC1}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_at','global',255,'material','2025-01-21 14:15:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F775933E-1D3E-440D-8EF6-4A44E6B02683}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 14:41:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7993446-DF96-4771-B2DB-0DAE4C4F645A}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:24:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7DEFB80-4B6A-4DB8-A164-7934A8D70B96}','DM-{AA256F14-0866-466F-8228-E252D03E392F}','de_at','global',255,'material','2025-01-21 13:19:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F88BB350-04CF-4CE7-AC0B-90EDFEECF37E}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_at','global',255,'material','2025-01-21 14:27:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8A7DEE5-3559-41E2-BA29-E5D96A41DF55}','DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','de_at','global',255,'material','2025-01-21 13:27:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8B3EDFA-5A2C-4BB1-A6D5-858CB85DB8F8}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:39:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F94BDD00-67CF-48D5-B253-DEE3AC5B2A11}','DM-{6135E85C-B07E-4E0A-89F5-C3F3B4AB70E1}','de_at','global',255,'material','2025-01-21 15:01:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA218E55-967B-4915-9DC0-8179A355AA70}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_at','global',255,'material','2025-01-21 13:05:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC18A93C-A165-4DD5-97F6-6C905773DB8B}','DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','de_at','global',255,'material','2025-01-21 12:54:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCD9318A-A44A-4651-8B36-2C58593B8E83}','DM-{2B8CB640-630A-4041-8A8F-8FBE81BCAD24}','de_at','global',255,'material','2025-01-21 14:36:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCE05644-168E-4C92-A8E5-109452D0C23C}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:14:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD089977-55FB-4903-A94A-A157B9832E8B}','DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','de_at','global',255,'material','2025-01-21 14:45:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD800E23-71DB-4CBA-85BA-86B6530430AE}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_at','global',255,'material','2025-01-21 13:11:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD808C70-C14A-4562-92EF-A38EF363195A}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_at','global',255,'material','2025-01-21 14:19:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD8A58FD-9606-49AA-A057-A95DFC80C78F}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:35:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE06406D-E0EC-4FAA-A979-691FDA8E1DBE}','DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','de_at','global',255,'material','2025-01-21 13:37:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE0CB650-5385-41A5-8030-0238F6B45CCB}','DM-{58202D14-791D-40E0-BA7D-275BE5C6C0D5}','de_at','global',255,'material','2025-01-21 15:19:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE6E28D9-9A2D-4202-96BF-5C4C81FA7E6A}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_at','global',255,'material','2025-01-21 13:15:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEBF62AF-F328-4A1D-A878-A897034E977A}','DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','de_at','global',255,'material','2025-01-21 13:09:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF19B1D3-9EC2-4122-A700-4DA0EB09C72B}','DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','de_at','global',255,'material','2025-01-21 13:34:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{419795D5-265A-4EE6-B04B-7F95D4F3D9D6}', 'DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'global', '255', 'material', '2025-01-23 12:13:52'); -- PE-Folie -> Trennlage
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-01-28 09:34 -- de_ch -- global --
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0071598B-15A3-4E50-A335-A2483C496AD5}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0087C144-E873-4653-B3CD-48E8E1E8F2FC}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:49:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01BBE83E-C872-47FF-8093-57115B016248}','DM-{084BA81F-8754-4DE0-82AC-880F64F03293}','de_ch','global',255,'material','2025-01-27 14:18:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{021E1190-DA04-48A5-B656-1322B6705196}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{02894DC8-F7D6-4AE5-8F82-CB474A20A0F0}','DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}','de_ch','global',255,'material','2025-01-27 14:13:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0301E547-F442-4B54-85AC-0783919D9E6E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:42:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0303A666-CBB4-4A39-BEC5-9A0B6AF2FFDF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:40:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C7D990-53E7-4A2D-9A38-DFECB7838B01}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04FA3D29-7A94-4B08-9364-5AED9614F1C8}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 18:02:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{053BF56B-E3F1-4CFB-BA3F-1C2FE8CA14F2}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_ch','global',255,'material','2025-01-27 14:46:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EB0D32-D438-4E41-B5CD-54C94D7A4E1A}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06FFDC2D-167F-4A52-917F-1F34DDD14B4C}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 12:23:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{072B0962-355D-46DA-9921-DDD9904E3AFC}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0759AA9F-D741-432B-BF9E-4856FDB1D536}','DM-{77868A0D-D2C3-4B0A-9728-877A9FC66D49}','de_ch','global',255,'material','2025-01-27 15:37:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0865A54A-C9C9-4E59-87B9-3B2628D53B13}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0925B528-8522-49A0-9B53-EEA71CB30C69}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:11:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A5A17AA-FBE2-40D1-9117-5DAD3E6EE9F8}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AEBA150-A369-499F-A7E0-D7D0A3DE94E2}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:59:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2BA224-4CB1-4195-83F1-064148F2025E}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5667DE-B543-4622-8B78-647E11A4FD0C}','DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}','de_ch','global',255,'material','2025-01-27 15:19:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E3E86EC-B23F-4FDE-BA36-440AE9E10A9D}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ECDE985-4339-4321-9A65-FBC4DE9E21F0}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 17:07:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ED14911-C57E-40DF-A524-9CBEF1EE1E0E}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FCA57F8-A535-4CAE-8043-CEDA63BABD82}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FF35FE6-7792-4503-A92C-EC6288CFD689}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:51:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{114D715B-2B00-4BA4-A935-BC64D6A327BA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 15:01:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1150F312-A137-45EA-BEC0-95447C34CDA2}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1204D132-F428-4C43-81F4-F7468B886977}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{125CB03B-4DCF-4750-995E-27218B836006}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 13:53:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{129C23CA-866D-4B3F-8D90-6BEE8591B7AB}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 16:56:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13D9DE86-A75E-493F-9858-08D28262B75B}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{143045E7-6490-44C7-99F6-3F6280474C8B}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:00:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1471AB7C-6B27-4E89-A495-43106AEC0783}','DM-{8D9CDD63-1A58-4462-97D7-74DC97F2C72D}','de_ch','global',255,'material','2025-01-27 14:05:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14878589-AC28-48BE-B2E7-A6C16E277486}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 16:55:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{149F9FD9-FF02-4F59-AFAB-AB7EB31AECE8}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14B38291-E4A4-4CD6-A119-67E59232CD40}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14E43E27-EC29-4D30-9551-FA2521C549EB}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:11:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16DD0D52-AD64-4104-91AF-B020E3566B30}','DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}','de_ch','global',255,'material','2025-01-27 16:54:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18AB395D-53F7-4E4C-9B5E-FFFAE8E7C87B}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 18:11:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A4BADB7-5EC0-4C72-9D3D-3F9531E0B65C}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:13:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BC30DFD-2B2D-4D8C-AAF5-4F5CCA44FBE7}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C99070A-251A-4699-9785-6346DA2B7CE4}','DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}','de_ch','global',255,'material','2025-01-27 15:19:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CA5C230-B720-4CA9-9749-B4A9CF2DF020}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:45:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CB7D687-C625-4FCC-91D6-8358318103F4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D714135-EAAF-429C-BF5C-11B8ED973DAB}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:09:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F2B6CD4-5C3C-4929-B35D-610A63D0D58A}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_ch','global',255,'material','2025-01-27 15:23:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F5686A7-78B6-445C-84FC-29CDC7DE029A}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 15:42:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201FE7BC-320F-4B82-AC00-F7D8B315C7B6}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 12:46:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{209DC80F-F315-4618-8219-4D3B705C4423}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 14:32:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2235E068-40F1-4B30-B1F1-1E88BE82EE8E}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 16:59:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{230F3439-05DF-4317-BBCE-DAA3BEDB7038}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:44:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23C49DB1-1EC5-404E-B1CF-597C7EEAB234}','DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}','de_ch','global',255,'material','2025-01-27 16:54:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{241DE528-D03E-4E6A-A965-BB34F9169CFD}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253001AE-614E-43C5-BB35-AA191785AA91}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253B6D5A-1BF1-433D-B908-4A0364A621C0}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2555C259-BA6B-41DA-9183-603C9CF8ACFC}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25621FF8-BF53-4280-968B-00556BC57F3F}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2565AD1D-6160-41B8-AC97-C72B4F9D6969}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 14:21:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2571DA7B-AD18-48F2-9F5F-2AC5E612BBFA}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25AF8E8F-FC0F-4BFA-B609-0FE77D254E79}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B72455-5E95-43CD-8636-05B56548C96E}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2649424F-9988-4A12-8F6B-74933169212C}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:01:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{291C650B-9A8B-4CD3-B30E-C1F618BBFBD0}','DM-{8E0AB25A-F5FB-4ACA-93A5-B0E4A88917CB}','de_ch','global',255,'material','2025-01-27 16:47:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{297956B8-263E-452D-8104-B9DD399A5CC3}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:31:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29E896B3-665C-45B9-8BF5-9FE0C320E0D1}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 12:51:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A120080-40E6-49C1-A06F-D07FA284CFDC}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:46:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A19D51D-C386-43DD-B477-C4C3F5BC9D99}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:48:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B29E6C2-F65B-48C6-8EE3-946FBE59EE92}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B467DD3-E7AD-4458-9C1F-BC880AF184C0}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B701457-3A9C-4D28-90C1-2821D1BE29DA}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:41:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CBC45AF-CF3B-4760-B56C-A23423E7F326}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D6BC8ED-D9D4-4CA1-806E-9523965BF2CB}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D8BE6EA-9A3D-4958-9615-30A9030B57C9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DA360DB-59CD-4A50-83E8-61DF8247837B}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:11:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3245F0-9F80-4F63-B8F8-939CBF02D9AA}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F6F1739-14F4-42E5-9333-791817353751}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 16:44:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F8848A8-8B2F-4722-9CC8-108725A8C37C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 18:11:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FA145FF-F02B-432E-B5B5-2C76CF79E194}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3001C337-71A9-46C7-80E1-B8120C67376B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3090D571-3B41-46BF-9522-F0C8E2128529}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30D60592-599E-4BE8-8D1A-28D8F3859CF1}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:48:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31709897-80B0-4110-A56E-77CFD4B0840B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:33:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31D178A0-8F81-4915-A7BE-3F1F7B7432E2}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:49:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3267ADD8-D9D3-4C5C-BA37-887C16C6504C}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{332A0923-5807-440A-83FE-918A48C2582E}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:42:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338AE0A0-FC06-425B-81EB-77CBD6EAC70D}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:52:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338F78F4-99AF-48D7-96DB-51D4993F3C9B}','DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}','de_ch','global',255,'material','2025-01-27 16:54:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{343E6211-72C9-4556-B8BC-7980014FF4EC}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345D1773-77CA-4B04-B017-D3B49652B92E}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:02:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3483AEBF-B1F8-422A-8E88-5DADAC925789}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3556BDC5-C8BB-4793-95BD-308165793B37}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:11:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35659FF6-B868-4D54-B1E6-D1F07BCD049F}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_ch','global',255,'material','2025-01-27 14:40:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35C7B94D-CA6C-48ED-952A-B282B4BA2673}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:53:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35F80E9A-869E-4FCF-BFBC-D68231281552}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3916CB90-E296-4A5A-AC8F-F0B60CD6FBD8}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:10:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{393AE909-BCCB-47C8-AEDD-5407293A6840}','DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','de_ch','global',255,'material','2025-01-27 16:41:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39C410BB-2C4E-4F5D-9808-23571B9CD8EB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:20:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AA81746-338E-40E2-A2BF-4A1BFEE2ED63}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B37F528-C350-4160-A195-53899B4D01C5}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 16:57:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C332A67-84A0-4577-9D2F-B27B0AE6D93E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:46:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CAB62DC-0509-4E7F-8BD2-838036E4DDE5}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DAC9A5A-B27B-43A0-9336-CBF07A76BF6A}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 14:29:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E108672-7248-42CD-A0B8-0970E3B08809}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E18CCC5-9902-4516-BB66-DFD21CA94C87}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FE92E47-E3CC-4F73-BD2D-11F7E1BF553D}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 17:09:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40501B63-59EE-4DF5-9F43-9B6AA0FA624C}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 16:46:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 16:47:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40B11739-37B2-41AA-A4C3-2C0E131BACE7}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4164EA41-A33A-4167-AB7E-92AFA8F128D3}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:43:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{419795D5-265A-4EE6-B04B-7F95D4F3D9D6}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AABD05-7051-4CE4-897E-AB730417F1AD}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 16:38:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4257630E-4A37-43D0-8F85-AC82D371D426}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42D71C90-E15D-49D1-AADA-FFBF5F42FE16}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{445EED45-8D0C-4429-A418-531B391CC656}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{446162F5-FB3F-4486-AFC6-ED898FC079E7}','DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}','de_ch','global',255,'material','2025-01-27 15:02:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B323C2-A99A-4C86-8BE4-564121501153}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:43:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B9820E-17AB-4FAE-B9FD-74DBFE884CAB}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45F7F179-3AE9-4F45-94AF-22B9458043BF}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{461AFBA3-CB2F-4A38-9544-9FE8C7B1CEFF}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4685D8C6-A669-4DA0-A29B-0118F9778337}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:20:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{471A22AB-BF17-4531-8FCB-B7FACAD63F69}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 15:34:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{472446CB-2673-44EC-8F63-7DEC34BD731D}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47AB55D5-DD5F-4459-9FBC-88D043125EEB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4844FF4D-17D2-4FB6-8195-784EF9AAE1B6}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}','DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}','de_ch','global',255,'material','2025-01-27 13:59:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48CB7CFD-7722-4D21-A206-B1E51623339A}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ECAB8D-4C00-42E1-8964-A0EBF4A03857}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{491D74AD-1139-41DB-8F37-D1B7D77B8F87}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:11:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49C4FACE-72F4-4E88-8DD3-C83A430E9218}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2C3CBA-CF19-4BDB-9A2A-E0D5E6601DAC}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A49EA5C-BC01-4454-85CD-14639EF6EB45}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AF082B1-EA21-4E72-97D4-FE14099F1906}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B7DAA06-5201-4EC8-B9EE-5EDE0C6D0375}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:20:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BBFA414-77A7-4D50-A32C-38807BE08CC9}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C451960-1EB3-41D6-8B4A-2BB7F699BAD4}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D39DA7A-82C6-435F-94E7-A6761514CCCB}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_ch','global',255,'material','2025-01-27 15:33:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D3FA9E5-BDF9-447E-86A5-89B9607D8C3E}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:13:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D66518C-E043-421E-9A29-25F87E1E959B}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D73F2EE-59E2-496A-8ACE-C23DC481EEB5}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DE79FD5-E185-421C-9C36-A5567CA64525}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA3C08F-AC4A-4DA4-B6BD-C52564E21C2D}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:53:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF4C714-1A45-441D-950D-83DC9E080806}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 16:38:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5038E65B-08D1-4C27-8911-81069EBBED8F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50981DAD-7BFA-4BCC-8AB8-0D998DA8AE04}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51DEE2CD-3282-4250-B2EA-12E7B9E5F71F}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52028111-6F23-4555-98C4-79E565009A02}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{520F1261-05D6-4C15-AD0B-83C0596B8798}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:42:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52C695FB-0503-40F9-A861-D2288979C701}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{533C1ABC-33A4-40ED-A226-5EB05A405DD8}','DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}','de_ch','global',255,'material','2025-01-27 14:13:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53FDE63B-9534-4FE6-A4D5-592E74DA36F4}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54236FE2-5C14-4653-B991-4437F05E43BE}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551FD34A-F3BD-45B2-B29F-D9AFF7A5BC74}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5520DB60-0FCC-4750-ADA1-E95DDB876756}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5542832A-4AED-4801-8044-CB2013B3A3E0}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{563F3B68-1748-43C5-B638-0B3D7CF2BF62}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{567CCF42-21C7-4FD6-85BD-DAE8D52C7BA9}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:25:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}','DM-{A8B67552-F7BE-40D4-A460-A3D99EDDD773}','de_ch','global',255,'material','2025-01-27 14:16:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{583B4073-AB7D-477E-974A-AF7E809C547B}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:20:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{585CD8D4-0C33-4645-9724-CEA76CEE7EB6}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B62C2E-037F-413C-8AD5-31881D7F6F48}','DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','de_ch','global',255,'material','2025-01-27 16:41:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59A14B9F-DBF8-41BC-87FC-DDE93839DA07}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 16:35:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AFA4179-D904-4798-B0FC-C5784CAF1DA8}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B2D677A-920D-422F-8E7A-12E4DAFC09A8}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:38:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C0DF7FE-D87C-4116-A08C-4AACB93D289C}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB0B2C0-780F-484C-80CC-79F873965516}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB320B3-DA76-40E5-9595-B220E2C6B0FC}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:49:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E336947-1AE4-42FF-92D7-07F56B85EF66}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E5E70EE-2EA6-4F27-A225-DB86B337E75A}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:11:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F7A8ACF-1C44-46C8-B2CF-60E5BD79C51A}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:26:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FE606D8-0495-465E-BA6D-4FB02BBFB8BC}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_ch','global',255,'material','2025-01-27 14:30:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6032F2EF-CFEE-4A74-BCE8-D50296D080B7}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:46:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60454BC5-FFFB-45EB-9490-F30B302AA734}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609AC8F6-FCFE-4F38-846B-56AEEE6845E0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 12:10:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C8728E-5711-4117-B619-61428FCFBA6E}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 16:35:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61A15942-5FFF-41F0-9A9A-52D6AA6FB5FD}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:25:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62D18FB1-526E-4D71-831A-7B00BB6FFB5B}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 16:43:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{636C649D-3677-45B0-9CCC-E651B8D6F107}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_ch','global',255,'material','2025-01-27 18:01:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{639C4733-C6F9-485F-9770-DD0F41335BAB}','DM-{A8B67552-F7BE-40D4-A460-A3D99EDDD773}','de_ch','global',255,'material','2025-01-27 14:16:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64406BD1-95FC-4E99-884E-D8351C47AF99}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 15:03:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64CEED94-8536-490C-8BBC-9011736A34F7}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 18:00:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65FF2BC2-3A47-4778-949C-A89CD7EDDB38}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6682226D-0B08-4C35-9B28-7C50C5389A14}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:05:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{678C169D-B56C-477B-8B62-DBB072B5487E}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68B1034C-2F06-426A-BBA5-34EB1CC11E5A}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68D1F59E-18A0-458A-BA82-9191BAF8B647}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6989478E-8B86-419B-B086-48F87549B194}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:11:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A5650B8-21DA-4969-99F2-F9D4638FEF51}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:44:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A772FB0-896B-4BC7-933F-51C884A11C0D}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 14:29:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}','DM-{D97AE1E8-AAD0-43B6-B29D-31364B71589A}','de_ch','global',255,'material','2025-01-27 14:03:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AFE65A5-ED5B-4BEF-B88B-1F496798485A}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BE7175C-2FD3-4C64-A3F0-9902666338FA}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C39864D-2892-4A9E-BE3E-95398FD26156}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}','DM-{084BA81F-8754-4DE0-82AC-880F64F03293}','de_ch','global',255,'material','2025-01-27 14:17:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D10C998-8690-404C-8A1C-FB2C79ACEF01}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:48:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DB4D983-7C1D-4635-B81C-8F05DB27D7E1}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DC76042-BF36-4735-A766-0DBE9D7C7C2F}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DEFE768-215F-4837-AFF9-451315801959}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:36:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E904830-E8D9-4E0C-948F-7674475CD49D}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 16:45:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6ED12D39-7307-4B7C-95E5-EBAC9FB21BEE}','DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}','de_ch','global',255,'material','2025-01-27 17:08:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F06C7AE-52C6-4B3B-944D-2ABFC8B4C2F0}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:44:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F80ED60-7902-443A-8904-8E9744E9D378}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 10:43:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC921A-8552-4B95-8770-92812B0516D9}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 12:53:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FBCAF5-0686-4317-9750-748A8143F704}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 15:35:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7112CEB4-C1BC-4799-A545-4F93ED55F96C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71E0B550-D0AE-4A3F-A573-C4EDCAE57D97}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 17:10:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71EC64B5-D0A7-4905-832C-225045D93C08}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 17:09:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71FAC7F9-C184-4378-AD08-21C49F3718FF}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72588056-5804-460D-9C63-320B4B699879}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:51:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72B7C6B9-163B-43D6-A0A5-C3E2A1735C94}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E4570E-9344-487F-B73C-2F8EC7CF96E9}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74213C7E-2F47-406B-B4B4-09769868CE4A}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74B3A49D-C985-4579-A6C2-0D14F720C847}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 17:07:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{758BEC58-62EA-49DA-B9A2-F0A99C331153}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75D16018-9787-4750-B3CB-B7FBCE87027D}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{768F7C16-B435-4DDB-AAD4-4686510A7DC3}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76CA8E8B-5C42-47A4-ACD7-B49D919CF9DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FF5BC-C2DB-4795-ADA4-6849FB61B1DE}','DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','de_ch','global',255,'material','2025-01-27 16:41:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{779D8106-0E63-49DE-BFF9-954FC4EB82B5}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7861717E-13DA-4305-8DBB-A63E5ADB6055}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:38:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78E8AC1D-FF9B-43F2-8467-3B62FA429688}','DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}','de_ch','global',255,'material','2025-01-27 13:59:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7905A39F-DE8B-42C7-9513-719D2F56BE61}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79ABACA6-65F3-4E8C-AB86-AE2103206224}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 16:55:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A464856-1A9A-4ACD-B727-BFDE8FDBE45C}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:59:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7AADE7C8-1DB2-45AC-B380-1CAF5CD427E7}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:05:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ABD6DD9-13E8-40E8-82FD-6AE5391E4F69}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:50');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADB1C34-D3A6-475E-A2C4-27155C3BCD8E}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 16:58:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B1100B8-85A7-4ECD-A74E-EF81F44F0FEE}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CCC4D83-82ED-4086-842B-99DFD8A3A10B}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EA5052C-446A-4D4E-A8DC-5C9D2F014F14}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:22:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F910534-B4FB-40F7-B609-DC34AE9F6292}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80028D4B-9D90-4E3A-96F8-C1A6825D21A4}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803BCB4F-86A2-489E-AF7A-1EFF535F7A1C}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80F37F2B-3C2D-4F1D-92D3-B720988F5488}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 16:58:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8105275E-CD7F-4AC8-BD76-C5DBF62D84C5}','DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}','de_ch','global',255,'material','2025-01-27 14:49:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81D6B700-E328-4DF9-AACB-3A5DC32468CE}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:53:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81DC2B42-4B9F-4139-AA03-B819B8CA1F97}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:31:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82D09EA7-2C80-455F-BCCC-FE5C06E6D33A}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:44:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82FAB99F-2B3E-4447-A8F4-A0C1B156C612}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 18:08:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}','DM-{7E758803-10B3-412A-8968-93E05D86E7F8}','de_ch','global',255,'material','2025-01-27 14:13:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85841BF7-716C-4BA6-83BB-7E3804D9BF31}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{866AFAA2-3A42-453E-BE38-6FE3A6F29D84}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 16:35:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA5A97-5BE3-44AE-845D-CF1CA195EFE1}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88F2B27A-0856-4714-8E0B-92E7EEA75726}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{894FC435-DDFD-43DF-8E35-2B8D5D45BFD6}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A3D6102-7A38-4C3E-B3E4-19F2C234F2B0}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B3D72F8-CA5C-4350-BCAA-972C10BFBAD6}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C813C80-92FB-4A59-A4D3-491631E7C58B}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_ch','global',255,'material','2025-01-27 14:40:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E1DC2E2-16A4-4A15-AA32-FBA8EB30DFFF}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:34:43');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E501A4C-6271-46F2-8D15-E63DB914C168}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 12:12:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E6CB485-781E-44D3-AA54-0F153FA075E1}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:52:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{910AE78E-E3F8-4522-AE34-F3A52A43F6B2}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 12:51:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9215EB28-7A78-434D-B4BE-928963FB8044}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 17:10:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{924FDE12-5283-4B25-8511-05302950202A}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93220622-69DF-43FD-B822-E492256687A8}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E60701-0351-4D85-A56C-B9D854423EB0}','DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','de_ch','global',255,'material','2025-01-27 16:41:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:13:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{954226D6-0A78-42C5-A387-18EADE6AC2E7}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 14:29:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}','DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}','de_ch','global',255,'material','2025-01-27 15:19:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96DC5B54-9BE1-4D83-864B-B2123638C7ED}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:35');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97301D60-40C9-4B64-AD75-162554953672}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 16:55:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{987B2F8B-6BB7-44CD-BCCC-445D40913C09}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 16:59:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98F9ED0E-1FFB-400E-9E55-9E89A954D7B3}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99EAA439-5781-41A8-AC9B-70BC5DEAB0AE}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 12:38:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A5B4D6B-B8EF-4E5F-B743-AA9F4E0289D3}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:28:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AE4552F-F747-43A0-B9DB-0D8B8C5F08DF}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B84A9D2-448F-4651-9DBC-19220A618871}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BC350B3-9CE7-4825-BB2B-33BFCD516FC8}','DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}','de_ch','global',255,'material','2025-01-27 16:40:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C045DFE-3891-418C-956E-3A5194E459A4}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C4C53FC-3666-4DD9-B8A3-55F81A259925}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 18:02:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C6AA5CD-7CD3-46EF-ADEC-D85A1D86A884}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CCE2AA3-5132-4229-BFB6-7433FAB7FEF3}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CD4785A-12C4-4D56-BA0E-4E9541897A13}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D992CC0-489E-481C-B640-ACD8F335040D}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:48:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E835B1C-0054-4A06-8B42-D99C3667C791}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:28:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ED27B13-66B6-4F88-AE4A-8A7A4857E9B2}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}','DM-{E45F9E4A-830B-4C64-9AD4-7DDF4D647259}','de_ch','global',255,'material','2025-01-27 14:06:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 18:09:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FE1387-1032-49F8-8035-9D82DCFEFF84}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:34:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A11BBB5B-4A73-4E2A-A6FB-CFC047C7EE1E}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 17:09:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2F862D8-81A7-41C2-B57D-2BC6CE01F3AA}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3D1300C-BDC1-4EE6-B16D-BC38715B84C5}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3EA0ECA-ACFE-42F8-BEF2-D370EC0030F9}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:43:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4E2CFDE-6808-4676-9F6E-3C1CCA3EE0E6}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4EC2644-B0C5-4540-926C-EA6ED42B5983}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B42B77-660C-476A-B1D4-B9C2FC6306F5}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5CD422B-3077-4F77-AD82-B8C780B37732}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5FD5C0F-7FFD-49D2-BBBF-214E5B63531A}','DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}','de_ch','global',255,'material','2025-01-27 13:59:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A611DAD1-6EF3-4EF7-AAA9-7A0941519333}','DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}','de_ch','global',255,'material','2025-01-27 12:43:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6E39608-E248-4F82-9794-C248C61DF97A}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 15:44:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7080459-9868-41B5-9D97-3660BA51B8F0}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A73400C2-DB7B-4542-8D3E-8AC7312B3755}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A79A9EB9-0F61-42AA-9072-94300C8E8D31}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 10:52:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7CA4264-50A9-4D8F-BFF1-636ECC67398E}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9EB4F04-B492-4FE8-8ACD-7BBC24DD09CE}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:11:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA0FCDC1-4017-4745-BE85-50EC3D61B6AC}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:43:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA1330F9-1FD5-4168-A90B-F6237DECF550}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}','DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}','de_ch','global',255,'material','2025-01-27 12:37:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA278F00-FD96-47B3-A6F8-8A3FDAB6DCA8}','DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}','de_ch','global',255,'material','2025-01-27 14:13:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA4790DD-4085-4C5E-A54F-68C60A954D77}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB29B77F-D255-49A5-8E29-235BA8E1DE5F}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:31:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC365583-C36F-441C-9EE1-921167CF5A78}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:54:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC525EED-EE76-43C4-9563-89011E25CA98}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 17:10:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC5D448D-D7EE-40FC-9BDB-E8E7F4939746}','DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}','de_ch','global',255,'material','2025-01-27 16:54:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD4017BB-BE59-44B5-B3FB-6555A4BB7C78}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:51:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF39A4F-A454-4196-90C8-503D4459B786}','DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}','de_ch','global',255,'material','2025-01-27 14:42:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF166FAA-7BD9-441D-9CBC-890E7B7C7FA5}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:26:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF220C79-A9F3-4EC7-805A-3D4A0315D388}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:28');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF89323E-B0D9-47F2-94EE-8074EC19C131}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFCC74A6-15A1-4BA9-8176-2808391228D2}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFD4CB07-3FCA-47ED-8802-777A8CE23522}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 13:53:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B023EA49-F408-4BD2-9DAE-ED68EEDAA185}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:31:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1428FFC-6490-493D-974F-CFFD4AA9792A}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1D7C370-704C-4F44-9ADD-AD087F3EFAE4}','DM-{1E9D6AD1-9D63-498E-8B16-73AE7E79B2F7}','de_ch','global',255,'material','2025-01-27 14:27:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2827D17-4BE9-4D0E-8828-431CDB4C68A3}','DM-{DEFF40D1-0075-4E88-9718-547D4C164375}','de_ch','global',255,'material','2025-01-27 17:08:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B371EFD6-F3D1-48E3-A9A2-5CF13A05200F}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:53:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3CFBDC1-A153-4716-AF3D-C49BB4159D77}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3EE36D0-77D3-466B-80E1-56C5EBD788D7}','DM-{084BA81F-8754-4DE0-82AC-880F64F03293}','de_ch','global',255,'material','2025-01-27 14:17:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B46160CC-651B-4F36-9B9E-654617B9707B}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:54:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E9E5DD-7777-45BC-BC88-901DE1140E1E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AF9423-0408-4103-8FFE-5E950896DEA2}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:39:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5FE1E24-7BFA-4B59-9BB6-D1A782E3FB38}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8AB0639-F900-4C70-88B0-C468B81D1A6A}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 16:45:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9268A79-566E-4922-9AC7-BF935D20D780}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:20:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9613779-1B9B-49A6-9756-6E6644705862}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB37673F-7932-42A4-8C9C-837AD457A8F7}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBC86339-D568-4069-9C31-016626F62E24}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCA4D010-58E4-40D6-88FA-BEFFA4DBB56B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:45:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCB7B6EB-132B-42E1-A260-C5FED3618CCB}','DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}','de_ch','global',255,'material','2025-01-27 18:06:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFC72B9B-6286-481E-B617-A60DCB72FDD6}','DM-{7E758803-10B3-412A-8968-93E05D86E7F8}','de_ch','global',255,'material','2025-01-27 14:09:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C5B06A-DD2E-47C6-82A9-FA8D8C10AA47}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22BE2DE-3AA9-4D1D-A734-8A6C0C493F41}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 16:47:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:48:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2A935F0-2BBC-462B-9D8A-E275F9BF3956}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C369DA26-6ED4-4C90-A3C6-7B0ADF9DB351}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:24');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C39BDFA1-55CE-4468-ABDA-5FFA1CF781CE}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:17');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C54E958E-3205-4A9A-8CC6-F59A7FD48D0C}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 14:39:07');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6B1EAFA-1D56-4E99-B329-1427A159FB64}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:34:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C767AE06-964A-4883-A923-E2D2B3AECEFB}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_ch','global',255,'material','2025-01-27 18:01:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7BA5787-D74F-4FB2-ACC4-DA0F9BE9F610}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7E512AD-4D86-4B24-8C01-B24B108208DA}','DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}','de_ch','global',255,'material','2025-01-27 14:13:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9FEDF3A-F477-4A40-B42B-BEB8F82824D3}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB311F3C-4272-4A79-AFA6-61ACC4F6186D}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBCD2AB5-A3BF-443D-ADFB-772950B20F89}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBDFDBF0-3F70-4998-B5F3-3B516812FFCA}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC3C5AC2-D400-4255-9873-70752E98A33A}','DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}','de_ch','global',255,'material','2025-01-27 15:22:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC917823-C809-4788-80AE-10B5A3419747}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:35:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CCA8C06E-4DC1-4AD3-8748-5EBF0F19E527}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}','DM-{FD24AFDF-9D56-4956-9FDA-C616360E9C0E}','de_ch','global',255,'material','2025-01-27 14:45:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDEB2534-8EB6-4EDF-8276-7FF15B588CDD}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 16:53:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEDE3AC6-EF25-427A-B0B2-A953BD5DCE39}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF0A19FA-4586-4899-BAE5-4742E3334BE4}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 12:11:14');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF8E7AF2-BD73-46E6-8B19-7F403B53F35D}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 17:06:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0D6BB45-AC9A-45A8-9187-A09DEE2C61BC}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:39');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}','DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}','de_ch','global',255,'material','2025-01-27 14:49:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1ED221D-E26C-4FC3-8200-A1441FEE3A70}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D329FFB5-267C-4190-BBAC-0F948723A5E0}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 12:38:02');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4AD0C31-E704-4975-8765-E32739EF4A9D}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4E514C6-5AEC-44C6-8871-5C494F63716B}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D511756B-8654-4B0A-809E-AE11FC4C3D1F}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:09:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5194B1D-A3D4-4F1E-B46A-57E9DAB804FE}','DM-{7E758803-10B3-412A-8968-93E05D86E7F8}','de_ch','global',255,'material','2025-01-27 14:09:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D529C3DF-FA1F-4D21-B1BA-6124CA41CB5B}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D54B669E-FC58-465A-A6C3-A4058B0AAD13}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 16:56:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D61A0399-9BAE-4A90-B70A-FC3EB8AFDD3C}','DM-{61220357-111E-4D88-B413-5A81F26A26B9}','de_ch','global',255,'material','2025-01-27 12:19:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6282B63-6ADB-4783-98A3-9FE17E531106}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:25:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63D069E-7309-4C02-A9BB-B0C6EA4109CD}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:56:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D687BA7D-C70F-4812-8EF3-89D0AD3D0564}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6C10AF3-49EB-4C4C-9FB1-066EAB0E48DC}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6D7E268-7471-4374-A453-CCB79AA34998}','DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}','de_ch','global',255,'material','2025-01-27 13:59:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7531F70-FB95-4DCD-86AA-3771AE309CBB}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D92E9257-4A62-4CC5-8B63-6F5201352322}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D420AD-CAA9-4D82-B011-F991BD336759}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA041090-18BC-4CF8-80DA-87D9AE5B4305}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA2E3849-1B94-4E18-969D-3C5C87D93797}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:26:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB24ED80-E7E0-4605-B355-94BBA69A0D80}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAA3F05-2D98-45B9-AA43-D4DD49A8F47B}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3C0C84-7E79-430A-AEC8-67EF04CF145F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:22');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3E5615-5004-46C4-86B8-AAD969409883}','DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}','de_ch','global',255,'material','2025-01-27 14:30:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC502D3B-298D-4C74-864B-BD1513EBD106}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 18:05:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC731B0B-C467-4367-9785-AC5579C11A62}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:09:34');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC76EDBF-504B-4EC2-8A05-12F885700F2F}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCB6DAF8-807D-4868-923F-347B50645B74}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 17:09:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:25:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:34:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE30037E-2369-494B-B2BA-D6ED29B681DD}','DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}','de_ch','global',255,'material','2025-01-27 14:24:23');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE330FC6-694E-44DA-B1BC-B6846D3301DD}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:56');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 12:27:32');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E043215A-8E25-4AEB-9E44-0DD862E1E323}','DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}','de_ch','global',255,'material','2025-01-27 12:53:15');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09B925F-D8C2-424D-9DC9-8B7B6AD724D9}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1008D2B-6D08-4FCE-8105-07EFAA59DF48}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:33:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E118B37C-EC1D-4186-864C-4006CC66E5D2}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E124A5A8-0939-4B24-A0DF-6589914173CC}','DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}','de_ch','global',255,'material','2025-01-27 17:02:12');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E36AF328-BF56-4B7E-A511-6A4071E600AB}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:13:59');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4EF9232-04EC-42F3-8F11-F48EE7B864E6}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:14:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5658C54-1349-4825-B76B-90166654E27E}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:21');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E612A5B2-C6F2-4975-821C-98D10C8FC41B}','DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}','de_ch','global',255,'material','2025-01-27 15:39:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E75B4BB8-BDBF-4F41-B6AC-F0D07D05C690}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E763BD5D-C41A-4277-B1DE-47224145E3E0}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:31:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E93F63A3-B2D4-42E0-AD6B-96112B44CF49}','DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}','de_ch','global',255,'material','2025-01-27 12:49:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E962EA34-CA7C-424D-88DE-95D58448132C}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:30:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B137B6-05FD-4150-8249-3A9C151B71D9}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB2D5562-6638-4046-8E0A-1F68A720D52F}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB4FE04E-A4C6-4DD0-AC09-7319F652A76F}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:33:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC7E571E-B222-4EC3-B768-0961A0511F04}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:50:00');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC8F84F0-286B-4A91-8785-7623610AA18E}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:27');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5D0950-A825-4CFB-9BD3-90B19461641E}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED820211-7AE4-4959-A5BC-839A663653CB}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:14:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F06DA951-B563-4F49-B459-BDABB046FB03}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 15:05:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F19974C8-16F2-4E20-BA8E-2D0145C03D9E}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BD74C5-74F3-4684-AC8F-F1271A54352E}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 13:57:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F312D21C-5B13-4202-97FB-1935E0BE8E49}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:14:13');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F38A674E-2E3B-47A1-98FB-3393BDF480D8}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:08:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F41B45CC-D814-4539-81A9-19AD613A9A4D}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:47');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4391BE4-3DBA-40E4-A244-2C3C716D32CA}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 13:50:11');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F440F262-54B6-4867-B5E2-A48CACC40C33}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F49F6B49-C534-47DC-98A2-187FF0F4A76F}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:26');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F56A6298-916C-4051-B239-1EAE2421C39F}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:16');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5CE4F94-782E-4536-97D2-5C08DBEE8ED7}','DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}','de_ch','global',255,'material','2025-01-27 16:45:57');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F62148B0-1B81-4F5B-A301-5B9565CEA3E4}','DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}','de_ch','global',255,'material','2025-01-27 17:07:01');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68084C5-38EC-4619-8DF5-2C917A28DF83}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:52');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:10');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6BEDD69-7D88-41BD-A575-A3B737CA2509}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6EB081D-E1E9-4F24-8EDB-920B10332EBA}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 17:13:30');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F74CADE4-2118-4182-B57B-B8FF3A55EDC1}','DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}','de_ch','global',255,'material','2025-01-27 15:41:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F775933E-1D3E-440D-8EF6-4A44E6B02683}','DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}','de_ch','global',255,'material','2025-01-27 16:49:55');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7993446-DF96-4771-B2DB-0DAE4C4F645A}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 13:47:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7DEFB80-4B6A-4DB8-A164-7934A8D70B96}','DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}','de_ch','global',255,'material','2025-01-27 14:50:51');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F88BB350-04CF-4CE7-AC0B-90EDFEECF37E}','DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}','de_ch','global',255,'material','2025-01-27 16:54:03');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8A7DEE5-3559-41E2-BA29-E5D96A41DF55}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 14:31:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8B3EDFA-5A2C-4BB1-A6D5-858CB85DB8F8}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 14:07:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F98501D0-38F6-4341-99DE-AF798F2CF1D9}','DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}','de_ch','global',255,'material','2025-01-27 17:14:06');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC18A93C-A165-4DD5-97F6-6C905773DB8B}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 12:29:41');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC3A9A8D-4AB8-4542-9BDB-E49C90199BBA}','DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}','de_ch','global',255,'material','2025-01-27 17:59:54');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCC4ABE8-0D0B-4173-8CDA-5B0D0312FBEA}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:25');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCD9318A-A44A-4651-8B36-2C58593B8E83}','DM-{154865CF-D3B8-4A84-A79C-B08982857291}','de_ch','global',255,'material','2025-01-27 17:04:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD089977-55FB-4903-A94A-A157B9832E8B}','DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}','de_ch','global',255,'material','2025-01-27 11:09:18');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD752C8C-BCF1-4CBD-B3BF-499F44203DE2}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:47:33');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD800E23-71DB-4CBA-85BA-86B6530430AE}','DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}','de_ch','global',255,'material','2025-01-27 13:51:42');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD808C70-C14A-4562-92EF-A38EF363195A}','DM-{316A773B-97FD-4230-9C51-08065B16A225}','de_ch','global',255,'material','2025-01-27 14:40:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD8A58FD-9606-49AA-A057-A95DFC80C78F}','DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}','de_ch','global',255,'material','2025-01-27 14:13:19');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE06406D-E0EC-4FAA-A979-691FDA8E1DBE}','DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}','de_ch','global',255,'material','2025-01-27 12:12:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE0CB650-5385-41A5-8030-0238F6B45CCB}','DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}','de_ch','global',255,'material','2025-01-27 18:06:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE6E28D9-9A2D-4202-96BF-5C4C81FA7E6A}','DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}','de_ch','global',255,'material','2025-01-27 14:33:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEBF62AF-F328-4A1D-A878-A897034E977A}','DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}','de_ch','global',255,'material','2025-01-27 12:34:58');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF19B1D3-9EC2-4122-A700-4DA0EB09C72B}','DM-{E45F9E4A-830B-4C64-9AD4-7DDF4D647259}','de_ch','global',255,'material','2025-01-27 14:06:05');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF4EC6A2-318A-47E4-B131-88D86A0ACC30}','DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}','de_ch','global',255,'material','2025-01-27 12:15:41');
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-01-28 11:47 -- de_at -- de_de -- global --
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C7D990-53E7-4A2D-9A38-DFECB7838B01}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C7D990-53E7-4A2D-9A38-DFECB7838B01}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1204D132-F428-4C43-81F4-F7468B886977}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1204D132-F428-4C43-81F4-F7468B886977}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14E43E27-EC29-4D30-9551-FA2521C549EB}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14E43E27-EC29-4D30-9551-FA2521C549EB}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C99070A-251A-4699-9785-6346DA2B7CE4}','DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C99070A-251A-4699-9785-6346DA2B7CE4}','DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F2B6CD4-5C3C-4929-B35D-610A63D0D58A}','DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F2B6CD4-5C3C-4929-B35D-610A63D0D58A}','DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B72455-5E95-43CD-8636-05B56548C96E}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B72455-5E95-43CD-8636-05B56548C96E}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DA360DB-59CD-4A50-83E8-61DF8247837B}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DA360DB-59CD-4A50-83E8-61DF8247837B}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3556BDC5-C8BB-4793-95BD-308165793B37}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3556BDC5-C8BB-4793-95BD-308165793B37}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BBFA414-77A7-4D50-A32C-38807BE08CC9}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BBFA414-77A7-4D50-A32C-38807BE08CC9}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50981DAD-7BFA-4BCC-8AB8-0D998DA8AE04}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50981DAD-7BFA-4BCC-8AB8-0D998DA8AE04}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53FDE63B-9534-4FE6-A4D5-592E74DA36F4}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53FDE63B-9534-4FE6-A4D5-592E74DA36F4}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59A14B9F-DBF8-41BC-87FC-DDE93839DA07}','DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59A14B9F-DBF8-41BC-87FC-DDE93839DA07}','DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64CEED94-8536-490C-8BBC-9011736A34F7}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64CEED94-8536-490C-8BBC-9011736A34F7}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68B1034C-2F06-426A-BBA5-34EB1CC11E5A}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68B1034C-2F06-426A-BBA5-34EB1CC11E5A}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6989478E-8B86-419B-B086-48F87549B194}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6989478E-8B86-419B-B086-48F87549B194}','DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{866AFAA2-3A42-453E-BE38-6FE3A6F29D84}','DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{866AFAA2-3A42-453E-BE38-6FE3A6F29D84}','DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88F2B27A-0856-4714-8E0B-92E7EEA75726}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88F2B27A-0856-4714-8E0B-92E7EEA75726}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CD4785A-12C4-4D56-BA0E-4E9541897A13}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CD4785A-12C4-4D56-BA0E-4E9541897A13}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA1330F9-1FD5-4168-A90B-F6237DECF550}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA1330F9-1FD5-4168-A90B-F6237DECF550}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2A935F0-2BBC-462B-9D8A-E275F9BF3956}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2A935F0-2BBC-462B-9D8A-E275F9BF3956}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5658C54-1349-4825-B76B-90166654E27E}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5658C54-1349-4825-B76B-90166654E27E}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC3A9A8D-4AB8-4542-9BDB-E49C90199BBA}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC3A9A8D-4AB8-4542-9BDB-E49C90199BBA}','DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCC4ABE8-0D0B-4173-8CDA-5B0D0312FBEA}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCC4ABE8-0D0B-4173-8CDA-5B0D0312FBEA}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF4EC6A2-318A-47E4-B131-88D86A0ACC30}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_at','global',255,'material','2025-01-28 10:32:38');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF4EC6A2-318A-47E4-B131-88D86A0ACC30}','DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}','de_de','global',255,'material','2025-01-28 10:45:36');
-- values (en_uk)
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{00DFC14A-F241-4FD2-A562-68665ED24EE4}','DM-{AC15DFEE-0509-44FC-BC8F-A33896EFF4C7}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04F28513-2486-4ACB-88E9-3A70DE94863B}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05C7C14E-F086-4D95-8069-25261B9E04F0}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05DED94D-FC45-45A8-8874-BF55AC96D55D}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{088E30FD-2830-49FA-A757-DB189F7105A5}','DM-{AC15DFEE-0509-44FC-BC8F-A33896EFF4C7}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09413ED6-5C4D-4B6B-89CA-2B33F976A4D6}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0BEB97A5-E0B9-475A-9605-A0541DE4588A}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D7514F9-5A4A-4765-8780-6822632561B7}','DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D972377-A913-484A-A515-4C35FAA33089}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2024-12-18 08:29:45');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10BA94D6-AF16-4E29-B987-12D8041B09D6}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11AB53B9-B412-4691-87C8-2BDF3EA158B8}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{12F0870F-C154-486C-96CF-AE15EE0536FF}','DM-{7D1A460C-9BE9-47A4-A16A-FDA19D09803B}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14949710-AF5E-4257-BC6F-E5E66833850C}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18926EF9-BE72-4189-BAD5-CD0660E3E4EA}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19C602B3-ED79-49F6-BEDB-5B7B15F13438}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19C7E6E1-B860-41AA-B233-2E6F16FEFD42}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A5A18D0-2D36-4931-9EB2-016CBD014833}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BEDD5E9-5974-4F92-8BBF-A5E4BE8524BF}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CD20EE5-F05A-41BD-B730-73868591CDAD}','DM-{7D1A460C-9BE9-47A4-A16A-FDA19D09803B}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D451920-35F6-4B10-933C-194D6D3B1015}','DM-{FDF177C2-0826-4346-B311-FF34218D5E8A}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1DDAE0C7-2C4D-44E1-9B8A-2CD81B5B0517}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2029927B-4111-4549-A940-41D70129C552}','DM-{8FDDD3BF-A60B-447D-BFD5-D824FA668C90}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{205057DD-14D7-4FD6-BA98-5455142F5E79}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23B84B31-AD57-438F-86E2-DAD6C5FBA66B}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2461E31F-7073-42A3-B0D6-6DB029ED9006}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2599D30F-A1DA-4464-82D5-3AF00D48C235}','DM-{FDF177C2-0826-4346-B311-FF34218D5E8A}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26571AA9-7A56-412C-A271-BEF2F49EB41E}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26EED3E1-3118-452D-90E2-C383C0393EC2}','DM-{7764444D-6DC5-463F-8B68-8CE3EB67A9EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28384D4C-0E6D-4D76-BC62-077E0FF36662}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B15D267-BE94-473C-83E3-BE2879610150}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2024-12-18 08:30:04');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F6D6A7F-FAA7-4AA1-9436-B6149B4A026E}','DM-{98E774A3-1C40-44DE-B743-BBCF30F68970}','en_uk','global',255,'material','2024-12-18 08:31:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FC1C78C-F410-4354-9FE0-A52044B35A6B}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{300D2EC4-43DF-4F3D-B600-2EBE2818EE36}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30FCFF93-41DB-49E2-9690-5E81634A994F}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30FE8D15-3367-405C-9BE9-06A9B6E69E63}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31B8E1C7-0A84-4A2F-9C7B-785AF5761B0C}','DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32D497CC-EB20-41C2-AAD0-5B968488856B}','DM-{CB48F04B-5AC4-4594-8E33-18FE9A5F7F0A}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34469938-9D5C-404D-AC03-ED1765D2F163}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3629CB40-A703-4023-846B-DF25D2AE2E25}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2024-12-18 08:28:09');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37D3F9D3-9CE0-4F9C-801A-3525354AF359}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37FACB4C-B497-48A4-8645-571C8645C437}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3965B543-D571-4A34-8630-5046A0D23068}','DM-{F0B32297-4DD5-4459-9432-83386CE62608}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3BD4A27F-EE6F-424E-8760-5C24B246C15D}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3EB08241-8BBD-45E9-8846-146CE61FA66E}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FCDBC16-EABD-4BDF-9DBA-75621534B225}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40755677-94B4-400C-80E7-E00577468070}','DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40DEE984-8C43-40FD-9F72-46103E556C83}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2024-12-18 08:32:08');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{447F0B79-EEFC-41B1-ACAD-8BF44A7012A9}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{455D793D-8BE7-405E-B2CF-DC470AA01DDE}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4675E9C7-1166-484A-9495-C9024D45F7A4}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46FB9356-6BFE-418C-9552-2FF97988AD74}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4919CA1C-337A-4986-AC05-5E28333BA171}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AC9373F-B9C2-4CE0-B86E-50BB75822910}','DM-{FDF177C2-0826-4346-B311-FF34218D5E8A}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E6128D8-E277-4025-B97A-FD5ADC3D952E}','DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E8FD09F-238D-4736-BE39-CFBBB88A6F72}','DM-{AC15DFEE-0509-44FC-BC8F-A33896EFF4C7}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{526D41EC-EE52-4E2D-AB0A-A2D55D36AE6F}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{527D58B6-EAAD-4D86-9B4B-31DFBC11A8CA}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{528A0348-DC52-4B44-831B-9AD7F88063F8}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5314D3C8-F50C-42B2-B9D4-E5F8A556E978}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5358E47D-AF41-4227-9F7B-E0862EB72FE3}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53736092-0D3D-40D5-9543-1BA747AD545E}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{57DBE498-7AA2-44FB-924B-A8AA024718F2}','DM-{CA061D13-1700-4C9E-A2EE-EF0276915CFC}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5862204D-85C7-4C68-B06E-0CEDD1AFF0B9}','DM-{F0B32297-4DD5-4459-9432-83386CE62608}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{586A6564-938E-4CE5-84DB-1AB099ABE585}','DM-{F0B32297-4DD5-4459-9432-83386CE62608}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{592C51C7-C39E-4620-94EB-99EC7A2A9AD7}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59CF1D43-07FB-4750-9D06-2A37E237FB2D}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5A088C65-B1B5-4E08-A204-509C34FA8577}','DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C0F0F88-5F54-47C7-A161-001F353BE1DF}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CA62483-8AD8-42BD-B250-334A8F04E9A3}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5DE47FBF-E4B5-46AC-AE01-DD2856A462C4}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E434CA0-E62E-4E42-9F5A-763E18B89887}','DM-{AC15DFEE-0509-44FC-BC8F-A33896EFF4C7}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60F2B609-E648-4AFA-BF2D-289197CDB736}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61F5AA46-0961-49CF-B5AA-1FAA8BB5BBDB}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6207721B-D274-41C3-8739-662D8A58F181}','DM-{CA061D13-1700-4C9E-A2EE-EF0276915CFC}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62537B33-1E1E-4967-BAF9-C9597D12E6A8}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63875D4A-A1B6-496B-B05B-AD6BC470CE44}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{643B9A8A-5424-44A3-A293-CA8EEBE8F081}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{647D6933-0D22-4D69-9F2A-AD3D3BF8E8EB}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{658BB632-BA74-4C0C-91DE-648483502030}','DM-{FDF177C2-0826-4346-B311-FF34218D5E8A}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67CE1EFB-F690-4126-B5A2-925E94BF6E9B}','DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67F339B3-3028-4A69-8570-5C698F9D4DC7}','DM-{9090CFE3-FFC1-473F-A7B3-76407AB6371B}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{69562DFD-A74C-40CF-AC42-65C70E403FFC}','DM-{862CD1DD-A6A7-4C0F-94A9-BAD070FB8903}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A596964-5660-4B86-BDEA-CCF1B793431A}','DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F6CF7B9-3A31-46B3-8F4C-A5CE78611ADE}','DM-{CA061D13-1700-4C9E-A2EE-EF0276915CFC}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71613984-3528-4E77-9D26-4C4B15D07741}','DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73A43961-A316-4ACC-8259-16A763C66349}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7401AFEF-3EA1-487F-A05C-23567560A253}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778051E9-88FA-4204-B7FF-72290D7054E3}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7AEED72C-8863-4CF5-8C46-693B59781B46}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B41A1E1-D89B-44CE-A49A-57A35238C7BD}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BC300F3-FCE2-4ADC-93A0-5191D7FBA2D1}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D7D7E9C-860A-4159-8A3F-FAC53A218211}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81CD4683-51F3-4CA4-965B-7EC679F9BCF4}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{858240B8-6917-4D02-8A83-7721EBC9C20B}','DM-{60EBA0D9-244A-4696-B851-927EBCD97866}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86D2896D-8E27-4E29-ACA8-A5A01981C1E1}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2024-12-18 08:31:40');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87A81D4C-7F7D-4E24-8D5C-C62BF03CC4D7}','DM-{3136A95D-3651-4F13-9009-CD2B927F3448}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{885C3AFF-4574-4ACA-B5CE-7A0F63244406}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88F5CE32-496C-4B55-8E15-ADB260E08570}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{890C2FF4-3161-4B13-B918-6E99A56661D7}','DM-{98B773DE-4B87-44C4-B735-BB2976C785F8}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8933865A-DB06-433E-9664-533F839E0F98}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{897C7696-9470-4242-A0BC-E3440728D23B}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A97C0E0-2BE5-47A2-8B93-96F43830FFEE}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2024-12-18 08:27:49');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BC207AF-65DA-429A-B03B-1C478B6BB261}','DM-{9DAEA003-BAA2-45AC-9D14-4608F67D2BCC}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CA8E080-A226-4F35-886F-0D29B25C0F53}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CFCB0E9-B6BE-4907-8875-272DFC3E5E1A}','DM-{9DAEA003-BAA2-45AC-9D14-4608F67D2BCC}','en_uk','global',255,'material','2024-12-18 08:32:53');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E01CA10-D80C-47CC-949B-03978C6D90F2}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90806837-C190-4012-A3CB-1B2FA2FFE6E2}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2024-12-18 08:30:46');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9098A8C4-C1C1-4932-90D8-D7EDD39CFA1E}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91A5B3CA-6252-4A45-9B5A-B9F3FBBFADC9}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{965DEA2A-14E0-475A-817F-47DF28BABC24}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2024-12-18 08:28:31');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{966CB362-8DC5-4E6C-8082-A8EE018BA943}','DM-{F0B32297-4DD5-4459-9432-83386CE62608}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{968EA69E-1EF5-4F71-B991-D9D62132A908}','DM-{308B06C0-37AD-4449-90D8-97CF9A96176C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9783418F-EACB-4C9A-BD42-261D232DE41A}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D92396B-9FEC-4CA3-AE34-56A18E6E2DFB}','DM-{174B68E4-A226-4E82-AAAC-95B00E199914}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F1AC1D8-3B23-4398-9037-C952D9C7230C}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9FF5ABA6-C5B9-4817-8C70-D178EF908FBF}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A32D9798-08D9-43B0-BF5C-C4DC8A6D36F2}','DM-{CCA340D0-2804-4DA3-87D2-ABBCF609EE4E}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A35D9662-1289-4065-BCD3-24141B21DC12}','DM-{F0B32297-4DD5-4459-9432-83386CE62608}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8589DDC-9C68-4342-94FC-153FED1ED1B4}','DM-{7D1A460C-9BE9-47A4-A16A-FDA19D09803B}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA83DC01-CD7A-4BAE-A2E3-B8F9641A662B}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2024-12-18 08:31:48');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB4E7678-BCBB-4EDE-B300-8B9BAC88F27D}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB75CC70-521A-4385-9BBA-36E4CFDFAADD}','DM-{862CD1DD-A6A7-4C0F-94A9-BAD070FB8903}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADC21147-EED9-4EF2-AF8B-C8D04C615DDB}','DM-{25908EF8-6A9D-4F77-BFA4-B72CDB25E87C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE70D357-1006-4567-A300-B4CCC3567109}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE7E2AE7-AA6D-4473-B353-C3CD1B7ABF5A}','DM-{7D1A460C-9BE9-47A4-A16A-FDA19D09803B}','en_uk','global',255,'material','2024-12-18 08:32:29');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AED9F263-0035-46EF-9080-9A8313DD2D5C}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF98DF3-7F86-4D95-80CA-5F61EDD66B46}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B193B2AD-C295-4430-9531-E29E7E92F69A}','DM-{CCA340D0-2804-4DA3-87D2-ABBCF609EE4E}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1EEDD10-C63D-4225-9697-B35E4667AB0A}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3AC3569-AE97-4343-9C5F-6BC5672EBEDD}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B465E3B8-C594-4F0B-973F-791D8B707B92}','DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5B097CD-4005-45AB-876F-1CF879B6C23F}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B6E61991-F36A-44CE-9E81-C42974347120}','DM-{7C96088A-6134-42B3-8161-A800F010E130}','en_uk','global',255,'material','2024-12-18 08:30:37');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B98F266E-05B0-43F4-AD09-AAD3319689BB}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC0735F2-F750-4320-A7BF-26BE711A1FFD}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCBBB77D-06A0-4905-A241-ECB8A1761DFE}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD122630-453F-4B0E-96B5-3D2BC589C9E9}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDCA75C3-6A26-4417-859C-845F491CE01E}','DM-{862CD1DD-A6A7-4C0F-94A9-BAD070FB8903}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEDCACF8-31B2-4796-8B5D-987D4A2AAD5D}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFF1B784-E792-4D99-A8DC-034F9A6E8BEF}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C64F108F-3B2D-48B3-8012-D70B4071A492}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C65BD167-BDC6-4762-84ED-135E40D55AA7}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7E5F053-D7C5-4143-ADD0-150404498029}','DM-{19C934D3-FFD9-449E-9C2A-2653DECE981F}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9EFF3D2-2CE7-4DC1-97D0-EFF03D6EB518}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA4F72D8-76CF-4C65-B657-7C06449EFB29}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE1EDB00-3019-4A5A-A052-13AD0B688EB1}','DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE61BA9F-DDE7-4635-AE24-E9400649E10F}','DM-{9090CFE3-FFC1-473F-A7B3-76407AB6371B}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF3E8BEF-3CED-4C61-AE2A-4352F3F9753A}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF934104-602E-4062-BE56-3A2A793A685C}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D02C9779-D786-4EE3-8AEA-BEA842EDB666}','DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D071021D-F75D-4E99-BD77-DA68AB86AFE7}','DM-{F6BA2C62-3EB4-4810-82C6-702ECF257F20}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3C27D35-A600-4D8B-AA0A-12A08108943E}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3DEAC6F-A05D-4D63-AA32-A83D930E1A69}','DM-{300F11F4-EC4C-416A-B8E0-0D70C7CDBE38}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D478BB33-F49B-4F1A-9558-764B47AA74B3}','DM-{A2398C68-EF9F-4860-8F35-A7F8125CE8C0}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4BA22E9-4E6D-482A-8A8F-971EA366BDBD}','DM-{8FDDD3BF-A60B-447D-BFD5-D824FA668C90}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4FA9921-5ADF-4ACC-A577-2345E2E81BB3}','DM-{19C934D3-FFD9-449E-9C2A-2653DECE981F}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5EF9BEF-2D41-469C-A37F-66521D23E3BE}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6045824-492E-4321-A782-5AC9C592A0A4}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6F0B95A-F681-4915-AF71-2DD9E4F6C605}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D96F7AA3-86DE-43B7-B929-4AD6FB08DFD9}','DM-{CE4DEC4F-8748-4F42-8813-CBA050BFF191}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD7D2720-CEA0-46ED-9355-2E265CEB4D07}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDA57F19-05AF-4139-8C7D-09DCC4D836C6}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE526208-345D-425F-876B-A7735AE13A83}','DM-{5F3116BD-7E85-4845-A137-9285BFF0B115}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE75B0BF-E8B5-4AB7-8C31-8F25B0AE29FD}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFABAB85-0186-42D5-9B32-414602E747A6}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1CF95F5-C37C-4110-AEC4-43B3ED2BBB61}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3CD7593-4368-46D4-B0A6-E34AF5DA0613}','DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4571228-698E-4876-9014-DF0ED9DD9443}','DM-{D247A510-145D-41BD-8C40-4AB9B0115668}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4FFE747-865D-47DC-89AA-BAF5803C3751}','DM-{862CD1DD-A6A7-4C0F-94A9-BAD070FB8903}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E61AA80F-7265-4C00-BD6A-39BF206DC673}','DM-{3136A95D-3651-4F13-9009-CD2B927F3448}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E86C59F0-A2D7-4D77-A686-711B822CF12A}','DM-{80A3FB97-B5AC-4D64-9201-6B6002AB1803}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA39E223-BF12-4ED7-B19C-42B4D6EA932B}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECCF2E7A-B870-4D49-9601-CC01C4E3992B}','DM-{CA061D13-1700-4C9E-A2EE-EF0276915CFC}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE7E3201-1198-4AD8-BF04-E2CB82DF2459}','DM-{DC1BDAD6-8E8C-4ECF-9DC4-A5E51149002C}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE997DD8-7358-4774-BD87-B4B15AEA423C}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F15D0D16-90FF-456F-9B11-41EF94706445}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F595D63D-0C82-4182-B597-F175C1137186}','DM-{CAAB5B53-F067-4ED3-8592-07A85591870D}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5EB9F76-4FC2-4F2F-BF12-A250E74FBCA3}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6F8B943-1AD3-4685-A110-65A3C75B6F9B}','DM-{6DD98C60-9F8C-4A50-A2D2-20BECAC94C85}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F703FA86-0F60-4C4C-A1EA-AA1198CB50B5}','DM-{E8DE6A82-62F7-4CDF-A5F0-48F4695EEBF5}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8FB43FA-A2C3-46B2-ABDF-0CFFDB4D301B}','DM-{676F629B-1B6F-4BF9-8830-4028861194EE}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC2BBE8C-4745-48F0-803F-BDB81B6CE62F}','DM-{F17827F1-EC12-433F-9761-82F03CB25A78}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE3808D3-F538-4466-866F-3CED60FA5075}','DM-{F2BEDE03-2F2F-491E-9CE7-E3F31F0878B1}','en_uk','global',255,'material','2025-02-14 12:40:44');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FFD4C9F8-4105-4617-B7DB-27D46396DE90}','DM-{E6824E33-D5F1-4E99-8E1D-FE680015A13D}','en_uk','global',255,'material','2025-02-14 12:40:44');
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-03-26 15:56 -- fr_ch
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{013A55F6-4000-4ACB-99EC-C29C1781A7DB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01B8729C-406A-47B8-82B5-B5621E7428E2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01DEDBD4-6469-496A-81EC-26EF0EEE07EF}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{023F0137-4B1C-4976-8BE2-27DC8225291F}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{031D5C42-5779-4F51-9420-5E040C9A6486}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{034F2D8C-CB94-433F-88C7-091EEF6CC96E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03B795EB-FE06-4675-B42A-14D9E148476B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C0FD9A-367A-42C0-A7A6-6E013B4DE4EB}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0453B249-D9FF-4C5E-9E1C-7C0E818A0C50}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05348E99-05BB-425A-B32C-D80A7F9F1905}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{058F0689-8EFD-45BD-8CB8-0FBCAAF25E3F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05DFCD64-1151-42E1-8F3E-376C6B1E88AC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{063C6A0F-AD91-4C67-83FE-60736EAF63CE}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0688522D-2761-49CD-BC37-501C9CE1F2DC}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06CE08CA-FB5B-459F-B4A1-0C0E1B8BC56A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06FA404F-F696-42D0-BE27-E98F17F004A6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07B9B859-06CD-4BFD-AAD9-0000877D7D63}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07C2F57A-6A46-4046-92F6-075CB576B84F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0956256C-EBCF-40E6-B32E-F6EC9123126F}','DM-{70A5D4D3-9BBC-4E02-AA0B-D4A0161BE3BC}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0971C7B9-2618-4F14-9B8B-7B28DA0EA5CF}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B585A2-8B20-4AD6-83A9-40F1B5A2F593}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AA7A0A5-F5B5-4268-8E50-2EF292840CA2}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AD5B426-A284-44F8-8156-D3A2824A1717}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AD87B46-E68D-449C-BE15-11AD8FBCFC43}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B3F8EF2-005D-46B4-B242-C55C1E4C2A3B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C1318A0-20A7-4306-B42E-AAF17256ECDC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5E10EA-8D7D-4419-B4A1-29ED37A5912D}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0CF49364-94C7-4196-B051-262DDF177255}','DM-{FFCD7994-238B-4812-8E59-D79ACE613A62}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D2D3309-2B65-4DDA-8BE3-9AE386AC02E8}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D9048C6-A344-40AF-8D18-DC5D95CE7D3C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D99E988-D842-4651-9D5D-63C0C86E4796}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E7B5219-EF3F-4A36-8B92-A14FD0E650E4}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EA9C493-7022-4686-A289-F2EF73EF93D8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EC0F9F4-36EA-4D93-8BD6-59197A16822B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EC26EA7-5DD3-45B2-9EA3-A86BB1C5F129}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EDA4523-6AE2-4F49-888E-4E5C65DD8105}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F0070C3-98C1-4D4B-9A3D-01EE4912FD66}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10140701-2314-433F-8EB0-094F7647821F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{107B3BFE-3B72-49DC-9BA2-ECE74023DFB9}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10819925-1CF9-420D-97E9-FBA457A2BB44}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1088BE88-C64E-427E-8005-048A12FC38C6}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10E0DBCB-995A-4BB6-9BE9-B9FD39FF939A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{123A70B4-9D09-44B1-AF7D-07D35B31DA6F}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{128F362C-D510-42EE-ADD7-A2EFDBB02508}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{132B8143-3261-4E6A-A232-A2E0257C968A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13C75F99-D541-41E9-B910-659EF0D68984}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1486BEDA-91AA-489E-BF20-187849B58657}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14D15918-246D-4D3A-930A-F0F8F5044B31}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{157340F5-2BC2-4EDB-9D2F-D40E4516DD27}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15F7D634-88F3-46B7-AD08-57817352DC58}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{165ABBDD-C32C-4BB5-B547-32FED8C367F4}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16D12E0A-D4E8-4BE5-A27E-5F4289C1CF8F}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16EF5E6B-B353-44A4-B860-0BDA014CD82F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{185A17B1-2282-4FEF-A85C-6F1CC6C1A166}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{189147C2-3AC6-43DF-948B-410C24AC6351}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A07A875-A3CB-4036-ABF4-D70E150DF98E}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A0ED450-5A69-47C1-B36F-EFCD6B9EB3D7}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1AAAF178-44B0-4B38-8F96-3DC7ED69A04A}','DM-{0A891D45-D04F-46D5-AAB1-97A917A485BE}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1ABEDEF5-532C-4D8D-912F-022C6E427C7D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BB5213F-2CAB-405F-A2F3-69654C64A73B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C7E162A-45F3-4069-BC12-4EF8646A8045}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CDD0386-45E8-4CD2-A3E7-337DB8E8BDBD}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D05865A-2215-415E-BBDE-66026FC6722A}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E106A14-D6DE-4447-A1D6-4EF365E5F8ED}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1EB99C43-0FB4-4430-9B4F-30D2D931D514}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FADC367-7C96-485A-8419-5CD5DF34333C}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FE32AE5-67CB-4D52-A98C-63F610106D1D}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201F2790-E4FB-4745-9135-338BC2F1D1BB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21A96072-8BF3-4686-A319-91CD708DFF2A}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21AE8AA4-F2FD-46FC-8D89-DD2E72F2783C}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22211E3C-94AE-4C16-81BC-EE11F5C9652D}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2290DE9F-9C0E-489F-A530-BF5435A14EFB}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2344E331-515C-4F13-AF07-AD93A175A6C6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23EF0B0F-F040-40E9-9E90-3BCD590E0D0E}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{252BAC70-D557-44E1-8323-3E07E02D517A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25378106-9905-4407-9954-7B2E21A37B18}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{254E5D09-FCD0-40EB-B962-AB2E1D144367}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{259047A9-D1AE-4215-9745-C82947BBBFED}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25CB502D-3E3E-47CE-B969-F2F6F549403C}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25DEA72B-0D9D-4663-8A23-95FCABBB14EE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2704793B-9C4A-444B-955E-16D6C5243578}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2784E67B-7258-48B0-98C4-6FF00DFE7C3C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{278590EA-2289-488B-9F12-B76023B51080}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2796CCB4-EB20-419C-AFB7-A14658D080AA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2849378B-3585-4541-995E-8974967B7FBB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A2C00F6-2D2B-4897-8189-2F3419153D33}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A32D430-6200-41E7-A4CF-811A87C1E90F}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A5C988A-70F9-4DEB-9C81-CDAEC2303A48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2BC8CDAA-587B-4628-A132-E8E59AF407B3}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C061F80-4E19-4659-BDE2-CA0AE9E2B1A7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C1218D7-20F4-43B5-A62A-C43B0D5D3735}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CD3E2C7-47D9-438C-BEA3-652D0674D51F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D35B4B6-D647-4E37-B6B1-BE3BDAAC2D19}','DM-{7C233D59-3200-412C-8F51-E7443767F1C1}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D9B62FB-B29E-4C8F-9BFE-E8EB443AC451}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DFC433F-63E0-481F-9EA6-C49E7D242DD6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2EC46512-7ECC-43A3-985B-54208CDD9AAA}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3EC7FE-1A9F-4207-887F-4B00E6A3940E}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FD5CA78-114A-4F9E-8FBD-1E2A81E38F6F}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FDA7CFA-4859-4059-9C35-904D4B975C6E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30FF6C10-2047-4F8E-B7E8-71BEEE581DBB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31DC0CF3-BA61-4E92-AA86-7B9A9EB73645}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3222CD3F-71A4-4682-AE71-136DB65ACB0B}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3249AD93-2FFD-41FB-BFB2-30EC2F142229}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{325F34ED-8A77-4685-971E-1953209B4172}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{329A9EDD-FD2E-4063-B3D1-AC966F9EC6BA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32A986AD-037B-46F3-BA69-976C257A0334}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32E69993-59C5-4A58-9389-95C685602E53}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32F8BFD7-BC40-47C5-9543-0A946BCFA57A}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3350B229-77E2-433E-8BDA-DA9E00E5CDF9}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3369592F-BAB7-4D01-B033-3EE9520BA7BC}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{33B8D962-3175-4028-88F9-318C790D014E}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345826EB-C148-423A-8F88-A97B9068B506}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3673E3A7-F5B3-46EF-8C04-BCFCD8C71B86}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{369701D6-4D30-45AE-A139-64DBF7D56681}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3711A6A9-DD71-4AA7-B408-7EE295613382}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3723BE0A-F958-4CBC-9487-542E78C1934F}','DM-{98A4AA64-3ABD-48EB-A143-EE06E34C9D12}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{379B5480-B36F-4AE3-92CE-FEC0D81260AD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{381584D4-A6CC-47B4-9B52-13CFEFF918B9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{386A07A8-529C-4A52-A79F-ACBF41EE9511}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3917E742-0636-4124-888D-BBD1182EE00B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3965A62E-AA5C-41D9-A3A5-A7FB149B3B95}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{396627CF-585B-45FF-A95E-E60430313FE5}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A0E810D-459D-4016-BDB0-526932CEEB76}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A8485B5-8107-4D84-ADBC-68846F716798}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AAC0000-FEA1-4009-A27A-0F17A31D9ACD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B7CB639-F696-47E4-AF44-53CEC2C18B59}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B87E3A7-1A5E-4A2B-AA0C-2B306CC3DFEF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CB26AA2-98F8-49CA-8D0C-3D3DA3C0E928}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CB53B5A-A8F2-4EDC-957E-3C9E360A11DF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CC8B132-B288-44B9-811E-08467256B241}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F2306FD-1C1B-4C52-A305-45EC5338932A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F40B4FE-D57C-4F42-BBC7-08D995F80B12}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FEFC426-F428-4DD3-92FE-F3526EE7AFCB}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40867852-1B7D-4745-ABAB-DE907F1FF2E4}','DM-{F51CA4BF-6614-4714-853E-66909E6E5D53}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{419DAF6F-269B-4275-B13F-220789D62AD7}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{420CEBD6-9760-4761-B7A3-724FE8743952}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42526318-0B04-4D0C-B6BD-4962BFEEF76A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{43D71A25-D40F-4CCE-B0E5-3A03BF7817CD}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{447AF20B-9A6C-447F-BE3A-0FF18E032B8F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{450BD1DE-CDD3-4F9C-9567-B8E9C4AB5560}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4533F347-DE17-42EA-9193-500FD35AFB44}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{453A37FA-212B-4037-88A2-EB4B355AB1AB}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45502421-10D2-4857-ABA1-71097253EBFC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{455F14F4-CD2F-4C73-8D7E-D3D207B7959C}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45684AE9-65FD-44C9-912E-9E3E19482C17}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4585E783-628C-4FD6-8565-F07FF7A9DA31}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B56DD7-E158-4B07-BF26-A1D02B339535}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47585E30-EF01-4949-B527-2360697ACEDD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{493DE1E6-E61B-4466-B1E6-1F3751319D2E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2D5DF9-7F32-4945-A847-7A2C39B51165}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B29A292-1B1D-42B7-BF8B-A3878331B3A5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B4CF12D-CA3D-43FB-931F-1C7FB87794D8}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BD2709B-0FD2-4B85-8C9F-9ABF7DBB8C93}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C6EB41F-EBF8-4051-9588-2C3DCA5B6481}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CC57D0B-0A66-436E-A566-E8A5D0B51D29}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D01325A-291B-4D13-8A1E-BE21D991F393}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D32674C-59A4-4D8F-9525-571473530B7D}','DM-{3590628E-C3DD-4623-8D65-052EFC3286C3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D4899C9-DB69-42E0-9974-83D72F7B47E3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E294F45-6B56-4316-BFE2-509CC3381B69}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF731D5-4A7A-4245-AF6E-D9A8E0060855}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F471332-CE48-4861-A4C1-48D502B8C8BD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5031376D-AF83-4460-AF39-748CD596F3BC}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50533D05-FD9E-4ACA-B598-9D07A5B0B777}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{512F92E0-EBA6-4159-A231-E948DE3B7C54}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51A8CBF7-F6B7-4064-9ADD-BF09B97768C5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52477A94-71EB-47FC-BC83-46CAF3B4ADE9}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52672D77-4E78-46C0-9316-2CD7E079373F}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5282B47E-ED1B-431B-8A0F-A278A1574DC3}','DM-{20394B8E-F36A-448E-8D22-29E35156C798}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52F00B0A-C54E-48BB-BB99-F4BE62C71EE9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5426C1F2-E402-4450-ABE1-5AB16F072470}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{554AA962-50E8-418C-A1E8-39CD1756D31C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55BCF770-CEE7-463D-99AC-7DFFA0F40BD5}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5680D2C7-B8E1-4A57-9EFB-1D1A19C69DA4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5749427C-6FA0-4315-957B-7FB88808D903}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{574AC0F9-3B7F-4CFD-9F64-0A69C8F73D7A}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5780EF7A-4496-446C-89A1-7FB802E25932}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58127D79-FC94-44B2-8BE5-34E64E558A9F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58919727-32AE-42CD-A13B-407F43743152}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{593C37E5-2FA7-4D6C-916D-CE0F0C9A8608}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{598B66B0-D625-4D65-9A62-81EEED3EE7EC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59E5DEFC-3323-463E-907B-4BD9C58F6F41}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5A93015C-60AD-4226-B736-7896733254C3}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5ABC1F63-716C-4A0D-A737-EF6E89B236A2}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B30D489-BEC5-4BB0-A0C0-735540B431FC}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B61F5E2-A0DD-4F7F-B1C5-192416C26D79}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BB5B4B2-A9D4-484F-8F63-CC9401D24855}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BC572C5-1EE9-40E3-98E4-1BE15D69242D}','DM-{FBD41200-41BF-4DAA-8547-0B5EC5ACE67F}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BD77517-0266-43B1-8B36-6C09C5E8C854}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D2C973D-8125-4E39-A1FB-548025262464}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E85FED7-885E-41B2-B856-885FA1070E0A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EEE467D-BDF1-4D1A-947E-1D3129BFF6F9}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F87F34B-051A-4411-BB01-3A0F365A568C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB983A8-BB57-401A-B5F5-7F7CB115BAB3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{602766C4-FB19-49C7-BBD6-9AC2F54B6AB3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60337298-38EB-44F8-8457-4D2952D2B8A6}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{607AF520-E16C-4986-A1E0-27AC43B843C0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60AB10E7-4BD5-4825-910D-E814176889AF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{612C9C33-BE02-4FB6-957E-123D831FF7D9}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{618E8CB7-69DF-4C5D-81FA-BAE170EC943A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6192EF9B-04F5-450E-98D1-D2DE4BE42E36}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6217FBFE-CF69-4403-9A93-0ABF18D5E349}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62605FE4-38D0-4EDB-ACD4-67F6F4475909}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{635FE4EA-4634-4730-A4FF-48408D1EAA32}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6371FEFB-8D9F-4425-B38F-9C930AEFDB21}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6469F660-4EE1-436D-9E34-B87089AE8C75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64820016-06AE-429A-8855-FCB5AF682DA2}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64B5C253-EF99-4574-B3BF-59689C15D3D4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{652ACB35-6DE2-477B-A5FE-55A007B42A21}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65A573EC-012C-48C9-89C2-5F5F36DC6EB5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{662D1329-57DB-46D3-8EFE-7383413509C3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66D375E3-65EF-4C51-BD95-BC98F78D8A3A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67360D97-0ADA-47C6-9614-6304506A16CA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68A47539-7041-4B46-8AF4-8A93684685E6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68EBC788-7FCA-450D-BF1A-CCAB04027653}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A23C638-0EFB-48FB-BF26-F15DCC98E9B8}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A72116F-EB2B-40AD-81E6-BF45AA782716}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BCAF8CD-636C-4E34-89F5-A4FC20CCA49C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C1C51EB-61D2-4B0F-BCCA-7757CCDF116F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CCDB136-7753-4D64-A332-9AF769971AA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D35993B-C750-455C-9D19-78F8FECC255C}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DBC00D2-3696-443B-A755-B959CF53F576}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DD14FCB-6AEB-4D15-B4F1-ECACEBA3E2FB}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E0ED961-8ADE-421D-B750-A1A16735FB11}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E8246A9-359F-4DE8-997A-F921BB5E9F86}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F88F0F9-A57B-498B-B794-0E828B5CEA54}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F8BC682-F8E3-42D3-B4AA-31B9378DB596}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6FEF1539-BE05-4629-971F-62705859CFF7}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71015ADC-29B0-4C2B-BC38-FBD6730AFBB8}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7161F599-090E-4660-965F-E0CDCC2B767B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73237BE5-12B2-449C-9555-5ADAE0C1DC75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E369B4-4756-456B-8A9F-F1639566ED2D}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7442A778-81C9-46EE-8BC6-72E129000601}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7465C201-EE34-4ACA-998C-2542AE71A902}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7607871E-6D9B-49E8-9E85-2043093F232E}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{761CBD3A-1AB5-4AE1-8EA3-BFCACD619684}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{765484F1-938D-47D5-9C91-81B5BAA5FFBC}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76971A77-5E5F-4BC8-AC49-887CFFC13ED2}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76E692DC-A046-440E-9658-E038B2D0BF6D}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77069B61-B743-4226-B9E7-EDD2EB1E116A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7765E69E-EB2D-4ACD-819C-7CEB800CF950}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FBBB0-B4D7-4916-B9CF-C79F2B131944}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77D3F184-7717-4291-ACF1-7BD440009535}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{784845FB-8235-4035-8F4C-C9FB5CFC8300}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7853E799-6091-4BB2-8A3F-B71E9B040ECB}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7951BB0A-9F48-4121-A3FA-BEA063A058F9}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79820EA5-049D-4FF2-8305-0CC19DE96D10}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADD2B0B-BF77-4BDE-8B52-7AA508A44425}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B444EC9-1221-4964-B653-0BEB65024D3C}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B5D8F6E-20C6-4F28-8D95-409B6863F56E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B68DB35-D03E-4467-8135-C061DD44755C}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C1190C4-1C1B-4BFE-8E2E-8C5B0B2CADCC}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C16DA38-9E51-47D3-BBE8-FDEE60D74CE3}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C182F70-28D4-47BE-8F85-25EDD115D9FF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C9D1296-75B4-4948-AC9B-2314FBD8F47B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CAF2DD3-7530-40C6-ADCA-E18CBA80F591}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D47751F-CDCE-4671-AEF0-80BB790205B2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D8D041D-CE45-4E83-8593-BF8CA3508984}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DCE3B42-B189-4697-AA87-AE25F3004172}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DD58DD6-6B51-4215-8B9B-5800CDA6016D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F2BF1AE-B2E6-4D6D-89FD-DA49306AB310}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F41D0C4-A848-4B15-9AA9-98D9B74587BE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803A22E9-DE76-4217-887F-0DE14C2E55EB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{804AB273-52BE-421A-9F3F-A8D0FAFDC33B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8100ECE0-5892-4A50-BA51-F280645C686C}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8128B37C-4AFC-47C7-8828-FFDB7AF81585}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{812F48DC-B907-4998-B21F-44CACC469697}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{813AE174-47A3-4160-AD54-4EF81B55AA67}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8145EBD4-2FE3-4B79-AC70-C9E2F5CDA55C}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{815DDBEE-CB9D-48D8-8D20-D617EE6E5E5D}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{818A2AA4-DC4A-4D9C-9766-BB4C638A1A71}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81EE5064-E14F-4051-92F6-CE3ECB0A0ECF}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8208505B-79BD-4002-9245-81FBFC78AA0F}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83438D0B-645E-41C5-AD43-DCC5443DB775}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8372D589-D2A5-444C-A3F6-1FE0B0C2DD82}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8382012A-5DB5-48D7-8CA9-F98F11D10B61}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{848D2DEF-DDF0-4A1F-AF77-6B7A1E03E231}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84AFF4CF-3F3B-4C58-8C5D-FFAC813E06D4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84B4F24E-C567-4B33-B00B-BBA3C5137AC2}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84EA04DF-B4D7-4FAD-A551-C2FD48956DA5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85641B10-465C-4478-8BC7-16C4E2879069}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85CF75CC-7475-43A2-A87E-AFE9C120728E}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86750902-10F6-48A4-9323-9699DE631450}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{876B4E43-CE8F-4937-8BB4-0C129C052785}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{876E98E8-B56C-45BF-8AF1-81EC4CE9EB88}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88705A04-16AD-4A7E-A0C5-BD3EA3E14003}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88A43A04-F782-4D23-BA7B-7E5031B002D6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8953C11C-41D8-41A7-B221-4DE307EAD2AE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89685A64-57EA-4C05-9B68-550CC46D73CA}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8969BCE4-FE61-4EF0-8C97-D653EBB2D70F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89E52080-8511-457E-A5BB-B06608AE6947}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A6FD0C6-A92C-409E-9EBD-32C1842AC4A9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B18BA07-6877-43E4-8E45-6BFE8BA2368E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B609566-2AC2-4AEF-BED6-8B4D821628D0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B9BF69D-22E0-4C0A-BF8C-F7C66C2F4FB3}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C464613-50EB-43C0-A8D9-F101E4E00B1A}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D7553CC-C3A3-4426-B98B-C6FDD7EC932C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8DAB21C8-D35E-4CB2-B19F-6A91939C43ED}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E19D3FF-3C57-4735-8C53-2CCF37411BD0}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E4B1D15-16FE-4B72-B12D-3C1690C04A3B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5280DE-8F30-4AC9-BFF2-94809EB7ECE1}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5743F6-3C67-4911-817A-E1A346C7B466}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8EA57574-D023-4EFA-A887-EBB3DF8034CF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8EE0EE6A-1B34-462E-9D9B-4081E0BD27EE}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F9547B2-D293-4173-9490-A762DF9F1143}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FC52B7D-ECE9-440C-B220-D026C50CCB1B}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9002111F-10ED-4503-B9E8-BF6632C4F0F1}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9044C7E4-EFDF-4101-BF12-41E6BF9C3A4F}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{907913F9-63A5-4D89-B507-F477B7E596FE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90A90C81-BE96-42B2-A5C5-443B4394353D}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9151535F-02AC-4DAD-AFC5-E40ABB61D48D}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91723F16-64F6-40AF-96B4-CC595C313834}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9198583B-0F70-44A9-BB2C-0153CEC9E7A3}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91D4F5A0-279C-4684-8EBB-75C32DA85915}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92244F82-C4A2-403E-A3D6-5298E3EE6A8E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9272C2DB-9EDC-416B-816B-05FBA304693A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92A67EE4-2D86-4B91-A261-FAE231B79653}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92B88334-4500-4EBF-9E26-D8B210BE282A}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92BB3948-2EE7-4A85-92A2-8D676F52B765}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92DDC4B8-AA3D-491D-AEA0-CA6A1FDB8517}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{938E52E7-9CEB-4493-BA85-7B13D1E2CC7D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93F1B0F6-2A21-4DF0-ABB1-ACB97C98A386}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9404D72B-223F-44FA-BE5E-8629E82B3E5A}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9413835E-1EAB-408C-B463-A3EE166C7B12}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94BCA705-F366-421F-A594-A82DC639DF6E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94F02505-0A59-4DCA-B7B9-AE27D22321FA}','DM-{FFCD7994-238B-4812-8E59-D79ACE613A62}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95288D2D-85C8-4830-ACE1-57D6B3886E2B}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95B50FC1-4F55-4716-A897-974E7FB9593B}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9699A615-E3E3-48AB-8047-FE1E21504B8E}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96FCCB87-1733-4CA2-9964-F59CFB1E0AA1}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97B26F83-5DE6-4680-A891-028CE09B71C6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97C5C812-E717-4AB0-8CC5-0F9CD83EACE1}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99573DBE-B4E2-4292-B834-2367FBB2EDE8}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99A3ADE9-B3F4-49FA-A04C-595CD8E0FC5E}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F2B469-455B-4D9A-A519-126D440E5026}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F2ED0B-12A9-42CC-9974-8A524651FAA6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A0715B2-05A8-44FB-AC83-EF5F2CF80E9C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A4C50F5-1AE2-40E3-9C83-DE3B603DE781}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AA4E2B3-09A5-4FA7-886C-D834760024C2}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ABB46B5-F8DB-48EB-ABF1-98AD9AF7446D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B0B0F7C-AF2D-4B09-9D09-F6144F8439F9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B1EEBDB-49DF-4D61-B1F9-931DE7831492}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C426CC1-A720-4F28-836A-083A32D99055}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C70FA2D-84CE-4342-9874-02F5B11E1F48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C9F9418-B54F-47D6-B914-494C2A64622F}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D6B0966-4A40-43C9-A3D8-770766D7C5C5}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9DC03E67-9C03-4C8E-A0AF-8E2C2B98ABA3}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9EF8502E-A5CD-48DE-8406-B4A6D1D63116}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FBD942-1EAC-4A5F-8BFF-D0534EA2EAF7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1F23CF5-F8EB-4296-B75A-55F8D262EF66}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A205D5C6-0D8E-4DBB-872F-06323A5AA742}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A25A7494-0451-4726-895B-7ED7F97D201E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A265C466-3DDC-4674-BD67-3EFAADAD91E3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A29229A2-4D50-4767-8F92-35C90C2FDEA1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2D62CC2-09FC-430A-9380-CF69F8B32A88}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A369DCCE-6304-4B7E-9A9C-BE771AC8B240}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A43B747F-39DE-47B1-A1DF-6D47217F9802}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A470B687-6C43-41D2-965C-255749F85CA5}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4889965-5A1A-422C-84D0-0BAA0DAAD99D}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5192EA7-AC0A-40B8-BDC4-69025E55133D}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B0B937-A8D4-4EE1-9EF6-CD798C737FA6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A60C3856-FCE4-462F-90FD-1289607D3CBB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A622D361-D637-4CF1-A969-A2F8D2BC00E9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A748CE42-351D-4B91-824A-223D7C031400}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A757D97F-9597-4E45-9C13-08840FB7DA1C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7A07123-CDD4-4EEA-AE43-9619AB85CE12}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F2E903-B656-4EF0-9B76-A51FE6A5761C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F80B82-5EA1-4546-9695-A496F4F9B248}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F88127-3531-4DAF-B7E3-4F70CE7EAC22}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8176A03-FDB2-49A0-81C7-503964F4BA98}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A84D0AD6-7083-4870-9A1C-F2CB9E501ED5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A84E97BF-7EFE-4F69-BAE6-91659A5BA7DA}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8965A79-F9FE-41FD-BE74-5D5308483787}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8F0D4A8-38AC-407E-A8D7-CC0AA1A82C7A}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A98CDCD3-6859-4698-A970-A2C708796067}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAC7EECF-D680-44FF-9CD7-DE05EF84877D}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAFD8BC4-B2BD-4354-9D61-4A341FECE947}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB4E8CFF-7E01-4941-9B90-69F8A4CF8311}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ABFCFCA3-192F-4537-AB92-8594D5BECF7D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD2D0064-5FD7-42A1-AE38-5346C9C2F13D}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADF8554C-71DB-4158-AD89-5B7B49DD1B6D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF0AA43D-B846-4F7F-B391-648BC94B703A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFA4AE24-0EE2-48D4-8AA0-C086861DB6E9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0B3D907-8417-4906-AC84-631A9F611BAB}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0CA7021-5D71-45B0-A95A-796EFC499F75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B11B65F7-E741-4087-B181-A176074EA037}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1752315-6F05-47A2-9D61-FE51A0A9F2A1}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1DCAF03-E201-4A8E-8BD3-4B9996FA94B2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B27CE8DC-8D1B-4A6B-B59B-BB80308383A5}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B39ED600-A99B-4F59-9CD8-26E60C76D2B4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3B857F3-25E7-45CA-A912-9D058CD1C0B1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3C22394-DDE7-40E6-B761-0ABBD985674C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3E8168A-B5C0-4D44-A83A-E7699B48D1E7}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3F8086C-B903-4002-885D-EC5056853640}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4560241-B2BE-45D6-8A0D-8C7D34236A50}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4C05CDE-A412-4F4A-9C86-7DA06003699C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B51DBD64-5D41-4CD4-B096-67705D7FF096}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5577D0B-F1BB-426F-973D-C029858AAFED}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B60D264F-AA63-48BD-A710-0648878A034D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B78EFFBA-4AE8-4248-883F-CB0C0778FD71}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7A09602-A506-4CB0-B133-66C17C3E441F}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7B9257F-ECF2-44C3-9059-680716367BA9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8714D24-C4EF-4AD8-9770-BA02E79D45DF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8FF254B-9412-4364-8B86-94DFB348A276}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B911312A-B11A-4345-8FEB-3F5624AF1B5E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9BDA79E-7CA2-48ED-8051-CAC167E2E7C3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9DCB46D-01B7-4CAF-AEA7-62092B327B2B}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9F8C849-30EB-4E35-8C3C-9540A3FC4551}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA936C3C-C9F5-42D2-9FD3-69BF0C1C7927}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAA95E61-E796-4B79-9E9E-0BA22E94BBAA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAE32058-C975-44FD-B8D2-27B06733D557}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB084D08-D737-43FD-82C4-EECA5659090A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC2C7D6D-4C62-4EBD-B5DB-3B0945EB6258}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC89B42F-37C1-42CD-BCFA-AE4682391014}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCD62094-60C2-4392-AC4B-E4094D520DF9}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD42EDCC-8BB4-47AC-AAA6-CC5297A6C635}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE1EECAA-F68C-4A2A-BFD4-57F20141DBB4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE20D980-9935-4DCA-90A7-2C6D7AE555A6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE244C39-BB39-4434-A75C-CCA312A018E0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE640FD0-B116-4B0C-ADC8-F124ECC2AD95}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE6935B3-945B-4E5C-B298-B3BBCA2F559C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF90E5FC-44F0-4F88-B06D-E2EE019900F8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C048BD2C-7459-43F8-AE03-8AE60F47D071}','DM-{0A891D45-D04F-46D5-AAB1-97A917A485BE}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C09359AE-CFB1-48C1-9A6A-7EC55DFEDE47}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0DF20C5-336D-4EDE-9BEE-E8850541E834}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0E58FEF-29C1-4FD0-92F2-89AEAE0850A3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1304ED6-020A-49BB-A915-2E8309DF0FF6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C19E0EC7-0217-4C7F-8960-BF578272C730}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1B8AEE9-151C-48C2-878E-3F9AB23CF96A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C217A71C-69E5-48A8-BB69-43A668D0423B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C25C770B-730C-44F9-A846-3020177F7AFB}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2942EC3-0A5B-40D7-AB68-C9A6D61E0F11}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2BD4489-D7E9-41DC-BEBA-C60DFAF51FA4}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2DDAF5D-26BB-479D-82EA-0E9290CD377F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C30929F5-9012-470D-B164-772666D75E63}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C35F4DFE-3178-4BE8-99E7-234784B37D1C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A129EC-ADE2-4E58-8D0D-07316751D2A1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C40CD3EA-61D9-4ADF-8F5F-5666030F6713}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C440CE4A-605F-4469-8261-797FC6AABD1C}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C53EA29D-9450-4EEF-A92F-DF2C2D0455F7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C59F24C5-E1FE-4F1F-A7AE-0D6C93B230C9}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5DCBE07-BE3B-4FD3-A16F-8157D0800867}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C61058EC-CB5A-4A82-BF4E-70A2535F5D29}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C62DA86C-8D05-4FEB-93D6-4C58F87AC953}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C643FDF1-7BC9-4C64-B291-2AB16FBC728F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6457428-EC5F-4905-BC67-708EE7CE1B1E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7047950-3E0C-402F-8DCC-DD70966894AF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C75BAE23-BE41-4A34-BEB9-402633B93BDF}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7C0BC70-99B9-46CF-AC41-F132FB8D793D}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7FFF338-6CDA-43FD-B6DD-63FB7FD65B75}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C85EF661-D847-4F6D-AE9B-598B522F5ACB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA16C89E-FD52-44CF-BD64-C6DC85B7DA34}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA897DB0-ACDB-49E0-99CF-33244EA92111}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA93B71C-6477-4CE3-8310-D6956F2C619C}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB60CFEB-8603-44FB-A9FF-F517655030DA}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB82231D-0B21-48D0-B0CE-16C9123EFC28}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB9D0A0E-242F-4EE4-858A-025A7921FFC7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC614A5C-1193-4A85-937A-6872E5FF5A48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD0E2E88-8FB0-4A65-9C4D-256454BC1A0E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD69F29B-C442-420F-B829-E95AC2F46C53}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEBDEC3F-C089-46E8-9957-125ED85F1D66}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF276236-22D5-4C4F-9D5D-72E141BC1468}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0258F2A-4FF6-4E90-A690-A463258BD6DF}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0766575-F2E9-44A4-8A18-2AB18C093B6F}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D232FF65-C798-43FE-956B-58F2B1DD0A2D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D25E8DFE-E5A1-4C0F-8942-B9FFB4DA7AA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D289591E-7635-4DFD-A00E-0DCF6628DF8B}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3226FC0-5487-47D0-AD6A-C5099C159541}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D41A448B-2219-41C9-BFE0-A8B3B05081B3}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4EA8EA7-654D-4BB3-9605-229349F4A043}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D51D7359-7B32-4917-A2E6-D9685ECF8EAE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5B9D33A-CAB3-44EA-A53F-0B355D8670EB}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D761C071-1709-41C7-8FEB-446A94F60662}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D765132D-E29A-4701-94F1-0FBC9C3614C5}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D76D0964-4190-44B2-8AFB-0D7CD79A616B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7796927-29A0-4D6A-9D08-E625E4635A8A}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8467653-3AED-44F1-84A1-D11A8AFF9E02}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8AF7510-FEF3-41A7-A860-FA0E04EDEFD7}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D91BC45D-19E7-46E7-AEA7-BF82DDFBF455}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D95E4D14-B8C2-42DF-BD50-60B0D070D648}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9F3D36C-52BF-4674-9BAA-F6E3D7E5EA4A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA0EE3B7-CC8D-4A97-84F3-07708699095C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA282BE6-F7D1-462B-9600-74C68513AB13}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA319486-CA79-49B1-BA29-C9D0560278A8}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA5BB312-A688-4011-B2A0-323EB6FBA6FB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA703329-716B-4CDB-A8A3-F1076E488861}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA904835-9828-4ACB-923C-1B77615ECF26}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAEDECD3-765D-4C9B-B790-F30B2A96978E}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB35A850-E850-4757-9B27-3072148A17CF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBC79D3B-922F-4EB7-9126-F70721E7C526}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC74C392-8B1F-4B7A-86A4-EF55182FBEF0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD8959F6-24AC-4758-BA05-C90D0D8E1C15}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDA5BCCF-EDB2-4474-BD5F-EFA9DE54B87F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE4B57F7-CF8C-49AF-96BF-FFAFD0DF67A5}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFB7D180-79F3-4512-9A85-D9CB4F105FA0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0670956-BE3C-43CF-AFB1-79C7AB24F043}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0C30B7C-8CEE-463F-AC9B-7A27F0FFA199}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0E51FB9-B590-4ADD-AF36-11B6B194891D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E12A0345-BACB-4C30-855A-A339653D5578}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E17319C6-32C4-4A35-97DD-EF5E4046238A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1BECE8F-AE8C-47C3-80F4-B84ED408EB16}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E262A864-23D1-4C28-90D4-E3DBA6819D77}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E2695100-8BD1-4665-8DB0-2640B79B59D8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E358324A-4A5A-4FD5-A4BE-5B612CA861DE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3C23DEB-02A5-4CAB-8A8F-2A4D97D40A4F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3E90D85-A006-4D60-9C68-F330A04A1D0B}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E412AC24-5677-4088-9A1B-241F0E7F0F37}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E52D609B-C8AB-44AF-A313-650ACA757EFB}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5D80C16-CEE4-4D8A-A3E2-F79687C09218}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5E5CBB1-0318-4518-85D9-277CFB509E5A}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E65A1DB5-3CEB-494D-BE91-FDAA60E485E1}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E846DA6D-8A93-4903-98F4-A4D5B083B5CF}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8F50454-ECED-4E25-A1CD-B384B17DFA92}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E92C87C5-D139-4625-9C8F-18D04DB6B0D6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9AB9B81-51BB-44D4-999F-529386858E36}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAC6EA8F-B372-443F-A503-5AF6F55E15A4}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB8CE300-98DC-43E7-89F6-DA6050FD16F2}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBC70B60-3B02-4340-8886-9B4EF7AAF9B8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC6384BD-85BE-4FE5-A7EB-B456616323AF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECC619D6-21E9-41DD-B54A-2BA5D62D6C80}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECC749BE-9C60-4D39-B7F4-FCACBC18135A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED1DCA5A-3541-4FD2-A91B-C9AC2A33EF31}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDA28E96-AAB1-46B7-A77B-1FFEF860966B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDBC8F51-0164-4291-B821-16EE2A26C834}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDD0BCDA-5E64-4A4F-AC46-C5EC0A7F9D04}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDDD7D81-AE9D-42EB-B291-25C7068E429F}','DM-{EED946E1-2E6E-46B6-BE91-860E37C2F468}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE1B1F3B-FF17-467F-82E7-6B133C9BA99B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE84F66A-73E9-438B-8B68-416167F2297A}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEBE077F-E15D-4D0B-A984-4BC83D99C003}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEC40DF0-E696-4BBE-A169-F9C5B6B586F9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF2B6E80-4904-45D0-A9B9-A858EABE2AB0}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFCD0775-E660-4AF4-8C8D-AF9BE4583CEB}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFD4063E-99B7-46E0-840B-338BE91B7D88}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFE09DF8-B624-4182-9444-831CC3022ACE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0675C86-6536-44A2-9A95-525B9A1A43AC}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F18B04F8-F2E9-4E3F-BABE-2764BBDEA7E6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2843F1E-29B7-49F5-A024-76600F57428E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F308C9E3-FF0A-492A-91E6-927942843135}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F32BFE32-F91B-497A-8093-B51AE9B5D40F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F497258D-C01C-49C9-B90C-7B56F081A1D5}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4C3AAD3-25C3-4C87-80E2-5E332E2AA8C9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F59DD05C-4397-430C-8147-3D77556FB3FA}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F67B3B22-903F-49D6-8983-976CAA1B7376}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68E9B87-702F-466B-A76F-D7FB61B2288B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6A288DF-A8A4-4785-A395-061660949690}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6A3374F-B710-4315-8377-BE53B6745B55}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F72DBA11-C0EC-4869-9322-762B30EB37EC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7C665DE-A6A1-4FCF-BD33-C95E81047D27}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7C7F02D-5456-47CF-8A90-94A45AC732A9}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7F7BDF3-360F-4223-9BC8-16FAE0BA1CA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8E42185-71BF-42DF-AA02-8B7D1CF86934}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA14F30B-5887-43E0-8E31-5264A2E0C8CB}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA532D1A-69D7-4A8E-B9BB-108A03344457}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAF934BD-0D93-4945-91E5-B860BADA9B1D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB23F251-104A-4236-B120-FFDEB1D51677}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBF760E7-B2F5-44C5-96F1-FB3FB239C150}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC7C057F-1A19-4FA9-94AE-C615ADF2D170}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCAF280F-152E-4A3F-BBD7-D37D21144BD3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD12ADF1-DF9B-424A-AB35-DA8CAEB8D3EE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD1DFCCF-942A-46F3-B442-F5D0F0969E48}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD249322-C193-4C91-B552-5620F5888F40}','DM-{70A5D4D3-9BBC-4E02-AA0B-D4A0161BE3BC}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE109040-C990-49C0-8C2B-B4DE45CF272E}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE7E70AF-71E9-43C0-8704-567FF1B3EA81}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FECBEC41-A715-4538-BA9A-0C43B2F98BE4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEE09835-9AFF-47A5-9DA8-3712990837BD}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF188BCF-5F18-4E93-AA5B-30E1D7D61F77}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_ch','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF599303-AC90-46EC-A8DB-430E7C8135A4}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_ch','global',255,'material','2025-03-26 14:50:20');
--
-- Query: SELECT * FROM ecad_guid_info.ecad_guid_info_depthmat_assoc -- Date: 2025-03-26 15:56 -- fr_fr
--
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{013A55F6-4000-4ACB-99EC-C29C1781A7DB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01B8729C-406A-47B8-82B5-B5621E7428E2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01DEDBD4-6469-496A-81EC-26EF0EEE07EF}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{023F0137-4B1C-4976-8BE2-27DC8225291F}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{031D5C42-5779-4F51-9420-5E040C9A6486}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{034F2D8C-CB94-433F-88C7-091EEF6CC96E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03B795EB-FE06-4675-B42A-14D9E148476B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C0FD9A-367A-42C0-A7A6-6E013B4DE4EB}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0453B249-D9FF-4C5E-9E1C-7C0E818A0C50}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05348E99-05BB-425A-B32C-D80A7F9F1905}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{058F0689-8EFD-45BD-8CB8-0FBCAAF25E3F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05DFCD64-1151-42E1-8F3E-376C6B1E88AC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{063C6A0F-AD91-4C67-83FE-60736EAF63CE}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0688522D-2761-49CD-BC37-501C9CE1F2DC}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06CE08CA-FB5B-459F-B4A1-0C0E1B8BC56A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06FA404F-F696-42D0-BE27-E98F17F004A6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07B9B859-06CD-4BFD-AAD9-0000877D7D63}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07C2F57A-6A46-4046-92F6-075CB576B84F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0956256C-EBCF-40E6-B32E-F6EC9123126F}','DM-{70A5D4D3-9BBC-4E02-AA0B-D4A0161BE3BC}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0971C7B9-2618-4F14-9B8B-7B28DA0EA5CF}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B585A2-8B20-4AD6-83A9-40F1B5A2F593}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AA7A0A5-F5B5-4268-8E50-2EF292840CA2}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AD5B426-A284-44F8-8156-D3A2824A1717}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AD87B46-E68D-449C-BE15-11AD8FBCFC43}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B3F8EF2-005D-46B4-B242-C55C1E4C2A3B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C1318A0-20A7-4306-B42E-AAF17256ECDC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5E10EA-8D7D-4419-B4A1-29ED37A5912D}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0CF49364-94C7-4196-B051-262DDF177255}','DM-{FFCD7994-238B-4812-8E59-D79ACE613A62}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D2D3309-2B65-4DDA-8BE3-9AE386AC02E8}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D9048C6-A344-40AF-8D18-DC5D95CE7D3C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D99E988-D842-4651-9D5D-63C0C86E4796}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E7B5219-EF3F-4A36-8B92-A14FD0E650E4}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EA9C493-7022-4686-A289-F2EF73EF93D8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EC0F9F4-36EA-4D93-8BD6-59197A16822B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EC26EA7-5DD3-45B2-9EA3-A86BB1C5F129}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EDA4523-6AE2-4F49-888E-4E5C65DD8105}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F0070C3-98C1-4D4B-9A3D-01EE4912FD66}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10140701-2314-433F-8EB0-094F7647821F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{107B3BFE-3B72-49DC-9BA2-ECE74023DFB9}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10819925-1CF9-420D-97E9-FBA457A2BB44}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1088BE88-C64E-427E-8005-048A12FC38C6}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10E0DBCB-995A-4BB6-9BE9-B9FD39FF939A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{123A70B4-9D09-44B1-AF7D-07D35B31DA6F}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{128F362C-D510-42EE-ADD7-A2EFDBB02508}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{132B8143-3261-4E6A-A232-A2E0257C968A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13C75F99-D541-41E9-B910-659EF0D68984}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1486BEDA-91AA-489E-BF20-187849B58657}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14D15918-246D-4D3A-930A-F0F8F5044B31}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{157340F5-2BC2-4EDB-9D2F-D40E4516DD27}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15F7D634-88F3-46B7-AD08-57817352DC58}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{165ABBDD-C32C-4BB5-B547-32FED8C367F4}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16D12E0A-D4E8-4BE5-A27E-5F4289C1CF8F}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16EF5E6B-B353-44A4-B860-0BDA014CD82F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{185A17B1-2282-4FEF-A85C-6F1CC6C1A166}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{189147C2-3AC6-43DF-948B-410C24AC6351}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A07A875-A3CB-4036-ABF4-D70E150DF98E}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A0ED450-5A69-47C1-B36F-EFCD6B9EB3D7}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1AAAF178-44B0-4B38-8F96-3DC7ED69A04A}','DM-{0A891D45-D04F-46D5-AAB1-97A917A485BE}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1ABEDEF5-532C-4D8D-912F-022C6E427C7D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BB5213F-2CAB-405F-A2F3-69654C64A73B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C7E162A-45F3-4069-BC12-4EF8646A8045}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CDD0386-45E8-4CD2-A3E7-337DB8E8BDBD}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D05865A-2215-415E-BBDE-66026FC6722A}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E106A14-D6DE-4447-A1D6-4EF365E5F8ED}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1EB99C43-0FB4-4430-9B4F-30D2D931D514}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FADC367-7C96-485A-8419-5CD5DF34333C}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FE32AE5-67CB-4D52-A98C-63F610106D1D}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201F2790-E4FB-4745-9135-338BC2F1D1BB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21A96072-8BF3-4686-A319-91CD708DFF2A}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21AE8AA4-F2FD-46FC-8D89-DD2E72F2783C}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22211E3C-94AE-4C16-81BC-EE11F5C9652D}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2290DE9F-9C0E-489F-A530-BF5435A14EFB}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2344E331-515C-4F13-AF07-AD93A175A6C6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23EF0B0F-F040-40E9-9E90-3BCD590E0D0E}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{252BAC70-D557-44E1-8323-3E07E02D517A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25378106-9905-4407-9954-7B2E21A37B18}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{254E5D09-FCD0-40EB-B962-AB2E1D144367}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{259047A9-D1AE-4215-9745-C82947BBBFED}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25CB502D-3E3E-47CE-B969-F2F6F549403C}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25DEA72B-0D9D-4663-8A23-95FCABBB14EE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2704793B-9C4A-444B-955E-16D6C5243578}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2784E67B-7258-48B0-98C4-6FF00DFE7C3C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{278590EA-2289-488B-9F12-B76023B51080}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2796CCB4-EB20-419C-AFB7-A14658D080AA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2849378B-3585-4541-995E-8974967B7FBB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A2C00F6-2D2B-4897-8189-2F3419153D33}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A32D430-6200-41E7-A4CF-811A87C1E90F}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A5C988A-70F9-4DEB-9C81-CDAEC2303A48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2BC8CDAA-587B-4628-A132-E8E59AF407B3}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C061F80-4E19-4659-BDE2-CA0AE9E2B1A7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C1218D7-20F4-43B5-A62A-C43B0D5D3735}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CD3E2C7-47D9-438C-BEA3-652D0674D51F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D35B4B6-D647-4E37-B6B1-BE3BDAAC2D19}','DM-{7C233D59-3200-412C-8F51-E7443767F1C1}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D9B62FB-B29E-4C8F-9BFE-E8EB443AC451}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DFC433F-63E0-481F-9EA6-C49E7D242DD6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2EC46512-7ECC-43A3-985B-54208CDD9AAA}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3EC7FE-1A9F-4207-887F-4B00E6A3940E}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FD5CA78-114A-4F9E-8FBD-1E2A81E38F6F}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FDA7CFA-4859-4059-9C35-904D4B975C6E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30FF6C10-2047-4F8E-B7E8-71BEEE581DBB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31DC0CF3-BA61-4E92-AA86-7B9A9EB73645}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3222CD3F-71A4-4682-AE71-136DB65ACB0B}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3249AD93-2FFD-41FB-BFB2-30EC2F142229}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{325F34ED-8A77-4685-971E-1953209B4172}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{329A9EDD-FD2E-4063-B3D1-AC966F9EC6BA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32A986AD-037B-46F3-BA69-976C257A0334}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32E69993-59C5-4A58-9389-95C685602E53}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32F8BFD7-BC40-47C5-9543-0A946BCFA57A}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3350B229-77E2-433E-8BDA-DA9E00E5CDF9}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3369592F-BAB7-4D01-B033-3EE9520BA7BC}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{33B8D962-3175-4028-88F9-318C790D014E}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345826EB-C148-423A-8F88-A97B9068B506}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3673E3A7-F5B3-46EF-8C04-BCFCD8C71B86}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{369701D6-4D30-45AE-A139-64DBF7D56681}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3711A6A9-DD71-4AA7-B408-7EE295613382}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3723BE0A-F958-4CBC-9487-542E78C1934F}','DM-{98A4AA64-3ABD-48EB-A143-EE06E34C9D12}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{379B5480-B36F-4AE3-92CE-FEC0D81260AD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{381584D4-A6CC-47B4-9B52-13CFEFF918B9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{386A07A8-529C-4A52-A79F-ACBF41EE9511}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3917E742-0636-4124-888D-BBD1182EE00B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3965A62E-AA5C-41D9-A3A5-A7FB149B3B95}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{396627CF-585B-45FF-A95E-E60430313FE5}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A0E810D-459D-4016-BDB0-526932CEEB76}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A8485B5-8107-4D84-ADBC-68846F716798}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AAC0000-FEA1-4009-A27A-0F17A31D9ACD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B7CB639-F696-47E4-AF44-53CEC2C18B59}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B87E3A7-1A5E-4A2B-AA0C-2B306CC3DFEF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CB26AA2-98F8-49CA-8D0C-3D3DA3C0E928}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CB53B5A-A8F2-4EDC-957E-3C9E360A11DF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CC8B132-B288-44B9-811E-08467256B241}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F2306FD-1C1B-4C52-A305-45EC5338932A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F40B4FE-D57C-4F42-BBC7-08D995F80B12}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FEFC426-F428-4DD3-92FE-F3526EE7AFCB}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40867852-1B7D-4745-ABAB-DE907F1FF2E4}','DM-{F51CA4BF-6614-4714-853E-66909E6E5D53}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{419DAF6F-269B-4275-B13F-220789D62AD7}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{420CEBD6-9760-4761-B7A3-724FE8743952}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42526318-0B04-4D0C-B6BD-4962BFEEF76A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{43D71A25-D40F-4CCE-B0E5-3A03BF7817CD}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{447AF20B-9A6C-447F-BE3A-0FF18E032B8F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{450BD1DE-CDD3-4F9C-9567-B8E9C4AB5560}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4533F347-DE17-42EA-9193-500FD35AFB44}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{453A37FA-212B-4037-88A2-EB4B355AB1AB}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45502421-10D2-4857-ABA1-71097253EBFC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{455F14F4-CD2F-4C73-8D7E-D3D207B7959C}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45684AE9-65FD-44C9-912E-9E3E19482C17}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4585E783-628C-4FD6-8565-F07FF7A9DA31}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B56DD7-E158-4B07-BF26-A1D02B339535}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47585E30-EF01-4949-B527-2360697ACEDD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{493DE1E6-E61B-4466-B1E6-1F3751319D2E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2D5DF9-7F32-4945-A847-7A2C39B51165}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B29A292-1B1D-42B7-BF8B-A3878331B3A5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B4CF12D-CA3D-43FB-931F-1C7FB87794D8}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BD2709B-0FD2-4B85-8C9F-9ABF7DBB8C93}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C6EB41F-EBF8-4051-9588-2C3DCA5B6481}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CC57D0B-0A66-436E-A566-E8A5D0B51D29}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D01325A-291B-4D13-8A1E-BE21D991F393}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D32674C-59A4-4D8F-9525-571473530B7D}','DM-{3590628E-C3DD-4623-8D65-052EFC3286C3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D4899C9-DB69-42E0-9974-83D72F7B47E3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E294F45-6B56-4316-BFE2-509CC3381B69}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF731D5-4A7A-4245-AF6E-D9A8E0060855}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F471332-CE48-4861-A4C1-48D502B8C8BD}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5031376D-AF83-4460-AF39-748CD596F3BC}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50533D05-FD9E-4ACA-B598-9D07A5B0B777}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{512F92E0-EBA6-4159-A231-E948DE3B7C54}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51A8CBF7-F6B7-4064-9ADD-BF09B97768C5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52477A94-71EB-47FC-BC83-46CAF3B4ADE9}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52672D77-4E78-46C0-9316-2CD7E079373F}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5282B47E-ED1B-431B-8A0F-A278A1574DC3}','DM-{20394B8E-F36A-448E-8D22-29E35156C798}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52F00B0A-C54E-48BB-BB99-F4BE62C71EE9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5426C1F2-E402-4450-ABE1-5AB16F072470}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{554AA962-50E8-418C-A1E8-39CD1756D31C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55BCF770-CEE7-463D-99AC-7DFFA0F40BD5}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5680D2C7-B8E1-4A57-9EFB-1D1A19C69DA4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5749427C-6FA0-4315-957B-7FB88808D903}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{574AC0F9-3B7F-4CFD-9F64-0A69C8F73D7A}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5780EF7A-4496-446C-89A1-7FB802E25932}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58127D79-FC94-44B2-8BE5-34E64E558A9F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58919727-32AE-42CD-A13B-407F43743152}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{593C37E5-2FA7-4D6C-916D-CE0F0C9A8608}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{598B66B0-D625-4D65-9A62-81EEED3EE7EC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59E5DEFC-3323-463E-907B-4BD9C58F6F41}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5A93015C-60AD-4226-B736-7896733254C3}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5ABC1F63-716C-4A0D-A737-EF6E89B236A2}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B30D489-BEC5-4BB0-A0C0-735540B431FC}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B61F5E2-A0DD-4F7F-B1C5-192416C26D79}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BB5B4B2-A9D4-484F-8F63-CC9401D24855}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BC572C5-1EE9-40E3-98E4-1BE15D69242D}','DM-{FBD41200-41BF-4DAA-8547-0B5EC5ACE67F}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BD77517-0266-43B1-8B36-6C09C5E8C854}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D2C973D-8125-4E39-A1FB-548025262464}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E85FED7-885E-41B2-B856-885FA1070E0A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EEE467D-BDF1-4D1A-947E-1D3129BFF6F9}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F87F34B-051A-4411-BB01-3A0F365A568C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB983A8-BB57-401A-B5F5-7F7CB115BAB3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{602766C4-FB19-49C7-BBD6-9AC2F54B6AB3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60337298-38EB-44F8-8457-4D2952D2B8A6}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{607AF520-E16C-4986-A1E0-27AC43B843C0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60AB10E7-4BD5-4825-910D-E814176889AF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{612C9C33-BE02-4FB6-957E-123D831FF7D9}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{618E8CB7-69DF-4C5D-81FA-BAE170EC943A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6192EF9B-04F5-450E-98D1-D2DE4BE42E36}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6217FBFE-CF69-4403-9A93-0ABF18D5E349}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62605FE4-38D0-4EDB-ACD4-67F6F4475909}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{635FE4EA-4634-4730-A4FF-48408D1EAA32}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6371FEFB-8D9F-4425-B38F-9C930AEFDB21}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6469F660-4EE1-436D-9E34-B87089AE8C75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64820016-06AE-429A-8855-FCB5AF682DA2}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64B5C253-EF99-4574-B3BF-59689C15D3D4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{652ACB35-6DE2-477B-A5FE-55A007B42A21}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65A573EC-012C-48C9-89C2-5F5F36DC6EB5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{662D1329-57DB-46D3-8EFE-7383413509C3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66D375E3-65EF-4C51-BD95-BC98F78D8A3A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67360D97-0ADA-47C6-9614-6304506A16CA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68A47539-7041-4B46-8AF4-8A93684685E6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68EBC788-7FCA-450D-BF1A-CCAB04027653}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A23C638-0EFB-48FB-BF26-F15DCC98E9B8}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A72116F-EB2B-40AD-81E6-BF45AA782716}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BCAF8CD-636C-4E34-89F5-A4FC20CCA49C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C1C51EB-61D2-4B0F-BCCA-7757CCDF116F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CCDB136-7753-4D64-A332-9AF769971AA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D35993B-C750-455C-9D19-78F8FECC255C}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DBC00D2-3696-443B-A755-B959CF53F576}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DD14FCB-6AEB-4D15-B4F1-ECACEBA3E2FB}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E0ED961-8ADE-421D-B750-A1A16735FB11}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E8246A9-359F-4DE8-997A-F921BB5E9F86}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F88F0F9-A57B-498B-B794-0E828B5CEA54}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F8BC682-F8E3-42D3-B4AA-31B9378DB596}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6FEF1539-BE05-4629-971F-62705859CFF7}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71015ADC-29B0-4C2B-BC38-FBD6730AFBB8}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7161F599-090E-4660-965F-E0CDCC2B767B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73237BE5-12B2-449C-9555-5ADAE0C1DC75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E369B4-4756-456B-8A9F-F1639566ED2D}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7442A778-81C9-46EE-8BC6-72E129000601}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7465C201-EE34-4ACA-998C-2542AE71A902}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7607871E-6D9B-49E8-9E85-2043093F232E}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{761CBD3A-1AB5-4AE1-8EA3-BFCACD619684}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{765484F1-938D-47D5-9C91-81B5BAA5FFBC}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76971A77-5E5F-4BC8-AC49-887CFFC13ED2}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76E692DC-A046-440E-9658-E038B2D0BF6D}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77069B61-B743-4226-B9E7-EDD2EB1E116A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7765E69E-EB2D-4ACD-819C-7CEB800CF950}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FBBB0-B4D7-4916-B9CF-C79F2B131944}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77D3F184-7717-4291-ACF1-7BD440009535}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{784845FB-8235-4035-8F4C-C9FB5CFC8300}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7853E799-6091-4BB2-8A3F-B71E9B040ECB}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7951BB0A-9F48-4121-A3FA-BEA063A058F9}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79820EA5-049D-4FF2-8305-0CC19DE96D10}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADD2B0B-BF77-4BDE-8B52-7AA508A44425}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B444EC9-1221-4964-B653-0BEB65024D3C}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B5D8F6E-20C6-4F28-8D95-409B6863F56E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B68DB35-D03E-4467-8135-C061DD44755C}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C1190C4-1C1B-4BFE-8E2E-8C5B0B2CADCC}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C16DA38-9E51-47D3-BBE8-FDEE60D74CE3}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C182F70-28D4-47BE-8F85-25EDD115D9FF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C9D1296-75B4-4948-AC9B-2314FBD8F47B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CAF2DD3-7530-40C6-ADCA-E18CBA80F591}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D47751F-CDCE-4671-AEF0-80BB790205B2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D8D041D-CE45-4E83-8593-BF8CA3508984}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DCE3B42-B189-4697-AA87-AE25F3004172}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DD58DD6-6B51-4215-8B9B-5800CDA6016D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F2BF1AE-B2E6-4D6D-89FD-DA49306AB310}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F41D0C4-A848-4B15-9AA9-98D9B74587BE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803A22E9-DE76-4217-887F-0DE14C2E55EB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{804AB273-52BE-421A-9F3F-A8D0FAFDC33B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8100ECE0-5892-4A50-BA51-F280645C686C}','DM-{8CB66F39-EF78-4E0E-AF86-C4DEAA85611D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8128B37C-4AFC-47C7-8828-FFDB7AF81585}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{812F48DC-B907-4998-B21F-44CACC469697}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{813AE174-47A3-4160-AD54-4EF81B55AA67}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8145EBD4-2FE3-4B79-AC70-C9E2F5CDA55C}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{815DDBEE-CB9D-48D8-8D20-D617EE6E5E5D}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{818A2AA4-DC4A-4D9C-9766-BB4C638A1A71}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81EE5064-E14F-4051-92F6-CE3ECB0A0ECF}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8208505B-79BD-4002-9245-81FBFC78AA0F}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83438D0B-645E-41C5-AD43-DCC5443DB775}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8372D589-D2A5-444C-A3F6-1FE0B0C2DD82}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8382012A-5DB5-48D7-8CA9-F98F11D10B61}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{848D2DEF-DDF0-4A1F-AF77-6B7A1E03E231}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84AFF4CF-3F3B-4C58-8C5D-FFAC813E06D4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84B4F24E-C567-4B33-B00B-BBA3C5137AC2}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84EA04DF-B4D7-4FAD-A551-C2FD48956DA5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85641B10-465C-4478-8BC7-16C4E2879069}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85CF75CC-7475-43A2-A87E-AFE9C120728E}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86750902-10F6-48A4-9323-9699DE631450}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{876B4E43-CE8F-4937-8BB4-0C129C052785}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{876E98E8-B56C-45BF-8AF1-81EC4CE9EB88}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88705A04-16AD-4A7E-A0C5-BD3EA3E14003}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88A43A04-F782-4D23-BA7B-7E5031B002D6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8953C11C-41D8-41A7-B221-4DE307EAD2AE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89685A64-57EA-4C05-9B68-550CC46D73CA}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8969BCE4-FE61-4EF0-8C97-D653EBB2D70F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89E52080-8511-457E-A5BB-B06608AE6947}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A6FD0C6-A92C-409E-9EBD-32C1842AC4A9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B18BA07-6877-43E4-8E45-6BFE8BA2368E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B609566-2AC2-4AEF-BED6-8B4D821628D0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B9BF69D-22E0-4C0A-BF8C-F7C66C2F4FB3}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C464613-50EB-43C0-A8D9-F101E4E00B1A}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D7553CC-C3A3-4426-B98B-C6FDD7EC932C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8DAB21C8-D35E-4CB2-B19F-6A91939C43ED}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E19D3FF-3C57-4735-8C53-2CCF37411BD0}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E4B1D15-16FE-4B72-B12D-3C1690C04A3B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5280DE-8F30-4AC9-BFF2-94809EB7ECE1}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5743F6-3C67-4911-817A-E1A346C7B466}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8EA57574-D023-4EFA-A887-EBB3DF8034CF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8EE0EE6A-1B34-462E-9D9B-4081E0BD27EE}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F9547B2-D293-4173-9490-A762DF9F1143}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FC52B7D-ECE9-440C-B220-D026C50CCB1B}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9002111F-10ED-4503-B9E8-BF6632C4F0F1}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9044C7E4-EFDF-4101-BF12-41E6BF9C3A4F}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{907913F9-63A5-4D89-B507-F477B7E596FE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90A90C81-BE96-42B2-A5C5-443B4394353D}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9151535F-02AC-4DAD-AFC5-E40ABB61D48D}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91723F16-64F6-40AF-96B4-CC595C313834}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9198583B-0F70-44A9-BB2C-0153CEC9E7A3}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91D4F5A0-279C-4684-8EBB-75C32DA85915}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92244F82-C4A2-403E-A3D6-5298E3EE6A8E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9272C2DB-9EDC-416B-816B-05FBA304693A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92A67EE4-2D86-4B91-A261-FAE231B79653}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92B88334-4500-4EBF-9E26-D8B210BE282A}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92BB3948-2EE7-4A85-92A2-8D676F52B765}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92DDC4B8-AA3D-491D-AEA0-CA6A1FDB8517}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{938E52E7-9CEB-4493-BA85-7B13D1E2CC7D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93F1B0F6-2A21-4DF0-ABB1-ACB97C98A386}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9404D72B-223F-44FA-BE5E-8629E82B3E5A}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9413835E-1EAB-408C-B463-A3EE166C7B12}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94BCA705-F366-421F-A594-A82DC639DF6E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94F02505-0A59-4DCA-B7B9-AE27D22321FA}','DM-{FFCD7994-238B-4812-8E59-D79ACE613A62}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95288D2D-85C8-4830-ACE1-57D6B3886E2B}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95B50FC1-4F55-4716-A897-974E7FB9593B}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9699A615-E3E3-48AB-8047-FE1E21504B8E}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96FCCB87-1733-4CA2-9964-F59CFB1E0AA1}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97B26F83-5DE6-4680-A891-028CE09B71C6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97C5C812-E717-4AB0-8CC5-0F9CD83EACE1}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99573DBE-B4E2-4292-B834-2367FBB2EDE8}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99A3ADE9-B3F4-49FA-A04C-595CD8E0FC5E}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F2B469-455B-4D9A-A519-126D440E5026}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F2ED0B-12A9-42CC-9974-8A524651FAA6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A0715B2-05A8-44FB-AC83-EF5F2CF80E9C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A4C50F5-1AE2-40E3-9C83-DE3B603DE781}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AA4E2B3-09A5-4FA7-886C-D834760024C2}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ABB46B5-F8DB-48EB-ABF1-98AD9AF7446D}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B0B0F7C-AF2D-4B09-9D09-F6144F8439F9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B1EEBDB-49DF-4D61-B1F9-931DE7831492}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C426CC1-A720-4F28-836A-083A32D99055}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C70FA2D-84CE-4342-9874-02F5B11E1F48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C9F9418-B54F-47D6-B914-494C2A64622F}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D6B0966-4A40-43C9-A3D8-770766D7C5C5}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9DC03E67-9C03-4C8E-A0AF-8E2C2B98ABA3}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9EF8502E-A5CD-48DE-8406-B4A6D1D63116}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FBD942-1EAC-4A5F-8BFF-D0534EA2EAF7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1F23CF5-F8EB-4296-B75A-55F8D262EF66}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A205D5C6-0D8E-4DBB-872F-06323A5AA742}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A25A7494-0451-4726-895B-7ED7F97D201E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A265C466-3DDC-4674-BD67-3EFAADAD91E3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A29229A2-4D50-4767-8F92-35C90C2FDEA1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2D62CC2-09FC-430A-9380-CF69F8B32A88}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A369DCCE-6304-4B7E-9A9C-BE771AC8B240}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A43B747F-39DE-47B1-A1DF-6D47217F9802}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A470B687-6C43-41D2-965C-255749F85CA5}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4889965-5A1A-422C-84D0-0BAA0DAAD99D}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5192EA7-AC0A-40B8-BDC4-69025E55133D}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B0B937-A8D4-4EE1-9EF6-CD798C737FA6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A60C3856-FCE4-462F-90FD-1289607D3CBB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A622D361-D637-4CF1-A969-A2F8D2BC00E9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A748CE42-351D-4B91-824A-223D7C031400}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A757D97F-9597-4E45-9C13-08840FB7DA1C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7A07123-CDD4-4EEA-AE43-9619AB85CE12}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F2E903-B656-4EF0-9B76-A51FE6A5761C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F80B82-5EA1-4546-9695-A496F4F9B248}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7F88127-3531-4DAF-B7E3-4F70CE7EAC22}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8176A03-FDB2-49A0-81C7-503964F4BA98}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A84D0AD6-7083-4870-9A1C-F2CB9E501ED5}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A84E97BF-7EFE-4F69-BAE6-91659A5BA7DA}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8965A79-F9FE-41FD-BE74-5D5308483787}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8F0D4A8-38AC-407E-A8D7-CC0AA1A82C7A}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A98CDCD3-6859-4698-A970-A2C708796067}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAC7EECF-D680-44FF-9CD7-DE05EF84877D}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAFD8BC4-B2BD-4354-9D61-4A341FECE947}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB4E8CFF-7E01-4941-9B90-69F8A4CF8311}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ABFCFCA3-192F-4537-AB92-8594D5BECF7D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD2D0064-5FD7-42A1-AE38-5346C9C2F13D}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADF8554C-71DB-4158-AD89-5B7B49DD1B6D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF0AA43D-B846-4F7F-B391-648BC94B703A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFA4AE24-0EE2-48D4-8AA0-C086861DB6E9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0B3D907-8417-4906-AC84-631A9F611BAB}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0CA7021-5D71-45B0-A95A-796EFC499F75}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B11B65F7-E741-4087-B181-A176074EA037}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1752315-6F05-47A2-9D61-FE51A0A9F2A1}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1DCAF03-E201-4A8E-8BD3-4B9996FA94B2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B27CE8DC-8D1B-4A6B-B59B-BB80308383A5}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B39ED600-A99B-4F59-9CD8-26E60C76D2B4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3B857F3-25E7-45CA-A912-9D058CD1C0B1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3C22394-DDE7-40E6-B761-0ABBD985674C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3E8168A-B5C0-4D44-A83A-E7699B48D1E7}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3F8086C-B903-4002-885D-EC5056853640}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4560241-B2BE-45D6-8A0D-8C7D34236A50}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4C05CDE-A412-4F4A-9C86-7DA06003699C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B51DBD64-5D41-4CD4-B096-67705D7FF096}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5577D0B-F1BB-426F-973D-C029858AAFED}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B60D264F-AA63-48BD-A710-0648878A034D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B78EFFBA-4AE8-4248-883F-CB0C0778FD71}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7A09602-A506-4CB0-B133-66C17C3E441F}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7B9257F-ECF2-44C3-9059-680716367BA9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8714D24-C4EF-4AD8-9770-BA02E79D45DF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8FF254B-9412-4364-8B86-94DFB348A276}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B911312A-B11A-4345-8FEB-3F5624AF1B5E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9BDA79E-7CA2-48ED-8051-CAC167E2E7C3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9DCB46D-01B7-4CAF-AEA7-62092B327B2B}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9F8C849-30EB-4E35-8C3C-9540A3FC4551}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA936C3C-C9F5-42D2-9FD3-69BF0C1C7927}','DM-{A30D0983-50B0-49E5-A7E2-0B9BCF1FCDEF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAA95E61-E796-4B79-9E9E-0BA22E94BBAA}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAE32058-C975-44FD-B8D2-27B06733D557}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB084D08-D737-43FD-82C4-EECA5659090A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC2C7D6D-4C62-4EBD-B5DB-3B0945EB6258}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC89B42F-37C1-42CD-BCFA-AE4682391014}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCD62094-60C2-4392-AC4B-E4094D520DF9}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD42EDCC-8BB4-47AC-AAA6-CC5297A6C635}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE1EECAA-F68C-4A2A-BFD4-57F20141DBB4}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE20D980-9935-4DCA-90A7-2C6D7AE555A6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE244C39-BB39-4434-A75C-CCA312A018E0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE640FD0-B116-4B0C-ADC8-F124ECC2AD95}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE6935B3-945B-4E5C-B298-B3BBCA2F559C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF90E5FC-44F0-4F88-B06D-E2EE019900F8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C048BD2C-7459-43F8-AE03-8AE60F47D071}','DM-{0A891D45-D04F-46D5-AAB1-97A917A485BE}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C09359AE-CFB1-48C1-9A6A-7EC55DFEDE47}','DM-{FC83166B-243E-4049-945D-61A48973F305}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0DF20C5-336D-4EDE-9BEE-E8850541E834}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0E58FEF-29C1-4FD0-92F2-89AEAE0850A3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1304ED6-020A-49BB-A915-2E8309DF0FF6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C19E0EC7-0217-4C7F-8960-BF578272C730}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1B8AEE9-151C-48C2-878E-3F9AB23CF96A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C217A71C-69E5-48A8-BB69-43A668D0423B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C25C770B-730C-44F9-A846-3020177F7AFB}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2942EC3-0A5B-40D7-AB68-C9A6D61E0F11}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2BD4489-D7E9-41DC-BEBA-C60DFAF51FA4}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2DDAF5D-26BB-479D-82EA-0E9290CD377F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C30929F5-9012-470D-B164-772666D75E63}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C35F4DFE-3178-4BE8-99E7-234784B37D1C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A129EC-ADE2-4E58-8D0D-07316751D2A1}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C40CD3EA-61D9-4ADF-8F5F-5666030F6713}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C440CE4A-605F-4469-8261-797FC6AABD1C}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C53EA29D-9450-4EEF-A92F-DF2C2D0455F7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C59F24C5-E1FE-4F1F-A7AE-0D6C93B230C9}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5DCBE07-BE3B-4FD3-A16F-8157D0800867}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C61058EC-CB5A-4A82-BF4E-70A2535F5D29}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C62DA86C-8D05-4FEB-93D6-4C58F87AC953}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C643FDF1-7BC9-4C64-B291-2AB16FBC728F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6457428-EC5F-4905-BC67-708EE7CE1B1E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7047950-3E0C-402F-8DCC-DD70966894AF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C75BAE23-BE41-4A34-BEB9-402633B93BDF}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7C0BC70-99B9-46CF-AC41-F132FB8D793D}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7FFF338-6CDA-43FD-B6DD-63FB7FD65B75}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C85EF661-D847-4F6D-AE9B-598B522F5ACB}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA16C89E-FD52-44CF-BD64-C6DC85B7DA34}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA897DB0-ACDB-49E0-99CF-33244EA92111}','DM-{4F247B02-2497-44EE-8001-A125AF5FCD7B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA93B71C-6477-4CE3-8310-D6956F2C619C}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB60CFEB-8603-44FB-A9FF-F517655030DA}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB82231D-0B21-48D0-B0CE-16C9123EFC28}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB9D0A0E-242F-4EE4-858A-025A7921FFC7}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC614A5C-1193-4A85-937A-6872E5FF5A48}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD0E2E88-8FB0-4A65-9C4D-256454BC1A0E}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD69F29B-C442-420F-B829-E95AC2F46C53}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEBDEC3F-C089-46E8-9957-125ED85F1D66}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF276236-22D5-4C4F-9D5D-72E141BC1468}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0258F2A-4FF6-4E90-A690-A463258BD6DF}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0766575-F2E9-44A4-8A18-2AB18C093B6F}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D232FF65-C798-43FE-956B-58F2B1DD0A2D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D25E8DFE-E5A1-4C0F-8942-B9FFB4DA7AA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D289591E-7635-4DFD-A00E-0DCF6628DF8B}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3226FC0-5487-47D0-AD6A-C5099C159541}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D41A448B-2219-41C9-BFE0-A8B3B05081B3}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4EA8EA7-654D-4BB3-9605-229349F4A043}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D51D7359-7B32-4917-A2E6-D9685ECF8EAE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5B9D33A-CAB3-44EA-A53F-0B355D8670EB}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D761C071-1709-41C7-8FEB-446A94F60662}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D765132D-E29A-4701-94F1-0FBC9C3614C5}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D76D0964-4190-44B2-8AFB-0D7CD79A616B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7796927-29A0-4D6A-9D08-E625E4635A8A}','DM-{5A1C54FC-23DD-482D-80BE-D1EFBD20E096}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8467653-3AED-44F1-84A1-D11A8AFF9E02}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8AF7510-FEF3-41A7-A860-FA0E04EDEFD7}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D91BC45D-19E7-46E7-AEA7-BF82DDFBF455}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D95E4D14-B8C2-42DF-BD50-60B0D070D648}','DM-{C4667FA9-7BC8-4919-AECC-7C8496F6BC4C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9F3D36C-52BF-4674-9BAA-F6E3D7E5EA4A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA0EE3B7-CC8D-4A97-84F3-07708699095C}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA282BE6-F7D1-462B-9600-74C68513AB13}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA319486-CA79-49B1-BA29-C9D0560278A8}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA5BB312-A688-4011-B2A0-323EB6FBA6FB}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA703329-716B-4CDB-A8A3-F1076E488861}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA904835-9828-4ACB-923C-1B77615ECF26}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAEDECD3-765D-4C9B-B790-F30B2A96978E}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB35A850-E850-4757-9B27-3072148A17CF}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBC79D3B-922F-4EB7-9126-F70721E7C526}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC74C392-8B1F-4B7A-86A4-EF55182FBEF0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD8959F6-24AC-4758-BA05-C90D0D8E1C15}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDA5BCCF-EDB2-4474-BD5F-EFA9DE54B87F}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE4B57F7-CF8C-49AF-96BF-FFAFD0DF67A5}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFB7D180-79F3-4512-9A85-D9CB4F105FA0}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0670956-BE3C-43CF-AFB1-79C7AB24F043}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0C30B7C-8CEE-463F-AC9B-7A27F0FFA199}','DM-{BD3DC34C-2144-4DD8-93AA-87417CF5E0A3}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E0E51FB9-B590-4ADD-AF36-11B6B194891D}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E12A0345-BACB-4C30-855A-A339653D5578}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E17319C6-32C4-4A35-97DD-EF5E4046238A}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1BECE8F-AE8C-47C3-80F4-B84ED408EB16}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E262A864-23D1-4C28-90D4-E3DBA6819D77}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E2695100-8BD1-4665-8DB0-2640B79B59D8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E358324A-4A5A-4FD5-A4BE-5B612CA861DE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3C23DEB-02A5-4CAB-8A8F-2A4D97D40A4F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3E90D85-A006-4D60-9C68-F330A04A1D0B}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E412AC24-5677-4088-9A1B-241F0E7F0F37}','DM-{519F85BE-312C-4D0A-BB64-4C81E187A03A}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E52D609B-C8AB-44AF-A313-650ACA757EFB}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5D80C16-CEE4-4D8A-A3E2-F79687C09218}','DM-{C3D4E353-AF7C-4B5D-92FE-11EB4B4FD9EF}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5E5CBB1-0318-4518-85D9-277CFB509E5A}','DM-{FA732F26-2691-41AA-A605-3996D725095D}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E65A1DB5-3CEB-494D-BE91-FDAA60E485E1}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E846DA6D-8A93-4903-98F4-A4D5B083B5CF}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8F50454-ECED-4E25-A1CD-B384B17DFA92}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E92C87C5-D139-4625-9C8F-18D04DB6B0D6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9AB9B81-51BB-44D4-999F-529386858E36}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAC6EA8F-B372-443F-A503-5AF6F55E15A4}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB8CE300-98DC-43E7-89F6-DA6050FD16F2}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBC70B60-3B02-4340-8886-9B4EF7AAF9B8}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC6384BD-85BE-4FE5-A7EB-B456616323AF}','DM-{45EE670B-082B-4F6C-B9CF-6BFFB2C48397}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECC619D6-21E9-41DD-B54A-2BA5D62D6C80}','DM-{6861C09C-9B20-44AE-B456-9F5E375CA1E5}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECC749BE-9C60-4D39-B7F4-FCACBC18135A}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED1DCA5A-3541-4FD2-A91B-C9AC2A33EF31}','DM-{39AEB5E6-D382-44B5-A5FC-05D8C5165392}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDA28E96-AAB1-46B7-A77B-1FFEF860966B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDBC8F51-0164-4291-B821-16EE2A26C834}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDD0BCDA-5E64-4A4F-AC46-C5EC0A7F9D04}','DM-{93215B39-99A0-4A93-9590-02D17F3445B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDDD7D81-AE9D-42EB-B291-25C7068E429F}','DM-{EED946E1-2E6E-46B6-BE91-860E37C2F468}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE1B1F3B-FF17-467F-82E7-6B133C9BA99B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE84F66A-73E9-438B-8B68-416167F2297A}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEBE077F-E15D-4D0B-A984-4BC83D99C003}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEC40DF0-E696-4BBE-A169-F9C5B6B586F9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF2B6E80-4904-45D0-A9B9-A858EABE2AB0}','DM-{DC342660-4C0D-4804-A637-253DA0A95C2C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFCD0775-E660-4AF4-8C8D-AF9BE4583CEB}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFD4063E-99B7-46E0-840B-338BE91B7D88}','DM-{618280B0-EE98-4B57-BACD-3B7729F636D0}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFE09DF8-B624-4182-9444-831CC3022ACE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0675C86-6536-44A2-9A95-525B9A1A43AC}','DM-{08D83229-50CF-4A2E-B237-824E1014EFB7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F18B04F8-F2E9-4E3F-BABE-2764BBDEA7E6}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2843F1E-29B7-49F5-A024-76600F57428E}','DM-{B849F6A6-6F8A-4A6E-8BCF-0AF4158B18B7}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F308C9E3-FF0A-492A-91E6-927942843135}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F32BFE32-F91B-497A-8093-B51AE9B5D40F}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F497258D-C01C-49C9-B90C-7B56F081A1D5}','DM-{0219D959-1B55-4ECA-82B4-A2EC2C47F713}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4C3AAD3-25C3-4C87-80E2-5E332E2AA8C9}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F59DD05C-4397-430C-8147-3D77556FB3FA}','DM-{18A6B552-4D6D-4A07-B39E-7827F020B153}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F67B3B22-903F-49D6-8983-976CAA1B7376}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68E9B87-702F-466B-A76F-D7FB61B2288B}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6A288DF-A8A4-4785-A395-061660949690}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6A3374F-B710-4315-8377-BE53B6745B55}','DM-{0CD4F877-C5B5-4455-BA21-14EDA7280710}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F72DBA11-C0EC-4869-9322-762B30EB37EC}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7C665DE-A6A1-4FCF-BD33-C95E81047D27}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7C7F02D-5456-47CF-8A90-94A45AC732A9}','DM-{65A21CE4-1853-42B7-BF36-4237180823BA}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7F7BDF3-360F-4223-9BC8-16FAE0BA1CA2}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8E42185-71BF-42DF-AA02-8B7D1CF86934}','DM-{BB4BCFFB-6700-427A-9E81-96C629B2501B}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA14F30B-5887-43E0-8E31-5264A2E0C8CB}','DM-{B4527C00-2309-4B99-AB6A-925CFEE12E81}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA532D1A-69D7-4A8E-B9BB-108A03344457}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAF934BD-0D93-4945-91E5-B860BADA9B1D}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB23F251-104A-4236-B120-FFDEB1D51677}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBF760E7-B2F5-44C5-96F1-FB3FB239C150}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC7C057F-1A19-4FA9-94AE-C615ADF2D170}','DM-{C6632620-BDE1-4C88-846B-0E024F06E7CD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCAF280F-152E-4A3F-BBD7-D37D21144BD3}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD12ADF1-DF9B-424A-AB35-DA8CAEB8D3EE}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD1DFCCF-942A-46F3-B442-F5D0F0969E48}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD249322-C193-4C91-B552-5620F5888F40}','DM-{70A5D4D3-9BBC-4E02-AA0B-D4A0161BE3BC}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE109040-C990-49C0-8C2B-B4DE45CF272E}','DM-{504BD567-B748-4C49-BBF7-681AD8812202}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE7E70AF-71E9-43C0-8704-567FF1B3EA81}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FECBEC41-A715-4538-BA9A-0C43B2F98BE4}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEE09835-9AFF-47A5-9DA8-3712990837BD}','DM-{12CB186B-F8E7-4197-87C1-F3B358ADD3BD}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF188BCF-5F18-4E93-AA5B-30E1D7D61F77}','DM-{59F0D0DC-075F-429A-BB00-2F9F0E540C8C}','fr_fr','global',255,'material','2025-03-26 14:50:20');
INSERT INTO ecad_guid_info_depthmat_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF599303-AC90-46EC-A8DB-430E7C8135A4}','DM-{ABEFFB7A-7BF6-436E-8A28-5697E2481B2E}','fr_fr','global',255,'material','2025-03-26 14:50:20');
