USE ecad_guid_info;

-- guid info for: preview image data for guids (1:n)
DROP TABLE IF EXISTS ecad_guid_info_depthmat_preview;
CREATE TABLE ecad_guid_info_depthmat_preview (
    guid varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,         -- guid (TY-GUIDs)
		region varchar(255) DEFAULT '' NOT NULL,                                     -- e.g. 'de_at', 'de_de' ...
    kind varchar(255) DEFAULT '' NOT NULL,                                       -- e.g. 'material', '3D', '2D' ...
    add_info varchar(255) DEFAULT NULL,                                          -- e.g. for any logical grouping    
    modify_datetime datetime DEFAULT NULL,
    image mediumblob DEFAULT NULL,                                               -- tif image binary data
    PRIMARY KEY (guid, region, kind)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values (de_de)
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'de_de', 'drawing', /*material - Beton*/ '2025-01-30 09:43:31', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'de_de', 'findesign', /*material - Beton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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'de_de', 'predesign', /*material - Beton*/ '2025-01-30 09:43:31', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}', 'de_de', 'drawing', /*material - Fertigteil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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}', 'de_de', 'findesign', /*material - Fertigteil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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}', 'de_de', 'predesign', /*material - Fertigteil*/ '2025-01-30 09:43:32', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}', 'de_de', 'drawing', /*material - Holz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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}', 'de_de', 'findesign', /*material - Holz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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}', 'de_de', 'predesign', /*material - Holz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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}', 'de_de', 'drawing', /*material - Leichtbau-Scheibe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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}', 'de_de', 'findesign', /*material - Leichtbau-Scheibe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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}', 'de_de', 'predesign', /*material - Leichtbau-Scheibe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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{154865CF-D3B8-4A84-A79C-B08982857291}', 'de_de', 'findesign', /*material - Magerbeton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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{154865CF-D3B8-4A84-A79C-B08982857291}', 'de_de', 'drawing', /*material - Magerbeton*/ '2025-01-30 09:43:33', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{154865CF-D3B8-4A84-A79C-B08982857291}', 'de_de', 'predesign', /*material - Magerbeton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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}', 'de_de', 'drawing', /*material - Ziegel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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}', 'de_de', 'findesign', /*material - Ziegel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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}', 'de_de', 'predesign', /*material - Ziegel*/ '2025-01-30 09:43:34', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}', 'de_de', 'drawing', /*material - Dämmung Ständer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}', 'de_de', 'findesign', /*material - Dämmung Ständer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}', 'de_de', 'predesign', /*material - Dämmung Ständer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}', 'de_de', 'findesign', /*material - Dämmung Linien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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}', 'de_de', 'drawing', /*material - Dämmung Linien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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}', 'de_de', 'predesign', /*material - Dämmung Linien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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}', 'de_de', 'drawing', /*material - Dämmung Trockenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}', 'de_de', 'findesign', /*material - Dämmung Trockenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}', 'de_de', 'predesign', /*material - Dämmung Trockenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}', 'de_de', 'drawing', /*material - Naturstein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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}', 'de_de', 'findesign', /*material - Naturstein*/ '2025-01-30 09:43:36', X'49492A0022130000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4BE07359C3FE6F399E4F67D3FA04CA77419550E8947A45268346A2532954FA8546574EA3D52A557AC4FEAD3E84D66BD4AADD02C35FB259653639CDA2CD6BABDAA6B6EB65C693709C5D2E577AD40AC17AB3C16F17FBE802A376C0616857CA46130D8B96E2A6D88C6646798E98E532586CB4B29D06CBD7F332ECFE76EFA1C0E8B4D95C853753A7D64EB5755D7EB745A4D760B1F04D95CF634BDDEE723B4DA6FAB1C0DEF0B31C5AE7238D7FE26DB51B8E5E4F95D2E774725CDEB677B1D9EBF4ED3DEEE597B734CE78661C1D2F9B17E3F5603D9EDBC7A36BF0C2FBFC97EFA7CEA1F2FCF7FAAD53FEFEAD6FB404F13C0B7C0F02B7500AC504A8AFC3D4F93F90530F062F30B428E1C1CDBC3301C36E7C3AB3408EA4270F43106C4F10A9F11C54FDC3EC6C5F16C1114B931A465002F71B46712B3D18B411F46F1041720C351D3EF23488EA30720493184910AC96E83850949926AA72AC791BC592B42F28CB915CB12AC9D2CCC127C8F2FC7334CD0C4CC3334D71FCDD284DF1C486AF3CAD3CA938CE707CF5274F6DE4FACD4C52E4F33FC51352C93BB2F42D0D1AD1146BFD47D2119CBD49D233AC4D3227B4652D4A5314EA672DD412BD033854733D3EB6514F7506FD54F214D952CDF5155F4E55F0E552B95575D55B4D4555A54F605475B56F3F572F8C20B8D8962D49495993E59D67D5D68D9F6153356D435EDB124DAD4EDBB4B597695BF6BD654F4CB6958D58DD1415CB69DD770DAB36B5B5DD2B73DD76858F78DDB5F4437859971D91295EB6A5FF795EEF4DD583DDD84E0F80559815F34061585D0F8561D435FD62E2EFAD933A5ED86E0D905F76DC898CD6F8DBD78ED1D175DB2FE5139E5F59DB596D0990BCD7A5CD826359B5DF9E5D19356B9F66F955B39A6297D67593E85A465989E62D9E895C63F7BE9F346AB97667A7696FA67166E9B8B6B79DE47A349BA0583B0BF3AEECD61ED1A0EC7AD68D7E43BABB735DED7506E92B6F3B2EB3B06DF6E421BBDBDB6ECFBFE4581E7BC36F883F119FF09B6715C4F1B7171F7EEA3896FDA4EDDCD70BC9E998666588731C3E23B1739C873D82F239872EBAE4920EF7C0757CA6E3D7CB5CAF16CA6E50CF6392F71706FBD2741E0745A2EE1D3EF1DFD27C1789E4742B87770A77BD879548799E5FAB35EBB7C784D86C9D979DE6EBFEEE3DDA2B7E8C15E9F6FD9F3FF0FB1F6754CDF6D197D5FA7B38C783AA7EF3FABB847F4FC1D33A5694ED5EFBBE80100D3E3DB811009CDC0C73AF8DFFBEE7AC6AE0540D786E3A03C16824A35FAA2D7CEEB5D440E84305DDA3A9803091F69B77D07B60EABF7F69EDEBC1383303D23C2B3B90B5CB43384706DFC43A79299A0ABA1878FF217BAC808F1E1143F4510D8DF4386E711621410725125C1AA5882F822A3E2850EAA1340B8B709DEF44C6A10FA2AC43860FE629C5F8BD186103F68C9169EF4486A71A638B9953115DE94507B51E9AB46883119A232CE8F07F6273BC8F8D6223C768D5069F2AEC8C4AF237BEF90114639C7F8B324A064833C32163CC91865176463A38231264D1D1938FA643B35912F925147491B0D5F9B019271EE4F41C8FD0964BC9F97260647CA075D015EA4B587B2FA1DCAF97122DA2CBD976A9A4547595933A51CC898B2B5404CA9A8C5667A5D99B32E224C29BB2CD521018000204FF824160D0784426150B864360B020043A25048844E2D178C466351B8345639078F47E452392495FF21934A24D2B964B6410392CAA5D339A47E651C9BCC621309ACB6731A9FCF68543845063146A25267B488CD32954F9653A2552A8556455486D62813B88D5A9B3C91D6ABD6389D8A1566B25A6CF609D576D56F9B5B2E36EB85D68F729C5E2675CBA5DA1F7AADDF6FD8385DA28B80C26264F888DE1B1555C7477198FBB646FF82A15F313968A64F2970CE62F319FC1E872FA4CFE874DA8BDE7ACBAE9766B2BB0876AF593EDA56773B7A7EDB6DBC94EEF0BC2E050F55C495ECAD5C7D1F16C9CCE75FB7DC8E8EB79B5FEBF56A1D0B7F2ABDDCED72FA92FECF8693D3F2F9B8DE3C97A7D54BF669F673BEFFC73BEEF7CD3C1F9C87DBDAFE3EAFC36AFF400BBC04DD40EA53BCA23F702BCEFF37F07410DC413092AF084090B4070AAD70E414AE41F0F30F11435033831244A8B3D114BD7143E51626B06B1505B630C45D1821919470E4C32D1476FD46D1FBAD13B791A488B6C851AC6F1F492A8C7B08C7F1D49AB9C8EE048D0BC9728477294A6C6C9F1EC932E4BAEC4AAE74AEC0CCB31CA9244D4B0CBF25CBB314DAD7CB3302AD33C5520CE735A492D47115CF6BCCEB384A7394AD104BD41D03414D345CF3424994744D365248BD0D335114B4F54AD1F46D391CCDF4FD3B4A54509D4902CF0F253D52C4755D58FFC9D484C34DD5F0ED5CFE55348CDD594854BD4B4056B5B54F60D613ECED19D3356D87623EF5BD6B6059962D7768D9563578D4D9366D976657D515A16A5752C5C1695C542D336ED3F745396FDA97552B7741CBE5E1475E745DD968DEB40DF3545B33E5C77DCE77BDB95A5C1805E37ECC971DB56B61585D9D57E0D3562309572E1DAF2DE0976D4386E2738E334962B556398FE07484FD1863B7351567E116161594C9B815899856795E6796DC98D66D7FE3797E499BE7792A7F93C599A57B9EE79A0E7587D591A68914E8D28E9182E7F60EA38C5E517E93A657FA9E976DE81AE5BC9E5E563EB1B15D3AF5F1AAE59A56D6C1643B1EDD92C2986DC37F6A9B9EC30EE9F8A6D9886D5BA6C1AB6FFA6B27B8DF5C2EBB936CD3FF15B96D175B61C4625C7ED3C662FC76F5C2737B6BB1BEBB5ABF35BAE47CEF01D370D0F729A9751C5F499F75BC8707CF4B1D036FD1651C0EF78674BC8DDF1B76D6C763CBF5FADF67D3F7D904DFE0B37CB725CC6EDDC68BE777FCC7575C7A9E57A1DEF8FD4F937A67BEBBCDE96A1DD739EFDEDECFC1EDBDBE639FF57D3F678DDE761F4713F93C9F73FBE1F9FE2EF2FD93DBE444ACC8CBBFA44300180BE6768FD1F9AD37B88F0FC3E278502136C04817039FABDD75CAC5CFB8D7F7051CABF86BF031FFC1A76504141406839099E242B83309211C1881B0B1BE41E332FC1FBBFE862B9617C3284B0A0B6C2A6F110DB7C3A88B0D1EAC204C7058C0C426130C223C4087B0F219C447051490A44E4E91298F4228A30FA1DC567771721AB998A0A25E8C0A791121ED4646631A913C5A2130090D44C7BD1B1F5C6E66B118F81F43E71E9A3C5E8AF1822FC5487F200A9B383B70E200C7083719E31C868C3210DEC8A41923204C82923189F3C787E31F1FDBFA8E885A3B48F92926D4640F9110A61B3229212762C4879252164E41793D0DE3F22D956E8E1745595314E5AC6B9626964B4AF52730253CB09932DA60C77986F34001018000204FF824160D07844260F020042A1D0F8643E25138A4562D178C45A23198946E391F9048645178F48E4B23944A6551893C865B2B984C6632F914D2652A864DA413A9640E6F3FA04D67D2B9E5068D47835163543A45369D05A5456A34FAA4A6A74B86D565139A650AB35BAED6AC530ABD4AC363B449ACF1FB2DA6DD0EB6DC2D76FBA59ABF38B9DD63B5CB55DEBD7AC0492F36CC1E070CFFB8C2B1387B1E2E118EC65572109C9DD2B97EC16627785C8DD72B0BCE676DF9FC46874569D26934F40D54135B6ECBC6753A6D5D8B5FAFDAD93697BCD6E72DBB887037D4DDBF0B4FB1BB5E37BC3D471B83CBE66379D8FE9F466FB3E875B25D5CA7733BC8E7F2BB59EEF683B3E3A7763D1A3F2E97CFEBA3F17DFEBF0753E714DC7C27BF7AC7EAD0F53FCDB3DAFCC02FC3DAA840EE3AF8F33C502BB6FE393072A900424F4C0704C2A89BE50CB9E8F4290E28D0DC40F8C2F08446C244CB945313BF699C30DF32F0FC589944519BAF12C6C9FC651CC1AA245EE63EABFC7917456F0C86DD48AFB48F2447B25AC124B151FBAD20A390246D1AC9CBEC9B2CA5D1C4B92D4992FBCCC5CAD19CB1314AB2F4D1144B735B33224DD31B8132C5933CE308C9F3BB65354F53C4DB3BCA9154FB37CC341C0D28293294AF3E50D2347D445169CC35454CD0C4E913C7746BBB4835D4A4EB4B53D095034ED392CCED4D494AB54311D335451352C11584792A52F565415948F56D5D524FF5DD7942D7D392BF5AC4153D835D5776455D6357D18C1760C19605A15FCF369D5F5ED9B5BDAD6BD496243966593465A76555170596B0D4772DB56DDA9305D972535735D4E5DD341DE578DC5685E146DEF7E30B7ACE37ED0D7DE077CD8F75DDED3601316057B60D6CD4B6F43386CFAB6E17276293D6098762355D8B845B73259F35E334061F70E3B5C48792E02EE62F4AD718942B8DE2B93DCF98E3D6FC4B9930F964DD9A6359B5E7385D8F739597E67905ADA064D94E8BA35A571CD5A44039F649A15F1A768BAB4D11DEA8FA695A96B584EC790EC37D61FAFCA7B3E0FB2E97AC5FD9C65559E85B5461B66216C651BD66FA26C9BE55F9E291AE619B860BB76C5BF6CDC4527493FDC24BFA665BC66DBC56DFCA50FC1469BC6F7556E71CF259FF39BEF3CBEF35C04F7CFD23D46E3D670FCB713D2F3DD3C8547E9FD0EAFCC73BDB6B7C32B1DA4D3B976FDF66BDD749DE6FFD9737C7345C84B9DC6BBE2683E177BE349FE071BD86D1EB6B3D7639ED72BE544391AF5E754DE969BEF78BF06F3F1707F2361D1E87F77636AF93E4717F551FEC5DBFA7B6FE9F4BFE7C2FE1CBC00490F01F33187D0E4E033A27A8FDD771CD79884DF93DD804FB5FB3F96A2FFE0BA02826FBE07C1A8330160EBC781AEE6139416EC9B20DC0382309211BF5852E15EE1FF7E0FB0CDBAA6610CDC8C0B81D0E2133B53BF0DE12BC17870D5D7C4582D0121944241507E18C2F89A9761D29F890F7E16C188A46AE15A9B880FCE28C2E89D14E2DC628A878E2EAB18BF12E32C5A8C7072264708DADDE281FD8B2EEE39C418CEF5635BAD8946E5B5409496F421A43C79F0563F4613D0D22412B987D0A23FC498E319A1CB3A8EAB4649C6E8F704237C9493B26A4AAB692ED424CC7893F29A4DC2290CF9E2BB608A123595C8F7A32B5E9C7D9251E5A4BCC960DD25A4019152A25C46C94F28A34A518AAA625948592316252C7A9432B08088000204FF824160D078442609020042A1D0F8844625138A456290C8B43E31198E4763D1F8FC6E410B81C8E4D2794476452895CA65D2F983FE5B2192CC66D37994326B2399CE27D3F874F6553BA05168D2486C9E8547A64C6971EA7D36A54AA24D29353AC44675558CD46B35F8B57A2F5CB0596C3648E58ACD6B84DAA2B6EB65C673579E5A2E552ADDD2CF7ABBDF60F7088602FD5FC1506ED83B8E170387C45AF156DC66368179AEE472584CB44B1F97A2E6EFF99CE5E34113CF68671A582EA34D20CA69347ABCEEBF0D7CD85835573DAE27658BDA6E6B1B7DBEFAD35BAD6EF8530E071B8F2EE4EF79747E0D239F98E7657ABD39BEB721D7EC69F959FEE7766DCDF168BC37BF2D37C9E9E8713C1ECF6F9F35DFF87A2A9F2FADD7F1AEFDFE6A0FA353003FCE2AF2ABBA301BB69640504367053FB062DF05C0307C20FE41D0AA9C9AC0B0943109C2F0EB9905C0F0EC0F11C30F5C410FA0CED4529345116BF515460D6438DC46718BEF1BC70EDC4D0445F1D3870A413203FF2141B22287233DF244830247AFAC7F2642D1CCA4FB25327C1928CAADE2C69D4B721C5D1AC49114C513C6B2C47D324951D305164B72D4BE854E138A1112CCB0ACE73A456E34DD244F33D3A52A50123CAF3BC213FD00D2CFB1BD113D51B3A4ED35D19355068D4D53434D47CE34D4BF48D2B424774FC9730C0B49D2540D4551D4354D51195591B54957CF753D6145CB34A56556C695A45B4F57358557564A35B3F34E4DF5C5735F5936456539D88F4D8D2ADA32959566D9957D1167BB169C996E4FD33D0D5BD694C3FD4D5B4E3DBD225D3205AB6C5AF615DF275C2DFDE3515D7365C15E4537BD4D574232F5B77AD3F7E46776DE171DE701DEF73B2F824618757B7CD7F6057789E1D86307885F78152B835538D44190630B964131E117D6438957F92CCD93BC6F7339964F18E5078F5ED9A5139C3F572563415AD9765795597A06877F65F802FD9950F9D521A167FA366FA2363A4375A95DDAB60E97E79286994DEBBAD660B3695716A181E9DABECB8EEBF0CEA8ACEC734EB18FECFACE7DB46EB7A6DAF56D7696F76A6E7B96E3A8ED2F36B75562BA0F03B3651C2BD9B7E15BEB27B0F23C4ED5CA66BBFF05BBF01C1B6DC93B3C85BFCB673C5E1372F417574EF8CD1C774DD151DCC715CE75FD72D991BADD969BDA6BDD265193771DDF7FAAE6D26F11E0D8FDE62DD4DF1DD2FBDB4B9CD7339EE8B10F7B96F8DBE7998CF3DDBFA1D8FBBCAEC1EAE67ECFB1EBB11E7567F35BBE55FBEA793F26FDF8325F475962FD982F61F07BFCBFE598FB69C9FBB0F802C45E43C57F6E8DF51AB5CEFD5AE3FD751015E9BD269F01CEEAC48187C20BB8D7F2FF204C0F83A6F93EC195A100D8DC10827049BB4287C648A111E585A789E1BFA854E6E0A3AD7D0A8214AC1868A15F134B81CBB2122E87FEF1208C3A7A307DE5C487DB0CDFC3797B9115C3C50898F7A29C3288CF2CC7B8C8470FE24BEE80D1560E435805139E7C5248AFBDF0C688C4A7620C0D2DD16A1746D7AD17A332498D5181EC15E8E10C2393E38D317E2BC568A2E00A5C7B82B1F61F47F8EB11213C817F84CE433018B912E2544D92B18E4BC043B5244E9C2F90F09A1CC8394255A3BA1B87AD9235BC7915236513748F0ECD3ACA69652CE5A4B596D2DE5C4B99752EE5E4BD97D2FE604C198530E624C598D31E644C999532E664CD99D33E61101000E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000E01300000301030001000000050000000601030001000000020000001101040004000000F61300001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000E61300001A01050001000000D01300001B01050001000000D81300001C01030001000000010000000000000000010000010000000001000001000000080008000800D7040000C1040000C0040000C104000008000000DF040000A0090000600E0000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}', 'de_de', 'predesign', /*material - Naturstein*/ '2025-01-30 09:43:36', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}', 'de_de', 'drawing', /*material - Natursteinplatten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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}', 'de_de', 'findesign', /*material - Natursteinplatten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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}', 'de_de', 'predesign', /*material - Natursteinplatten*/ '2025-01-30 09:43:36', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}', 'de_de', 'drawing', /*material - Stahl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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}', 'de_de', 'findesign', /*material - Stahl*/ '2025-01-30 09:43:37', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}', 'de_de', 'predesign', /*material - Stahl*/ '2025-01-30 09:43:37', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}', 'de_de', 'predesign', /*material - Holz massiv*/ '2025-01-30 09:43:37', X'49492A00B8050000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D27944A6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65369D4FA8546A553AA556AD57AC566B55BAE576BD5FB0586C563B2596CD67B45A6D56BB65B6DD6FB85C6E573BA5D6ED77BC5E6F57BBE5F6FD7FC06070583C26170D87C4627158BC66371D8FC86472593CA6572D97CC667359BCE6773D9FD068745A3D26974DA7D46A755ABD66B75DAFD86C765B3DA6D76DB7DC6E775BBDE6F77DBFE070785C3E27178DC7E472795CBE67379DCFE8747A5D3EA757ADD7EC767B5DBEE777BDDFF0787C5E3F2797CDE7F47A7D5EBF67B7DDEFF87C7E5F3FA7D7EDF7FC7E7F5FBFE7F7FCFFC0100C0501C0902C0D03C1104C1505C1906C1D07C2108C2509C290AC2D0BC310CC350DC390EC3D0FC4110C4511C4912C4D13C5114C5515C5916C5D17C6118C6519C691AC6D1BC711CA168080800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D27944A6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65369D4FA8546A553AA556AD57AC566B55BAE576BD5FB0586C563B2596CD67B45A6D56BB65B6DD6FB85C6E573BA5D6ED77BC5E6F57BBE5F6FD7FC06070583C26170D87C4627158BC66371D8FC86472593CA6572D97CC667359BCE6773D9FD068745A3D26974DA7D46A755ABD66B75DAFD86C765B3DA6D76DB7DC6E775BBDE6F77DBFE070785C3E27178DC7E472795CBE67379DCFE8747A5D3EA757ADD7EC767B5DBEE777BDDFF0787C5E3F2797CDE7F47A7D5EBF67B7DDEFF87C7E5F3FA7D7EDF7FC7E7F5FBFE7F7FCFFC0100C0501C0902C0D03C1104C1505C1906C1D07C2108C2509C290AC2D0BC310CC350DC390EC3D0FC4110C4511C4912C4D13C5114C5515C5916C5D17C6118C6519C691AC6D1BC711CA168080800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D27944A6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65369D4FA8546A553AA556AD57AC566B55BAE576BD5FB0586C563B2596CD67B45A6D56BB65B6DD6FB85C6E573BA5D6ED77BC5E6F57BBE5F6FD7FC06070583C26170D87C4627158BC66371D8FC86472593CA6572D97CC667359BCE6773D9FD068745A3D26974DA7D46A755ABD66B75DAFD86C765B3DA6D76DB7DC6E775BBDE6F77DBFE070785C3E27178DC7E472795CBE67379DCFE8747A5D3EA757ADD7EC767B5DBEE777BDDFF0787C5E3F2797CDE7F47A7D5EBF67B7DDEFF87C7E5F3FA7D7EDF7FC7E7F5FBFE7F7FCFFC0100C0501C0902C0D03C1104C1505C1906C1D07C2108C2509C290AC2D0BC310CC350DC390EC3D0FC4110C4511C4912C4D13C5114C5515C5916C5D17C6118C6519C691AC6D1BC711CA168080800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D27944A6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65369D4FA8546A553AA556AD57AC566B55BAE576BD5FB0586C563B2596CD67B45A6D56BB65B6DD6FB85C6E573BA5D6ED77BC5E6F57BBE5F6FD7FC06070583C26170D87C4627158BC66371D8FC86472593CA6572D97CC667359BCE6773D9FD068745A3D26974DA7D46A755ABD66B75DAFD86C765B3DA6D76DB7DC6E775BBDE6F77DBFE070785C3E27178DC7E472795CBE67379DCFE8747A5D3EA757ADD7EC767B5DBEE777BDDFF0787C5E3F2797CDE7F47A7D5EBF67B7DDEFF87C7E5F3FA7D7EDF7FC7E7F5FBFE7F7FCFFC0100C0501C0902C0D03C1104C1505C1906C1D07C2108C2509C290AC2D0BC310CC350DC390EC3D0FC4110C4511C4912C4D13C5114C5515C5916C5D17C6118C6519C691AC6D1BC711CA1680800E00FE000400010000000000000000010300010000000001000001010300010000000001000002010300030000007606000003010300010000000500000006010300010000000200000011010400040000008C06000012010300010000000100000015010300010000000300000016010300010000004000000017010400040000007C0600001A01050001000000660600001B010500010000006E0600001C010300010000000100000000000000000100000100000000010000010000000800080008006C0100006C0100006C0100006C0100000800000074010000E00200004C040000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}', 'de_de', 'findesign', /*material - Holz massiv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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}', 'de_de', 'drawing', /*material - Holz massiv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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}', 'de_de', 'drawing', /*material - Dämmung Trittschall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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}', 'de_de', 'findesign', /*material - Dämmung Trittschall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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}', 'de_de', 'predesign', /*material - Dämmung Trittschall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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}', 'de_de', 'predesign', /*material - Aussendämmung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}', 'de_de', 'findesign', /*material - Aussendämmung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}', 'de_de', 'drawing', /*material - Aussendämmung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}', 'de_de', 'drawing', /*material - Bodenaufbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}', 'de_de', 'findesign', /*material - Bodenaufbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{112BC6D2-C432-48FB-9DEF-3A2CF661F7BE}', 'de_de', 'predesign', /*material - Bodenaufbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'de_de', 'drawing', /*material - Dämmung weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'de_de', 'findesign', /*material - Dämmung weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'de_de', 'predesign', /*material - Dämmung weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'drawing', /*material - Dämmung hart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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'findesign', /*material - Dämmung hart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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'de_de', 'predesign', /*material - Dämmung hart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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}', 'de_de', 'drawing', /*material - Dämmung Gefälle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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}', 'de_de', 'findesign', /*material - Dämmung Gefälle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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}', 'de_de', 'predesign', /*material - Dämmung Gefälle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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}', 'de_de', 'drawing', /*material - Dämmung Aussen weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}', 'de_de', 'findesign', /*material - Dämmung Aussen weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}', 'de_de', 'predesign', /*material - Dämmung Aussen weich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}', 'de_de', 'drawing', /*material - Dämmung Aussen hart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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}', 'de_de', 'findesign', /*material - Dämmung Aussen hart*/ '2025-01-30 09:43:41', X'49492A00B80E0000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4D66D379C4E66D069D4F67D3FA05068543A25168D47A45267D3CA55369D4FA84C69951AA556AD43A9D5EB55BAE576BD5FB04CAB361B25968D63B35A6D53AB45AEDD6FB85C6E54B82DCEED72B6DDEF56181CAAFB7BC06070583A45FDFF86C2626AB79C56368B8894E431D93CA656F10296E4B2D9B9CE33399FB1662599AD06974DA7A264B49A8D667B59A6D568B5FB3DA6D65FB1006DB67AEDD65757ABDEF078582DFECB879FDE71F89C6DBF3395CFE85BF8191E774709C9EB5DBA787EAF67BDDFAB76FB7E0B8F63C96EF1777CFEBF650BD3B9F6DEFCDF1B278FA9F0FA7E7F552F5667FAFDACAF9C00ABBEC95C0B01C10EB40EFBC12B540506AA105BB8FC4210ABC1094250B29507C34A4C30FFC3B10B6B0FC29112B50E44CD4C409843314C5CC1C5B09C5F13AEB19AA318AFD15C6D1DB031C4191E29D144809DC74FE44B21C911EC8B1649724A6F2149D232831F4A32AC0926A5D2A4AD0346B2DBDD2C49923CBD31AB92D47F3227F284C7334B9314D137C6F30343374E1234D928CEF33CEB3DA9F3CC653E26B354BD3F4FD4050D1CCE8BA51343BEF42C87474FF46524B64E49A5211E5053C52B2251749D3CFF53B29D372B5332752F3D53F54CC33ED472AD4B24D4F48D5559D41565433DD5F24563445695A5775453D5CC775FCDB5ED67625794FD851B5916058D4659B5952565C6768DA367C1B6B55B5D4BB49DAF675B1345BF695A16ED0D71D9370D716DA81743F36A44D775C9754C9795E4F8DE1115ED765E910DF75BD07735017BDC17ED1F7E545804B77CC2D8258B83549842B1895F5814E1875D38854D8A61343E190AE3182E356663976E4B0D63F0864387E4792614F0E4F86E2D35E6389E5F96C0795D6B75A093E674D1E6B9C39F9FE598BE6780E6F2BE93A15DFA0E3B9E688E3EA3A0697A642FA766D9F68F4D6AB32EB1AB35FA9CB3AFDF1ADE37AEAB7B16C0F96C9ACCDF94BF5B56A9B5E41B6CBFB462B9EEDFBB455BC6E8DD6E5B1EFD0EEE0F6F0355EFFA6F06AEF0ED3F0AF671BC1713C5313C8B4BC7BD7CB6E7C9ECBC5EBDCF413CC3CFCD725CE3BFD2677A4750CA757D2F4CECF5BD4EB9D8B1BDA68BD7BA1DB633B3F74EBEF920F7FDC32FD02C1DEC61B365CCE78DE127BE5E4561F9114F9DDBF9911F82AA7A6ED7A378FAF38F89EAED9EFACDECAE7D13A3F25E7F035BEEC23F6383F3773F77BDF57D7F141DF9701EDE51FC7B1FE7E8F01FB1E87FCFD5F44028025AE02BFF7D2722019A87E070E04BD481465A08BBB65C40408000204FF824160D0784426150B864361D0F8844625078100227178C46631158D4763D1F90486452392496451C934A64928954B65D2F7FC5659309A4D635339B4E61B389D4F67D3FA0506193CA14EA8945A44A66503A4D365B47A74BAA151AA556AD49A9D5E4759AD576154B8B57AC510AE58E6F4CB35A6D56B8BD96D911B75BEA960B95B2E37587DDEF17BBE4E6F57D84DFF013EBA60EAD82C3452D189C66365588C76431D4AA5E4E9B92C66632D9BCB66B0D9ECE47F0BA1A068301A6D26A6F1A8BE6B35512D1EBEFD8BD942F5DB5DC53B6FADDA6E6A595DF6FEC3C1DB6F789C7B5EEF4FC6E448363CD93F3391CAE875729C3EB4C7A5D9B6F03B9A2EDF13A9DFF259FB1D6F1F079FE5EEF9FB9E9F67C703E1E9FD3E55FEF7DEF3F6E6FC3F4FBBFCE5BDCFFBF099408FDC06EFC0303BC905B7904C1882BD708A0D072F70B428E8430BAC36CDC270CBB50841AFE4411043AD5C48FD43F0644F07C4B17A7714BD1193CB15C0F16C2F1A460FFC71144450246D20474FEC871DBE51EC3922BB320C79254891FC8D1549CFACA12940D134A70D4B328B8F2440512C98F8CBCBECC72E4932AC012DBD4FCC2332C73344CD11CE1314D4DF4C2F64DD324EB38B433CC5D2C4AF164F6EACFD3E2AF42CF539C6740C6F41CB54550D3B51D27C293BBDF49CA948C8F4C4BB4E3394B4974F5334D5174D510B15414A54910D574254547D1B464D34852B57D5AB4D4EC4D72C3CD94DD6936D6D5BAC75DB07622E75ECE95FC33635849359962D82CFD91055A352D9AD959F5D5AB37DB2A15BB685956BCCF7155959DBED2DB7585C8D4DCF44CAD76B0974DAD75B1B784BF735E4E4DF350DC37A2BB7B5A57EB4954B71805C17F5EB7DDE73960C9861B776116D6051DE1EE162AA7E154BE2788DBD8CDF964E2E92E4383E3971E4B0AE3CAD608D56477BE4EBB6538D61998D798DCCD96D9B9C4FF8D674E76696A66D97A5F9EE219E67ECBE8F3968554693A05F9A2233A865DA5D0FA6E6545EA4F6EA8846B328EBB37E9FAB63BA0D57AFD6BB2549B32C969E0BB14F1B764BB56A6F16D8DAEE5A2EB6A46EF9DD3B594D7B455BBDC9BC06CBB828DBADB1C36DFC26F3B5F19C0F149B656CCF2364F1A9FF0580EFBCCA09CE6E7CBA6BCF6F0DCF27897410474FC3F1F6173DD2F35D4F51D831FCAD67CDF696776F2B765D9F5775F05D76F9DDA87DCCE3D1729DEDFFC443DE257DE1771E45C5DFF94CEF99DD79C8F78CC8FAA90F80B97B3EA7A1A17BEC9EE5EEADFF1FB5F0E5FF4613F5375E9F8FEBA27F653FEDF07BB2048088000204FF824160D0784426150B864361D0F8240801108A4562D178C466351B8E41A251D9048645239248A3F25944A6552B91C9E592F8CC4A5D309A43A67359C4E675219BCEE7D3FA04167B41A25167543A34AA6503A4CD2914DA8546414FA9556AD0BAA55EB55B83D66B917A5C4EBF26A658ECD63AF59ED53BB4DAEDD3EB6DBE1361B94C6CB75BC516E379BE582EF7DC04E2F77CBA606B17FC36265F83C56362388C7646C962C93FF0B95C66573587CA66F3D8FCEE7F4514CCDBB2F92D2E8F37A9D55AF59ADC8EBECDA7D8E4361B7AEEDB7172D96EF15BDAFED313C0DF6FF75C5B57139181E55578586E6F2F09C7E9707A9D5D1746A3CFE675FB19EED77E9DDEF1663C9BCA5EA3CFE5F3687D952F0FBF93EBD37A78DEEF96C3E3F98EFEFF8D9BE900264C6BFCFFBACFC40CA0C0B04AB505AE0FB38700C18C041D09A1F0AC2CA84309CBB8BCC370CC35094408E43F11A8D12BC701BBB0444CCD4510B45F16A8918A530EADF1A4649FC71034771CA8F112AF1B3EB1647D0248122A211EC9114BA1082FB254969ACA0EC4A728B1723B9D272EB2ACAC984B8E5CBF2EA5730AFD1543D2C4C4F9C8934A6D344D8B44DD13CB4F44D737C9F38CA3324ECC9CEF332F13D4F696CF116D0140A7941C1539CD5433C14444742D1943CEAADC84AE52148BFB474414BD308DD388552B4A5354EC4349CED4FD4932CFF452CF545528C55D15D5EF554D20D594B54759BB75CBF358D748B57D50CB35AD7F1BD78F957D62C9363CC75BD456259545D3164DA286D836741B665AB44DA147DB56DC756FA516129B6A5C10BDC4E2DCD73DAD74D25545D7763393DDE3792E7772A76C3E17C5ED2654F7E5FB2BDBB19DF55DE0780C0F2EDEB8437383A8172609876195C6256460189CBD8BCCB4BE178C23D8D45D9063D1AE44D260B3962B91DF794BD98EE558E64EBD64B955C799C299B6694165914D0197672A1670E9E779FE0D67E7BA0E894947D9F689A3CFD61E9326E8775691A8C49AAE1BA76AD08EA6D5699A8E9D30EBFADEC77F6B7AE2AD88439AC6CF4CEBAD1ECBB06D9B5305B66DB4F6ED84EEF59587B16F3BDA35B8A4BC16ADBF69F996DFC05CBBFE8BC53EF834ABC26CFC94F9C76D152F23C672D553FFCA70BA46E98173723713BE747A97219B73DBDF57CE74FC7E512575BB6F668AF6BB275598F45D7F60F176FCFF4B587749677FC9F35BAF83DE650A4F429278BBBF9F86F94F6E231C7A3E379321FA75A7AB917AFDC7B2D778FEDAEDF0CDBC3C7FF37C988B71EFF69EF7879D7D6D5FC7927D5F9FD907FD1B37F0C778AFB9D631779ABE5FBBFD5C3015A84067FD0088110108000204FF824160D0784426150B81002170F8844625138A4562D178C466351B8E476350D8F48645119048E4D27944A6552B964A64B2D84C365F30824CE69379C4E6753B9CCDA793D81CFE8543A25168D35A0CE265499BCFA8F4FA8546A516A754E4555AB566B55BA1562554B87502C35CB2596CD2DAF59E2969B55B6DD6F98D3269609D5B2E177BC5AAED77BDDE6FD7FA95F6AF4BA6DCB0187C4567056EC5E271D8F986363F84B9E1B2197CC616C78FC96673D9FAA65A5D94C8E8B41A7D44633B66D5EA75DA8D6E86659AD7ED76D6BD35BF63B7DE6737326BA4B377BDE26278750E3F179579E4C33495FDFF2FA598E6D1BABD3EC593AF08E0CAFB7D9F054FBF5DE8F87CD7CF2C73BBD0CDF9FDD88F1ED3DFF3C3FC691B3D1FB7E9FBBC7DB4AFD3F900ADAF1BD6E03D301410C0C0EAB3FD04C1D0340090C0A91C1B07C2C8EC2AEF4170BC38B13D9024370EC44F935910C4713C3508A3D09C311345117BF2BD45D18468C1C54C9BF10A4671AC788DC331B47B20C491B3AF1FC851AC8D15C7723C988848AE7C2525C9B29B9D1BBAD294A92CA0D27C7316CAD2D4C08AC928BCC730C46E4C588CCCB3343B35B712FCD938AE33822734B552C4E529CDD3ACF13CC99344A11F4FB3F49B3DCE742510924FB3B4DF44D1D2750728CE947CF2DDD193E5274A4E3433B948D351E52D40CC94F53F1A53883D4F52BDF50CBB355495554D57CC55956114558D5D535ABE9435735D55719D2E87D7B5F3CF5E569624CF605454C5914FD8D4CD9B2CD7165A2561DA2F0C936B5AEECDA756DAB63DB764DA1255C770DA510D834EDCB734F5705D576534C6DD3545DD7841F6CDEB7B413795A92ADF578DC16D5FEE95F96F5FD81E0175D678561123AFB799FF8161AE5BFD89626E2E1F7EDE98662F506037CE3B00E33832158B642E24B993D1D91AD9936559453D9765EDE65B8D62390667916639C672FDE6B924B79E67AF9E53A1CFD9FE7FA35135669544690D3665A6B6DA66A5A76A16A6A3AAB5DAA6B54AEAFA06B3AEB4FAE6C5362B13B6C3B2EC774685B558BAFA7DB4EDDB5DC7B96E6CFEE340EEDBBB3382EF9AF3F509EF7BFB21BF709B330DC16DBC3DB0E8F07C637DC0B49C7F21C2F1DC5F2AF025EEEF29CCB8DCBE39CF445CDF27CC74582741D3CCDD2473CEF54FAF13D375F8A292B075DD9F61C9743DC4DBDB681DE4FFD8F77E042DDF77FE2483BCF87E45F7E3765E66319B7A18F76DE9F11E3FADE4FA5ECC91EDFB91879DF0FC5F1FC9F2FCDF3FD1F4FD5F5FD9F6FDDF7FE1F8FE5F9FE9FAFEDFBFF1FCFF5FDFF9FEFF440400E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000760F000003010300010000000500000006010300010000000200000011010400040000008C0F000012010300010000000100000015010300010000000300000016010300010000004000000017010400040000007C0F00001A01050001000000660F00001B010500010000006E0F00001C01030001000000010000000000000000010000010000000001000001000000080008000800C203000099030000B4030000A103000008000000CA03000063070000170B0000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}', 'de_de', 'predesign', /*material - Dämmung Aussen hart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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}', 'de_de', 'drawing', /*material - Blech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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}', 'de_de', 'findesign', /*material - Blech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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}', 'de_de', 'predesign', /*material - Blech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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{C7BADAA3-4258-4567-B03A-B9D1C67DB67F}', 'de_de', 'drawing', /*material - Blindboden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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{C7BADAA3-4258-4567-B03A-B9D1C67DB67F}', 'de_de', 'findesign', /*material - Blindboden*/ '2025-01-30 09:43:43', X'49492A00DE1D0000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA65503954B65D2F984C659319A4D665029B4E675339D4F65B3C9F5065340A14E689459DCE291490052E8347A74BEA1519854EA92EAB55EB357A1D2AB952AF57EAB61B15769B65B1D9ED166B5D820F2BB2596B75CB9D6AE362BAD52F348BDD3AFB42BFDF2EF5FC0D170B80C1DD31378C5DEB1B8AB55AF0F4FC7DFB2B8EB5426DB6CCDDC3239BC9D1B2F51D0CDB4B4CCEE9F459FB968F2DACC96BB11B0B46AA6FB4D6EE2EDBAC26CB29BCC85BB6D69CEE7B8B9CB6F0E69CAAC6FB0DCE9EF3389A0E86FF8EFFE971B8FD9E46A7ABABEBF73B1DFE8E260DB1E06EFC3E49AF8BB5C9F6783A9E9CC77BE9A4F8E9BF3D3E2F8BDCEEB6AFDB970139AFBB5ED5B86FFBC703296FF408FE3D0F5C18EB3B707BDEFB4250C42B09A7D0541D0E3670D3FAD1BCEFAC370CBE7143E11042915C5508C4F18C5D1946111C58F946D11474F2A0903C6914C811CC831DB7317C031BC792348B1FC97214672746B2243A82B9F24351263192B47128C8723C952CCBF2F4BB27CB9324C5284CF29366BDC3D0B40B3549B32CE4DECB4FD4EB084C739B832C4E930CF7344E33CC1B2A4ED3F4C14150344CF4F54F93FCE143CCD48D2147C4D405274435EAB4DB3BC074E4DF46D194B4FB5052B4A51D34D3152D52FC53D3C51554372A3D3743555495475154F5B57345D6F5E5775ED571F57150D4CDDA7959D4956569655936158B41D5AB759767583685A76B59B6C5873A3356CD995D52F57DC5625AAC15A34FDB76FD9F735AF765BD2ADDB6144B74DC971D817B57F7CDC37DD615F5A97056B7F5B575DE177E06B343F78C438345B826177A60F805F580DFB7BE05776218C61D8D40AE9591895EB7E5F17FE2F82E339262D8AE2795E5191E2392E5F8EBF78FE618E65D75655916439CE53966299F6719BE5B9DE8598AD2D3E699E6819363729DCE9FCDD05E159B6759EE89AAE839AE9DA9E991E327A4E8BAA6ADB1EB3A5687B26AF9FEB1B3E9787E9B24E19AEB7EC0EC1B5ED5BBEDB86DCBB96B5B76CDBC6D9B4ECBB0EB7B8EFD734D9A8C2FBFF07C171DA36EDB1709C3F23C0F21B472FBCF0B93F33A72E7BAF31C6F01D1F25CAF29C672DD2F43BE751D3F272BF39D5710F37150075FCDEFBBD76FB8641D2753D6776F6F6BA96F7CEF8DD1735AF2E3D0793DD74DD977FE3F81E7FA7DF7A5D77A9DE6DFD87B7DC48F79F99C7F91E8FA1EBFCBF3FC9EAFC7EB79DD6FDBE0D3BAE7B14ADBBD8FBDDEFD1F37EFDCCB7E2FF2FBDECBDC7FCFEDF74047E0A1531AF37BB021FB3DA807039FC3EA7C4FA6083FC81902DE134F71701E0CBF2804D411EC0F83F05A0EB868470160AC28800FB2093FA7E6FAE1842D8630BA13C2063CD45F0C2C85F05215C337FF0CA204347FB0461DC3A86B006033E281511A21C247E309A26C2A8A307227C4487F0A62A2E88311562DC177DD12E2BC477571161F4498C70F609C428BD15A333CD8A712235C4E8E319CCF35F870F0D84C508E71661041E8DB0F23FC6A8C5196324418C320643B0837D1E606C838D31A22647B8E123A4146F92325244C9890D26E42C9D832E25A7C399092424CC96947222404928E916249C5C84529A47C9C934F28E048C8BAABA394B88A52AA374AC92F2C24ACBC9532CE524C3981294DBA9A8EF069DB4AD98530612C6C93D2CA63CC636F1FA67CA79B335A68CB953AACA65CD89BB2BE6DCD05A51EA624A89CD16A724E39A53A669CF19E0DCD423C49DF3AA62CEB8FB3A2574F797D36A79CD59F506E6F4EC9FD40672B187EB4165D4BDA113BA8650497743E7ED1199B44E8AD189AF3F284CF86E5182675109573E6924D4A3B3CA8F4FF9634AA5FD1B91B40A64522A1D14E9052DA654AE92D2CA014663E4E7A0F4C294D39A2949EA1D37A4750217D35A634F29C541A9150AA7D4EA7549AA2D3E96F55A76D4CA8F54E9453AA9554AAAD06A2D3DAABD62A3551A9DD44AA3572A856CAC15AEB0CFB76357EB556EAED5B6B454DAEB5C6AC53DACD4CEBDD5AB0143690D829B961A64C8B8F13868E584AB75E69B588A974BAB1D12B0764AAA570B3565276D74AE5596CFD59B394FED1D95A2F65ED2D8FB3763AD45A1B49642C9DAC73C63E51587B536B6BED85B6F6EAD7563B6B40EBFD7AAF9706C8DBB5A132A66564ACF662AEDC3B956BEE6578B576E6E5DC4B7169EDE5D4BAF6F56E3CBB17286EFDA0BB570AE9DC6AD36C2CCD81BCD792F5DC5B65702EE1907C1786D15E8B9B796F8DD9BAD6DAF7DB1BC77BAFFDE7BA37A6FEDFC3DF42EFAE01BD9816F85BFC057EF005D8B557B707DF9C277DAE95EA55D67B05E0AC2373EDF5F4A5F86B01D77ADF85303612BB765B0EE2875D87306E22B4D8830BE25C33832FF62AC5B85AEDE0EC538D2BF6408EA83E5B609C2185716635C5D8DF1B5F8C3D8E71E63FC938F71938CC6173B1F5F7C4991F2963ABE194F2EE42C3F9832FE5EC9199B1FB749EB9A72AE41CC994337E6CB93916E865CC639CF36DFACA30D32BE4FC099372DE38C4F8633FE76CA19672664BD07A032C679B1F9F73465AD0989B4A693D13A0B4AE4ED23A1F4762BD37A173DE67CC53D0FBE74C439E2F06A89C5A334D6A3C779C73BEABD03AC34E2ADB3DA9AEAEA1CE5ACB4B6ADD69A2F45699D67A7F496ACD83A5F5FCB4D8DA63646C4D9BABB31ECED7DB4B61EBAD8BB1F69ED0D45A23601692028000204FF82416040082C26150B864360F0D88446210F8945627038B4661D188D476291D903FE3F218D48E49119349E25299542E592D864BE6104994CE0D1C9B42A6B399DCDA7B2A9FCC28324A1D020F47844D271399BD269931A5D3E8B27A9C7AA34FA553AB109AAC96AF58AEC66C356AD582BF52B3CCEC75EB2D6E4569A15C27D72A35B6B71FA451EDD59BDD72E954BFCB6D72BC0DD6FB4DBEE0E2D8A8BDDACD8EB9E42998C8DE4A7985C065B0598A2672D987BE4EA9189CF4832950CD5AB4B8BD5E7F41A7976B6C5B2946D22BB0D16A6E3BACEEF30DAFDB657416FDF69B83B5C85E6EFC7C6E938BBDE770F71A8E8F039FAEC3F4F11D6EAF6799C2BDF6B73DDF26574FE2BF75F67EAB2796DDE8EDFBFBFD4F0FCF63ECDBFDBC7F5FC7AFA4FD388FFBFAE4404B6314F8342F9406FCC16F03BD06C08FE40B093B90A41EF73970839B0B430CBC350740CD5C1100C3912AD10FBE90BC4D0CC3B13C5AC9C0111C6518C00F8C590AB7AAAC671446D15C3D09C55054811BC832245EDDC871F32324C5D1C2EAA1C7723C97254611E3F72149CC7C992ACB71FCB32C4C12937F22B769ECA32A4BD30CD129CD536CB92FCDF3249B3948D2D4E134CC4E32F5104D731CF2E84EF39CEB374F13EB332ECD93FCFD3B4E942D08C8A5333D1F38D074AD194B5054BD0D4051B44D3745D3349C9140B54BCA9D495314A5355153D50D5351D3B52D1159549475555654157B3753D4D2B3D34550F4FD8358D61603DB5AD7759D8B615395D5695C59750B956457355D6F675A36BDAD5B5B756DB166D9890BD1545BB6D5BCACDC71A57D1ED5D72DB973DDB785CD67D8CEC5EB3D5EF63DA164CD769DE37A5C2FF5A96CDDF79E097FE0F835F9625E584E0B8761B85C18F3DD56562580DF56FDAB88E018463961DF37B5DD8FDC17DDC4CE5FD8DE3B8D5F181E2F8F65787E4993DD704E5992E6F9164D96E19953093DE719966399E418C4198B67DA2633A367FA4621A4E87A8E85A2C739462B97669A765F856A5ADE47A869FAA6739E6C7A5E61B0E83AAB7974E6B12677B4EB9B16BFB96CFB86A7BB695ACE98D657D726EB10B35B66B5BD67BB470990E9BAC6C9BDC37C2EBDBCF17BFEE9AEC9EB3F05C56CDB2E75B8F1FCA70DC8F35C4F1DB06F1CF74BCFF32C7D23ABF47D06E7CEF51C3F5FD2765B7F37D9F27D8F5DC8753DE700BC759C4423D6F4FE2F69DDF39DAF43E1F85A3F19D1797E776D9E57BBEC6B9B771E3773D877DE879F14F9B3E7A7DEF4DE3FC9BBF9555E53ECFD3EEEF9C1F91F47E3F771BF0FC1EFFEBF67E7F37DBF2EE8FADFA3DE724F6A023B7807019E4BFB774FBDCC3FD81702207B027C7040E23146DAE5DE240E7B8FF9F3C017EF04E013D1842FCA02C127EC7DDAD4008350720A42C8150960EBFC85F0AE08BCC7F0F8A04C307A509D2BAC685509A1BABF81B0CE2243A84701E2042086D12A1DBFA862F6E1740C832BA1AB4177831061445887B13A16C5086AFE6264478A31762345284512D9A2507AEDBA33C608DB16E30C1F8DF10A29C668B51D239C598E31BA124346F899A35C188791CA3EC458C90CA3B47B8E11E645C8589F19626C4891EE023E4929232323C45C8930E63F49D8BD2423148E92F26A344A492B270F5BAB8ACF5A55BF092727E4F4A090925A50C1E94F17E5AC8890F21A5E47F346F62454999831EA4C2EC9512BE644B19772CA5BC1B9712CE63CA3968F0DEACAE99732A5ECD29A32E667CC48EEDFA4C4E094526E71C8956F0FE69CCD8C73925B4389CB36A6ECEE9DB34277CF29B729674CF69EB2CE744EB9F13DE784CEA0536264CECA013EA79CDE9F33FE78CF4A072C1F9CFDA214168A4D7A0D3EE854E190315E61C8DA1347A7F50197545E81512A2B37287CCCA4146295D1F8D937E8DCAD8EF31A9650EA4739A12526A4544E82516A7142E8CCA6A11486A1D0DA834BA9A54898141E8652929A58E41533A974D6A3D44A9B4DE9DD2AA6D51AA9D40A5B55AAAD54ABB2526CD28AB159AB2D3FAC1516AD561A9D5A6ACD3DA4959EABD3CAE15B189981AA34766154C9D55DA93D75ADF5AAB157DB0B526B5D5BADB57EC018D9012B26B577B155D2B7589B116167155EB0D66ACBD2EB3365A2A1C9A39316B1D5CB37682D3DA6B3B652BC58DAD162E97D7CB3F6AAD0D95B5D612CF5319076DAD85ABB6F5C6DFDADB616CEC1D3EB80DA9E0590887606BFDC5B5F5CAC15ACB5352AD8D7EB8571AB9DC1BA3649C6CD5AA5756A1593BB56F2E95BEB9D76EDEDA5BCF71EEC5B8BCB632F4DB1A7578EEBDDCBE17BEF059CBD56A2E25FCB7577EBDD1AA646A0E9DFDB4D81AF8E01BC3792FA5E2B9973EECDEBBEB83F0741ABE77BADA5F9B5179AE85ECC237E304620BFF5F30E5F6C2B87E4FE17B9B7E312E14C5789B0662EC2787B19627C3184B1B5EDC5F70F11D64C138F705E33C218D716E1DC858DF11603B4986B0CE0A9258AAFDE4DB47906E9DFEC9595318E46C738A3225F7C6197B2EE5567F1AB2BDB2C817EB3163FB951D71D647C699BF2E66DBD19CB1DD8E2E588706E45CBF932DCE65BAD96F2467BCF5A071E67EB0F944B2132CF1A16C8E84CB59673DE8BD1F98349E69C93A373868E95254749691CCF9FF4869ACC3A7751E9FD0F9F316688D2BA871F6A4CE9A534F686BA993B506B0D45ABF4B679D55AEB5465228E40408000205037FC160D0784426150B8242E1D0F8640A211387C3629178545A31188D46E371D8F442412189C8E49198949E3929954524D2D834BE6107994C26B337FCDE553A9B4B271089E4B6833B9640E8727A3C92932B004FE2B3EA7416971EA9CBAA15198D5E9D55A6562514DAF54AB558AE48AC751B2D3EC161ACDAEBD6992D9EB757A35CA7B6EB65C22378B0DEABF6C9A5DA858299DFA1386BDE02DB80C45FEF384BBE332183BE5CF2B64C9D132F39BADBF3348CFC7F4321C6E2F159CCDE174754D5D5B533FD2D035B71D7CE363A8D3EE31FB5D56F341BECA6E66F75E06D385B3B37177F92E552B916AE3F36BBA7DBE9AFBCFE36EFA3CCEDF6BA9D8E4D32D3D5B174A2FE4DD75FCDA2F5F6715B7F47C7C18EF7FCF0FF6C4F7BEBEDF0F7FF8D7348CEB96FF3B9023F502BD4EEC13033F70441CCC3FEF733D08BFB05C1B06402A3433054270E4210F2D0FC3E90EC3103C3F12C430A3A11342D1242F17B34A0BE5153EF1A3F316C58CB4411D4511747D1CB611146B07C7114C7713B6D0145718491224792648D1EC831B447204932A4872B49F1FC8B2DCB529C2697C672749B32CBB304A52BC8F28CCF364B937CD1284BD36CE6CB24131CBF354F2DECC9374CD384FD40D013E4D3424E538CFB3ACA6E23AD44B2342D1F43CF54950D4752741D113FD354BCF701D294CCD8E24F13A5414550552D374AD3AE0D56CD52D5554F58D614C53940D19485594FD7357D3D5E39D2C36560303615475A5675456548D7D574AD5BD495DD5AD658546D536458F64D6B535B5655A2F64D76BDB76CDACF2B1AF848560D975EDAB715D970DC16E59F66575795D36F57177DA0B52FD735A6F2DEB0DDBB805E37858D756075FDBF825D77A603695EB676196C5F188E0B845EF8362B8A5C776E158963185E3F8F5F3772F6AADF984E479062D79E43926538E6618D645815FEF3DCF61E51993C4D0E4F8BE579AC019F66986DED83E758EE5DA1E8D8768596E91694659BD8B9568F97E93A6659AB69F98E9DAE67FA2425B066D624458846F8CEBBAAE27B4EB7B56DBB7EBFA5E8BA06C3B93A7ACEDDB8CECB3E7BBC6B1BA42BC0497C16EBABEF58DED7C3E67BFEC5A0EEDA82E9A966F6A717C5713BCE95B472DB8731C671FC7709B3F1BC2F10BBD9DBEF432AF3FD272BBBF5287751D1F45D5F03D9755CD733D2D73517257EBD3DC73DC3773AF73BCDEB5E2783AA793D6EC79CF39E5CE7B3799B9F95E378BE1F2FB678FEBFA1E7FADED7B9D076DD877B35FA5ECFBFF4FC3D6785E6E9BF57BBE47A9DA707F1DD1F7FB1EF7F2D45F7C9DFCFD9DBBBA7D6ED5FA3EC7F4FC601BE27A6EB9EABFB7D103183BE781101E053C082B035F737E7E0FCE0B4067E50420EC0484305E0FC13586C99FF3BF831072013E084D0260F4308450B60DC208570C60A43684B0B0D71496A702E0CC238710D617C2E878FB6124488870CA00C408930E6209BF6A2EF9D8C0576710A2BC378A313A25C4588913E1DC5D8BF0EA07C5E7C886A19C5C8B31AA26C4A8D31BA3044C8CEEBE35C6588F14238C788E6FE0E4A628531562C46D86919241C668B72052CC1A90918637C858EEF6E3D325723151F2C7C8F324231C878B4FD62B482919272443F791521A4BC72582E9E3FC959472962348B8ED2BA56CA48C503A58C8F94D27A57C8D93F1EDFE24A8E8CE24B4B39652EA5CCAC96D2465C4C89132FDCA4A1993266634108251B265C0099B26E5E4CC94533A6ACD48EB32A6FC9896F376384C284934E62CD99ACFFE55CE696138A61CD193537A604ED98938267CB49E123E744B59DD3CE74CF79A13FE795059DF3EA71CEC9B50AA4ECEA9E9391DD4FD98F40E815089FD4568BD06A314527CD19A1D372854EB9EB48291BD5A254128FCD89C34068ED1CA532EE8DD07A3D4AE7C4D7A1F36E954A091D49E9A52EA7B45A9F525A1B4FE78D28A895069B4E5A8F502A650091D4129E542A954EA98554A594BEA9D10A6F4329243FAB352EA2D60A27534AFC53A175269AD38AB75A2AAD5AABF54A9CD6EA9F4C6B0D56AD35C2B6AE4305202B8D6AABB2A64A364B0359E90D6BB0B5BEB9579AF1622C3A8B6F92AA85D5EAE746ACA558B2765AC556CAAF5FABED2DA65522C6A294EF64291592B33672ADDA6B3767AA75A7AB9676C4D09B175DCB6CA8B04F3AD05B39F7592CFDBDAEB6C6BBDAAB69686C65AFB53602DACBEB616A2D5DC0B7366AE0DC8A45742E7DC4B8771AE2DC2B76E7AA8DBCB5B6CAEA5DEB2B5D2F1D76BB758EDFD62A8D79AE6DD6B5D69AEEDDFBA360EE9DEEBDB762CBDEABE5756FC5E7B7D7A3005E2B30BE2F8DECBE76E3015E4BFF7AF01D33C0D7F2BE586BFB782FB60EC1B2F4FFDDAC2984F0B5FABCB73AD961AC3B6B30FE1EC19732FCE24B3F816F0E23C5B6E7115FEC157EF04E0FC6B85F1BE26C678DB17615BCF81718E39C558EF13E43C798C2E9543C8D8E31EDBAC3784638551C837A725E3AC8F90B17E58C7D88724D24CB39532FE01C6983A89653CC599F22E20C9B99B05E63CD19BB36E25CAB9CF2666FCE534F36670CC196F26E61CD38A319672CFD9EB41680BEF9E742E4E8A524F0467BD158432EDCBD1F96B49E8ED0795F4B67CCED9FF0E6818CF6DB46E9BC8995B3AE94D11A734BEA5D1DA9F426A8D359C74E1167797D32566AD45A635BEB6D4DA4709650C53AAB44EA9D49B0EA11032028000204FF824160D078442615020042A1D0F8443221138A44A291783C5A311B82C6A391B8F47E21219144E492584C9E510B81CAE1F2A974665B3194CCE692C86CDE1D3098CF26F3E95D027B369D412610CA14969322A5CA29B1CA7D3289458ED4E75518FD622F5A9055A7F5EA2D724D60ABD92BF39AA51ACD34B148ED743B45A68148B7D42EB52B8DA6D579B0DDE9D7EA5602BB7CB960A316D8AE1AB78AC1DEAF78E83622C784B3E42AB94B66330F9AB76622374B2E7A5D92CEE43492FCE6274541D4E4F4DADD2E3B4F3BD84D75770CB63F65B5DA6DF03BED6702B382BA70A71AFE35E391B97FECF8FBBE4F0FA38BE9E37A1CCE764779CFCB7672FD8EDF6BAB9BF1EC6F15CEF6EBBBE1EFEE7D3E2E5FBBD9EAF8DEBDFEDFB7CFE1F2F2EA3FAD73AEFE3EABFA90E940700BF2FFBCD03AFB053FD0630B0733F093B908BC10A36D082A8F7BEEFA436DAB8AF243506C46D0C2F12B2B04450E0C4F1545D04C56DC45F0B466D1B4105C3F0C42718C6D1D2651F39AFD3F11A3D72043B20C8D2143D1846B1249B1349F1EA8EFD48F0E4952445B2648B1E45928B3324C8121CBD024B3224B9033F8924AD30C97284B7014C71ECCEDFCE6E54E32ECDF2D4EB114E13D3A110CDB14CF3334EF3250B3A50F3B4FD45CDD3DAED304CB1CD23274F2E2CD749D1B44CD1465254D51F473AD4E5295040141D3B5354717D015153354D594150957CF1524715950D5456356D735853CD5530BDBB32ACA92BD85484FB5DD5D5D54F6459564D795B5115C59F665811058961CD92C58F65D7B52D6907DB7675C566C65694BF5FDCF70B7AC458B6FDBD6ED6B6A567785C1735CB775E369DB971DF574DEC9C3D16BD8D7FDFD795EF7DE0D68DF10CDD5845FB724E586E0B5ED573E6095BE16DEE330AE1D7E5E7685158DE19906318EE218FE12FF29776DE977E494FE2583E5F50E45316674DE5392E3D9964F9E37EB9E059AC7F7467D9DE1596E399BBA9A261F88E2FA3E955F6639FAC1966A38B6856D69F90E9191EB3AB6BFA0EBB8D6C7A4B43356C5ABE97A9E519369DB0DB34BED9A2EE9A6EDBA36B9B56551BEB5B869989EF19D67BB7EDDC0707BBF0F9C6CAFDEB7C56F5B24918AF179B673A8713CB6EDBAF11CCF31C0F3BCD741CFF39BCF2B9A5ABB8DB1BFF43D270BC175BD170DD1F5DCF74DC7ECDD7F59DA6B11FEE5DB5EBBF6E7D8757C774BDDF7DC878B9878FDBF63DD6D7BDC31DEEB3CA765E17ADCDFB1E1F95E9D03E6F2FDAF93A971BEDB3AD3FA5C9E87F4719F0F8DEFF89EAF73F779FE07C7F0771F7FA1ED7EDE77F7FD7F0FF9F23FC7DAFC1FFC047E6FA9B03F77AF015FCC0B802FB203C02822FC9FEB84796FADF53D47BD019F13F483CD50E4BE782E8EE0CBDD801055ECC1682900E093BF810DA60841D8150361942D65D0C5E442F750C0E0FC237D30FA0C4365F306E223B3408D021E4256FB0CE064468390DE264138A30A22744581CFC6154538A097D29C4988106A13C2C8C314A2B4298B11962AC698B31A22BC6289F10DB39538450E23846B8571D6364548ED1EE3CC4D8DB03E37C358EF20A409935571CE2D4648C72123EC8091B1EA33C8B8B724A3C46A8CD1FA4BC8E4DCA59D4BC19332424B49894326A42BCC90724E3E4946BD0E9D547F76AE4A2142E88102658C3996B29A54CB993F1BA47CA897B2565D4A273B2C2554B68E92AE59C3091323262CB897F2CA63C247EB2F266C415E5312574D498329267CC699737A5BCD69BF30248CDB941366724A39CF395C89A99693461FC3D9E138A70C6094B3427BCE09AB34A79CFC9C73E21A4C29D93AA6D4BB9153E678CAC93D41283CDD99D3EE135089E90526C50094F3A66E5108973261DBDCA373F688D0E9914828FCFF9FCDEA8AD27A493DA834EBA0B43266512A5946A99CE8A634B697D199CD4E681BE52D73BE93509A392B69ED45A7940AA450DA35502914FAA774E8C1C5DA894C25F54B9953D6A1517A2D4CA90D56A3B12A445589DA5F2A655AA5550689D5CA4B58AB2D6AADB4E2A5536AAB5CA8C1E72675BEAF553AA1552BAD49A6F4D2AED74AB75C2BFD82A9D612B99C193957E69D71B1143EA7D85B1F48EB4567A9B642A357BB35666C957C7C54A6B5535B3951EC759EB0F5E685D86AB3656C0D93B2D59AD5D6266D682D7598AFD692CEDAAAD365EDDD80AD76FAB0DB0B7B646C4DA68876D2DBDA5B37726C1DA8B1B6E6D1DCAA5D72EE95CCB4F712BEDD4851722EADDAB8B6EAD15C6B295B2ABD24AF1782D8DC093B73E82DDCB9B762F7DB5B877CAF0DE8B7F686D6DD6BB3742FD5E3B857D6E8DD0BDD6BEB75E5BF17DEFA5E9BE177F00DD7C13822E74F2B597CD09951BCF836FDE0CBFB812DE600C376DAEF5DDBF9886F8DE2C397A8FEDEEC2F87EFF60BC338BF11E31B718CF1861AC458D312DF6C5760ADA63BBA78FF1B640C6B90F16E1DC1583F0F637C958E70C645C50846A95A9C858CB2260EC5989EFB649CA795B1D606C8D85312641C70BAE3965EC9F582F5E12B657E730E55C8F846855ECC9799102E6CC9B96307E3ECC79BB30677C4196F3E65ACF793B17684C919D98B58BAF5A0326683CB9A3347E8ECFF95F4466DD0D89B37E85CF1A634BC01B17A7F506A1D45A8F526A5D4DA9F546A9D55AAF566ADD5DABF586B1D65ACF5A6B5D6DADF5C6B9D75AEF5E6B0202000E00FE000400010000000000000000010300010000000001000001010300010000000001000002010300030000009C1E00000301030001000000050000000601030001000000020000001101040004000000B21E00001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000A21E00001A010500010000008C1E00001B01050001000000941E00001C0103000100000001000000000000000001000001000000000100000100000008000800080093070000690700007207000067070000080000009B070000040F000076160000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{C7BADAA3-4258-4567-B03A-B9D1C67DB67F}', 'de_de', 'predesign', /*material - Blindboden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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'de_de', 'drawing', /*material - Brettschichtträger*/ '2025-01-30 09:43:43', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'de_de', 'findesign', /*material - Brettschichtträger*/ '2025-01-30 09:43:43', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'de_de', 'predesign', /*material - Brettschichtträger*/ '2025-01-30 09:43:43', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}', 'de_de', 'drawing', /*material - Dachziegel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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}', 'de_de', 'findesign', /*material - Dachziegel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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}', 'de_de', 'predesign', /*material - Dachziegel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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'de_de', 'drawing', /*material - Erde*/ '2025-01-30 09:43:44', X'49492A0090290000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D217FCA6552B94C0E592F95CBA593298C0A61339B4DE5F349D4F27000954FA61429ECE674FFA24B68D499AD028F4DA7D427F41A35469954A75469155A5566AF53A7D7EA563AC55AB947B15326969B3D16B36EB8576CD6FB0DB66F42B5DDA877AB2D6AB774BFDF6B56CC05C6C972BAE16EF7A8360B0D73C25CEFD81C4E3AC168BE65F0D6ACCE53079DAC673157BD1E5B3104C7E57559FD46AF53A7C962349B1D66D345B4DC6276F7EC8EF20BAFE066B759DDEED67F78E27274BC7E564F8B6EE7EBB17CBBFF4761D2EBF1BB3C1D9EFBA9D6E8737BDB9D2783A7E49DEFFB1DCD37B385DDEDFAFCFF2C3E9FCDF0C6FCFE39EF27DFD2C03ACFF3DF00BC4ED3DAFD2C503BEB04B65063F8FD414FFC24FA426FAC2B08B64FEC0B0C41EFDC1CBCBA90E39110C1AD04330844F0F436E1B5AFDBFF0FC56F832118C2F143ED1A3DF1AC6F1243B0E444F540D1CC6D17C4D1EC850B3A70148D243CB1C4991F2BB18347294671E37720C9B2B49D283AB22CAEF44932DC531D3C2EFCC525C89334D4E73952A48737A9B374650A39935CE9344EB3049F31CC33B45D383432F319414D5394C9404F33BA13362BD4251943C1733B4D024FD0D52B3E4E74CCE54346D4DD1CF1C8F49D2514D293D47552D41154B546D574B51F4C52153C6345D6150D6D3DCF12ED2F3FD70FCD7958D6B5D55F5FD832E4954E5895ECDB51D72C24951FD0B4FD93643DD66DA55356F672972057D605716841567D83105AB6A4FB6ADC0EF4BF4550975D9374C97715AD565CB6BC59745C776D0756CEF40CA77B5A76DDFF002110ADCD4CD21725FB7CE07785B148DE954DF10EE152C5BD516238B51178E0587E1CCBDE56462B87E458EE258DE316360184E4D2CE3D62E1961E2790D9983E555DDEB7E5DF98E4F80E7599E6BA0E7F946798D5BFA2E4995E379B4A37DDC3A568ECF44799689A92CFA65958CDBDAC6476CEA0C15DD9CD87A9E7B8BC4B826879F69F9C69796EB7AFECFA06D8FC6AF82C8FAEED5B2E9BB4ECD8E45B97DE6CDE853D6F1BEBEFC2EDBBE6F7AA611385BB85F0304706FA711A8F0FB75D9C5585C5F399DF23A36DFB9F0DC9F3D9A5A3D166179F4DC06B9D2693CD66FD6597D457368757C853C83F43B155392F69B0601D6EB4EC785DDD6F8FF3FE33B5DF765E1D55C660DE0EE18A567E9EC95E76FDAEF763F31C6FBD297B3D1EFFCCEE5E2F33F36F3E4F297D77F4C7C1EB69D757E1DA71FF4F79F57B1F67A1AF761E3FDCFE9DC2677EAF89D7BE8673019AAB586D6A31F0B8981AF797F3FB6B2956093C86E4956043DA6ACFF4B1BCC802DA15741F794EC5E23D5838F5CDB3D3780DA607AA874ADD55DC1985CEBE023A9344E55D0B078150DA014007ED025203F780B0F613C417D70721243F4770D20FBDC88AF8E0843C74F049DF4287C8BDE1137A736E822926582B17573C5A846C81D740E8CAFE62844288F064EE403880DCE1C46067CF663741A866D222CBD489ED8E1845F8ECF761DB9F6C2FF9FC4568A2E5A403F38F90823147290D05CD5C839110C63EC4D88D21DDB4448FD059C4C7E8D927646C13942F0A2749B8F112A354A8941172514AC949269F94699090DE4545A8E31FE383DD86B1A24E4985492EA55B8492F2A636CC0927309E74BB98B32659BD299921E1D4C3983185FC3829192B96949289335A624AB9B51CA0A46F79ACA651CD97E30BD3F4DF9710A586C799C32FA6AB929AF131973FC93D2D66C4B298F3BA714FC9E103E6ECD09F110DF6CF1A051EE72D089592F631C4A8EAE5E74D039ED44D2C3B99C733667CDB91D44A56C9F90B19E8B4FEA433A25DD1E38AFA23AAF0A213DE8CCA77C534682D296EED0A9852C97B4A2584E8A6B259CD3A6A773E69BBF3A652B648540A793D2825487CF4E68BD46A49425E6CA5A1354A7CD54A9B52A7FD429A4A69D241EA9F5127029D84D4DA8A51A3B357AA2D689FB58275C25929429E448196F392AFC555B90FAA2D2F8CF0E68E57CAE119A243FF557402295846B347A4CD7FA0F5CA73CEFAF346110591A9952DFA42A73B32A37CEAA18A26ACC4FAAD652AC3E5B1B15CD659AA5D352CC473B276AAB7BF591F46210D6CB1F06EB251598D434D7D73AC357279D6BB73256AFDB1B1080EDBD65ADD59A54DAF9F6F3E99CFA8233FABF557B4968669CAAA0F29A835CFB83602E95D6B7175680DDFB3B526E83FC5B514EDF599B4776DBA4EDBD8F46F75B3BE17CAC85EBBC3672D4BF79D54E2F8DE9BDB7D249DA6BB37E13AAEEB7580D885C8BC0DC6F2A4C96F49AE2DB2AC54B7095BCC1575E795DD65985308614B37826DDDA962B6BABDDB0C1B78B145C6BBD8AB00617C5D8871354EBA9863195D3C4F8C2E5E2D97E8B707DF6C634AEA85BBBF8E3321CB6ABA93A3A6489F15A9F4E4CBF4D4324CB9A63846C94FAA4F8964157DB0B96A5C61D917869A2D86CAF6299BE5E9636D692E58CC7981D555BC535B71AE2BC737731BE6DCA79DF345FEBEF856FCDE6CB16273662FCF98E2BF4329CD99330D968F56C6D9C77BC78FE8E523C679AE50D74B7F9E31542DD0F9E738530C0F79E2A64BC956062DE7B7DF6573BD3FBC8D1B22CBCD2B65F05E01B575EA9ED5AD6B0B24BDC3D4B9EB3F698D599BB1638ED81A0F62682D419D763DEFD8573B60BDFD8787F686846199470168EB0DA5AD3E8FD17905E5DC0C66ACB0F6D2DB7B1653DCAD050AF3EDCBDCDB37706E7DCBB7AF56CCCE117B1B5ACDBF8C71D6F3D79ACAFEECA4E3ACF3A672D8D97337ED1D779CF7B6F5DE942EC16BA6D7C3AC1706C818230FD43B18C0F8837EE3295F6BF11DB39BF8B68A969A237FEF2893BAF725B4DF15AEFDEA2DFBBA76C714A376F78160CE119A797F2BBFFAC686F28E2FCC680ABEE7FB23826ECE75CC3714AFD517638EEFADB5BE78967FE93B0FA6F51B5BBC357567CB9A9F4E727A41A6F06E94DFDD8B49D78E15CCEEEE92DF7D93B5A05BF9B572A63EC6993A6F650A69DDB5F713AD3A8EDAF74EE7DE2A8F808F3DEB9677CAA7D53A2F37E8FE2FC5725DEFE3781F24E0BD4FC9746B0FC03A7EFBF23D77CD3DBF0D5D66777DF43B72B8F22EE3CE77579FEF7AE28577EE7B58F57F2AEB3EAE6454DAED8F3B766AECD75BAE7A4E039B3B6799A3BEEAC1F5BF77A99D9F4CEE5BA3B0FB9D7DAD2ED721F9FD9F1A78FEADDC2CF798BA3F53A474EFBBC6EADF43897F735EFD6F289A643755E6DE6DDEF58CF75D3F1697F2747F9A7DDF99E43B478CACDA7F48FEEFF4C76FE6ED4E34F92CEAE1EF1300CF2AE52D74FA4F38F1D00AE1B00F021012EAD01ABB4DF2D92EA1024B1CB50FFEF2EE96F0F03EA9CFB0F02F51002FC2F4CBD0E6ACECFCCCB304AF2D02D03AF7AF8480F008C2CDC4F4AFEB062EB0E9AE39022DC6FC09AEFE2C2704CADF088F6AFCE67AFF8FA6F64D03000C0AFFCFF0D89018F7C9EADFCDDCE650B1079050D5702F06B0BAD490B5026E3F075052E84D9EE3D044F54B48F08C9AF04A750DCB44D6EF44CA50E708F0D30E4A8EC8CD530E10D6F9CC48674CCCEB4E48F82E82EC0BD9004C4510CECAA23106F9D01B110E75120E11124BC4BCEFD50B2EA4FBD0C8F95096FBF07D08109B1350A30850671370A90BEA590A6D7F11911F11D14ED130C10A0BE6A45114EDB15915F05B15B16EE18DC69D8ED316B14B1730F4C7B1010D50DB0E8DB90D90E2D430F70F0F411910EF0EC9E9194DE31990491ACF0718CD2E20208000204FF82416040082C26150785436130C8743E071186C4229128445DFF168A41E39118FC5E431589C8A3D19934A2351B92CAE470B96C6A5F1895C1A630E99C9255209BC767B309DCA66B049CD127F18A2CB2833EA5D025D27A7D3671479D546874AAB50E93499B54ABB57ADD529D5A92C9EA561AF58E6946B4DAE6B68AADAA9960B1562E56CACDBEEB5FB5572F132BDDFEDD7EBB50AC9418B613157590E371981C2DCEEF919E5B6F97AC45972170C3DC72986D05E72F8BCB5B2CDA2CADD23D92CC6AAA39CD0E02DBA7D96A3632999E936D4CDCE6F1FA5A56F781BAD96C359BBA071B539DC3F0B5DB5E6D1F89B7DE74B7DC3A8733A9C9DFF3F5B95E9F1FA153D5F6BC5DBA4777CDCBDC7ABBFE8AEF2BE193F8F5F91E4EAF6367F6E2FBBEECBBF2FFBE901BD2FDBF4D7BB2F7BCEC740CEF2F30641CF641E9BBC3093C700304F3C34C9C210BC3CFC438FF43ED643B0542CD044B0133F05C29113E6CFC5313C36B743115C08CF274C4BF8F6C1B11C651FC691F48317C2B10330F9471213EB1EC5F1AC731749326C33204A32ACA929C88EBC911BCB8E0CA12EC9CEE49919CA2DA48719B492DC8D2B3C922CD934C77324B0CF4D537BDD3AC09384C7214F508CD73034D38CAF1B3072FCFF33AFB434ECFD4F142BCB43C494150930C8D22CDD44C0F405272C4D546B474353CC152D455313F52F4754D494CB50549544F956D3F4CD1159C9F47CE55A4BB50D375C5774A57D5CD55314555FD7B39D355D54F62593605655BD9560C0B61D8D5E59F66D07625AB694BD5B48165B0B4EDA158D536B4793F5B2ED5C13DC51565C93A5D97354AF5D8B79CCCFBD90CD5D573BDF74DE1573D0B3475265BCE73C781BAD465C310D657BACF3BD6169B618361B81613424FB7945985E1F8B61D7CDBB8EDFB4A6237C463485078964369CD96C655666537A37F46DBD7D4559463163E379B44D9367925E6B8AE692565B5E41980C6B9D426CCDDB9C25192D9DA1E8D93E2B92E18EF69DA9635A565EE9EAF9EE5D88673176BB96661A6C5BA5DA9516CEFCB85A455F6E4B3B45EBA168983E83B8C118F6BD59EE7BC66F6DEB7686FBA7D778270BA9E63B0EE504E7FC5EE15AEF3C6F03C7EBF9DF21BA6EF5BEDD72DAFA1DAB99711CA6EBB467DCC6A1D0F26D570D6D2D1D074940C0DD5D39C536DB1F3DD3EB5A67597C657CAF6BDE6FFDEC61B5F4DC3F73D1F53857937DF89CB77578F9DBDEA9DA43FA2F19DC6ABBA707E7EE3CDCD1EBEFDE8EC9EF585E2F5DECFBBD46FFEDFA5F57C5DF3C1EA7D3B351FF6517C9D4F9D75DDDF45CCE98FE5D0C0075EE01F5BEE7F6F99F03C2619009FC3828028ED803CD692F2DF1BC07DEC71753E86EF069DBADF7DD055FA41483AD460BBB250F071E340A524D720FC2382CE49FFC097B90C1293657F8E460437A74B0D61439A7E50D1C23E47DAFF61743A7610DE1CC226F7082201FD8890D9AC3FE678C8E01C26402F05B0308806C89904498A2EE17EC548950822131782F1718A4466F9175F9C525DCDE9F42FC8B1079723FA856D01B54707E51CA1E42F63F1563F1B78ED1D63C4745ED1ED77B6F76D1423EC6A8DD0CDCEC298E7109E148F79124E16BE18912364DC4187EF6A4CC3E900D2A2B49090D262424218E714A1249E8F52AA4E2F295B28254C4C8BCBFA4EC7F92D2B240C9588B1BE31A27966F85FB4603A2C4E60A6D6ED2AE63418972A5665CB148F34626B9C8973361C4D7918A46644B79B928997C3B97D24A69CDD84B04664CE2922F9E4FC9A9693A5F846D9BCD621EACC9EB10E784979CF28E7BB9F9DAAD5CDC8BA0304A75C779613558CCB69A4D1E7FBCA9E33828750B7AB2F62FB3B9874428B5049B47CA8140E7EB03E3531280F19E23D0591D4968DB8AA46E3695CB4A5B23652CF898F2B9FE52F9454DA613E08194CE79B6980944A21C947B128618D2799D4F2A0464A1AE8EA13C6A9B19A9A5268E30CA462A3A8D45E9CD57A34AAE51C2A78F356AB49BAC32DEB1D40A39266B3D5D94D54E5AC3998B36E77D3DA312BA9C54155B48AA253EA9F216BAB979DD3CABFD37AF342A845458F90D2C3D6EAEF4AA8F535B1B2A25E56A9C938EA8515AE963E98598B112267DD914CD18AC8515666ECE0CCED85956AAFB05AF3682CEDA2AF956E88D51AF5452D9DA95D764AAF5849756A9FA51DB715C6925937E36A267D94A976E6D0DADB957167B5C797F5CA53573B81616992D18F371AE25A49C333698DBA9A139AD94D9BB158AD85D5827746D75E0A4D79EF358ABD5604F648B97775D3CCE8B873E6345A3B852E2F5B6FBE75C253DCB91560EFAC4FBBCFDE6C5D37A178689D07C14BFEAA5C87A35BF0A611C1360306529BB3526F45EDBE15DA90D20B996D711E07C3B84AEA55EAFB735D8CD4BB574121DF2C2F37F13DCF78716EEE62EC34EFEDB5E3C1B8FA69632BF78D3125C9BBB8DA84D0FB2D691BEBADB9D53B0246BC0D8CE3FDFA8F93F6A1E1BB056FF08653C87956D7CAFBFF3B32D4F464999DC740DCB990314C45C57532C5CFCB354BB28E56CE2EAB3BCA8CDF3FB34E7A8217DB22E00AB8B8EF256DACCD8AB4688CB969E25565B65A3AFECFAC4D8C74568DCFFA2D2D616D0592F0D4F7B2B8EF3A66BC593E73B6218B588F4FE6CCCDA8B386ACD278A2A9661A31A7B4CE65B6B5EF16EAECB376EA3DB7D51AD75FEA7B9396F52389C71AF72265BD4B64742E84AC941B4B5A5D31B4B5E558CA5B3659488D0D5834AEC3C2FB2F2A65FA7FB830E681CDBA6F0F6C4C1FBAB0FEAAD41B97586EFDCF9F379EBBDD7A470CD5CC85596A6DF9CA3BFB63E57C9EE1B2C694C1DBB702EFD8B3B91EFF07DDD823716EEDAD849F66A5C8FA4ADE70F7B9BEE0363AE357F38C599BDF74B5F635AAB7978FAE2D39ACF8F7269D5B9AE1F05C2BAEB90F24E6DBE39C6F2E73CA6946F9E4DC2B88F3FDFFB8778EECE7C816145BE993C4F245BBE83CC300EF5C6FABFA6F53C611A331D9CE0B4338772BAB3D530074A80B47ED467BC73C8FA175DE9F52BB46E9BEFCEEA2F52B59D16F4F37D3BCB7B74CAEDBDD3BD7726CFD8B91625DEDBC3C1F47EC125B8675EEFBD5FC2F70D5BE0B7477CF0FD13376DAE2FC731ED6BDBBA1F6A53DD19B7B93ED3D9DE731E4CFAD3E9B4BED16ADA276DEB189F93B9A6A9C95ADF3CF81EC79AA30E22F4176337FB2E6BDC7DBE7ECFB3EF5C678F8763B537C8DCFEFBACEB9F739CBE3DEEF97B037BFB4F93F0BE7FB8F8370799B79F3FF739462FF498FFCF79BDB8D67D52E8D653C7A4FE6E73E9FD07DFFCFEAF80FE1C6F67FF5E02F17E13286B6C54CEAFF2EECE78F7EBACFF8F60F2100EF76E5CF28F22ED29B2FF0744F12BBF00472AF2ECC2E2EF9B031018E5EF269C902CB2503EDAAAA8E80E2AE86A7F0065F484C82278F024E20E649A2EB6FC504879B067059002E9D05E9CD062EAD01AEC2B68F24A2305AC0AE00F20F9B01104D06B08EE6908D014EF3081009007092F1907B084EA0AFC980F1CA14F30DB10ACEEAF14E28EF0EC0DAD0A5078EFCE0F0AAE5509D02B0C2EAB0B0E74DDE7AC6E0E0909060F0C90AF0A70E6FFD087036DC2E990A0E130E86270D08B3098CBB10AE1B0C4A3C603116E0706F0D50BB121112FA10CCBC50B30DB0BF12F11F10F12D04F130F1F0F0FF3056EF8AD8F46D1EDA0C8D14EFF4FE1154B3914CF5B0E1152B3715EE49156FE6BFCD9E8B4A46D68D84DCAF98F6717D0FEFFAD8A8D2D82F8D18AA90BA9180F10D8D186BD8E8E3482028000204FF824160D07810020F0B7FC26190881C3E170E89442151583452191A8C43613118AC7231228DC82251F9343E492794C962F21944760B2B8B476691998CCA3D2F964F2552D9ECEA77429BCDE2739984FA9336A045A8D04A7CE29547A9D3A9B2EA6556A559A8CCEAF5EAD582895F9AC8E515DA859287659946AD16BB6C82DF24A8DCE5B75BBDAAED4ABC5F2D562B35FAC369C158F0770C05C65F7BC3626B354C7CEAE97ABCE1F196CA0E630391ADE6F354BCF677158ED0D52DD7FC25735188CFE674792CA65B5767CE6BB6D81BEED74B3F8FEEAB1B0D96F781B7D06BF8DC4C870373BBDFE2B97C5DF69B63D1DE6AB0FA4D16FB69ADEAF33A5C1C6F0F7997E877B09E4E47765DE8F3766D9CFEA7BBD7D3F171EADD7D4FB793F3FC6B39AF8BB6FB3CAFFBDEFA404FDA7AF834300C10FD3F2F941501B5CC9BFB08C26CABC3093D50A432F8B12A2C0D0F41EEC42CF53390E3EAF4B9B1440EEE4570C453072E1103C118C08FF44AFE47306BF9113FD1547920C4D21C34F948111C64F648AEC48F1FC88EFC7D2549B2945D2148D27CAB2CC9D1BCA6D9C4324A912EC2AB3CBF22C19304C6AD34F1AC5B2BC6732CC50BCD91F448B94BD39BDB33C97244CD3B4F13DCB735CE93E4AD4146526489434DB444B8F3CEF28A911DC0AC2C6D2B3F71A5072DC3EABD2537537354E12C47B5152D42437185175345F504FF38D554ED194FD5D54AA54C52B2D5655C555464F5585775FD3D605634755B52585604A960D9564D876559B6658F4D5A2BED7D695AD67D1F43D916CD0166DB134D3308CF56FD676850332DAB1644F50C6EF25D3545D7704F3035CD5B40777D28E35F152B457DD7537DE53ECD97ACFD4ED1515608C5DD9723956E5F8BDD937C6238754F62DAF6DE158B618E762965CEF89E34FBC3B7FB9F1CE1371D8D6B5CD8DC9AB060D8ECA13464751D0195DA785E6F80D66EB5219D3C79C62F954C394E6DA0E5F9F66B326917F68D786533ACFF84E1FA76937CB89A2E0EE66992569996672ED5D19833F716C555E67ADE3BA5632C36BB9268746EE16FEA5346E7AAEB14E63FA0579BCE438F383BACC5C0689B7E5B57EF970EF134CD7C5E8193F1BB2E63B8CB58871399DF99772B5BF249DE8FCB64599735C8F2F8C6D9CCD69CA559CF737946FDD5731A8E951E6DB76EA9D1E9B7CF057BCFDD76BF49F79D6EC7BD749E0EFB6F4F9ACEABB3F77D0F7B7EF21C9EA9D9F65DAD899E5B5A16FFE176FC478BE1F4FE7FB7E67B1E97A0E15BBE6F0BEC77FDCE77EBE8FF26FD6A3637B67BD2F53F1637FA69FEF7F5CDFF2E99FAB0D7EEF7DC54007DCBD2033FE7F9025DB325818E0E02C03802C71563AC458FB144BCB568D79E73DD7D4C55EE20083504DB036B7C4D7211C0762CF2206AEC858DBA15C297928DA17BAB6D30695EBDA7E0F19F0BE783F011F5BE06EF07A1DBE87F70F5F4C4589111E2541C7DB0CE2039F60108A2243250B10A2B419690A5E1BC5B77CE69B44318AB099814418C90963343C5D4E8225BC05F50BA1D45983B05A044635CB162091B88F1125C24108F919E2640F83B0863F4466E0EA234C817CD0921844E54503A3B410758D4E48C5192D211BB4716FB24E4342D8BD1BA4C47F9431B104C9A67B12A21C8C87CFCA45CA479B0621FCA97CB251E53B092B1AA394B491B2751749077ED423442A975281AD2DC772BB9B2A0171D27DBAB267C0EBE5549E73B0A9904669AB09E5CB8693EE8A42CAB8FB3120539C9931E26BA0287336D8C4A87E729A304DF987152584EF984DD27649996EBCE56C509E11EE6C4E89C137270B8C8F33E9E3CF56AEF51674AFA113C8E2C6BA08EEA404DE96D43227D0E93C8668B4DD5E345E79C837F0F7A604D49DD2F15AB8F9FD2721FCA3A0341A453DC7FB28A3D49B9C949A5FD2095D43E27CA5A074C0A4CD38294D573CF9A7323E91CFFA894468E465A6D4E22953C9F749E71D42A353E2474368073A9ECCF76053C5624B24713F237B56A6E9CAA1D566F7569E9D62A56C068CD663EB5B68A420AA714297CBBA215C6B5D2192F14AAF54EA5B476BF54CADD5EE7B4D1AFF44A95549B03596BC58D7CB4FAC4D76A0F3E672D649FB1FE584C8AB566AC8CB1A591BACCB87B2F61DD9D9CB012CEA5B088EB2267153BAE552A4B428AA1522A3D2EAA326267495B736B2D95BCB6F48A664F5B77476E1C04A5157284D29AC75CDC0D34A3F72AC158EA8D5E6D3DD4B114C6C35D6B1764AC3DDBAAD71E414B8B68ED2D9DE2B1516A60C1B41F7169E5ECB49176DF34BAC1072AF5EEBAD7DAA4DB29956AEEADE2B43046D65CD9FD59E8DDFD8175A19CDFF7ED806494CF9B5816EBD837E1221EAE15BA3772ED5DDC355AEBAE19669632C7DCEBD5743105D3BA53430DE02BB3252C84F496D39F13D0AAD58955CDC9B4B3671B361C67862B4E3187B5C2D4561BCF87A1AE43C7B906556408DB91D375E0AA58E6E0E4FC7C8D2E4555C8D887043F1B3F6AB296489F1956D4E29CB1675B965BCC77633461EC5572EEFE2282787729CDFCC16B6EF62CCDD8BB15E41CE197A9EDE1CF94EB3AE099D740F22E3C7899C689E7FB997AEF9CC5BC7A222E603A9792A63D0BA498134BC86D0B89B43E998DA85318606B07A0351665CB379AD1D84C6998735667C239AF57E62D479B3486A5D3D7EDF3528D316C6385E5D59336DFD12B2B22B61D74D7B7C62A6C89DB18F62CD2D837B63AEA1C85AA661E0A417A3728656D3BB4F58E3FDB0FFF5F612DBF8CA955A6DBBB9AEF4AC89BAB35AEDDCAFB676A6B4D15ACF77686DE1BD77BE81D39BEF6D6FCDD9BD9D7E13BF9AAB03E0CB4183AAFD6CB3FBA3594BEDE3C1F70ED5E1192B1AD81E1991263551D37C5E2BEE1BF13778FE1CD9FB1391DF7D8FAA790F128C55035D60FB80EA989725B27A5371EADCB5A9E74E66DE9AAF1268BE77ACB53664E73CE37F73DE7FD1F76AF1CF7A7F1C6A8AEFBCE86734D25C27A7716E9BBFD08757C97B6F7EDF4D2DD6EF2755C37A6FAED05D1F0C3275B6B5DCDB14617E6F9E72874BECB9D3A0682ED7BBFB6F3C959DC2FF67EE8B1D388E69EF153779774DF1C7739E54E6B9DBA277BD6CF8F9D788F172F6A2F73F1DE1FA1F42F21E35D8F0FEA5CB219789F43E4FACE3BDF37A3A867CF3F73DE47A2A23EBB266FAA1D563D8F0D5234CE99753F69C3FBD545AB18B6C2F85EC5DB35BFA4EF3CFBC677CF33F0BB3714E5D4FF51614E08EDEE470EDF1F5B74DA2FAFF6AECFD2EE1F63DB303E75F7AF7E4FE39EA308DBDE517C3CF727FD3FBB685F2B75FB35E7F2E0DCA772554B89FD2CC7BEE26CEEF30EC0F86F06F0CF64F8CEB1006F52F4EF89004F8ACBB01B020F60F78ED0FFCEEECF4FE08D8FD4C46E5AA82B71030E4CE56FD7042FEA96AF4101ED76FE2D92FF7046CDED7AD70C20FBAE07062C00F58EBEE2AFC3061070DAEF02E20E0CEFAF7506CD18CB2FC0E6D088ACAFACDA500D078F7AE88F2CF22C2D09907CF9101509D09B0110AEF36F950B2F1ED2AD72F47096B5F012DEEF9D0228E4F76F4AF3506F0CAE14F4CDDB0C8D8102D0D6F6B018F6700E8A6F284C8D48FA6F250C090EF2B01CB2D002F2EDF4ACF024C3EF98A82AFAB6B0B07DF09F0B70F70F110667EF729AD000D610950A4E90F0901712F0A6EDF1111250E90ECE630E30AAF8113B10F0D10A8D26EBF0BB008E2F10D0D5130EB8EEAEA9156BA10DEB85082E8CC99162ECCF350EB0F2D5D166CFAF38AB31330F919116EFAB02B19500B16B1430A312719D0AB18119B026A4A6322028000204FF8240A0C0082426150B7FC1A19098743E1F11894160F088AC2E290C8DC661B038F4523B1390466471C92C7A3F079549E3529894BA492C9545A31339ACDA5B179CCAE2B32944DE7F3C9CCCA812FA14C64B479F4866138A2D124D4FA0CEE93539A4D68D54A44F62F57A1D827551B142ABF5EA5D7E9F4C885A6CB55A755ED963A6D6AB966BBD32477ABBDC2F16FBA5B70175AB5FB0B81B8E1EFF689BDCF094AB95F6BB88AC62B0D90CBD42ED91C1DEF258FCAE4F3782CB627458AC75F3398CB3E9B4764D2E6B6361D9E62E3AAC66D6FFB8D86BB7599E069F7DC3D96DB5FC7DA6F6B1BCE471AC3CCDFE5393A1E6F17A9D1D070667ADEBF1349AEE877BA5A2D4E7EB783C17973B79CFFA7DBE3EB77FA9E1EEE2FC1E6F7F67E1F2F56EBD4FEBC4FD3B6FCC00FB38EFA3A6ED3F8FC3D6ACC10E341F013E4D441904C0305BD0CA40AE9C36FDB84F9C2AE74451041B0B3E30844313C550C3730FC4CBF43B0945CC846309C470E453053E0EE46D15C67033B11AC7F1D4811BC8D22BEB2247B2543D24499194A125C8729CA326C851F4AB284AF294B12DCA92F4B308C88CF2B331C08B5ADD16C9311A4533C332D3D8C6C730BC7734CE9274D93B3AB27CC92E4CD37CFB26CFD2FCE341CC339C0D314A91ECDB405111351B3547132C8F433DCB2CC0FFD0AE54833D4FF494514C51F4AA90F3D412C52F17D4943D293C5512B53D4251D12CEB5A4F71A5375BD5CA0D4D4E57156D555DA6D455853858145D0558566EC50D4CCDCAB58966C1968D956854757D8D53CF96BD3F5F4075B53B06DA9634793BD0362D9CD5D656D4F3395973BD1958CD762DE3755E76EC9171BE973D836DDED74D4F48DBD7F3337D5117E5572E3B974D89865B964D595ED754B5875CDC2D661F565AD706136561B67AC98962F90E2D734DD8FDDEE5E3318DCB8D63A95E0D5156798DC38064D63CBB8CD537856B8C63979D359FDFB8F6417BE8994E8788E759EE49A1543913EFA45AAE5659A5B417DE8B4860FACDDB80EAD813AB9A621845B1B260BAE3ADAC6A5B4ED1B165D7464EA96938A5B39E6DFA4E8391E278AE9D7A68F766E1B5EF1AFED17C637BD66B95F0B52F17C0F01C365EB55AF9B6EBB2EE3BEDA599F1B98CAFCA423CF727C6D79C5731C6705A9B37CEF44BA73FD5AEBD6AD5CCEE9D8429D3ED99FEDDD9DE582591D7F5DA8335CA5F1305EAD8F73B1F77DEECD50F1FA6449E6C04E651BE5EFDCAF11BB651E3F2DD2F1D81D57E166FE8789D439FC27B9D97BDEAFC1A36EFC8EB7075E5F5D27DE6F7DF66566751E07E9C3FDDF3F589A1DB3BA5DCFEDF0BCE6E6FE592BDB76B01DEB3518090290D27165ACEDFABAA67103CED360818ED1F23D8801009FC3D16E50155D4137FA7F9E4BEA74300E0F37D835092144175D6FA6131BB5A6E91F1423820FB1F441577EEBA1EBD77D90D620B377B5061E53E684311DEFC3F86503621C3A746FDD0FC4C5F307DF4C20823005E442C855171FB3838C0D922B3C5892FFA30C67896FC62726A7F51A8E23D48B47D53232D355195BFC598BAF9631B9B8A509D00C2F87718A3C2E48DB0D23FB3976D11219C258531CE4244A88C5B9E9C7E8FB13E22C83860FF59443989F216462AE61D25E35CA485B27653C388F4CC24B49E40AE497B40B9571CA2AC927DB141AD3B890EF762FBC668AFADAAC689052E652B90970D7638CBB8E7301CBC85932BFA2B37985AE26534519310764D4D694B345CBCC5927309D23F28E10FA704D796F0F66E39A9CB06E44CC64FF389C0BE3844ADA74B3E9BCF6E784D29C9351E830A452F6676CE38390F1FFB6B6DD3064F4C69992EA3022C9032DA844D38F738DF9ADEA172FA86D058630C661C80A0931E6CCEEA3D3B1714AA9C92A1FACCF89B4669049093736A59C4EA513DE925189692F4F24CAA1F39A74CF2A072815CCCE8B74BA90B7CA132229E53A5132D960D1DA70D8647C8D86B4FA44CF04611627DB54AB14D1E652BA8F3CEAE32A8A956503D5BA5F456A7B7A8DF5A6AEC8A9FB51A91ABFA8127EA5462ABF10A9AD12A3F5CE5754CAE3516B6580A455BA98CD59F95EA3E3DAA6F3E6A8CE747F53AA24C4A275EEAC55696B2C6BFC19B1B6322F579AA1676B3CC8B1D606C5C96B2117699C24AD76469CD63B3CFF2C15A88135D9A6D78ABD01ACCDADB694A6B85B16956BAD0ADFB6CEDED2CE5AF86DEBF48AB8F6F296D93B8700AE5C7CAC33BEE4C48B09652C349CA21555F7B5E9D7236953B7A3158657D4ABCB7665BD8ABBB6226C5EA65345EAD5E8A2376250C77AEB19ED4CF8A4D4920B57D9174CAFBC5FBF3342FDDDABFF25EFED85B2D6FDC0554AE8F727D5BBBF98166B609A4F2B655C14C2581AE7DB2C2180303DFEC1B102DEC91A93682EC50AB92DAAF25EBAC932EF34BFC48D5F175AFBDB8AF1AD2FBCF5DEC9E0EC54EC6E75ECB95755595D157F8F2DF5E1B596FAFB5DFC2B91278E01C9760F29D14A57255775ABCACF06D9E5BAAF70324E25CBD7E32EDD7B61759E1E65CAB1A7335AACD5782E4660C3758B1B530AC0E9973E3EA7792B3854BC9D78F20CD9B4F2F3405A3B07A0ECE67CD096EAC2DDECD77CF3D3408537D719E46CED876C0E68D03A6B4369BB6F8BEE0E54CFB9D74E60BD15A3F10568D4B8CACC69781D98EEBE5AD3B9B3514BCD65A9E8D6B0C61AB739EAAD47A7F593A0CE5A7E5943655AC4B532B5D933CF48D4DB37807446D0B1BAE366652B1F40745E92C51AAEB1E96A1DA836D658C356E74CEC4DC9AD76A573C0795F2866BD15B3773629C8514F4C399DBD47A58687BB741B7DE8ED1BA06F8474C630BB7ED16E0B67E7BDF38858B37FED9DD3B4DBE5289EB6D779E1EC917436B486BD19A73FE64E3B80B28611D431E77071CBA7C5B86EA4DC9C8B26437E3F7538DE45E33BC36D4F6E2B8339BEF6E67CBB8BEBAE6589F42EC5E12DB71C50CC5BD1B94E37BE5AB2B7EB499393B8557FE19B83A9F0BE9952341F3AC438674F70EC8FC8F9C6AEC9F87F04618B9982F9A6E8CC59B7B1EF5E4946F836C7E7783FA69E7D97DDB8CCFEE81D273F727CA3CBD23CA1E1ECCBBBC12D2B0AFC1D87DE52B361F6CB8BDD636731CB9AF378EBED673A337EB38C9BB7466E5A9F4DFC4D43EB8E5760F03ED5E3375614E55E7B54792F4FE17C06C6EDDE6BBCCD8D7BE5773F5DF5BBAD6FD3DF6B9DEE6F5EE9DCB76EF9C8AFB6FDC22AF05EDBC0ECFF25B47E7FCEF20BFFDFF78F5D6F683D66EC5E5BD0BCFF93C9BEFF1EF57AEF6E46EF33B0BDBEB1FCFE1D9C7B08CDC97B5EF7ED989BBF7ADE7BFCFF0FACF75FEFDA774EF8FD2F5EF8CED2E7CFFADE8F927A4DA4E90F16FC8C84C7701AEAEFE0F49012E82EA5020CEB01D016C7B026D5EAC8D289E8F10E1AF78E30EB6BE8ECCC27048AD504103AF54FC4A909B704CC3905D0430549A8ED0FD8F6703CFEAED7002A4AEC8FA6FEEDDCF98E4107CC15058C87088ECEEE707ECE2EA287709A81EEAAC74C72EC50A2F1709EA04E88E3F0AACE70B6DE30BB09D0B2E86DF8C80EC2F56E58FCACE3080EDEEC0C9B096BF4F630CF0090DAFFEE7F0D4E350DCC090E09BAFB0DB0F5309105EF1B078D6F08500CCC30EEEC0EB50709FEF32F07106F82DC6FF4EFF11507AA6C874F1EEF912F092FA8FAEF8EFECEE30828A1132EACF29122D90FAAB2B14F1370F0B44FBAB2494496116116316516716916B16D16F17117317517717917B17D17F18118318518718918B18D18F19119319519719919B1802020000E00FE000400010000000000000000010300010000000001000001010300010000000001000002010300030000004E2A00000301030001000000050000000601030001000000020000001101040004000000642A00001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000542A00001A010500010000003E2A00001B01050001000000462A00001C010300010000000100000000000000000100000100000000010000010000000800080008006B0A00005A0A0000690A0000590A000008000000730A0000CD140000361F0000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'de_de', 'findesign', /*material - Erde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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'de_de', 'predesign', /*material - Erde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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}', 'de_de', 'drawing', /*material - Eternit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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}', 'de_de', 'findesign', /*material - Eternit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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}', 'de_de', 'predesign', /*material - Eternit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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}', 'de_de', 'drawing', /*material - Gips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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}', 'de_de', 'predesign', /*material - Gips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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}', 'de_de', 'findesign', /*material - Gips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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}', 'de_de', 'drawing', /*material - Gipskartonplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}', 'de_de', 'predesign', /*material - Gipskartonplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}', 'de_de', 'findesign', /*material - Gipskartonplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}', 'de_de', 'drawing', /*material - Glas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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}', 'de_de', 'findesign', /*material - Glas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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}', 'de_de', 'predesign', /*material - Glas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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}', 'de_de', 'drawing', /*material - Hartfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}', 'de_de', 'findesign', /*material - Hartfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}', 'de_de', 'predesign', /*material - Hartfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}', 'de_de', 'drawing', /*material - Holzschalung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}', 'de_de', 'findesign', /*material - Holzschalung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}', 'de_de', 'predesign', /*material - Holzschalung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_de', 'drawing', /*material - Kies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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_de', 'findesign', /*material - Kies*/ '2025-01-30 09:43:48', X'49492A00FE070000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65367906A7546A553AA556AD57AC566B55BAE576BD5F9CD42C163B2596CD67B45A6D56BB65B69562B75C6E573BA5D6ED77BC5E6AD70BD5F6FD7FC06070583C2516F985C4627158BC66371D53C3E3F2593CA6572D97BEE47319BCE6773D9FD050F35A1D26974DA7D463747A9D66B75DAFD858357B1DA6D76DB7DC5860BB9DE6F77DBFDAECF81C3E27178D88E171F95CBE6736D1C9E7747A5D3EA5BF77D5EC767B5DBA7F5FB9DFF0787B7D0F1797CDE7DB793D1EBF67B73FEAF77C7E5F3C57C3E9F7FC7E6EBF6FD7F7FCFFB64EF40101C0902ABCFE40D04C1505A7B0441907C2108A59074250AC2D02C290BC350DBEF0CC390FC40F3C3D10C4912BB311C4D14C54E5C5115C5D17B7B16C6119C68D7C651AC711CB431BC751EC7CCAC791FC8521B1320C8923C90CCC0524C9926B252349D28CA4B34A129CAD2BAB52ACB12DCB8A74B52ECC130A892FCC532CCC9D4C933CD535A6134CD937CDF374E139CCD394E93BCBB3B4F13DCAD3D4F93FC9B3F50141C894150943C7B4351145C694551947C574752149C49495294BC374B5314DC254D5394FC174F54151C095154953BFB5355155BE95555957BDB5756159BCD595695BBBF5B5715DBB081A028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBA9D4ED3D4FD4150D4551D4952D4D53D5154D5555D5956D5D57D6158D6559D695AD6D5BD715CD755DD795EA9C80800E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000BC0800000301030001000000050000000601030001000000020000001101040004000000D20800001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000C20800001A01050001000000AC0800001B01050001000000B40800001C010300010000000100000000000000000100000100000000010000010000000800080008000F020000EB010000EB01000011020000080000001702000002040000ED050000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'de_de', 'predesign', /*material - Kies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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}', 'de_de', 'drawing', /*material - Kieskoffer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}', 'de_de', 'findesign', /*material - Kieskoffer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}', 'de_de', 'predesign', /*material - Kieskoffer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{3A3457C6-22E5-43CA-80B2-F0ED64BFC862}', 'de_de', 'drawing', /*material - Konterlattung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{3A3457C6-22E5-43CA-80B2-F0ED64BFC862}', 'de_de', 'findesign', /*material - Konterlattung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{3A3457C6-22E5-43CA-80B2-F0ED64BFC862}', 'de_de', 'predesign', /*material - Konterlattung*/ '2025-01-30 09:43:49', X'49492A00FE070000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65367906A7546A553AA556AD57AC566B55BAE576BD5F9CD42C163B2596CD67B45A6D56BB65B69562B75C6E573BA5D6ED77BC5E6AD70BD5F6FD7FC06070583C2516F985C4627158BC66371D53C3E3F2593CA6572D97BEE47319BCE6773D9FD050F35A1D26974DA7D463747A9D66B75DAFD858357B1DA6D76DB7DC5860BB9DE6F77DBFDAECF81C3E27178D88E171F95CBE6736D1C9E7747A5D3EA5BF77D5EC767B5DBA7F5FB9DFF0787B7D0F1797CDE7DB793D1EBF67B73FEAF77C7E5F3C57C3E9F7FC7E6EBF6FD7F7FCFFB64EF40101C0902ABCFE40D04C1505A7B0441907C2108A59074250AC2D02C290BC350DBEF0CC390FC40F3C3D10C4912BB311C4D14C54E5C5115C5D17B7B16C6119C68D7C651AC711CB431BC751EC7CCAC791FC8521B1320C8923C90CCC0524C9926B252349D28CA4B34A129CAD2BAB52ACB12DCB8A74B52ECC130A892FCC532CCC9D4C933CD535A6134CD937CDF374E139CCD394E93BCBB3B4F13DCAD3D4F93FC9B3F50141C894150943C7B4351145C694551947C574752149C49495294BC374B5314DC254D5394FC174F54151C095154953BFB5355155BE95555957BDB5756159BCD595695BBBF5B5715DBB081A028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBA9D4ED3D4FD4150D4551D4952D4D53D5154D5555D5956D5D57D6158D6559D695AD6D5BD715CD755DD795EA9C80800E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000BC0800000301030001000000050000000601030001000000020000001101040004000000D20800001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000C20800001A01050001000000AC0800001B01050001000000B40800001C010300010000000100000000000000000100000100000000010000010000000800080008000F020000EB010000EB01000011020000080000001702000002040000ED050000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{316A773B-97FD-4230-9C51-08065B16A225}', 'de_de', 'drawing', /*material - Lattung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{316A773B-97FD-4230-9C51-08065B16A225}', 'de_de', 'findesign', /*material - Lattung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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{316A773B-97FD-4230-9C51-08065B16A225}', 'de_de', 'predesign', /*material - Lattung*/ '2025-01-30 09:43:49', X'49492A00FE070000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65367906A7546A553AA556AD57AC566B55BAE576BD5F9CD42C163B2596CD67B45A6D56BB65B69562B75C6E573BA5D6ED77BC5E6AD70BD5F6FD7FC06070583C2516F985C4627158BC66371D53C3E3F2593CA6572D97BEE47319BCE6773D9FD050F35A1D26974DA7D463747A9D66B75DAFD858357B1DA6D76DB7DC5860BB9DE6F77DBFDAECF81C3E27178D88E171F95CBE6736D1C9E7747A5D3EA5BF77D5EC767B5DBA7F5FB9DFF0787B7D0F1797CDE7DB793D1EBF67B73FEAF77C7E5F3C57C3E9F7FC7E6EBF6FD7F7FCFFB64EF40101C0902ABCFE40D04C1505A7B0441907C2108A59074250AC2D02C290BC350DBEF0CC390FC40F3C3D10C4912BB311C4D14C54E5C5115C5D17B7B16C6119C68D7C651AC711CB431BC751EC7CCAC791FC8521B1320C8923C90CCC0524C9926B252349D28CA4B34A129CAD2BAB52ACB12DCB8A74B52ECC130A892FCC532CCC9D4C933CD535A6134CD937CDF374E139CCD394E93BCBB3B4F13DCAD3D4F93FC9B3F50141C894150943C7B4351145C694551947C574752149C49495294BC374B5314DC254D5394FC174F54151C095154953BFB5355155BE95555957BDB5756159BCD595695BBBF5B5715DBB081A028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBD334DD3CD82568088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBF1FA7D7CBF3FB7E7F5D7FC7EFFCFFB8EFEC0101C08DCC0502C1104B5703C1506C1CCEC1907C2509B1F08C290BC30C1C2D0CC390EAEB0DC3D10C44B4C4111C4D13ABB12C5115C58A8C5516C6118A8917C651AC6C9BC691BC751DA531CC791FC808FC7D20C8922A2B21C8D24C9485C9125C9D2749B27CA522CA329CAD1E4AB2BCB51ACB32DCBD164BB2FCC511CC331CCD0E4CB33CD509CD335CDD054DB37CE501CE339CECFD4EB3BCF4F8CF33DCFCF54FB3FD04F1D0341D0CEE50B43D14E9D1345D1CE651B47D24E2D2349D2CDF52B4BD34DBA9D4ED3D4FD4150D4551D4952D4D53D5154D5555D5956D5D57D6158D6559D695AD6D5BD715CD755DD795EA9C80800E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000BC0800000301030001000000050000000601030001000000020000001101040004000000D20800001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000C20800001A01050001000000AC0800001B01050001000000B40800001C010300010000000100000000000000000100000100000000010000010000000800080008000F020000EB010000EB01000011020000080000001702000002040000ED050000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}', 'de_de', 'drawing', /*material - Platten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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}', 'de_de', 'findesign', /*material - Platten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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}', 'de_de', 'predesign', /*material - Platten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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{5EBA1CF0-581D-4897-8CDE-CE90D68377A6}', 'de_de', 'drawing', /*material - Platten 20cm*/ '2025-01-30 09:43:50', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{5EBA1CF0-581D-4897-8CDE-CE90D68377A6}', 'de_de', 'findesign', /*material - Platten 20cm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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{5EBA1CF0-581D-4897-8CDE-CE90D68377A6}', 'de_de', 'predesign', /*material - Platten 20cm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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D50A602B-AB65-43E8-B1B0-AC7CE0240181}', 'de_de', 'drawing', /*material - Riemenboden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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D50A602B-AB65-43E8-B1B0-AC7CE0240181}', 'de_de', 'findesign', /*material - Riemenboden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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D50A602B-AB65-43E8-B1B0-AC7CE0240181}', 'de_de', 'predesign', /*material - Riemenboden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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_de', 'drawing', /*material - Spanplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_de', 'findesign', /*material - Spanplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'de_de', 'predesign', /*material - Spanplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'drawing', /*material - Trennlage*/ '2025-01-30 09:43:52', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'findesign', /*material - Trennlage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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'de_de', 'predesign', /*material - Trennlage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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}', 'de_de', 'drawing', /*material - Estrich*/ '2025-01-30 09:43:52', X'49492A009C0A0000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D1E7FCA6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65367906A7546A553AA556AD57AC566B55BAE576BD5F9CD42C163B2596CD67B45A6D56BB65B69562B75C6E573BA5D6ED77BC5E6AD70BD5F6FD7FC06070583C2516F985C4627158BC66371D53C3E3F2593CA6572D97BEE47319BCE6773D9FD050F35A1D26974DA7D463747A9D66B75DAFD858357B1DA6D76DB7DC5860BB9DE6F77DBFDAECF81C3E27178D88E171F95CBE6736D1C9E7747A5D3EA5BF77D5EC767B5DBA7F5FB9DFF0787B7D0F1797CDE7DB793D1EBF67B73FEAF77C7E5F3C57C3E9F7A7457F1FB99FDBF8FFA7EFF25501400F040902C109840EFEBBD04BD705C1D04A06BDA0508BCF0842CFDC26AC4370CBC30C43CF8C3AAE44710BB11044CF644AAEC5714B9B1445D0BC2AB1C5B18B951846CEFC6AD94671CC6F06C7D00476AFC8720B791C48D13C7AB3C8B24AAE87AD52449CE9C9B1249729C288226D292852E4B117CAEB2CAB2FA8D31A69333F3204C9114C2B24D135A7D37A6F392912F4E0E34E8AACF33BA6B3DB74002B33B4F8E1CFCA6D0B41C19402A543BBB2D510F9518A3D2347A5749CFF2CD2D4A38F4CA814E5347FD3D3ECDB434D54FBD08000204FF824160D0784426150B84408010C8844625138A4562D178C466351B8E436071D8CC3A41218747E4727944A6552B964B65D2F984B2453184CCE69379C4E675349B4EA7B3992C9A7743A25168D47A45260B3F97532954FA85464F4E9E50A8141A9566B55BAE576614187C8EC15EB2596CB54A6D5A7163B35B6DD6FB8566C173BA5B2E377BC4EED12DBDCBEED79C06070583C26170D6DBEC83135FAC61F1D8FC86472593CA52F1B28C5D564B95CE6773D9FD0686AF618C5FE93A6D16A755ABD66B73D75D85AAA3A8D756F639BDAEE775BBDE57B69BDA26FE6BB2E07178DC7E446F85C9B4E923599E6747A5D3D6F2FA998E2697B3D7EE777BD8FEB77FB5CEB176FC5E7F47A77D97F572BCDE3F6FC7E5F3A5787E90AE8453F3F7FE7F7FCFD3D8FFA20FDA250240503C10FE3ED049FF033F0F7C1908C24F6C170941D06C2109C350DBBD0AC230AC2F0E44511B810F438DBC431245515B5D1345917C6118BAF174651AC6D1BB6B1A4711DC791EB251D47D20C8521AE0872028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B66766B75C6E573BA5D6ED5FB85DEF57BBE5F6FD7F90DE70183C26170D87B8E0B118BC66371D8FA1E2B2193CA6572D97954FF319BCE6773D94C967F45A3D2696D5A1D36A755ABD652751ADD86C765B3946BF69B7DC6E7750EDB6EF7DBFE06B77BC1E27178D96E1F1F95CBE65FF93CDE8747A5A7CD74FADD7EC59F9FD9EE777BD42EDF7FC5E3F24BBC3E5F47A7D519F3FAFDDEFF8423DBCEA7757E3F7FC647ED9595C2FE6FCC0100A36FFAF4FEA210340504C1492408BA4109F28105C2509A3106AE707A270C4290DC388642CB943488C430EC491243F07422DE45312C591644EBB4467FC6316C690A45F02BEAA7C6ADD46F1DB329647D20AAD0D47B2121B22C8D24A9B15A1319C948EC9127CA48F49C834AB29A2B28CB12DC7F154752E4A8FDCC131AB4FB4B52C4CF324D5084BF35CC3204DD38CE4ACCD339CED3BC19314F13DCF89ECEB3ED0140C453D50542D0C934FF43D1542D1345AA91CBEB4737146D24A439F4A52B185094CBA936C2B26538CED3150A732BA2D53548C654754A6D544D95633955D60B7D408FD5D59BE938570BC56AC0D7B5DB0D5958093D6F4FD3D61B0F615913CD8E9158B65AEB655A1665115FDA6BEDA56BD7D66C076B5B56C5376FAA767C8F6F5C51C57573CE9735CB6E3994844B6CDD566463783B1225D8FCDE579B6B1CBD17ADF2F85F77E4D57C5DD04E07824D784B838661587DDE812028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D279445E052B004A65D2F984C665339A4D66D379C4E6753B9E45259039ED068543A25168D47A4526954B92CFE5B4CA8546A553AA556AD57AC4D29D59AE576BD5FB0586C56391D6EC967B45A6D56BB65B6614E95DBAE573BA5D6ED77AF5C28178BE5F6FD7FC06063F7AA7E0B0D87C4627156EC262F1D8FC86472545C6E4F2D97CC6673519CAE6F3D9FD0687219DD16974DA7D45AF49A9D66B75DAFA859B61B3DA6D76D33D96DF75BBDE6F62BB9DF70785C3DDF0389C7E472745C6E57379DCFC5F33A1D3EA756E9D2EB767B5DBBCCFFB9DFF0786A9D8F1797CDE79AF93D1EBF67B641EABEFC3DDF3FA573E56CD5BFFF3F5FE7F696FBAD0B8B38BDBFD02C0CA1400B14048F41703C1D07B70EF2E506A450A4210BC3090C12EEB0AB2C090CC4110C06962E70B3DF0FC4514C5487C36AC44D0AC5115C6519A0B16BED18B071C4691DC451B2B317C191D47921C2F1F45D212392048925C0F2346F0EC932449929BFD274388D4952A4B52AC24F8CA4844B32DCC4FE4ACB1B08FDCC734C0B32CD536CDCF1CBB37CE539C1538CE93BCF0AB4D93CCF93EA653DCFD40D049250141D0D43CB13B51145D1893D0B46D2148A0F47D251E4CF2FD2A855294CC42F84D14E2094DD410350130D2151546FAD4D11D52FD51556C6955C832852354560F2D650F56945D6D5BBC35CC615DD115ED7CEFD810D5313ED8962BAD63A4D674DF65D98EA5A1425933BDA569BA16AD7553D5F6D41D6E5836F4497047B6BDC7495B37339F71237774DB75DD8E6DE1565D56FDE707DEA895F778DF17CC217ED357450495A028000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F9042204009048E4327944A6552B9644E472696CC665339A4D66D379C4E6752F81CBA793AA05068543854F24944A4526954BA65369D1DA35467F4FAA556AD0FA355EB55BAE576BD5FB0586C55BACD8ECD67B45A6D56BB65B68365B75C6E573BA5D6ED77A75C2F17BBE5F6FD7FC05F2F581C26170D87C46266D83C56371D8FC8647158CC96572D97CC666BB94CD6773D9FD06864F9CD16974DA7D468B49A9D66B75DAFC06AF61B3DA6D76D60D96DF75BBDE6F671B9DF70785C3E245B81C5E472795C3E3F2F9DCFE86B39BD1EA757AD95E9F5FB5DBEE5FBB3DDF0787C569EFF8FCDE7F4553CBE9F67B7DD37F5FBFE5F3FA47BE3F5FC7E7F50DFBFEFFCFFBF0FEC0101C08F440502C1104BB503C1506C1CE541907C2509B7908C290BC30D742D0CC390EB410DC3D10C44C944111C4D13B0D12C5115C58BC45516C6118AD917C651AC6CDC2A71BC751DB051CC791FC80B746920C8922B171F48D24C94ABC8725C9D27A3726CA129CA888CA52ACB12CA0F2BCB52ECAB2E4BD30C9CEFAA497CC533CBF24212DCCC1344DD01B19014DB37CE8F92E0982433C4EB3DC5132A633D4F940C393F2674050543C1D39A0B4351146C0B454B69ED1D49C014820D465294CBE74B517495354FD37352694C54152BCD4B54953554F15089955355D60EDD5B3FD3D58D6CEECEF5ACF35D56F5EC173555E8AD835F588E7B493254562D94EACCB66D9D67DA168DA569DA96ADAD6BDB16CDB56DDB96EDBD6FDC170DC571DC972DCD73DD174DD56F20200E00FE000400010000000000000000010300010000000001000001010300010000000001000002010300030000005A0B00000301030001000000050000000601030001000000020000001101040004000000700B00001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000600B00001A010500010000004A0B00001B01050001000000520B00001C010300010000000100000000000000000100000100000000010000010000000800080008006A0300007802000069020000490200000800000072030000EA05000053080000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}', 'de_de', 'findesign', /*material - Estrich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{9F648D23-5AF3-43FE-A6F0-B354378D529C}', 'de_de', 'predesign', /*material - Estrich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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}', 'de_de', 'drawing', /*material - Vollholz*/ '2025-01-30 09:43:53', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}', 'de_de', 'findesign', /*material - Vollholz*/ '2025-01-30 09:43:53', X'49492A00D20B0000800020503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F904864523924964D217FCA6552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65366D099540E9D53AA556AD57AC566B55BAE576BD5FB05865B5294C1AC702B15A6D56BB65B6DD6FB85C6E5739CD92576697DDAE97BBE5F6FD7FC060705839DDEA597898E1B098BC66371D8FC8647218AB3C129F68C9667359BCE6773D9F9C652F305BAE6341A7D46A755ABD65674589D26174DADDA6D76DB7DC6A75F33C44F377B9E070785C3E256B7F34DECFB8FC5E67379DCFE854767CAD8D0F97D1EC767B5DBC9F4E81C9EB77BB9E3F2797CD6CEBCEBC145F4F9FDDEFF87C7D5E2A27AE8FEDF97E7F5FBF1FE27AFB292FF3F901C0902B5B013A8CB2AF0440D06C1D07B070627F0029D094210BC310CABF0B3BEEAAB70E43510C4511BC2002BD0A416FA44915C5916BFF152B11435D1845D1AC6D1AC40FBC3CB4C731BC7D1FBCD1EA911944F1A48123C9120C8D22C14B8C8524CA128B5127A992247925CA52CCB529CB0B14ACB5CA92DCC531AE130AA92FADB334C935CD919C4CC0CD0B7CD536CE93ABD92ECCB1DC233C4ED3ECFD1D4DEC64E2BA4E73FD0D4350AAE506BE51343D1D3151AAED16BF52347D2D1F52B26532B05374BD3D0CD3B4D4F9415474FD4D4C54AC25275250353D5D24D432BC9AD656357D6CE756AB5556C8D735BD7CDB57B304F4DAD835FD8CCF58AF4586DBD9363D9D563895DB3F66D9F6AAF76A4E565B856C5AD6ED64E85A4D55B96F5C918D5303DB4E6DC772DD900DCF625D2E7DD776DE904BCB70B7179DEB7DB7977B817C5FF7F5F981A977D4E178BFB8160985C3B56BE18038B8361963624C5E217561589E34CAC0D8BDE58CE3785E2AEED670764790CD793D7984407956512865CC963D84E1D97E45905EF9664D9C66D4B662CEE66F767F9EE779AC49A0E1F9E68931E86D3E90F969BA5C95A34719D457A8EA4EC6B1716AD16EB7ACB87AFB57A7E3BA56C1086C57464B2DED3B3B41B6B69B242FB86DD95EA9B66BB986CDBABB9BA5F3BCCA5BF6F96BEF7ABA0480808000204FF824160D0784426150B864361D0F8844625138A45204008AC66351B8E4763D1F904864523924963517934A6552B964422F2896CC66533934C269379C4E6753B9E4F611369F506852B97C0E8747A44968149A65369D4FA84369751AA555FF458C55AB55AA9D6EBD5FB0586175DB15967558B35A68564B55B6DD6FA251AE17396DA2E977BADCAF17BBE5F60B6CBF6062D45C16163F80C36271543C462F1D07BB63F250FC6E4F2D978EE57318BC8E6F3D7FBD67F45A38566B4985CEE9F37A6D56B6FDACD76BF09B1CFEC369B7B16DB717BD4EEF2DBADF70693C0E15D37BC5C971391CB9972B996FE3F3F1DCEE975733A1EB67367D9DFF63B9DF90753C169E8F8F13E2F3767D1E9B2F97D986F5FBF7DF1F9587DDF5D477BF1EAFD7EFF297BFCCBBE900B92FEC08C13EF03C1103414D240706ABF04C20C0C1F09ADD0AC2CADC250CB64ACC3902C3D0FBA6EDC451044AFFC4EC9C3714AFB0C4589EC5D17AAD15C64BE4631AAF310C70ED4011DBBB1D47CA746F20AA91A488DE41923A7121C94A8C8D26AF1264A0D2C9329C5B124ACC7CA529CB72CA9F27CBD28CAB30A252ECC9214B133CB531CD49FCD936C911ECE11FCE6A94DF3ACC5394F1154EF26CCD3DCD13D5013E4812F4FF41D0343D112FCFB13D1545A9B305211B51B09D1F49D2334D313A46B4BD374CD054FB314F41D4AD454A54353D47533F942D551FD4957D19573D958D655056D5BD02F95735D2994957D143BF5ED835FD3562B6B5633D625916355366B4566467655A10A58F6ADA36A4175A5B165DAF6EDB36E44D70363605C91E557715CF6F59F75B4F6939B6D5DCFFDE179AA17AA95795ED7A5F57DBE17EB87805FD6B5DB81B5B7C22B8460D44E0585D84B06158761975624D56228362F8AD7186E357FE289DE338EE378FE458B6388DE4392E479539F4F653966579865B93AC79A6657E6499BB5D1BE5F9D6279F3AD01E7BA067FA26836A687A368BA568F9CA09A4E99A5EA3A6A1DA86A7A96AFAA3219B6B311E0BAEB97736C1930008088000204FF824160D0784426150B864361D0F8844625138A4562D178C466351B8E476051F004764523924964D27944A6552B8E482072C984C665339A4D66D338FC2273379E4F67D3FA05064B2E90D0A8D47A4526952C9DC329B4BA8546A553AA512A957AC566B530A7C42BB5BB0586C56385D5AC967B45A6A75F8A5B2D56FB85C66566B95D6ED778F4BE456EBC5F6FD7F83DD30183C25DAF979A2E17158BB460B198FC854B0F26C9E472D979BE3B319BCE4C72B2ACFE7745A38CE6B49A7D45B6F540D0EA75DAF7FE9B61B3D76B66DB6DA6E723B2DD6F72DB89F7037DC3BC6F389C7BF70A85CAE4736C7C6E77471BABB2733A5D7A8F43B1DBAAF52DFD6EE787832EF1797BB89BEF83CDEB95F6BD9EFB9F7B01EAF87D637EEFB7E647F4B4FF3F4FFA1CFC40101A26FF2E3034090240504C1884C10BBC1F06BE105C2506422BFC2F0ABC30A434FD432C2C3F0EB9D0E444F6442C7C4F12B7B12454EE452CBC5F16B6AF2464FFC62CEC6F1AC711A474F7C72D3C7F1EB2116484DA482D7C8F22B0722494D4492DCC9F26B0D1E4A4E3CA2E1CAF2ABFB2A4B5283E526CB32EAC3264C4C54C2EC4CF32BCF34CD4A5CD90DCBF36B31324E4BACDF134E33AB193A4F52DBD13EA233BD009ACF941AC1414153CD0D29A4145BE74551D40D2148BA746D293B5274BA2544534FBCB94EB9F4CD40D54FF51CC74FD4CAC5392D55754C035455CA855B3556758B035856CA356B3D57758D0B5CB295158093D7B51D7F61A5B61590D059565A5163D9C8AD8B54DA745DA168ABD66DB09C5B56DA316BDBD075BB70A696ACE5705C8D8DC774B3375DD8855D16DDCD77A0B79CA578D977B5E89D5DD77DF15CDF57DA9D7EDC37FDA982604ECE116760D4EE0384DA585D8186D2387E20D2E255762941E2D8BB118F5D54B6058EE409264909D716C64F92D898CD1D8DCBB95E58F6E5D406613066B99C319CCDB9BC7B9967576D4B89E5363679A0C51A3E719157DA5690DFE9D1D67D0AE81A7D65A8C55A9C13AAEACF3D4DAD46DAC6BB19E874323E80808000204FF824160D0784426150B864361D0F8844625138A44604008AC66351B8E4763D1F904864523924964117934A6552B964362F2896CC665338ECC269379C4E6753B9E4F66B039F506852297D028747A444A6D49A65369D4FA84D29751AA5068B18AAD667753AD576BD5FB0532B961B2486AF65B449E8D69B65B6DD6F8CD8EE1738459EE97783DCAF17BBE5F6AB7ABF5A2ED81B6E030987C46267186C5553078DAEE332193CA6567F58CB63A8B99A864B399FD0686F36BD150B1FA59E67B51ABD664F55AD9369F6131D7ECF6DB7BE6D7711CD96EE47BADF7078569E070E1FBDE346B8BC9E6736FFA4E745791D18772FA9D7EC51FADCDE9F660DDBEF787C53AF070BBBD9F2F8FD5EB99FA76FE7E8FBBD9F3FA4AFE5ACF8727EFF5FE7F648FDB42FCB83003FD02C0C8FC08CB404F7BA103C1D07B5306B8D05B5B04C210BC308A42CC4428D2C370CC4110B8F0941897BCD1244514C54FB450FC336DC43F15C6519AEB16B450EB5D1B4691DC78B53310AC5ED5C631EC8922486B2C70C248F22C9923474C6C92DCC9F26CA92AA3725AB328AE92C4AD2EC9D1FB292D2DD2E4BD32C8B322933130529CCD36CDD0D4D8B84D4B04D137CED33CE2B64E6AD4EB3BCFD264FAC5C82BC5033FD0D404F2AFCF6A750B43D1D26D1A95516A452347D2D48512A8D26AB5334BD3D4FA194AC7D513794ED4153D511ACC13A506AF54954D61445573E55AE7D6758D715CA2757A2D5AA9F5E57560D655A44D4D54D615916458084D3692D9764DA12A59E8259AB358F68DB168D976AB2F6CDBD6FB956BB7F5F5055BDC173DD150DC5045C8995A774DE12B50B6E22177DE37BCBB3ADE9755CD7C5FD7FD54A95DB71DFB8060D83DA975C4762A537B61187CBD0FDF7876218ACCB04DAB8A62D8DCCCFDD278D63990CDAF74E79064593CDCF04B59365196CDEE5C719665D99CECDD417996699CCEED53E19C6759FCFCC63A79F681A2CFEBD365A268DA5D0CAE307A5699A8D0E9B2AFA86A5ABD1DAAEB5ADEB9AEEBDAFEC1B0EC5B1EC9B2ECDB3ED1B4ED5B5ED9B6EDDB7EE1B8EE5B9EE9BAEEDBBEF1BCEC280800E00FE00040001000000000000000001030001000000000100000101030001000000000100000201030003000000900C00000301030001000000050000000601030001000000020000001101040004000000A60C00001201030001000000010000001501030001000000030000001601030001000000400000001701040004000000960C00001A01050001000000800C00001B01050001000000880C00001C010300010000000100000000000000000100000100000000010000010000000800080008000B030000E0020000E3020000FC0200000800000013030000F3050000D6080000');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}', 'de_de', 'predesign', /*material - Vollholz*/ '2025-01-30 09:43:53', X'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');
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}', 'de_de', 'drawing', /*material - Weichfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}', 'de_de', 'findesign', /*material - Weichfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}', 'de_de', 'predesign', /*material - Weichfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}', 'de_de', 'drawing', /*material - Leer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}', 'de_de', 'predesign', /*material - Leer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}', 'de_de', 'findesign', /*material - Leer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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}', 'de_de', 'predesign', /*material - Dämmung Balken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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}', 'de_de', 'findesign', /*material - Dämmung Balken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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}', 'de_de', 'drawing', /*material - Dämmung Balken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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}', 'de_de', 'predesign', /*material - Dämmung Fassadenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}', 'de_de', 'findesign', /*material - Dämmung Fassadenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}', 'de_de', 'drawing', /*material - Dämmung Fassadenbau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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBDB2A00-E574-40D1-BBAE-A0E5562B64C7}', 'de_de', 'predesign', /*material - Gipsfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBDB2A00-E574-40D1-BBAE-A0E5562B64C7}', 'de_de', 'findesign', /*material - Gipsfaserplatte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
INSERT INTO ecad_guid_info_depthmat_preview (guid, region, kind, modify_datetime, image) VALUES ('DM-{DBDB2A00-E574-40D1-BBAE-A0E5562B64C7}', 'de_de', 'drawing', /*material - Gipsfaserplatte*/ '2025-01-30 09:43:55', X'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