USE ecad_guid_info;

-- guid info for: hierarchy generic uses
DROP TABLE IF EXISTS ecad_guid_info_hierarchy;
CREATE TABLE ecad_guid_info_hierarchy (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
    username varchar(255) DEFAULT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,	-- e.g. for any logical grouping    
    modify_datetime datetime DEFAULT NULL,
    de VARCHAR(160) DEFAULT NULL,
    cz VARCHAR(160) DEFAULT NULL,
    en VARCHAR(160) DEFAULT NULL,
    es VARCHAR(160) DEFAULT NULL,
    fr VARCHAR(160) DEFAULT NULL,
    gr VARCHAR(160) DEFAULT NULL,
    it VARCHAR(160) DEFAULT NULL,
    ne VARCHAR(160) DEFAULT NULL,
    pl VARCHAR(160) DEFAULT NULL,
    ru VARCHAR(160) DEFAULT NULL,
    sl VARCHAR(160) DEFAULT NULL,
    user_default_lang VARCHAR(8) DEFAULT NULL,	-- e.g. 'de_at', language and region, use within alias and/or language columns
    aliases VARCHAR(2047) DEFAULT NULL,	        -- e.g. 'de_de=Alias1;;de_ch=Alias2;;fr_ch=Alias3', optional dynamic alias list for any region differences
    PRIMARY KEY (guid)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Architektur');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Kan-Gruppe');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F52B33A8-79C2-403B-BF7E-F3F1DDE727EA}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{98285FB2-92F3-42DD-95FF-7AC0CF428AFC}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Innen+');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Aussen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4E457834-F0F8-4F14-9D84-D3AEC3B2EF06}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'TGA-Elektro');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E0C9EA3F-4619-471C-8582-363CD71B0E28}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'TGA-Heizung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3D536AF0-D04C-4698-A4BA-B5E1F8962371}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'TGA-Lüftung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{80A01A87-D2B3-46AF-BBE2-C77AF56D7A2D}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'TGA-Sanitär');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Layout');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{34C5BA91-BC48-461E-BE67-E6F489CBEBE9}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'HLSE-Elektro');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{666ABABB-49F7-4C72-8DCA-1C49CA32E8BB}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'HLSE-Heizung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D059902F-01AF-4949-90FA-B5FC4BE3CBCF}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'HLSE-Lüftung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{2C5CF3F9-548A-4A3A-A88D-A08F4A273A9A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'HLSE-Sanitär');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdichtungsbeschichtung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abdichtungsbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0CF4BC41-46C0-4983-BEBE-2E9B4860320E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem-Holz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Abtrennsystem-Metall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Akustikplatte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{59EE99A2-77E7-4E92-BE3B-15DCB2D69E88}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich roh');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Anstrich Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Asphalt');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3CAF35C4-06A9-49C8-B116-334D352F6616}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Auflager');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussendämmung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CC91BEF7-F97A-4D27-8C47-E52141D0E3E6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Aussenputz-hinterlüftet');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{AFA0F644-6E25-4A40-A74E-2969234AB088}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{78F94678-F679-4125-BED3-786B9747367D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Backstein-Sicht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bekleidung-Verschiedene-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bepflanzungsfläche');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F21B7DDA-3432-4A5A-BEDA-920AECB986BB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beplankung-Verschiedene-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Beton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DD048929-D856-4824-8501-62637F813393}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonboden');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonoberflächenbehandlung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Betonstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blech');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{20A160E8-D19B-487C-A3FC-6B0193030F74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Blindboden');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bodenbelag-Verschiedene');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Bretterstapel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettschichtholz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{67EBF2B3-E9E1-47C4-BC13-FEDA9AF6BBF5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Brettsperrholz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbegrünung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{299FFDF9-7F1C-4DF9-8F13-1DE96FED55E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachbekleidung-Verschiedene');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B1E8FCF3-C72F-4101-BDE3-AE89548C2DA3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachflächenfenster');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{5BBDFA3D-43A6-4816-80A9-CD97F09DD0D0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachuntersicht-Aussen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dachziegel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0A902A49-65FD-44F7-A8C7-EDCE75208AC4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmputz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Balken');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Boden');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{80F59ACE-3F9B-4C7B-ABE9-8684E1E393E8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Decke');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Fassadenbau');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Flachdach');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Hohlraum-Verschiedene');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Holzständer');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Holzwolle');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Lattung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Perimeter');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Ständer');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trittschall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dämmung-Trockenbau');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dampfsperre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{FC196730-5CE9-4098-93E2-15CBA87BA352}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckenhohlraum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{AB63944C-E2E3-4BB1-99C6-7638557623E5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckleiste');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Deckputz Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtungsbahn');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BBCB8289-D3FA-4C80-90CA-518A1C518852}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Dichtungsbahn-Kunststoff');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Doppelboden');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Drainageschicht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{28F68337-C968-4EB3-8551-5FED863602F2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{89E91AFC-6B79-47B7-A9F3-182F6F69C6C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Gummi');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{712C3B68-2D82-487E-A095-7E882C5E5C0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Linol');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elastischer Belag Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Backstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Beton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{75AB92DB-55F2-47C3-8F5F-FA3D8600113B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Porenbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{1A2C6EC3-683B-4EF5-A440-D0B873F2C099}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Elementbau-Sichtbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Estrich-Element');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Faserzement');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{2EE64CDE-75CF-4F8E-B0D1-489D91F288E3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fassadenbekleidung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Flachdachbelag-Verschiedene');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich Anstrich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E0651CA8-B0DF-4CFD-B43A-A06C360DED39}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fliessestrich-Bodenheizung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Fugenlose Beschichtung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{7636A3CC-FBE2-4679-AB3F-0A3226E1AAAA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gips');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipsfaserplatten');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Gipskarton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glas');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{34324FDE-37CE-42A5-A789-56DA759C5DB5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Glasbaustein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Grundputz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3F310784-9291-419B-B968-5FAAD5EA2ACB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Guss');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hartbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{83AB8DCB-230C-4ABE-AA6E-14CEFD9B902E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Hohlraumschalung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holz-Unterkonstruktion-Konter');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbausystem');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzbausystem-massiv');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzboden Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzfaserplatte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{85A91D6B-777C-46E5-960B-C71689A613BD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzkastenplatte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzmetall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C09446EE-A15E-4488-B9AF-F3CFA786AC16}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzriemen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{FE079A17-7FA3-4703-AD16-E4E9DED71FD0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzrippenplatte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzschichtplatten');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzständer-Hohlraum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzverkleidung-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Holzwerkstoff-Sicht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Installationselement');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8A49658E-1BCB-45A9-8CAB-3FBFC1E94450}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kabinentrennwand');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kalksandstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{680CFB2F-4443-4802-81D7-5B1ED17387E0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaltbitumen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E3EB2521-C5E3-4D5D-800F-AFCC6566F7A5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kaminstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kanalisationsschacht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Keramikplatten Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kies');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Klinkerstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Konstruktion-Verschiedene');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kork Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Küche');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunstharzbelag');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B1FE74A3-8588-42F2-B7E7-34489438E3C5}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoff');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Kunststoffmetall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Leichtmetall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E36590D5-2521-4E85-8ACC-55C911057C34}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Lukarnenschalung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Magerbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{7D3AE940-6256-47D0-878F-B0F3BBBDBBE8}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Markise');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E188BD02-CBA9-4953-B16A-BDCA42D4FCB7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metall-Unterkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Metallplatten');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4B790B7A-0A63-413D-A725-40A230059EB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Mörtel wasserdicht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Naturstein Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Noppenbahn');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Oberlicht');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pflästerung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{88D5142C-064B-4DCF-B1BB-7FD7A874152B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Pfosten-Riegel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenmauerwerk');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Plattenwand');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Porenbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{54867749-FF75-4A51-AD06-9C75E358EB96}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putzträgerplatte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C9A79516-E3D1-4DD8-A166-7C00784576F9}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Putzträgerplatte hinterlüftet');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Rasen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A0A05C72-7B3B-45AB-8EF6-5EFD459ADF4E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Roh');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzschleuse');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Schmutzwasserleitung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtbeton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sichtmauerwerk');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerleitung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sickerplatten');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A33829BF-FA55-4EBF-84F9-3492AFAC2E33}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Sonnenkollektor');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stahl');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ständerwand');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Steinholzbelag');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8791BDCE-88DF-455F-AE78-C5FA378F133F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Stoff');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Tapete Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Teppich Sanierung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Terrazzo');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Trennwand');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterkonstruktion-Verschiedene-Aussen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D692DFB2-FEEA-4387-8305-7983FCEFB44C}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Unterkonstruktion-Verschiedene-Innen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Verbunddecke');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A78788A0-5CE1-491D-B51A-5C05621DE825}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vollholz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{698DEBC5-C683-4110-A545-9EF72E4ADE36}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Vorfabrikation in Beton + künstl. Steinen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A55DD73B-29DB-425D-9AED-4FE1697B7F0E}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{466EACD9-B412-411A-88A3-5E42399E251F}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich Anstrich');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F1419E16-44C9-4F53-985E-520F061D6DDB}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementestrich-Bodenheizung');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{EA9B35B1-9BD0-41E6-82D9-5E135EB66AD4}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Zementstein');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B1DC8151-B4A1-4E45-8B87-7C476622FAA0}', 'global', '255', 'material', '2024-04-22 08:00:00', 'Ziegel');
-- WKGUIDs
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{FA000000-0000-0000-0000-000000000000}', 'global', '255', 'WKGUID', '2024-04-22 08:00:00', 'Favoriten');
-- values `en_uk`
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{970433CE-DD72-4544-98E3-A8DBE643FB47}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Acoustic board');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{B47CE84C-D210-402D-8306-B6817CE2044E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Artificial stone');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{6E482766-A59A-45FF-BFEE-24F2D4B4FCC4}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Asphalt');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{B9E49985-DB0B-4A07-9ACC-085F5D67AF99}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Brick');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{55F8092B-A74F-44AD-81DD-739224A5D898}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Carpet');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{BA28DD78-176B-4593-A721-FA61FD0A107A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cast');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{08695A90-844E-4AFC-8155-A975B2048AB9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cellar-partition');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{CB77AFEE-2060-4871-B5F0-27342069B1BA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Ceramic tile');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{CF846500-031E-4B25-AE6C-A68E337A5B0F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Chimney unit');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{87A95258-525A-446A-8344-1FA0EE922847}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Clearance');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{B2C7D3A9-E571-4DC8-B71D-0B95CDE5A8F1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cold bitumen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{2C592D41-8D31-4282-B4C5-C68A4370792C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Composite floor slab');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{8E4487BF-7547-44A5-A0EE-9F3122A44470}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Concrete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{058882E7-86E2-4F66-BB87-8A6153447FFE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Concrete block');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{E90C2B22-2F99-4FC8-AFB1-F4ED49255D60}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cork');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{71E9FAD2-55A8-4788-9260-2DD1777B17F7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cross laminated timber');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{A5E42FFC-3067-4798-9452-7A32567BC0B5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Cubicle partition');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{46DDD150-B5A1-4F9F-B81E-032239E9FDA7}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Derived Timber Product');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{107FCE02-A5CB-4DC7-8B71-9ADBEA37FF8D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Double bottom');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7493D97D-5DB1-45F3-A9E0-4FE874839F86}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Drywall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{450185A9-9783-4B1B-9025-1584386CD3EB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Expanded Concrete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{6F517D14-47DD-41FB-81EF-88CD0B6E7201}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Exposed masonry');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{D85FB502-A88A-42FE-9BA3-FF74BD549FB5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Exterior Insulation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{A1EAE5D8-FE23-47E2-96DD-F44ED239FCFD}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fabric');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{F74A023B-9ACD-466F-9D11-DE35D65A7DAC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Facade lining');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{AE91B855-8D1C-410E-A026-07EE93C7B8CE}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibre Cement');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{0A094B6E-4CF2-4934-B382-EEAA2F660B52}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibreboard');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{ED7BFE42-DB12-437E-996E-809356ED26BA}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Fibrous plaster');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{268E65F7-E9F9-40B9-96A6-361E76BF1AD8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Filter panel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{54FB46BA-F15A-4B7A-840B-142D0B3D8A95}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Final rendering');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{23C87ADA-D6E8-482D-A505-A34FD5E99FB1}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Floating screed');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{68873534-4D91-4D92-9A11-CF95B30CED62}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Footfall-insulation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{D310D972-3045-4465-BE30-01EB758BA699}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gipsum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{0F8E8F14-3983-4C13-A79B-3277A163BF6E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Glass');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{801F0306-D3CD-4A00-86C3-8563A95FB9C5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Granolithic');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{A3778F34-171A-4AA5-87FB-E501737028BF}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Gravel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{A11C9218-CFB2-48A7-83AE-6F4E5345D8DC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{ED017B28-A19A-4C0F-A06D-5894C95B6216}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-beam');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{F1DE9638-35C1-4BCF-943B-D575B2DDF0D9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-drywall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{BC4F33CB-AFEC-4CDB-A38C-D07098B215E5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-flat-roof');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{3D8DA1F3-C239-4300-874A-4BCDCE5212D5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-lining');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{BB7EA218-A61B-4B43-885B-33493DB0B796}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Insulation-post');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{BA21AB3B-60D7-4977-B5D8-62BFF8C63399}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Jointless covering');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{59F43847-2B95-4624-B988-B0EE7776298B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Laminated wood');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{C428980E-6FC3-4BC1-9A93-1D66D71454C9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lawn');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{1090B38C-60F2-482A-82F4-771B1F8D1AB8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lean concrete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{C537B2EC-082A-4475-845E-5C2AEA619A61}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Light metal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7EFACEDC-8A47-4228-8D3F-C59EE60DCFE6}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Lime-Sand Brick');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{C3805130-03D9-4D6F-B1B2-A44EA27F307C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Manhole');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{78AF48D3-DE71-4B8F-BFE3-173D2D891893}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{5689AF52-CAD3-4A5A-B3B3-4CFFAF428D55}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal panel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7BF16928-10C9-4D92-BA66-71A5D6A66A5E}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Metal sheet');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{971EF1D9-5392-4BDB-9B6A-DC30339FAE2F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Natural stone');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{4C50DE26-5B98-4AC8-AE38-A1800798FD71}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Painting');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{88E14401-04B0-4DF6-AE12-195845D036F5}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Panel wall');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{C3033901-3C53-4658-9E71-8E62B2DE32D9}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Pavement');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{FB2D56C6-7D7C-42E9-BD6E-8FBDB2DA2815}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Planting');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7407AF68-C60C-4D97-AA54-F6BACFB2778B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plasterboard');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{66C8398F-02CC-4096-BB1F-69AEFD43663F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{6CC0636B-A3E3-4D5D-BD52-1F88E212EB0B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Plastic flooring');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{AE4DD081-509A-4166-9F63-DDABE161F186}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Prefabrication massive');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{6ED4E6F5-144C-48FE-86B7-A00E65E88527}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Raw');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7F3EAED1-C841-4087-84E6-1DF53FAF0AFC}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Resin flooring');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{0B0DAC4E-FE96-4252-BD3F-16FB39E9985A}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof greening');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{DC30ACD8-569C-4F35-84B7-1D990E2B82CB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Roof window');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{F004D069-1072-4A2B-938B-8B23623157BB}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Screed');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{176BF6C1-199D-41E9-86FD-3D90E7B93083}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Screed flooring panel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{005EC588-736F-493B-9A9C-7AB64B8162F0}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Seal sheeting');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7D2731E1-7618-40A0-989F-D848E39C7635}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Skylight');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{72AEF757-863C-4DBA-AEA0-6D13BE1BEF9C}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Solid wood construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{E418D608-C99F-46CE-89C1-8991699E0A98}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Steel');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{F476304B-AB43-49FF-8E5A-DBDFCEC78F18}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Stone-wood');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{48506A9E-F257-4775-ADC2-34AED8AC6E78}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Substructure');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{3DA95E14-5CFE-4658-96E9-C4FA806652F8}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Tile');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{F6182470-8B27-46A1-84A3-ADDABBD0B29B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Undercoat plaster');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{33007B83-D3B5-46D7-A2D1-F99BBF88454F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vacuum concrete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{821C4D9B-77CF-48F4-A819-FE2F47FE9191}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Vapour barrier');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{9AA703C4-748A-4D08-9185-63A4A4B8B910}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wallpaper');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{758E946F-D7BA-49D6-BBD7-02F18AE1E689}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof concrete');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{693E13E9-052A-4AD7-9419-8B7DAFF07F93}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Waterproof-coating');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{B05D608D-76C5-4841-869F-3112E867DED3}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{5AF6DEDA-B345-4868-BA04-182E987E8878}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{33FB779E-CFFD-40C2-B478-5DD8257C9049}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood covering');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{55821D3E-BDAF-4BB7-BD48-DDA99915E97B}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wood-metal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{0D81EA21-86CA-4696-A375-AB605DEBC78F}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden floor');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{A851ECB4-F7EC-4C60-A978-6E1E91C7804D}', 'global', '255', 'material', '2024-11-14 13:06:06', 'Wooden subfloor');
-- values `fr_fr`
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{289A8629-BF34-4486-BD9D-494ADE314D04}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Acier');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{176E7162-F894-4846-BCAE-34AEF9970B0F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Application');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{2292DE28-8B5A-4E15-A66F-06E9DB4DC8F5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Asphalt');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{C22F430D-DA61-434F-8654-9A4F8531A477}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{CC3AF099-4EB9-4248-9A05-541504B4424F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bardage-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{DFF7DDE3-591B-4CC7-ADB4-BCE737526388}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Barrière-vapeur');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{F3FC21DF-5927-494A-80E2-B95A9261F968}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A61BED4C-27D7-485B-B632-614EAED6CAFC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton maigre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{586D3018-EA64-4D1F-A405-370F268CAF52}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-celluraire');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{BC61C015-BB2E-4F34-BE1B-8E3CC01AFE06}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-dur');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{109DC0CB-6587-4D9E-80E9-AA41077689D4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-étanche');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{3C4113BC-855E-41B6-A488-0707CAE3D997}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Béton-sous-vide');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{05898836-7A72-4894-8F4A-DEABBEE50C49}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bitume-froid');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{FF8DE722-7F47-4CD0-9E4D-A170B487C7B4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D8CA52AF-FCE6-498F-8075-2EA4A63CD0C4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois lamellé-collé');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{2273FB37-44A4-4481-A6B5-0864F13207FB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Bois-Métal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A26C3A57-9349-46C8-92CA-85AC3015FCC9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique s-c');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{EF21F5B8-4AF0-4DD8-808F-03657D638D40}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique t-c');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{415300A6-AA2D-404D-8CF4-68BAA68A3746}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brique-béton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{7FF7024A-81D7-4582-A138-BCFC43C6C948}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{631C4791-98CD-4D53-BFFF-5881987379E5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Brut-application');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9F195452-732D-4562-8211-D37188FA27AB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'C-béton-mançonnerie-préfabriqués');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A9271483-AE99-4E36-9D08-DB50A52EF695}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Canalisation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{CEDC4E01-9CC9-4A49-B1C5-AA5C8D3F5B05}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreau-métallique');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{305987E7-E70D-4186-B9AA-8040713D44F5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carreaux t-c');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{88BE6390-0C0C-49E6-9A47-B5FD4BEA856D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Carrelage');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6605BA8C-8316-4C8E-8647-93FB665661D2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape fluide');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{C3F6486F-82C3-48DA-8113-D93B7CA7DE15}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape-ciment');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A8AACE83-A2F0-49CA-BECD-FA77A722A8F9}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chape-ciment-application');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{852E11B5-ABFD-4416-99E3-6BB6EC061F83}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Charpente-iso');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{17D1B430-A557-484C-8D29-857E23FF2E50}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Chauffage-sol');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{4AE9B1E5-CF54-450D-BD57-B282534F00FE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5DDFECB2-BF49-45F0-A181-6ED494C21F62}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-cabine');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{C525C9CF-9B35-4243-AE02-93ADB0539429}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-carreaux');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{1BD2534A-5AF5-4B04-927C-E4540D696288}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-claire-voie');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{0B19A2F0-2419-4C95-9E9E-E26CDC3A8943}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-légère');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{84066F7C-2DE6-4B40-BD06-4D3FC3EBAE74}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cloison-mobile');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9C4F9188-60BB-4768-B330-E74D8217AD1C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{B90E8415-1A46-4CE8-A96C-0A5357BBC0A5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Constuction-bois-massif');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{30F9B2C7-A16F-4CFA-BE90-B2D6C7420B96}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Contreplaqué massif');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5A0F2A75-9E71-4F1A-B611-FACF511D4419}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Couche-finition');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{75D6E822-C2D2-4E9A-AE97-AE538E6D852E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Cuisine');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{7E7FCDFF-D706-473C-9B9F-B638578076BE}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Drain');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{65B7F080-A236-4721-AE77-B59DD8DA7AEC}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Élément-chape-sèche');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5C9A5014-E8A0-4180-A22E-9F53C3F3993C}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit-fond');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6ACA5F51-B7DA-4C0F-B06F-47F51BB0617D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Enduit-synthétique');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{0999AA39-9FF5-4BC1-BFEC-64F9DBDE0787}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Étanchéité');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D5E54FE6-9D5C-493D-9049-CE756E09D4F6}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faux-plancher');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{3B8951D5-8D66-491C-8B8D-301111BB5DB5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Faux-planchers techniques');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{E1338A53-D69F-485A-84C1-DEF05CDBFEBF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fibres-ciment');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{1B42A560-74E2-4A39-8D41-6B937C39DD58}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Fonte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6E803EF4-54DB-4254-A373-A663B906A783}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gazon');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{F16A69A2-0E49-4E2C-9760-1900814A05C3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Gravier');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{89A15549-B8E1-4FC7-9DE5-63D473F2D479}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso façade');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D5CE5C19-380A-4F13-A247-B7952A9EE5DB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso poutre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5548860E-E797-4E90-8864-D38751C77CD5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-bruit-chocs');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{AFF42D45-BC84-40DA-ADBC-A2350DD23B04}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Iso-pente');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D0D4FECF-2466-4264-90D1-B3350F268298}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolant');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{40B28011-DE5A-4D99-9535-615CB2BEFA26}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolant pl.d.plâtre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{67C49FA0-601F-4FA1-A184-EC25107C26EA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Isolation-extérieure');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{76368275-474D-4637-83C2-A2DAA9692262}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lambrissage-plénum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{F17F46B1-89FA-45F8-B01E-23F5E5A5AD6F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lanterneaux');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{1C38C5A3-720F-4BA4-AE91-359EC4792AAA}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lé-étanchéité');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{707EE0E7-1769-436C-B565-85A24E9CA6F0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Liège');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{E1E21B0E-19C3-4A80-A673-7E486EF70BC2}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Lucarne-lambrissage');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{10FD6CD8-E659-43E2-B39B-D91A64D4EBEB}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Maçonnerie-parement');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D8033F70-003D-4A10-849D-B2809001530A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Matière synthétique');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{3D55D013-9D65-4178-9A34-FE600458DA04}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Métal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{F7F0BF26-FC3A-409E-8336-EDD860C95593}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Métal-léger');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{07248444-6903-4565-BCE9-2A0283AFED5D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau solaire');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5381452B-06B8-4917-9166-A30FC4934470}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau-fibres-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{0DD5B3EB-5151-4367-AF8A-9B93EFBCF48D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Panneau-insonorisant');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9AA30643-9723-4C0E-97D6-C5FD94FCA273}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pavage');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9BD8DC63-C2A8-44C9-9450-D10D9C9C4C03}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-artificielle');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{4E692F21-A159-485A-90EC-937AB6003571}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-naturelle');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{AFAF450D-53EA-4F80-B288-A9855E665505}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Pierre-réfractaire');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{E48CBCAF-DD19-4E84-AC68-F9D12ECDD961}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plancher-mixte');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{61AAF44E-3DB7-4604-8181-9B53675E762F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plantation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{60CB94E7-1469-4C11-B82E-C99E29A30991}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque-filtrante');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{C10D00B5-478E-4C33-8188-E9ADABC3F8E1}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plaque-plâtre-fibres');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6AFF53D6-14EA-4612-9D07-B43D79D1E7E3}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plâtre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{EA3F10AB-588D-4E75-9C1C-7EE1FBB1ECA8}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plâtre-cartoné');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{80BAA2FA-A52B-4327-B239-F819FA07D764}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Plenum');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5DCB4D92-0452-4A05-97DF-06F6C74F2E5B}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Produit-dérivé-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D755E2FE-0581-4E85-AC6C-B591CF27EE36}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Regard');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{B489C283-0AC9-4C77-8BB7-0C1C29954835}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revt-sans-joints');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9D0C3D7A-6C08-4765-AECD-9DC9844375FF}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Revt-sol-synthétique');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{B1F5D594-D63A-4B6E-A3D3-BFA0DBB624E5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Sol-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{698D4221-1F33-4404-B772-144AC67196C4}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Support-bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{41D23FD4-FB77-46D1-8454-AD57AABFA30E}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapis');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6CFCF848-9184-4597-B204-B373EF21E563}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tapisserie');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{AD98AC4B-18AB-4AA5-8880-27D1A0303F4D}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tissu');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{1061057F-638E-4FA1-9E11-4EAE3C669BC0}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tôle');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A8DB3B5B-5026-4FEF-95AE-A0816FFF145F}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Tuile');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{9B0B6ADC-FBB7-49D2-A15E-D5ACC8DB44F5}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Végétalisation de toiture');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D4F58863-F45B-4A7D-B81C-15D19730838A}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Velux');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{C7B88F2E-9F10-4054-BC18-686005394842}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Verre');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{47DCEB67-E614-488A-ACE1-B4AFE7642352}', 'global', '255', 'material', '2024-11-14 14:23:10', 'Xylolithe');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:16', 'Design');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Drainage group');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Architecture');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Groupe-Can');
-- values ArObject - de
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F3D9B317-D05E-45A2-8EA3-C6765822F0AD}', 'global', '255', 'wall', '2024-12-17 13:51:29', 'Betonkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4E59E083-3049-446D-8DE3-6DBF655A938E}', 'global', '255', 'wall', '2024-12-17 13:51:48', 'Dämmkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{36526284-F088-4EB5-A289-37A2FEDF716D}', 'global', '255', 'wall', '2024-12-17 13:51:56', 'Holzkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{328B28F4-D40A-4C6F-ADF6-26F6071B42FF}', 'global', '255', 'wall', '2024-12-17 13:52:09', 'Trockenbaukonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{C5F6713D-BD5B-4ABF-8EDE-1747E49D6AFC}', 'global', '255', 'wall', '2024-12-17 13:52:34', 'Ziegelkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{F2427879-7184-4ED2-8301-3DF87B3A5FB2}', 'global', '255', 'wall', '2024-12-17 13:52:42', 'Crashkurs');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{E0A8E905-6CB2-45D2-99FD-E894AF920134}', 'global', '255', 'floor', '2024-12-17 13:53:01', 'Betonkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{321D9A6D-A147-4438-B4AC-31B574D075DB}', 'global', '255', 'floor', '2024-12-17 13:53:11', 'Holzkonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BBDE216B-85FD-4825-B469-6801FC5F4A13}', 'global', '255', 'floor', '2024-12-17 13:53:20', 'Ziegelkonstruktion');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{797C34FE-9B79-427E-B2DE-BE94A4D552DA}', 'global', '255', 'roofwindow', '2024-12-17 13:53:49', 'Dachflächenfenster');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D65583C1-315B-4EE6-AA94-E7CA92CC85D1}', 'global', '255', 'wallwindow', '2024-12-17 13:53:55', 'Fenster');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{7559264E-E882-4280-8627-F4086078F612}', 'global', '255', 'wallwindow', '2024-12-17 13:54:03', 'Fenstertüren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{6F36874F-F66E-4BA8-A90D-BB904E16DF8C}', 'global', '255', 'wallwindow', '2024-12-17 13:54:10', 'Crashkurs');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{B14DDC96-E9BB-4E47-A936-944C5E56B7BB}', 'global', '255', 'walldoor', '2024-12-17 13:54:35', 'Innentüren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{A55135D4-DFD2-46CD-B31F-2E2C2A1FE94B}', 'global', '255', 'walldoor', '2024-12-17 13:54:44', 'Zargentüren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{BD34EF46-6D4A-4DC0-9A5C-4125B46A35AF}', 'global', '255', 'walldoor', '2024-12-17 13:54:51', 'Aussentüren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{6E5BB813-A66D-4806-A8DC-04C33CD7081B}', 'global', '255', 'walldoor', '2024-12-17 13:54:57', 'Tore');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{D3A87B30-A17B-4F4F-AB42-CFE40AA79014}', 'global', '255', 'walldoor', '2024-12-17 13:55:04', 'Crashkurs');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{523D5CE9-71D1-411A-8832-F777CCE36D27}', 'global', '255', 'astairs', '2024-12-17 13:55:21', 'Crashkurs');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{219186C8-8AA5-4C4C-814B-7257332431E9}', 'global', '255', 'railing', '2024-12-17 13:55:34', 'Crashkurs');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{EF55A1D4-2002-488B-BF51-9F48FD674772}', 'global', '255', 'hatchpar', '2024-12-17 13:56:28', 'Füllschraffuren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{4A85044F-B039-401A-A0E7-F8F128391364}', 'global', '255', 'hatchpar', '2024-12-17 13:56:35', 'Linienschraffuren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{EC6F58BB-8310-4462-B874-B6D824CC0460}', 'global', '255', 'hatchpar', '2024-12-17 13:56:44', 'Musterschraffuren');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{23C3DE50-A9CB-41F9-94CA-514CA711E60D}', 'global', '255', 'material', '2025-01-10 12:05:09', 'Floor covering');
-- values ArObject - en
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{2C4BAA7D-6EF5-4F84-86DB-605D05EFBEBC}', 'global', '255', 'wall', '2025-01-20 12:56:29', 'Concrete construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{C8F77510-93F3-4E46-9EBF-E44E4D03797E}', 'global', '255', 'wall', '2025-01-20 12:56:42', 'Insulation construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{510DBF3C-4845-493A-B5CF-3B9F6281FBB3}', 'global', '255', 'wall', '2025-01-20 12:56:52', 'Wood construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{FEAEC7C7-D261-42EC-ACF3-B66F8A5D535B}', 'global', '255', 'wall', '2025-01-20 12:57:00', 'Drywall construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{59E96B69-CEEC-4256-9B44-F136AEBE8C09}', 'global', '255', 'wall', '2025-01-20 12:57:09', 'Brick construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{344B52F0-8CA4-4717-83AB-8F8B0D7557F7}', 'global', '255', 'wall', '2025-01-20 12:57:20', 'Crashcourse');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{9849A0CE-4DE2-48D0-8AA3-EDF715862705}', 'global', '255', 'floor', '2025-01-20 12:58:24', 'Concrete construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{BF05FB83-6F61-41EA-880D-8901E1F64613}', 'global', '255', 'floor', '2025-01-20 12:58:44', 'Brick construction');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{952E1E81-441C-4D87-9EB0-472926C95FEF}', 'global', '255', 'floor', '2025-01-20 12:59:01', 'Wood construction');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{148E5273-BFBC-42CE-BF5A-85D762410A62}', 'global', '255', 'wallwindow', '2025-01-20 12:59:36', 'Windows');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{0F3A671F-2516-481D-859F-2C3FB9C5E900}', 'global', '255', 'wallwindow', '2025-01-20 12:59:45', 'French doors');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{7D2672AA-194C-428D-8197-389DA9EFDFDB}', 'global', '255', 'wallwindow', '2025-01-20 12:59:55', 'Crashcourse');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{EEC64531-1DB1-466C-82E0-49B99660B59D}', 'global', '255', 'roofwindow', '2025-01-20 13:00:43', 'Roof windows');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{FB2BB3CC-D1E1-4BA3-ADAD-28ECD2B10C66}', 'global', '255', 'walldoor', '2025-01-20 13:01:12', 'Framed doors');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{9DCCAC28-0EAB-4813-9E79-897ADAE7C5B5}', 'global', '255', 'walldoor', '2025-01-20 13:01:20', 'Interior doors');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{46454CF5-E344-45B4-9E90-A1CD69C6DE6F}', 'global', '255', 'walldoor', '2025-01-20 13:01:28', 'Exterior doors');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{4C48E963-32A2-4F01-8B12-288C34ACE3E3}', 'global', '255', 'walldoor', '2025-01-20 13:01:34', 'Gates');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{514B8AA3-D17C-4B56-83A1-3AE58CB5D171}', 'global', '255', 'walldoor', '2025-01-20 13:01:41', 'Crashcourse');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{4D59251D-0C5D-4887-B03B-F92425E86E6D}', 'global', '255', 'astairs', '2025-01-20 13:02:03', 'Crashcourse');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{13E3E7D1-9C1B-4375-A10D-95F6C119AC3F}', 'global', '255', 'railing', '2025-01-20 13:02:30', 'Crashcourse');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{85474B2B-E347-41B4-AB0B-508FAEE2AF2C}', 'global', '255', 'hatchpar', '2025-01-20 13:02:52', 'Infill hatch');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{DDC110AF-2CFF-4F4B-A681-2AD7AB16CC1A}', 'global', '255', 'hatchpar', '2025-01-20 13:02:59', 'Line hatch');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{2519A90D-90E3-46F7-93E9-3DB74FCF16BC}', 'global', '255', 'hatchpar', '2025-01-20 13:03:06', 'Model hatch');
-- values ArObject - de_ch
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{ED1BC03E-7892-4267-B21B-D992CE2C4C14}', 'global', '255', 'wall', '2025-01-28 13:53:27', 'Mauerwerkskonstruktion');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{044E1961-2D28-4BD8-B60E-E954795F77BB}', 'global', '255', 'wallwindow', '2025-01-28 14:03:59', 'Tore');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{DD624B31-4341-48D7-9354-C4E600307FBB}', 'global', '255', 'layer', '2025-02-11 11:44:34', 'Layergruppe');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{FABE1F8E-7229-4678-A49B-2611E95AB603}', 'global', '255', 'layer', '2025-02-11 11:56:25', 'Layergroup');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{5762312E-4136-4B99-9A03-9181C6C364F1}', 'global', '255', 'wall', '2025-03-05 10:23:22', 'Construction béton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{B0D57EF0-5EB8-403F-AFBF-3816BB12A68D}', 'global', '255', 'wall', '2025-03-05 10:23:42', 'Construction isolation');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{8FEB8E5B-3FC6-413C-94F3-2B7F29680B84}', 'global', '255', 'wall', '2025-03-05 10:23:51', 'Construction bois');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{59314A88-5941-4CCA-80D7-EF8448260EF1}', 'global', '255', 'wall', '2025-03-05 10:24:13', 'Construction sèche');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{2C599F24-E1F1-41AB-8D2A-DF12EB4D6C9B}', 'global', '255', 'wall', '2025-03-05 10:24:24', 'Construction brique');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{212C04DB-9183-4FB1-9257-6782AED075A1}', 'global', '255', 'floor', '2025-03-05 10:26:54', 'Construction béton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{42921A94-2540-4585-9784-92B1F635A4AA}', 'global', '255', 'floor', '2025-03-05 10:27:03', 'Construction bois');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{706E664C-C8FE-4F4B-AE25-03107BA1DB28}', 'global', '255', 'wallwindow', '2025-03-05 10:28:13', 'Fenêtres');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{E42D1064-F9B2-490D-A52B-D7C85FD1D6C4}', 'global', '255', 'wallwindow', '2025-03-05 10:28:20', 'Portes');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{6B0C9591-6640-4A51-A166-45EBF248D9CE}', 'global', '255', 'walldoor', '2025-03-05 10:32:39', 'Portes à châssis');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{EF16B20C-6BFA-433F-B29C-75B184BF34D4}', 'global', '255', 'walldoor', '2025-03-05 10:32:55', 'Portes intérieures');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{4378572D-4269-466C-9FE9-2962585551C8}', 'global', '255', 'walldoor', '2025-03-05 10:33:11', 'Portes extérieures');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{A9BF35F9-C542-41DF-BB6C-B4E27625A90E}', 'global', '255', 'walldoor', '2025-03-05 10:33:18', 'Portes');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{D9D7B572-2792-4156-BEF6-D92CF4340ADA}', 'global', '255', 'hatchpar', '2025-03-05 10:37:33', 'Hachure de remplissage');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{2FBF44C3-8CF0-432A-BC66-B05B8139E03C}', 'global', '255', 'hatchpar', '2025-03-05 10:37:54', 'Hachure à lignes');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, fr) VALUES ('HY-{855CA27E-31A7-430D-8D4D-5068F78F5FD2}', 'global', '255', 'hatchpar', '2025-03-05 10:38:12', 'Modèle de hachure');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{E77C7F5D-DE82-48E9-A805-8DFB104E89F5}', 'global', '255', 'wall', '2025-03-11 07:20:09', 'Konstrukcja betonowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{879883A3-10D1-4BE5-84D7-78E89FA3FA52}', 'global', '255', 'wall', '2025-03-11 07:20:22', 'Konstrukcja drewniana');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{21ABFA22-8E40-45EE-9E52-9529C3B58412}', 'global', '255', 'wall', '2025-03-11 07:20:33', 'Konstrukcja suchej zabudowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{918C2491-3A6E-4A0B-8B8D-03627BD1510A}', 'global', '255', 'wall', '2025-03-11 07:20:44', 'Konstrukcja murowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{1A3A84EE-533F-4574-ACE1-88F62C9025FF}', 'global', '255', 'wall', '2025-03-11 07:20:55', 'Inwentaryzacje');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{23E1DAB3-BC7F-4895-A3A5-0C3D1D92D345}', 'global', '255', 'floor', '2025-03-11 07:58:32', 'Konstrukcja betonowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{321A83DF-8E60-45A8-8B69-32569E00B1A6}', 'global', '255', 'floor', '2025-03-11 07:58:42', 'Konstrukcja drewniana');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{125F4F3E-03A1-41A5-9F75-B50660B70267}', 'global', '255', 'floor', '2025-03-11 07:58:53', 'Fundament');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{006E25C1-7E36-43D4-A620-E3A1EB330D30}', 'global', '255', 'wallwindow', '2025-03-11 08:00:30', 'Okna standardowe');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{4E8DC872-1E5A-4457-8151-2C7CDB467F1E}', 'global', '255', 'roofwindow', '2025-03-11 08:01:55', 'Okna dachowe');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{C0A8ECFB-DB5E-40C9-90D4-20B9B32C655C}', 'global', '255', 'walldoor', '2025-03-11 08:02:40', 'Drzwi ramowe');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{5CE4D551-5D69-41D8-812C-CC0F16369528}', 'global', '255', 'walldoor', '2025-03-11 08:02:50', 'Drzwi wewnętrzne');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{BC12DD80-7F05-4610-846D-39EBC426C21D}', 'global', '255', 'walldoor', '2025-03-11 08:02:59', 'Drzwi zewnętrzne');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{A5F6D037-9BAE-4E99-9A97-E45216F7F0A8}', 'global', '255', 'walldoor', '2025-03-11 08:03:17', 'Bramy');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{DB058324-8864-499C-AF58-05281C9B6515}', 'global', '255', 'layer', '2025-03-11 08:26:46', 'Design');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{0C6D67FA-C9DD-435B-9AF8-C01B169B73DA}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Arkusz metalowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{424708FC-965C-44FC-A4AB-25F9386FC2B9}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Asfalt');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{A7D4AEA7-DA3A-485A-80FC-2DD43B4A2ECB}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Asfalt na zimno');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{679387C1-C91E-4894-8EAF-8E54ADADCB84}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{E69A632C-B0CE-477B-BC84-76EB7A26279A}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton komórkowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{D6981558-7878-487C-874D-D01D24AB6ADF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton próżniowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{7359E0EE-9811-4A47-AD62-8C82E0F2FDB1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Beton wodnoszczelny');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{B15CE5ED-9032-42EA-A777-DE32E2B42F56}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Bezspoinowe pokrycie');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{AE095B3F-313D-4F9B-A1F7-F3518755E6AF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Blok betonowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{E300B3BD-4FF5-4F69-86B5-4D90C64A3A26}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Cegła');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{7AB87AC5-8F61-4C52-A6C4-5A1D6D4D9980}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Cegły');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{94E4A99A-C3A6-4D08-A8C7-1D179B3887B9}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Chodnik');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{1EFADD25-2C4F-42D4-8DA4-DFB45BBF8806}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewniana okładzina');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{55C5CF7E-4B29-4E72-AC68-4138222E060F}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewniany podkład');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{D9DFEFE2-F45B-405E-AD0D-4BB6377802F3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewno');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{67A5D60B-3D73-409A-8844-FC1603BD00D2}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewno klejone');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{09400F19-B618-49D2-873C-37C222E00135}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Drewno-metal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{8A9369D1-DFF5-4397-B1A3-3C35990D0219}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Dywan');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{C33ED6AA-4A1E-4338-AA09-1C5502438887}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Farby');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{B5B25ED6-3B1B-4AFC-9F54-459F063D5910}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Filtry');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{9520C742-35FF-4467-8CB1-7E0AB4D4C8ED}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Gips');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{5AEF0FE5-278D-496F-85A0-4A486CB2A315}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Granit');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{284860CB-2AB4-4005-B47A-467077C42FD8}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{9AC3D624-381C-4F0C-9184-7294FB53B72B}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - belka');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{796B1108-7A80-4BF1-B051-7CF5DBB71C2B}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - dach płaski');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{EF5E0FEC-867B-4BEF-BFAE-AD37300B5A7E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - okładzina');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{316FEF15-9103-4D64-BD4A-9030CC51AA4D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - słup');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{FB0D6781-A191-4644-A4E5-3C2F70DF0E0C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja - sucha zabudowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{8AFB3DE5-6CC6-4A43-8B94-D229889F9725}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja podstawy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{89205EE7-81B2-4EC0-8093-B511036C7C1E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Izolacja zewnętrzna');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{D251F8C0-C752-4DF2-88E0-BA86F2847996}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Jastrych');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{97EEEDB2-7FA1-4B50-B2D0-0E4A221B047E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Jastrychowa wylewka');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F72A303C-A861-430E-A74F-52A4EF7FEEDD}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Kamień');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{5888D8DB-5F44-4E9B-B745-2BB2AA816965}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Komin');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{75737539-664C-4128-B4AD-354E75BBDB8C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Konstrukcja drewniana');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{B85520C6-6743-4765-AC7C-A93123729618}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Konstrukcje drewniane');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{2E9B6A15-5664-4945-94DF-6787DFD3F5C8}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Korek');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{9B7372F0-892D-4F37-92D4-9DB1961B7A0E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Laminowane drewno');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{C35C5113-4FF4-483A-98D1-8FC1E3407E7A}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Lekkie metale');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{C93BBAC3-06DD-4FAB-BF79-0187264DEA33}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Lukarna');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{572BBB26-FDCD-4D34-A416-B00C2F0CE14D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Naturalny kamień');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{0E961369-2C05-499A-BA35-47C27D9E9B5E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Odsłonięty mur');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{6D338AC8-8FC2-480A-AC98-9A908B46501A}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina betonowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{18B0E142-AAA2-43E5-9025-6BE6CE780E83}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina elewacyjna');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{C536D612-0037-4A00-9A28-14664920D701}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okłądzina plastikowa podłogi');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{7F664874-887D-47CB-82EA-DA1F6E0E0217}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okładzina podłogowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{5B636444-ADFB-4D5B-A3FF-079CF9AD54D1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Okno dachowe');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F9018F19-3165-4FFF-9313-5810EA0521DE}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Panel metalowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{268BE652-399E-407F-9BDC-1C4D420DFCB3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Paroizolacja');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{6B6DC460-9228-489E-95CA-C1CEB6B1265C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Pilśniowa płyta');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{E8307CC4-5012-4368-829F-81B492107020}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Piwnica - podział');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{87B83128-7AC1-48FF-8AD5-C88FC6461BCC}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Plastik');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{595817CE-DC9A-452E-AAD1-7913E3F1C432}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyta akustyczna');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{3A3538FD-193B-4C74-990B-2A2C3169FAF9}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyta kompozytowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F5767689-EAFE-495A-AC0D-8510778CFA3F}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płytki');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{17B49C1E-9047-4FAA-BBC0-C698E30E2CED}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płytki ceramiczne');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{13C0764B-0C13-49E0-8778-0100213049EF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Płyty');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{23A92E96-CDC8-4AB8-BE13-A3E7D4D7ABF7}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Pochodny produkt drzewny');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{345308AE-043B-4135-9EDC-A938480538F3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podkonstrukcja');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{46882B62-8C50-4B60-B5F1-0EAF670A0FDD}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłogi drewniane');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{ECEA3E61-40A5-43C9-8D35-E94C1F32690C}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłogi żywiczne');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{66899E13-5BC5-4FFF-96D1-2DC8D9452A27}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podłoże');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{0A21D713-5D40-4278-B3D0-6D9CFA6284FC}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Podwójny spód');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{AE72A862-486B-4F12-9C80-42030F3BFDFF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Powłoka wodoodporna');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{B6E527BF-6EC7-48C8-9DB3-A7000C45A6EA}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Prefabrykaty');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F42FE616-2CC0-46FF-8408-B2438C671EFD}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Prześwit');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{0115E354-0686-47AC-AB6F-CF9A113A58E3}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Renderowanie');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{DE400169-335F-43EE-AF9D-A9BE6899F1AB}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Ściana działowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{7ECFF1E2-9B3B-44D8-B69E-4D8E2D770C79}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Ściana panelowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F3E14D4B-8938-4451-9EE7-70335D28B43E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Stal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{A55E9060-13F0-4BEB-80A1-17B581FE0904}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Stan surowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{5C25F1E8-C4E7-458B-B482-4A1ADE7B5121}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Sucha zabudowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F39B20A1-13EC-4E4C-AAF6-0DD9A87DBD4B}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Szkło');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{1B3C0E0C-2503-44D8-8E8A-5985AB42CEE4}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Sztuczny kamień');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{ABADD8F3-9B8D-4F3D-ACAF-1761393345E6}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tapety');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{CFD11BDC-AAD4-482E-93EE-F4FAB47A2B7F}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tkanina');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{B74097B6-B73B-4555-9353-182BA3B1B3DF}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Trawnik');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{D15B26AA-A4A8-415E-B54F-6869F82E1643}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tynk podkładowy');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{CE9B04F6-D7F1-4FC7-9409-24C66D5AD300}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Tynk z włóknem');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{D7413CAD-FAFF-4346-B9C0-3B6DD76F3108}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Właz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{F71A1810-1DC5-4204-8A8F-E4D89E71952E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Włókno cementowe');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{BE6EAEA2-3AFC-4AA3-BA35-C621304A249E}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Wylewka jastrychowa');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{70FE09F0-9AB2-4987-8BFC-7E70F9378BF1}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Zew. izolacja');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{3F6B58B6-A0F8-4FE1-878E-32BC6F496526}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Zielony dach');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{0D4908EF-CCFC-4400-A10D-CDB08EEDC13D}', 'global', '255', 'material', '2025-03-11 11:47:28', 'Żwir');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, pl) VALUES ('HY-{8C0D8B2F-5F85-4389-9600-C8209FC68C20}', 'global', '255', 'material', '2025-03-11 12:26:26', 'Metal');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{E6085DBE-2A47-4700-97DB-50FFBC0877AC}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Σχέδιο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{A8B480B3-D8AC-4144-B9BE-4CA7B098554A}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Αποχέτευση ομάδα');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{9D769A28-240E-4267-AB92-767789B6847E}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Arhitektura');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{778EE413-D2A8-4B0B-9222-3A2DBF326D23}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Komunalni vodi');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{451985C3-F5B0-4559-AE16-C117A1373226}', 'global', '255', 'wall', '2025-03-17 14:30:33', 'Τούβλο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{5CD9EA0A-5F83-434B-8B2D-98028157B7B0}', 'global', '255', 'wall', '2025-03-17 14:30:44', 'Γυψοσανίδα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{378699C0-2E0E-4424-88D6-9728F8A753FC}', 'global', '255', 'wall', '2025-03-17 14:30:56', 'Σκυρόδεμα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{91E24CFD-9DF2-4004-8A78-C794462A0FCD}', 'global', '255', 'wall', '2025-03-17 14:31:11', 'Φυσική πέτρα');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{6FE113BA-1C0B-4812-94E8-51651E7CE4A7}', 'global', '255', 'wallwindow', '2025-03-17 14:34:31', 'Γωνιακό παράθυρο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{553B7CB6-FD24-433F-ADF8-925BB2514248}', 'global', '255', 'wallwindow', '2025-03-17 14:34:41', 'Παράθυρα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{44C481F2-BA61-44D2-8453-1CD759A64E68}', 'global', '255', 'wallwindow', '2025-03-17 14:34:55', 'Συρόμενα παράθυρα');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{695913B1-66EB-4ED0-8DF0-B238BBE396DE}', 'global', '255', 'walldoor', '2025-03-17 14:36:10', 'Βιομηχανική πόρτα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{00E137BE-7C4A-4B3F-8554-951372B09AC1}', 'global', '255', 'walldoor', '2025-03-17 14:36:20', 'Εσωτερικές πόρτες');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{AA22DC2D-C840-4DF4-B00C-DF579B5A6C62}', 'global', '255', 'walldoor', '2025-03-17 14:36:31', 'Πόρτες εισόδου');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{5228633C-1C13-4E04-BA77-D7A7D902D50F}', 'global', '255', 'walldoor', '2025-03-17 14:36:43', 'Πόρτα γκαράζ');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{E26B880B-AAEA-4FEF-9515-1D8BEB5279EF}', 'global', '255', 'walldoor', '2025-03-17 14:36:55', 'Συρόμενη πόρτα');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{96701250-23D3-4FA7-8D4B-9056BCAD92B9}', 'global', '255', 'wall', '2025-03-17 15:24:32', 'Betonska konstrukcija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{375A5551-37F6-441C-AC4F-5D7BA7E5158A}', 'global', '255', 'wall', '2025-03-17 15:24:44', 'Izolacijska konstrukcija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{5A2C1D6B-25A7-4B74-9D46-37E3E8E83494}', 'global', '255', 'wall', '2025-03-17 15:24:53', 'Opečna gradnja');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{CB232DC6-42B7-4E4F-87C1-7426B8B43058}', 'global', '255', 'wall', '2025-03-17 15:25:08', 'Suha konstrukcija');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{70575993-A306-4549-8F3F-AFB50BACB9A2}', 'global', '255', 'floor', '2025-03-17 15:27:10', 'Betonska konstrukcija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{5C50A061-C81F-4107-B3EB-3B90A524945D}', 'global', '255', 'floor', '2025-03-17 15:27:19', 'Lesena konstrukcija');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{B5CF279C-0A2B-4111-893E-71C0FDF5862B}', 'global', '255', 'wallwindow', '2025-03-17 15:27:52', 'Okno');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{317EA18D-79A2-41F0-892D-437EB1DE94EC}', 'global', '255', 'roofwindow', '2025-03-17 15:28:36', 'Strešno okno');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{329FC666-8270-43C3-8A1F-62B26AEC019A}', 'global', '255', 'walldoor', '2025-03-17 15:29:04', 'Notranja vrata');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{3E31E2C3-41A9-44CA-B43B-77CA9E259479}', 'global', '255', 'walldoor', '2025-03-17 15:29:14', 'Garažna vrata');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D4E9A793-88A6-4B7F-B407-D50EA3665DD8}', 'global', '255', 'walldoor', '2025-03-17 15:29:23', 'Zunanja vrata');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{07818B8A-02EE-4D2A-B712-6EFE16334A8D}', 'global', '255', 'hatchpar', '2025-03-17 15:30:14', 'Infill hatch');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{184D6951-DC07-458C-9147-D4700E31951A}', 'global', '255', 'hatchpar', '2025-03-17 15:30:24', 'Line hatch');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{9D1565F2-8BE5-4CE9-A3E5-042D5670EF5F}', 'global', '255', 'hatchpar', '2025-03-17 15:30:33', 'Model hatch');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{8301B6E4-9A4B-4A7D-92DF-563A9956C060}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Beton');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{E83496E2-425D-4F0B-BCE5-54B5166127B3}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Beton vodotesen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{3AA5D382-C42A-429B-92B2-2ECFA218D37E}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Betonski blok');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{831D47FE-FB6A-418D-9FC4-7307725A7554}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Opeke');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{571B525A-3956-4FFA-987A-AB3AE14BF93C}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Ploščice');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{4E442170-1E4F-4F53-B947-432677238DA9}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Prazen prostor');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{AF434950-3159-4E59-AD1D-4A1671923BED}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Estrih');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{ABE1102D-75ED-4D4A-BB8F-7F53AF3EA1CD}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Eternit');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{AA89F366-E35D-4F30-B5C5-263051C28187}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Purobetonski');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{AEA56988-5F2A-4F99-95D4-4D12ADFF442B}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Zunanja izolacija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D39CB31D-BBEB-4ED7-A1C3-4C43ECBC4D8F}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesonitna plošča');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{E742C714-56B7-4F6B-A825-D3375DFEA5BB}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Mavec');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D1BFD1B1-7E6C-44B7-A56C-361E1AC531F0}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Sestava tal');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D3659218-AADD-451A-94EA-D362EDB9B0B4}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Zvočna izolacija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{5D30D5E6-6D80-4C2A-B380-E00652BA70BA}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Steklo');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{0B6BB319-EB35-4778-A5B4-FCD0C38EBE59}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Gramoz');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D828D686-4113-442B-9DA6-FF3375F6CD49}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{F5C97215-1FF9-44EC-9B5B-DB87CF6E45CB}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacijska prečka');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{81BC8FAB-172A-4C6E-8683-C0A26C413456}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacija med suhomontažnimi ploščami');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{31AAE582-96F6-4377-A248-09EAB3515DE5}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Izolacijska stojka');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{4AF83F35-ED7D-4AB0-98F6-E3ED6A7C7202}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Jeklo');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{56484D28-1968-4E1D-BD2C-1DAC65378BF4}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Kovina');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{390E4B9E-DB8C-4AEF-86B7-30BC01B559E9}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lahka kovina');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{7E5746F9-EDFB-4927-81D8-D7B44BF1605F}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lamelna talna obloga');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{9EEE8EE0-1194-4759-9585-88DDE08245E2}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Les');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{9D5231D2-FB6A-47A1-99D3-3CFA077E3EE4}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Les-jeklo');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{1EF2B8FD-F63D-44D9-BBA5-4CC77AB9DDE2}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesen opaž');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{26BF9656-E846-4A21-A7E0-FC6BC5808201}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesena konstrukcija');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{D00433B6-CB87-43D3-80B2-D839617B1F6A}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Lesena tla');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{A8BEBC5A-31C9-4E55-B25B-CD6E979DEA13}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Letve');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{7188B1CB-75BB-4251-9A5D-4652C4C116BF}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Masivni les');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{A8A55D62-5635-4107-8118-98B9B0C0D2AC}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Mavčno kartonska plošča');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{DFBAB207-6BCF-4142-AA2F-205EF82C3FD8}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Naravni kamen');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{E7222A07-D4F9-4422-A269-862A3355C0D6}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Razraščen teren');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{72B58B89-F4FC-4B57-94D5-2014A874C5A9}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Umetni material');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{9B909C15-C93A-49FA-83A1-AEC24F6E7761}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Tesnilni trak');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, sl) VALUES ('HY-{900FCDF6-2805-453C-84C6-D3EABD6BF001}', 'global', '255', 'material', '2025-03-19 14:09:25', 'Strešnik');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{493BDDA5-32BB-436B-B05E-2EFCF261D938}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Τεχνητή πέτρα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{63DB180E-8B4B-4AF2-892C-99154B349638}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Τούβλο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{4D8AF612-2060-48DD-A18A-4A6B4FAB812D}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Αδειάζω');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{BE9ABFD1-428C-422E-ACC1-6FAFD09EE6F7}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Σκυρόδεμα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{8BD5CBF2-5E09-40D9-B0E2-C04D215E847F}', 'global', '255', 'material', '2025-03-21 07:06:42', 'γύψος');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{D0B84A6E-0D87-4E34-AF86-94930B608023}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Χαλικι');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{BA646896-C1D8-4704-B3A2-5F438E104355}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Μόνωση');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{BEAB81D6-D38D-4E7E-846F-36A702D37D29}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Ασβεστόλιθος');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{AFCAA79E-41D2-42D8-A4E8-A49CEADD0A67}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Μέταλλο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{D1F8CC35-57C8-493B-9EBA-A24645792760}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Μεταλλικη επενδυση τουβλο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{85C37CD7-1D62-44E6-A0A2-B8802978F45D}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Φυσική πέτρα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{2DAA6AFB-DB88-4E3E-9E7A-67ACB0BAD9FD}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Φύτεμα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{5E1A2568-B8E3-42F9-91FC-1809333845A6}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Γυψοσανίδα');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{52258FC1-9F24-43A3-AE24-44053315153E}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Πλαστικό');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{E410A1B4-EDB4-4935-90CF-46BBE2C780E0}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Φυλλο στεγανοποιησης');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{C2F30E8C-7D9F-49C9-9EC4-DC0F2F564949}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Πλακιδιο');
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, gr) VALUES ('HY-{003449BC-01F9-4615-B43D-EB312FD8908C}', 'global', '255', 'material', '2025-03-21 07:06:42', 'Ξύλο');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, en) VALUES ('HY-{4F521C3B-4C92-407C-9F5B-6C280C156950}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'Mechanics');
-- values
INSERT INTO ecad_guid_info_hierarchy (guid, username, mode, add_info, modify_datetime, de) VALUES ('HY-{13235251-DB4C-4B96-B487-8564838F58B0}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Mechanik');
