USE ecad_guid_info;

-- guid info for: assoc table for mapping guid <-> hierarchy (n:n)
DROP TABLE IF EXISTS ecad_guid_info_hierarchy_assoc;
CREATE TABLE ecad_guid_info_hierarchy_assoc (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,         -- any guid (maybe also HY-GUIDs)
    assoc_guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,   -- assoc GUID, usually HY-GUID
    region varchar(255) DEFAULT '' NOT NULL,                                     -- e.g. 'de_at', 'de_de' ...
    username varchar(255) NOT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,                                          -- e.g. for any logical grouping    
    modify_datetime datetime DEFAULT NULL,
    PRIMARY KEY (guid, assoc_guid, region, username)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{43198C77-E456-457D-8485-741D066C19A4}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F48C206C-58A9-4146-B4DF-E778DC344CE9}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1D48B874-7232-4945-B3EC-1BCA7FEEC5A4}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{AC13355B-4DD2-4B03-B17F-4A5BF22BE31A}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{660F76DB-EBF5-4E39-98FA-F51F10702ABD}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4BA8E41B-9A48-4765-AD18-3F9DE323EDDF}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{6CCC07AD-335C-4AEE-B00B-4E29D08C66E3}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{68850C7E-17F9-4601-B6AE-BB935A8A504A}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C6D4A879-4D8C-4B8A-BF51-8D78A3CE8CD5}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{86ED93ED-0026-4A2B-9466-DDF917F20D45}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FEAEF45D-87EF-49A2-82D2-5627C5354187}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{DEF7D225-92D3-435E-A40C-5A8795B19DDA}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F4C36A15-BF33-4422-A43C-686BDA8D5A7C}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7B269F59-20AD-4D26-B236-FB499889F680}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{0E16ECF3-D35E-4262-A174-AFC8BB44B5B6}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C1FCAB43-CB26-48A1-9BFA-B1CD0D84949E}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F4031F68-CD28-4024-ABD3-1029643E3E6F}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{12C77C06-9A4F-40DA-AD0E-C19C0F5762FF}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F6308CF5-B8F6-4069-A77E-E0FE53B85B86}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{708BA5DC-B5D3-4F68-BC84-41057EE65D1A}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1CD9F1AB-1159-4B96-B1BB-55C9A106B98A}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7BB10887-26EA-4E82-B14A-DA57E5886242}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1B699DA8-3021-4BF0-BF05-25586DAAF0D5}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{D2F7F725-069C-465B-BDA8-DCB130C85EEA}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{269BC8D7-FCA7-443D-9025-D8B902989645}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EFEB9787-4BAC-4127-99A2-0A45DFBFF932}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FE2F2EC5-76C1-4722-B6C0-8B72879375F6}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EB9C770F-A6E0-4490-9186-DC7668ABB503}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{12BF8207-FA89-47C9-B292-6D7F50B0D62C}', 'HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{513B983F-F798-4E5B-A95C-AB98640EC3A3}', 'HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{76F255A8-28E4-4EB9-ACFE-3AEA0C217050}', 'HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4E8F44E8-BEC2-4B95-9352-A08CA55CF04F}', 'HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{70B55CC7-85F8-4955-BA2F-7B877A545BA5}', 'HY-{7DDAF044-CC85-416A-A4BB-614FE38FB9F7}', 'global', '255', 'layer', '2024-04-22 08:00:00');
-- values
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{89661D66-DF45-4A1C-B350-09DEDD11FAB6}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{84B26863-04AA-437B-95E4-D35A644B7F0C}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{20389C8B-2E58-4D82-82F8-FD0D1AEF4B34}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F0BEA28C-627A-4A79-AB10-1C7F908AB65A}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C1FCAB43-CB26-48A1-9BFA-B1CD0D84949E}', 'HY-{F52B33A8-79C2-403B-BF7E-F3F1DDE727EA}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F4031F68-CD28-4024-ABD3-1029643E3E6F}', 'HY-{F52B33A8-79C2-403B-BF7E-F3F1DDE727EA}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{0E16ECF3-D35E-4262-A174-AFC8BB44B5B6}', 'HY-{F52B33A8-79C2-403B-BF7E-F3F1DDE727EA}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1CE72B80-83E4-42EB-BC09-5662BB2C2CF0}', 'HY-{98285FB2-92F3-42DD-95FF-7AC0CF428AFC}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{9B5D7864-7ED4-4144-8BE1-AE7699A6F842}', 'HY-{98285FB2-92F3-42DD-95FF-7AC0CF428AFC}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{D6ACB3FB-500C-4A9F-9D16-7650DFEB9C3F}', 'HY-{98285FB2-92F3-42DD-95FF-7AC0CF428AFC}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4EB78200-BBCD-4BE8-BB41-CF0296C65AE1}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{9301FED8-A627-41CC-BE3B-21DF6387C85D}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E4DC3933-0B57-425E-BD4B-CF70E53DE90D}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1B699DA8-3021-4BF0-BF05-25586DAAF0D5}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1E338982-08DD-48AF-8CFE-59932E63AB0D}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{B869F2AC-E1D8-430B-9220-D21F417E75C8}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{9CA6E84D-34B5-4363-92AD-0DC9276F4D75}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{DB824FD8-F6BD-432B-B16D-D0F87ED0DDEF}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{A9BBF2BD-A2B3-48B1-92CF-9FB7E3D3277C}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7BB10887-26EA-4E82-B14A-DA57E5886242}', 'HY-{F9ABC938-56F4-4F01-93F4-650D8BE06D74}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{D2F7F725-069C-465B-BDA8-DCB130C85EEA}', 'HY-{4E457834-F0F8-4F14-9D84-D3AEC3B2EF06}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{115E9E8C-B0BB-4AF3-A6B2-8C1C314075AD}', 'HY-{4E457834-F0F8-4F14-9D84-D3AEC3B2EF06}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EFEB9787-4BAC-4127-99A2-0A45DFBFF932}', 'HY-{E0C9EA3F-4619-471C-8582-363CD71B0E28}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FE2F2EC5-76C1-4722-B6C0-8B72879375F6}', 'HY-{3D536AF0-D04C-4698-A4BA-B5E1F8962371}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EB9C770F-A6E0-4490-9186-DC7668ABB503}', 'HY-{3D536AF0-D04C-4698-A4BA-B5E1F8962371}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{269BC8D7-FCA7-443D-9025-D8B902989645}', 'HY-{80A01A87-D2B3-46AF-BBE2-C77AF56D7A2D}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E6C17451-EA76-4552-AF5E-0C668F76DAEE}', 'HY-{80A01A87-D2B3-46AF-BBE2-C77AF56D7A2D}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{60578AA5-AD91-4ECE-BB87-778E65645B72}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{43684C77-0061-45D3-BC68-CD5AA20F1FE8}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{699591A1-9053-4366-A373-0864B6FE10E3}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F6308CF5-B8F6-4069-A77E-E0FE53B85B86}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F4C36A15-BF33-4422-A43C-686BDA8D5A7C}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7B269F59-20AD-4D26-B236-FB499889F680}', 'HY-{9BA996A9-8AC3-43B9-9878-4FEFB7326EA9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
-- values
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{D2F7F725-069C-465B-BDA8-DCB130C85EEA}', 'HY-{34C5BA91-BC48-461E-BE67-E6F489CBEBE9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{115E9E8C-B0BB-4AF3-A6B2-8C1C314075AD}', 'HY-{34C5BA91-BC48-461E-BE67-E6F489CBEBE9}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EFEB9787-4BAC-4127-99A2-0A45DFBFF932}', 'HY-{666ABABB-49F7-4C72-8DCA-1C49CA32E8BB}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FE2F2EC5-76C1-4722-B6C0-8B72879375F6}', 'HY-{D059902F-01AF-4949-90FA-B5FC4BE3CBCF}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{EB9C770F-A6E0-4490-9186-DC7668ABB503}', 'HY-{D059902F-01AF-4949-90FA-B5FC4BE3CBCF}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{269BC8D7-FCA7-443D-9025-D8B902989645}', 'HY-{2C5CF3F9-548A-4A3A-A88D-A08F4A273A9A}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E6C17451-EA76-4552-AF5E-0C668F76DAEE}', 'HY-{2C5CF3F9-548A-4A3A-A88D-A08F4A273A9A}', 'global', '255', 'layer', '2024-04-22 08:00:00');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FCBA1AEE-FC14-4D84-B036-76AC15DC3D05}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:16');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1EE71A67-2FCE-47EB-9199-420CD72775B4}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:16');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{867265BB-030D-4F6D-9BCB-135134F98996}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{BEAA6F41-830C-49CF-9EC5-3E7E190AF65D}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{01A8AAE5-3540-46C6-911B-54F9B876802A}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E80878AD-3DE9-410E-AF6D-816F1320147E}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FD641895-DE72-4DD4-AB8D-0C700AF91185}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FF5D6674-84AE-4CB1-9781-A729DA03B5A6}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{AC7C112F-A9EE-4596-AB75-80712F0B9785}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{8DBD3C4C-FF93-44E3-8E5F-2FFB1F816327}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{55243216-9B59-42A1-B60C-83E5847D7782}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{CD2E1723-5CC5-49CF-9859-1BC703518606}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4CB1C71E-30A6-4B42-995B-99EBF5AFB8B6}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{835F774B-E446-457F-B4ED-FB9E523BAE90}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C45D2ED5-75B3-48F1-8E6A-BB9C905A3577}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{04907890-954F-4006-A30F-B984B019BE69}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{35FEEF03-EAF3-406C-ACE0-8550384A5EE5}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{BDB0B590-FC30-4FCA-A480-79509D815E61}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{B6393B3E-E547-419E-83D4-CBFEEE78BB67}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{93CE553F-EE9A-4C06-85EA-CD244E5279D1}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F06B01AE-B5E6-4A44-A47D-11B6938406F4}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{9C7A53A6-5FB7-4ACE-9F3F-F2DE926E029E}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{65CE0E06-C13B-4A2B-91CA-9F1EC1A808A8}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{8B9857E2-E038-46CD-951C-479B605215B6}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{6681FA3E-EE46-4123-8AB2-3F7DB0B96518}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{955527B6-28C8-4E30-A876-076913397702}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{253213EA-3ECF-4F66-B113-019DB154B065}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7ECD89D4-F883-4C3E-9ED5-9712D33ADDAF}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C613905C-5233-493C-AC15-FBE802031DCD}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7262EB20-71E0-4066-B2A6-C421446869F5}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{3ADD4649-9937-4D59-9CAD-4B6085960B2E}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'HY-{EE9738EB-AFF9-4DF2-944B-673957176D36}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{CB48CBF3-1AEF-4B73-9F73-65AADA3455B0}', 'HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{3106BA2A-D5BD-4048-854D-FCD86FEE45A1}', 'HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7F2D2041-CF67-4BD7-9836-D1E8EED22218}', 'HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{63C7E140-6300-4471-ACF7-33FC937D4C14}', 'HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{85EF18E2-2C91-4C77-A5A3-F33181BEE638}', 'HY-{D5FFF660-A3AE-49D3-A718-4A92E82FAA14}', 'global', '255', 'layer', '2024-11-20 11:33:17');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{97331A7E-E2F7-4134-8D12-BCB6209045EB}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{6D368216-CECF-4F83-AA45-FA406CD17A1C}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{8B2AD10F-0B24-42FE-80F4-EDBCECC0E459}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E0C64C7F-B543-4C07-85D7-394130E854DF}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C81C9BF3-E779-4E28-8D6A-E17D1EF58F8A}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{AA188EC6-789D-4E81-B60A-9B2428792E12}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{18B68905-BA42-4343-B476-BF83501BFD1C}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{7DDA33B5-9560-4A4C-82E2-1225CB5062A2}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{18093161-A331-487C-BEAD-B53202392319}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1745C18A-DED1-480A-94F8-3AD8347B2258}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{CA0EBB4E-10B0-414D-B508-791298AF94B5}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1CF0839D-2F76-45CE-8B56-5D9FD981D45C}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F5E73C37-B455-4912-A3E5-092066931AD2}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{C7C2695D-8374-4DAE-B983-E6C4202ACC9C}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{BEB7D7C5-E8F3-4EA9-A97D-C416FCF1E00F}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{D28D4CC6-FCAE-4ED8-8060-BE4B6783C0E9}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4BF74204-C194-4DC9-8599-C022F5EDFA31}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{F6BBFC0F-BC77-48F9-B151-0DF9C4E4C4F9}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{1FC54F33-D423-49AB-AE60-F651DFFA29D9}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4546B9CF-6F4D-40BC-B03E-3EBA9DDE58D6}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4E01A438-09A1-49BA-8B05-B4FA3F074E3E}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{61DEA2E8-D076-4BC0-8FC4-5B98393D64E5}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{DA0D52BC-DDE0-4CDF-BB22-F8E77F06086D}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{E316388A-7455-48E2-B1EA-029892F7F886}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{36BE7DCB-4419-4357-BEC6-72EA63334129}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{42556DC0-8DF9-43E5-8904-F526106134FB}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{21694216-51CF-493B-91AA-A686C7C8F33C}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{5BB37F14-C74F-45B2-BD76-B2B09246FFFE}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{8AA86B6B-2934-40E0-BF61-BC6C9226F55A}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{027432DF-D527-43CB-9A13-ABA97ACEDC1E}', 'HY-{569920E1-754B-4E90-A1E4-A78CA1955A4D}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{4A3BE985-2BFB-477E-8906-53063A6E6418}', 'HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{50FDD51F-541A-4E2D-A373-F78F8A3C97E2}', 'HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{FD8A64C3-0A5F-4064-BE37-9D2575C7E306}', 'HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{CE55CFF2-33C7-4BD4-9E25-129B66AB52CE}', 'HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{255822DE-00AA-4B7F-AA91-FA934746C0B6}', 'HY-{1B67F28A-B978-46E6-93F9-98EADBAC9058}', 'global', '255', 'layer', '2024-11-20 15:37:41');
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, username, mode, add_info, modify_datetime) VALUES ('LY-{DD312B87-0BA3-44E6-96F6-BC365727D277}', 'HY-{92FA723F-C2D7-4B20-ACC4-55DF19F64CA6}', 'global', '255', 'layer', '2024-04-22 08:00:00');
-- values material de_de
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F80ED60-7902-443A-8904-8E9744E9D378}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abdichtungsbeschichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D511756B-8654-4B0A-809E-AE11FC4C3D1F}', 'HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abdichtungsbeton -> Abdichtungsbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F9C0D9C-0CBA-4FC8-BBBB-4ED5272A4D5C}', 'HY-{0CF4BC41-46C0-4983-BEBE-2E9B4860320E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem-Holz -> Abtrennsystem-Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13AB4089-6B23-4B7F-8CC1-A4E733CABF3E}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem-Metall -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE06406D-E0EC-4FAA-A979-691FDA8E1DBE}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikplatte -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F1940FC6-EC8B-4A22-B1B1-C170B36E9848}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E2D3FCB1-9C3D-42AD-B4DB-EFCD98A78474}', 'HY-{59EE99A2-77E7-4E92-BE3B-15DCB2D69E88}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich roh -> Anstrich roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B0473DD-4B0C-40F2-9161-138611D38B81}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich Sanierung -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6B01795-0A4C-45D3-B3C5-A22F146A2260}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Asphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EABD763-E8B8-4D7C-AB13-FE2AB5053A48}', 'HY-{3CAF35C4-06A9-49C8-B116-334D352F6616}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Auflager -> Auflager
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B1CBEF8-F010-470C-8FD3-A6E5C0BA633A}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussendämmung -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EC943ED-C356-4D99-BE33-1B086A82D021}', 'HY-{CC91BEF7-F97A-4D27-8C47-E52141D0E3E6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussenputz-hinterlüftet -> Aussenputz-hinterlüftet
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2EAA1D9-F8A6-437A-94DA-5FF88226B165}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein-Sicht -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{311D06DB-9798-4809-9AFB-E9D816720563}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung-Verschiedene-Aussen -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66E20559-6C13-4B44-BEF8-1465FE22536A}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung-Verschiedene-Innen -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E11C5196-E554-4409-80B5-B3870914E518}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bepflanzungsfläche -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8C63912-956F-4F6B-9D49-5BD2B0A6BF27}', 'HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung-Verschiedene-Aussen -> Beplankung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0169DCE8-D84F-42F4-B7A5-4A48A22E8328}', 'HY-{F21B7DDA-3432-4A5A-BEDA-920AECB986BB}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung-Verschiedene-Innen -> Beplankung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42D5DFEC-B2F9-4E0A-97A0-94FC2A42AEAA}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B0576EC-E063-420F-A3B2-70B4635A590B}', 'HY-{DD048929-D856-4824-8501-62637F813393}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonboden -> Betonboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EECFC826-B81B-46AD-B652-C5F0E196D30B}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonoberflächenbehandlung -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{654B2532-349B-4617-9BCA-94F05447CA05}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBD968E7-C1B4-4561-BA8F-C15A82A4B37B}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Blech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7BADAA3-4258-4567-B03A-B9D1C67DB67F}', 'HY-{20A160E8-D19B-487C-A3FC-6B0193030F74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Blindboden -> Blindboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C14E768-9CDA-411A-83E3-609FC9DCE60C}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenbelag-Verschiedene -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9509E1-342B-4E2C-991F-138A1751767C}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bretterstapel -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EDB66198-48FD-4966-AB5F-8C07384FD0F5}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtholz -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB71F999-849F-43C8-A8B0-7032471935D8}', 'HY-{67EBF2B3-E9E1-47C4-BC13-FEDA9AF6BBF5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettsperrholz -> Brettsperrholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82D09EA7-2C80-455F-BCCC-FE5C06E6D33A}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbegrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{356FADF1-2C61-4BD4-B30C-7AA2A059DC31}', 'HY-{299FFDF9-7F1C-4DF9-8F13-1DE96FED55E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbekleidung-Verschiedene -> Dachbekleidung-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5F11D03-D7C1-4081-9E29-35B98053C9F2}', 'HY-{B1E8FCF3-C72F-4101-BDE3-AE89548C2DA3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachflächenfenster -> Dachflächenfenster
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4FB539B-D1CE-4618-8AD9-411C1BDF0230}', 'HY-{5BBDFA3D-43A6-4816-80A9-CD97F09DD0D0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachuntersicht-Aussen -> Dachuntersicht-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4543ECDC-AA37-463C-9E62-7E5AEA365EF2}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E77D8B-6EF4-4A2F-8214-3920D837DE84}', 'HY-{0A902A49-65FD-44F7-A8C7-EDCE75208AC4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmputz -> Dämmputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B74BA8CF-AC3E-4870-BFF1-FBEA17DCCEA5}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEF0976F-C017-40E6-BCEC-AA1A732B81DC}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Balken -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC6A6C37-DC46-4109-AB83-EA35988DC3A6}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Boden -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{301F94B3-AC22-4E77-9E42-39947B6A600D}', 'HY-{80F59ACE-3F9B-4C7B-ABE9-8684E1E393E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Decke -> Dämmung-Decke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D97AE1E8-AAD0-43B6-B29D-31364B71589A}', 'HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Fassadenbau -> Dämmung-Fassadenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D9CDD63-1A58-4462-97D7-74DC97F2C72D}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Flachdach -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95161056-69CD-4B90-8854-3203EB683A47}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Hohlraum-Verschiedene -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05AEFD54-4E7A-4679-B6F0-1E238FC41E9E}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Holzständer -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{262F27AE-2967-43E1-A091-3CC6A119DB28}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Holzwolle -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25AD412F-2322-42DA-97F2-21D867D9DF25}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2E39BE02-D354-4C5A-9345-8DA451D16CAD}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Lattung -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5727AD1-3BB2-4648-B50A-CA7DBFC02778}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Perimeter -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E758803-10B3-412A-8968-93E05D86E7F8}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Ständer -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8B67552-F7BE-40D4-A460-A3D99EDDD773}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{084BA81F-8754-4DE0-82AC-880F64F03293}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Trockenbau -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29E896B3-665C-45B9-8BF5-9FE0C320E0D1}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfsperre -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338AE0A0-FC06-425B-81EB-77CBD6EAC70D}', 'HY-{FC196730-5CE9-4098-93E2-15CBA87BA352}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckenhohlraum -> Deckenhohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E043215A-8E25-4AEB-9E44-0DD862E1E323}', 'HY-{AB63944C-E2E3-4BB1-99C6-7638557623E5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckleiste -> Deckleiste
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CAB62DC-0509-4E7F-8BD2-838036E4DDE5}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D10C998-8690-404C-8A1C-FB2C79ACEF01}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz Sanierung -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F4391BE4-3DBA-40E4-A244-2C3C716D32CA}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dichtungsbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8725130A-6A67-4C62-BF66-053864E38879}', 'HY-{BBCB8289-D3FA-4C80-90CA-518A1C518852}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dichtungsbahn-Kunststoff -> Dichtungsbahn-Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71FAC7F9-C184-4378-AD08-21C49F3718FF}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Doppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C952DA14-65E1-46AA-9B48-A4938FC31C9F}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Drainageschicht -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39C410BB-2C4E-4F5D-9808-23571B9CD8EB}', 'HY-{28F68337-C968-4EB3-8551-5FED863602F2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag -> Elastischer Belag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01042161-AF47-4653-8DF0-2DFB22C25B21}', 'HY-{89E91AFC-6B79-47B7-A9F3-182F6F69C6C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag Gummi -> Elastischer Belag Gummi
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0BA87327-C6D8-4181-950E-8E2D21E03450}', 'HY-{712C3B68-2D82-487E-A095-7E882C5E5C0E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag Linol -> Elastischer Belag Linol
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9268A79-566E-4922-9AC7-BF935D20D780}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE726D90-E0CF-4841-B354-1A61A73B83AC}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau-Backstein -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A25A5713-0A27-482E-AAF4-C317E26C8F0A}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau-Beton -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1053130-23F9-4D5E-9BF9-36DBFBC4522A}', 'HY-{75AB92DB-55F2-47C3-8F5F-FA3D8600113B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau-Porenbeton -> Elementbau-Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0BB9E72F-11A0-42E1-989B-DBCC862AFDC0}', 'HY-{1A2C6EC3-683B-4EF5-A440-D0B873F2C099}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau-Sichtbeton -> Elementbau-Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4FD2A875-1E69-43AA-9C7B-058C98116C87}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich-Element -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25AF8E8F-FC0F-4BFA-B609-0FE77D254E79}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzement -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{567CCF42-21C7-4FD6-85BD-DAE8D52C7BA9}', 'HY-{2EE64CDE-75CF-4F8E-B0D1-489D91F288E3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fassadenbekleidung -> Fassadenbekleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8D57DFA-F7C2-4144-A819-EE9FBD08CA1D}', 'HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachbelag-Verschiedene -> Flachdachbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551FD34A-F3BD-45B2-B29F-D9AFF7A5BC74}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{108D9C61-0E0D-452E-9E5F-9BBB6B2A48F3}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich Anstrich -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE0E5C7D-C8A8-404A-9EEB-F2DE1C580921}', 'HY-{E0651CA8-B0DF-4CFD-B43A-A06C360DED39}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich-Bodenheizung -> Fliessestrich-Bodenheizung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{532233DC-9A37-4817-89E3-5517BF7B50CB}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fugenlose Beschichtung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C44D1F7-6131-4446-9092-C0884A2B1129}', 'HY-{7636A3CC-FBE2-4679-AB3F-0A3226E1AAAA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gips -> Gips
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED62C039-21E6-4A23-8193-58CBE2454988}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatten -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27903630-783C-45AE-9E5C-E30160073F66}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskarton -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16CEE4D3-9CDA-4DCF-9242-84AF6D9F4259}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FE606D8-0495-465E-BA6D-4FB02BBFB8BC}', 'HY-{34324FDE-37CE-42A5-A789-56DA759C5DB5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glasbaustein -> Glasbaustein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8A7DEE5-3559-41E2-BA29-E5D96A41DF55}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{209DC80F-F315-4618-8219-4D3B705C4423}', 'HY-{3F310784-9291-419B-B968-5FAAD5EA2ACB}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Guss -> Guss
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB4FE04E-A4C6-4DD0-AC09-7319F652A76F}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartbeton -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E1DC2E2-16A4-4A15-AA32-FBA8EB30DFFF}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlraum -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC917823-C809-4788-80AE-10B5A3419747}', 'HY-{83AB8DCB-230C-4ABE-AA6E-14CEFD9B902E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlraumschalung -> Hohlraumschalung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53AD89F3-DA96-4895-91A6-2B37CB249C8A}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14DC65AE-FE01-4B85-902D-904A1FAFF5B4}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Unterkonstruktion -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85F6DC17-F255-449F-8139-FAA08815BF79}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Unterkonstruktion-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FCBF469-DDBD-47A3-9A5E-E8655FE0EA6B}', 'HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Unterkonstruktion-Konter -> Holz-Unterkonstruktion-Konter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF39A4F-A454-4196-90C8-503D4459B786}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzbausystem -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE32C99B-A34A-4F6C-8D20-480B8FAD84C5}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzbausystem-massiv -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5520DB60-0FCC-4750-ADA1-E95DDB876756}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B467DD3-E7AD-4458-9C1F-BC880AF184C0}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D11109DB-47DC-4C75-A9CB-10D68EDD262E}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzfaserplatte -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72588056-5804-460D-9C63-320B4B699879}', 'HY-{85A91D6B-777C-46E5-960B-C71689A613BD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzkastenplatte -> Holzkastenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97EA83C3-2ABE-45AC-96F8-05C4F1AADE82}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzmetall -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A6D932B-6996-4181-B667-AF781C2CD93C}', 'HY-{C09446EE-A15E-4488-B9AF-F3CFA786AC16}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzriemen -> Holzriemen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{114D715B-2B00-4BA4-A935-BC64D6A327BA}', 'HY-{FE079A17-7FA3-4703-AD16-E4E9DED71FD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzrippenplatte -> Holzrippenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F40174D-0BFB-4E61-A5D0-17CDB7BFC194}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzschichtplatten -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{434CCD74-E8E1-4935-AE96-EE4B1CBA97D2}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständer-Hohlraum -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DC76042-BF36-4735-A766-0DBE9D7C7C2F}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BE096FE-555E-4FDE-A2D1-837DB398BABA}', 'HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung-Innen -> Holzverkleidung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E6F63506-2630-455A-86F4-14BE9966EE5A}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwerkstoff -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B3B02ED-EDC8-4DF1-96BE-BA77929C8D1E}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwerkstoff-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{399A87B1-067E-4E28-A3E5-B6CE3F4C57C2}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwerkstoff-Sicht -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67F032C0-8B48-4615-8DAA-882CAB130229}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Installationselement -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C6C0A90-CE64-4691-A724-0BB639716BB5}', 'HY-{8A49658E-1BCB-45A9-8CAB-3FBFC1E94450}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kabinentrennwand -> Kabinentrennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{390B5A48-FF26-4116-80A9-6DA4F107C290}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{471A22AB-BF17-4531-8FCB-B7FACAD63F69}', 'HY-{680CFB2F-4443-4802-81D7-5B1ED17387E0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kaltbitumen -> Kaltbitumen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FBCAF5-0686-4317-9750-748A8143F704}', 'HY-{E3EB2521-C5E3-4D5D-800F-AFCC6566F7A5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kaminstein -> Kaminstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8DEBCC2B-F7AF-46D3-BAF6-E11613DA9F55}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kanalisationsschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DB4D983-7C1D-4635-B81C-8F05DB27D7E1}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA2E3849-1B94-4E18-969D-3C5C87D93797}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten Sanierung -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D5403AC-3323-495E-B53A-FCC5398A1B73}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F5686A7-78B6-445C-84FC-29CDC7DE029A}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerstein -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA5F0B33-E246-4922-AD18-3964E95DEF76}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Konstruktion-Verschiedene -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60FEFD8E-94FC-489B-91AD-AB926ED0A5C4}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{866AFAA2-3A42-453E-BE38-6FE3A6F29D84}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork Sanierung -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A331962-7D4B-47C7-92E0-A858E64C4363}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Küche -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81308FA0-594B-4C0C-B088-7C99E52C008D}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharzbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81C3D119-27B1-4E65-B03D-57B1C89E1376}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62D18FB1-526E-4D71-831A-7B00BB6FFB5B}', 'HY-{B1FE74A3-8588-42F2-B7E7-34489438E3C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff -> Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DB35AC-2FE0-4F59-8588-DDAA5F2E61F3}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffmetall -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CA5C230-B720-4CA9-9749-B4A9CF2DF020}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtmetall -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8AB0639-F900-4C70-88B0-C468B81D1A6A}', 'HY-{E36590D5-2521-4E85-8ACC-55C911057C34}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lukarnenschalung -> Lukarnenschalung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{154865CF-D3B8-4A84-A79C-B08982857291}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Magerbeton -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29F14CF4-9731-49F5-AE2C-CB5101DB6DA8}', 'HY-{7D3AE940-6256-47D0-878F-B0F3BBBDBBE8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Markise -> Markise
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2459D3D-17DA-48A2-8B41-B03D13A10438}', 'HY-{E188BD02-CBA9-4953-B16A-BDCA42D4FCB7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall -> Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E935BAFF-4E2B-4DD0-82BC-92B4F6992C34}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall-Unterkonstruktion -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6EDB39EE-B5DA-423F-89CA-5B5B1E3E4091}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallplatten -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAA22D0F-81EE-4591-BF0C-255A731A8EDF}', 'HY-{4B790B7A-0A63-413D-A725-40A230059EB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mörtel wasserdicht -> Mörtel wasserdicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46868212-E4D1-43A1-B8B5-95F61286C7BF}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC365583-C36F-441C-9EE1-921167CF5A78}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14878589-AC28-48BE-B2E7-A6C16E277486}', 'HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Noppenbahn -> Noppenbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E454439-4731-491D-8264-E92FF5C7522E}', 'HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Oberlicht -> Oberlicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{768E22B9-4F48-4800-BC3F-763155B4375A}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pflästerung -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{95DB5753-1850-4A78-BF27-38398479003E}', 'HY-{88D5142C-064B-4DCF-B1BB-7FD7A874152B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfosten-Riegel -> Pfosten-Riegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80F37F2B-3C2D-4F1D-92D3-B720988F5488}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plattenmauerwerk -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C39BDFA1-55CE-4468-ABDA-5FFA1CF781CE}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plattenwand -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B2B5AA-F878-415D-BF1D-9A042BCE968F}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbeton -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6682226D-0B08-4C35-9B28-7C50C5389A14}', 'HY-{54867749-FF75-4A51-AD06-9C75E358EB96}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Putzträgerplatte -> Putzträgerplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF8E7AF2-BD73-46E6-8B19-7F403B53F35D}', 'HY-{C9A79516-E3D1-4DD8-A166-7C00784576F9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Putzträgerplatte hinterlüftet -> Putzträgerplatte hinterlüftet
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74B3A49D-C985-4579-A6C2-0D14F720C847}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rasen -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72E4AEF3-B74F-4E10-8E6F-ACFF085CBB3C}', 'HY-{A0A05C72-7B3B-45AB-8EF6-5EFD459ADF4E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Roh -> Roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{965525C1-6327-429C-BB05-50A48E5C0505}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzschleuse -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC443148-F77B-4C83-A28E-B8666DFDD5EB}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzwasserleitung -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FCE5383-58E0-42D2-A839-3339A4CDC440}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbeton -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2827D17-4BE9-4D0E-8828-431CDB4C68A3}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtmauerwerk -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE5B8F7B-9D80-45B2-9782-AA7FA2B9BF2D}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerleitung -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEC42027-148F-4085-8FD4-B0769791F2BE}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerplatten -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3C40AAD-DF07-4A8D-9AA7-3E288A125CFB}', 'HY-{A33829BF-FA55-4EBF-84F9-3492AFAC2E33}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sonnenkollektor -> Sonnenkollektor
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{991BBBFF-57DC-416E-BA74-B289F91E1EAC}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED820211-7AE4-4959-A5BC-839A663653CB}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständerwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3556BDC5-C8BB-4793-95BD-308165793B37}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinholzbelag -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F535D44-8B8E-4E53-9F04-22009B7E67E9}', 'HY-{8791BDCE-88DF-455F-AE78-C5FA378F133F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stoff -> Stoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F4D8FA3-B242-4021-ACE8-9AD6B8046E22}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ADE7956-C38A-484C-A1B4-0BBADD4661A9}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete Sanierung -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A39118BD-A20C-4093-A5C9-5DB9703B012E}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DDF28E4-B35A-49AE-80ED-6746B29BF752}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich Sanierung -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FB693F5-E67E-4C28-9D2F-FB27285AC04B}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C4C53FC-3666-4DD9-B8A3-55F81A259925}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trennwand -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C2D5C06-DCAB-4FFF-ADD1-18F19EA106BE}', 'HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterkonstruktion-Verschiedene-Aussen -> Unterkonstruktion-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6657F209-2B66-4CBC-A43E-6ACDE0F0D466}', 'HY-{D692DFB2-FEEA-4387-8305-7983FCEFB44C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterkonstruktion-Verschiedene-Innen -> Unterkonstruktion-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70693F55-E31B-415D-B960-6971F3A0F406}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verbunddecke -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81F988E8-2FE8-46FE-B495-8BF91A399C9B}', 'HY-{A78788A0-5CE1-491D-B51A-5C05621DE825}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollholz -> Vollholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5D031C8-FFA6-4EA4-B5C9-71117B26A8FF}', 'HY-{698DEBC5-C683-4110-A545-9EF72E4ADE36}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vorfabrikation in Beton + künstl. Steinen -> Vorfabrikation in Beton + künstl. Steinen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49C4FACE-72F4-4E88-8DD3-C83A430E9218}', 'HY-{A55DD73B-29DB-425D-9AED-4FE1697B7F0E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementestrich -> Zementestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{328A6EA9-C18A-42E7-A7F7-A38A8A5E680B}', 'HY-{466EACD9-B412-411A-88A3-5E42399E251F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementestrich Anstrich -> Zementestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D43D177-AD27-4DD7-B979-9652A7624207}', 'HY-{F1419E16-44C9-4F53-985E-520F061D6DDB}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementestrich-Bodenheizung -> Zementestrich-Bodenheizung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA60FC90-EF01-410F-8E54-742109234CA9}', 'HY-{B1DC8151-B4A1-4E45-8B87-7C476622FAA0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegel -> Ziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A79A9EB9-0F61-42AA-9072-94300C8E8D31}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bentonitmatte -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F38A674E-2E3B-47A1-98FB-3393BDF480D8}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumenbeschichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB2D5562-6638-4046-8E0A-1F68A720D52F}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ethylen-Propylen-Dien-Kautschuk -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{561C80E5-A38F-4A57-8370-F0977B76B840}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Flüssigkunststoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{561C80E5-A38F-4A57-8370-F0977B76B840}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flüssigkunststoff -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5038E65B-08D1-4C27-8911-81069EBBED8F}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flüssigkunststoffabdichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{768F7C16-B435-4DDB-AAD4-4686510A7DC3}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lehmbasierte Abdichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{678C169D-B56C-477B-8B62-DBB072B5487E}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralischer Dichtungsschlamm -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD089977-55FB-4903-A94A-A157B9832E8B}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymerbitumen -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3090D571-3B41-46BF-9522-F0C8E2128529}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schutzbeschichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C8728E-5711-4117-B619-61428FCFBA6E}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schwarzanstrich -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F41B45CC-D814-4539-81A9-19AD613A9A4D}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Thermoplastisches Polyolefin -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B010390-AC8F-48DF-8EA0-CC391114BE18}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Wasserdichte Beschichtung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B010390-AC8F-48DF-8EA0-CC391114BE18}', 'HY-{349B47FC-473D-4224-BA8B-1BA141D9317E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wasserdichte Beschichtung -> Abdichtungsbeschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{57F8DD2C-6797-40AF-9F5A-2D1F298D73C3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Beton wasserdicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{57F8DD2C-6797-40AF-9F5A-2D1F298D73C3}', 'HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton wasserdicht -> Abdichtungsbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D714135-EAAF-429C-BF5C-11B8ED973DAB}', 'HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrbeton -> Abdichtungsbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BA76771-C779-4C74-A151-854471B1C409}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Sperrbeton / 750 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BA76771-C779-4C74-A151-854471B1C409}', 'HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrbeton / 750 -> Abdichtungsbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{317E4B2B-B058-47E3-8ACA-DC7FB9DB3A34}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Wasserdichter Beton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{317E4B2B-B058-47E3-8ACA-DC7FB9DB3A34}', 'HY-{CD2FC2D4-304F-499B-AED6-1C191704D7F4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wasserdichter Beton -> Abdichtungsbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609AC8F6-FCFE-4F38-846B-56AEEE6845E0}', 'HY-{0CF4BC41-46C0-4983-BEBE-2E9B4860320E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem Holz -> Abtrennsystem-Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B83E0EC7-6CDD-4634-97CF-E4B7E76A76D6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:08'); -- Lattenverschlag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B83E0EC7-6CDD-4634-97CF-E4B7E76A76D6}', 'HY-{0CF4BC41-46C0-4983-BEBE-2E9B4860320E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattenverschlag -> Abtrennsystem-Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C61D7015-1F40-4E23-AFAE-783508C75427}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Abtrennsystem -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C61D7015-1F40-4E23-AFAE-783508C75427}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45598954-1C67-4A84-9F2B-90DFE43FE043}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Abtrennsystem / 120 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45598954-1C67-4A84-9F2B-90DFE43FE043}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem / 120 -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF0A19FA-4586-4899-BAE5-4742E3334BE4}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abtrennsystem Metall -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DBD558F-79DA-4B23-9913-66D9CA681F87}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Gittertrennwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DBD558F-79DA-4B23-9913-66D9CA681F87}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gittertrennwand -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90647797-38F9-4D05-A752-8F1127E7D426}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Gitterwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90647797-38F9-4D05-A752-8F1127E7D426}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gitterwand -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B5511FB-E3B6-48D7-97E8-76CC4DE5C607}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Metalltrennwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B5511FB-E3B6-48D7-97E8-76CC4DE5C607}', 'HY-{876513AB-A44D-4894-AC50-22BC1D460F8B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metalltrennwand -> Abtrennsystem-Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{383EBA89-0ABD-48ED-82B8-75E30DA7910F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustik-Deckenpaneele -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{383EBA89-0ABD-48ED-82B8-75E30DA7910F}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustik-Deckenpaneele -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D463032C-F3B8-4CAD-880F-E36EE8881DAC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustik-Mineralfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D463032C-F3B8-4CAD-880F-E36EE8881DAC}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustik-Mineralfaserplatten -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{590AD895-8DE2-489A-8798-730C0787AB3F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustikdecke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{590AD895-8DE2-489A-8798-730C0787AB3F}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikdecke -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBE4677A-9016-4CB4-A34F-49E31E3D7FBB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustikdeckenplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBE4677A-9016-4CB4-A34F-49E31E3D7FBB}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikdeckenplatte -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D753236-6EC6-49FD-A171-9BC0754A65B8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustikdeckenplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D753236-6EC6-49FD-A171-9BC0754A65B8}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikdeckenplatten -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECA8484E-3F15-43DE-BD11-A29FED68500C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustikelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECA8484E-3F15-43DE-BD11-A29FED68500C}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikelement -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCFD3E2C-B50A-4CC0-B201-2E2084CF0A2D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Akustikplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCFD3E2C-B50A-4CC0-B201-2E2084CF0A2D}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikplatten -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7447C93-46E9-4E86-A50D-3C3F8E58C1CC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Decken-Schalldämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7447C93-46E9-4E86-A50D-3C3F8E58C1CC}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decken-Schalldämmplatte -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D01C7F9-7B20-4094-AAD2-3FF0B3847A2A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Decken-Schalldämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D01C7F9-7B20-4094-AAD2-3FF0B3847A2A}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decken-Schalldämmplatten -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4B3D42C-39EE-4AC6-AD19-7814A2850425}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Schallabsorbierende Wandpaneele -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4B3D42C-39EE-4AC6-AD19-7814A2850425}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schallabsorbierende Wandpaneele -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6087B2E7-BC79-427B-AF3C-458114039055}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Schalldämmpaneele -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6087B2E7-BC79-427B-AF3C-458114039055}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmpaneele -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E501A4C-6271-46F2-8D15-E63DB914C168}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmplatte -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{035990DB-C856-4836-AFD5-B7F36A078680}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Schalldämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{035990DB-C856-4836-AFD5-B7F36A078680}', 'HY-{59AC5358-90DD-4EC3-B816-BABC78D94FE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmplatten -> Akustikplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CE4759C-C91B-4247-B974-B4855D66FDED}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Acryldecklack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14A560E4-27C0-4520-A4CF-CAF533181827}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Acryllasur -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50592DD2-C882-4AD0-A64E-45E07B1CFEEE}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Acrylparkettlack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9066742-AFD2-4130-858E-B2FEC02E13E7}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alkydharzfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B079AB23-6F0B-4507-A0FE-076730771D41}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alkydharzlack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E7E8E6DA-D5E6-4F98-9263-AD0329085231}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beize -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24FDB761-489D-4279-9D9B-EB95068A6357}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenanstrich -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D836DB2C-AB88-4479-8D5C-4F52B6CE3BAE}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C560AA37-A840-464D-8B83-67686AA8670E}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dispersionsfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD902F89-8567-4185-8B3A-4C52ED65156F}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dispersionssilicatfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4000C445-B739-4779-8207-B9742EB2D535}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dispersionssilicatlasur -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20C6C4E2-12BD-431F-B69B-40A02E7AC2A8}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eisenglimmerfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58E837B1-A035-4866-A4E6-3AE3F6EE110E}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Epoxidharz -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2AAB7ECF-8159-417E-B5B1-2811D723A3AF}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Farbanstrich -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{195FC903-5E34-4726-B908-33535A31C402}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Fussbodenfarbe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{195FC903-5E34-4726-B908-33535A31C402}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fussbodenfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDA2548F-5498-4EC4-99F0-3B60F9EE5D46}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- gebeizt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDA2548F-5498-4EC4-99F0-3B60F9EE5D46}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- gebeizt -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{888D767C-0A70-4347-9FEA-3A6E7E5B83C3}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gestrichen -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35D96946-4D7B-489B-9A33-427CBE5BB5B3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35D96946-4D7B-489B-9A33-427CBE5BB5B3}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- gestrichen -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA5B9CF1-05E6-4047-9BA2-4535A2E2C156}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Gipsdecke gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA5B9CF1-05E6-4047-9BA2-4535A2E2C156}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsdecke gestrichen -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59868D05-6C49-4E2F-9D88-6E0B8E05E131}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19212EB8-216E-46DC-B935-460B2CE46A9E}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkkaseinfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E86B7457-4FAE-4CA5-995D-BC7D0B856C0F}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CADBAA3-3650-4812-A019-2FEEAFE44023}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- lakiert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CADBAA3-3650-4812-A019-2FEEAFE44023}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- lakiert -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C87900EA-E6CE-403A-8876-4A145672EBC0}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lasur -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E89B7972-0316-457A-87AE-A590FB07EFBC}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lehmfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18BE6BC5-3680-4F42-A01D-7095B5C0F010}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leimfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{169ADF23-2470-495E-AEEA-313F7D477742}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturharzdispersion -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B45DE141-D833-48BC-AE9B-B17E818294DF}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturharzöllack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{815F799F-68A4-4818-B0BF-E5BEF37C0D5A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Oelfarbe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{815F799F-68A4-4818-B0BF-E5BEF37C0D5A}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Oelfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1167B778-4AA5-4843-A6AB-03C95B48BC70}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Oellasur -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1167B778-4AA5-4843-A6AB-03C95B48BC70}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Oellasur -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F5A6BF1-DCB1-46EC-AB92-3FDA2BFAB052}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ölfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{367DBA57-91E5-40AA-8EF0-B34EA76A9D81}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Öllasur -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E7E0A43-9E9F-48E0-951F-C0DC3125C273}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymerisatharzfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{266A276A-26EA-48BA-90DF-221D85EBA343}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyurethanlack -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C08C49A-4DE3-43B5-BA1F-BEFBB53E072A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- PU-Bodenfarbe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C08C49A-4DE3-43B5-BA1F-BEFBB53E072A}', 'HY-{0DA6EFAC-7410-41F4-AAB6-12D2654C2D9D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PU-Bodenfarbe -> Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9858FBB-2D58-462A-95F2-3DDB4880A5BA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- roh gestr. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9858FBB-2D58-462A-95F2-3DDB4880A5BA}', 'HY-{59EE99A2-77E7-4E92-BE3B-15DCB2D69E88}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- roh gestr. -> Anstrich roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE6D4B3E-FD8B-4EDD-B401-DAF6E72A307D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Roh gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE6D4B3E-FD8B-4EDD-B401-DAF6E72A307D}', 'HY-{59EE99A2-77E7-4E92-BE3B-15DCB2D69E88}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Roh gestrichen -> Anstrich roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEB569A5-D367-4A75-AEAD-51F1FA3167B7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Roh/gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEB569A5-D367-4A75-AEAD-51F1FA3167B7}', 'HY-{59EE99A2-77E7-4E92-BE3B-15DCB2D69E88}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Roh/gestrichen -> Anstrich roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B09CF88-A66F-4406-8E9B-F08ECC953D44}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Abrieb / Renovation Maler -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B09CF88-A66F-4406-8E9B-F08ECC953D44}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb / Renovation Maler -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18B860FF-25AC-4EE4-A76B-0D3CC42CDD38}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Abrieb neu gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18B860FF-25AC-4EE4-A76B-0D3CC42CDD38}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb neu gestrichen -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF3FDC30-FE4A-4240-A3D8-0CED58E4C68D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Anstrich neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF3FDC30-FE4A-4240-A3D8-0CED58E4C68D}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich neu -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD06F747-DAFE-4C19-A627-FA11ACB7B4C8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Anstrich renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD06F747-DAFE-4C19-A627-FA11ACB7B4C8}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich renoviert -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD11FD53-C2C6-45FC-932E-2F5E86F34617}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Anstrich-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD11FD53-C2C6-45FC-932E-2F5E86F34617}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich-Renovation -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99B49391-9CF5-4206-9635-ABA2605A827A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Anstrich-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99B49391-9CF5-4206-9635-ABA2605A827A}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anstrich-Sanierung -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD6E676E-4870-4C7F-B4E1-0060A0DE8A8F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Deckputz / Renovation Maler -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD6E676E-4870-4C7F-B4E1-0060A0DE8A8F}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz / Renovation Maler -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C151DC2-4A8C-4B19-BE98-8EA4590A904B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Deckputz neu gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C151DC2-4A8C-4B19-BE98-8EA4590A904B}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz neu gestrichen -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB7BFA80-D4A0-4A08-BECF-34781DDB2952}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- gestrichen renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB7BFA80-D4A0-4A08-BECF-34781DDB2952}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- gestrichen renoviert -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC84551F-7A7F-4701-939F-5FD939FAC340}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- neu gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC84551F-7A7F-4701-939F-5FD939FAC340}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- neu gestrichen -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9D1DC2-FBB5-4E40-8773-CC5DB312EA4C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Weissputz / Renovation Maler -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9D1DC2-FBB5-4E40-8773-CC5DB312EA4C}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz / Renovation Maler -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3000705F-CF9A-48CA-9673-7C31C2F0EFE6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- Weissputz neu gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3000705F-CF9A-48CA-9673-7C31C2F0EFE6}', 'HY-{20BEBADD-26D9-4277-BD1C-471EBB104189}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz neu gestrichen -> Anstrich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31ADED99-69B0-4363-9DAC-376B6B42B162}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC B H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31ADED99-69B0-4363-9DAC-376B6B42B162}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC B H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8AE086E-2D1B-4799-8830-A2B6B84ED48A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC B S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8AE086E-2D1B-4799-8830-A2B6B84ED48A}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC B S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F6E960B-173E-4722-A96F-C657EC3A8DC8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC F -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F6E960B-173E-4722-A96F-C657EC3A8DC8}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC F -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{342FB140-311D-47B0-8DB3-46CC2402CEDD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{342FB140-311D-47B0-8DB3-46CC2402CEDD}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14D2B822-00EE-4E96-BB40-7D4EB232C771}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14D2B822-00EE-4E96-BB40-7D4EB232C771}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60BA90C9-D251-4CA4-9EF8-E3D2FDF20396}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC N -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60BA90C9-D251-4CA4-9EF8-E3D2FDF20396}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC N -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A2FC678-A6A9-48E6-83D6-C70E3EE2DBA0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A2FC678-A6A9-48E6-83D6-C70E3EE2DBA0}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B89DE7-0938-4A54-9FF8-93E073576FD8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC T -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B89DE7-0938-4A54-9FF8-93E073576FD8}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC T -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7AF0155F-EF01-4193-B6F7-91F6626B820D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:09'); -- AC T H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7AF0155F-EF01-4193-B6F7-91F6626B820D}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC T H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{608A572E-3BB7-4C78-AAA1-1E04ED34C7A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AC T L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{608A572E-3BB7-4C78-AAA1-1E04ED34C7A8}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC T L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63F7AF86-7068-422C-A6DB-0553BB041866}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AC T S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63F7AF86-7068-422C-A6DB-0553BB041866}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AC T S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A238640E-6C4E-4AC5-828B-F9A37AD05593}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Asphalt / 120 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A238640E-6C4E-4AC5-828B-F9A37AD05593}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Asphalt / 120 -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA520875-BEA2-40BF-B366-8227B3A745CF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Belag, Asphalt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA520875-BEA2-40BF-B366-8227B3A745CF}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Belag, Asphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BBFA414-77A7-4D50-A32C-38807BE08CC9}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Binderschicht -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{606F5259-4C7A-4101-B84B-3DCCF865DC3F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Binderschicht AC B H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{606F5259-4C7A-4101-B84B-3DCCF865DC3F}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Binderschicht AC B H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5D4BB2B-29DC-47AC-918B-981C46DBD9CA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Binderschicht AC B S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5D4BB2B-29DC-47AC-918B-981C46DBD9CA}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Binderschicht AC B S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D06A0200-A87E-422E-B9E8-7D33C2F7E1AC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Binderschichten AC B S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D06A0200-A87E-422E-B9E8-7D33C2F7E1AC}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Binderschichten AC B S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1204D132-F428-4C43-81F4-F7468B886977}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Biomodifizierter Asphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5658C54-1349-4825-B76B-90166654E27E}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckschicht -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63B143E9-30E8-4CFD-A682-B662CC2D4137}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Deckschicht AC L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63B143E9-30E8-4CFD-A682-B662CC2D4137}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckschicht AC L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF99EB05-DB4D-4214-9458-6C7231AF5714}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Deckschicht AC S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF99EB05-DB4D-4214-9458-6C7231AF5714}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckschicht AC S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C4FD198-50AD-4B1B-9349-A82ED9D32337}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Deckschichten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C4FD198-50AD-4B1B-9349-A82ED9D32337}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckschichten -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E61F05C-2DB1-42AF-9A40-51D21DD324B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Deckschichten AC L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E61F05C-2DB1-42AF-9A40-51D21DD324B6}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckschichten AC L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCC4ABE8-0D0B-4173-8CDA-5B0D0312FBEA}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekor-Gussasphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA1330F9-1FD5-4168-A90B-F6237DECF550}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Destillationsbitumen -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53FDE63B-9534-4FE6-A4D5-592E74DA36F4}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fundationsschicht -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C6BEFF7-DB76-49E4-8DC1-E928EE48B721}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Fundationsschicht AC F -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C6BEFF7-DB76-49E4-8DC1-E928EE48B721}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fundationsschicht AC F -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6AF3AB2-6063-4147-AB83-869D2E5FD7D2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Fundationsschichten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6AF3AB2-6063-4147-AB83-869D2E5FD7D2}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fundationsschichten -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{243EE2E0-8A38-479F-BD38-86A9D9E039E8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Fundationsschichten AC F -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{243EE2E0-8A38-479F-BD38-86A9D9E039E8}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fundationsschichten AC F -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C2A935F0-2BBC-462B-9D8A-E275F9BF3956}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gussasphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{655B28BC-9793-4637-AE6F-9BE8C44BCC07}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Gussasphalt-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{655B28BC-9793-4637-AE6F-9BE8C44BCC07}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gussasphalt-Belag -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5553AFB1-A9FF-4348-94A2-45B45E0A1E0E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Gussasphaltbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5553AFB1-A9FF-4348-94A2-45B45E0A1E0E}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gussasphaltbelag -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C114AC3-8DE9-47A1-99C0-010A1ECE33F9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- HMT -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C114AC3-8DE9-47A1-99C0-010A1ECE33F9}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- HMT -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF4EC6A2-318A-47E4-B131-88D86A0ACC30}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hochvakuumbitumen -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CD4785A-12C4-4D56-BA0E-4E9541897A13}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Recycelter Asphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50981DAD-7BFA-4BCC-8AB8-0D998DA8AE04}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschicht -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A534CC07-DB30-4540-82F2-5678E538533C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschicht AC T H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A534CC07-DB30-4540-82F2-5678E538533C}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschicht AC T H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{111D9C91-5942-41A2-B514-A9D039044281}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschicht AC T L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{111D9C91-5942-41A2-B514-A9D039044281}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschicht AC T L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D620BD-37A9-463E-BF48-112F7F4104B9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschicht AC T S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D620BD-37A9-463E-BF48-112F7F4104B9}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschicht AC T S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F66501D8-2AF2-42FD-A3D2-6426EA1A8D76}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschichten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F66501D8-2AF2-42FD-A3D2-6426EA1A8D76}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschichten -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C8ACCAE-F538-4ECF-83CE-147B7AFD9C0E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschichten AC T H -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C8ACCAE-F538-4ECF-83CE-147B7AFD9C0E}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschichten AC T H -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD756A1E-39C8-4641-B283-822028A1E807}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschichten AC T L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD756A1E-39C8-4641-B283-822028A1E807}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschichten AC T L -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A28BC8A2-52DD-4CC5-BC14-0F23D19E1DB0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Tragschichten AC T S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A28BC8A2-52DD-4CC5-BC14-0F23D19E1DB0}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragschichten AC T S -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3DEE73D-164D-4AED-8C8C-544C6FC0B08B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Umgebung - Asphalt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3DEE73D-164D-4AED-8C8C-544C6FC0B08B}', 'HY-{35573244-6585-43EA-B5B4-27BEE8D1F3C1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung - Asphalt -> Asphalt
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{00E2B1B3-81AF-4D81-AE73-8712994B75AE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Stelzlager -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{00E2B1B3-81AF-4D81-AE73-8712994B75AE}', 'HY-{3CAF35C4-06A9-49C8-B116-334D352F6616}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stelzlager -> Auflager
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80A88E58-7541-48FE-90CB-2FD040D516C2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD EPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80A88E58-7541-48FE-90CB-2FD040D516C2}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD EPS -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35A9F886-9B96-4FFF-91B6-2C26104B6551}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD Mineralfaser -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35A9F886-9B96-4FFF-91B6-2C26104B6551}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD Mineralfaser -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D020610E-BEE1-43AD-B9B1-B75197633382}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD Mineralfaserplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D020610E-BEE1-43AD-B9B1-B75197633382}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD Mineralfaserplatte -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5A6C884-1FA7-4668-85C4-65622942E264}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD Mineralfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E5A6C884-1FA7-4668-85C4-65622942E264}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD Mineralfaserplatten -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{69032C3F-134D-4B1E-8B84-27819EEC0A9A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD Mineralwollplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{69032C3F-134D-4B1E-8B84-27819EEC0A9A}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD Mineralwollplatte -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{320464DE-97CE-414C-9576-8EB44C7FD6AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD Mineralwollplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{320464DE-97CE-414C-9576-8EB44C7FD6AF}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD Mineralwollplatten -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A6B0DAA-1A45-445B-8509-25798C91978E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD PIR -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A6B0DAA-1A45-445B-8509-25798C91978E}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD PIR -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0B11D1D-9657-4414-B92A-82BE0B050B9E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD PUR -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0B11D1D-9657-4414-B92A-82BE0B050B9E}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD PUR -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4432B74C-2161-4553-AA59-2F80192CB8B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- AD XPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4432B74C-2161-4553-AA59-2F80192CB8B6}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- AD XPS -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C890C61-09E1-4F47-BE42-BBB2C887CC7F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Aussendämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C890C61-09E1-4F47-BE42-BBB2C887CC7F}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussendämmplatte -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31A8982B-F401-4340-AA2E-98ECE2AF4CCC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Aussendämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31A8982B-F401-4340-AA2E-98ECE2AF4CCC}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussendämmplatten -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9583EF44-F77E-45CC-A786-2DB3DA374F65}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Aussendämmung / 760 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9583EF44-F77E-45CC-A786-2DB3DA374F65}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussendämmung / 760 -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA5A97-5BE3-44AE-845D-CF1CA195EFE1}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussenisolation -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D529C3DF-FA1F-4D21-B1BA-6124CA41CB5B}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Aussen -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87FD9BED-2364-4B99-A9E1-B87981CDB8DC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Dämmung aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87FD9BED-2364-4B99-A9E1-B87981CDB8DC}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung aussen -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AAF09655-C738-45F4-B4C2-8FB042961455}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Aussen hart -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0DCF8C9A-4891-4973-A97E-A851E721A561}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Aussen weich -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61220357-111E-4D88-B413-5A81F26A26B9}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Aussen -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AC08B75-94EA-4697-96A5-42C6F6BDF804}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Dämmung-aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AC08B75-94EA-4697-96A5-42C6F6BDF804}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-aussen -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05B1342C-C8A6-4EA6-A524-B37C95BAF9E8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Dämmung, Aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{05B1342C-C8A6-4EA6-A524-B37C95BAF9E8}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Aussen -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3483AEBF-B1F8-422A-8E88-5DADAC925789}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Expandierte Korkdämmplatte -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C39864D-2892-4A9E-BE3E-95398FD26156}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyisocyanurat-Dämmung -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D61A0399-9BAE-4A90-B70A-FC3EB8AFDD3C}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyurethan-Dämmung -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1989DCC-8BBD-4FFB-BAB2-A44BA751636C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Verputzte Aussendämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1989DCC-8BBD-4FFB-BAB2-A44BA751636C}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputzte Aussendämmung -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74213C7E-2F47-406B-B4B4-09769868CE4A}', 'HY-{49DF1E9A-AF2C-470A-A192-DBAD7A966970}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- WDVS -> Aussendämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B7DAA06-5201-4EC8-B9EE-5EDE0C6D0375}', 'HY-{CC91BEF7-F97A-4D27-8C47-E52141D0E3E6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussenputz hinterlüftet -> Aussenputz-hinterlüftet
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D57AEFE-A5C9-4B23-AF72-98F185D75102}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Backstein, Sichtmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D57AEFE-A5C9-4B23-AF72-98F185D75102}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein, Sichtmauerwerk -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1B4F59B3-EE64-420D-BECA-4AE977100EA9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Backstein, Sichtmauerwerk / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1B4F59B3-EE64-420D-BECA-4AE977100EA9}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein, Sichtmauerwerk / 700 -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2E3769-7402-478E-B96F-FB587C0CAB3A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- I + L Stein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2E3769-7402-478E-B96F-FB587C0CAB3A}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- I + L Stein -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{641F80DA-11D4-4DFD-BFBD-16B9D3F987F7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- I+L-Sichtbackstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{641F80DA-11D4-4DFD-BFBD-16B9D3F987F7}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- I+L-Sichtbackstein -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC817390-C7F8-45A3-A835-1655A9061DE9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- I+L-Stein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC817390-C7F8-45A3-A835-1655A9061DE9}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- I+L-Stein -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F6C8463-63FC-430D-BCC1-69ADDD670176}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Kelesto -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F6C8463-63FC-430D-BCC1-69ADDD670176}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kelesto -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A4D9F0C-EFEF-4138-8EF9-1BA86273477E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- MB Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A4D9F0C-EFEF-4138-8EF9-1BA86273477E}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MB Sicht -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63876025-0C7D-4B0A-90A8-C8F5061DBDA1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- MW, Backstein, Sichtmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63876025-0C7D-4B0A-90A8-C8F5061DBDA1}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MW, Backstein, Sichtmauerwerk -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5088E5F2-3E3D-4D64-B1F6-26FA45554916}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Sicht MB -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5088E5F2-3E3D-4D64-B1F6-26FA45554916}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sicht MB -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F94BDD00-67CF-48D5-B253-DEE3AC5B2A11}', 'HY-{78F94678-F679-4125-BED3-786B9747367D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbackstein -> Backstein-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACE31795-E491-4D34-8921-31B0A7DB5A60}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Allgemein, Bekleidung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACE31795-E491-4D34-8921-31B0A7DB5A60}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Bekleidung -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7929F923-53D3-4815-818D-E159C87C1E66}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:10'); -- Allgemein, Bekleidung Aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7929F923-53D3-4815-818D-E159C87C1E66}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Bekleidung Aussen -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6282B63-6ADB-4783-98A3-9FE17E531106}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Außenbekleidung -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{043DAEF4-8741-480E-BBA0-968BAC87A09F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Bekleidung, Aussenwand / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{043DAEF4-8741-480E-BBA0-968BAC87A09F}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Aussenwand / 400 -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F425A564-1006-41D2-AA52-B91EF8079E72}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Bekleidung, Aussenwand / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F425A564-1006-41D2-AA52-B91EF8079E72}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Aussenwand / 650 -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD128B94-ECEC-4AEA-9C2A-98924E7DF8DF}', 'HY-{4661E85F-9055-48B0-9D57-59B9CC9B3BA2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verkleidung -> Bekleidung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{426C148E-9FD2-4C82-8158-446722ABA8AE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Allgemein, Bekleidung Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{426C148E-9FD2-4C82-8158-446722ABA8AE}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Bekleidung Innen -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F01041D-C288-42F6-80B0-EE19D10B4B77}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Bekleidung, Decke oben / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F01041D-C288-42F6-80B0-EE19D10B4B77}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Decke oben / 300 -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D02FAA4-47D4-4788-A38E-6D4D6EBA626F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Bekleidung, Decke unten / 330 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D02FAA4-47D4-4788-A38E-6D4D6EBA626F}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Decke unten / 330 -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CE60949-FF81-4246-B8AC-B84A71438938}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Bekleidung, Innenwand / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CE60949-FF81-4246-B8AC-B84A71438938}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Innenwand / 320 -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF166FAA-7BD9-441D-9CBC-890E7B7C7FA5}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innenbekleidung -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB21A9CD-14D9-47E2-99FC-780BB7B57473}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lehmbauplatte -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F7A8ACF-1C44-46C8-B2CF-60E5BD79C51A}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schilfrohr -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03170400-4CA2-4C56-9A7F-A785CA60CA11}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Schilfrohrdecke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03170400-4CA2-4C56-9A7F-A785CA60CA11}', 'HY-{B90F6FC7-8355-4F73-AE28-6CD7E00DEAEA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schilfrohrdecke -> Bekleidung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAA3F05-2D98-45B9-AA43-D4DD49A8F47B}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bepflanzung -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{120744C8-E03A-4493-BBF4-F5A52157EDB3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Erdbereich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{120744C8-E03A-4493-BBF4-F5A52157EDB3}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Erdbereich -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91EE1E10-8636-4324-B5D9-CF04B40FFA90}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Erdbereich / 100 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91EE1E10-8636-4324-B5D9-CF04B40FFA90}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Erdbereich / 100 -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94A5BEF2-25CD-4473-882C-58B53A7125E9}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Erde -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1ED221D-E26C-4FC3-8200-A1441FEE3A70}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Erdreich -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFC12419-385C-45FF-9E19-A95E954C6E2C}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Erdschicht -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{491D74AD-1139-41DB-8F37-D1B7D77B8F87}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Humus -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B3D72F8-CA5C-4350-BCAA-972C10BFBAD6}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pflanzen -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E53C0A15-8041-469E-A871-48BA331F45BF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Umgebung - Erde -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E53C0A15-8041-469E-A871-48BA331F45BF}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung - Erde -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3001C337-71A9-46C7-80E1-B8120C67376B}', 'HY-{DE1D01A0-0C74-4B5C-B60C-4185A4F9F9F6}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vegetationsschicht -> Bepflanzungsfläche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A5B4D6B-B8EF-4E5F-B743-AA9F4E0289D3}', 'HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Außenbeplankung -> Beplankung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E4DA0D5-7F5B-4F07-B40C-622D488AD094}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beplankung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E4DA0D5-7F5B-4F07-B40C-622D488AD094}', 'HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung -> Beplankung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF877A9C-D56B-462A-8839-686A996F88C8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beplankung, Aussenwand / 520 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF877A9C-D56B-462A-8839-686A996F88C8}', 'HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung, Aussenwand / 520 -> Beplankung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7FD3A3CD-6A15-40AD-B618-5255CDCFF2E6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beplankung, Aussenwand / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7FD3A3CD-6A15-40AD-B618-5255CDCFF2E6}', 'HY-{87087625-66D0-44CE-A3F4-7D6C81F8F315}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung, Aussenwand / 650 -> Beplankung-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0888A360-C29A-4373-828E-DC32831A3CBD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beplankung, Innenwand / 500 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0888A360-C29A-4373-828E-DC32831A3CBD}', 'HY-{F21B7DDA-3432-4A5A-BEDA-920AECB986BB}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beplankung, Innenwand / 500 -> Beplankung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E835B1C-0054-4A06-8B42-D99C3667C791}', 'HY-{F21B7DDA-3432-4A5A-BEDA-920AECB986BB}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innenbeplankung -> Beplankung-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C09AF3A0-23AB-49D3-977A-9F8385F920E7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- beton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C09AF3A0-23AB-49D3-977A-9F8385F920E7}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- beton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25512A20-A9D6-4B48-966E-9C044245B7A4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton - Ortbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25512A20-A9D6-4B48-966E-9C044245B7A4}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton - Ortbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96684CBE-84F0-4F79-8553-08754A35B7BE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton - unbewehrt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96684CBE-84F0-4F79-8553-08754A35B7BE}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton - unbewehrt -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{72B7C6B9-163B-43D6-A0A5-C3E2A1735C94}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C100/115 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E75B4BB8-BDBF-4F41-B6AC-F0D07D05C690}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C12/15 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0D6BB45-AC9A-45A8-9187-A09DEE2C61BC}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C16/20 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC18A93C-A165-4DD5-97F6-6C905773DB8B}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C20/25 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7905A39F-DE8B-42C7-9513-719D2F56BE61}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C25/30 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51DEE2CD-3282-4250-B2EA-12E7B9E5F71F}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C30/37 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB24ED80-E7E0-4605-B355-94BBA69A0D80}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C35/45 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0E3E86EC-B23F-4FDE-BA36-440AE9E10A9D}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C40/50 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4844FF4D-17D2-4FB6-8195-784EF9AAE1B6}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C45/55 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AE4552F-F747-43A0-B9DB-0D8B8C5F08DF}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C50/60 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CCA8C06E-4DC1-4AD3-8748-5EBF0F19E527}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C55/67 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A3D6102-7A38-4C3E-B3E4-19F2C234F2B0}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C60/75 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B29E6C2-F65B-48C6-8EE3-946FBE59EE92}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C70/85 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A73400C2-DB7B-4542-8D3E-8AC7312B3755}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C8/10 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42D71C90-E15D-49D1-AADA-FFBF5F42FE16}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C80/95 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7112CEB4-C1BC-4799-A545-4F93ED55F96C}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton C90/105 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4D382E1-049E-436C-A155-23BC18CD3061}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton Ortbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF87E3CC-CBF8-4EE4-8456-FB1C8B7E0311}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton SB1 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7635C017-F07E-4538-B8ED-152F15A6B694}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton SB2 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADBCE8EA-5130-425B-B0BC-093B7693BDF8}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton SB3 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8A643AC-55E6-4D25-B258-49E8DF4E0B3A}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton SB4 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04B5CA9B-70CB-4AF2-8178-C543C797D573}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton Sichtbeton, hellgrau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04B5CA9B-70CB-4AF2-8178-C543C797D573}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton Sichtbeton, hellgrau -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E3A42A9-2EF1-4F64-B064-CC8FB4759411}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton_LB_WD -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44D2FDB-4C49-4A06-B584-82A42D66789C}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton_STB -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEA330B3-DFBA-4CF7-9F57-2564A749C5A9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, bewehrt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEA330B3-DFBA-4CF7-9F57-2564A749C5A9}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, bewehrt -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2714EED5-A9FA-4568-ACD7-804820114566}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, Bodenplatte / 780 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2714EED5-A9FA-4568-ACD7-804820114566}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Bodenplatte / 780 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27ED91D2-3858-4318-8FD1-23FAA65458E4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, Erdbebenscheibe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27ED91D2-3858-4318-8FD1-23FAA65458E4}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Erdbebenscheibe -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CDABDA5-DC41-4EBC-82EB-59DA88A49DFF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, Erdbebenscheibe / 795 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CDABDA5-DC41-4EBC-82EB-59DA88A49DFF}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Erdbebenscheibe / 795 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2489F0-207F-4AE9-921A-DA5E435E4C24}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, Stahlbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2489F0-207F-4AE9-921A-DA5E435E4C24}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Stahlbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D51F881-557C-40E4-BECC-B6ADFD2A965C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, Stahlbeton / 750 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D51F881-557C-40E4-BECC-B6ADFD2A965C}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Stahlbeton / 750 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDF83941-2C6D-4CED-AF3B-C7C6FEBCF461}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, unbewehrt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDF83941-2C6D-4CED-AF3B-C7C6FEBCF461}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, unbewehrt -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A135002-3986-495B-B74F-1FEA7E963E04}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton, unbewehrt / 730 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A135002-3986-495B-B74F-1FEA7E963E04}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, unbewehrt / 730 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE540EAA-97D3-4E0B-A0CC-A6C8948F0A66}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- CH_Beton verputzt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE540EAA-97D3-4E0B-A0CC-A6C8948F0A66}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Beton verputzt -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDED4253-824B-4E21-8D7E-D1BB81C7969F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- CH_Erdbebenscheibe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDED4253-824B-4E21-8D7E-D1BB81C7969F}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Erdbebenscheibe -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D14278FB-B879-4D4A-8C9F-721CDBD57C82}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Eisenbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D14278FB-B879-4D4A-8C9F-721CDBD57C82}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eisenbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C369DA26-6ED4-4C90-A3C6-7B0ADF9DB351}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigteilbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{664C17E3-FAD5-4F3E-802A-607CCAA93EE2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- LB1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{664C17E3-FAD5-4F3E-802A-607CCAA93EE2}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- LB1 -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF89323E-B0D9-47F2-94EE-8074EC19C131}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34DA8D95-362F-4BFC-8D67-2C3B14F65700}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK A -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34DA8D95-362F-4BFC-8D67-2C3B14F65700}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK A -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB22FB4-EA56-490B-8182-E5EC61D484B4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK B -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB22FB4-EA56-490B-8182-E5EC61D484B4}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK B -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{939FD42A-01D2-4CB3-A905-2F609F04A6DE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK C -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{939FD42A-01D2-4CB3-A905-2F609F04A6DE}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK C -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECFD050E-5342-4775-96DC-AE534E068416}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK D -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECFD050E-5342-4775-96DC-AE534E068416}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK D -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD9F3528-6023-4E91-A2EC-7806EDA3F102}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK E -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD9F3528-6023-4E91-A2EC-7806EDA3F102}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK E -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FBC26BF-C723-461D-AA84-EAEEE0565815}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK F -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FBC26BF-C723-461D-AA84-EAEEE0565815}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK F -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F286E636-E65E-44BA-9B2E-2D118EC7D1AC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- NPK G -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F286E636-E65E-44BA-9B2E-2D118EC7D1AC}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- NPK G -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C6AA5CD-7CD3-46EF-ADEC-D85A1D86A884}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ortbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B2CAD27-6544-4F3B-BB8F-993C2F2FEEF9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Recycling-Beton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B2CAD27-6544-4F3B-BB8F-993C2F2FEEF9}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Recycling-Beton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEDE3AC6-EF25-427A-B0B2-A953BD5DCE39}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Recyclingbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96DC5B54-9BE1-4D83-864B-B2123638C7ED}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26F279CB-FF4D-4A49-9BA2-82CF131430E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- stahlbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26F279CB-FF4D-4A49-9BA2-82CF131430E1}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- stahlbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22065D8-9875-4200-BD06-807027BB1FFB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Stahlbeton - Ortbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22065D8-9875-4200-BD06-807027BB1FFB}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlbeton - Ortbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E962EA34-CA7C-424D-88DE-95D58448132C}', 'HY-{9D02952B-EAAF-4D68-BDC9-36E0A75982DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Waschbeton -> Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B433578-9E1A-4EB8-A205-E1DFF2257147}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:11'); -- Beton Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B433578-9E1A-4EB8-A205-E1DFF2257147}', 'HY-{DD048929-D856-4824-8501-62637F813393}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton Boden -> Betonboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C82E8085-1A98-460E-A0C8-AAE45B8337C7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Beton-Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C82E8085-1A98-460E-A0C8-AAE45B8337C7}', 'HY-{DD048929-D856-4824-8501-62637F813393}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Boden -> Betonboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31536532-D74B-424C-B23B-DC285FB99D77}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Beton, Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31536532-D74B-424C-B23B-DC285FB99D77}', 'HY-{DD048929-D856-4824-8501-62637F813393}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Boden -> Betonboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06C38178-21DD-49DD-8065-8106AF3DE130}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Kellerboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06C38178-21DD-49DD-8065-8106AF3DE130}', 'HY-{DD048929-D856-4824-8501-62637F813393}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kellerboden -> Betonboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E460374-53FF-447C-B61D-53FEFF243104}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Besenstrich -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA270471-9DCA-4C3C-909B-62545D6E094E}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Homogen Beton -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{43291F2D-C538-42EF-BFF3-B6CF08825EA8}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Homogenbeton -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5ECD45BD-9224-4887-95CF-8C563ADC74AD}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Monobeton -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65BE6FF0-BDCA-4C59-A5D6-016405EB7DFC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Vacuumbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65BE6FF0-BDCA-4C59-A5D6-016405EB7DFC}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vacuumbeton -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{297956B8-263E-452D-8104-B9DD399A5CC3}', 'HY-{3FBD6398-803D-4FE2-8C4F-E2C8E55B4F86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vakuumbeton -> Betonoberflächenbehandlung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAF76D13-435B-4201-A502-9260E1765450}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton_HBL -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{442A56BC-F7F0-49BB-A2A4-20506CC0295A}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonhohlblockstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BD95407-46FE-461B-B47B-6ABDFB0E65AD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Betonhohlstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BD95407-46FE-461B-B47B-6ABDFB0E65AD}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonhohlstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA85F24D-5CC1-48A7-BF69-B3AB0F30971E}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonmantelstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA218E55-967B-4915-9DC0-8179A355AA70}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonschalstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAC05403-DD8C-4F82-B45E-D6DFED9F11C6}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonvollstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B504045-621B-45AB-8C31-F7577A1CEC1B}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbetonhohlblockstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C85DA4DA-6FF0-4A2B-B76F-A07BD3A0FC5F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Schalungs-Betonstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C85DA4DA-6FF0-4A2B-B76F-A07BD3A0FC5F}', 'HY-{E89E719C-E3D1-4D64-A4F3-CB509C4286DF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalungs-Betonstein -> Betonstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7160EC4-DF42-42D6-AA37-8D953E8386AD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Alublech -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7160EC4-DF42-42D6-AA37-8D953E8386AD}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alublech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6BE7175C-2FD3-4C64-A3F0-9902666338FA}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aluminiumblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F49F6B49-C534-47DC-98A2-187FF0F4A76F}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Blechverkleidung -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6BEDD69-7D88-41BD-A575-A3B737CA2509}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Chromnickelstahlblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AF082B1-EA21-4E72-97D4-FE14099F1906}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Chromstahlblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E1F01C0-6FA1-4660-8A2A-A7EC37EF3BD5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Dach - Blechdeckung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E1F01C0-6FA1-4660-8A2A-A7EC37EF3BD5}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Blechdeckung -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6B2907C-4954-47CB-A74F-E8CE644DF5B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Dach - Titanzink -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6B2907C-4954-47CB-A74F-E8CE644DF5B6}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Titanzink -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4E9E5DD-7777-45BC-BC88-901DE1140E1E}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kupfer -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F910534-B4FB-40F7-B609-DC34AE9F6292}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kupferblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7A7DF47-8D93-418B-9092-B08B54CD6E96}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metall - Kupfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7A7DF47-8D93-418B-9092-B08B54CD6E96}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Kupfer -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{325F877E-F536-4749-9824-F932D296DDC8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metall - Paneel, Kupfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{325F877E-F536-4749-9824-F932D296DDC8}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Paneel, Kupfer -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE496009-EB7A-46CC-9A2E-6FB5490DCB8B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metall - Trapezblech -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE496009-EB7A-46CC-9A2E-6FB5490DCB8B}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Trapezblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{116D11C0-C669-43C4-81F3-F5036F6C72E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metall Kupfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{116D11C0-C669-43C4-81F3-F5036F6C72E1}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall Kupfer -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE4CDFDC-8AC2-4565-8030-E0310D98F2C7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metall TitanZink -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE4CDFDC-8AC2-4565-8030-E0310D98F2C7}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall TitanZink -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{13D9DE86-A75E-493F-9858-08D28262B75B}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallverkleidung -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{429DA01E-9986-45BA-9398-6E17FFE2F731}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Metallverkleidung / 940 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{429DA01E-9986-45BA-9398-6E17FFE2F731}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallverkleidung / 940 -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14B38291-E4A4-4CD6-A119-67E59232CD40}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profilblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4257630E-4A37-43D0-8F85-AC82D371D426}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4AD0C31-E704-4975-8765-E32739EF4A9D}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Titanzink -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F19974C8-16F2-4E20-BA8E-2D0145C03D9E}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Titanzinkblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F68084C5-38EC-4619-8DF5-2C917A28DF83}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trapezblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FEBF62AF-F328-4A1D-A878-A897034E977A}', 'HY-{65FCB677-73B0-45F2-B733-EFA2E2E1937B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zinkblech -> Blech
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E63FEA7-D608-4259-9F6E-042A364CB047}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Blindboden / 420 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E63FEA7-D608-4259-9F6E-042A364CB047}', 'HY-{20A160E8-D19B-487C-A3FC-6B0193030F74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Blindboden / 420 -> Blindboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEE0A9A2-9DCB-44A0-A083-8A2E7AC5652D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Belag, Bodenbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEE0A9A2-9DCB-44A0-A083-8A2E7AC5652D}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Belag, Bodenbelag -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E2EB729C-2407-48BC-89A0-F84F6245EAA7}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenbelag -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DEA0182-5EBF-43AF-BB50-4806873F94B7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Bodenbelag / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DEA0182-5EBF-43AF-BB50-4806873F94B7}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenbelag / 140 -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1EB1AF79-9945-41A0-A39C-EBBD8B0B5D33}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Bodenbelag / 200 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1EB1AF79-9945-41A0-A39C-EBBD8B0B5D33}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenbelag / 200 -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56EA6A9D-388F-4F16-A172-45EE3958460F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Bodenbelag / 405 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56EA6A9D-388F-4F16-A172-45EE3958460F}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenbelag / 405 -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBF33FB9-C70D-4082-8C7A-AA493B53AFF9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- G2 Bodenbelag / 200 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBF33FB9-C70D-4082-8C7A-AA493B53AFF9}', 'HY-{62321F9A-A08A-4AB0-9B57-B23415E94833}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- G2 Bodenbelag / 200 -> Bodenbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F07E9525-3ECF-4855-B306-9D80703A01F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Bretterstapeln -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F07E9525-3ECF-4855-B306-9D80703A01F0}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bretterstapeln -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{69BF17B0-992A-4EEE-9884-A99358695491}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstapel-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{69BF17B0-992A-4EEE-9884-A99358695491}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstapel-Element -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA039E61-8BF8-4CBD-8070-FC8402A2A4D7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstapel-Wand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA039E61-8BF8-4CBD-8070-FC8402A2A4D7}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstapel-Wand -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{603CC39B-5F83-4205-BDEE-1FB5B0F58B0E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstapel-Wandelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{603CC39B-5F83-4205-BDEE-1FB5B0F58B0E}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstapel-Wandelement -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{783CCD83-C913-45FE-911F-8278802555A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstapelelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{783CCD83-C913-45FE-911F-8278802555A8}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstapelelement -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C57FC432-C029-4656-8FF7-4A6EE9797571}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstapeln -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C57FC432-C029-4656-8FF7-4A6EE9797571}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstapeln -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4754FA40-A345-4C46-ABDC-4888328E92F1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettstappeldecke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4754FA40-A345-4C46-ABDC-4888328E92F1}', 'HY-{03B6154A-2CDC-4256-9445-FC230FDCCC64}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettstappeldecke -> Bretterstapel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F50131A0-97A2-472A-917B-659C84E9168C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettschichtholz / 750 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F50131A0-97A2-472A-917B-659C84E9168C}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtholz / 750 -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B905648-7F51-4B6F-A1A4-E30EC5040A62}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettschichtholz / 810 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B905648-7F51-4B6F-A1A4-E30EC5040A62}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtholz / 810 -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC18F38F-9966-43A3-80FE-4DA04D00DA57}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettschichtholz2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC18F38F-9966-43A3-80FE-4DA04D00DA57}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtholz2 -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA256F14-0866-466F-8228-E252D03E392F}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtträger -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{715F9799-A082-4D5F-A52F-CA85BDD9C6DB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- BSH -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{715F9799-A082-4D5F-A52F-CA85BDD9C6DB}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- BSH -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B889CED-23D5-4EFC-B426-399995C6C65F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Holz verleimt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B889CED-23D5-4EFC-B426-399995C6C65F}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz verleimt -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B6DC91B1-EB09-472E-8C60-452C30D554E6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Massivholz verleimt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B6DC91B1-EB09-472E-8C60-452C30D554E6}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivholz verleimt -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C888FC5A-8D78-4668-B26A-ED578B798D72}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Profil-Holz-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C888FC5A-8D78-4668-B26A-ED578B798D72}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profil-Holz-Element -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A12CFDFF-5285-457D-9551-F0014E8181BD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Profilholz-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A12CFDFF-5285-457D-9551-F0014E8181BD}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profilholz-Element -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D329FFB5-267C-4190-BBAC-0F948723A5E0}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profilholzelement -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99EAA439-5781-41A8-AC9B-70BC5DEAB0AE}', 'HY-{3EAE9F54-7E46-49A5-9A42-CB88672B58AF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollholzwerkstoff -> Brettschichtholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A611DAD1-6EF3-4EF7-AAA9-7A0941519333}', 'HY-{67EBF2B3-E9E1-47C4-BC13-FEDA9AF6BBF5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtsperrholz -> Brettsperrholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D85D5B87-B70B-4011-9EF0-F30D7EB69D86}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettschichtsperrholz2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D85D5B87-B70B-4011-9EF0-F30D7EB69D86}', 'HY-{67EBF2B3-E9E1-47C4-BC13-FEDA9AF6BBF5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettschichtsperrholz2 -> Brettsperrholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{266D303B-760B-49AA-8905-47926869B1F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Brettsperrholz-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{266D303B-760B-49AA-8905-47926869B1F0}', 'HY-{67EBF2B3-E9E1-47C4-BC13-FEDA9AF6BBF5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brettsperrholz-Element -> Brettsperrholz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46926B70-61C7-4A0E-8760-4AD3317D5C52}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Dachbegrünung / 100 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46926B70-61C7-4A0E-8760-4AD3317D5C52}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbegrünung / 100 -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{144468C2-C9E3-4485-A510-A86BDBAB1E60}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Ext Begrünung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{144468C2-C9E3-4485-A510-A86BDBAB1E60}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ext Begrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A5650B8-21DA-4969-99F2-F9D4638FEF51}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Extensivbegrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEF1F0B6-8782-4D77-95EB-24591CA3AD34}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- Extensive Begrünung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEF1F0B6-8782-4D77-95EB-24591CA3AD34}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Extensive Begrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D13F4B9-00AC-4A68-B591-6E9F45F11570}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- extensive Begrünung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D13F4B9-00AC-4A68-B591-6E9F45F11570}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- extensive Begrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{431CADBB-4406-4189-89E9-E3A1DBEBD9B8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:12'); -- extensive Dachbegrünung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{431CADBB-4406-4189-89E9-E3A1DBEBD9B8}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- extensive Dachbegrünung -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCA4D010-58E4-40D6-88FA-BEFFA4DBB56B}', 'HY-{A375357B-A54E-4E9F-A5C9-8178CACBE299}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Substrat -> Dachbegrünung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6032F2EF-CFEE-4A74-BCE8-D50296D080B7}', 'HY-{299FFDF9-7F1C-4DF9-8F13-1DE96FED55E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbekleidung -> Dachbekleidung-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8684EC4-F543-43D6-B1D0-29EDE35C91ED}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dachbekleidung / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8684EC4-F543-43D6-B1D0-29EDE35C91ED}', 'HY-{299FFDF9-7F1C-4DF9-8F13-1DE96FED55E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbekleidung / 970 -> Dachbekleidung-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C332A67-84A0-4577-9D2F-B27B0AE6D93E}', 'HY-{299FFDF9-7F1C-4DF9-8F13-1DE96FED55E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachdeckung -> Dachbekleidung-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EA2C98C-359A-4CAE-9462-04E2367B5717}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Velux -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EA2C98C-359A-4CAE-9462-04E2367B5717}', 'HY-{B1E8FCF3-C72F-4101-BDE3-AE89548C2DA3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Velux -> Dachflächenfenster
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7CC9452-4E75-4F99-9959-97CB520FD96E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- velux -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7CC9452-4E75-4F99-9959-97CB520FD96E}', 'HY-{B1E8FCF3-C72F-4101-BDE3-AE89548C2DA3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- velux -> Dachflächenfenster
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201FE7BC-320F-4B82-AC00-F7D8B315C7B6}', 'HY-{5BBDFA3D-43A6-4816-80A9-CD97F09DD0D0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachuntersicht Außen -> Dachuntersicht-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ADA293B-5021-4CFE-95FC-C83DFF8B60A1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Beton-Flachziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ADA293B-5021-4CFE-95FC-C83DFF8B60A1}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Flachziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5136CB-AE15-4FCF-846E-F463DD53E6BC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Beton-Pfannenziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E5136CB-AE15-4FCF-846E-F463DD53E6BC}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Pfannenziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9FEDF3A-F477-4A40-B42B-BEB8F82824D3}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCD2B981-33A6-402F-A469-9BCEFFAAF4F7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dach - Ziegeldeckung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCD2B981-33A6-402F-A469-9BCEFFAAF4F7}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Ziegeldeckung -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB72DC65-B695-426A-919E-0DDC4A0F5DFB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dachziegel / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB72DC65-B695-426A-919E-0DDC4A0F5DFB}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachziegel / 970 -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E93F63A3-B2D4-42E0-AD6B-96112B44CF49}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Falzziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C045DFE-3891-418C-956E-3A5194E459A4}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB0B2C0-780F-484C-80CC-79F873965516}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klosterziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{803BCB4F-86A2-489E-AF7A-1EFF535F7A1C}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfannenziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{144FBF47-CEC6-4CCB-8927-176118F32C47}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Ton-Biberschwanzziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{144FBF47-CEC6-4CCB-8927-176118F32C47}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ton-Biberschwanzziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0600DE71-A806-47F8-9A73-108678ABEBD0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Ton-Falzziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0600DE71-A806-47F8-9A73-108678ABEBD0}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ton-Falzziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B01581C3-D661-4A81-B9DB-78DC447F59A7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Ton-Klosterziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B01581C3-D661-4A81-B9DB-78DC447F59A7}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ton-Klosterziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{821F432E-46C0-4695-AE42-140672592963}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Ton-Pfannenziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{821F432E-46C0-4695-AE42-140672592963}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ton-Pfannenziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CB7D687-C625-4FCC-91D6-8358318103F4}', 'HY-{CC81F4D2-7DAE-444C-964A-604283DDA3E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tonziegel -> Dachziegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{331C800A-4B4C-42AD-91E1-C1B1F7DEDE11}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Wärmedämmputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{331C800A-4B4C-42AD-91E1-C1B1F7DEDE11}', 'HY-{0A902A49-65FD-44F7-A8C7-EDCE75208AC4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmputz -> Dämmputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91FC6476-4F5A-417D-9FEC-75A2003AED64}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- CH_Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91FC6476-4F5A-417D-9FEC-75A2003AED64}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Dämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD33F420-1BBA-4014-B7C8-BC5C7722F725}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- CH_Wärmedämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD33F420-1BBA-4014-B7C8-BC5C7722F725}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Wärmedämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6892A4DA-A181-418F-9324-D67A1F9EC2D0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmflocken -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6892A4DA-A181-418F-9324-D67A1F9EC2D0}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmflocken -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EACB81B-37B1-4C03-952F-8530B601694C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmstoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EACB81B-37B1-4C03-952F-8530B601694C}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmstoff -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD04E4FE-27C1-46D5-9C80-F289BB7C031A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD04E4FE-27C1-46D5-9C80-F289BB7C031A}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D52B538A-B0C2-495A-A100-57D28D357CB5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmung hart -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D52B538A-B0C2-495A-A100-57D28D357CB5}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung hart -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63E97C0-7F14-48E0-AB10-998638C713C2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmung weich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63E97C0-7F14-48E0-AB10-998638C713C2}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung weich -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CC0AC3B-4E96-49A8-B7B7-1221773C79B0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmung, hart -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CC0AC3B-4E96-49A8-B7B7-1221773C79B0}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, hart -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA03F0-CA63-4C86-AEA5-D618F7D64556}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Daemmung, weich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86DA03F0-CA63-4C86-AEA5-D618F7D64556}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, weich -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D63D069E-7309-4C02-A9BB-B0C6EA4109CD}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmflocken -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D40B3D2C-DED1-450F-9CD5-42FB34FCB988}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmstoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D40B3D2C-DED1-450F-9CD5-42FB34FCB988}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmstoff -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC272CFD-B021-4965-832F-EAD01DE60B0D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmstoff horizontal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC272CFD-B021-4965-832F-EAD01DE60B0D}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmstoff horizontal -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D712EBB8-ACAA-4633-84C8-CD9303D22E56}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmstoff vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D712EBB8-ACAA-4633-84C8-CD9303D22E56}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmstoff vertikal -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0D819BC-1B29-4E56-8170-27FE75B4EAE9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 08cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0D819BC-1B29-4E56-8170-27FE75B4EAE9}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 08cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6F1B3B6-3FB5-4466-B411-5A9549D4C5EF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 10cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6F1B3B6-3FB5-4466-B411-5A9549D4C5EF}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 10cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E98CB20A-864C-4FCB-A30C-100CC1FE8C7F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 12cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E98CB20A-864C-4FCB-A30C-100CC1FE8C7F}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 12cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C614F0-484E-4275-A476-5F0DF5BF1BC9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 14cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{60C614F0-484E-4275-A476-5F0DF5BF1BC9}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 14cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DB31DE0-2F48-41A3-9693-810D59BBCAA9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 16cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DB31DE0-2F48-41A3-9693-810D59BBCAA9}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 16cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1030D209-0665-4A4C-8A80-D09C3EEAEA33}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 18cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1030D209-0665-4A4C-8A80-D09C3EEAEA33}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 18cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB8549ED-3964-4F8F-AA65-E040A424ED27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung 20cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB8549ED-3964-4F8F-AA65-E040A424ED27}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung 20cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BD74C5-74F3-4684-AC8F-F1271A54352E}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung EPS -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{173100CB-D3DF-400A-8F96-B5D78BDA3CBA}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung hart -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D141FE01-8129-4B95-9131-DF270A60467C}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Linien -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A48314-9D19-40E5-BA80-DCFA3CC7B18F}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung weich -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC8836DD-53B7-4313-B46D-A67529A51B05}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 06cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC8836DD-53B7-4313-B46D-A67529A51B05}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 06cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D343E2-DC9B-474D-8C09-FF4E24F8DB9B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 08cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D343E2-DC9B-474D-8C09-FF4E24F8DB9B}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 08cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D30E7332-3469-4401-B242-3C3AD2F23A27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 10cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D30E7332-3469-4401-B242-3C3AD2F23A27}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 10cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{280E4DA3-A4D1-40BE-8AD5-30E1F2C7C34A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 12cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{280E4DA3-A4D1-40BE-8AD5-30E1F2C7C34A}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 12cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6530B73F-4773-415E-BB98-34D48513FBFC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 14cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6530B73F-4773-415E-BB98-34D48513FBFC}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 14cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11A33B81-0169-45B6-B2FB-F34197A730E2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 16cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11A33B81-0169-45B6-B2FB-F34197A730E2}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 16cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{452FF1A9-95DE-487F-94B8-23C0EF7CCBC6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 18cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{452FF1A9-95DE-487F-94B8-23C0EF7CCBC6}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 18cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C65FC843-E475-4D99-BF83-F9C409B4D0C5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_hart 20cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C65FC843-E475-4D99-BF83-F9C409B4D0C5}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_hart 20cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9334461-BB39-43DF-80EE-27DE3D1A1992}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 08cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9334461-BB39-43DF-80EE-27DE3D1A1992}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 08cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B9ADD7F-27C7-4711-B917-A9BF65DAE5C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 10cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B9ADD7F-27C7-4711-B917-A9BF65DAE5C6}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 10cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A2850BE-FA76-43FC-994C-140A0BF15CE3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 12cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A2850BE-FA76-43FC-994C-140A0BF15CE3}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 12cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E63FFC82-3F20-4D91-B113-68457FACE6EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 14cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E63FFC82-3F20-4D91-B113-68457FACE6EE}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 14cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DACA8BB6-3A26-4984-A902-65C5B3F663E8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 16cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DACA8BB6-3A26-4984-A902-65C5B3F663E8}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 16cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9065B507-CE11-4799-BE6C-8CE1EE60B36F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 18cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9065B507-CE11-4799-BE6C-8CE1EE60B36F}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 18cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA3B1C4B-5114-4FD3-AADC-4BF06757BDAF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung_weich 20cm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA3B1C4B-5114-4FD3-AADC-4BF06757BDAF}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_weich 20cm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47E0D279-6811-462B-AAF0-54F28522436D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, hart -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47E0D279-6811-462B-AAF0-54F28522436D}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, hart -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A39EACD1-51A0-4B4E-9F1C-D46980248BC6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, hart / 760 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A39EACD1-51A0-4B4E-9F1C-D46980248BC6}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, hart / 760 -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C520D72-A5C5-49B6-B5D0-101435816BC4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, hart EPS / 765 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C520D72-A5C5-49B6-B5D0-101435816BC4}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, hart EPS / 765 -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEEED4AA-0B75-4E37-ADCD-34B5056387A1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, Steildach -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CEEED4AA-0B75-4E37-ADCD-34B5056387A1}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Steildach -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DCA46C5-BCBF-447D-9AD8-8EF8D48BA545}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, weich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DCA46C5-BCBF-447D-9AD8-8EF8D48BA545}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, weich -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0065E743-168E-4A22-88E6-38926D8F392A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Dämmung, weich / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0065E743-168E-4A22-88E6-38926D8F392A}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, weich / 700 -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34701D7C-EE48-4EEC-AF69-441FF4D2BA2C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- EPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34701D7C-EE48-4EEC-AF69-441FF4D2BA2C}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- EPS -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5743CD-AFF5-4D3D-8A2F-A83683A17141}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:13'); -- Expandierte Polystyroplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5743CD-AFF5-4D3D-8A2F-A83683A17141}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Expandierte Polystyroplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3D1300C-BDC1-4EE6-B16D-BC38715B84C5}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glaswolle -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B46160CC-651B-4F36-9B9E-654617B9707B}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hanf -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{072B0962-355D-46DA-9921-DDD9904E3AFC}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Isolation -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7AA7422-3629-466B-9325-8CC81FF426B1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Korkdämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7AA7422-3629-466B-9325-8CC81FF426B1}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkdämmplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80028D4B-9D90-4E3A-96F8-C1A6825D21A4}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkdämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2555C259-BA6B-41DA-9183-603C9CF8ACFC}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lehm -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01EBF9FB-0436-4893-A9CF-825537D060C4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Mineralfaser -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01EBF9FB-0436-4893-A9CF-825537D060C4}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralfaser -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E336947-1AE4-42FF-92D7-07F56B85EF66}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralfaserdämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF220C79-A9F3-4EC7-805A-3D4A0315D388}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralschaumplatte -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68D1F59E-18A0-458A-BA82-9191BAF8B647}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralwolle -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E2B16D0-870D-4322-B608-ABE574E904A3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Mineralwollplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E2B16D0-870D-4322-B608-ABE574E904A3}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralwollplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C02B22C-96C3-45E5-81C2-60DEA512B67C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Polystyroplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C02B22C-96C3-45E5-81C2-60DEA512B67C}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polystyroplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52028111-6F23-4555-98C4-79E565009A02}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schafwolle -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1BC30DFD-2B2D-4D8C-AAF5-4F5CCA44FBE7}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schaumglas -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09D8AC5-B817-4994-9CE0-7EFAB2FD6975}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Schaumglasplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09D8AC5-B817-4994-9CE0-7EFAB2FD6975}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schaumglasplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFCC74A6-15A1-4BA9-8176-2808391228D2}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinwolle -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0A2BBD7-AD25-419C-B6EF-F58BB8504865}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Steinwollplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0A2BBD7-AD25-419C-B6EF-F58BB8504865}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinwollplatten -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{241DE528-D03E-4E6A-A965-BB34F9169CFD}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stroh -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BED98CB2-DC3E-4040-8548-5FDEE7160416}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Waermedaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BED98CB2-DC3E-4040-8548-5FDEE7160416}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Waermedaemmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{00417AEB-1BCB-4323-8460-2520265B5ADF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Waermeisolation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{00417AEB-1BCB-4323-8460-2520265B5ADF}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Waermeisolation -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B86CBF6C-A04E-4A06-BCDC-8E6A4AF44AC3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Wärmedämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B86CBF6C-A04E-4A06-BCDC-8E6A4AF44AC3}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmung -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B8C3F0F-D4B6-4EC0-9093-427A7AACFC65}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Wärmedämmung - hart -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B8C3F0F-D4B6-4EC0-9093-427A7AACFC65}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmung - hart -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16F61F28-B1BB-40B1-A3D2-311CACA69F95}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Wärmedämmung - weich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16F61F28-B1BB-40B1-A3D2-311CACA69F95}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmung - weich -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C89B08F-E589-463F-B255-1759BC75F62F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Wärmeisolation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C89B08F-E589-463F-B255-1759BC75F62F}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmeisolation -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B2BA224-4CB1-4195-83F1-064148F2025E}', 'HY-{FAAB3D98-6495-4544-A621-80B048C4F2CD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zellulose -> Dämmung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5DFCC6A-2B0A-44D0-918A-D09CD6412335}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Balken-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5DFCC6A-2B0A-44D0-918A-D09CD6412335}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Balken-Dämmung -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6D7E268-7471-4374-A453-CCB79AA34998}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Balkendämmung -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8208CDB1-951C-4721-87AD-8619194DD0E4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Balken -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8208CDB1-951C-4721-87AD-8619194DD0E4}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Balken -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48C7E8BA-8866-46EA-AF0C-E4DE9244B592}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Balken -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50308F99-6F5F-402C-AAA0-5F4F828A6EB2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Balken / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50308F99-6F5F-402C-AAA0-5F4F828A6EB2}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Balken / 700 -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5FD5C0F-7FFD-49D2-BBBF-214E5B63531A}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sparrenunterdämmung -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78E8AC1D-FF9B-43F2-8467-3B62FA429688}', 'HY-{D7CF1A60-B843-444B-A8C5-6B1A4C17C017}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zwischensparrendämmung -> Dämmung-Balken
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FAACA8D-E075-465E-8DD2-14DF62F465C4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Bodendaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FAACA8D-E075-465E-8DD2-14DF62F465C4}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodendaemmung -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{143045E7-6490-44C7-99F6-3F6280474C8B}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodendämmung -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4D93FD8-0C28-4CB7-9C7E-DA5A5D32F197}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4D93FD8-0C28-4CB7-9C7E-DA5A5D32F197}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Boden -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CF34EF5-75E0-4D96-B836-34089E50BD97}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung Bodenbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CF34EF5-75E0-4D96-B836-34089E50BD97}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Bodenbelag -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B21355B-470F-4516-8430-337052A3C562}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung UB -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B21355B-470F-4516-8430-337052A3C562}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung UB -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CD86EBF-B039-4A01-B593-0F8099CE3F9A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung Unterlagsboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CD86EBF-B039-4A01-B593-0F8099CE3F9A}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Unterlagsboden -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6785972-9B2B-4B95-861A-E04C4B4768B2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6785972-9B2B-4B95-861A-E04C4B4768B2}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Boden -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE142802-9FC9-4DA4-B154-E7C5BEBAB398}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Bodenbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE142802-9FC9-4DA4-B154-E7C5BEBAB398}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Bodenbelag -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6C1DCCD-59AD-451F-B198-9BB53A621369}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Unterlagsboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6C1DCCD-59AD-451F-B198-9BB53A621369}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Unterlagsboden -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA6F13CE-EB53-420F-A812-6A2951972F9F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- UB-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA6F13CE-EB53-420F-A812-6A2951972F9F}', 'HY-{1183CDC4-FD2E-4849-8222-EEC2C2884F2C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- UB-Dämmung -> Dämmung-Boden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50479C61-19D0-460C-9DA1-4860F1C4EA3D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Decke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{50479C61-19D0-460C-9DA1-4860F1C4EA3D}', 'HY-{80F59ACE-3F9B-4C7B-ABE9-8684E1E393E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Decke -> Dämmung-Decke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{345D1773-77CA-4B04-B017-D3B49652B92E}', 'HY-{80F59ACE-3F9B-4C7B-ABE9-8684E1E393E8}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckendämmung -> Dämmung-Decke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D020B4EB-3513-4827-98F2-77F5C3FC5B61}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Fassadenbau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D020B4EB-3513-4827-98F2-77F5C3FC5B61}', 'HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Fassadenbau -> Dämmung-Fassadenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A7B51FB-A1A2-4E7E-9E73-AF76F9CC38D1}', 'HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Fassadenbau -> Dämmung-Fassadenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06CB14EA-90AB-406E-AD5F-373DDA414141}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Fassadenbau / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06CB14EA-90AB-406E-AD5F-373DDA414141}', 'HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Fassadenbau / 700 -> Dämmung-Fassadenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A72EC37-697D-4809-AC33-962A44310E90}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Fassadenbau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A72EC37-697D-4809-AC33-962A44310E90}', 'HY-{6F05AEBE-B6E2-408F-B9B5-0879CA71442F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Fassadenbau -> Dämmung-Fassadenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8C7F8CD-467F-41AD-BB17-E0644F3F88D0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Flachdach -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8C7F8CD-467F-41AD-BB17-E0644F3F88D0}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Flachdach -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA94DA9D-028E-4616-9D73-07C79A3FF083}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung, Flachdach -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA94DA9D-028E-4616-9D73-07C79A3FF083}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, Flachdach -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F5E08AA-C064-46FC-A056-AC43CEBB45A4}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Gefälle -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E45F9E4A-830B-4C64-9AD4-7DDF4D647259}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Gefälle -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA06567B-D5FF-4379-82BA-048937AF5427}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Flachdach -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA06567B-D5FF-4379-82BA-048937AF5427}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Flachdach -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41C3F008-2AE1-4821-9A69-75D96A45B227}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Flachdachdaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41C3F008-2AE1-4821-9A69-75D96A45B227}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachdaemmung -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1471AB7C-6B27-4E89-A495-43106AEC0783}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachdämmung -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF19B1D3-9EC2-4122-A700-4DA0EB09C72B}', 'HY-{DD6D6799-D437-43A4-8491-D1A267256C8E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gefälledämmung -> Dämmung-Flachdach
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51B07A89-0AEF-47D8-9ECA-AA9FBD2FB4AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Hohlraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51B07A89-0AEF-47D8-9ECA-AA9FBD2FB4AF}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Hohlraum -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FADC230E-09CD-4200-9D61-383D3AF9FA69}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Hohlraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FADC230E-09CD-4200-9D61-383D3AF9FA69}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Hohlraum -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{43010DCC-A5DD-4B6C-895B-6EAAD12D6880}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Hohlraum / 510 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{43010DCC-A5DD-4B6C-895B-6EAAD12D6880}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Hohlraum / 510 -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B0A3E65-0740-422D-961D-57A3173F1719}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Hohlraumdaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B0A3E65-0740-422D-961D-57A3173F1719}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlraumdaemmung -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8B3EDFA-5A2C-4BB1-A6D5-858CB85DB8F8}', 'HY-{3A2ED362-B20E-4BFE-91FF-9FF60BF8D8B4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlraumdämmung -> Dämmung-Hohlraum-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C9B6B0D-2A57-4740-B050-17F66B8A9854}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Bodenlager -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7C9B6B0D-2A57-4740-B050-17F66B8A9854}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bodenlager -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{596CACF0-C25F-494E-8DA4-A68817B861A4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung-Holzstaender -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{596CACF0-C25F-494E-8DA4-A68817B861A4}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Holzstaender -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1C3E422-EEFB-413F-8048-5311470115B3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Daemmung, Konstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1C3E422-EEFB-413F-8048-5311470115B3}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, Konstruktion -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADB33B55-A46B-4AE6-A5FB-6000F559B57F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Holzständer / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADB33B55-A46B-4AE6-A5FB-6000F559B57F}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Holzständer / 700 -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{913EBF85-8C98-49F0-958E-F3837BAEA937}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung-Pfosten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{913EBF85-8C98-49F0-958E-F3837BAEA937}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Pfosten -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB4B6875-9112-40D2-BBFD-26A72E4DC51A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung, Konstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB4B6875-9112-40D2-BBFD-26A72E4DC51A}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Konstruktion -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FDBE7FA-70AC-4287-8009-CBAC9E9A06C4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung/Holzständer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FDBE7FA-70AC-4287-8009-CBAC9E9A06C4}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung/Holzständer -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFBF3AD6-86FC-42ED-8DA5-367BA856E1AA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Dämmung/Pfosten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFBF3AD6-86FC-42ED-8DA5-367BA856E1AA}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung/Pfosten -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15333D2F-1B56-40DA-B213-45517CBDAAC4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Holzständer Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15333D2F-1B56-40DA-B213-45517CBDAAC4}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständer Dämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE339D61-FC09-44B7-B9D1-41A98FD58BB6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Holzständer-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE339D61-FC09-44B7-B9D1-41A98FD58BB6}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständer-Dämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{499F536D-EB6D-44E5-93FE-0030FAA1AE2F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Holzständer/Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{499F536D-EB6D-44E5-93FE-0030FAA1AE2F}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständer/Dämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5194B1D-A3D4-4F1E-B46A-57E9DAB804FE}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständerdämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21EBF8A2-007C-4B69-88A7-B637F4F92373}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Pfosten-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21EBF8A2-007C-4B69-88A7-B637F4F92373}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfosten-Dämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{553BA438-2E77-4D60-9D0F-2F504CE63B1E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:14'); -- Pfosten/Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{553BA438-2E77-4D60-9D0F-2F504CE63B1E}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfosten/Dämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFC72B9B-6286-481E-B617-A60DCB72FDD6}', 'HY-{879CD58F-37F2-4BB7-B98F-7BD33E980465}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfostendämmung -> Dämmung-Holzständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A8D47A4-DC47-4D74-B523-7875E76C48D8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung-Holzwolle -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A8D47A4-DC47-4D74-B523-7875E76C48D8}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Holzwolle -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F4359EA-6EC3-4E4D-B063-412374F8E387}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwoll-Daemmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F4359EA-6EC3-4E4D-B063-412374F8E387}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwoll-Daemmplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7AE22BE-951E-4797-ABCD-0E2ED48FD808}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwoll-Dämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7AE22BE-951E-4797-ABCD-0E2ED48FD808}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwoll-Dämmplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0E57A90-4434-4535-B101-5A62AA409B02}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwoll-Dämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0E57A90-4434-4535-B101-5A62AA409B02}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwoll-Dämmplatten -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7C6DBC2-6F0D-4B21-9A1E-7345C7ABC6BC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwolle-Dämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7C6DBC2-6F0D-4B21-9A1E-7345C7ABC6BC}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Dämmplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8586B8CE-3B60-4B25-8BA3-EA45EF95510E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwolle-Dämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8586B8CE-3B60-4B25-8BA3-EA45EF95510E}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Dämmplatten -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BC94010-B17F-421F-B125-597FCCA6D692}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwolle-Mehrschicht-Dämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BC94010-B17F-421F-B125-597FCCA6D692}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Mehrschicht-Dämmplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7E28E52-0CA4-4804-BD97-7C4E2FAD534F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwolle-Mehrschicht-Dämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7E28E52-0CA4-4804-BD97-7C4E2FAD534F}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Mehrschicht-Dämmplatten -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18BB4CB5-4554-4D45-A52F-16FB734DA30A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Holzwolle-Verbundplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18BB4CB5-4554-4D45-A52F-16FB734DA30A}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Verbundplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3916CB90-E296-4A5A-AC8F-F0B60CD6FBD8}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolledämmung -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1400C179-749E-44CE-8820-A1F32E6B6933}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Mehrschicht-Dämmplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1400C179-749E-44CE-8820-A1F32E6B6933}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mehrschicht-Dämmplatte -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A892FB7-ABBC-4A8C-9616-2518130A7A15}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Mehrschicht-Dämmplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A892FB7-ABBC-4A8C-9616-2518130A7A15}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mehrschicht-Dämmplatten -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9755C4B-5C75-4D2D-BF72-0921982DB1D6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Schichtex -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9755C4B-5C75-4D2D-BF72-0921982DB1D6}', 'HY-{1FDFFED3-86DB-4243-BF43-AF0408B5D202}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schichtex -> Dämmung-Holzwolle
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5B4918-4BD4-48A8-B575-7B72D78F58B9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5B4918-4BD4-48A8-B575-7B72D78F58B9}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB87DC25-01A6-4DEF-8592-0CD2A3ED5783}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB87DC25-01A6-4DEF-8592-0CD2A3ED5783}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A854BF-21E3-4E7C-9197-60E8679F1F2F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung, Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A854BF-21E3-4E7C-9197-60E8679F1F2F}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58DF0089-C547-403D-BBDF-AE311D853044}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58DF0089-C547-403D-BBDF-AE311D853044}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{544DD228-C85A-4058-809D-8287631181FA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{544DD228-C85A-4058-809D-8287631181FA}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609C66F0-2D58-414D-86A8-AD63329EBBFE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung_Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{609C66F0-2D58-414D-86A8-AD63329EBBFE}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEEA767B-B87B-4675-9ED1-171467497A27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung, Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEEA767B-B87B-4675-9ED1-171467497A27}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29416189-5C20-4529-A7FC-9433D71BB1B3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Innendaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29416189-5C20-4529-A7FC-9433D71BB1B3}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innendaemmung -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E5E70EE-2EA6-4F27-A225-DB86B337E75A}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innendämmung -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20E3580F-567D-4966-95F1-4D94CD08A314}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Innendämmung / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20E3580F-567D-4966-95F1-4D94CD08A314}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innendämmung / 400 -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9EB4F04-B492-4FE8-8ACD-7BBC24DD09CE}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innenisolation -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CF01EF4-CE54-47D4-99FA-4ECB0E9A3CCD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Waermedämmung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CF01EF4-CE54-47D4-99FA-4ECB0E9A3CCD}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Waermedämmung-Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB063B5-03A5-402F-8A1E-09272BE5A678}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Wärmedämmung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB063B5-03A5-402F-8A1E-09272BE5A678}', 'HY-{5EDF2D4A-922E-48E1-8B25-887AECB739BC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmung-Innen -> Dämmung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0A4F254-097D-4892-9C2D-EA2998552A08}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung-Lattung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0A4F254-097D-4892-9C2D-EA2998552A08}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Lattung -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0925B528-8522-49A0-9B53-EEA71CB30C69}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Lattung -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7804C52A-4BD3-42B2-806A-E61B6BC9132F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung-Lattung / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7804C52A-4BD3-42B2-806A-E61B6BC9132F}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Lattung / 700 -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FED2418A-C765-4241-AB74-560DBDF96C69}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Lattung-Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FED2418A-C765-4241-AB74-560DBDF96C69}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung-Daemmung -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAF0E9F-6324-4EB8-919B-BD87D6DFD1B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Lattung-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBAF0E9F-6324-4EB8-919B-BD87D6DFD1B6}', 'HY-{E9E36DC7-4A99-4598-98AC-E01D2CEB270B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung-Dämmung -> Dämmung-Lattung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67AE0FBE-5442-42A9-8661-855B5AB09D98}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung Perimeter -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67AE0FBE-5442-42A9-8661-855B5AB09D98}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung Perimeter -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22A45AD3-EB48-4830-9144-4005C410222F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung-Perimeter -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22A45AD3-EB48-4830-9144-4005C410222F}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Perimeter -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC231139-94F8-467A-9674-6D23573BD7AD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung Perimeter -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC231139-94F8-467A-9674-6D23573BD7AD}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Perimeter -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA278F00-FD96-47B3-A6F8-8A3FDAB6DCA8}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{932ACFF9-49D5-4DA8-9952-0C5C0F8F9D26}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung-XPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{932ACFF9-49D5-4DA8-9952-0C5C0F8F9D26}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3BE8EDAE-5D75-4F41-B037-B8FD567B7FFD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung, Perimeter horizontal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3BE8EDAE-5D75-4F41-B037-B8FD567B7FFD}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Perimeter horizontal -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03B215D2-3D0C-43D0-9B91-A7CA4C9EF187}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung, Perimeter vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03B215D2-3D0C-43D0-9B91-A7CA4C9EF187}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Perimeter vertikal -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{369B7C01-C87D-41A3-9E2C-D725DEA5AFBC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- PD EPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{369B7C01-C87D-41A3-9E2C-D725DEA5AFBC}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PD EPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1E52917-5A80-4CC9-93BE-1F0ECDBD7233}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- PD Schaumglas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1E52917-5A80-4CC9-93BE-1F0ECDBD7233}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PD Schaumglas -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{660C88E5-BD92-4C06-BF47-19BEEA80C1D3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- PD Schaumglasplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{660C88E5-BD92-4C06-BF47-19BEEA80C1D3}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PD Schaumglasplatte -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A48575D-A0F1-4991-A0DB-DB29F915BDF0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- PD XPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A48575D-A0F1-4991-A0DB-DB29F915BDF0}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PD XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8F3C272-241F-4888-9716-D33B3B4793C2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Perimeter-Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8F3C272-241F-4888-9716-D33B3B4793C2}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeter-Daemmung -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B8B6D2-305C-42E7-B9F9-8F4A60D1DA45}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Perimeter-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B8B6D2-305C-42E7-B9F9-8F4A60D1DA45}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeter-Dämmung -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76643463-6D7B-4496-985D-88D2B2FB5612}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Perimeterdaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76643463-6D7B-4496-985D-88D2B2FB5612}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdaemmung -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD8A58FD-9606-49AA-A057-A95DFC80C78F}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25941452-8376-4D3E-8A3C-38070B4D8ECF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Perimeterdämmung / 755 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25941452-8376-4D3E-8A3C-38070B4D8ECF}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung / 755 -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9C502AC-F2E6-4D0B-BEC3-127411D2AFD5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Perimeterdämmung / 757 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9C502AC-F2E6-4D0B-BEC3-127411D2AFD5}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung / 757 -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7E512AD-4D86-4B24-8C01-B24B108208DA}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung EPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{02894DC8-F7D6-4AE5-8F82-CB474A20A0F0}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung Schaumglas -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{533C1ABC-33A4-40ED-A226-5EB05A405DD8}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Perimeterdämmung XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67BBC4CD-456B-4CE8-BCB1-90C46C8E62A9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Wärmedämmung XPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67BBC4CD-456B-4CE8-BCB1-90C46C8E62A9}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wärmedämmung XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AE21FB-1BA3-421E-A7A2-644A5DB5B91D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- XPS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AE21FB-1BA3-421E-A7A2-644A5DB5B91D}', 'HY-{EC80FD19-7E77-4DF7-A6FE-2F40365BE439}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- XPS -> Dämmung-Perimeter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEC69D2D-F701-4FEF-8483-291298DC4C5A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung Staender -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEC69D2D-F701-4FEF-8483-291298DC4C5A}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung Staender -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEBD2865-6E88-409D-8D31-BD6D538774CE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung-Staender -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEBD2865-6E88-409D-8D31-BD6D538774CE}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Staender -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83B1C3D9-299E-413A-A10B-983A0AF69D59}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Ständer -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{066721B8-6B1F-4B02-81AC-E8292AD30277}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung_Ständer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{066721B8-6B1F-4B02-81AC-E8292AD30277}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung_Ständer -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CDF5B00-938C-44BB-8D9A-E0D29DB4DA63}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung-Ständer / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CDF5B00-938C-44BB-8D9A-E0D29DB4DA63}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Ständer / 700 -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44A33F96-33A3-4CD5-8588-780E7A15DCD0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Staender_Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44A33F96-33A3-4CD5-8588-780E7A15DCD0}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Staender_Daemmung -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{940F55D6-80CE-4A05-845C-2268C9986246}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Staender-Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{940F55D6-80CE-4A05-845C-2268C9986246}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Staender-Daemmung -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04992482-68B3-43AD-B8EB-A3F116F50320}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Ständer_Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04992482-68B3-43AD-B8EB-A3F116F50320}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständer_Dämmung -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{771ED246-1F87-44E3-ADF2-62F2EB7F9CF6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Ständer-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{771ED246-1F87-44E3-ADF2-62F2EB7F9CF6}', 'HY-{B0FDF198-C012-49E2-B20E-4CDA4433C5AE}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständer-Dämmung -> Dämmung-Ständer
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E5BDB5E-AD24-4970-B259-306164C2FD17}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- CH_Trittschalldämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E5BDB5E-AD24-4970-B259-306164C2FD17}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Trittschalldämmung -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED7AAAC-500A-495C-B261-84D71F7F7F27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung Trittschall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED7AAAC-500A-495C-B261-84D71F7F7F27}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C78AAF8E-C25C-4A22-9EF5-32992BF698EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung-Trittschall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C78AAF8E-C25C-4A22-9EF5-32992BF698EE}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{483BD2CE-846D-4184-B484-6C3A81220FE7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Daemmung, Trittschall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{483BD2CE-846D-4184-B484-6C3A81220FE7}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung, Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{578DB70E-123C-4A3B-9E07-DA99D7E42E16}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D6C21F7-B00B-49C7-BC7E-A73B3C6533F5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Dämmung, Trittschall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D6C21F7-B00B-49C7-BC7E-A73B3C6533F5}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED6B8F8-20FB-461A-81C4-5B57D747808B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Trittschall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED6B8F8-20FB-461A-81C4-5B57D747808B}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschall -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19067D88-21D9-4015-BDC3-697D7DA2C213}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:15'); -- Trittschall-Daemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19067D88-21D9-4015-BDC3-697D7DA2C213}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschall-Daemmung -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{742E85F6-AA1D-438B-9CF0-83704536CA9B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trittschall-Dämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{742E85F6-AA1D-438B-9CF0-83704536CA9B}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschall-Dämmung -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89EAD867-BB48-4E3B-BE8F-5EA62B02061A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trittschall-Isolation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89EAD867-BB48-4E3B-BE8F-5EA62B02061A}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschall-Isolation -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AB56E78-855C-4E7D-82CF-2F5D9FB21A89}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trittschalldaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AB56E78-855C-4E7D-82CF-2F5D9FB21A89}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschalldaemmung -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88A153CD-C694-4B1F-9381-1B5311EC761C}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschalldämmung -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BCBF214-244F-4144-BA7D-0A72A7915C0E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trittschalldämmung / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5BCBF214-244F-4144-BA7D-0A72A7915C0E}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschalldämmung / 400 -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC6DD3F8-0DEA-475B-9500-3DAA969ACFDD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trittschalldämmung Schaumstoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC6DD3F8-0DEA-475B-9500-3DAA969ACFDD}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschalldämmung Schaumstoff -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{639C4733-C6F9-485F-9770-DD0F41335BAB}', 'HY-{E647C773-23A7-412B-8C04-F284C027B763}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trittschallisolation -> Dämmung-Trittschall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30ED3D25-7F93-4BB6-8B30-577F1FF97010}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Akustik-Hinterlage -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30ED3D25-7F93-4BB6-8B30-577F1FF97010}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustik-Hinterlage -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{490EB12E-B1F0-4FB8-9AD4-8BA971E0DF86}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Akustikhinterlage -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{490EB12E-B1F0-4FB8-9AD4-8BA971E0DF86}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikhinterlage -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{545275AF-3D74-4836-9173-824D57ADB3E6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Daemmung Trockenbau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{545275AF-3D74-4836-9173-824D57ADB3E6}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung Trockenbau -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE2438D7-E7A0-47A5-9E30-DE10DDBC5B8B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Daemmung-Trockenbau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE2438D7-E7A0-47A5-9E30-DE10DDBC5B8B}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Daemmung-Trockenbau -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CF8FBCE-5660-4EBB-9849-A60AF541B138}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung Trockenbau -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CA842C0-BB57-48DC-8866-1E515D2BF746}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dämmung-Trockenbau / 510 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CA842C0-BB57-48DC-8866-1E515D2BF746}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Trockenbau / 510 -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8344B0CF-F41C-4272-8A10-25D374C766C3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dämmung-Trockenbau / 700 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8344B0CF-F41C-4272-8A10-25D374C766C3}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung-Trockenbau / 700 -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6273FF38-C148-4A35-897B-D1190BB23D6B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dämmung, Schalldämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6273FF38-C148-4A35-897B-D1190BB23D6B}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmung, Schalldämmung -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2AAC3162-F401-430F-8142-AC1484466346}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Isolation-Trockenbau -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2AAC3162-F401-430F-8142-AC1484466346}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Isolation-Trockenbau -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D20FFAAF-DD73-43A3-AB76-3715E3E85371}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Schalldaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D20FFAAF-DD73-43A3-AB76-3715E3E85371}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldaemmung -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51B7E1B3-2885-432F-99D4-7B399A3E6AA0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Schalldämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51B7E1B3-2885-432F-99D4-7B399A3E6AA0}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmung -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2DED2AD-1EBA-4F92-8948-40884C11AEBF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Schalldämmung / 500 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2DED2AD-1EBA-4F92-8948-40884C11AEBF}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmung / 500 -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E18D5849-7863-409E-A790-3BD1D7AD2796}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Schalldämmung / 510 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E18D5849-7863-409E-A790-3BD1D7AD2796}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalldämmung / 510 -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B04DF626-9724-4918-9FCB-A81A03DC5585}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Trockenbaudaemmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B04DF626-9724-4918-9FCB-A81A03DC5585}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trockenbaudaemmung -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3EE36D0-77D3-466B-80E1-56C5EBD788D7}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trockenbaudämmung -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01BBE83E-C872-47FF-8093-57115B016248}', 'HY-{D4B16F03-8F63-47E3-B750-91BF356A508D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trockenbauisolation -> Dämmung-Trockenbau
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{910AE78E-E3F8-4522-AE34-F3A52A43F6B2}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfbremse -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDCE7B81-7B1A-486D-94FF-60299FFA9A59}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dampfsperrbahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDCE7B81-7B1A-486D-94FF-60299FFA9A59}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfsperrbahn -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A54E937E-EF3A-4A7E-82C8-D22B2B445D21}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dampfsperre / 800 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A54E937E-EF3A-4A7E-82C8-D22B2B445D21}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfsperre / 800 -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C8CC0740-5AF6-4E6F-AD9D-C584FB661402}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dampfsperrlage -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C8CC0740-5AF6-4E6F-AD9D-C584FB661402}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfsperrlage -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78CB753D-D72F-4C0E-9352-259FC08ED920}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Dampfsperrschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78CB753D-D72F-4C0E-9352-259FC08ED920}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dampfsperrschicht -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{481E685E-3700-40C9-9700-D89A910D13C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Sperrschicht, weit -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{481E685E-3700-40C9-9700-D89A910D13C6}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrschicht, weit -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9DE969-726B-4CAD-9F16-F7FDE60B19AA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Sperrschicht, weit / 800 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F9DE969-726B-4CAD-9F16-F7FDE60B19AA}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrschicht, weit / 800 -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51712219-2A66-488D-9F56-C43F214BDB3F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Standard - Dampfsperre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51712219-2A66-488D-9F56-C43F214BDB3F}', 'HY-{8E0F4655-0535-4A30-B59C-1189A8EBAC40}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Standard - Dampfsperre -> Dampfsperre
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65567C9C-2A60-466B-9B57-6FCB541CFB4D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Abhänger -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65567C9C-2A60-466B-9B57-6FCB541CFB4D}', 'HY-{FC196730-5CE9-4098-93E2-15CBA87BA352}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abhänger -> Deckenhohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E7896B7-8DE9-47C9-9B3B-07F67797D619}', 'HY-{FC196730-5CE9-4098-93E2-15CBA87BA352}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abhängung -> Deckenhohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC921A-8552-4B95-8770-92812B0516D9}', 'HY-{AB63944C-E2E3-4BB1-99C6-7638557623E5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abdeckprofil -> Deckleiste
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{469078B2-CD95-48E9-900F-13FA77F3D325}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Deckleisten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{469078B2-CD95-48E9-900F-13FA77F3D325}', 'HY-{AB63944C-E2E3-4BB1-99C6-7638557623E5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckleisten -> Deckleiste
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B84027-B581-4B0A-8172-CBD0C2CD3693}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- abgerieben -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B84027-B581-4B0A-8172-CBD0C2CD3693}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- abgerieben -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A120080-40E6-49C1-A06F-D07FA284CFDC}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D24CC6C9-1DB7-4A87-8B68-8FE2647178D3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Abrieb gestr. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D24CC6C9-1DB7-4A87-8B68-8FE2647178D3}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb gestr. -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D420AD-CAA9-4D82-B011-F991BD336759}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb gestrichen -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9613779-1B9B-49A6-9756-6E6644705862}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E6CB485-781E-44D3-AA54-0F153FA075E1}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aussenputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB85CD87-AC9E-404C-851E-B465E8F75E18}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- CH_Innenputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB85CD87-AC9E-404C-851E-B465E8F75E18}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Innenputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56771EDC-6C90-42C6-8287-CC2E86B4577B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Deckenputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56771EDC-6C90-42C6-8287-CC2E86B4577B}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckenputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{585CD8D4-0C33-4645-9724-CEA76CEE7EB6}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Edelputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{779D8106-0E63-49DE-BFF9-954FC4EB82B5}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskalkputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F56A6298-916C-4051-B239-1EAE2421C39F}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3CFBDC1-A153-4716-AF3D-C49BB4159D77}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glattputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ED27B13-66B6-4F88-AE4A-8A7A4857E9B2}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hanfputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5FE1E24-7BFA-4B59-9BB6-D1A782E3FB38}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innenputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B3CAE0C-1237-4192-B7FE-58EECADC66A9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Kalkgipsputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B3CAE0C-1237-4192-B7FE-58EECADC66A9}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkgipsputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7CA4264-50A9-4D8F-BFF1-636ECC67398E}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7993446-DF96-4771-B2DB-0DAE4C4F645A}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkzementputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25621FF8-BF53-4280-968B-00556BC57F3F}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klosterputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54236FE2-5C14-4653-B991-4437F05E43BE}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B9820E-17AB-4FAE-B9FD-74DBFE884CAB}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lehmputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DA041090-18BC-4CF8-80DA-87D9AE5B4305}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Magnetdeckputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AFB18E-C81E-4F07-BC4F-DD067482D851}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Magnetputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AFB18E-C81E-4F07-BC4F-DD067482D851}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Magnetputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FA145FF-F02B-432E-B5B5-2C76CF79E194}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralischer Putz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{894FC435-DDFD-43DF-8E35-2B8D5D45BFD6}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Putz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E83A163E-3F1B-4CE6-8A2D-8CAD55377369}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Silicatputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E83A163E-3F1B-4CE6-8A2D-8CAD55377369}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Silicatputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97936607-C025-4B79-9BCE-DE8BE8FBDF54}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Siliconharzputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97936607-C025-4B79-9BCE-DE8BE8FBDF54}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Siliconharzputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E18CCC5-9902-4516-BB66-DFD21CA94C87}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Silikatputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3BE5972-4879-4A18-98B7-EA54BE1DEABE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Spritz-Akustikputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3BE5972-4879-4A18-98B7-EA54BE1DEABE}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spritz-Akustikputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4EC2644-B0C5-4540-926C-EA6ED42B5983}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tonputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A19D51D-C386-43DD-B477-C4C3F5BC9D99}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FD8AC14-1C67-4F8A-8EB9-FFF52EC6DD17}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Verputz, Aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FD8AC14-1C67-4F8A-8EB9-FFF52EC6DD17}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputz, Aussen -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD2C9F0E-4788-42BC-B73C-1C36EBAAC595}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Verputz, Aussen / 530 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD2C9F0E-4788-42BC-B73C-1C36EBAAC595}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputz, Aussen / 530 -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8123628C-F88A-4A44-9219-37399CAA583D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Verputz, Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8123628C-F88A-4A44-9219-37399CAA583D}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputz, Innen -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A637809A-EEC4-4E1C-9809-DB8F93E7D438}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Verputz, Innen / 150 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A637809A-EEC4-4E1C-9809-DB8F93E7D438}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verputz, Innen / 150 -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB7A6368-8DA1-4B1D-B2EF-43ECB29541CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- verputzt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB7A6368-8DA1-4B1D-B2EF-43ECB29541CD}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- verputzt -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D992CC0-489E-481C-B640-ACD8F335040D}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1E41A0F-14B5-4125-807C-A3C887B94145}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Weissputz gestr. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1E41A0F-14B5-4125-807C-A3C887B94145}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz gestr. -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8B8F240-A9AC-40C7-B246-FD61563A69D7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Weissputz gestrichen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8B8F240-A9AC-40C7-B246-FD61563A69D7}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz gestrichen -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{38884E5D-C799-4981-920D-D7AE14956C27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- WP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{38884E5D-C799-4981-920D-D7AE14956C27}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- WP -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{30D60592-599E-4BE8-8D1A-28D8F3859CF1}', 'HY-{3500D347-5AA0-4CE5-BF8D-123AB65479B7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementputz -> Deckputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{196317D5-6E03-48F9-B155-EB555C2DC71B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:16'); -- Abrieb neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{196317D5-6E03-48F9-B155-EB555C2DC71B}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb neu -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B294F2F-9B9C-4E50-A0D8-BDA367BC5079}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Abrieb Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B294F2F-9B9C-4E50-A0D8-BDA367BC5079}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb Renovation -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28944F81-E75B-4E6E-A481-74AF79B5BCD6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Abrieb renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28944F81-E75B-4E6E-A481-74AF79B5BCD6}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb renoviert -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E973045-2110-452A-8C5F-8B6BE958E57D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Abrieb saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E973045-2110-452A-8C5F-8B6BE958E57D}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb saniert -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75BD6374-85B8-4DD7-9495-CB4AEFF3DC40}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Abrieb-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75BD6374-85B8-4DD7-9495-CB4AEFF3DC40}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abrieb-Renovation -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11B1430A-C18A-40D7-8C3A-1BBE8F690379}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Deckputz neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11B1430A-C18A-40D7-8C3A-1BBE8F690379}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz neu -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{12684143-D1D5-445D-A4F7-76F4F1EA7C20}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Deckputz saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{12684143-D1D5-445D-A4F7-76F4F1EA7C20}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz saniert -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DB2A4E3-8CBC-4747-97B2-C16CDC7708DA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Deckputz-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DB2A4E3-8CBC-4747-97B2-C16CDC7708DA}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz-Renovation -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DBF5D73-EFC5-42DC-AB7E-8A804B682188}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Deckputz-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DBF5D73-EFC5-42DC-AB7E-8A804B682188}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Deckputz-Sanierung -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2915A061-2489-4395-BD99-F8BD2174C60D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2915A061-2489-4395-BD99-F8BD2174C60D}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz neu -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4C6248E-1B56-44DC-AC04-26FB98E8992F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4C6248E-1B56-44DC-AC04-26FB98E8992F}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz Renovation -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB39A8E5-147C-4257-889C-F6B2A5B879F8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB39A8E5-147C-4257-889C-F6B2A5B879F8}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz renoviert -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AAC5131-E647-416D-B2C0-8D150222C4CB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AAC5131-E647-416D-B2C0-8D150222C4CB}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz saniert -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9890AA7A-6C95-439D-87CA-D2BC610BEAF6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9890AA7A-6C95-439D-87CA-D2BC610BEAF6}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz Sanierung -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F6C6597-9B44-4B08-82A5-BB7FB4BD94F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F6C6597-9B44-4B08-82A5-BB7FB4BD94F0}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz-Renovation -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FE334D-D152-43A5-97CC-E3A436AF26C7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Weissputz-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70FE334D-D152-43A5-97CC-E3A436AF26C7}', 'HY-{3B404E67-8DA8-4D65-BEEB-A808EDA0AD2A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weissputz-Sanierung -> Deckputz Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31D178A0-8F81-4915-A7BE-3F1F7B7432E2}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abdichtungsfolie -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{149F9FD9-FF02-4F59-AFAB-AB7EB31AECE8}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumen -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D67DAC3E-679A-4319-BA5F-F8A10C52242A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Bitumen-Dichtungsbahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D67DAC3E-679A-4319-BA5F-F8A10C52242A}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumen-Dichtungsbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F3245F0-9F80-4F63-B8F8-939CBF02D9AA}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumenbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD8F9ABD-6C20-4FC8-87B6-6FA2AEC5CD8D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Bitumenbahnen 2-lagig -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD8F9ABD-6C20-4FC8-87B6-6FA2AEC5CD8D}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumenbahnen 2-lagig -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{724F1669-609B-4725-9063-F579F059B791}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Bitumenbahnen 3-lagig -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{724F1669-609B-4725-9063-F579F059B791}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bitumenbahnen 3-lagig -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2F862D8-81A7-41C2-B57D-2BC6CE01F3AA}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachpappe -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9F0AD82-C2FF-4D4E-916C-FA4A960F162F}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dichtstoff -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1FBEEE7-DFC2-4102-94E5-D50436B919C1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Dichtungsbahn / 800 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1FBEEE7-DFC2-4102-94E5-D50436B919C1}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dichtungsbahn / 800 -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB37673F-7932-42A4-8C9C-837AD457A8F7}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastomerbitumen -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31A2A877-B990-4A2F-BC06-4F6F1D164E4C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Flachdach -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31A2A877-B990-4A2F-BC06-4F6F1D164E4C}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdach -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{758BEC58-62EA-49DA-B9A2-F0A99C331153}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Folie -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ABEFEE75-718B-4E51-8B41-539D2019D0C8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Polymer-Bitumen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ABEFEE75-718B-4E51-8B41-539D2019D0C8}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymer-Bitumen -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E9F7F0B-4AAD-4E16-AAE0-F0DFC8DB83EB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Polymer-Bitumenbahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E9F7F0B-4AAD-4E16-AAE0-F0DFC8DB83EB}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymer-Bitumenbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D27ED6B0-D5AD-4FC2-99DE-99F4D558582D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Polymerbitumen-Bahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D27ED6B0-D5AD-4FC2-99DE-99F4D558582D}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymerbitumen-Bahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D792D039-7637-435D-A0C3-DC88EA43F674}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Polymerbitumen-Dichtungsbahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D792D039-7637-435D-A0C3-DC88EA43F674}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polymerbitumen-Dichtungsbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3C0C84-7E79-430A-AEC8-67EF04CF145F}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrschicht -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2ADAF7EB-9074-433E-A235-F3D385C6DC3A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Sperrschicht, eng -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2ADAF7EB-9074-433E-A235-F3D385C6DC3A}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrschicht, eng -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3074D51B-2647-42F4-B045-702459A7D696}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Sperrschicht, eng / 800 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3074D51B-2647-42F4-B045-702459A7D696}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrschicht, eng / 800 -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{904FC3C6-5C1F-46B2-8921-14E84C9FF3C8}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Trennlage -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D92E9257-4A62-4CC5-8B63-6F5201352322}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterdachbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{021E1190-DA04-48A5-B656-1322B6705196}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterdeckbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5AFA4179-D904-4798-B0FC-C5784CAF1DA8}', 'HY-{000D4CDC-2D9A-46BA-ABB1-FFEEA46408C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterspannbahn -> Dichtungsbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F657EDD5-05A7-4705-92C0-87C6BAE2FA54}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Kunststoff-Dichtungsbahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F657EDD5-05A7-4705-92C0-87C6BAE2FA54}', 'HY-{BBCB8289-D3FA-4C80-90CA-518A1C518852}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff-Dichtungsbahn -> Dichtungsbahn-Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73DDDBD8-7625-41EC-A1B2-27847FD1E595}', 'HY-{BBCB8289-D3FA-4C80-90CA-518A1C518852}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffdichtungsbahn -> Dichtungsbahn-Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62991E1B-D512-411B-9AAB-2C18EA008384}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Sarnafil -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62991E1B-D512-411B-9AAB-2C18EA008384}', 'HY-{BBCB8289-D3FA-4C80-90CA-518A1C518852}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sarnafil -> Dichtungsbahn-Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A01B28E9-53BF-4483-8991-ED0FFE54B0E9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Akustik-Doppelboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A01B28E9-53BF-4483-8991-ED0FFE54B0E9}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustik-Doppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0865A54A-C9C9-4E59-87B9-3B2628D53B13}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustikdoppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD800E23-71DB-4CBA-85BA-86B6530430AE}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calziumsulfat -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B9D3295-C3EA-493B-B84E-0DA415005C7A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Calziumsulfat-Platte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B9D3295-C3EA-493B-B84E-0DA415005C7A}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calziumsulfat-Platte -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77ADE360-F3A8-42F0-AFB9-A7D8934B4A16}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Calziumsulfat-Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77ADE360-F3A8-42F0-AFB9-A7D8934B4A16}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calziumsulfat-Platten -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D73F2EE-59E2-496A-8ACE-C23DC481EEB5}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calziumsulfatplatte -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1E76ED2-72A4-4FAA-BAD4-346C4AE9318C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Calziumsulfatplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1E76ED2-72A4-4FAA-BAD4-346C4AE9318C}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calziumsulfatplatten -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FCA57F8-A535-4CAE-8043-CEDA63BABD82}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Doppelbodenplatte -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A332456B-A095-4F8D-B7D5-44FA6060C6E8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Doppelbodenplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A332456B-A095-4F8D-B7D5-44FA6060C6E8}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Doppelbodenplatten -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F07431-2976-4FA9-B5AF-F62E11F94DC0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Element-Doppelboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99F07431-2976-4FA9-B5AF-F62E11F94DC0}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Element-Doppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C451960-1EB3-41D6-8B4A-2BB7F699BAD4}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementdoppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10129DF9-D081-48BB-9BD9-5FA3F45D674E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Kalziumsulfatplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10129DF9-D081-48BB-9BD9-5FA3F45D674E}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalziumsulfatplatte -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8BCA64E-E351-456F-A414-3388A085EFBC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Kalziumsulfatplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D8BCA64E-E351-456F-A414-3388A085EFBC}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalziumsulfatplatten -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9DF61ABC-C301-4CBF-A753-EFF3D00A4836}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Thermo-Doppelboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9DF61ABC-C301-4CBF-A753-EFF3D00A4836}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Thermo-Doppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C5B06A-DD2E-47C6-82A9-FA8D8C10AA47}', 'HY-{F4066469-8320-4134-8853-A0C5B4A762C4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Thermodoppelboden -> Doppelboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{125CB03B-4DCF-4750-995E-27218B836006}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Drainage -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A498F3F2-16A9-486A-B15A-EB0BDEB1F5AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Drainage-Schicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A498F3F2-16A9-486A-B15A-EB0BDEB1F5AF}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Drainage-Schicht -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFD4CB07-3FCA-47ED-8802-777A8CE23522}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Drainagematte -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1EE29CE-1F2D-4E74-83FE-980CBEBBF6DE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Drainschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1EE29CE-1F2D-4E74-83FE-980CBEBBF6DE}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Drainschicht -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C4007F1A-BA2D-45CE-B45B-8350882639FB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Dränage -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C4007F1A-BA2D-45CE-B45B-8350882639FB}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dränage -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC4085-88B5-45DD-AA9B-62879D017B1B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Dränschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70AC4085-88B5-45DD-AA9B-62879D017B1B}', 'HY-{3C0AFC76-5F45-4615-B5D5-F7D98CC6BFD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dränschicht -> Drainageschicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4685D8C6-A669-4DA0-A29B-0118F9778337}', 'HY-{28F68337-C968-4EB3-8551-5FED863602F2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag -> Elastischer Belag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{583B4073-AB7D-477E-974A-AF7E809C547B}', 'HY-{28F68337-C968-4EB3-8551-5FED863602F2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vinyl -> Elastischer Belag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C5B12C3-14B9-44F3-9893-B1CD0AD0224E}', 'HY-{89E91AFC-6B79-47B7-A9F3-182F6F69C6C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gummibelag -> Elastischer Belag Gummi
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5BE2344-9C05-4AB8-9A20-F1F05F465112}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Gumminoppen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5BE2344-9C05-4AB8-9A20-F1F05F465112}', 'HY-{89E91AFC-6B79-47B7-A9F3-182F6F69C6C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen -> Elastischer Belag Gummi
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB28071D-34AC-4E9F-8A59-8A3E75A21F33}', 'HY-{89E91AFC-6B79-47B7-A9F3-182F6F69C6C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppenbelag -> Elastischer Belag Gummi
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB7BAA79-066B-483C-84BE-505032BED4E2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Linol -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB7BAA79-066B-483C-84BE-505032BED4E2}', 'HY-{712C3B68-2D82-487E-A095-7E882C5E5C0E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol -> Elastischer Belag Linol
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35BECE8C-67E4-4524-A60D-84CCF812C1B7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:17'); -- Linol / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35BECE8C-67E4-4524-A60D-84CCF812C1B7}', 'HY-{712C3B68-2D82-487E-A095-7E882C5E5C0E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol / 140 -> Elastischer Belag Linol
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCE05644-168E-4C92-A8E5-109452D0C23C}', 'HY-{712C3B68-2D82-487E-A095-7E882C5E5C0E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum -> Elastischer Belag Linol
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8181245F-E5B9-4008-B92D-FA5E7AB53F6F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elastischer Belag neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8181245F-E5B9-4008-B92D-FA5E7AB53F6F}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag neu -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4FE84A8F-ABDF-460E-9817-DC0A21167C12}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elastischer Belag renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4FE84A8F-ABDF-460E-9817-DC0A21167C12}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag renoviert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B2682D-88AD-440A-B8F3-58E8A30CAF63}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elastischer Belag saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09B2682D-88AD-440A-B8F3-58E8A30CAF63}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elastischer Belag saniert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A3188AD-288D-4B43-A482-681958D667C1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A3188AD-288D-4B43-A482-681958D667C1}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen neu -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F9ED15B-2E9A-4585-B5D5-D003DA512006}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F9ED15B-2E9A-4585-B5D5-D003DA512006}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D7F9727-3B41-457E-AA17-1C4A2CD48593}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D7F9727-3B41-457E-AA17-1C4A2CD48593}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen renoviert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{279E7C9B-8656-471F-B4B4-700FEB82D22F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{279E7C9B-8656-471F-B4B4-700FEB82D22F}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen saniert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B08FA8-EF13-4D9A-9371-F43DDE399589}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B08FA8-EF13-4D9A-9371-F43DDE399589}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E00C80CC-E3D3-45FF-BB9C-8F45BA8C43C4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E00C80CC-E3D3-45FF-BB9C-8F45BA8C43C4}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen-Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A2DB4F-C2B3-4A89-8190-66DE1CB8752B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Gumminoppen-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A2DB4F-C2B3-4A89-8190-66DE1CB8752B}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gumminoppen-Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25DBA129-9259-4E1A-AD78-ACDD644D04E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25DBA129-9259-4E1A-AD78-ACDD644D04E1}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag neu -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8AF0C3A-6D7C-404C-8AAC-C10FC8F568BD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8AF0C3A-6D7C-404C-8AAC-C10FC8F568BD}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8040CE96-0AB3-4978-9046-1A908A99BF41}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8040CE96-0AB3-4978-9046-1A908A99BF41}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag renoviert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2F823BD-1D05-4164-B6F6-C51D6630B698}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2F823BD-1D05-4164-B6F6-C51D6630B698}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag saniert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5024F7CC-1445-461E-99BD-AE3EF1F1E8D7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5024F7CC-1445-461E-99BD-AE3EF1F1E8D7}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D995C11A-EDA5-4BCE-BAD1-4DAD34B31782}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D995C11A-EDA5-4BCE-BAD1-4DAD34B31782}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag-Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BF69BA9-5D4D-4D3F-A88E-8101553FDBC1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Kunststoffbelag-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BF69BA9-5D4D-4D3F-A88E-8101553FDBC1}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffbelag-Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FDD1CB2-A33B-423F-9ACE-519E2275BF44}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8FDD1CB2-A33B-423F-9ACE-519E2275BF44}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol neu -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94FBBB36-FB63-43D0-8CAA-8B233F0FC355}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94FBBB36-FB63-43D0-8CAA-8B233F0FC355}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24A9220A-E646-4468-AC61-4B2B286127EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24A9220A-E646-4468-AC61-4B2B286127EE}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol renoviert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF9AF865-B7B3-4ED1-8020-3F2077276839}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF9AF865-B7B3-4ED1-8020-3F2077276839}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol saniert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{025A9B9D-B2F7-4F22-A35B-265EF449EDCA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{025A9B9D-B2F7-4F22-A35B-265EF449EDCA}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{081BA7A0-E748-4684-A3E8-CF610E394C41}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{081BA7A0-E748-4684-A3E8-CF610E394C41}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol-Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DFF161B-CA8B-4327-9B17-8298D8388AE9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linol-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DFF161B-CA8B-4327-9B17-8298D8388AE9}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linol-Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{619B7D69-DCAF-4EC9-A14B-DCDA64A5448C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{619B7D69-DCAF-4EC9-A14B-DCDA64A5448C}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum neu -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47EA1F18-8D56-45A3-9142-273893540977}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47EA1F18-8D56-45A3-9142-273893540977}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA8D5799-F219-4BA7-989A-DDB1A704A0F7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA8D5799-F219-4BA7-989A-DDB1A704A0F7}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum renoviert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE60A01C-E274-45A1-862B-2F1693242A5F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BE60A01C-E274-45A1-862B-2F1693242A5F}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum saniert -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4502CC9-6C63-4509-88D8-1D5F3492F6EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4502CC9-6C63-4509-88D8-1D5F3492F6EE}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EF426BB-0D6A-4B98-9646-8B4FA085791F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EF426BB-0D6A-4B98-9646-8B4FA085791F}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum-Renovation -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAFE732C-E1F5-4061-B296-6E3AC98840E7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Linoleum-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DAFE732C-E1F5-4061-B296-6E3AC98840E7}', 'HY-{EBD7C6C0-4E5E-4BD6-83E0-34AB89E66B74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Linoleum-Sanierung -> Elastischer Belag Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C72BAA54-0FEC-490F-8E85-66F074E163A0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Backstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C72BAA54-0FEC-490F-8E85-66F074E163A0}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78CE591B-D023-4164-AFBE-1A1B342E8FBA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Backstein-Wandplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78CE591B-D023-4164-AFBE-1A1B342E8FBA}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein-Wandplatte -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A011D29-D7C4-442B-B9D8-899E8700CB69}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backsteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39F11DCE-6FDC-4A66-A9E7-778168D5DD4B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elementbau Backstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39F11DCE-6FDC-4A66-A9E7-778168D5DD4B}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau Backstein -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1BE9C88-AFAC-404A-8C29-79E4CE69BD69}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elementbau Ziegelstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1BE9C88-AFAC-404A-8C29-79E4CE69BD69}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau Ziegelstein -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0001AB0D-E69E-4AED-B013-63A9C1252E80}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Klinkerstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0001AB0D-E69E-4AED-B013-63A9C1252E80}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3A1B8AA-2808-489E-915D-DC5E73EA0E57}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkersteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E1530D0-4BED-4531-9D4D-C8B95EE80FDB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Preton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E1530D0-4BED-4531-9D4D-C8B95EE80FDB}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Preton -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0354D5B7-0694-4EA0-B6F8-5289CD9BCC3A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Sichtbackstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0354D5B7-0694-4EA0-B6F8-5289CD9BCC3A}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbackstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F80F3A0-0F74-479E-9209-E346E2A48744}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbacksteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B174DFA3-14F3-4F72-9221-2EAA16E09044}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Sichtstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B174DFA3-14F3-4F72-9221-2EAA16E09044}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DDEA4183-BAA2-4058-9606-71A52364F0A3}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtsteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B531B72E-8EF3-43A7-8692-7914EE5AAD6E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Sichtziegelstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B531B72E-8EF3-43A7-8692-7914EE5AAD6E}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtziegelstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2E47E30-75C0-4C24-9FA5-0AC629E7264D}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtziegelsteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{560DF9E7-2CEA-48ED-9CDE-52C08C3A5464}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Ziegelstein-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{560DF9E7-2CEA-48ED-9CDE-52C08C3A5464}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegelstein-Element -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82912D28-1A48-4146-83C0-9E7DE9DE6746}', 'HY-{9125ED8E-D694-4082-881F-284625F21CD1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegelsteinelement -> Elementbau-Backstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93DF009B-BAEB-490D-8DF4-737385991A3C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Beton vorfabriziert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93DF009B-BAEB-490D-8DF4-737385991A3C}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton vorfabriziert -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{666EC72F-ADE7-4E0C-B015-45E1CF708872}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Beton Vorfabriziert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{666EC72F-ADE7-4E0C-B015-45E1CF708872}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton Vorfabriziert -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC13C0AE-807A-4D55-989A-D21BF42B57DD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Beton-Fertigelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC13C0AE-807A-4D55-989A-D21BF42B57DD}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Fertigelement -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA5806FC-7194-4C3E-9CD4-0AC5D23F5025}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Beton-Wandplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA5806FC-7194-4C3E-9CD4-0AC5D23F5025}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Wandplatte -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F1AD63C-540C-43DF-B1B3-BAEB04C5B54D}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonelement -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75F62622-400E-493A-A5DE-0C806490A3C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Betonsandwich-Wandplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75F62622-400E-493A-A5DE-0C806490A3C6}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonsandwich-Wandplatte -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F86CCE1-B350-476C-B80F-44E635AE8607}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- CH_Betonwerkstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F86CCE1-B350-476C-B80F-44E635AE8607}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Betonwerkstein -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F005611-17C6-4468-AC07-0439E318CD63}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Elementbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F005611-17C6-4468-AC07-0439E318CD63}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbeton -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E44A9C9C-B68C-4CE7-8A7F-98713951979B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Fertigbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E44A9C9C-B68C-4CE7-8A7F-98713951979B}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigbeton -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55911AF1-0B82-4FB3-8FBF-5D59552BC91D}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigteil -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A5E66C5-7B5B-4CA8-A399-D597C05A173A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:18'); -- Leichtbeton-Wandplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A5E66C5-7B5B-4CA8-A399-D597C05A173A}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbeton-Wandplatte -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD19FDBC-6B43-49D4-A97C-EF8822C4C63C}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbetonelement -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FFA9AAFA-59F9-4C35-B477-8A47C80674EC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Stahlbeton - Fertigbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FFA9AAFA-59F9-4C35-B477-8A47C80674EC}', 'HY-{144FBF68-4AFB-455C-8F67-C2932A9BD987}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlbeton - Fertigbeton -> Elementbau-Beton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CFA084DE-2FA3-4A64-AD27-B9AFA8EED01F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Porenbeton-Wandplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CFA084DE-2FA3-4A64-AD27-B9AFA8EED01F}', 'HY-{75AB92DB-55F2-47C3-8F5F-FA3D8600113B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbeton-Wandplatte -> Elementbau-Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{470D6786-E8DA-47E4-9577-8AD49D00708D}', 'HY-{75AB92DB-55F2-47C3-8F5F-FA3D8600113B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbetonelement -> Elementbau-Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E074FC0-82C8-4AC9-80CA-0696619D4FFC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Elementbau Sichtbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E074FC0-82C8-4AC9-80CA-0696619D4FFC}', 'HY-{1A2C6EC3-683B-4EF5-A440-D0B873F2C099}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementbau Sichtbeton -> Elementbau-Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D12830C-86AF-4457-AE07-742E53337813}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Sichtbeton-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D12830C-86AF-4457-AE07-742E53337813}', 'HY-{1A2C6EC3-683B-4EF5-A440-D0B873F2C099}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbeton-Element -> Elementbau-Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2565AD1D-6160-41B8-AC97-C72B4F9D6969}', 'HY-{1A2C6EC3-683B-4EF5-A440-D0B873F2C099}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtbetonelement -> Elementbau-Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74404702-95B0-4636-B5CC-3A436D650A79}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Dachboden-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{74404702-95B0-4636-B5CC-3A436D650A79}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachboden-Element -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAA0426D-B212-4751-824F-06ED172F2178}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Dachbodenelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAA0426D-B212-4751-824F-06ED172F2178}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachbodenelement -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58E3BB84-F251-4B1A-805D-0376F26F98BE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Estrich-Bodenelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58E3BB84-F251-4B1A-805D-0376F26F98BE}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich-Bodenelement -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14A6BD8B-03E0-4C99-8995-2A5BCD683A39}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Estrichboden-Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14A6BD8B-03E0-4C99-8995-2A5BCD683A39}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrichboden-Element -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7EA5052C-446A-4D4E-A8DC-5C9D2F014F14}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrichbodenelement -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F9A91A9-90D4-4AFB-961F-1D7D9C6EC65F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Estrichelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F9A91A9-90D4-4AFB-961F-1D7D9C6EC65F}', 'HY-{BBEEA2C5-5FA5-48A5-A863-E7536453D881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrichelement -> Estrich-Element
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{843FA539-59E0-40FC-98E0-E430E3A7CDD1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Dach - Zementfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{843FA539-59E0-40FC-98E0-E430E3A7CDD1}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Zementfaserplatten -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82EEE8EA-D058-4B2F-B5C1-8CCBBF0CEEC9}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternit -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92D85FAB-7A29-486A-BE03-F54C96056FBA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Eternit / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92D85FAB-7A29-486A-BE03-F54C96056FBA}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternit / 400 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD4B2B8C-C93F-461F-8EFF-12A99664C12B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Eternit / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD4B2B8C-C93F-461F-8EFF-12A99664C12B}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternit / 650 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A787A56-2463-496F-89E3-9A363F13862B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Eternit / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A787A56-2463-496F-89E3-9A363F13862B}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternit / 970 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3267ADD8-D9D3-4C5C-BA37-887C16C6504C}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserbeton -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89A8064B-A84B-4F13-8632-60C5E93C0C6D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Faserzement / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89A8064B-A84B-4F13-8632-60C5E93C0C6D}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzement / 400 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D612567-A822-4709-865B-62BB3C426931}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Faserzement / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D612567-A822-4709-865B-62BB3C426931}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzement / 650 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01A63D8A-E4C7-43BC-8900-321CD9529FD2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Faserzement / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01A63D8A-E4C7-43BC-8900-321CD9529FD2}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzement / 970 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE30037E-2369-494B-B2BA-D6ED29B681DD}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementplatte -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A37411BB-966F-451D-86EB-01DE85182265}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Faserzementplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A37411BB-966F-451D-86EB-01DE85182265}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementplatten -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{76CA8E8B-5C42-47A4-ACD7-B49D919CF9DD}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementschiefer -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC76EDBF-504B-4EC2-8A05-12F885700F2F}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rechteckschiefer -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBFE82D5-6471-47F5-BF21-28403C6FE9DD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EBFE82D5-6471-47F5-BF21-28403C6FE9DD}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearl -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D412D067-324E-480D-8646-DD698F030477}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearl / 400 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D412D067-324E-480D-8646-DD698F030477}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearl / 400 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A61632A6-2F72-46F3-A67E-8E4FA9494BA9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearl / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A61632A6-2F72-46F3-A67E-8E4FA9494BA9}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearl / 650 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{028BF596-620B-4ECE-B325-1CEE72C2D390}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearl / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{028BF596-620B-4ECE-B325-1CEE72C2D390}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearl / 970 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DD2738D-41CB-4149-B95D-CF74A45061AE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearlplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DD2738D-41CB-4149-B95D-CF74A45061AE}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearlplatte -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24F3650C-9A62-4177-9BDF-E480C059A549}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearlplatte / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24F3650C-9A62-4177-9BDF-E480C059A549}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearlplatte / 650 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D25C8AEA-27E7-4AB4-91BD-B5714E230470}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Swisspearlplatte / 970 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D25C8AEA-27E7-4AB4-91BD-B5714E230470}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Swisspearlplatte / 970 -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{924FDE12-5283-4B25-8511-05302950202A}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wabenschiefer -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98F9ED0E-1FFB-400E-9E55-9E89A954D7B3}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wellplatte -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01362BB8-573C-4C01-B165-A947661712A7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Wellplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01362BB8-573C-4C01-B165-A947661712A7}', 'HY-{16E77003-F401-4C8F-BCFF-5E88F6522513}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wellplatten -> Faserzement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C38DF9AC-1F6C-4317-A2AC-8E822C87A56B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fassadenbekleidung / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C38DF9AC-1F6C-4317-A2AC-8E822C87A56B}', 'HY-{2EE64CDE-75CF-4F8E-B0D1-489D91F288E3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fassadenbekleidung / 650 -> Fassadenbekleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61A15942-5FFF-41F0-9A9A-52D6AA6FB5FD}', 'HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachbelag -> Flachdachbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18BD6D18-053E-457B-A77C-FDDDAE9BAEA1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Flachdachbelag / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18BD6D18-053E-457B-A77C-FDDDAE9BAEA1}', 'HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachbelag / 140 -> Flachdachbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E9A6115-8EFF-4981-BC0C-AC01A3B291B5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Flachdachbelag / 405 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E9A6115-8EFF-4981-BC0C-AC01A3B291B5}', 'HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachbelag / 405 -> Flachdachbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{288796DF-1EE6-4F85-B9CC-7D6CB88D190D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Flachdachbelag-Verschiedene / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{288796DF-1EE6-4F85-B9CC-7D6CB88D190D}', 'HY-{AF0876E7-11DB-45D1-BA66-F2E7B084C8C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Flachdachbelag-Verschiedene / 140 -> Flachdachbelag-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA4790DD-4085-4C5E-A54F-68C60A954D77}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Anhydritfliessmörtel -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18AB325C-4270-4E70-ABDD-1B35F677A1DC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Calciumsulfat-Fliessestrich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18AB325C-4270-4E70-ABDD-1B35F677A1DC}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calciumsulfat-Fliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CCC4D83-82ED-4086-842B-99DFD8A3A10B}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calciumsulfatfliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C56FACA3-353A-4A0D-86EA-603122C5083B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fliessbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C56FACA3-353A-4A0D-86EA-603122C5083B}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessbelag -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BE29165-E11A-41B3-AE94-EB597CF41C5E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fliessestrich / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BE29165-E11A-41B3-AE94-EB597CF41C5E}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich / 140 -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1809BF34-7400-4F87-8338-391FF6E99BB3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fliessestrich CAF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1809BF34-7400-4F87-8338-391FF6E99BB3}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich CAF -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F500F3B-380F-4874-BBF9-3BD40EB8BC20}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Kunstharz-Fliessbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0F500F3B-380F-4874-BBF9-3BD40EB8BC20}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharz-Fliessbelag -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1D7C370-704C-4F44-9ADD-AD087F3EFAE4}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharzfliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5DCC2096-169E-451D-973C-2EFC6E333DC3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Unterlagsboden Anhydrit -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5DCC2096-169E-451D-973C-2EFC6E333DC3}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterlagsboden Anhydrit -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85E2593F-4E2B-465A-AA96-50A125EEC323}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Zement-Kunstharz-Fliessbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85E2593F-4E2B-465A-AA96-50A125EEC323}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zement-Kunstharz-Fliessbelag -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1150F312-A137-45EA-BEC0-95447C34CDA2}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementfliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A05E26A-91EE-40E9-8E2A-6C6E61D41E48}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Zementfliessestrich CTF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A05E26A-91EE-40E9-8E2A-6C6E61D41E48}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementfliessestrich CTF -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52C695FB-0503-40F9-A861-D2288979C701}', 'HY-{7AF3288C-4170-4E1E-BB82-1DA0C3A6F38F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementkunstharzfliessestrich -> Fliessestrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A8F0AEC-7C21-463D-9A02-01516D047E3D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fliessestrich 2K-Epoxidharz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A8F0AEC-7C21-463D-9A02-01516D047E3D}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich 2K-Epoxidharz -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56F60509-30BC-4C69-898B-462557D43E6E}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich Bodenanstrich -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9A56B63-5AEE-4699-AB53-C4370FEA47D0}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich Bodenfarbe -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01F204C5-2121-49D6-B2F2-8A2903EECCBA}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich Epoxidharz -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F88E679E-A3A3-4A2A-97C0-1C720EB9B2DF}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich gestrichen -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFA06C63-D40E-41AA-8EC2-2CF0C0DAABE4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Fliessestrich PU-Bodenfarbe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EFA06C63-D40E-41AA-8EC2-2CF0C0DAABE4}', 'HY-{E0357FA1-10A4-453D-AD7D-30A7A96C2AE9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliessestrich PU-Bodenfarbe -> Fliessestrich Anstrich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32B0693E-9E27-4663-86F2-DFAA60BA203D}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Feinmörtelbelag -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66797BA2-0656-493C-8338-E82DC5C1D572}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- geschlämmt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66797BA2-0656-493C-8338-E82DC5C1D572}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- geschlämmt -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD964F3D-B22E-41C0-B45A-EC55E6BED2E5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- gespachtelt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD964F3D-B22E-41C0-B45A-EC55E6BED2E5}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- gespachtelt -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB34047-7EAB-4CE9-B7E8-05349F82D42F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Gipsspachtel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FB34047-7EAB-4CE9-B7E8-05349F82D42F}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsspachtel -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{447E76A7-3474-4B53-A9A3-4784069B6A5A}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsspachtelung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B63FE963-FD37-43AE-BC31-D84D163309BC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Kunststoffspachtel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B63FE963-FD37-43AE-BC31-D84D163309BC}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffspachtel -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A308454A-D81E-4F60-ABCD-A3A1A24C9F5A}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoffspachtelung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C276057-AAA5-4EFC-98C9-006FB277F887}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schlämmputz -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35E79C68-FDBD-4E93-B6A8-FBDCBDEA1CDD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Schlämmung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35E79C68-FDBD-4E93-B6A8-FBDCBDEA1CDD}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schlämmung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1856BDC9-FDBC-4C69-93C8-918422B0FA23}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:19'); -- Spachtel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1856BDC9-FDBC-4C69-93C8-918422B0FA23}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spachtel -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8325B93B-BC7D-4C16-87B4-B01AC7D5030A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Spachtel-Überzug -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8325B93B-BC7D-4C16-87B4-B01AC7D5030A}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spachtel-Überzug -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F04735A3-D4C5-4864-AC68-D03D42C74925}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Spachtelüberzug -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F04735A3-D4C5-4864-AC68-D03D42C74925}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spachtelüberzug -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA5D5E31-E64B-4FFF-9A26-C66401C46C5E}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spachtelung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F181667-6025-4F01-B467-C8EB0C09E691}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Strahlenschutz-Spachtelputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F181667-6025-4F01-B467-C8EB0C09E691}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Strahlenschutz-Spachtelputz -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7192F1DE-686F-4037-AED8-E8BDDD37A331}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Zementspachtel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7192F1DE-686F-4037-AED8-E8BDDD37A331}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementspachtel -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3435B91-A403-4D1E-8D61-8B6656BC7240}', 'HY-{72525E47-C8F5-47BD-8556-94552136D985}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementspachtelung -> Fugenlose Beschichtung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BFA00AD-31F2-49FA-926C-3215F9FD6CEA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- CH_Gips -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8BFA00AD-31F2-49FA-926C-3215F9FD6CEA}', 'HY-{7636A3CC-FBE2-4679-AB3F-0A3226E1AAAA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Gips -> Gips
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{633E88BC-D251-446F-BFD3-0C260E115380}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gips / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{633E88BC-D251-446F-BFD3-0C260E115380}', 'HY-{7636A3CC-FBE2-4679-AB3F-0A3226E1AAAA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gips / 320 -> Gips
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09A207BE-4BD0-4905-B4A2-83CAA3F1ACCB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gips / 450 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{09A207BE-4BD0-4905-B4A2-83CAA3F1ACCB}', 'HY-{7636A3CC-FBE2-4679-AB3F-0A3226E1AAAA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gips / 450 -> Gips
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C41885D5-F941-495E-970F-8908313793E0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Fermacell -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C41885D5-F941-495E-970F-8908313793E0}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fermacell -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23193933-4E63-47B8-8E30-4F80C032C2AB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Fermacell2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23193933-4E63-47B8-8E30-4F80C032C2AB}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fermacell2 -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BB6E64A-2D87-4DC2-9BF1-51F2D1A0A1CC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- GF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BB6E64A-2D87-4DC2-9BF1-51F2D1A0A1CC}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GF -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DBDB2A00-E574-40D1-BBAE-A0E5562B64C7}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatte -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE81AE5A-F24F-4158-8F1B-F5F40F565A9B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsfaserplatte / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE81AE5A-F24F-4158-8F1B-F5F40F565A9B}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatte / 320 -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B987F2EC-FC71-415A-B981-27F238F0EA4A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsfaserplatte / 330 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B987F2EC-FC71-415A-B981-27F238F0EA4A}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatte / 330 -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{853BB6ED-6580-4CDC-B6C3-7CECAC8BBC14}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsfaserplatte2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{853BB6ED-6580-4CDC-B6C3-7CECAC8BBC14}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatte2 -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC7E395F-6248-416B-AE36-2FBAA8A0AFB9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsfaserplatten2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC7E395F-6248-416B-AE36-2FBAA8A0AFB9}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsfaserplatten2 -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62E0F9BA-E14F-4DED-AD9F-3D9B6A44D91B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Rigidur -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{62E0F9BA-E14F-4DED-AD9F-3D9B6A44D91B}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rigidur -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63E44B77-689F-4591-916C-E8296B6011BC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Vidiwall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63E44B77-689F-4591-916C-E8296B6011BC}', 'HY-{07F10942-E9F9-4145-A89D-56883C43E55D}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vidiwall -> Gipsfaserplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA4021AA-E890-4555-A321-3D71FBCB37C3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Decke - Gipskarton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA4021AA-E890-4555-A321-3D71FBCB37C3}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decke - Gipskarton -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0364DA24-9C5F-4C2E-8F38-DCCE7AFC89F2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gelochte Gipskartonplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0364DA24-9C5F-4C2E-8F38-DCCE7AFC89F2}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gelochte Gipskartonplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{233D35B6-2A21-41C0-AC28-A265D662B15B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Geschlitzte Gipskartonplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{233D35B6-2A21-41C0-AC28-A265D662B15B}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Geschlitzte Gipskartonplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6222EFC0-B64C-476E-9116-6CA15A53EED2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsbauplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6222EFC0-B64C-476E-9116-6CA15A53EED2}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsbauplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F803419A-E940-47BF-A7B3-BFCA58DB8324}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F803419A-E940-47BF-A7B3-BFCA58DB8324}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsbauplatten -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{286F2714-72CE-4CDA-8C86-4B3F483E375B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskarton / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{286F2714-72CE-4CDA-8C86-4B3F483E375B}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskarton / 320 -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC66926A-9FE6-42EB-A43F-84D09632823D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskarton gelocht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC66926A-9FE6-42EB-A43F-84D09632823D}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskarton gelocht -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BF6A62-64C4-4215-A708-73F27263240C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskarton2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2BF6A62-64C4-4215-A708-73F27263240C}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskarton2 -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD1D8CD7-7A9C-4EDC-BDAE-3C4ADA58DC65}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3DAC9A5A-B27B-43A0-9336-CBF07A76BF6A}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatte gelocht -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A772FB0-896B-4BC7-933F-51C884A11C0D}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatte geschlitzt -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DF4DFDC-70F3-405E-AAF8-AAF112F77570}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskartonplatte2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DF4DFDC-70F3-405E-AAF8-AAF112F77570}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatte2 -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5352110-11A7-4C65-B9E7-B10B99B5BDD4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskartonplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5352110-11A7-4C65-B9E7-B10B99B5BDD4}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatten -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC3DB159-5C7C-4746-9C2F-5C1930B21234}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskartonplatten geschlitzt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC3DB159-5C7C-4746-9C2F-5C1930B21234}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatten geschlitzt -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91681745-9631-480C-BDA1-06E493334DA0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskartonplatten2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91681745-9631-480C-BDA1-06E493334DA0}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonplatten2 -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D5DBD5-4632-4429-BDF1-E3820D53C013}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipslochplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D5DBD5-4632-4429-BDF1-E3820D53C013}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipslochplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA518AE6-BE92-4163-ACE9-598D67852A63}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipslochplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA518AE6-BE92-4163-ACE9-598D67852A63}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipslochplatten -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2093A3C-6AAF-4998-AB62-40A3D18DDE08}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2093A3C-6AAF-4998-AB62-40A3D18DDE08}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDEBBB66-7577-4835-9944-A0F4931197DC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatte horizontal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDEBBB66-7577-4835-9944-A0F4931197DC}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatte horizontal -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D919F4C0-5507-4B7F-A7F1-FFC69A480FA9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatte imprägniert horizontal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D919F4C0-5507-4B7F-A7F1-FFC69A480FA9}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatte imprägniert horizontal -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{368E8A74-4D17-4F8A-A1D3-605C94BE2103}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatte imprägniert vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{368E8A74-4D17-4F8A-A1D3-605C94BE2103}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatte imprägniert vertikal -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAAE82C7-43E1-4713-B6E3-46CBCB375273}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatte vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAAE82C7-43E1-4713-B6E3-46CBCB375273}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatte vertikal -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2714E3B1-BDF8-4284-8835-D03EE613C3CE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2714E3B1-BDF8-4284-8835-D03EE613C3CE}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsplatten -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5537C23-04E2-4AB9-B47C-0B8095877D13}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- GKFI -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5537C23-04E2-4AB9-B47C-0B8095877D13}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GKFI -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9879AB0-142F-46C0-BD26-9BA9C565C3A1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- GKP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9879AB0-142F-46C0-BD26-9BA9C565C3A1}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GKP -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{954226D6-0A78-42C5-A387-18EADE6AC2E7}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartgipsplatte -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5388106C-A36B-45A8-B0AA-57A5E3FDEB20}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Rigips -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5388106C-A36B-45A8-B0AA-57A5E3FDEB20}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rigips -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{816D3731-4453-43D1-A5E2-DBDF8DC94C39}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Rigips2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{816D3731-4453-43D1-A5E2-DBDF8DC94C39}', 'HY-{90548505-E1F4-4A0E-88C6-36E74F57D019}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rigips2 -> Gipskarton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AADB5D4-1847-47CC-B7FF-2E107DAF6BE6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Fenster - Glas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AADB5D4-1847-47CC-B7FF-2E107DAF6BE6}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Glas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58AD2F75-D09A-4ADC-B82C-2AF7CE0475F8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Glas - Klarglas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58AD2F75-D09A-4ADC-B82C-2AF7CE0475F8}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas - Klarglas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87A382E9-F74A-4A0B-9B56-DB646E5EF9AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Glas - Mattglas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87A382E9-F74A-4A0B-9B56-DB646E5EF9AF}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas - Mattglas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF855B1-5DAC-4FE1-864C-F3EC30C7BD7A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Glas / 530 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEF855B1-5DAC-4FE1-864C-F3EC30C7BD7A}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas / 530 -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48560052-DA1F-436D-A408-0F3CFDE6B6C2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Glas Normalglas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48560052-DA1F-436D-A408-0F3CFDE6B6C2}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas Normalglas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC3E5615-5004-46C4-86B8-AAD969409883}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glastrennwand -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{925D8704-D265-4BDC-955C-90CF62059451}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Tür - Glas -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{925D8704-D265-4BDC-955C-90CF62059451}', 'HY-{D25C4181-0BA4-4060-8D53-3FC421D4F07F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tür - Glas -> Glas
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{588030C7-EDED-4175-AAF0-97944777168F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Glas - Glasbaustein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{588030C7-EDED-4175-AAF0-97944777168F}', 'HY-{34324FDE-37CE-42A5-A789-56DA759C5DB5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glas - Glasbaustein -> Glasbaustein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E763BD5D-C41A-4277-B1DE-47224145E3E0}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1BA867B-0353-44BF-8AF5-C284BD8733E7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipsgrundputz geglättet -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1BA867B-0353-44BF-8AF5-C284BD8733E7}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsgrundputz geglättet -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B89A134-8A54-4241-9B3B-8BD31FEE0A58}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Gipskalkgrundputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B89A134-8A54-4241-9B3B-8BD31FEE0A58}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskalkgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB29B77F-D255-49A5-8E29-235BA8E1DE5F}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkgipsgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D066A71E-5C54-4E3E-9199-6B5735E606EB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Kalkgrundputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D066A71E-5C54-4E3E-9199-6B5735E606EB}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81DC2B42-4B9F-4139-AA03-B819B8CA1F97}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkzementgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9FEC927-9AE6-42BC-9F08-44FD9EDD175B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:20'); -- Strahlenschutz-Grundputz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9FEC927-9AE6-42BC-9F08-44FD9EDD175B}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Strahlenschutz-Grundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B023EA49-F408-4BD2-9DAE-ED68EEDAA185}', 'HY-{0CAEEF79-7E79-4EC0-AE65-8F8F86615E55}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementgrundputz -> Grundputz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F1E5B50-4AB8-4E0D-A531-23466B190844}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Hartbeton / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8F1E5B50-4AB8-4E0D-A531-23466B190844}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartbeton / 320 -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA22A6A-D59B-415A-A48F-34FF9A62E3C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Hartbeton kunstharzvergütet -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA22A6A-D59B-415A-A48F-34FF9A62E3C6}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartbeton kunstharzvergütet -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FE6E28D9-9A2D-4202-96BF-5C4C81FA7E6A}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartbetonbelag -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16C97787-A481-4065-AB84-CE0688F6C7A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Hartbetonbelag kunstharzvergütet -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16C97787-A481-4065-AB84-CE0688F6C7A8}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartbetonbelag kunstharzvergütet -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDAD41E8-5035-4BD7-B9E2-311816713022}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Kunstharz-Hartbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDAD41E8-5035-4BD7-B9E2-311816713022}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharz-Hartbeton -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{167785CD-D5A0-4390-9709-C28E661B3EA6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Kunstharz-Hartbetonbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{167785CD-D5A0-4390-9709-C28E661B3EA6}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharz-Hartbetonbelag -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31709897-80B0-4110-A56E-77CFD4B0840B}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharzhartbeton -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1008D2B-6D08-4FCE-8105-07EFAA59DF48}', 'HY-{D7C96004-FA5C-4EDD-B7B8-CCA79DC4C2E4}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharzhartbetonbelag -> Hartbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE069FD0-4B78-4F76-A656-4238EBAF33DC}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hinterlüftung -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB289272-415D-4B3A-A8E5-0CD27F8E0837}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leer -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C476E3B-E05F-4AD6-9973-411631B9AEDC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- leer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5C476E3B-E05F-4AD6-9973-411631B9AEDC}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- leer -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3400ADD4-D23A-4FBD-A733-1369EA142F0B}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leer2 -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7864122-F1E6-4C00-8460-5D546493A910}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Leerraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7864122-F1E6-4C00-8460-5D546493A910}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leerraum -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92332AE0-269E-45C3-9939-48973DB07C6A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Leerschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92332AE0-269E-45C3-9939-48973DB07C6A}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leerschicht -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56D5EFFF-16E4-41AE-9AEA-BDF48C2BCC49}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{547BC560-3238-46D4-AFF2-D041809D4E2D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luft vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{547BC560-3238-46D4-AFF2-D041809D4E2D}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft vertikal -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA3889C9-C4DB-46A4-9C7B-8FCC35EF9A85}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luft, horizontal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BA3889C9-C4DB-46A4-9C7B-8FCC35EF9A85}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft, horizontal -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF85DDB2-F06D-46F0-849C-41968B46AFA4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luft, horizontal / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF85DDB2-F06D-46F0-849C-41968B46AFA4}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft, horizontal / 300 -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AD18FBA-3AE1-46D5-91FE-9B40F73B903A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luft, vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9AD18FBA-3AE1-46D5-91FE-9B40F73B903A}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft, vertikal -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07E62B4B-0D5B-41A6-A958-55069FC66F0F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luft, vertikal / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07E62B4B-0D5B-41A6-A958-55069FC66F0F}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft, vertikal / 300 -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A56842B-6A11-4CE6-A761-5638DF6AA0F4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luftraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2A56842B-6A11-4CE6-A761-5638DF6AA0F4}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luftraum -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6B1EAFA-1D56-4E99-B329-1427A159FB64}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luftschicht -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E9EF92-60F4-4E26-B7A1-CB669F0EFF69}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luftschicht vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E9EF92-60F4-4E26-B7A1-CB669F0EFF69}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luftschicht vertikal -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B6209D9-6734-4B5A-97FF-4D26EFA334F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Luftschicht, vertikal -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8B6209D9-6734-4B5A-97FF-4D26EFA334F0}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luftschicht, vertikal -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41C6F6A6-9560-4232-BDAC-69D678432AED}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Standard - Luftschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41C6F6A6-9560-4232-BDAC-69D678432AED}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Standard - Luftschicht -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A0FE1387-1032-49F8-8035-9D82DCFEFF84}', 'HY-{263420C3-0C44-48CB-B8BC-F4D04FFD5829}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zwischenraum -> Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D1D3406-01B0-4985-8D09-4457EC4FC0FF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Fenster - Holz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D1D3406-01B0-4985-8D09-4457EC4FC0FF}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B6B2298-5B92-40F5-9681-F25C43632E2D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Fenster - Holz 1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B6B2298-5B92-40F5-9681-F25C43632E2D}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Holz 1 -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3B3E298-71F7-4F4B-A4D4-E59143DA8A72}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Fenster - Rahmen Holz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3B3E298-71F7-4F4B-A4D4-E59143DA8A72}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Rahmen Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD54DF3F-BA3E-4F25-8FEF-CB75319CB3FB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Geländer - Holz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD54DF3F-BA3E-4F25-8FEF-CB75319CB3FB}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Geländer - Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFDC917B-2BFF-4CCF-A222-31D4D3B86C55}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz - Kirschbaum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFDC917B-2BFF-4CCF-A222-31D4D3B86C55}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz - Kirschbaum -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A10AC3A-A338-44C2-A1A8-2810A5FD9598}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz - Kirsche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A10AC3A-A338-44C2-A1A8-2810A5FD9598}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz - Kirsche -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE6FDAAA-A997-403E-90ED-A32C64376062}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz / 600 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE6FDAAA-A997-403E-90ED-A32C64376062}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz / 600 -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE09697D-680A-46E1-8009-583F00DAB853}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Ahorn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE09697D-680A-46E1-8009-583F00DAB853}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Ahorn -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8DE83F3-D914-4D86-BB1C-099D3B1CBE96}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Buche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8DE83F3-D914-4D86-BB1C-099D3B1CBE96}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Buche -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{543DBADE-896C-42F0-9C17-95CC18A33BB5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Eiche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{543DBADE-896C-42F0-9C17-95CC18A33BB5}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Eiche -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC2A05DB-7B16-4AA0-83E5-7F1C3266799C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Esche Olive -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC2A05DB-7B16-4AA0-83E5-7F1C3266799C}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Esche Olive -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCA23E63-F03B-46D3-9CE7-97F9DD70FECA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Fichte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCA23E63-F03B-46D3-9CE7-97F9DD70FECA}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Fichte -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88284F30-6AF1-475C-A662-CFD6E4B5F3E0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Kiefer Ast -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88284F30-6AF1-475C-A662-CFD6E4B5F3E0}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Kiefer Ast -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9376B1FF-328A-4843-B4D2-BD1DF3EF7274}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Kirsche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9376B1FF-328A-4843-B4D2-BD1DF3EF7274}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Kirsche -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F1E3279-6D8B-49E0-BAB2-42A9DB182CD7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Lärche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7F1E3279-6D8B-49E0-BAB2-42A9DB182CD7}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Lärche -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0DBAA00-EAE0-4718-877C-0CDAFBFFB951}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz Nussbaum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D0DBAA00-EAE0-4718-877C-0CDAFBFFB951}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz Nussbaum -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFA4A536-FB5D-420A-AF98-FE2D680EC71B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz, Konstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DFA4A536-FB5D-420A-AF98-FE2D680EC71B}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz, Konstruktion -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BFCB598-C337-46EC-A957-6CDBC50D0205}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz, Konstruktion / 550 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BFCB598-C337-46EC-A957-6CDBC50D0205}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz, Konstruktion / 550 -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5184ECF-46AD-4776-9F8E-080BA795225A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz, Konstruktion / 750 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5184ECF-46AD-4776-9F8E-080BA795225A}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz, Konstruktion / 750 -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8E1FCA2-34C9-4E7E-84F0-884F75A7075C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holz, massiv -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8E1FCA2-34C9-4E7E-84F0-884F75A7075C}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz, massiv -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6DEFE768-215F-4837-AFF9-451315801959}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzkonstruktion -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEDF15FB-4BF0-4175-BA79-CDF7D8ED3989}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Rahmen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AEDF15FB-4BF0-4175-BA79-CDF7D8ED3989}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rahmen -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99981932-7AB4-429A-A6A5-6E6CBECE9041}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Tragwerk - Holz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{99981932-7AB4-429A-A6A5-6E6CBECE9041}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragwerk - Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C13F7FEA-2625-4F2A-98B3-CA5701025832}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Tragwerk - Holz 1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C13F7FEA-2625-4F2A-98B3-CA5701025832}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragwerk - Holz 1 -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39051091-E62E-44EA-8466-CE68635BCB5C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Treppe - Holz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39051091-E62E-44EA-8466-CE68635BCB5C}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Treppe - Holz -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{486E8795-7FBA-45BF-8539-5377EBDCA455}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Tür - Holzrahmen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{486E8795-7FBA-45BF-8539-5377EBDCA455}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tür - Holzrahmen -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC862169-B7A6-4C5B-85BC-0B48860D315C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Tür - Holztürblatt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC862169-B7A6-4C5B-85BC-0B48860D315C}', 'HY-{9EE6B44F-F00D-4697-AA06-77614EA755A9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tür - Holztürblatt -> Holz
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDA51DAA-0F91-48AF-8367-9F0BA90B3867}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Dach - Latten/Verkleidung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDA51DAA-0F91-48AF-8367-9F0BA90B3867}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Latten/Verkleidung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9594308C-51E7-4C80-BE5F-40BED09A96EA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Dachlatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9594308C-51E7-4C80-BE5F-40BED09A96EA}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachlatte -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5C7E42-DD3C-42C9-96C8-4F9D3AD8ECC8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Dachlatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5C7E42-DD3C-42C9-96C8-4F9D3AD8ECC8}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachlatten -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7861717E-13DA-4305-8DBB-A63E5ADB6055}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachlattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D27A4338-5DEE-41E7-A252-19C5DDBA8D1F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Dachlattung / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D27A4338-5DEE-41E7-A252-19C5DDBA8D1F}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachlattung / 300 -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ACF84B1-9616-4161-8996-1C3057853D17}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Holzlatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ACF84B1-9616-4161-8996-1C3057853D17}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzlatten -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B2D677A-920D-422F-8E7A-12E4DAFC09A8}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzlattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C54E958E-3205-4A9A-8CC6-F59A7FD48D0C}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzunterkonstruktion -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5AF9423-0408-4103-8FFE-5E950896DEA2}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Horizontallattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BA292C8-B9B4-4582-A928-7CE733E78E3B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Latte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BA292C8-B9B4-4582-A928-7CE733E78E3B}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Latte -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1ABDF75-600E-446E-984C-BC9C998E7A3B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:21'); -- Latten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1ABDF75-600E-446E-984C-BC9C998E7A3B}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Latten -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{316A773B-97FD-4230-9C51-08065B16A225}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75189DF2-3DA9-4BAB-AC72-BE90D5F8CE51}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Lattung / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75189DF2-3DA9-4BAB-AC72-BE90D5F8CE51}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung / 300 -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8C813C80-92FB-4A59-A4D3-491631E7C58B}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung hinterlüftet -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B97289B-DCE5-4989-9DC0-863F05DBC3CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Lattung/Hinterlüftung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B97289B-DCE5-4989-9DC0-863F05DBC3CD}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung/Hinterlüftung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CAA9BB07-84D1-4E93-A3E1-7F96C696895C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Luft / Holzlattung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CAA9BB07-84D1-4E93-A3E1-7F96C696895C}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Luft / Holzlattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35659FF6-B868-4D54-B1E6-D1F07BCD049F}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Querlattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD808C70-C14A-4562-92EF-A38EF363195A}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiftlattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37F799E3-EF78-44C3-9125-A30DA8469753}', 'HY-{9E3F2CCB-FCD8-47AE-95A7-0F4F21845761}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegellattung -> Holz-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE79EA22-AB44-41A7-9309-C8C6517C97CF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzlatten-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AE79EA22-AB44-41A7-9309-C8C6517C97CF}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzlatten-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37B08A22-A83D-41AF-9B08-CBEDD7F7EF04}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzlattung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37B08A22-A83D-41AF-9B08-CBEDD7F7EF04}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzlattung-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2B701457-3A9C-4D28-90C1-2821D1BE29DA}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzunterkonstruktion Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA315943-FFC0-43E0-897E-150A486F355D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Horizontallattung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA315943-FFC0-43E0-897E-150A486F355D}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Horizontallattung-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{830F085F-ACC6-4142-9B5A-00C2DF73A715}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Latte-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{830F085F-ACC6-4142-9B5A-00C2DF73A715}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Latte-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36F53CEB-258E-4720-8354-ECBB4CE51BF8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Latten-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36F53CEB-258E-4720-8354-ECBB4CE51BF8}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Latten-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D91C063-C76F-40D1-B77A-139FAC54C686}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Lattung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D91C063-C76F-40D1-B77A-139FAC54C686}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD4BB187-E700-4DB5-875E-1F7B6C77703B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Lattung-Innen / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD4BB187-E700-4DB5-875E-1F7B6C77703B}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lattung-Innen / 300 -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C468FF4F-6BFB-4FAB-AD01-19A3662E7AAA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Querlattung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C468FF4F-6BFB-4FAB-AD01-19A3662E7AAA}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Querlattung-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20657590-C620-486A-9BBF-5B4723CDC9CA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Schiftlattung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20657590-C620-486A-9BBF-5B4723CDC9CA}', 'HY-{F3350E71-B335-4DC8-A7AB-B2618A1B4628}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiftlattung-Innen -> Holz-Unterkonstruktion-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2AF7AD1-47C0-4543-9858-868314DA6634}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Konterlatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2AF7AD1-47C0-4543-9858-868314DA6634}', 'HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Konterlatte -> Holz-Unterkonstruktion-Konter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29392127-022E-4EDA-8EDD-C4A0232C7EC1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Konterlatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29392127-022E-4EDA-8EDD-C4A0232C7EC1}', 'HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Konterlatten -> Holz-Unterkonstruktion-Konter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A3457C6-22E5-43CA-80B2-F0ED64BFC862}', 'HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Konterlattung -> Holz-Unterkonstruktion-Konter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEED4BF6-49F1-477A-9E4B-5F61812BC0E7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Konterlattung / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEED4BF6-49F1-477A-9E4B-5F61812BC0E7}', 'HY-{08060DE8-0839-4F1B-951A-35BE76263618}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Konterlattung / 300 -> Holz-Unterkonstruktion-Konter
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{520F1261-05D6-4C15-AD0B-83C0596B8798}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzrahmen -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{332A0923-5807-440A-83FE-918A48C2582E}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzrahmenbau -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0301E547-F442-4B54-85AC-0783919D9E6E}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzrahmenwand -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45B323C2-A99A-4C86-8BE4-564121501153}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständerwand -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA0FCDC1-4017-4745-BE85-50EC3D61B6AC}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holztafelbau -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3EA0ECA-ACFE-42F8-BEF2-D370EC0030F9}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holztragwerk -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4164EA41-A33A-4167-AB7E-92AFA8F128D3}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Riegelwand -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66DE9B08-02F4-4D53-8452-D17C6B9E574B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Ständerbau-Wand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{66DE9B08-02F4-4D53-8452-D17C6B9E574B}', 'HY-{BDD906F8-19A5-4634-895D-B780612FE834}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständerbau-Wand -> Holzbausystem
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6F06C7AE-52C6-4B3B-944D-2ABFC8B4C2F0}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Blockwand -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDABFA59-3CDF-4609-B8ED-AC1C8ED7A218}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz massiv -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD24AFDF-9D56-4956-9FDA-C616360E9C0E}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz_massiv -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5AE5514-E0B4-4312-8951-E5F353332854}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzbau massiv -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5AE5514-E0B4-4312-8951-E5F353332854}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzbau massiv -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B25A1F1D-D74B-4FAD-8D71-9864496F8A48}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzbausystem-Massiv -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B25A1F1D-D74B-4FAD-8D71-9864496F8A48}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzbausystem-Massiv -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DD91E66-77A3-4930-8401-BBBC1612D9D6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzblocktafel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7DD91E66-77A3-4930-8401-BBBC1612D9D6}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzblocktafel -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{053BF56B-E3F1-4CFB-BA3F-1C2FE8CA14F2}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzblocktafelung -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B94AD0A-5DF4-451F-9A46-8479F332CF56}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Massiv-Holz-Mauer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B94AD0A-5DF4-451F-9A46-8479F332CF56}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massiv-Holz-Mauer -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D15DFD35-A7E5-4382-84AA-144003FC28CB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- MHM -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D15DFD35-A7E5-4382-84AA-144003FC28CB}', 'HY-{C9D5A58D-493B-4E61-9B05-F4220E2D8667}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MHM -> Holzbausystem-massiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6EBDBBC-AAB8-4AD5-84D7-196C77C3C842}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Abgesperrtes Parkett -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6EBDBBC-AAB8-4AD5-84D7-196C77C3C842}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Abgesperrtes Parkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A28121FE-0F01-42F8-9CD1-9C70F287F9A0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Absperrparkett -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A28121FE-0F01-42F8-9CD1-9C70F287F9A0}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Absperrparkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11DC53EE-ED75-49F2-9461-F2BACD3074CC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Estrich+Parkett -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{11DC53EE-ED75-49F2-9461-F2BACD3074CC}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich+Parkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6C10AF3-49EB-4C4C-9FB1-066EAB0E48DC}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1B028862-D4E8-4672-9C67-85A226E52CBE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkettboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1B028862-D4E8-4672-9C67-85A226E52CBE}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkettboden -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E13AC55-0060-4972-873A-F67DEDBFA46B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holz - Dielen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E13AC55-0060-4972-873A-F67DEDBFA46B}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz - Dielen -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63E8CA51-D60A-42CA-ADF5-E01CE243BBF5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzboden / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63E8CA51-D60A-42CA-ADF5-E01CE243BBF5}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden / 140 -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{47AB55D5-DD5F-4459-9FBC-88D043125EEB}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzdielen -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{472446CB-2673-44EC-8F63-7DEC34BD731D}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzpflaster -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10976E94-439E-48A2-A6EE-A5A1FEB45EBD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzpflasterboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10976E94-439E-48A2-A6EE-A5A1FEB45EBD}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzpflasterboden -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBC86339-D568-4069-9C31-016626F62E24}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzrost -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7531F70-FB95-4DCD-86AA-3771AE309CBB}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klebeparkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A5A17AA-FBE2-40D1-9117-5DAD3E6EE9F8}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCE341F9-676E-4430-9309-42730D2812BE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Laminatboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BCE341F9-676E-4430-9309-42730D2812BE}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminatboden -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A49EA5C-BC01-4454-85CD-14639EF6EB45}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DE79FD5-E185-421C-9C36-A5567CA64525}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D524258-9D7A-49B3-830F-20576A161813}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Parkettboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3D524258-9D7A-49B3-830F-20576A161813}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkettboden -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FD752C8C-BCF1-4CBD-B3BF-499F44203DE2}', 'HY-{679EEEC8-329D-4A67-804E-3AD47D3B0E23}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stirnholzparkett -> Holzboden
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A7DD0EF-363F-4178-AB77-5A183EF8543D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8A7DD0EF-363F-4178-AB77-5A183EF8543D}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett neu -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0284B695-F766-455A-B467-67D23A3641CF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0284B695-F766-455A-B467-67D23A3641CF}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC9EB88C-BF38-4E5C-B0A9-FB0FDC0CEB87}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC9EB88C-BF38-4E5C-B0A9-FB0FDC0CEB87}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett renoviert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5F2AAC1-7A1A-474E-995B-F744E7D04DA8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5F2AAC1-7A1A-474E-995B-F744E7D04DA8}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett saniert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1FC7271-0348-465D-B771-6003AF5E9E03}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1FC7271-0348-465D-B771-6003AF5E9E03}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECBE07EA-E6F8-4F06-BF8E-C6EBCA5A5F44}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECBE07EA-E6F8-4F06-BF8E-C6EBCA5A5F44}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett-Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D75C698-4292-4E56-829F-50CE11A9BEF5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Fertigparkett-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9D75C698-4292-4E56-829F-50CE11A9BEF5}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigparkett-Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B3AC649-6973-4974-982D-FA124F21C698}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzboden neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B3AC649-6973-4974-982D-FA124F21C698}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden neu -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68A22DE9-53F0-43A0-8F90-8FF4A2C131EA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzboden renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68A22DE9-53F0-43A0-8F90-8FF4A2C131EA}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden renoviert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D281A27-F150-44D3-BF87-045C7D956270}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzboden-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D281A27-F150-44D3-BF87-045C7D956270}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden-Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDDED0B4-6BF4-4B5F-977F-FCFF126DB4BD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Holzboden-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDDED0B4-6BF4-4B5F-977F-FCFF126DB4BD}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzboden-Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B76D45A0-2984-4821-94CF-A53FBC3A4320}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Laminat neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B76D45A0-2984-4821-94CF-A53FBC3A4320}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat neu -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE4A5A66-B94F-47CA-AAB1-61A27C3CEDF7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:22'); -- Laminat Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE4A5A66-B94F-47CA-AAB1-61A27C3CEDF7}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A41A9CA5-0DE7-4A90-8615-11E99E46DA03}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Laminat renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A41A9CA5-0DE7-4A90-8615-11E99E46DA03}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat renoviert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83E9B1A6-9CC4-4BA4-934A-B736E0A096A1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Laminat saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83E9B1A6-9CC4-4BA4-934A-B736E0A096A1}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat saniert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B58E4C1C-BA4C-4C3F-B868-2265E86D1F56}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Laminat Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B58E4C1C-BA4C-4C3F-B868-2265E86D1F56}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96FF1A0F-D302-4DAE-A4D9-FBD74CEE6978}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Laminat-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96FF1A0F-D302-4DAE-A4D9-FBD74CEE6978}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat-Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6766BC0-4FDE-43F4-BEE4-FA8F94A71F49}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Laminat-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6766BC0-4FDE-43F4-BEE4-FA8F94A71F49}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Laminat-Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5C3FF34-B113-4D18-AD91-877E21E7FAC7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5C3FF34-B113-4D18-AD91-877E21E7FAC7}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett neu -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C8900B71-5E9D-4502-B39D-CA741FCE592F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C8900B71-5E9D-4502-B39D-CA741FCE592F}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1329F312-488A-4C67-9D0F-DC5A66F4B75D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1329F312-488A-4C67-9D0F-DC5A66F4B75D}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett renoviert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0CB2B68-692D-4D91-B803-A7E33B383FFD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0CB2B68-692D-4D91-B803-A7E33B383FFD}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett saniert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B306FB9F-1FB3-45EC-85B6-066679776784}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B306FB9F-1FB3-45EC-85B6-066679776784}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC68A852-254C-42F9-96FD-D0E3A9753A6F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC68A852-254C-42F9-96FD-D0E3A9753A6F}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett-Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E283BA25-C1BF-46C6-BD0D-0BB9A2AED737}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Massivparkett-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E283BA25-C1BF-46C6-BD0D-0BB9A2AED737}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massivparkett-Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19768296-27A2-4F6E-89C3-E1D2B93B37B4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19768296-27A2-4F6E-89C3-E1D2B93B37B4}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett neu -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49260ED6-1EC9-465F-8611-05932F81E207}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49260ED6-1EC9-465F-8611-05932F81E207}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC5680B8-0A76-4226-8522-4D29B736E971}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC5680B8-0A76-4226-8522-4D29B736E971}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett renoviert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{389C0071-2365-4889-A721-43A223110955}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{389C0071-2365-4889-A721-43A223110955}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett saniert -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED2D5102-0D31-452F-BD1A-EE743718A309}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED2D5102-0D31-452F-BD1A-EE743718A309}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7650A7B9-AFCF-4CBA-B33C-EFC1F7F73A0E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7650A7B9-AFCF-4CBA-B33C-EFC1F7F73A0E}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett-Renovation -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B6D3BFB-6392-452E-9CB3-346BF28C8596}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Parkett-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5B6D3BFB-6392-452E-9CB3-346BF28C8596}', 'HY-{67B651CE-AA74-4930-85A6-80EFD796AF6E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Parkett-Sanierung -> Holzboden Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{89C71DF7-2B8E-44F8-BFEA-B95D77A3B8EE}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartfaserplatte -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5314DD7-EF25-4B5E-97C4-C685B7169F84}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Hartfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5314DD7-EF25-4B5E-97C4-C685B7169F84}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartfaserplatten -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23B23BD7-FC54-40C6-9312-ABA04EC45816}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- HDF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23B23BD7-FC54-40C6-9312-ABA04EC45816}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- HDF -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8105275E-CD7F-4AC8-BD76-C5DBF62D84C5}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzfaserdämmung -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45343160-EC11-41F3-BADD-CF223D414DE4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holzfaserplatte / 500 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45343160-EC11-41F3-BADD-CF223D414DE4}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzfaserplatte / 500 -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9BDDFFE-E073-40DB-BD20-B045A0F30215}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holzfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9BDDFFE-E073-40DB-BD20-B045A0F30215}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzfaserplatten -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0161F27F-B09B-4D8E-A874-30467B6C1014}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Isoroof -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0161F27F-B09B-4D8E-A874-30467B6C1014}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Isoroof -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACC38D44-3001-42B6-B348-D402F89E7B35}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- MDF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACC38D44-3001-42B6-B348-D402F89E7B35}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MDF -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6B86C878-3C6D-47C6-B09C-B60F1F0C2773}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mitteldichte Faserplatte -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44AA48B3-2740-49D9-BBBB-49807A35E3A9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Mitteldichte Holzfaserplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44AA48B3-2740-49D9-BBBB-49807A35E3A9}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mitteldichte Holzfaserplatte -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92AA9062-3F81-4125-9775-E79164DB4667}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Pavatex -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{92AA9062-3F81-4125-9775-E79164DB4667}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pavatex -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC4DA7AD-63AC-4B75-8C9C-6151FFEDE722}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Pavatherm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC4DA7AD-63AC-4B75-8C9C-6151FFEDE722}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pavatherm -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5032857-9457-494B-84B3-5F68AE90E2F1}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weichfaserplatte -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F10D92FD-5622-4F85-A965-78B439B7CBCE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Weichfaserplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F10D92FD-5622-4F85-A965-78B439B7CBCE}', 'HY-{B0D443C1-73B3-4BF7-B6D6-0E7C8CE31A1F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Weichfaserplatten -> Holzfaserplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC141699-CF21-4640-B313-BE3A55F4D406}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Hohlkasten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC141699-CF21-4640-B313-BE3A55F4D406}', 'HY-{85A91D6B-777C-46E5-960B-C71689A613BD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlkasten -> Holzkastenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7DEFB80-4B6A-4DB8-A164-7934A8D70B96}', 'HY-{85A91D6B-777C-46E5-960B-C71689A613BD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hohlkastensystem -> Holzkastenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BCA9219-45C2-44A8-8EEE-098A571FB101}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Kastenelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BCA9219-45C2-44A8-8EEE-098A571FB101}', 'HY-{85A91D6B-777C-46E5-960B-C71689A613BD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kastenelement -> Holzkastenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D67BDE7-4111-40A4-B66D-A7D59BFA7C85}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz-Alu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8D67BDE7-4111-40A4-B66D-A7D59BFA7C85}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Alu -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0AEBA150-A369-499F-A7E0-D7D0A3DE94E2}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Aluminium -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A464856-1A9A-4ACD-B727-BFDE8FDBE45C}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Metall -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF33C59A-FD1F-402E-8E13-7C692049DE49}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz/Alu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF33C59A-FD1F-402E-8E13-7C692049DE49}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz/Alu -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E42E0BD9-14EA-419C-82A6-F4F5B4734A56}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz/Aluminium -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E42E0BD9-14EA-419C-82A6-F4F5B4734A56}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz/Aluminium -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0A80D25-D070-4A43-A7EA-C800A6410625}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz/Metall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C0A80D25-D070-4A43-A7EA-C800A6410625}', 'HY-{C626D104-83FD-45E6-93E6-2C7541C5B7E1}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz/Metall -> Holzmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB0C0643-3C9C-4CFD-98AA-67C24793EC55}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holzriemen / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB0C0643-3C9C-4CFD-98AA-67C24793EC55}', 'HY-{C09446EE-A15E-4488-B9AF-F3CFA786AC16}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzriemen / 140 -> Holzriemen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{010019A2-A0B2-404B-BA86-56F2DA8C2878}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Riemen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{010019A2-A0B2-404B-BA86-56F2DA8C2878}', 'HY-{C09446EE-A15E-4488-B9AF-F3CFA786AC16}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Riemen -> Holzriemen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D50A602B-AB65-43E8-B1B0-AC7CE0240181}', 'HY-{C09446EE-A15E-4488-B9AF-F3CFA786AC16}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Riemenboden -> Holzriemen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{824F0081-AE28-4664-B6D6-31AD4CC22BAA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Rippenelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{824F0081-AE28-4664-B6D6-31AD4CC22BAA}', 'HY-{FE079A17-7FA3-4703-AD16-E4E9DED71FD0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rippenelement -> Holzrippenplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBA64ABA-CF74-47BF-BDA9-E01278B11EF5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- CH_Holz_Sperrholz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBA64ABA-CF74-47BF-BDA9-E01278B11EF5}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Holz_Sperrholz -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E323AB1C-558C-4C25-B2E6-CF763B6FF7B1}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dreischichtplatte -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D67C8CF-08B8-40DB-AD4E-9E0FE1FF341C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Dreischichtplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D67C8CF-08B8-40DB-AD4E-9E0FE1FF341C}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dreischichtplatten -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D632B82-3D2E-42A4-AD9C-4F2DA13DD092}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- DSP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0D632B82-3D2E-42A4-AD9C-4F2DA13DD092}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- DSP -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5DDCABB-FB75-467E-9504-141F4B8D8B57}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz - Sperrholz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5DDCABB-FB75-467E-9504-141F4B8D8B57}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz - Sperrholz -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{480374F9-7395-4214-A5C3-0021988C79EF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holz - Sperrholz1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{480374F9-7395-4214-A5C3-0021988C79EF}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz - Sperrholz1 -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{446162F5-FB3F-4486-AFC6-ED898FC079E7}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzschichtplatte -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{390BCFC2-5749-4AE7-9180-37B41C34A229}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Sperrholz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{390BCFC2-5749-4AE7-9180-37B41C34A229}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrholz -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26D73B71-AFFD-4053-9147-CC1FBB0C0A0E}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrholzplatte -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3CAC208-E3F4-4E8C-A23F-B10B1F65062B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Sperrholzplatte / 560 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3CAC208-E3F4-4E8C-A23F-B10B1F65062B}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrholzplatte / 560 -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{031AD4D6-6C29-4D81-902F-B7915F0EFAFE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Sperrholzplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{031AD4D6-6C29-4D81-902F-B7915F0EFAFE}', 'HY-{CE90ECB6-767A-49A3-808E-3063F2837E18}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrholzplatten -> Holzschichtplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25211CB6-ABC4-4E07-82F1-FE2DF403BCF9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Holzständer-Luft -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25211CB6-ABC4-4E07-82F1-FE2DF403BCF9}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständer-Luft -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64406BD1-95FC-4E99-884E-D8351C47AF99}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzständerhohlraum -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3B5C393-8FA3-444D-BE9E-822FF84CD1A4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Ständer-Hohlraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3B5C393-8FA3-444D-BE9E-822FF84CD1A4}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständer-Hohlraum -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{441BDC96-7F8E-4AD1-BD29-5B5128DB7C6A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Ständer-Hohlraum / 300 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{441BDC96-7F8E-4AD1-BD29-5B5128DB7C6A}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständer-Hohlraum / 300 -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{612BFE3B-318F-4D0B-BC67-0F3FE3C97D0B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Ständer-Luft -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{612BFE3B-318F-4D0B-BC67-0F3FE3C97D0B}', 'HY-{19E81D35-7D02-49B8-AD25-73D2788E79FF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ständer-Luft -> Holzständer-Hohlraum
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81AF0F83-0108-4244-8FCA-1D33F93B24E0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:23'); -- Akustiktäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81AF0F83-0108-4244-8FCA-1D33F93B24E0}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Akustiktäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2CBC45AF-CF3B-4760-B56C-A23423E7F326}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Brett -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{531C89B1-2E1A-437A-9C2C-9A1ADCAF1136}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Bretter -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{531C89B1-2E1A-437A-9C2C-9A1ADCAF1136}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bretter -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B1100B8-85A7-4ECD-A74E-EF81F44F0FEE}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachschalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC8F84F0-286B-4A91-8785-7623610AA18E}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dachuntersicht -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E947DEC-BE81-4407-8236-2528F03476A2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Fassade - Holzverschalung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5E947DEC-BE81-4407-8236-2528F03476A2}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fassade - Holzverschalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10490FA5-F422-4B9B-B5EE-AA135BAFBAAF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Fastäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{10490FA5-F422-4B9B-B5EE-AA135BAFBAAF}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fastäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACCD88A7-77C1-404A-A6ED-05D1B54E86B9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holz-Paneelen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ACCD88A7-77C1-404A-A6ED-05D1B54E86B9}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holz-Paneelen -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93220622-69DF-43FD-B822-E492256687A8}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzpaneel -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC82C16E-4B0A-483A-9DCF-CEB018AD0A21}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzschalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9B137B6-05FD-4150-8249-3A9C151B71D9}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzschindeln -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE91D0E8-6E45-48D2-9F08-BD238D8C1FDB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzverkleidung / 520 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE91D0E8-6E45-48D2-9F08-BD238D8C1FDB}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung / 520 -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5722F2AE-6460-4BDE-8C50-9CC001725A59}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzverkleidung / 550 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5722F2AE-6460-4BDE-8C50-9CC001725A59}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung / 550 -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A38C97AA-8F0A-403C-960C-1F96472D718E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzverkleidung / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A38C97AA-8F0A-403C-960C-1F96472D718E}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung / 650 -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ECAB8D-4C00-42E1-8964-A0EBF4A03857}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverschalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{229FC656-1FE6-48A2-A361-3EAFF108B856}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Landhaustäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{229FC656-1FE6-48A2-A361-3EAFF108B856}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Landhaustäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19A06F69-F366-4F54-9552-AC6718ACF661}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Rundprofiltäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{19A06F69-F366-4F54-9552-AC6718ACF661}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rundprofiltäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35F80E9A-869E-4FCF-BFBC-D68231281552}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0ABDF7B-247F-408B-8C6D-2C54B42561B5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Schalungen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0ABDF7B-247F-408B-8C6D-2C54B42561B5}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schalungen -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96B9CF73-4977-409D-A27B-ACB251CE2C3E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Schattenfugtäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{96B9CF73-4977-409D-A27B-ACB251CE2C3E}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schattenfugtäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39D28E6E-1F2E-40F5-9B7F-4B2EA4F77676}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Steilfastäfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{39D28E6E-1F2E-40F5-9B7F-4B2EA4F77676}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steilfastäfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F06DA951-B563-4F49-B459-BDABB046FB03}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stülpschalung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E108672-7248-42CD-A0B8-0970E3B08809}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Täfelung -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56691433-47E1-4F6A-8F1D-9B910910507D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Täfer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56691433-47E1-4F6A-8F1D-9B910910507D}', 'HY-{57B83DFF-5A94-4A90-8754-5D40BC847C74}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Täfer -> Holzverkleidung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB7625D8-7C58-4EB7-BEFD-68BC72F76EBD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Dach - Holzverschalung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB7625D8-7C58-4EB7-BEFD-68BC72F76EBD}', 'HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dach - Holzverschalung -> Holzverkleidung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27214A90-4EDC-493A-B1EA-214BEEEF5DCF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzschalung-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27214A90-4EDC-493A-B1EA-214BEEEF5DCF}', 'HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzschalung-Innen -> Holzverkleidung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23BD2221-1B7A-484A-B68B-C8680EB25110}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzverkleidung-Innen / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23BD2221-1B7A-484A-B68B-C8680EB25110}', 'HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzverkleidung-Innen / 650 -> Holzverkleidung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC731B0B-C467-4367-9785-AC5579C11A62}', 'HY-{8BC8E63D-DA22-4523-8213-2EC25D95DC86}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Innenholzverkleidung -> Holzverkleidung-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1609D04-2E4C-48E6-9E5A-4470DB78C38D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- CH_Holzwerkstoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D1609D04-2E4C-48E6-9E5A-4470DB78C38D}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Holzwerkstoff -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E8AC76F-596C-44F4-A997-4A31946D64BB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Duripanel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3E8AC76F-596C-44F4-A997-4A31946D64BB}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Duripanel -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29C87571-B494-4DBF-A8BA-F1B6617355B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- DWD -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29C87571-B494-4DBF-A8BA-F1B6617355B6}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- DWD -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F2B6CD4-5C3C-4929-B35D-610A63D0D58A}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grobspanplatte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D272A15F-C169-4B37-BEA2-4E5440287879}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Grobspanplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D272A15F-C169-4B37-BEA2-4E5440287879}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grobspanplatten -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9143540D-E35C-4419-8430-BD7B3B6B7CFD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzwerkstoff MDF, natur -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9143540D-E35C-4419-8430-BD7B3B6B7CFD}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwerkstoff MDF, natur -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CC3C5AC2-D400-4255-9873-70752E98A33A}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwerkstoffplatte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0C5667DE-B543-4622-8B78-647E11A4FD0C}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7271F48-B7DB-4E68-A7F0-20F66D6E22D7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzwolle-Leichtbauplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B7271F48-B7DB-4E68-A7F0-20F66D6E22D7}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Leichtbauplatte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEC52677-D67A-4717-B4F4-46A712A303D6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzwolle-Leichtbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEC52677-D67A-4717-B4F4-46A712A303D6}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzwolle-Leichtbauplatten -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1C99070A-251A-4699-9785-6346DA2B7CE4}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzzementplatte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27CD7BC9-32BB-430F-B897-E52C32489FCF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- OSB -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27CD7BC9-32BB-430F-B897-E52C32489FCF}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- OSB -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{968F515C-A53C-4316-8CD6-CA5913E3EC8B}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- OSB Platte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84E1C88E-0116-4C3F-99A5-061F3A76DC02}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatte -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADC382FC-BA7B-4206-ABB2-1AB33E24E300}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Spanplatte / 560 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ADC382FC-BA7B-4206-ABB2-1AB33E24E300}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatte / 560 -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3EE25F9D-B49E-487C-A3B1-56DAA7D0A620}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Spanplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3EE25F9D-B49E-487C-A3B1-56DAA7D0A620}', 'HY-{3B79A0F4-65D0-49E8-B806-791134A2E6BA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatten -> Holzwerkstoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C28D272-2952-46AD-A260-F52E4A86A951}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Grobspanplatte-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C28D272-2952-46AD-A260-F52E4A86A951}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grobspanplatte-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4814E05-0B0B-4D3F-8440-C751AB22C690}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Grobspanplatten-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4814E05-0B0B-4D3F-8440-C751AB22C690}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grobspanplatten-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F28321F-26B4-483F-99BD-5FC51BD33960}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- OSB-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F28321F-26B4-483F-99BD-5FC51BD33960}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- OSB-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B102907-228F-4E89-89BB-9B498EF1541A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Spanplatte-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7B102907-228F-4E89-89BB-9B498EF1541A}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatte-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D12A8BC0-8C59-4667-A619-CDF803A5187E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Spanplatten-Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D12A8BC0-8C59-4667-A619-CDF803A5187E}', 'HY-{BB410A57-F84E-4F5E-92F0-54E10686672B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatten-Innen -> Holzwerkstoff-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7307A32C-8BB8-4F2F-BECE-5AD88C0A6506}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Duripanel-Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7307A32C-8BB8-4F2F-BECE-5AD88C0A6506}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Duripanel-Sicht -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87E0A940-B61F-460E-925D-54A49DCF53A5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Duripanel-Sichtplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87E0A940-B61F-460E-925D-54A49DCF53A5}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Duripanel-Sichtplatte -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35FA6333-B4D7-4ACA-8B4E-72212C6213B8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzzementplatte-Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35FA6333-B4D7-4ACA-8B4E-72212C6213B8}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzzementplatte-Sicht -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{150A1016-58D2-46E1-BEB9-C585F3EE5754}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Holzzementplatte-Sichtplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{150A1016-58D2-46E1-BEB9-C585F3EE5754}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzzementplatte-Sichtplatte -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D39DA7A-82C6-435F-94E7-A6761514CCCB}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holzzementsichtplatte -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3A88F034-3971-4F5D-AED4-00EA19AC7277}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatte furniert -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3DE1AA4-8306-4063-8772-DC8168E4A3B2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Spanplatten furniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3DE1AA4-8306-4063-8772-DC8168E4A3B2}', 'HY-{C86634FC-94C3-4873-B88D-1FDD15506DE0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Spanplatten furniert -> Holzwerkstoff-Sicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDC7C037-9ED7-4D80-B9EE-50D9FD6E68F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Geberit Installationssystem -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDC7C037-9ED7-4D80-B9EE-50D9FD6E68F0}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Geberit Installationssystem -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CF646F0-E00A-44B0-A496-3EDCDC8288E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- GIS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4CF646F0-E00A-44B0-A496-3EDCDC8288E1}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GIS -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F1E63549-57DA-45EF-932B-B116299E82C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- GIS / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F1E63549-57DA-45EF-932B-B116299E82C6}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GIS / 320 -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{12FCF449-A239-4AFC-8C69-D0660D670EC0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Installationssystem -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{12FCF449-A239-4AFC-8C69-D0660D670EC0}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Installationssystem -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3995491D-D4DA-4D86-BDAA-2FF9B63F7B20}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Santro -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3995491D-D4DA-4D86-BDAA-2FF9B63F7B20}', 'HY-{586C5D73-3CAE-415E-86D7-17AA87981764}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Santro -> Installationselement
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27144E9D-6C08-4E82-9E03-E8018A8A211C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Kabinentrennwand / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27144E9D-6C08-4E82-9E03-E8018A8A211C}', 'HY-{8A49658E-1BCB-45A9-8CAB-3FBFC1E94450}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kabinentrennwand / 320 -> Kabinentrennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B8D3039-5BFA-4344-A892-74B809996DD7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Sanitärtrennwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B8D3039-5BFA-4344-A892-74B809996DD7}', 'HY-{8A49658E-1BCB-45A9-8CAB-3FBFC1E94450}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sanitärtrennwand -> Kabinentrennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8968FC08-CCED-40C8-A577-BDE862FA5F12}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- WC-Trennwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8968FC08-CCED-40C8-A577-BDE862FA5F12}', 'HY-{8A49658E-1BCB-45A9-8CAB-3FBFC1E94450}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- WC-Trennwand -> Kabinentrennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45F336A5-4A59-4F2C-8C3B-55FB0903CED9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- CH_Kalksandstein verputzt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45F336A5-4A59-4F2C-8C3B-55FB0903CED9}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Kalksandstein verputzt -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73B14AEB-BAB7-4978-9122-CBD33D2A9CBD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Duplo-Block -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73B14AEB-BAB7-4978-9122-CBD33D2A9CBD}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Duplo-Block -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA16DADA-4E87-4120-8ECD-578551BA6918}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- Kalksandstein / 650 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CA16DADA-4E87-4120-8ECD-578551BA6918}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein / 650 -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7797028E-4066-4904-9A80-DF496B314258}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- KS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7797028E-4066-4904-9A80-DF496B314258}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CAAE48D-F3E7-4C95-896A-493D10E7A8BB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- ks -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6CAAE48D-F3E7-4C95-896A-493D10E7A8BB}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- ks -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15ACB5DE-3509-4C4B-8407-2541A1DBB65E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:24'); -- KS BP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15ACB5DE-3509-4C4B-8407-2541A1DBB65E}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS BP -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67648A2C-2A2C-454E-BDC2-16EBAB1524AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS F -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67648A2C-2A2C-454E-BDC2-16EBAB1524AF}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS F -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3BEF710-4379-4B9A-A594-257F99E6B27F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS L -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B3BEF710-4379-4B9A-A594-257F99E6B27F}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS L -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BCC7EFD-A677-4CDA-8431-CE6B8C24EE7B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS L-R P -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BCC7EFD-A677-4CDA-8431-CE6B8C24EE7B}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS L-R P -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{490ADF78-1485-4368-A70A-2D5758B071B1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS L-R SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{490ADF78-1485-4368-A70A-2D5758B071B1}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS L-R SFK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65957822-1400-41C1-BFFA-9BCD2113927E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS Plus-Planelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65957822-1400-41C1-BFFA-9BCD2113927E}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Plus-Planelement -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20F646C3-4C89-4713-84B6-FE6007B2804B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{20F646C3-4C89-4713-84B6-FE6007B2804B}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS SFK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FE6286F-DC6E-47EB-8945-9A12786717FB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS XL-PE -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FE6286F-DC6E-47EB-8945-9A12786717FB}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS XL-PE -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53A42BEE-8E97-495B-A653-B93AEA733BBD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS XL-PE SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{53A42BEE-8E97-495B-A653-B93AEA733BBD}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS XL-PE SFK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01917345-5B14-4E7C-BD8F-C717562B9551}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS XL-Planelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{01917345-5B14-4E7C-BD8F-C717562B9551}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS XL-Planelement -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2415F81B-8F27-410B-A58B-2583D48F7977}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS XL-Rasterelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2415F81B-8F27-410B-A58B-2583D48F7977}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS XL-Rasterelement -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{115D1D47-B6AF-4083-99A3-C5184C3C2F1B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS XL-RE -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{115D1D47-B6AF-4083-99A3-C5184C3C2F1B}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS XL-RE -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D36FC7F6-7485-40A6-844F-AA6F3E2E4E5D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-Fasenstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D36FC7F6-7485-40A6-844F-AA6F3E2E4E5D}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Fasenstein -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B54F810-DB09-43FD-A047-5AB131CEB9DB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-Planstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B54F810-DB09-43FD-A047-5AB131CEB9DB}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Planstein -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F45EC8B-82FE-4957-9DE7-1AD10EC4DEF4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-Quadro -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F45EC8B-82FE-4957-9DE7-1AD10EC4DEF4}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Quadro -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{993527DF-0E5B-4BD8-A791-1543F8BB6AFD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-Quadro E -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{993527DF-0E5B-4BD8-A791-1543F8BB6AFD}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Quadro E -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98EA6F96-ACEA-43A2-8F36-32A89C96EEB2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98EA6F96-ACEA-43A2-8F36-32A89C96EEB2}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-R -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F9B7B5E-AA1F-4D40-B8BA-58BEAAD3E169}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-R P -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F9B7B5E-AA1F-4D40-B8BA-58BEAAD3E169}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-R P -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{670DDAF7-7C96-4DAD-A2D2-1E5F133B9841}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-R P SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{670DDAF7-7C96-4DAD-A2D2-1E5F133B9841}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-R P SFK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4ECEAE8-B32F-4848-9167-10101627D949}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- KS-R SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4ECEAE8-B32F-4848-9167-10101627D949}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-R SFK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C764258-C639-49C2-A805-363322294EFE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- MK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C764258-C639-49C2-A805-363322294EFE}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MK -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA347B62-ED48-4219-928A-2A2B2EF2AE0F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- MKD -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA347B62-ED48-4219-928A-2A2B2EF2AE0F}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MKD -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEA27C7D-5194-4655-90C7-ECC5EB8159F1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- MW, Kalksandstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEA27C7D-5194-4655-90C7-ECC5EB8159F1}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MW, Kalksandstein -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1238352-29B6-48CF-8EF4-C1A3834281D7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Quattro-Block -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1238352-29B6-48CF-8EF4-C1A3834281D7}', 'HY-{8D935D1F-759B-459D-A48E-2FEF2FA0EDFF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Quattro-Block -> Kalksandstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D496F2EB-4F75-4EB2-9712-6E5EA59D7A0A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Kaltbitumen-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D496F2EB-4F75-4EB2-9712-6E5EA59D7A0A}', 'HY-{680CFB2F-4443-4802-81D7-5B1ED17387E0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kaltbitumen-Belag -> Kaltbitumen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2776A87B-EEDF-49A9-B36E-68AAD2BE9F56}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Kaltbitumenbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2776A87B-EEDF-49A9-B36E-68AAD2BE9F56}', 'HY-{680CFB2F-4443-4802-81D7-5B1ED17387E0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kaltbitumenbelag -> Kaltbitumen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0759AA9F-D741-432B-BF9E-4856FDB1D536}', 'HY-{E3EB2521-C5E3-4D5D-800F-AFCC6566F7A5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Chamotte -> Kaminstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEA42F3D-BA13-4333-9736-6CAD464D4F27}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Feuerfeste Steine -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEA42F3D-BA13-4333-9736-6CAD464D4F27}', 'HY-{E3EB2521-C5E3-4D5D-800F-AFCC6566F7A5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Feuerfeste Steine -> Kaminstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F95E2DC9-D038-40B0-8B19-A655DEA209A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Einstiegschacht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F95E2DC9-D038-40B0-8B19-A655DEA209A8}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Einstiegschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FFD6DEDA-A994-45C9-9D2E-15B04F4750F7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Kontrollschacht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FFD6DEDA-A994-45C9-9D2E-15B04F4750F7}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kontrollschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87A5EB36-7DDD-481E-A06A-254FC3C1C024}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Mineralölabscheider -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87A5EB36-7DDD-481E-A06A-254FC3C1C024}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mineralölabscheider -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B835B0E1-4558-4519-B7C8-9DA34169D483}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Pumpenschacht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B835B0E1-4558-4519-B7C8-9DA34169D483}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pumpenschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EE1650-FF12-4FC7-9C56-6379F6106222}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Schlammsammler -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EE1650-FF12-4FC7-9C56-6379F6106222}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schlammsammler -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB83C433-E79D-44F2-B109-356AA487F6FB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Sickerschacht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EB83C433-E79D-44F2-B109-356AA487F6FB}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A621BDE-393C-4AAD-83BA-9D3370C9AEE3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Versickerungsschacht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A621BDE-393C-4AAD-83BA-9D3370C9AEE3}', 'HY-{36A3ACE4-A676-4372-849B-5CB3813640FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Versickerungsschacht -> Kanalisationsschacht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8B6B837-438F-4405-985F-B1824FA53D99}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Estrich+Fliesen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8B6B837-438F-4405-985F-B1824FA53D99}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich+Fliesen -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65EABE19-D976-45BB-9189-639552A24C37}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Estrich+Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65EABE19-D976-45BB-9189-639552A24C37}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich+Platten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2571DA7B-AD18-48F2-9F5F-2AC5E612BBFA}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fliesen -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D6BC8ED-D9D4-4CA1-806E-9523965BF2CB}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6C3333A-27B6-45C1-A9C8-58D013E87235}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Keramik-Mosaik -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C6C3333A-27B6-45C1-A9C8-58D013E87235}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramik-Mosaik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0071598B-15A3-4E50-A335-A2483C496AD5}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikmosaik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE3C2765-8F50-4EDA-A075-2B1515995E53}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Keramische Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE3C2765-8F50-4EDA-A075-2B1515995E53}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramische Platten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E612A5B2-C6F2-4975-821C-98D10C8FC41B}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kleinmosaik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9F8AEC6-BF48-4FAE-A215-84565F3A1A22}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Klinker-Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9F8AEC6-BF48-4FAE-A215-84565F3A1A22}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinker-Platten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40B11739-37B2-41AA-A4C3-2C0E131BACE7}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerplatten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9361DB32-D6E5-4A12-8260-0FCFB43270F4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:25'); -- Klinkerriemchen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9361DB32-D6E5-4A12-8260-0FCFB43270F4}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerriemchen -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{253001AE-614E-43C5-BB35-AA191785AA91}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerriemen -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09B925F-D8C2-424D-9DC9-8B7B6AD724D9}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mittelmosaik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D8BE6EA-9A3D-4958-9615-30A9030B57C9}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mosaik -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CFCC8DD4-2F60-44BC-93DA-7F9EC55FAE87}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C34150AB-E8DD-468A-92EE-5E05090FB323}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:43'); -- Platten / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C34150AB-E8DD-468A-92EE-5E05090FB323}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten / 140 -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EBA1CF0-581D-4897-8CDE-CE90D68377A6}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten 20cm -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67CAB312-7403-44FB-8D6A-7502AFEAFBBB}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten 50cm -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB793CBF-AF17-464A-8A40-9DF29BED9C2B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:43'); -- Platten Sanitär -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BB793CBF-AF17-464A-8A40-9DF29BED9C2B}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten Sanitär -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40CF6403-1651-4BEC-8087-723CDDD30BBC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:43'); -- Platten Treppe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40CF6403-1651-4BEC-8087-723CDDD30BBC}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten Treppe -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BECFEE7B-F9C1-4865-9C91-900BDAE934B8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Plättli -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BECFEE7B-F9C1-4865-9C91-900BDAE934B8}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plättli -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5542832A-4AED-4801-8044-CB2013B3A3E0}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeug -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{85841BF7-716C-4BA6-83BB-7E3804D9BF31}', 'HY-{FEFEC736-7EDE-4EF0-BDC3-DF2F22AB78E9}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tonplatten -> Keramikplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21D56327-FE21-4F52-8F8E-CADECBB8BE7D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Keramikplatten neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{21D56327-FE21-4F52-8F8E-CADECBB8BE7D}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten neu -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E9A8C3B-98D1-41B0-8776-8B8F1F1829AB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Keramikplatten renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E9A8C3B-98D1-41B0-8776-8B8F1F1829AB}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten renoviert -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A368DB0-1879-4899-AF9D-8A692069EDF2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Keramikplatten-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0A368DB0-1879-4899-AF9D-8A692069EDF2}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten-Renovation -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8F04DA1-11AA-4045-87D4-AD30B7370287}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Keramikplatten-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B8F04DA1-11AA-4045-87D4-AD30B7370287}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Keramikplatten-Sanierung -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD3E6779-5C98-4490-883D-617C7495AD7A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Platten neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD3E6779-5C98-4490-883D-617C7495AD7A}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten neu -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECD3CF2B-F0A4-4394-A759-9BE34A977191}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Platten Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECD3CF2B-F0A4-4394-A759-9BE34A977191}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten Renovation -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78F07F35-6307-47C3-9B38-54BBD028B6C4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Platten saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78F07F35-6307-47C3-9B38-54BBD028B6C4}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten saniert -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58F2BF9E-0C0C-4E60-A272-E9E41F9FB2B4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Platten Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58F2BF9E-0C0C-4E60-A272-E9E41F9FB2B4}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten Sanierung -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C3B3AE-A8D2-4E8A-9447-B14E2CE08949}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Platten-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C1C3B3AE-A8D2-4E8A-9447-B14E2CE08949}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Platten-Sanierung -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B23DDA7-57DD-4AD5-BE8D-BFDCCC312A5E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Plättli neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B23DDA7-57DD-4AD5-BE8D-BFDCCC312A5E}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plättli neu -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B06591A1-B8DA-4EDA-9477-4C13288BF05E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Plättli saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B06591A1-B8DA-4EDA-9477-4C13288BF05E}', 'HY-{303003F9-68ED-44B1-92B4-5EBF786F0C9C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plättli saniert -> Keramikplatten Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDCB4127-7D2F-4647-B3D4-459A5887BB78}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:44'); -- Belag, Kies -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDCB4127-7D2F-4647-B3D4-459A5887BB78}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Belag, Kies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0303A666-CBB4-4A39-BEC5-9A0B6AF2FFDF}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Geröll -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E51F636-F8C1-4FDA-8C3F-705AF34E33CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Kies / 674 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7E51F636-F8C1-4FDA-8C3F-705AF34E33CD}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kies / 674 -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2FD8DBAB-D02E-4441-B99A-1EBBC01FA28D}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kieskoffer -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58A5B3F5-8881-4E6A-BCA1-FBD5E2DE1B88}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Naturstein - Kies -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58A5B3F5-8881-4E6A-BCA1-FBD5E2DE1B88}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein - Kies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AB33292-A394-46D1-B65A-E34028EA5704}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Naturstein - Treppe -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AB33292-A394-46D1-B65A-E34028EA5704}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein - Treppe -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{461AFBA3-CB2F-4A38-9544-9FE8C7B1CEFF}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Recyclingkies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBDFDBF0-3F70-4998-B5F3-3B516812FFCA}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rollierung -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F74CADE4-2118-4182-B57B-B8FF3A55EDC1}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rundkies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3AA81746-338E-40E2-A2BF-4A1BFEE2ED63}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sand -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AFE65A5-ED5B-4BEF-B88B-1F496798485A}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schotter -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB311F3C-4272-4A79-AFA6-61ACC4F6186D}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schüttung -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D4E514C6-5AEC-44C6-8871-5C494F63716B}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Splitt -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{305C18E5-8860-4C29-BD46-8E38E9241F91}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Splittschicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{305C18E5-8860-4C29-BD46-8E38E9241F91}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Splittschicht -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{38C408F1-E378-4910-925B-990B0674F5D8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Umgebung - Sand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{38C408F1-E378-4910-925B-990B0674F5D8}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung - Sand -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31AF80FD-1B5F-4C85-B3F0-BE9947768C33}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Umgebung Geröll -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31AF80FD-1B5F-4C85-B3F0-BE9947768C33}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung Geröll -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEC5095D-3606-474E-A4B3-879CDDA9F3C1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:45'); -- Umgebung Kofferung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEC5095D-3606-474E-A4B3-879CDDA9F3C1}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung Kofferung -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09888D8-B48E-4B39-92CD-0B42A698BC7C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Umgebung Rundkies -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E09888D8-B48E-4B39-92CD-0B42A698BC7C}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung Rundkies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C36E121F-9EBA-447D-851D-E3BA09924442}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Umgebung Splitt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C36E121F-9EBA-447D-851D-E3BA09924442}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung Splitt -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8275477-ED6E-423E-B8C6-B55659CEC437}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Wandkies -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8275477-ED6E-423E-B8C6-B55659CEC437}', 'HY-{0AEE7587-D245-4960-977F-7AAE06A0D1CA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wandkies -> Kies
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{665F4E56-7CF9-45B6-8212-563AD483763F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- CH_Feuerbeständige Ziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{665F4E56-7CF9-45B6-8212-563AD483763F}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Feuerbeständige Ziegel -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42CB72D0-1C4E-4E96-806F-C6EEDEA81610}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- CH_Feuerfeste Steine -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{42CB72D0-1C4E-4E96-806F-C6EEDEA81610}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Feuerfeste Steine -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F93FC7B-128C-4D4D-A9A1-91E4895919F6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Kemano -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9F93FC7B-128C-4D4D-A9A1-91E4895919F6}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kemano -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{98336CB8-C70D-4977-B867-09F5383BE414}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinker -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77D192B5-736B-4CAC-905D-6A2E37F11063}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Klinker-Sichtmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{77D192B5-736B-4CAC-905D-6A2E37F11063}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinker-Sichtmauerwerk -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4662C4E8-035F-4B9B-90CC-E68C4BC0DEBB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Klinkermwk. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4662C4E8-035F-4B9B-90CC-E68C4BC0DEBB}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkermwk. -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A8B95938-7C89-486C-9B1D-8C9ECB8A1805}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkersichtmauerwerk -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93BA73BA-64A2-43FD-A2D7-475C05DBAFBB}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkervormauer -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79EA5ECE-7986-43E8-821D-CB280B634230}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkervorsatzschale -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3C902BF-C28A-4EA3-A782-BA4357CEB466}', 'HY-{178F378A-46FB-4A85-A97F-3C2CFB587E7F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Klinkerziegel -> Klinkerstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29413B0F-DA84-4FE8-9E3E-05A653EEE897}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Allgemein, Konstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29413B0F-DA84-4FE8-9E3E-05A653EEE897}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Konstruktion -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{039BAAEF-E26E-4FB0-B04F-23855F302759}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Allgemein, Konstruktion Aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{039BAAEF-E26E-4FB0-B04F-23855F302759}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Konstruktion Aussen -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0552941A-D28A-4041-B38A-088F98BC8A1B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:46'); -- Allgemein, Konstruktion Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0552941A-D28A-4041-B38A-088F98BC8A1B}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Konstruktion Innen -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18E0E3FB-2306-405E-B276-61A799856480}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Massiv -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18E0E3FB-2306-405E-B276-61A799856480}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Massiv -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6E39608-E248-4F82-9794-C248C61DF97A}', 'HY-{DF330476-910F-4D2D-B60E-D0BC14033881}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verschiedene Konstruktionen -> Konstruktion-Verschiedene
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2453B764-E90F-49DB-BC91-70696C55209D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2453B764-E90F-49DB-BC91-70696C55209D}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork / 140 -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A02FDEC5-5B41-452F-BDAB-16555A1710A2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork / 405 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A02FDEC5-5B41-452F-BDAB-16555A1710A2}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork / 405 -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34D75C35-F5AC-4F98-86E0-BA0F6940FA14}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Korkboden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34D75C35-F5AC-4F98-86E0-BA0F6940FA14}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{59A14B9F-DBF8-41BC-87FC-DDE93839DA07}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkplatte -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F6C9D76-4B45-45AF-8F38-891FBC3D8217}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Korkplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3F6C9D76-4B45-45AF-8F38-891FBC3D8217}', 'HY-{690D8D79-F81F-42FC-B789-061C6DFA580F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkplatten -> Kork
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B768EA5D-37B2-48D7-BAEB-D7AD401439CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B768EA5D-37B2-48D7-BAEB-D7AD401439CD}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork neu -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0430BA8-1EEC-49D8-9BE2-A7BAE0DEFAAA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B0430BA8-1EEC-49D8-9BE2-A7BAE0DEFAAA}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork Renovation -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E560B389-CF2A-4D08-B32C-44B74C230034}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E560B389-CF2A-4D08-B32C-44B74C230034}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork renoviert -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB83E087-FC1A-4D9E-8FEE-F54AD40B6A5D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB83E087-FC1A-4D9E-8FEE-F54AD40B6A5D}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork saniert -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B63ED404-96D3-4325-B112-94D8CF1D9B81}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B63ED404-96D3-4325-B112-94D8CF1D9B81}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork-Renovation -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2834FD80-6B82-41AA-8AD8-23FD4CBE90C0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Kork-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2834FD80-6B82-41AA-8AD8-23FD4CBE90C0}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kork-Sanierung -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC62DE5F-38CE-473D-ACB4-CB5D99A44D53}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Korkboden neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC62DE5F-38CE-473D-ACB4-CB5D99A44D53}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden neu -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D6869BA-F41A-4660-8746-E1046066ACB0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:47'); -- Korkboden Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D6869BA-F41A-4660-8746-E1046066ACB0}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden Renovation -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD51D35B-FD67-4980-941E-26AFB088ADBB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Korkboden saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD51D35B-FD67-4980-941E-26AFB088ADBB}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden saniert -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF33C5AC-B715-41B4-80B2-8E9159E84C6A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Korkboden Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EF33C5AC-B715-41B4-80B2-8E9159E84C6A}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden Sanierung -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D1D43E4-C404-46AB-8165-877098165248}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Korkboden-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D1D43E4-C404-46AB-8165-877098165248}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden-Renovation -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8466C90-D97E-4A07-8B6D-F37C52764B58}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Korkboden-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F8466C90-D97E-4A07-8B6D-F37C52764B58}', 'HY-{13F549D0-0DFB-4231-BDCB-7A660DD316C0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Korkboden-Sanierung -> Kork Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03BDBF8B-BFE5-4343-A03F-57234382DFDD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Haushaltsküche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03BDBF8B-BFE5-4343-A03F-57234382DFDD}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Haushaltsküche -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{196F2751-ECB6-4D05-A6E6-89E78B05EBC8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kleinküche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{196F2751-ECB6-4D05-A6E6-89E78B05EBC8}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kleinküche -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA60AC1C-C255-4BD9-9D10-00207ECEF3BD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochbereich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FA60AC1C-C255-4BD9-9D10-00207ECEF3BD}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochbereich -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F514BD80-E142-44E7-8F78-ECA7533273ED}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F514BD80-E142-44E7-8F78-ECA7533273ED}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochen -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07D9390E-A856-4C61-B202-820795928A15}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochnische -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07D9390E-A856-4C61-B202-820795928A15}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochnische -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6A5F4F5-7D11-4A31-AF04-EC9FA04E6785}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochraum -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D6A5F4F5-7D11-4A31-AF04-EC9FA04E6785}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochraum -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BDA730D-9627-43BB-9CAF-41751F8299C3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochstelle -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BDA730D-9627-43BB-9CAF-41751F8299C3}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochstelle -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C9F131A-0121-4096-B7C1-6423E4BE23C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Kochzelle -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C9F131A-0121-4096-B7C1-6423E4BE23C6}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kochzelle -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D2BC112C-2D08-4951-BCB2-BAF39AB231F6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- KÜCHE -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D2BC112C-2D08-4951-BCB2-BAF39AB231F6}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KÜCHE -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A03B6BB0-A954-4E06-BC88-721C5DDFCDCB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- KÜCHE / ESSEN -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A03B6BB0-A954-4E06-BC88-721C5DDFCDCB}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KÜCHE / ESSEN -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63478874-D744-47CA-AFD7-5FCC5706AAA6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:48'); -- Küche / Essen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63478874-D744-47CA-AFD7-5FCC5706AAA6}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Küche / Essen -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28D372C9-6C1B-4C95-A212-3D0C597361CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- KÜCHE / WOHNEN -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28D372C9-6C1B-4C95-A212-3D0C597361CD}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KÜCHE / WOHNEN -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9D33C82-0306-46B0-9653-3E0687110422}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Küche / Wohnen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9D33C82-0306-46B0-9653-3E0687110422}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Küche / Wohnen -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{399C7211-8053-4083-8BE8-E4BB645CD24B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Küchennische -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{399C7211-8053-4083-8BE8-E4BB645CD24B}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Küchennische -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{298DDCA1-8414-4087-B2CA-81A138CC77C1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Küchenraumzelle -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{298DDCA1-8414-4087-B2CA-81A138CC77C1}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Küchenraumzelle -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA88D7FD-8F73-4635-9043-6A2ADAB354E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Wohnküche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA88D7FD-8F73-4635-9043-6A2ADAB354E1}', 'HY-{4585ADBA-B5BC-4EEE-8C22-6B669CAE96C3}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wohnküche -> Küche
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF9AD521-06E3-4D8C-A82C-68CD7D0C8A8D}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Einstreubelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C15F24C1-E832-4C67-9E03-6C59CF16F6D8}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Epoxidharzbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2E04C589-FE72-46BC-BD8E-C060979E6321}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Kunstharz-Einstreubelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2E04C589-FE72-46BC-BD8E-C060979E6321}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharz-Einstreubelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0BBCE11-7AF7-4DF2-9747-B79D0BCC8C91}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Kunstharz-Mörtelbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F0BBCE11-7AF7-4DF2-9747-B79D0BCC8C91}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharz-Mörtelbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52A9CDC5-2A31-410E-A250-9343E2ABDA86}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Kunstharzbelag / 420 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52A9CDC5-2A31-410E-A250-9343E2ABDA86}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunstharzbelag / 420 -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D19045F-7BB9-46F9-8104-094BBB4DEB5C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Methylmethacrylat -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D19045F-7BB9-46F9-8104-094BBB4DEB5C}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Methylmethacrylat -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97D6CD7C-2616-4740-9EE3-D5737153F0A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Methylmethacrylat-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97D6CD7C-2616-4740-9EE3-D5737153F0A8}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Methylmethacrylat-Belag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49F61648-85AA-4944-8ABA-D87343943988}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Methylmethacrylatbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04933A42-D479-48BB-8600-779687B4B58C}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mörtelbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EB7B0BE-2846-49FF-85F5-E73E69200523}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:49'); -- Polyurethanharz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EB7B0BE-2846-49FF-85F5-E73E69200523}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyurethanharz -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{24ACDC2C-762C-492F-9348-2840F618568F}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyurethanharzbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22DCC37A-600E-4F2E-9FFF-FA6A44A1E336}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Zement-Kunstharz-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22DCC37A-600E-4F2E-9FFF-FA6A44A1E336}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zement-Kunstharz-Belag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5906B1E0-FFB2-400F-809E-065EFC4F81D5}', 'HY-{397BCE8E-D328-437D-83F5-CA65F8DE27EA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementkunstharzbelag -> Kunstharzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D08B7D10-1E89-45A6-BC5E-AC01EA55DC2A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Beton-Pflasterstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D08B7D10-1E89-45A6-BC5E-AC01EA55DC2A}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Pflasterstein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AABD05-7051-4CE4-897E-AB730417F1AD}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonpflasterstein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF4C714-1A45-441D-950D-83DC9E080806}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonplatten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{890F2D6A-4BF3-42DB-BF4B-C61BFDD328EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Betonplatten / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{890F2D6A-4BF3-42DB-BF4B-C61BFDD328EE}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonplatten / 140 -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D50DF60F-FB5D-468D-AEC4-4696A2CF5C90}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Betonplatten / 405 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D50DF60F-FB5D-468D-AEC4-4696A2CF5C90}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonplatten / 405 -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D5462F4-2458-4E62-A5B2-13F950DC34E5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Betonwerkstein Kunststein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D5462F4-2458-4E62-A5B2-13F950DC34E5}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonwerkstein Kunststein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{284A0321-7C47-471D-A0D8-047F3CA2A19F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Kunststein, Betonwerkstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{284A0321-7C47-471D-A0D8-047F3CA2A19F}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststein, Betonwerkstein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0731D62D-82AF-4DBA-8F0D-B4601EB84678}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Kunststein, Betonwerkstein / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0731D62D-82AF-4DBA-8F0D-B4601EB84678}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststein, Betonwerkstein / 140 -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9BC350B3-9CE7-4825-BB2B-33BFCD516FC8}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststeinplatten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCCFFB3E-C4B6-4BF5-92CF-8EBB3F7D8BB2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:50'); -- Terrazzo-Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCCFFB3E-C4B6-4BF5-92CF-8EBB3F7D8BB2}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo-Platten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58B62C2E-037F-413C-8AD5-31881D7F6F48}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzoplatten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{778FF5BC-C2DB-4795-ADA4-6849FB61B1DE}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verbundstein -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{93E60701-0351-4D85-A56C-B9D854423EB0}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verbundsteinplatten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{393AE909-BCCB-47C8-AEDD-5407293A6840}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementplatten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6935236D-9960-4C9E-8DDE-95B902C50E57}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Zementplatten / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6935236D-9960-4C9E-8DDE-95B902C50E57}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementplatten / 140 -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA0B6E2D-8F82-4462-81C2-49FEB9AF6C8F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Zementplatten / 405 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EA0B6E2D-8F82-4462-81C2-49FEB9AF6C8F}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementplatten / 405 -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E7554EF4-891D-450B-AD47-5DF2918F1DF7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- ZM-Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E7554EF4-891D-450B-AD47-5DF2918F1DF7}', 'HY-{E5A8C74F-4B19-4D9A-888B-4482C4137754}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- ZM-Platten -> Kunststein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52058ADA-515E-40AB-BD2A-F8C51311F64E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Fenster - Kunststoff -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52058ADA-515E-40AB-BD2A-F8C51311F64E}', 'HY-{B1FE74A3-8588-42F2-B7E7-34489438E3C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Kunststoff -> Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5DD910-9798-45A7-9791-52A1CE53ACB9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Fenster - Kunststoff weiß -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5DD910-9798-45A7-9791-52A1CE53ACB9}', 'HY-{B1FE74A3-8588-42F2-B7E7-34489438E3C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fenster - Kunststoff weiß -> Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D876CEB-67AB-42AE-9728-71930A20EC30}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6D876CEB-67AB-42AE-9728-71930A20EC30}', 'HY-{B1FE74A3-8588-42F2-B7E7-34489438E3C5}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff / 140 -> Kunststoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2F6F1739-14F4-42E5-9333-791817353751}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff-Alu -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E645CF51-F792-48F1-9DD6-7838B1A69769}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff-Aluminium -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E645CF51-F792-48F1-9DD6-7838B1A69769}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff-Aluminium -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ACE9B11-3858-4196-AB0D-46AA1BDAA88F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff-Metall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ACE9B11-3858-4196-AB0D-46AA1BDAA88F}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff-Metall -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A438D5D-3A27-478E-811D-DEF17E84085B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff/Alu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9A438D5D-3A27-478E-811D-DEF17E84085B}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff/Alu -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF26325A-D2FA-474D-A5C2-0AB9CA6E59C9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff/Aluminium -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF26325A-D2FA-474D-A5C2-0AB9CA6E59C9}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff/Aluminium -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7B11E85-3EAB-4F8D-9E8B-3F2E8D167CAB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Kunststoff/Metall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7B11E85-3EAB-4F8D-9E8B-3F2E8D167CAB}', 'HY-{5175F6D6-234F-4577-8EF9-C0206C7E3784}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kunststoff/Metall -> Kunststoffmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{775518E7-C636-4C24-AAB3-8F8EFD16FFA5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Alu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{775518E7-C636-4C24-AAB3-8F8EFD16FFA5}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alu -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{230F3439-05DF-4317-BBCE-DAA3BEDB7038}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Aluminium -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15B6DC31-7DC7-47B5-8334-EE13872ADA80}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:51'); -- Metall - Aluminium -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{15B6DC31-7DC7-47B5-8334-EE13872ADA80}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Aluminium -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B07AF1B-B1E3-4313-9812-A3CA4D7B5BC3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Metall Aluminium, matt -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9B07AF1B-B1E3-4313-9812-A3CA4D7B5BC3}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall Aluminium, matt -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9FF374C-0D82-4938-AAD4-210ABD2BF187}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Metall, Aluminium -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9FF374C-0D82-4938-AAD4-210ABD2BF187}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall, Aluminium -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F205CC7-B910-42BF-8CA8-9DC801C971B5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Metall, Aluminium / 910 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F205CC7-B910-42BF-8CA8-9DC801C971B5}', 'HY-{DF6AFFBA-0729-455B-84ED-EC530AB3330F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall, Aluminium / 910 -> Leichtmetall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6E904830-E8D9-4E0C-948F-7674475CD49D}', 'HY-{E36590D5-2521-4E85-8ACC-55C911057C34}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gaupenschalung -> Lukarnenschalung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F5CE4F94-782E-4536-97D2-5C08DBEE8ED7}', 'HY-{E36590D5-2521-4E85-8ACC-55C911057C34}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gaupenverkleidung -> Lukarnenschalung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40501B63-59EE-4DF5-9F43-9B6AA0FA624C}', 'HY-{E36590D5-2521-4E85-8ACC-55C911057C34}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lukarnenverkleidung -> Lukarnenschalung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED842117-EAE0-40CB-8C6A-719BDDEA8E41}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Beton, Magerbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED842117-EAE0-40CB-8C6A-719BDDEA8E41}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Magerbeton -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{213D5EEA-2361-4CD5-9094-083427438084}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Beton, Magerbeton / 740 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{213D5EEA-2361-4CD5-9094-083427438084}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Magerbeton / 740 -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B1FD42-916B-4B11-B31A-EEB2F2C2E026}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- CH_Beton Magerbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B1FD42-916B-4B11-B31A-EEB2F2C2E026}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Beton Magerbeton -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58EA0674-6004-4FDC-9F7F-90C27B1A2C16}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Magerbeton / 730 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58EA0674-6004-4FDC-9F7F-90C27B1A2C16}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Magerbeton / 730 -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{40A86804-0B02-46FB-91AD-8EA42E7ECC84}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sauberkeitsschicht -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22BE2DE-3AA9-4D1D-A734-8A6C0C493F41}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerbeton -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{291C650B-9A8B-4CD3-B30E-C1F618BBFBD0}', 'HY-{A50C64EA-1980-4726-9911-A3682DAD4D92}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterlagsbeton -> Magerbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{084487FB-0B09-45EB-B643-76AFD661A056}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Metall - Profil -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{084487FB-0B09-45EB-B643-76AFD661A056}', 'HY-{E188BD02-CBA9-4953-B16A-BDCA42D4FCB7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Profil -> Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBCD7E58-BE85-4951-9998-9F6EA96BA2A4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:52'); -- Tür - Metall -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBCD7E58-BE85-4951-9998-9F6EA96BA2A4}', 'HY-{E188BD02-CBA9-4953-B16A-BDCA42D4FCB7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tür - Metall -> Metall
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5CB320B3-DA76-40E5-9595-B220E2C6B0FC}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Doppelrost -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0087C144-E873-4653-B3CD-48E8E1E8F2FC}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Einfachrost -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1507B7FA-2597-4250-90F0-74FD889F5AB5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Metall Unterkonstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1507B7FA-2597-4250-90F0-74FD889F5AB5}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall Unterkonstruktion -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56877A49-7294-4D30-8B26-E9630208151B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Metall, Unterkonstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{56877A49-7294-4D30-8B26-E9630208151B}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall, Unterkonstruktion -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F775933E-1D3E-440D-8EF6-4A44E6B02683}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallrost -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EC7E571E-B222-4EC3-B768-0961A0511F04}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallunterkonstruktion -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBCD2AB5-A3BF-443D-ADFB-772950B20F89}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profilrost -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{563F3B68-1748-43C5-B638-0B3D7CF2BF62}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rost -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5CD422B-3077-4F77-AD82-B8C780B37732}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlblechprofil -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D687BA7D-C70F-4812-8EF3-89D0AD3D0564}', 'HY-{56EBAE7F-073F-4296-B374-C9FE7AB1B0FD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragprofil -> Metall-Unterkonstruktion
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90902E28-AA0B-4BF8-B426-80BB428B9034}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Alu-Paneele -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90902E28-AA0B-4BF8-B426-80BB428B9034}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alu-Paneele -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB5FDB3D-6BD6-453E-B391-56846FDA8381}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Alu-Paneelen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB5FDB3D-6BD6-453E-B391-56846FDA8381}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alu-Paneelen -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ABD6DD9-13E8-40E8-82FD-6AE5391E4F69}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alupaneel -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B54FC8B8-3122-4891-BC30-A55CC903A579}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Bekleidung, Metall / 320 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B54FC8B8-3122-4891-BC30-A55CC903A579}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bekleidung, Metall / 320 -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A69A4FA9-BE34-48F9-ABE5-BE9E5B523C2E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Fassade - Metallpaneel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A69A4FA9-BE34-48F9-ABE5-BE9E5B523C2E}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fassade - Metallpaneel -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48CB7CFD-7722-4D21-A206-B1E51623339A}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gitterrost -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{695626CB-F118-4B19-A2F2-BC3057EE7E34}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:53'); -- Metalldecke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{695626CB-F118-4B19-A2F2-BC3057EE7E34}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metalldecke -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CCE2AA3-5132-4229-BFB6-7433FAB7FEF3}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallpaneel -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF556654-C3AD-4E33-8548-5D817EF6841E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Metallpaneele -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CF556654-C3AD-4E33-8548-5D817EF6841E}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallpaneele -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FF35FE6-7792-4503-A92C-EC6288CFD689}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallplatte -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{277BEA66-484D-4C66-9553-065640387938}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Metallplatten profiliert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{277BEA66-484D-4C66-9553-065640387938}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallplatten profiliert -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD4017BB-BE59-44B5-B3FB-6555A4BB7C78}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Paneel -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E57B29C6-080F-4A2E-9D18-D1555743B636}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Paneelen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E57B29C6-080F-4A2E-9D18-D1555743B636}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Paneelen -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{739F0247-BF6F-406A-A45F-FDEC5B04E0EB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Profilierte Metallplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{739F0247-BF6F-406A-A45F-FDEC5B04E0EB}', 'HY-{C5284E7F-3D27-4CC7-8927-840619132C8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Profilierte Metallplatten -> Metallplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0208A676-3331-410F-91B3-A53B2AF070D2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Putz wassericht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0208A676-3331-410F-91B3-A53B2AF070D2}', 'HY-{4B790B7A-0A63-413D-A725-40A230059EB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Putz wassericht -> Mörtel wasserdicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A33136B7-6DF1-483F-A416-AC920F9CB18E}', 'HY-{4B790B7A-0A63-413D-A725-40A230059EB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sperrputz -> Mörtel wasserdicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD424CD9-8801-47C6-97AE-BB0AA91DCDCD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Wasserdichter Mörtel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CD424CD9-8801-47C6-97AE-BB0AA91DCDCD}', 'HY-{4B790B7A-0A63-413D-A725-40A230059EB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Wasserdichter Mörtel -> Mörtel wasserdicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CDEB2534-8EB6-4EDF-8276-7FF15B588CDD}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551F70C1-2656-40E5-9A3E-25C7C3F28DEE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Granit / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{551F70C1-2656-40E5-9A3E-25C7C3F28DEE}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit / 140 -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC5D448D-D7EE-40FC-9BDB-E8E7F4939746}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3833DB62-79C0-422B-A218-0E1EC66855A5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Granitplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3833DB62-79C0-422B-A218-0E1EC66855A5}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E8E3D28-C544-4D4B-8014-8B28F7F116C9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:54'); -- Kalksandstein / Platten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4E8E3D28-C544-4D4B-8014-8B28F7F116C9}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein / Platten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B371EFD6-F3D1-48E3-A9A2-5CF13A05200F}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalkstein -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F88BB350-04CF-4CE7-AC0B-90EDFEECF37E}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksteinplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F23233D3-BBD3-4EC7-BB31-4B9460BE8FA0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Kalksteinplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F23233D3-BBD3-4EC7-BB31-4B9460BE8FA0}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksteinplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91CA3C8A-8206-43BE-B0B3-5077DC543593}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Limestone -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91CA3C8A-8206-43BE-B0B3-5077DC543593}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Limestone -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81D6B700-E328-4DF9-AACB-3A5DC32468CE}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16DD0D52-AD64-4104-91AF-B020E3566B30}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmorplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9FC75224-A3C1-4E4F-8539-68FCC2564CEF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Marmorplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9FC75224-A3C1-4E4F-8539-68FCC2564CEF}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmorplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9810A067-707A-4EB1-A750-50C054870234}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Naturstein / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9810A067-707A-4EB1-A750-50C054870234}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein / 140 -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBB8A0DE-C32B-41BB-B87A-D240D8B1D049}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Naturstein allgemein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BBB8A0DE-C32B-41BB-B87A-D240D8B1D049}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein allgemein -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70C69577-B0CB-491F-B7EA-EA8FCCDE6AA8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Naturstein Kalkstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{70C69577-B0CB-491F-B7EA-EA8FCCDE6AA8}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein Kalkstein -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31F24EEA-D478-4CEB-882C-72ACFEF26823}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Natursteinplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{31F24EEA-D478-4CEB-882C-72ACFEF26823}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Natursteinplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E01834E-DA76-4C55-823B-1CC712527A4A}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Natursteinplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EA3C08F-AC4A-4DA4-B6BD-C52564E21C2D}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Quarzith -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23C49DB1-1EC5-404E-B1CF-597C7EEAB234}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Quarzithplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B03BF4A4-B9E8-40D1-A7CA-CFD5DCB8C5FF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:55'); -- Quarzithplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B03BF4A4-B9E8-40D1-A7CA-CFD5DCB8C5FF}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Quarzithplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{35C7B94D-CA6C-48ED-952A-B282B4BA2673}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{338F78F4-99AF-48D7-96DB-51D4993F3C9B}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schieferplatte -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{392BC9EE-A6B7-4AF2-827E-9FB4BAED4EDB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Schieferplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{392BC9EE-A6B7-4AF2-827E-9FB4BAED4EDB}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schieferplatten -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37EA8C06-6A79-44F1-B5A2-B653C85111E6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Solnhofer -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37EA8C06-6A79-44F1-B5A2-B653C85111E6}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28922387-1772-4C5A-ACD3-3278A2280DD2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Treppe - Naturstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{28922387-1772-4C5A-ACD3-3278A2280DD2}', 'HY-{77C66C8F-F1F6-48F1-95E5-1818F77E2887}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Treppe - Naturstein -> Naturstein
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36F58DEB-19CF-49BF-A2A6-9034CC3C0D0D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36F58DEB-19CF-49BF-A2A6-9034CC3C0D0D}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51ACE1F5-4652-4B32-A54D-651D916C131E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{51ACE1F5-4652-4B32-A54D-651D916C131E}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9C159D3-17B8-42D3-A1C7-745247320573}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9C159D3-17B8-42D3-A1C7-745247320573}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit renoviert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE5B3A39-7993-4110-8E30-47C1175C69E4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE5B3A39-7993-4110-8E30-47C1175C69E4}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22B6FF5-C2DA-4581-81A2-BD854D0FAEB2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C22B6FF5-C2DA-4581-81A2-BD854D0FAEB2}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED8C31F-6936-4D24-9982-79457DC72845}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granit-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8ED8C31F-6936-4D24-9982-79457DC72845}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granit-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDEFA3F8-125A-4E3B-8693-70434543FA5D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDEFA3F8-125A-4E3B-8693-70434543FA5D}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EFA1EE2-C62F-4D4E-8650-62E0754ECF63}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5EFA1EE2-C62F-4D4E-8650-62E0754ECF63}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FF75DAE-A56A-4341-A884-69D7BEA70E3E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FF75DAE-A56A-4341-A884-69D7BEA70E3E}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten renoviert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA36B42B-3A1C-45FB-BC47-ED65234CA624}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA36B42B-3A1C-45FB-BC47-ED65234CA624}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten saniert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F77BD13E-0871-4BB9-846A-6C2A5E8A804B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F77BD13E-0871-4BB9-846A-6C2A5E8A804B}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEBCDF0B-4E8F-4964-B5BE-F206567CBDB8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:56'); -- Granitplatten-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EEBCDF0B-4E8F-4964-B5BE-F206567CBDB8}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF85E39A-237D-4D74-A68D-72975A71B797}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Granitplatten-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF85E39A-237D-4D74-A68D-72975A71B797}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Granitplatten-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E7E9B55F-6F6B-4DA2-BD14-8B593A78802A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E7E9B55F-6F6B-4DA2-BD14-8B593A78802A}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B615CA3-A034-4226-8EAE-AD3B0B2F073C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4B615CA3-A034-4226-8EAE-AD3B0B2F073C}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45E1EA4A-7784-4169-8E80-57A3DEAD89D2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{45E1EA4A-7784-4169-8E80-57A3DEAD89D2}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor saniert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F292AF37-2A31-4DC0-946D-4FC5BE8764F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F292AF37-2A31-4DC0-946D-4FC5BE8764F0}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A74BF2B0-DF8E-4C3C-BEAC-88CE1B059C9F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A74BF2B0-DF8E-4C3C-BEAC-88CE1B059C9F}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78B6E665-CA7E-4687-ABDD-8E9FB0D1F8AD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Marmor-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{78B6E665-CA7E-4687-ABDD-8E9FB0D1F8AD}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Marmor-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E70245F-F0AE-4743-9BCE-F68C652BBF9F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Naturstein neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8E70245F-F0AE-4743-9BCE-F68C652BBF9F}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CBFADF7-128F-4391-93E8-20694002C24B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Naturstein renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3CBFADF7-128F-4391-93E8-20694002C24B}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein renoviert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C19C51B6-9ACF-4081-A2AE-98DB707AC68C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Naturstein saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C19C51B6-9ACF-4081-A2AE-98DB707AC68C}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein saniert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79805E76-F834-4013-B248-5366C5F43A2A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Naturstein-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79805E76-F834-4013-B248-5366C5F43A2A}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3E22F62-A8EF-4C12-AF47-C4EDBF458E5B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Naturstein-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3E22F62-A8EF-4C12-AF47-C4EDBF458E5B}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Naturstein-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CE05F37-6B8A-4521-9DB0-8776D437EEEE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Schiefer neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CE05F37-6B8A-4521-9DB0-8776D437EEEE}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9336A9D3-6FBB-43CE-845C-E3AFDA7B91F4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Schiefer Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9336A9D3-6FBB-43CE-845C-E3AFDA7B91F4}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{239FCD26-EF3A-4C59-BEEB-194D0A745F46}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:57'); -- Schiefer saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{239FCD26-EF3A-4C59-BEEB-194D0A745F46}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer saniert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF97B188-32DE-455D-859C-06456B672309}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Schiefer Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF97B188-32DE-455D-859C-06456B672309}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2077D467-0298-4F79-8374-8E75300996E5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Schiefer-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2077D467-0298-4F79-8374-8E75300996E5}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8A6D207-99DC-4568-8A0E-5037B0CB7D1E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Schiefer-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E8A6D207-99DC-4568-8A0E-5037B0CB7D1E}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schiefer-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C70721A5-BE5D-4C15-95AC-05BE4EE39494}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C70721A5-BE5D-4C15-95AC-05BE4EE39494}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer neu -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFF84FF8-1CB1-4FA9-BBF4-86D408D3FA36}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFF84FF8-1CB1-4FA9-BBF4-86D408D3FA36}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90FBA2BF-3EFF-4274-B538-A8D0892AE4AF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{90FBA2BF-3EFF-4274-B538-A8D0892AE4AF}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer saniert -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48800E42-4842-443C-81DA-57F4E7CC1718}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48800E42-4842-443C-81DA-57F4E7CC1718}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07543FFB-BB05-4D8A-BAC8-6C6913D67B59}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07543FFB-BB05-4D8A-BAC8-6C6913D67B59}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer-Renovation -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54190888-CC5E-487B-94C3-849505B1B398}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Solnhofer-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54190888-CC5E-487B-94C3-849505B1B398}', 'HY-{751A759D-D35B-4F51-9DAB-22F956814D4C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Solnhofer-Sanierung -> Naturstein Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F161BC4B-3677-438E-B5D3-D263082173E5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Noppen-Bahn -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F161BC4B-3677-438E-B5D3-D263082173E5}', 'HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Noppen-Bahn -> Noppenbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D67763B-A405-440A-A35E-B2ED0AD9947E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Noppenbahnen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D67763B-A405-440A-A35E-B2ED0AD9947E}', 'HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Noppenbahnen -> Noppenbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79ABACA6-65F3-4E8C-AB86-AE2103206224}', 'HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Noppenfolie -> Noppenbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{97301D60-40C9-4B64-AD75-162554953672}', 'HY-{175D52A7-A51E-4173-B8C2-57622A8689DC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Noppenmatte -> Noppenbahn
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4AAC9F4-2BF0-4DB5-94D7-CD4F024A30AD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Cupolux -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4AAC9F4-2BF0-4DB5-94D7-CD4F024A30AD}', 'HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Cupolux -> Oberlicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD97D5D2-1F28-43EC-9137-8223D04E02C6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:58'); -- Glasoberlicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD97D5D2-1F28-43EC-9137-8223D04E02C6}', 'HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glasoberlicht -> Oberlicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C68B3CA-0B0E-46FF-B59B-8F05ADC806EB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Lichtband -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C68B3CA-0B0E-46FF-B59B-8F05ADC806EB}', 'HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lichtband -> Oberlicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C95DEA8-1B4D-45CA-89E7-C21AA5A2E2DF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Lichtkuppel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C95DEA8-1B4D-45CA-89E7-C21AA5A2E2DF}', 'HY-{CAD2B81F-66F7-4657-9038-5244F25F156F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Lichtkuppel -> Oberlicht
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3FFE6AC-754D-47F0-8595-4837FA34C995}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Belag, Pflaster -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D3FFE6AC-754D-47F0-8595-4837FA34C995}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Belag, Pflaster -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D54B669E-FC58-465A-A6C3-A4058B0AAD13}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonverbundstein -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{129C23CA-866D-4B3F-8D90-6BEE8591B7AB}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pflasterstein -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FF0B020-3237-4EFB-B411-9D1DC3217D5C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Pflasterstein / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1FF0B020-3237-4EFB-B411-9D1DC3217D5C}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pflasterstein / 140 -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2E2571FC-3834-467A-9D67-836F6E8A0E0D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Pflastersteine -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2E2571FC-3834-467A-9D67-836F6E8A0E0D}', 'HY-{E282977C-9513-48CA-B33E-5BF643436239}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pflastersteine -> Pflästerung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B37F528-C350-4160-A195-53899B4D01C5}', 'HY-{88D5142C-064B-4DCF-B1BB-7FD7A874152B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfosten-Riegel-Konstruktion -> Pfosten-Riegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4707B74B-3F1D-4A70-8DBA-673BAC86395E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Pfosten/Riegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4707B74B-3F1D-4A70-8DBA-673BAC86395E}', 'HY-{88D5142C-064B-4DCF-B1BB-7FD7A874152B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Pfosten/Riegel -> Pfosten-Riegel
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5BA4C9C-C457-47E2-B374-5E184B86F9DA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Plattenmauerwerk Betonstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C5BA4C9C-C457-47E2-B374-5E184B86F9DA}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plattenmauerwerk Betonstein -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F41E219-3D8E-4D93-A06B-B327AC9EEC49}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Plattenmauerwerk Zementstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1F41E219-3D8E-4D93-A06B-B327AC9EEC49}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Plattenmauerwerk Zementstein -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7ADB1C34-D3A6-475E-A2C4-27155C3BCD8E}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zellton -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{987B2F8B-6BB7-44CD-BCCC-445D40913C09}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zelltonplatten -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2235E068-40F1-4B30-B1F1-1E88BE82EE8E}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegelbauplatten -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{788F570E-262D-4156-983A-36B9C5A3F963}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:58:59'); -- Ziegelwandbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{788F570E-262D-4156-983A-36B9C5A3F963}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ziegelwandbauplatten -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C809DA1-6EBF-44AF-B485-BE0689241FB7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- ZP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3C809DA1-6EBF-44AF-B485-BE0689241FB7}', 'HY-{A9D37FE8-9FB8-47E1-A077-7D30555B4CAC}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- ZP -> Plattenmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A5B4A2-9918-456F-B5F0-7376A4A762ED}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Alba -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67A5B4A2-9918-456F-B5F0-7376A4A762ED}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alba -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1DED524F-0B26-4D1B-A75D-2D0908FEF033}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Alba hydro -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1DED524F-0B26-4D1B-A75D-2D0908FEF033}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Alba hydro -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73D82317-A75D-4EE6-84A3-6AA1B75C865A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Albaphon -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73D82317-A75D-4EE6-84A3-6AA1B75C865A}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Albaphon -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE45BDD7-8D5C-4391-890B-AC2196A219E3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Albatherm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CE45BDD7-8D5C-4391-890B-AC2196A219E3}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Albatherm -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7BA5787-D74F-4FB2-ACC4-DA0F9BE9F610}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ausbauplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3BA866E4-7100-4C8C-91F4-259B920D57A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Ausbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3BA866E4-7100-4C8C-91F4-259B920D57A8}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ausbauplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ED14911-C57E-40DF-A524-9CBEF1EE1E0E}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bauplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D50FC3B-219A-4947-8148-C9614425FA25}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Bauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D50FC3B-219A-4947-8148-C9614425FA25}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Bauplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF0C0DEE-F581-4447-B6A0-799F27382FBC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Gips-Wandbauplatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BF0C0DEE-F581-4447-B6A0-799F27382FBC}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gips-Wandbauplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B302DF1-AADD-405D-BA1C-18A14B06E2A3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Gips-Wandbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0B302DF1-AADD-405D-BA1C-18A14B06E2A3}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gips-Wandbauplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E124A5A8-0939-4B24-A0DF-6589914173CC}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsausbauplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{552C7847-38F0-4858-818C-BC8BF0351746}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Gipsausbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{552C7847-38F0-4858-818C-BC8BF0351746}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipsausbauplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4A2C3CBA-CF19-4BDB-9A2A-E0D5E6601DAC}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipswandbauplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1BB9AE4-4D1A-4C4A-B9B6-A7A982259B5F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:00'); -- Gipswandbauplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E1BB9AE4-4D1A-4C4A-B9B6-A7A982259B5F}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipswandbauplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2649424F-9988-4A12-8F6B-74933169212C}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollgips -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75D16018-9787-4750-B3CB-B7FBCE87027D}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollgipsplatte -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7084AFE-5E75-49A8-802B-930AA3CE5B4D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Vollgipsplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7084AFE-5E75-49A8-802B-930AA3CE5B4D}', 'HY-{9369F070-8C3D-4B01-B51C-5EAFCCD4509B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollgipsplatten -> Plattenwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7080459-9868-41B5-9D97-3660BA51B8F0}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dämmbeton -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F440F262-54B6-4867-B5E2-A48CACC40C33}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gasbeton -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED5D0950-A825-4CFB-9BD3-90B19461641E}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gasbetonstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB2391A9-3C7B-430F-A878-94C9DBFBB9D9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Leicht-Porenbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DB2391A9-3C7B-430F-A878-94C9DBFBB9D9}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leicht-Porenbeton -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{898EEA58-AB33-4CC9-A30D-9FB27581B29B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Leicht-Porenbetonstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{898EEA58-AB33-4CC9-A30D-9FB27581B29B}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leicht-Porenbetonstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A1A2F9D-A29F-4400-94DC-1DB046FAE7E3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- MP -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A1A2F9D-A29F-4400-94DC-1DB046FAE7E3}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MP -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9853AD2D-7CB3-4EB6-BBDE-66C3E6705A41}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- MPD -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9853AD2D-7CB3-4EB6-BBDE-66C3E6705A41}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MPD -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D203C57A-DC68-4FE8-A059-F3E9B08AEB03}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- MPL -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D203C57A-DC68-4FE8-A059-F3E9B08AEB03}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MPL -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{109D7DDE-D317-4141-B8EB-18448956DCF5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Planblock PPW -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{109D7DDE-D317-4141-B8EB-18448956DCF5}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Planblock PPW -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9D7C6E0-8CDD-4B89-86FB-A988A66FC841}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Porenbet.Verb.ST -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B9D7C6E0-8CDD-4B89-86FB-A988A66FC841}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbet.Verb.ST -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A185C41B-6B21-4150-8EB0-16382E0D55C1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:01'); -- Porenbeton-Verbundstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A185C41B-6B21-4150-8EB0-16382E0D55C1}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbeton-Verbundstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FCD9318A-A44A-4651-8B36-2C58593B8E83}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbetonstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D66518C-E043-421E-9A29-25F87E1E959B}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenbetonverbundstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E118B37C-EC1D-4186-864C-4006CC66E5D2}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenleichtbeton -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE330FC6-694E-44DA-B1BC-B6846D3301DD}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Porenleichtbetonstein -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EF630C1-D179-435D-84D8-B7959A676B94}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- PPEW -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0EF630C1-D179-435D-84D8-B7959A676B94}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PPEW -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD20526D-8406-49BC-8CA3-97C3AE03FDD6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- PPN -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BD20526D-8406-49BC-8CA3-97C3AE03FDD6}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PPN -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9711DF1-3434-46CA-98FA-79DBE838009B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- PPpl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9711DF1-3434-46CA-98FA-79DBE838009B}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PPpl -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C649729-53D8-4CC6-BA82-86BC4BB96421}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- PPSW -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C649729-53D8-4CC6-BA82-86BC4BB96421}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PPSW -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6EE0A71A-8763-4C9B-B22C-80B7D4042E77}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- PPW -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6EE0A71A-8763-4C9B-B22C-80B7D4042E77}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PPW -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EB0D32-D438-4E41-B5CD-54C94D7A4E1A}', 'HY-{C5157905-D57C-4C60-BF29-938A97FBFC6C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Ytong -> Porenbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7AADE7C8-1DB2-45AC-B380-1CAF5CD427E7}', 'HY-{54867749-FF75-4A51-AD06-9C75E358EB96}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Putzträger -> Putzträgerplatte
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{61C5F456-03F6-46AA-B8F4-4A7C40513933}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Begrünung -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F62148B0-1B81-4F5B-A301-5B9565CEA3E4}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gras -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBC9CF6C-2BD1-4B16-AF23-E30472509ECA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- Grasfläche -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBC9CF6C-2BD1-4B16-AF23-E30472509ECA}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Grasfläche -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63D41082-CCF1-4A3B-BAF6-576C04DB69EA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- Rasen / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{63D41082-CCF1-4A3B-BAF6-576C04DB69EA}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rasen / 140 -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0ECDE985-4339-4321-9A65-FBC4DE9E21F0}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Rollrasen -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0BD169E2-7E59-43CB-A97C-31BBE3C55528}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- Umgebung - Gras -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0BD169E2-7E59-43CB-A97C-31BBE3C55528}', 'HY-{E3AAF76B-386D-428A-896E-29834BF3A533}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Umgebung - Gras -> Rasen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D824B8A-94D4-483C-B636-87543EFB3B00}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:02'); -- Beton roh -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D824B8A-94D4-483C-B636-87543EFB3B00}', 'HY-{A0A05C72-7B3B-45AB-8EF6-5EFD459ADF4E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton roh -> Roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{799CD5E9-44BA-4B5D-9DE4-D7E5F97C3CD1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- roh -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{799CD5E9-44BA-4B5D-9DE4-D7E5F97C3CD1}', 'HY-{A0A05C72-7B3B-45AB-8EF6-5EFD459ADF4E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- roh -> Roh
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52BBD30B-6E9D-47FF-9FDF-EADEB174B645}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Schmutzfang -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52BBD30B-6E9D-47FF-9FDF-EADEB174B645}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzfang -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86D2A1E0-8E58-41B2-8078-6F69E3B9E969}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Schmutzfangmatte -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{86D2A1E0-8E58-41B2-8078-6F69E3B9E969}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzfangmatte -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AFD89BA-1F99-4C04-87F7-940E6AE947E5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Schmutzfangteppich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4AFD89BA-1F99-4C04-87F7-940E6AE947E5}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzfangteppich -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5028E47-9D89-4ED0-BBEB-F62023B8EB64}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Schmutzschleusenteppich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5028E47-9D89-4ED0-BBEB-F62023B8EB64}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzschleusenteppich -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9F1218C-9DF9-42CC-A130-281F1CA33E5C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Schmutzteppich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C9F1218C-9DF9-42CC-A130-281F1CA33E5C}', 'HY-{CD6C3535-DD5B-4770-8082-8E45EC2AD804}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schmutzteppich -> Schmutzschleuse
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B421925E-03C4-4283-95D6-A98FD9330FAD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- B-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B421925E-03C4-4283-95D6-A98FD9330FAD}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- B-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7FDB3206-6600-44FF-9B32-3795349E9476}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Betonrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7FDB3206-6600-44FF-9B32-3795349E9476}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82DAC5A8-15BA-48D7-8451-5CF69798E00F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Betonrohr B-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{82DAC5A8-15BA-48D7-8451-5CF69798E00F}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonrohr B-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDA2C2D8-3DA6-4D3F-9D6C-FA41E8EE2C4C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Betonrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BDA2C2D8-3DA6-4D3F-9D6C-FA41E8EE2C4C}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49FA248C-95A2-4B3B-AE5E-39F12F45E307}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Betonrohre B-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49FA248C-95A2-4B3B-AE5E-39F12F45E307}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonrohre B-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27BCF732-F6B8-4C91-9A06-A786245F0414}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Eternitrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27BCF732-F6B8-4C91-9A06-A786245F0414}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternitrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9008A68A-8FEE-498E-BC8C-287269D1AB30}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Eternitrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9008A68A-8FEE-498E-BC8C-287269D1AB30}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eternitrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16EEFCD9-690D-4F05-B668-4F6B1F65BCA2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:03'); -- Faserzementrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{16EEFCD9-690D-4F05-B668-4F6B1F65BCA2}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{004FD344-4579-4DB3-BBC3-55BE2AF568CE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Faserzementrohr FZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{004FD344-4579-4DB3-BBC3-55BE2AF568CE}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementrohr FZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F96F7B19-3BA3-4192-AF63-A1D3CB05BDCD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Faserzementrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F96F7B19-3BA3-4192-AF63-A1D3CB05BDCD}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D65CC53-D9CD-4A4B-B401-34D2E0FD95B6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Faserzementrohre FZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7D65CC53-D9CD-4A4B-B401-34D2E0FD95B6}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Faserzementrohre FZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64A0A59F-0DB3-4E85-85B1-E197F4C2EB84}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- FZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64A0A59F-0DB3-4E85-85B1-E197F4C2EB84}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- FZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FBB6342-5C72-4E7A-93FA-EBF186C65A4A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- GFK-UP-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FBB6342-5C72-4E7A-93FA-EBF186C65A4A}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GFK-UP-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7890AC45-9FDB-4863-BA0B-5A2903086406}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- GGG-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7890AC45-9FDB-4863-BA0B-5A2903086406}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- GGG-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF46056-12EF-489C-BCAF-68FCF9040FE0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Guss GGG-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4EF46056-12EF-489C-BCAF-68FCF9040FE0}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Guss GGG-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5579BDE-7F21-4C85-A701-2736D772F7BA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Gussrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5579BDE-7F21-4C85-A701-2736D772F7BA}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gussrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4DB100C-51A2-4057-AF5A-83F33BD22154}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Gussrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4DB100C-51A2-4057-AF5A-83F33BD22154}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gussrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BFBBA9DD-A9EB-4FFA-84CA-5A7C8D42C82B}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PE -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73595AC8-EC0A-4A3A-9E4E-3D619F10F244}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- PE-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73595AC8-EC0A-4A3A-9E4E-3D619F10F244}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PE-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEFD037E-ABE4-4336-B407-889E9D487D00}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- PE-Rohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BEFD037E-ABE4-4336-B407-889E9D487D00}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PE-Rohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ACC5F2-5E35-4F78-B2B4-1992A2BF6957}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- PE-Rohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48ACC5F2-5E35-4F78-B2B4-1992A2BF6957}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PE-Rohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{251F2D0D-9A74-45FA-B287-1799CD4B76F6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Polyethylen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{251F2D0D-9A74-45FA-B287-1799CD4B76F6}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylen -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52DC750C-A3C2-485F-9529-2079C09A6C8D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:04'); -- Polyethylenrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{52DC750C-A3C2-485F-9529-2079C09A6C8D}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylenrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{015056D8-1993-40D3-9028-22B737ADF0DC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polyethylenrohr PE-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{015056D8-1993-40D3-9028-22B737ADF0DC}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylenrohr PE-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{165FA69B-7750-4ADC-9FAF-D5089A361C2E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polyethylenrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{165FA69B-7750-4ADC-9FAF-D5089A361C2E}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylenrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5E8572E-4BAA-4DAF-B406-D3D7DFCF24CF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polyethylenrohre PE-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D5E8572E-4BAA-4DAF-B406-D3D7DFCF24CF}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylenrohre PE-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CF6085A-EF6D-4B0D-9A43-B5016ABBF4D4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polypropen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9CF6085A-EF6D-4B0D-9A43-B5016ABBF4D4}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropen -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB69E835-0EEB-452F-AB9F-9F69C3E7767A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polypropylenrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AB69E835-0EEB-452F-AB9F-9F69C3E7767A}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylenrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D291F356-8759-4C7D-8B15-FB3B0A8AE10C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polypropylenrohr PP-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D291F356-8759-4C7D-8B15-FB3B0A8AE10C}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylenrohr PP-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C1704C2-FA0F-44B7-BD2C-3186F1F94178}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polypropylenrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9C1704C2-FA0F-44B7-BD2C-3186F1F94178}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylenrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAC6EE0D-15CE-4B85-99B4-AE5473DC811D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polypropylenrohre PP-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BAC6EE0D-15CE-4B85-99B4-AE5473DC811D}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylenrohre PP-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BF5F9A7-999A-44FD-9215-93B74DB55957}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- Polyvinilchlorid -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4BF5F9A7-999A-44FD-9215-93B74DB55957}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyvinilchlorid -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3DA4E40-8C4F-4636-A491-DEB64F2772A7}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PP -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54A8C603-63F8-4B6F-8928-4EFC2678A002}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- PP-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54A8C603-63F8-4B6F-8928-4EFC2678A002}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PP-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{197873F6-E769-40FA-A2A5-4236E0987AD3}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBBDA334-343C-423E-B87F-26DC012BD051}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- PVC-Rohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CBBDA334-343C-423E-B87F-26DC012BD051}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-Rohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED9E6FC5-4777-484E-B601-3CDB1AEBFC68}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- PVC-Rohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ED9E6FC5-4777-484E-B601-3CDB1AEBFC68}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-Rohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22E96804-A1D8-41F7-81FA-8DF948CC5636}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:05'); -- PVC-U-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{22E96804-A1D8-41F7-81FA-8DF948CC5636}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-U-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2CBB18E-0E70-4413-9242-1945C73C4935}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- SBR -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A2CBB18E-0E70-4413-9242-1945C73C4935}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBR -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{109EA659-79F4-43E7-9BD4-9BF7BE84E1FC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Steinzeugrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{109EA659-79F4-43E7-9BD4-9BF7BE84E1FC}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugrohr -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BACF32F9-4AB9-43F3-9241-D3DE1DE0AD9D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Steinzeugrohr STZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BACF32F9-4AB9-43F3-9241-D3DE1DE0AD9D}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugrohr STZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{818AFA1B-A7A0-4139-9248-71633A2CBC86}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Steinzeugrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{818AFA1B-A7A0-4139-9248-71633A2CBC86}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugrohre -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41BE3449-9A0D-4D6C-A180-0AEB8B209058}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Steinzeugrohre STZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41BE3449-9A0D-4D6C-A180-0AEB8B209058}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugrohre STZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E95064A-DAF6-4C5C-B161-594CC7A5DB64}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- STZ-R -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9E95064A-DAF6-4C5C-B161-594CC7A5DB64}', 'HY-{447BED0D-6AE7-4195-9D7F-6330DDD7F1FA}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- STZ-R -> Schmutzwasserleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDF295C2-C6D9-492D-A127-EABDAAC68A40}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Beton Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FDF295C2-C6D9-492D-A127-EABDAAC68A40}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton Sicht -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D0BCD64-D32C-4E4B-BBBB-DAA04D4468C3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Beton-Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D0BCD64-D32C-4E4B-BBBB-DAA04D4468C3}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Sicht -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44F43A3E-F013-49AB-BF66-F3ADD6647653}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Beton, Sichtbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44F43A3E-F013-49AB-BF66-F3ADD6647653}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Sichtbeton -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC136D2E-4DB8-4B13-8F6C-71937FF8AA49}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- Beton, Sichtbeton / 780 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC136D2E-4DB8-4B13-8F6C-71937FF8AA49}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton, Sichtbeton / 780 -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D18FF1A-BF91-443C-9290-1B70A6577A04}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- CH_Sichtbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1D18FF1A-BF91-443C-9290-1B70A6577A04}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Sichtbeton -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3CF35A2-BD31-4923-8A01-B67B1F5FBA62}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- SBK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C3CF35A2-BD31-4923-8A01-B67B1F5FBA62}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBK -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07C81235-AF4F-4397-A1AB-B770527A3FCA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- SBK 1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{07C81235-AF4F-4397-A1AB-B770527A3FCA}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBK 1 -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2872EB8-71A9-413F-B324-C8F72CD09C74}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- SBK 2 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B2872EB8-71A9-413F-B324-C8F72CD09C74}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBK 2 -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3557CA5-5A80-4703-8F95-06BA5D58BD1E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:06'); -- SBK 3 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A3557CA5-5A80-4703-8F95-06BA5D58BD1E}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBK 3 -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67330277-CC75-452F-84A9-8AAFC776AAC9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- SBK S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67330277-CC75-452F-84A9-8AAFC776AAC9}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- SBK S -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44E2AB7-1338-4A21-B61C-3B4DF74A6C6E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Stahlbeton - Sichtbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44E2AB7-1338-4A21-B61C-3B4DF74A6C6E}', 'HY-{249C62D6-A002-4C81-AF6A-D293D4132F8F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Stahlbeton - Sichtbeton -> Sichtbeton
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8102E3B2-6D9D-4987-AFA7-BCBC53EC30B5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- B-Inside -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8102E3B2-6D9D-4987-AFA7-BCBC53EC30B5}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- B-Inside -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{489B528C-580C-4B98-A32F-354D0BC7F219}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Backstein bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{489B528C-580C-4B98-A32F-354D0BC7F219}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AD49B72-66F2-4F45-BB38-3B3F53EF8F36}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Backstein MB bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6AD49B72-66F2-4F45-BB38-3B3F53EF8F36}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein MB bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B76385F9-27A8-4E9D-84C2-CE8CA169A4EA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Backstein MB nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B76385F9-27A8-4E9D-84C2-CE8CA169A4EA}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein MB nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34E6BB5A-1E90-4A86-9C9D-29302FD5582C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Backstein nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{34E6BB5A-1E90-4A86-9C9D-29302FD5582C}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{229CA218-F0C1-4A31-9B8A-090B9C5CB84F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- CH_Sichtziegel -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{229CA218-F0C1-4A31-9B8A-090B9C5CB84F}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Sichtziegel -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A4E2CFDE-6808-4676-9F6E-3C1CCA3EE0E6}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holländerstein -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A867CA08-A5CE-43D4-93A6-DAB23B760E50}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Inside -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A867CA08-A5CE-43D4-93A6-DAB23B760E50}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Inside -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D20778-46A5-47D7-B6BC-EBE28897BFA6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Kalksandstein bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D9D20778-46A5-47D7-B6BC-EBE28897BFA6}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{966D4C0E-81E1-4AA9-A660-6BAC880AD13B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Kalksandstein MK bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{966D4C0E-81E1-4AA9-A660-6BAC880AD13B}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein MK bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAEF315D-560A-45D1-98FD-C78E4A2E8D85}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Kalksandstein MK nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAEF315D-560A-45D1-98FD-C78E4A2E8D85}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein MK nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF370821-C1A8-42B8-8001-41A6E8546805}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- Kalksandstein nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FF370821-C1A8-42B8-8001-41A6E8546805}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Kalksandstein nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{562AFD5B-C5A8-4159-B958-28B91A7DE78C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:07'); -- KHLz B -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{562AFD5B-C5A8-4159-B958-28B91A7DE78C}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KHLz B -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B00C761-93B2-472E-A9ED-DC797E2C84B9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3B00C761-93B2-472E-A9ED-DC797E2C84B9}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26CBA128-CB60-4530-8647-23184FF4534E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS n.bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{26CBA128-CB60-4530-8647-23184FF4534E}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS n.bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA6A4355-7300-4C24-BC68-ACAE7CD7B34D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AA6A4355-7300-4C24-BC68-ACAE7CD7B34D}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F486D21F-EE36-47E2-9014-755C7CDB8E5C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Sicht -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F486D21F-EE36-47E2-9014-755C7CDB8E5C}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Sicht -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{969A0A55-2D5D-4300-89C4-09183EB927B8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Sichtm. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{969A0A55-2D5D-4300-89C4-09183EB927B8}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Sichtm. -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7BE7C75-4E3A-4A80-9E9D-CFEE30488511}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Sichtmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D7BE7C75-4E3A-4A80-9E9D-CFEE30488511}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Sichtmauerwerk -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEEEFDD1-9A76-462C-929E-513F3B665057}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Vb -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DEEEFDD1-9A76-462C-929E-513F3B665057}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Vb -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55FEC788-5EB8-4818-A5F7-C9EE5839D200}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Vb SFK -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55FEC788-5EB8-4818-A5F7-C9EE5839D200}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Vb SFK -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC246BED-3FEF-480B-B697-2A64DF25D608}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS VbL -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BC246BED-3FEF-480B-B697-2A64DF25D608}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS VbL -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC18F1CD-A7CB-4F56-AC23-F79663CBBA5B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS Vm -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DC18F1CD-A7CB-4F56-AC23-F79663CBBA5B}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS Vm -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32FD95C8-1F5F-4965-8DF5-FDC48D9A535A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS VmL -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{32FD95C8-1F5F-4965-8DF5-FDC48D9A535A}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS VmL -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBBE94AA-C4F2-43B6-AF23-EE0B0C719EC4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS-Verblender -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBBE94AA-C4F2-43B6-AF23-EE0B0C719EC4}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Verblender -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F00D1C61-DBD8-4D7F-A2BA-1EFB9F565148}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- KS-Verblendmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F00D1C61-DBD8-4D7F-A2BA-1EFB9F565148}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- KS-Verblendmauerwerk -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ECEA7E8-4160-4C7F-85EF-E393FC92F55B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- Mauerwerk - Sichtmauerwerk -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9ECEA7E8-4160-4C7F-85EF-E393FC92F55B}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Mauerwerk - Sichtmauerwerk -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{267F55C6-0A35-45A3-84FA-57FB59AAB64A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:08'); -- MB bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{267F55C6-0A35-45A3-84FA-57FB59AAB64A}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MB bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAD37732-8EEE-41E2-B432-0A42D0FA4823}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MB n.bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EAD37732-8EEE-41E2-B432-0A42D0FA4823}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MB n.bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{350EFAF6-0147-4A2A-8325-948BE1F58A88}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MB nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{350EFAF6-0147-4A2A-8325-948BE1F58A88}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MB nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{215309D5-FDF6-4BB2-99DA-212E91DF855E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MC bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{215309D5-FDF6-4BB2-99DA-212E91DF855E}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MC bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBAFC16F-B990-45BC-BD1B-4C55BE9D3B90}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MC n.bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FBAFC16F-B990-45BC-BD1B-4C55BE9D3B90}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MC n.bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D4855FB-2E95-4A00-84CC-73A0DE1EE4BF}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MC nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D4855FB-2E95-4A00-84CC-73A0DE1EE4BF}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MC nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFA6EEB7-310C-4465-B1EA-4AA10EC1BA87}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MK n.bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AFA6EEB7-310C-4465-B1EA-4AA10EC1BA87}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MK n.bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{037CF6E8-ECF2-417E-B68D-57918021D4F6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- MK nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{037CF6E8-ECF2-417E-B68D-57918021D4F6}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- MK nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB3ED15F-1019-40E2-9C90-DA17C6D4CEE2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- Sicht KS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FB3ED15F-1019-40E2-9C90-DA17C6D4CEE2}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sicht KS -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF49F7CB-1725-409B-9C3F-8B22AF7DB142}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- Sicht ZS -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AF49F7CB-1725-409B-9C3F-8B22AF7DB142}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sicht ZS -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BADF56DF-9170-4F6F-9737-96F14EDC187F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- Sichtkalksandst. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{BADF56DF-9170-4F6F-9737-96F14EDC187F}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtkalksandst. -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6ED12D39-7307-4B7C-95E5-EBAC9FB21BEE}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtkalksandstein -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23258567-FFC4-431E-9FB3-EE0B947060EE}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:09'); -- Sichtzementst. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{23258567-FFC4-431E-9FB3-EE0B947060EE}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtzementst. -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{343E6211-72C9-4556-B8BC-7980014FF4EC}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sichtzementstein -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B1428FFC-6490-493D-974F-CFFD4AA9792A}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verblender -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5B42B77-660C-476A-B1D4-B9C2FC6306F5}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verblendziegel -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48F39C21-BFA6-4DD9-BCD2-B233F1467162}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- VHLz B -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{48F39C21-BFA6-4DD9-BCD2-B233F1467162}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- VHLz B -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3759B04-6A5E-4180-9FD6-9970C0D39C12}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- VMz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E3759B04-6A5E-4180-9FD6-9970C0D39C12}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- VMz -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C9988B4-62D8-4A17-8B55-E0389A596C3E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Vmz -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2C9988B4-62D8-4A17-8B55-E0389A596C3E}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vmz -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{73E4570E-9344-487F-B73C-2F8EC7CF96E9}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vormauerziegel -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67936FB1-7288-4361-81B3-A482E41379E1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Zementstein bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{67936FB1-7288-4361-81B3-A482E41379E1}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementstein bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D793E28-9C9D-4AD8-945D-05BB543224A5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Zementstein MC bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2D793E28-9C9D-4AD8-945D-05BB543224A5}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementstein MC bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FAF22EB-E8B5-4BED-BC19-ABFAD6E1D4C2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Zementstein MC nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5FAF22EB-E8B5-4BED-BC19-ABFAD6E1D4C2}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementstein MC nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF890EFF-A489-4BCC-94A8-79A13C6AB84C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Zementstein n.bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DF890EFF-A489-4BCC-94A8-79A13C6AB84C}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementstein n.bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29478EA0-E563-45D0-9E0A-DB96E5B9A3CA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Zementstein nicht bewittert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{29478EA0-E563-45D0-9E0A-DB96E5B9A3CA}', 'HY-{79164DBD-5253-42D9-B790-579D506C0708}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zementstein nicht bewittert -> Sichtmauerwerk
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7ED3DF3-8090-42FF-A531-EE320746C1CD}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Beton-Sickerleitung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7ED3DF3-8090-42FF-A531-EE320746C1CD}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Beton-Sickerleitung -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4736E05A-567B-43E9-AFCA-09A0EDF6AF7B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Betonsickerrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4736E05A-567B-43E9-AFCA-09A0EDF6AF7B}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonsickerrohr -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{234501B8-2602-4055-B22B-A3E025F7C910}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Betonsickerrohr B-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{234501B8-2602-4055-B22B-A3E025F7C910}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonsickerrohr B-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{285CA767-1746-4024-B7F6-52598369D214}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Betonsickerrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{285CA767-1746-4024-B7F6-52598369D214}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonsickerrohre -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18F73C89-3BA4-43B6-8E9A-696EB61AF947}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- Betonsickerrohre B-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{18F73C89-3BA4-43B6-8E9A-696EB61AF947}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonsickerrohre B-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B105E0A9-96A5-41BF-A5D9-D2E24A1C1897}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:10'); -- PE-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B105E0A9-96A5-41BF-A5D9-D2E24A1C1897}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PE-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F6BBF66-4EF9-4547-9DD9-540F025C11F0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polyethylen-Sickerrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4F6BBF66-4EF9-4547-9DD9-540F025C11F0}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylen-Sickerrohr -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4737459-ECB1-4422-8AC1-A086699192BA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polyethylen-Sickerrohr PE-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4737459-ECB1-4422-8AC1-A086699192BA}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylen-Sickerrohr PE-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4A4B8C6-68C1-4811-BAF8-B463857FC219}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polyethylen-Sickerrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B4A4B8C6-68C1-4811-BAF8-B463857FC219}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylen-Sickerrohre -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{243EFA37-DDBA-457C-BDE5-613D224157E7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polyethylen-Sickerrohre PE-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{243EFA37-DDBA-457C-BDE5-613D224157E7}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polyethylen-Sickerrohre PE-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68EE78E0-950B-4866-9D05-91180C12EA58}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polypropylen-Sickerrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68EE78E0-950B-4866-9D05-91180C12EA58}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylen-Sickerrohr -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9E8C6D0-6E3C-4AE9-BEBE-A65BF3A8D0D5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polypropylen-Sickerrohr PP-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E9E8C6D0-6E3C-4AE9-BEBE-A65BF3A8D0D5}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylen-Sickerrohr PP-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC222062-4D81-4A9D-9C35-DDDFB78E7C24}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polypropylen-Sickerrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC222062-4D81-4A9D-9C35-DDDFB78E7C24}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylen-Sickerrohre -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE46D8B2-7476-4AB2-A8F1-3876376FFFF4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Polypropylen-Sickerrohre PP-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{EE46D8B2-7476-4AB2-A8F1-3876376FFFF4}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polypropylen-Sickerrohre PP-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4CC88CB-D630-417C-8E9F-E6C3C1FBDFE2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- PP-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4CC88CB-D630-417C-8E9F-E6C3C1FBDFE2}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PP-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{597F1C73-478A-4E99-9022-7BA692C9E905}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- PVC-Sickerleitung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{597F1C73-478A-4E99-9022-7BA692C9E905}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-Sickerleitung -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D767FC27-356D-4A19-8404-1ADAB9709D9E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- PVC-Sickerrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D767FC27-356D-4A19-8404-1ADAB9709D9E}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-Sickerrohr -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94C9AB27-ACF4-4DE4-B1EF-5C0317CD1AF1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- PVC-Sickerrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94C9AB27-ACF4-4DE4-B1EF-5C0317CD1AF1}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-Sickerrohre -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DDCF6B1-9A08-417F-BBFC-89A870C67CA4}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- PVC-U-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4DDCF6B1-9A08-417F-BBFC-89A870C67CA4}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- PVC-U-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{765177E7-ABEF-4611-ADD9-74B492BA352B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Sickerrohr PVC-U-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{765177E7-ABEF-4611-ADD9-74B492BA352B}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerrohr PVC-U-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D955EF-D20F-4909-AEF3-5A6A882E62A8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:11'); -- Sickerrohre PVC-U-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{46D955EF-D20F-4909-AEF3-5A6A882E62A8}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerrohre PVC-U-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EC3EEA-024D-49A2-8BB4-3D942D851C98}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Steinzeugsickerrohr -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{06EC3EEA-024D-49A2-8BB4-3D942D851C98}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugsickerrohr -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CA580BF-BC51-45EC-9475-2BA01CB6136D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Steinzeugsickerrohr STZ-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CA580BF-BC51-45EC-9475-2BA01CB6136D}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugsickerrohr STZ-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FAA8B35-3581-407F-815A-A82A69278C22}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Steinzeugsickerrohre -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0FAA8B35-3581-407F-815A-A82A69278C22}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugsickerrohre -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7157F17D-3273-4BF3-ACBB-0D987E7073BA}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Steinzeugsickerrohre STZ-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7157F17D-3273-4BF3-ACBB-0D987E7073BA}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinzeugsickerrohre STZ-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AFAA54-1609-422D-9186-C69FF32E2106}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- STZ-S -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41AFAA54-1609-422D-9186-C69FF32E2106}', 'HY-{36528D33-2AD9-4626-977D-1901485354AD}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- STZ-S -> Sickerleitung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71EC64B5-D0A7-4905-832C-225045D93C08}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Filtermatte -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE905362-6500-42F2-8EAB-1D2B3BC08772}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Filtermatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DE905362-6500-42F2-8EAB-1D2B3BC08772}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Filtermatten -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FE92E47-E3CC-4F73-BD2D-11F7E1BF553D}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Filterplatte -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7012C65D-D9B5-437B-B7C0-560C519933F2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Filterplatten -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7012C65D-D9B5-437B-B7C0-560C519933F2}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Filterplatten -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A11BBB5B-4A73-4E2A-A6FB-CFC047C7EE1E}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schutzmatte -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DCB6DAF8-807D-4868-923F-347B50645B74}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerplatte -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{041134DD-3107-41C5-B4E4-535F72673B40}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- Sickerplatte / 760 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{041134DD-3107-41C5-B4E4-535F72673B40}', 'HY-{958B3766-B4A4-4D8E-BD1D-8A3E5962EBEF}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Sickerplatte / 760 -> Sickerplatten
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C0792A7-A0E6-456C-AFB5-650E5BB30F29}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- C-Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4C0792A7-A0E6-456C-AFB5-650E5BB30F29}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- C-Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CF3791C-9E5D-4119-B4B3-15A77D29277D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:12'); -- CH_Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{8CF3791C-9E5D-4119-B4B3-15A77D29277D}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- CH_Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{9215EB28-7A78-434D-B4BE-928963FB8044}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Chrom -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{71E0B550-D0AE-4A3F-A573-C4EDCAE57D97}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Edelstahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AC525EED-EE76-43C4-9563-89011E25CA98}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Eisen -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{099AB91A-252F-4BC4-96A9-550999FD61EC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Geländer - Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{099AB91A-252F-4BC4-96A9-550999FD61EC}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Geländer - Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECE86A28-09EC-41D3-8397-60A9F503C64E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Metall - Chrom -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{ECE86A28-09EC-41D3-8397-60A9F503C64E}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Chrom -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27B21E5D-D8AA-4803-A6F9-83DD0EB67073}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Metall - Edelstahl, poliert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{27B21E5D-D8AA-4803-A6F9-83DD0EB67073}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Edelstahl, poliert -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C13989D-6FF3-4D24-884A-1DC9B4CD3C9F}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Metall - Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6C13989D-6FF3-4D24-884A-1DC9B4CD3C9F}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall - Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2DAA01C-D4A7-49A4-BA03-DEA83FF2BC77}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Metall, Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2DAA01C-D4A7-49A4-BA03-DEA83FF2BC77}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall, Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{348DD50B-0295-4EE0-AFED-E3E6B04BE5C8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Metall, Stahl / 900 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{348DD50B-0295-4EE0-AFED-E3E6B04BE5C8}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metall, Stahl / 900 -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A1D168C-FA7D-4779-8703-B9EE0D9EFB76}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Tragwerk - Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6A1D168C-FA7D-4779-8703-B9EE0D9EFB76}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragwerk - Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{823711A9-9029-4389-9BA9-475635C493D2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Tragwerk - Stahl 1 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{823711A9-9029-4389-9BA9-475635C493D2}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tragwerk - Stahl 1 -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAA7F3BD-1FC6-49C9-BA2B-5FA571731B77}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Treppe - Stahl -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FAA7F3BD-1FC6-49C9-BA2B-5FA571731B77}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Treppe - Stahl -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F1C5DE3-FC2B-48BC-9492-9025C2D20CD0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:13'); -- Tür - Stahlzarge -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5F1C5DE3-FC2B-48BC-9492-9025C2D20CD0}', 'HY-{6134DF10-97C7-4A1D-9A76-9A30C4BB850E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tür - Stahlzarge -> Stahl
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1A4BADB7-5EC0-4C72-9D3D-3F9531E0B65C}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonständerwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4D3FA9E5-BDF9-447E-86A5-89B9607D8C3E}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gipskartonwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E36AF328-BF56-4B7E-A511-6A4071E600AB}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbau_Ständer -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{94CF67A6-7600-4CE4-99AC-1BEE8E673199}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbau-Scheibe -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{E4EF9232-04EC-42F3-8F11-F48EE7B864E6}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbauscheibenwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F98501D0-38F6-4341-99DE-AF798F2CF1D9}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leichtbauständerwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37497C36-0319-4960-BF01-D10271D579C7}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- M.Stw.GKB -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{37497C36-0319-4960-BF01-D10271D579C7}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- M.Stw.GKB -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CF6DC62-16EC-49E2-8D71-EAD4291627C9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- M.Stw.GKF -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7CF6DC62-16EC-49E2-8D71-EAD4291627C9}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- M.Stw.GKF -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D60CC148-6A78-4C25-9773-BC0937F1B36B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- Met.2-f.Stw.Gp. -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D60CC148-6A78-4C25-9773-BC0937F1B36B}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Met.2-f.Stw.Gp. -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{449FD875-004A-4E0F-9D62-3D860E2A5B17}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- Met.Stw.Gp -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{449FD875-004A-4E0F-9D62-3D860E2A5B17}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Met.Stw.Gp -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F6EB081D-E1E9-4F24-8EDB-920B10332EBA}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Metallständerwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F312D21C-5B13-4202-97FB-1935E0BE8E49}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Systemwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44D28D2-AA01-4931-8C5C-05169F2D1FC2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- Vollgipsständerwand -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D44D28D2-AA01-4931-8C5C-05169F2D1FC2}', 'HY-{0969BD4D-C74A-4EFD-A4FE-473D67F45256}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollgipsständerwand -> Ständerwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{49C32C8E-7DB8-40A1-B4E7-552CEE15D4A5}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartsteinholz -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BB03256-F97B-41CD-AB55-D1DFA2AED5B1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- Hartsteinholz-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7BB03256-F97B-41CD-AB55-D1DFA2AED5B1}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartsteinholz-Belag -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2DA360DB-59CD-4A50-83E8-61DF8247837B}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Hartsteinholzbelag -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{6989478E-8B86-419B-B086-48F87549B194}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Magnesiabelag -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{14E43E27-EC29-4D30-9551-FA2521C549EB}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinholz -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5ABCE0F-14D4-4267-A826-79253FD07FE5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:14'); -- Steinholz-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A5ABCE0F-14D4-4267-A826-79253FD07FE5}', 'HY-{C75435D5-BD93-4447-8E89-C85ED9884CE2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Steinholz-Belag -> Steinholzbelag
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5650D327-7B90-4BB1-A20C-2028AE6B133A}', 'HY-{8791BDCE-88DF-455F-AE78-C5FA378F133F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Gewebe -> Stoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD73AE81-524C-4712-9E8D-544D8653BD90}', 'HY-{8791BDCE-88DF-455F-AE78-C5FA378F133F}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tuch -> Stoff
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5D9D6119-FB49-4B79-9191-BE2B4E9BAD8F}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Calicot -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B97977C0-A51E-4ADD-98BC-4719DA696A90}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glasfasergewebe -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4221BF01-6ADB-4B46-BDF1-06CE27B13F43}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glasfasertapete -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B731876C-CC8A-4A96-AAAA-401D4CA9C272}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glasvlies -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{7A906D11-5FCE-409B-8647-42EB0E3F12F3}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Jute -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F3BA5AD3-8E9B-4E72-BA51-ED36EF8A5C4E}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Leinen -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{545FF061-953D-47D7-B30F-127F3F97837A}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Papierwandbekleidung -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0276211A-BEFB-4432-86B7-48FD21F64573}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Raufaser -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{3FCB313F-17A2-4B83-B5B8-B8AE7BFAA8E8}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Raufaserpapier -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A41C974F-E5AE-4B00-BFBD-82A63138C731}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vlies -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{87F39495-A764-4996-9555-5416326C0B0D}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vlieswandbekleidung -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CB6495E4-DCE1-49F7-8C3A-1B4A5BE201F6}', 'HY-{94697902-1A16-4F9A-B843-CE6F047B952C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Zellstoffvlies -> Tapete
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4FB7DEB7-4EF9-471D-936B-CFEFDF74BD41}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:15'); -- neu tapeziert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{4FB7DEB7-4EF9-471D-936B-CFEFDF74BD41}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- neu tapeziert -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{336CDFC4-031F-4491-BC9A-3A8BF135D3B9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:15'); -- Tapete Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{336CDFC4-031F-4491-BC9A-3A8BF135D3B9}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete Renovation -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{812852A6-72BA-4DD5-B5C7-C4928213428E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:15'); -- Tapete renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{812852A6-72BA-4DD5-B5C7-C4928213428E}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete renoviert -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7E7CF1A-617C-4DA2-A637-837F0A09CBB1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:15'); -- Tapete-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F7E7CF1A-617C-4DA2-A637-837F0A09CBB1}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete-Renovation -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41222F42-894B-4F67-99BD-C1004F30C43C}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Tapete-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{41222F42-894B-4F67-99BD-C1004F30C43C}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Tapete-Sanierung -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1284DE67-843E-470D-A3C5-52046CE13C5A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Taptete neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1284DE67-843E-470D-A3C5-52046CE13C5A}', 'HY-{753EE752-0A9F-4BA0-AABC-67554C0F4D02}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Taptete neu -> Tapete Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36C7D5C7-00C1-4B20-9DE7-33D2902E584D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Estrich+Teppich -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{36C7D5C7-00C1-4B20-9DE7-33D2902E584D}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Estrich+Teppich -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{AD04DD60-BD21-489D-A1FE-8F8AE47E2F51}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Nadelvlies -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F9A51E69-CE02-4F28-963F-DD2496BF969F}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Polvlies -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{906E136A-4EA3-4414-B847-951F9475FD9A}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schlingenpolteppich -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{D74C95DD-B621-42CD-931A-D880CB17E263}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Schnittpolteppich -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{08D38778-D085-4EF5-B588-129B46BE724B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich / 140 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{08D38778-D085-4EF5-B588-129B46BE724B}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich / 140 -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{201F732E-02CF-44FC-987F-3B90661531EA}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Textilbelag -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84C10AE5-4B56-4345-8B04-CD6D18A9A4F2}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Textiler Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{84C10AE5-4B56-4345-8B04-CD6D18A9A4F2}', 'HY-{8526A42C-5558-44E2-B1D7-04A63603BDB2}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Textiler Belag -> Teppich
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9792D27-DE13-4539-86D8-4B1AB1F60A01}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich neu -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A9792D27-DE13-4539-86D8-4B1AB1F60A01}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich neu -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91209099-0AB8-4E6F-ADFF-8A41A988BC45}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich renoviert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{91209099-0AB8-4E6F-ADFF-8A41A988BC45}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich renoviert -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E8E2D3C-40C1-4D05-8F0E-F7321BAC178D}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich saniert -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1E8E2D3C-40C1-4D05-8F0E-F7321BAC178D}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich saniert -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0DDE4686-07EA-4C2A-BFDA-40F5FA7FC353}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich-Renovation -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{0DDE4686-07EA-4C2A-BFDA-40F5FA7FC353}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich-Renovation -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{275C53E7-B03A-4627-BB01-3F190CA36C69}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:16'); -- Teppich-Sanierung -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{275C53E7-B03A-4627-BB01-3F190CA36C69}', 'HY-{5153B59D-C1CF-40DB-9A08-4FF8E6D466A0}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Teppich-Sanierung -> Teppich Sanierung
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55245288-331F-40DA-9101-523D37332BE5}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Decor-Hartbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{55245288-331F-40DA-9101-523D37332BE5}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decor-Hartbeton -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{207217A5-C9CB-42C0-BF40-E7BD5CB4A56A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Decor-Hartbetonbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{207217A5-C9CB-42C0-BF40-E7BD5CB4A56A}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decor-Hartbetonbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1D85444-4A44-4B66-85E0-7CFCAB62C8E3}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Decorbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A1D85444-4A44-4B66-85E0-7CFCAB62C8E3}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decorbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54CD6194-08ED-4F8D-BD6A-DE83D51C5B92}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Dekor-Hartbeton -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{54CD6194-08ED-4F8D-BD6A-DE83D51C5B92}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekor-Hartbeton -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75928713-2870-4310-8E63-4AF65952F6EB}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Dekor-Hartbetonbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{75928713-2870-4310-8E63-4AF65952F6EB}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekor-Hartbetonbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{65FF2BC2-3A47-4778-949C-A89CD7EDDB38}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekorbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{03C7D990-53E7-4A2D-9A38-DFECB7838B01}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekorhartbeton -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{68B1034C-2F06-426A-BBA5-34EB1CC11E5A}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Dekorhartbetonbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2401A546-87EB-417C-A650-BEA99BAE0582}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Terrazzo-Belag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{2401A546-87EB-417C-A650-BEA99BAE0582}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo-Belag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7919A21-BFF1-46DA-B38E-19B6879DC8C8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Terrazzo-Boden -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C7919A21-BFF1-46DA-B38E-19B6879DC8C8}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo-Boden -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6D5BD35-1E9F-4AAD-978D-CB17296B198A}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Terrazzo-Verbund -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A6D5BD35-1E9F-4AAD-978D-CB17296B198A}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo-Verbund -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83622CC5-358F-4CC1-B405-4DFA6B8137D1}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:17'); -- Terrazzo-Verbundbelag -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{83622CC5-358F-4CC1-B405-4DFA6B8137D1}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzo-Verbundbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{FC3A9A8D-4AB8-4542-9BDB-E49C90199BBA}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzobelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{88F2B27A-0856-4714-8E0B-92E7EEA75726}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzoboden -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{25B72455-5E95-43CD-8636-05B56548C96E}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzoverbund -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{64CEED94-8536-490C-8BBC-9011736A34F7}', 'HY-{6E5E8EA1-0686-4591-9927-784F647CFF9E}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Terrazzoverbundbelag -> Terrazzo
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{81173146-E95C-41C4-90FE-B0A8B2DA360F}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Elementwand -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{58C0946A-88BC-47A3-BDEC-352997A64146}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigwand -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80DD810C-53AE-4E4E-AD97-AC5A955F641E}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Fertigwand / 120 -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{80DD810C-53AE-4E4E-AD97-AC5A955F641E}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Fertigwand / 120 -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{636C649D-3677-45B0-9CCC-E651B8D6F107}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glaselement -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C767AE06-964A-4883-A923-E2D2B3AECEFB}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Glaselementwand -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{04FA3D29-7A94-4B08-9364-5AED9614F1C8}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Holztrennwand -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CC38CF0-034F-43D9-86E0-D836D1E32756}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Verglastes Element -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{1CC38CF0-034F-43D9-86E0-D836D1E32756}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verglastes Element -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5DE8B2B-4B56-4B65-8667-17DA8E4BF1D0}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Vollwandelement -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{B5DE8B2B-4B56-4B65-8667-17DA8E4BF1D0}', 'HY-{A05A20AD-04BA-4766-965F-0C1F8C9919E7}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Vollwandelement -> Trennwand
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5023077A-8154-4385-B789-5A0CCCC1B3D9}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Allgemein, Unterkonstruktion -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{5023077A-8154-4385-B789-5A0CCCC1B3D9}', 'HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Unterkonstruktion -> Unterkonstruktion-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F33AE1DA-04E4-413A-B1EF-9C99A5686825}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Allgemein, Unterkonstruktion Aussen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F33AE1DA-04E4-413A-B1EF-9C99A5686825}', 'HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Unterkonstruktion Aussen -> Unterkonstruktion-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79F62756-F1F8-4500-B086-7FF28A824AF8}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Unterkonstruktion-Verschiedene -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{79F62756-F1F8-4500-B086-7FF28A824AF8}', 'HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Unterkonstruktion-Verschiedene -> Unterkonstruktion-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{154DC50D-7255-484F-916A-4D7C596145E9}', 'HY-{C162CBD5-6A9F-42AF-960F-3B2542EDDC2B}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verschiedene Aussenkonstruktionen -> Unterkonstruktion-Verschiedene-Aussen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{004DC850-8457-43ED-956B-A4A82F7ECAE6}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Allgemein, Unterkonstruktion Innen -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{004DC850-8457-43ED-956B-A4A82F7ECAE6}', 'HY-{D692DFB2-FEEA-4387-8305-7983FCEFB44C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Allgemein, Unterkonstruktion Innen -> Unterkonstruktion-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{C90A63AA-7180-40A9-B83D-BCD72B07C2E6}', 'HY-{D692DFB2-FEEA-4387-8305-7983FCEFB44C}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Verschiedene Innenkonstruktionen -> Unterkonstruktion-Verschiedene-Innen
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7576E11-4A1F-4430-9BB4-7D61CB17161B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:18'); -- Backstein-Fertigdecke -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{A7576E11-4A1F-4430-9BB4-7D61CB17161B}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backstein-Fertigdecke -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{891BAAF1-FE3C-4C48-9D5A-E445301AB46B}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Backsteinfertigdecke -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{DD5AC7A7-168C-4409-98DB-C80D17486222}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Betonverbund -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2ADB590-494E-4678-BE23-A4DAFCCB9DDC}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:19'); -- Decken-Backstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{F2ADB590-494E-4678-BE23-A4DAFCCB9DDC}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decken-Backstein -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44E09DC3-AC12-4B2C-B514-B0A2D645593B}', 'HY-{AE000000-0000-0000-0000-000000000000}', 'de_de', 'global', '255', 'material', '2025-01-15 13:59:19'); -- Decken-Ziegelstein -> ~Archiv
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{44E09DC3-AC12-4B2C-B514-B0A2D645593B}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de', 'global', '255', 'material', '2025-01-15 13:57:07'); -- Decken-Ziegelstein -> Verbunddecke
INSERT INTO ecad_guid_info_hierarchy_assoc (guid, assoc_guid, region, username, mode, add_info, modify_datetime) VALUES ('DM-{CECCB58C-85EF-4738-957C-CFD9406189B1}', 'HY-{B5F0200B-BB76-475D-8019-3708A378C87A}', 'de_de