USE ecad_guid_info;

-- guid info for: object layer attr name
DROP TABLE IF EXISTS ecad_guid_info_layer;
CREATE TABLE ecad_guid_info_layer (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
    username varchar(255) DEFAULT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,	-- e.g. for any logical grouping
    modify_datetime datetime DEFAULT NULL,
    de VARCHAR(160) DEFAULT NULL,
    cz VARCHAR(160) DEFAULT NULL,
    en VARCHAR(160) DEFAULT NULL,
    es VARCHAR(160) DEFAULT NULL,
    fr VARCHAR(160) DEFAULT NULL,
    gr VARCHAR(160) DEFAULT NULL,
    it VARCHAR(160) DEFAULT NULL,
    ne VARCHAR(160) DEFAULT NULL,
    pl VARCHAR(160) DEFAULT NULL,
    ru VARCHAR(160) DEFAULT NULL,
    sl VARCHAR(160) DEFAULT NULL,
    user_default_lang VARCHAR(8) DEFAULT NULL,	-- e.g. 'de_at', language and region, use within alias and/or language columns
    aliases VARCHAR(2047) DEFAULT NULL,	        -- e.g. 'de_de=Alias1;;de_ch=Alias2;;fr_ch=Alias3', optional dynamic alias list for any region differences
    PRIMARY KEY (guid)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{43198C77-E456-457D-8485-741D066C19A4}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Wand');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{F48C206C-58A9-4146-B4DF-E778DC344CE9}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Stütze');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{1D48B874-7232-4945-B3EC-1BCA7FEEC5A4}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Träger');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{AC13355B-4DD2-4B03-B17F-4A5BF22BE31A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Decke');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{660F76DB-EBF5-4E39-98FA-F51F10702ABD}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Dach');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{4BA8E41B-9A48-4765-AD18-3F9DE323EDDF}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Dachstuhl');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{6CCC07AD-335C-4AEE-B00B-4E29D08C66E3}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Stahlbau');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{68850C7E-17F9-4601-B6AE-BB935A8A504A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Kamin');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{C6D4A879-4D8C-4B8A-BF51-8D78A3CE8CD5}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Treppe');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{86ED93ED-0026-4A2B-9466-DDF917F20D45}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Fenster');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{FEAEF45D-87EF-49A2-82D2-5627C5354187}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Tür');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{DEF7D225-92D3-435E-A40C-5A8795B19DDA}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Raum');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{F4C36A15-BF33-4422-A43C-686BDA8D5A7C}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Beschriftung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{7B269F59-20AD-4D26-B236-FB499889F680}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Vermassung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{0E16ECF3-D35E-4262-A174-AFC8BB44B5B6}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Mobiliar');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{C1FCAB43-CB26-48A1-9BFA-B1CD0D84949E}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Einbauten');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{F4031F68-CD28-4024-ABD3-1029643E3E6F}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Küche');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{12C77C06-9A4F-40DA-AD0E-C19C0F5762FF}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Bauteil');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{F6308CF5-B8F6-4069-A77E-E0FE53B85B86}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Plangrafik');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{708BA5DC-B5D3-4F68-BC84-41057EE65D1A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Detail');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{1CD9F1AB-1159-4B96-B1BB-55C9A106B98A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Symbol');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{7BB10887-26EA-4E82-B14A-DA57E5886242}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Umgebung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{1B699DA8-3021-4BF0-BF05-25586DAAF0D5}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Gelände');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{D2F7F725-069C-465B-BDA8-DCB130C85EEA}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Elektro');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{269BC8D7-FCA7-443D-9025-D8B902989645}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Sanitär');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{EFEB9787-4BAC-4127-99A2-0A45DFBFF932}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Heizung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{FE2F2EC5-76C1-4722-B6C0-8B72879375F6}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Lüftung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{EB9C770F-A6E0-4490-9186-DC7668ABB503}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Klima');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{12BF8207-FA89-47C9-B292-6D7F50B0D62C}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Kanalisation');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{513B983F-F798-4E5B-A95C-AB98640EC3A3}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Schmutzwasser');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{76F255A8-28E4-4EB9-ACFE-3AEA0C217050}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Regenwasser');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{4E8F44E8-BEC2-4B95-9352-A08CA55CF04F}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Mischwasser');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{70B55CC7-85F8-4955-BA2F-7B877A545BA5}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Sickerleitung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{89661D66-DF45-4A1C-B350-09DEDD11FAB6}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Wand Trockenbau');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{84B26863-04AA-437B-95E4-D35A644B7F0C}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Aufzug');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{20389C8B-2E58-4D82-82F8-FD0D1AEF4B34}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Fundament');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{F0BEA28C-627A-4A79-AB10-1C7F908AB65A}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Decke Abhang');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{1CE72B80-83E4-42EB-BC09-5662BB2C2CF0}', 'global', '255', 'layer', '2024-04-22 08:00:00', '3D Personen');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{9B5D7864-7ED4-4144-8BE1-AE7699A6F842}', 'global', '255', 'layer', '2024-04-22 08:00:00', '3D Einbauten');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{D6ACB3FB-500C-4A9F-9D16-7650DFEB9C3F}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Dekoration');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{4EB78200-BBCD-4BE8-BB41-CF0296C65AE1}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Lageplan');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{9301FED8-A627-41CC-BE3B-21DF6387C85D}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Grundstück');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{E4DC3933-0B57-425E-BD4B-CF70E53DE90D}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Bebauungsgrenze');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{1E338982-08DD-48AF-8CFE-59932E63AB0D}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Fahrzeuge');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{B869F2AC-E1D8-430B-9220-D21F417E75C8}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Bemaßung Lageplan');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{9CA6E84D-34B5-4363-92AD-0DC9276F4D75}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Beschriftung Lageplan');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{DB824FD8-F6BD-432B-B16D-D0F87ED0DDEF}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Nachbarbebauung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{A9BBF2BD-A2B3-48B1-92CF-9FB7E3D3277C}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Grundstücksgrenzen');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{115E9E8C-B0BB-4AF3-A6B2-8C1C314075AD}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Elektro-Einbauten');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{E6C17451-EA76-4552-AF5E-0C668F76DAEE}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Entwässerung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{60578AA5-AD91-4ECE-BB87-778E65645B72}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Redlining');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{43684C77-0061-45D3-BC68-CD5AA20F1FE8}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Grafik');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{699591A1-9053-4366-A373-0864B6FE10E3}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'PDF');
-- values
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{DD312B87-0BA3-44E6-96F6-BC365727D277}', 'global', '255', 'layer', '2024-04-22 08:00:00', 'Außenkontur');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{FCBA1AEE-FC14-4D84-B036-76AC15DC3D05}', 'global', '255', 'layer', '2024-11-20 11:33:16', 'Terrain');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{1EE71A67-2FCE-47EB-9199-420CD72775B4}', 'global', '255', 'layer', '2024-11-20 11:33:16', 'Wall');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{867265BB-030D-4F6D-9BCB-135134F98996}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Column');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{BEAA6F41-830C-49CF-9EC5-3E7E190AF65D}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Girder');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{01A8AAE5-3540-46C6-911B-54F9B876802A}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Slab');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{E80878AD-3DE9-410E-AF6D-816F1320147E}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Roof');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{FD641895-DE72-4DD4-AB8D-0C700AF91185}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Wood construct');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{FF5D6674-84AE-4CB1-9781-A729DA03B5A6}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Steel construct');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{AC7C112F-A9EE-4596-AB75-80712F0B9785}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Chimney');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{8DBD3C4C-FF93-44E3-8E5F-2FFB1F816327}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Stair');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{55243216-9B59-42A1-B60C-83E5847D7782}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Window');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{CD2E1723-5CC5-49CF-9859-1BC703518606}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Int. glass elements');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{4CB1C71E-30A6-4B42-995B-99EBF5AFB8B6}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Door');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{835F774B-E446-457F-B4ED-FB9E523BAE90}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Room');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{C45D2ED5-75B3-48F1-8E6A-BB9C905A3577}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Naming');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{04907890-954F-4006-A30F-B984B019BE69}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Dimensioning');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{35FEEF03-EAF3-406C-ACE0-8550384A5EE5}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Furniture');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{BDB0B590-FC30-4FCA-A480-79509D815E61}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Equipment');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{B6393B3E-E547-419E-83D4-CBFEEE78BB67}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Kitchen');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{93CE553F-EE9A-4C06-85EA-CD244E5279D1}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Struct.parts');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{F06B01AE-B5E6-4A44-A47D-11B6938406F4}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Constr_part');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{9C7A53A6-5FB7-4ACE-9F3F-F2DE926E029E}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Plan graphic');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{65CE0E06-C13B-4A2B-91CA-9F1EC1A808A8}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Symbol');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{8B9857E2-E038-46CD-951C-479B605215B6}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Detail');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{6681FA3E-EE46-4123-8AB2-3F7DB0B96518}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Surroundings');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{955527B6-28C8-4E30-A876-076913397702}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Electric inst');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{253213EA-3ECF-4F66-B113-019DB154B065}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Sanitary');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{7ECD89D4-F883-4C3E-9ED5-9712D33ADDAF}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Heating');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{C613905C-5233-493C-AC15-FBE802031DCD}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Ventilation');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{7262EB20-71E0-4066-B2A6-C421446869F5}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Climate control');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{3ADD4649-9937-4D59-9CAD-4B6085960B2E}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Other installations');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{CB48CBF3-1AEF-4B73-9F73-65AADA3455B0}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Drainage');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{3106BA2A-D5BD-4048-854D-FCD86FEE45A1}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Waste water');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{7F2D2041-CF67-4BD7-9836-D1E8EED22218}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Surface water');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{63C7E140-6300-4471-ACF7-33FC937D4C14}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Comb. waste water');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{85EF18E2-2C91-4C77-A5A3-F33181BEE638}', 'global', '255', 'layer', '2024-11-20 11:33:17', 'Drain pipe');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{97331A7E-E2F7-4134-8D12-BCB6209045EB}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Murs');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{6D368216-CECF-4F83-AA45-FA406CD17A1C}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Piliers');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{8B2AD10F-0B24-42FE-80F4-EDBCECC0E459}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Sommiers');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{E0C64C7F-B543-4C07-85D7-394130E854DF}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Dalles');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{C81C9BF3-E779-4E28-8D6A-E17D1EF58F8A}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Toiture');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{AA188EC6-789D-4E81-B60A-9B2428792E12}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Construction bois');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{18B68905-BA42-4343-B476-BF83501BFD1C}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Construction métallique');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{7DDA33B5-9560-4A4C-82E2-1225CB5062A2}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Cheminées');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{18093161-A331-487C-BEAD-B53202392319}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Escaliers');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{1745C18A-DED1-480A-94F8-3AD8347B2258}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Fenêtres');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{CA0EBB4E-10B0-414D-B508-791298AF94B5}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Portes');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{1CF0839D-2F76-45CE-8B56-5D9FD981D45C}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Locaux');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{F5E73C37-B455-4912-A3E5-092066931AD2}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Textes');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{C7C2695D-8374-4DAE-B983-E6C4202ACC9C}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Cotes');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{BEB7D7C5-E8F3-4EA9-A97D-C416FCF1E00F}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Mobilier');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{D28D4CC6-FCAE-4ED8-8060-BE4B6783C0E9}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Aménagements int');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{4BF74204-C194-4DC9-8599-C022F5EDFA31}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Cuisines');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{F6BBFC0F-BC77-48F9-B151-0DF9C4E4C4F9}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Eléments de construction');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{1FC54F33-D423-49AB-AE60-F651DFFA29D9}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Plans graphiques');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{4546B9CF-6F4D-40BC-B03E-3EBA9DDE58D6}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Symboles');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{4E01A438-09A1-49BA-8B05-B4FA3F074E3E}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Détails');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{61DEA2E8-D076-4BC0-8FC4-5B98393D64E5}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Arrière-plan');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{DA0D52BC-DDE0-4CDF-BB22-F8E77F06086D}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Electricité');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{E316388A-7455-48E2-B1EA-029892F7F886}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Sanitaire');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{36BE7DCB-4419-4357-BEC6-72EA63334129}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Chauffage');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{42556DC0-8DF9-43E5-8904-F526106134FB}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Ventilation');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{21694216-51CF-493B-91AA-A686C7C8F33C}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Climatisation');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{5BB37F14-C74F-45B2-BD76-B2B09246FFFE}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Terrain');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{8AA86B6B-2934-40E0-BF61-BC6C9226F55A}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Environnement');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{027432DF-D527-43CB-9A13-ABA97ACEDC1E}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Aménagements ext');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{4A3BE985-2BFB-477E-8906-53063A6E6418}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Canalisations');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{50FDD51F-541A-4E2D-A373-F78F8A3C97E2}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Drainage');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{FD8A64C3-0A5F-4064-BE37-9D2575C7E306}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Pluie');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{CE55CFF2-33C7-4BD4-9E25-129B66AB52CE}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Polluée');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, fr) VALUES ('LY-{255822DE-00AA-4B7F-AA91-FA934746C0B6}', 'global', '255', 'layer', '2024-11-20 15:37:41', 'Usée');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{460E92C9-1BBC-4C58-A650-BC86DF51E574}', 'global', '255', 'layer', '2025-02-11 11:44:40', 'Default Layer');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{66AB2222-BD2E-4D60-97DE-F5756D65B9E8}', 'global', '255', 'layer', '2025-02-11 11:56:28', 'Default Layer');
-- values pl
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{25EF9108-E44A-4C94-919D-6B7E7DEEFB25}', 'global', '255', 'layer', '2025-03-11 08:26:58', 'Teren');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{780844F3-FEC9-4C2F-A333-43BA6F01CBEC}', 'global', '255', 'layer', '2025-03-11 08:26:58', 'Ściana');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{EE46667F-76DB-47F8-A52D-DC8F4C48F82E}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Kolumna');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{C65D3D29-AADE-43AE-A4C0-BAA6311E2214}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Dźwigar');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{F12C8863-8DA2-401B-BA2C-760B0260D090}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Płyta');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{0A2FBE45-6F18-4CC9-A72A-2827946AFB5A}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Dach');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{4163EAD4-1FF7-443E-92FB-30B587EEBFD6}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Mur');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{04EFF374-7596-4974-A27A-9120BA5184C2}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Konstrukcja drewniana');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{76FD4D82-1F3E-4792-8123-5F302821D709}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Konstrukcja stalowa');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{72B68749-9F6E-4180-940E-629744CF50AE}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Komin');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{49436E25-0234-49DF-B724-9585965B8B58}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Schody');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{42096DA5-0AD7-4A87-9C4E-FD92451F3E02}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Okno');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{CFE7C040-C5CB-4569-AFCD-4F7B7778D0C8}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Elementy szklane');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{53619D05-F265-4C43-BBC4-92D1FB3883C7}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Drzwi');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{5E381B38-3EE5-4D36-BDE1-E2D6F21E882B}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Pomieszczenie');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{EC1D6E5C-A9EC-4AD9-B725-D5A402AA74A3}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Pokój');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{2C8639D6-81F4-4437-8C94-DB519970DCC8}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Nazwy');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{59B1738E-D9D8-47E6-9554-E94F714E1EDE}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Linie wymiarowe');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{449390F0-530C-4E74-872E-E1FBDE75D81E}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Meble');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{66C8BA10-CAED-4F44-BB98-C7498D32974F}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Wyposażenie');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{8DAB5143-48B7-45DD-A3CD-C7006AE10F98}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Kuchnia');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{84668C91-41A9-4663-A9F3-99C20A673007}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Elementy kondygnacji');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{7FCBC962-505F-4D2E-A931-A298B10F6F47}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Elementy konstrukcyjne');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{BC527345-E2B6-40B6-A6A2-1CB86D00FF8D}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Plan graficzny');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{84B84AA1-592C-43A0-B2F3-795E1DBAA04D}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Symbole');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{D614E4B7-059C-424C-A0B2-F05F29C38D1E}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Detale');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{5B7AE0D5-1D80-417D-A22C-5FCD2D52084C}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Otoczenie');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{E4830335-8EA5-48FF-BE5F-20BEF5276620}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Instalacja elektryczna');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{6676A959-1467-4525-85CE-2C39A39122F1}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Wod-kan');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{9E4928F2-D562-4316-A39E-5FFEB86B2E96}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Ogrzewanie');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{A10787BB-003B-473A-AC93-932F680B9539}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Wentylacja');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{A5934F18-30A2-4670-8AAC-8AFA52ABB4A5}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Klimatyzacja');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, pl) VALUES ('LY-{DB48AB4F-81EB-4ED9-B19C-CFAB570F71C0}', 'global', '255', 'layer', '2025-03-11 08:26:59', 'Inne instalacje');
-- values gr
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{501F8838-194A-46C6-A780-0A526065DDE3}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Έδαφος');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{EB02144C-C886-4835-A482-90DAAB24AE21}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Τοίχος');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{0820473B-3373-49B3-A481-9F4FEBD421CE}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Υποστύλωμα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{91B541D6-249E-4F60-8EFE-0656055520ED}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Δοκός');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{F8BF4178-7028-4E27-A3EC-E33E2EBB36AB}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Πλάκα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{1FEA6A8A-E19B-4A93-83BB-03EEC08447EB}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Στέγη');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{1971F3E5-27DF-446F-A5B8-AC2A8D00F8F0}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Ξύλ. κατασκευή');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{8085F0FA-A89C-41A8-879F-5D1D89565B38}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Μεταλ.κατασκευή');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{C44C19CE-8716-4022-9A84-00151DE02041}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Καμινάδα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{9D696409-A9B6-42A4-B361-E1588815F888}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Σκάλα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{C249F089-75C2-44DF-9AE5-23865E38B68A}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Παράθυρο');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{1B6CD62A-9A6B-4D16-A77E-0425DCFC0FD9}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Εσωτ.γυαλ.στοιχείο');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{CF54EA34-EBCE-4ADA-B1B8-44653E99C559}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Πόρτα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{9F3FEA62-99F0-4A71-BCD1-C4BC1CE77BFF}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Χώρος');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{E6E06F5A-DCCE-4A47-A6A4-1277B30BB498}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Ονομασία');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{D53B54D8-8EE0-42E1-81AA-96F669E6704A}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Διάσταση');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{DD722A98-73CB-48D6-8D27-AFED96EFEF09}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Έπιπλο');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{7B86D24C-9334-452D-B20E-373ACC808274}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Εξοπλισμός');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{FF143089-300D-4F96-B168-B9C993B2ED38}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Κουζίνα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{966F44B0-0796-4B9A-8D85-493D242021F8}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Κατασκευαστικά μέρη');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{95204E7C-6605-4469-A427-1307E21153C0}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Κάτοψη');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{B54E4B8A-23CA-4D1A-9A64-C10F6826E9B2}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Σύμβολο');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{EB602373-C635-4874-86C5-FF6EC20D50A6}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Λεπτομέρεια');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{8FED53AF-A0AD-45D7-A8F7-E3FCC73D9787}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Περιβάλλον');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{32025DA8-206C-4891-8F9E-696EA2F61A08}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Ηλεκτρικά');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{AAB2BCC1-AF8C-4B9E-AA63-F7E9BCABFA02}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Υδραυλικά');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{ED038D3A-7950-489E-9D66-06E5360F6575}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Θέρμανση');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{C2C8E483-A88D-43E8-800D-D1B4FA7FA0CD}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Κλιματισμός');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{02BC86E9-D2B1-4954-8880-9087F5DD7731}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Άλλες εγκαταστάσεις');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{8935A3AB-389E-4157-A98D-5B14D124AE60}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Σωλήνα αποστράγγισης');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{459EDF4A-7383-4572-BCF7-F4ACA504BE89}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Συνδυασμένα λύματα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{86EEE2A6-5247-4480-8F55-0E04B7525388}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Επιφανειακά νερά');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{268DB69C-6F70-4CA6-9C0A-78752327AA67}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Λύματα');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, gr) VALUES ('LY-{3657F51E-E6FB-4938-8287-F54002256193}', 'global', '255', 'layer', '2025-03-11 13:26:22', 'Αποχέτευση');
-- values sl
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{DFF26B53-A1E4-41E9-817B-D7FFE1131FB2}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Stena');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{EB183A92-D27B-4493-A8FA-5EA674072B07}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Steber');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{FB43C38E-7954-4785-912F-4F2DBC80444B}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Nosilec');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{191495C0-2E4A-44A3-AAB5-79A76B69BF03}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Plošča');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{C07CE317-CCF4-4170-8295-57FE77A59357}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Streha');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{C21CAE47-24D3-4018-BD09-DBDF32C504B2}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Strešna konstrukcija');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{B809F44A-B22D-43D3-AF31-C146D4A644E5}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Jeklena konstrukcija');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{CA4F0037-8C65-4504-BCD6-98A442713A44}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Dimnik');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{A676CE9C-AAED-4E4C-A968-242A9734AD1D}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Stopnice');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{061A14B2-03EF-4CA0-B0CB-E605CCDFB65C}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Okno');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{35986BD4-60FC-4B7F-BC52-6581B739B857}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Vrata');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{2DC88D82-9303-458F-97C8-D94B6769DDEB}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Prostor');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{314EFB06-5A19-4F7C-B15C-2EC5A247AB25}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Opis');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{82C8D97B-3D68-4990-BFD7-C02B4433BCDE}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Kotiranje');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{2CB31885-A758-41E0-BB7A-7F1F9D8EE9A8}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Oprema');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{FADA70B4-CCC7-4FAA-9ED6-AE32E841DF03}', 'global', '255', 'layer', '2025-03-13 10:59:06', 'Obloge');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{5CBE27A5-3A8E-4A77-BFBC-95870898D393}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Kuhinja');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{BBF43D56-550F-479C-869E-4EE72488E378}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Vgradni elementi');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{B613DEF1-8E32-479D-8D66-941B216DEEBC}', 'global', '255', 'layer', '2025-03-13 10:59:07', '2D konstrukcija');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{8A961B08-546C-417E-9880-C1C4655F71F2}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Detajli');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{A49A8775-F46C-471B-B110-EE44B018144D}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Simboli');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{FFB4F404-345E-4D9A-8D8D-7C698ADBFB07}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Okolica');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{BBB30F58-3687-4671-AAA2-24E57FFD3624}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Teren');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{8216DEB6-265C-4318-9BF1-16B8FE765E47}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Elektro');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{1F24F5CE-C535-4F1C-ABA4-585CD56D9308}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Sanitarije');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{57303FAD-0769-424B-9AC7-F0DDEC869A3E}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Ogrevanje');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{C84AEF2E-1A00-4304-A702-0655852BA936}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Prezračevanje');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{A0ED6C06-5BED-402D-A98F-F6BEDF7F77E8}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Hlajenje');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{41C9D97E-133C-464C-B732-D23BA050E0F6}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Kanalizacija');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{94D56C76-82BC-4B90-AC3A-E4A135956DEF}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Fekalne vode');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{62D0A1B6-9D3D-4549-876F-A51868AB1326}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Meteorne vode');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{82EED6CA-0EC0-477D-B1EA-84544A45335B}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Vodovod');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, sl) VALUES ('LY-{30191D25-05AB-4B50-B3EB-42444DA926DD}', 'global', '255', 'layer', '2025-03-13 10:59:07', 'Drenaža');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{169607F7-4AD6-4451-AEF5-418661037D49}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'internal production');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{60F65431-6277-4525-B59E-D22D9BC5D806}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'external production');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{4A295753-4D5A-4A38-BAC1-6BBBF0CD7A6E}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'purchsed items');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{F79239D7-D617-4F03-9E5D-401EE682399F}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'stock items');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{889BADF6-D48B-4DCF-A6E5-663BBFB3D48A}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'standard parts');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{4BCC59B3-41AD-4D90-88FA-88C78EAD9C2F}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'unit 1');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{B52600B3-FFB6-4D42-AA65-3FB779EB9A8E}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'unit 2');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{CEDCB41B-D677-4637-986A-E816E90961D1}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'steel construction');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{20CA3D1D-2789-48E6-AC8A-F4F0F47809A9}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'mounting');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{73DC4D82-7CD8-4764-8C5B-ADBDDC62DD26}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'surroundings');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{2B7CDEB3-B2E0-4C31-962A-89F81674D52C}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'terrain');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{BDD9FEA4-0278-4778-AE16-86D99863F58C}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'sheets');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{2EB64A0A-34EA-4838-9317-24A4FCDF1193}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'profiles');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{BEA8CB0D-B3A7-496E-800F-14612889134F}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'brackets');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{BC5D404B-251A-4EC1-82AD-08FC8CCBE31D}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'pipes');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{69EFD672-4912-43CC-BB5C-FF53F4DA1D0C}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'support');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{71ECCC3D-6EAE-40CD-B3CA-6DABA6F4F9DC}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'girder');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{835EE110-C9D1-4AC6-A7ED-037E68843477}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'stair');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{2C645101-864F-433C-BED6-AE4127C4ABB8}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'banisters');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{92B058FB-8051-4C33-8D3A-B33A71AD5924}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'pedestal');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{20DD9231-3862-4E9B-84C8-3889DC1524C0}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'labelling');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{EB1CC4F4-4A12-4525-9090-D0229ED3E12D}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'symbol');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, en) VALUES ('LY-{83EA4B07-BBE5-4372-BB9D-81B93B34DDB9}', 'global', '255', 'layer', '2025-10-10 05:15:38', 'dimensioning');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{9353FCF0-20C9-480F-9AB3-7146C7599710}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'eigene Fertigung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{7D651433-6F68-411F-8C1E-9CCB4ADE2851}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'externe Fertigung');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{0C849461-8617-4A81-97DA-1AEB8C9B4D19}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Zukaufteile');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{C29F5789-1377-4059-930A-8A79907B13A0}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Lagerteile');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{4F1C9A1E-6186-411B-B927-A8882F3BA894}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Normteile');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{0CFBB95F-FEAC-4C0A-9C32-B2E7354D451C}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Anlage 1');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{45404EFF-53EB-47D0-812E-CFCD12FD3A3F}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Anlage 2');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{313876D2-F544-4300-882C-A2AE41FA2872}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Montage');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{69C5A35C-F1FA-4D0F-B39B-20AC3D1F4904}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Platten');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{83F77BBE-79A9-467B-9837-8B9B09D8161B}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Profile');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{8D45FA09-98E4-4719-9F3F-F96166E15352}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Winkel');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{6DBB36E7-2E6D-44E7-8098-466A6648DA3C}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Rohre');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{8BDC6C38-3E50-4AA9-83DD-2F9078A59171}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Geländer');
INSERT INTO ecad_guid_info_layer (guid, username, mode, add_info, modify_datetime, de) VALUES ('LY-{7FC04220-C2C2-4A9C-880E-3FFE9B2029D3}', 'global', '255', 'layer', '2025-10-20 14:20:34', 'Podeste');
