USE ecad_guid_info;

-- guid info for: assoc table for mapping guid <-> hierarchy (n:n)
DROP TABLE IF EXISTS ecad_guid_info_layer_assoc;
CREATE TABLE ecad_guid_info_layer_assoc (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,         -- guid (LY-GUIDs)
    assoc_guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,   -- assoc guid (LY-GUIDs)
    region varchar(255) DEFAULT '' NOT NULL,                                     -- e.g. 'de_at', 'de_de' ...
    username varchar(255) NOT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,                                          -- e.g. for any logical grouping    
    modify_datetime datetime DEFAULT NULL,
    PRIMARY KEY (guid, assoc_guid, region, username)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

