USE ecad_guid_info;

-- guid info for: object (database) type
DROP TABLE IF EXISTS ecad_guid_info_type;
CREATE TABLE ecad_guid_info_type (
    guid VARCHAR(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
    username varchar(255) DEFAULT NULL,
    mode INT DEFAULT NULL,
    add_info VARCHAR(255) DEFAULT NULL,	-- e.g. for any logical grouping
    modify_datetime datetime DEFAULT NULL,
    de VARCHAR(160) DEFAULT NULL,
    cz VARCHAR(160) DEFAULT NULL,
    en VARCHAR(160) DEFAULT NULL,
    es VARCHAR(160) DEFAULT NULL,
    fr VARCHAR(160) DEFAULT NULL,
    gr VARCHAR(160) DEFAULT NULL,
    it VARCHAR(160) DEFAULT NULL,
    ne VARCHAR(160) DEFAULT NULL,
    pl VARCHAR(160) DEFAULT NULL,
    ru VARCHAR(160) DEFAULT NULL,
    sl VARCHAR(160) DEFAULT NULL,
    user_default_lang VARCHAR(8) DEFAULT NULL,	-- e.g. 'de_at', language and region, use within alias and/or language columns
    aliases VARCHAR(2047) DEFAULT NULL,	        -- e.g. 'de_de=Alias1;;de_ch=Alias2;;fr_ch=Alias3', optional dynamic alias list for any region differences
    PRIMARY KEY (guid)
)  ENGINE=INNODB DEFAULT CHARSET=UTF8MB4 COLLATE = UTF8MB4_0900_AI_CI;

-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D26FDD86-C399-42F6-899D-E51D8324B861}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Ziegel-DÜWA');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7CFB1282-E0DF-4525-A7C8-D9426C899106}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Mauerziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B447C3DF-9CC9-47B2-B784-F180C047F19E}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hochlochziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CAD2E0C5-53A3-4C0F-B9FF-5B29D8CD8D52}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Aussenwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ACB60813-446C-4306-9B32-C769D52E2BB0}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Beton-unbewehrt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{67388882-5CDD-41FD-BB59-90DA1888053D}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hochlochziegel+WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FDC3D6F0-04D4-4E31-A232-C880F2EB9E4F}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Leichtbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{00A8732C-B9C9-41F6-AF7F-366594610D44}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Betonstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{791E31D9-F5BE-4278-A3A4-5C4CD4FE8698}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hohlblockstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB9C65C7-5E19-4324-BA0F-542273930D44}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Stahlbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2B6E0A24-0FD0-4356-9653-04FB86916281}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Stahlbeton-B300WU');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{347F5557-30FA-4489-B545-6C69C74D771C}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Betonfertigteil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4DBD7C73-C6CA-4403-A0D4-7C72CADE73AD}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Stahlbeton+WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0CBC2E93-6E9C-48BB-A2A8-56932949F68F}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hochlochziegel+Schalung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B223BC27-7AD3-4695-8ED3-0DD323E12A79}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hochlochziegel+Vormauer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2E428EE0-F173-48F4-9279-81D4D3CB4E80}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Systemwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9DDB2B25-466C-4138-BEC2-D1B72D8478DA}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Innenwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{753FF775-DE12-4182-A651-C9013EA86EDF}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Deckenrandschalung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CC499218-CE7B-4BCD-9A23-D9FF2E5C17C8}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Hochlochziegel+WD+Dämmputz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{31C65251-4056-49D8-83BA-799FAD933CC9}', 'global', '255', 'grider', '2024-04-22 08:00:00', 'Holzträger');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{220C456F-EFF2-4760-AEC8-C008099FAED1}', 'global', '255', 'grider', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7CE0A9E9-38B0-4BE3-A753-FC13CBA60549}', 'global', '255', 'column', '2024-04-22 08:00:00', 'Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C5F0B268-C15E-484E-9B7F-73EE45E8EB0E}', 'global', '255', 'column', '2024-04-22 08:00:00', 'Ortbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{62EE8AA2-075D-496E-B5E0-C644587CF6C0}', 'global', '255', 'column', '2024-04-22 08:00:00', 'Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0B7AB859-3876-4153-8338-DB2F08BCB69B}', 'global', '255', 'column', '2024-04-22 08:00:00', 'Beton');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C0C1C319-F6F8-4441-BBE6-1F2BFECAD48F}', 'global', '255', 'chimney', '2024-04-22 08:00:00', 'Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{317A9C6F-F51A-4CC7-A3F4-24A37071283B}', 'global', '255', 'chimney', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0105EBEF-B255-4F75-8346-9412C68B91DB}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Geschossdecke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{85ECC049-EBFF-4082-B629-B629F054AEFC}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Niveaudecke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FC822AF2-8CC6-4F7F-AA0C-219893E5AE18}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'abgeh. Decke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{71E3750E-3868-4D1E-A914-8B14DC9C7084}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Balkendecke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{43194334-E23B-4193-A2CD-5DE7FA9BF39E}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Fundament');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7BBEA7FE-3C86-4792-BE97-8C01616331C6}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{84EBEF45-679F-4631-AC2F-1BE62CA9A878}', 'global', '255', 'floor', '2024-04-22 08:00:00', 'Gefällsdecke');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{513BED63-DFDC-4E46-89D7-6D2D62C53A9F}', 'global', '255', 'roof', '2024-04-22 08:00:00', 'Spitzboden');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{40457A5F-511F-4277-BAC7-587438C3097D}', 'global', '255', 'roof', '2024-04-22 08:00:00', 'Standard 3-schichtig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5483D5AB-52A9-4312-931F-48C7F1782A59}', 'global', '255', 'roof', '2024-04-22 08:00:00', 'Steild Däm. zwischen Sparren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C5E45385-072D-458E-87D3-1819347E28CD}', 'global', '255', 'roof', '2024-04-22 08:00:00', 'Steild Sparren unter Däm.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2768E21C-2F2C-40E7-8619-0812FD3933E1}', 'global', '255', 'roof', '2024-04-22 08:00:00', 'Höhenbegrenzung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{84B8EA26-425E-4FD3-B4AE-295A3ACAAEC0}', 'global', '255', 'dormer', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D79FB1BB-FB62-484A-90B8-921286A76A83}', 'global', '255', 'roofstruct', '2024-04-22 08:00:00', 'Dachstuhl');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FFFD66EB-D91E-4C62-BDD0-8E3149B0BC33}', 'global', '255', 'roofstruct', '2024-04-22 08:00:00', 'Balken');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{49FEB5CB-A285-4F64-B85B-A1E8460A7E95}', 'global', '255', 'roofwindow', '2024-04-22 08:00:00', 'Velux Schrägdach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3476EB7D-0B26-46B7-8B75-FAEE9A845A57}', 'global', '255', 'roofwindow', '2024-04-22 08:00:00', 'Velux Flachdach');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{365C294D-2980-4B0D-A98D-CE57AF6F1A18}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Standard_Flügel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7451B57B-BE38-42D2-9736-84FB4E2F3929}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Schiebefenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A6AD466C-99D4-423B-8F5F-CF43BCDBFC95}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Standard_Anschlag');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6CA1E10C-4CCB-4C00-A061-DF476E1E688F}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', '1-Flügel+Sturz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E5B91282-800D-4EFF-8C39-4ED78B7249A1}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', '1-Flügel+Griff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2A907DD8-C33A-44C5-9727-F634C7AAF6F2}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', '2-Flügel+Griff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A99E1AAD-97BF-4BDA-B6B0-C7C0F26965EF}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Gewände');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F991B678-A4B9-4A03-9E6F-8C40A8ED5790}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Standard_Türe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{53601B26-2B2C-4C36-ADC9-4B13ED702E74}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'WDVS_Rolladen');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F47B2929-F761-43B1-B45A-D330CC95DB9A}', 'global', '255', 'flooropen', '2024-04-22 08:00:00', 'Bodendurchbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{74EFA897-6A52-48FD-8585-4C5150F81957}', 'global', '255', 'flooropen', '2024-04-22 08:00:00', 'Bodenschlitz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{65EDAF7F-D69D-42D6-B096-3C2038E19517}', 'global', '255', 'flooropen', '2024-04-22 08:00:00', 'Deckendurchbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AF706137-5133-4694-B5C5-CFD59CF095A5}', 'global', '255', 'flooropen', '2024-04-22 08:00:00', 'Deckenschlitz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C6B52190-920A-42B3-A3C2-1FBDBD85C75B}', 'global', '255', 'roofopen', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F3D6A91E-121C-4FE7-AE2C-892671053923}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Blendrahmen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DD2AB751-87A0-4887-BC64-4C1B16FD47E3}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C0C70252-5112-402F-A40B-74547F9B4A80}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Blockzarge');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E361D7B0-7CC9-4CD7-8001-9D7E0F30D760}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Garagentor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{25C0C81F-4ED0-4505-9C0B-A38FB3B35A99}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Durchgang');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2ABE8915-6A96-4D29-A59F-66D70B2340B8}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Eckzarge');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AA83C2B5-E26E-4D6A-AC24-45341D5609F1}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8E3BBE41-F6AB-4E8D-9976-7DB26DA7A228}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Schiebetüre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AC60624A-9610-406A-AA10-5D48AA913C54}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Umfassungszarge');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5C146917-7595-433E-A8B5-B648E8C00D90}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{29644F73-23F5-4451-A857-E57B0252792C}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{102E2C45-9AB8-4209-9F44-6BA19AACECD9}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür mit 2 Seitenteilen 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{76AB29AB-E3DD-409A-826A-8DFC68EC52E9}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür mit Seitenteil 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3AB6C890-1934-4531-9FB6-D972627F5FEC}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür mit Seitenteil 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1F5950A9-7964-4A0D-BE03-C33309B9D3B3}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür mit Seitenteil 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{96176F4D-CA07-485E-A6E7-AF3AD79E5FC5}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Aussentür mit Seitenteil 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB537FA7-2AE3-4889-91AC-0D7DA1FB46B4}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Industrie-Sektionaltor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9AC95C22-FA18-498F-A402-DFF049E15FCB}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Innentür 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{643F6FA7-7493-4EEC-9739-7A6628814B66}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Innentür 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F50C60F1-F931-4269-AF62-6526DBCAE0C3}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Innentür 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B70142F1-6C94-4536-A5C1-A609E4C39CFE}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Labortür');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E3824AAF-E7DC-466A-BF0D-00DC040F12B1}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Sektionaltor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{145F7D14-D501-4DDC-ABF3-24D9F89521D0}', 'global', '255', 'walldoor', '2024-04-22 08:00:00', 'Sektionaltor mit Verglasung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{33013B22-F653-4091-8CBC-43932CC9F75B}', 'global', '255', 'wallopen', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{54D076DE-A3D9-4801-B105-4374E9554B59}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Kellerraum');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E4E7657F-5FA1-47FD-8CB7-633582423A88}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Nassraum');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4310DE24-EE57-4A0A-B940-59CC340F2019}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Wohnraum');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{203366D7-1317-4B19-AE28-AE54647235E5}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Treppenhaus');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{32CB9C3B-C2BF-4958-9D81-5DC5C9AE1767}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Flachdach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8E458018-7FCA-47D1-A08D-78E12C54ED13}', 'global', '255', 'room', '2024-04-22 08:00:00', 'Terrasse');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F8301BAF-73AB-4FFB-BBF1-D3D2F9EA615C}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau Estrich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D61D0E7E-3E03-4BC7-A50F-2A71FF3CC845}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB16450B-246A-4D47-B4A4-3C009B951EE4}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau einschichtig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F9368740-60DC-4895-9D24-B16F45ACE847}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau gedämmt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{176AC47B-78CA-4FCB-83BD-2A665C96931A}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Flachdach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9AA51A64-3383-4E81-8023-B5BE6145FB92}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Flachdach Gefälle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7E34E299-D8D0-41F7-9517-0BC6E2BF9812}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Flachdach Gefälle Platten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{463B4A5A-8A35-4193-9E1D-3C10C7E9E236}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Gefälle über Abfluss');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1588DD52-38DC-4BEC-8AB0-75E4C81B12DF}', 'global', '255', 'roomceiling', '2024-04-22 08:00:00', 'Raumdecke');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{271D7AA8-5E71-42E5-8F30-5986810208E3}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Einreichung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{13E9CA52-4E51-4BBF-A6A8-6B73E07F593A}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'BIM2COST');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{01C41FF3-EDB6-4EC7-84EA-2B2C0A881345}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Entwurf');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{463C9A6E-E130-46D0-B97A-41A8A2677345}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Ausführung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{224AEBB5-4FFB-428C-A697-8D641AE222DE}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Raumnummer');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2B380CA5-4EA4-4A0F-A418-3D7BD2209062}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'Total');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{89C44BE2-0432-4B15-AE0F-22B70AB89D56}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'HNF Geschoss');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CEF7C968-F81B-45E1-9C87-9B38460BBDBC}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'Total Bereich a');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{29E3ECA0-8AD9-4B7C-A13E-0C3F8C16F778}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'Wohnung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9599E392-7450-4458-B387-75F0DA11C80F}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'Raumsumme');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{67DDCE7C-F1E7-4AAC-8235-AF09EE6E0253}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Ausführung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1B1E8923-DD81-4724-B19F-842B8FF3C750}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Einreichung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2452C356-1607-4255-ADCF-41A794EF7220}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Entwurf');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E38C29F3-8800-464C-9F11-0CA8127DC670}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Standard 3 Zeilen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B1E63129-70B8-4B9C-8A00-B045EC409187}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Standard 5 Zeilen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{547D7B88-11BD-4949-954B-5E6D78AA3E8E}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Raumstempel für Schnitt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{65FBE462-555A-4E39-A7E0-B5808FE3D61C}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Fensternummer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5A33F812-D12C-45F6-B4AC-60FC3EF7589B}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Nummer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C5FE2019-9DE1-4ED1-8F3B-15B55BB640B1}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Türnummer');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C94BC984-FB9B-48B7-AB56-584B2F9B156E}', 'global', '255', 'grid', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{394CDE64-AB91-4D40-8319-2542DBBCD2D0}', 'global', '255', 'grid', '2024-04-22 08:00:00', 'Standard variabel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ACE0DE97-76B3-43BB-B88C-47D39088724A}', 'global', '255', 'grid', '2024-04-22 08:00:00', 'Standard variabel 2');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CD7FC9D3-245E-4829-944F-4273672DFE1F}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.75 Halb m.ü.M');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{19CEF24E-8DBF-4878-B8D0-71923EA6A1E4}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.5 Halb m.ü.M');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{818BC64E-03F3-4872-A6C7-FDE27546A0DB}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.25 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{61656609-BA4D-46F4-8994-EEE49F1039BB}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.25 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6E54E740-4983-4BEC-AFDA-67F15B96BDB4}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.25 Voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C8636C15-D0D0-4D93-8AEF-3204163826AB}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.5 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4081622E-03CA-49BE-BE51-2F7BEBA1A3BE}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.5 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9C6CAEA6-A474-4E15-A688-3552BAC62EA8}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 1.5 Voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EFB3B289-6FC3-4CE5-85A3-E7430D2E2D0C}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.0 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8832EE45-8B86-470F-BE17-342CAB573A59}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.0 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CBB74D0D-C6ED-4454-A59A-49CC743B1409}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.0 Voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{17B842D9-6C51-4BF4-8210-EFB028AE97A6}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.5 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{41C763AC-9540-432A-89A1-1762F0FB4D67}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.5 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D6B035B4-26D8-4252-9A89-CFB07B5431A3}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 2.5 Voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CF5B9657-5B11-44B1-8B81-072812E6D277}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.0 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7D1F443A-BD61-44EF-88F2-29F163D53C59}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.0 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C35CE327-5F8E-4CB7-8C3E-95331F80EFCC}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.0 Voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A780D6D9-9A66-48A8-A04C-42192249F1F2}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.5 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B2C76D49-B358-489F-B4A0-360E49B35ED8}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.5 Leer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5898B205-D61D-470C-8659-837BBEC31830}', 'global', '255', 'ardimlevel', '2024-04-22 08:00:00', 'Arial 3.5 Voll');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1A8D96E0-32C3-47E9-B696-4DF98F6D3BBA}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.5 Fertig / Roh m.ü.M');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D8939E09-6901-44D5-803F-9AD9177E703F}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.5 Fertig m.ü.M');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9D17297E-4B5D-4570-B9E8-813337152800}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 1.25 Fertig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A41A32C2-933E-44BE-B6CF-2BA0217EC1F5}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 1.25 Fertig / Roh');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{771C5824-0D59-4037-8429-5F155431E030}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.5 Fertig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{248D3527-04C3-4944-99A4-0427BA1712F8}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.5 Fertig / Roh');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F07C7AAB-D0F5-4D50-905E-57836CBC0E43}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.5 Roh');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8BEB0AB7-77C3-4E3E-8119-19498476C95C}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 1.25 Roh');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8E55A572-D329-4845-8EE9-86CCD88B0397}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.0 Fertig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0A56CDBB-B58E-43D2-B41C-A20A9FEB9C0E}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.0 Fertig / Roh');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AC8D1F1B-1C1C-4A56-9239-6C287404A089}', 'global', '255', 'argroundlevel', '2024-04-22 08:00:00', 'Arial 2.0 Roh');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F5AD830A-CB2B-4ED2-9846-7EAFCB62E380}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6E96845C-7607-48E3-A88C-D92EFEC04E39}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Fertigteil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FCC1AC12-A294-43E1-9D31-13BE4B75C432}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Leichtbau-Mehrschale');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{02E8216A-D9A9-4C76-8815-EBEAF3A5276F}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Ziegel+Wd+Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1CAF722B-F5AE-4C44-BC3C-35C44908B1B6}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'WDVS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CD827C0A-E744-486F-9BBE-CE9BC4549635}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Aussenverkleidung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2FD7FA02-9096-4077-A583-98B31A9913EA}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'WDVS-Brüstung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{32A4F724-6FDE-434E-B546-7AF81A51BE5D}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Innendämmung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5FDB3EA5-537E-478E-8B6B-CABDE20D481D}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Holzleichtbau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EC2F7ABD-CC40-4089-AF51-3ACC8B226ED5}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'WDVS+Dämmputz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A4D38E4F-91A9-4405-9C9F-29477680EEFE}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau Zementestrich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{68F8FD9D-120B-4EE0-99E3-FD9189F810F9}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Entwurf einschichtig');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{39D1CA3F-F353-4FF1-9F7C-EC26CD23B724}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Auswertung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F9363BFF-F148-40D8-A6F0-692E6F869723}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Eingabe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F87336CA-281D-4F71-A493-E93729B35CF8}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Ordnung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1AF01BBD-B27C-4D56-8CCE-1DDA179F61CE}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Werkplan');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C978BDDC-0C42-4C87-BEE7-80288CA95092}', 'global', '255', 'roomgroup', '2024-04-22 08:00:00', 'NF1 Geschoss');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BC30D25D-63BB-403C-912B-020F8D93A549}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Eingabe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9E7268E4-3495-440E-972E-2AF085DE7416}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Werkplan');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B6DE281D-B0E6-4785-A8B8-F86EED2CE152}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Raumstempel für Schnitt 3.0');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{407E19E0-5501-498B-88B4-6F1114351D5A}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Backstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{86FDB34F-B1E8-4292-8071-6EE8E57C7F7B}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Kalksandstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1F376323-DCD7-4857-8BCA-2A3114001115}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Naturstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A469246B-6235-40E9-82E0-977282265DE5}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Aussendämmung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{60BC15B0-4CBE-435A-9C42-45717F54CC38}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Zweischalen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1DC32FBA-2529-4591-921B-DDA1AFE08F2B}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Brüstung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8188AC88-B66E-43BC-8E15-4151C13C8C68}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'schräge_Wand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4B5F6A2C-78F0-4C45-AE85-9C1908E56C81}', 'global', '255', 'wall', '2024-04-22 08:00:00', 'Randdämmstreifen unsichtb.');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{64A6B493-F5FE-40FA-A88C-021660E2EB62}', 'global', '255', 'column', '2024-04-22 08:00:00', 'Backstein');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{124C51D8-C3CE-4F33-85CC-7CFBEE17647B}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Aussendäm_Blende');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{73935B9A-104F-4E5D-BEB7-A2F6D8638319}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Verkleidung_Rolladen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1828EC49-2341-44BA-BA12-7118D172C2D0}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Zweischalen_Blende');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6A727680-CF63-4319-9E36-7E4306A15D74}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Standard_Tür');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3B5CFFF8-8EF4-4BD3-A0A6-E6378A506ACC}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Sektionaltor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{96F8755D-6F54-4C16-87B2-3C153D3F93C0}', 'global', '255', 'wallwindow', '2024-04-22 08:00:00', 'Sektionaltor_mit_Tür');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{75100F5F-4B7C-48BD-9D1C-23EF77B41D14}', 'global', '255', 'roomfloor', '2024-04-22 08:00:00', 'Bodenaufbau Zementüberzug');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5464606B-0620-45CC-8724-AC89F2079530}', 'global', '255', 'roomceiling', '2024-04-22 08:00:00', 'Gipskartonplatte');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{886A7EFC-C55B-464C-8E74-8CB6ECE12BB9}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Bauprojekt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{11B450C3-74B5-4E96-8724-7DCC261C56C0}', 'global', '255', 'roomparam', '2024-04-22 08:00:00', 'Werkplanung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D3D3EF34-B4E9-4296-BE09-4EE6EEEA97BA}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Werkplanung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3CC8BFC4-79FB-43A5-A0C6-E5654419AB28}', 'global', '255', 'roomgroupparam', '2024-04-22 08:00:00', 'Bauprojekt');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9E2CDE8F-DD2F-4C66-9A43-2450AAA9CDE0}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8F2512C5-0EC4-41AE-A430-8F3B35028955}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Verkleinert');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A8AE3623-ACAE-455F-BB6C-135098408050}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9124CEC4-E617-4BCB-AE1C-D6359D6B96DA}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D6176F37-4873-41B5-B12E-119C1D6CDD3B}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{78A54DC6-EDA9-479E-816E-D5EDB8810991}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.0 block');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F190F42D-537D-430B-A68E-D2F974132FFE}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.0 fett');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8EA30D59-8154-47B7-B8C3-583B959FB284}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{11F3FD12-8D84-4279-AD4B-C863AEF3D21E}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.5 block');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{781DF76B-0CC8-49FE-9144-67F4BF1A1685}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.5 fett');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6EFC24AB-B214-4B6F-86B6-461620200419}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A13F8107-624A-4453-901B-40E38CDFF01D}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{385711BC-7153-4CA5-A096-38EF5FEF5EF6}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9380C75D-5FDD-4513-BA05-5A7C6394F6F1}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 7.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1D96A58B-DD30-42BC-9DEE-E8AF856DB0B2}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial_10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{845450DC-F298-410F-BD25-0B7F5EDAFABA}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial_15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AC481E96-9595-48A6-878C-8F9FA4600E30}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'gelaende');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{373A3F0E-CBE1-4541-A097-FC5500D01532}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'leitung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A7C20164-6DCE-4330-9AE4-DF3473153824}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 1.5 mitte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{602518D4-0A59-4F38-BBBE-79CDA16EF483}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'schacht');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{756C6BB0-C555-47AB-B665-E773BE7AC13C}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.0 mitte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D0C5C266-B2D8-4F91-ABC8-E4F93D0687A9}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 2.5 mitte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C686973F-6074-4EE1-A562-F1C8C1C9093B}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 3.0 mitte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{974C41C1-8730-45B3-945B-23F14E10BC4B}', 'global', '255', 'textpar', '2024-04-22 08:00:00', 'Arial 7.0 mit Rahmen');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{54E4BE29-6350-4834-95AD-FE901E2ED64C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Himmel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9A079A83-D149-4FAD-87EA-17053ECF713F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'linie horizontal 0.4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{916E99EB-4103-4693-87E9-BCECD6451ECC}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'linie vertikal 2mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{08A948EB-037C-457E-96B5-EA2E984A65AB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'linie vertikal 4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EDEF2C8E-6390-4175-A5A0-2DE7EE3410F2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'linie vertikal 10mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{349B6BB4-2355-4EEB-8E88-08F7F372936E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Dach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D91F7815-5979-4F97-876F-53FCB054EFC8}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'abbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C2A4DA47-C554-4549-8E58-FD9F86575E8D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'naturstein-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C0B3C88E-B6CF-4115-B690-72B2EDDBB382}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Holzwerkstoff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{65969F42-3120-4424-B61C-E591DB5F9112}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'holland-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CFBC6E13-CC6B-44AB-9CFE-C71E9E6B7954}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Kiesbelag');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{27C0745B-B2F6-4173-B93B-9CCCE08E5AF5}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'binder125-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DC533318-622E-4F21-BFC6-F7303F45D14C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'binder80-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EF728FBA-AEAB-442C-A2FF-4F828567045E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'bindervb-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F9206738-DA4C-4911-8B59-989CD21A2DF7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'bruchst1-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{70BDAE38-B102-4AAB-91FA-DFA7629B6CC0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'bruchst2-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CE6131A2-77FC-4187-843F-CB8E9DD61902}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'dachziegel-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FF4D5801-43F4-4B33-95FD-C5DC592E9981}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'isolier12-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2197FB39-3E1E-425C-AA6A-5560982846F0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'kreuzvb-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C2689A01-F5FC-4387-84C8-A8FE2B266E9E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'holland-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C395005E-FC2A-4F24-AD17-5CBF17AFF2E0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'isolier10-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{58EA4A7A-2779-42EF-88C4-519A6879F18D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'dachziegel-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D877D7CD-42CA-4247-9C91-3D87CC4627BB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'kreis-ortho4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E13C57FC-CF7A-4F37-B5A0-9F0F4AFDB227}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'kiesel-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A3CD1B11-7CD5-4D6C-839D-557A10CA785A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'kreuzvb-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8221ED3E-E363-49F3-B919-D7E347CE29B5}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'marmor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{242B075B-D4C1-434B-94D0-FB839C20A671}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'lochblech');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0039B69E-7D17-42B9-8F75-183F22DD3311}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'mauervb-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ECCE61E0-2386-48BD-A495-0120072787A0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'mauervb-PP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{25CE38D4-BF9E-452C-A79C-6B9399E3E42A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'naturstein-EP');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{37723428-5BFA-4678-808D-708B752F26D3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Kiesbelag');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2A61BE28-B754-424B-9B04-2EE70FD7F5A9}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kreuz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{94D28566-5151-49DA-8C16-10900DCB8340}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Stahl');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{44F36128-424F-4041-9FBC-3DAD1782D185}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Stahl');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{20632E89-E6C6-40F7-A729-23928BB9E1F1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Holzwerkstoff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3B2419FB-C307-463A-BF15-9BB0CFA2C88E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Abbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1377656C-2F8B-425C-BAD7-14B731A69952}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Erdschicht');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{38F1A201-B345-4552-A54D-570C6A4E40C0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'dichtstoff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E8CB49BD-0B79-4D7D-957E-7B4DBD51CB10}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7D66C7D5-8C53-4FBB-8493-29689A4F79CF}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Gips');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{741AB239-709A-492E-A0D5-EA080F429C59}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Naturstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{257CDA6F-4DB0-431B-8CA7-EEA09C95EE50}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Standard-3D');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CC9CDB21-4A4A-43E8-864F-9BAB6C19FC99}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Standard-3D');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{217E915B-43C7-4599-A65B-377520F4E7C2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Schatten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2D6A9C52-01E8-497D-BD5B-DEB847E444F2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Ziegel_WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E76686AD-8C74-4AA7-AEA1-707CEFF6AF32}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Beton_FT');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8663545C-71D6-47F9-A3EB-93D8E4707917}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Beton_STB_WU');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0DB5999C-081B-40B0-9B94-18E8B512C71C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CA5D610C-486C-46BE-8A10-CA1A1DF56429}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Metall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B3E176C2-9D6A-459E-8C86-51A8D39D8250}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Beton_STB');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3A026BDC-774D-489D-9FA5-DBC61944A55B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Beton_WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9F02241F-DF7C-4462-8E81-A547007C91FE}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Neuplanung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CA52C3CA-9574-433B-BD5C-70F5DCE77790}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Dämmung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{623BAD39-BED5-40D3-B157-EFB1BB9D0FB2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Naturstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5BFD64E9-A481-49B5-95D7-D43D1F05349F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Glas');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7053313B-3B0B-4E8F-8F41-C59CBA413F21}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F301BD7D-E291-4C16-A0FC-BC933DE9338E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Leichtbau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B6D51FD4-A8FE-4B7A-8213-90141E7E07BB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{92F78EE9-9A94-4BA0-A07C-0E31535BE5FE}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton Estrich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FC06004B-C40E-41D7-B202-DA434C493226}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AAB687C4-8453-47AF-BA97-BFB8ECC6DEF4}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Erdreich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9AACE360-C7CC-4DE6-A3C6-BF5EA4CE993C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Leichtbau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8ADBEE74-7491-46AE-AF1D-06A522513774}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Rollierung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{33138ACF-3803-4DFF-AD45-A9DE752D2CB7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Ziegel_WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{48C6D772-D2AE-4C3E-9096-BE1403901FC7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton STB_WU');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B5E4F170-C17E-431F-83C5-614729F639CD}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton_WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{11A3BCE0-D1B0-4D7C-A4A8-17F046C8DCA3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton_STB');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9B850B14-DD0E-40DF-B86F-7B3991E56E9A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton_FT');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7DD2EE98-83B1-4394-8330-21CBFCFD39B7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Beton_FT_WD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{20EACF40-B937-47F2-9C8C-71DE3FAAA8A8}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Metall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{569F33E3-A00C-4147-B5F3-52523B9AA8A9}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Rollierung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BF37BE11-10A2-44A0-8C71-64B135AEC7F6}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Erdreich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4CC3CA3B-4295-4429-8C77-C83A236F200D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{16D03D49-2899-4490-B6E2-D756610FEC3A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'V grau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AF650641-15B1-4636-8277-0421380219AA}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'V schwarz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E7FA8B6C-D79C-4518-98FF-4D29495E269B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Natursteinplatten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F1BEC6BD-8A53-4E06-9F1C-610F18C74906}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Aushub');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BDD78A8A-7B0B-45AD-89D0-5E1C8AE5027E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'unsichtbar');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8538E660-14C9-484F-8044-596642097690}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'gelb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{07135FE8-1FCA-4AE3-B081-7FE79F5A7ED4}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'rot');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F7D9EDD5-D2F2-426A-9211-1457BA6130A1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Bestand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4B389EF5-E116-4C35-9EE9-4F279B35E9F0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Bestand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C72DD8C9-A560-4D74-9407-21E77E575AD1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'schwarz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{650EBBBD-C932-40EF-9AD7-74BC051E76BF}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Dämmung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9D68F481-91BA-4548-B2E8-11E4010758AB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'P Dämmung hart');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8FFF680B-0040-46E1-A5E7-383216131211}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'E Dämmung hart');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5DCB9484-E2BE-401F-B601-103332C09AFE}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'grau_dunkel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5443833A-423F-4C72-B700-6F1ECEF9DC1E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'grau_hell');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{92B99FFC-0D0A-4D40-86C2-7236653B629F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fensterfläche blau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2923BF8A-5E4C-4D15-90D6-5887BA4E147D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fensterfläche grau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{41459EA0-3C00-477D-AC7D-93FE8E24A668}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Holzfaser_parallel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A15991AD-81B1-4022-A0A4-C577A516E27C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Holzfaser_quer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5C90D311-2C3E-4AC9-850E-0E660BCC6742}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Schatten transparent');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A2518681-C9F7-48F1-80A9-BF824027CB3F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Estrich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{963A0EBE-B42C-4866-848B-B6A88A076530}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Gipsplatte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{26964ACA-C79B-4641-8929-E7DAAD975FAB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Pflaster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{27D03F94-AB23-4DE9-BB30-6B5ED3E2572F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Platten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{177ADB54-5F47-48C0-A6FE-6302DD3A99E2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Punkt iso 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D3E4C3D5-368D-4A3F-9392-D4D98F623038}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Punkt iso 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{870ED098-3C17-42E5-AE9E-A09C268E67D5}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Putz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A5E110E5-B532-47BB-B94B-6261CA73CCA8}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Welle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{09F180CB-3CCA-46C9-A28F-B351C1F47B0F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Erdreich-Fl');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A8043E1A-0AF5-46DD-BFD6-65AA120F7147}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fliese 60x30 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A73851F1-EE18-4ED3-B0C7-9C43399625A2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fliese 60x30 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1BA33574-8DAE-4DA0-A822-9DCA24B45B44}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fliese 60x30 Vers 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F539B35B-84FE-487A-A1B7-B751B6392D2B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fliese 60x30 Vers 1:50');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8FD5BA59-E5C3-435E-BC0C-55A1CC64D358}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4D5F8CA1-55D5-48F2-B625-A418A2DB396C}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A67D8E15-C752-4430-88CE-B7C5427E3A20}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.0 L15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E4DED02B-4442-473F-96A5-6E1BD4772A2E}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.5 L04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2D217A62-18AD-4DF3-BBE7-B877B18FC0E7}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.5 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{03E4E2AD-0170-4BB9-AAA5-D8F01A8A1E0E}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.5 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8BBB2685-9D3D-43BF-A1E5-A7A4386CB038}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F64F5864-3D7A-4F83-AA2B-AC54518866FD}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 2.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F7944742-1CE4-421F-A1CC-0D342D099959}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.0 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C4A904BD-98AB-4C83-B9E4-08ADF696501A}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{830D51E1-6FC2-43F3-A0B5-D09A95D4BEC8}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.0 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FA3A4A3F-56A8-41EE-80BA-A8D17BCBCE27}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.0 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C07D5B22-B33C-4CAB-91BF-4F9368243552}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0A0AEEC8-A57C-4C3A-97D4-AE250F23FAF9}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{637BD783-F226-443A-8A1A-948AADAEE68F}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 3.5 L40');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8547E935-737C-41F3-8801-49FDCAB536F3}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'höhenschnitt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E3894D8F-A332-4350-8004-FC5968A0A688}', 'global', '255', 'dimpar', '2024-04-22 08:00:00', 'Arial 1.5 L02');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5A1684DD-DB08-4DAD-8FA6-21D31D35E9E6}', 'global', '255', 'reppar', '2024-04-22 08:00:00', 'Umgebungsflächen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D3B4AD05-DDFB-46E1-BB38-9E4E570950A5}', 'global', '255', 'reppar', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ACCBE5B0-9361-41A7-8E3A-C34655FD1570}', 'global', '255', 'reppar', '2024-04-22 08:00:00', 'Betonelement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{28DF718D-4462-4364-AFF5-B1E2CC4134C2}', 'global', '255', 'reppar', '2024-04-22 08:00:00', 'Holz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CEED71C0-8103-4A5F-A95F-D8C2ECD1DB33}', 'global', '255', 'arrowpar', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{765311AE-A7C5-4829-B5D1-EA463B4C5206}', 'global', '255', 'arrowpar', '2024-04-22 08:00:00', 'Standard Kreis voll');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{772B3D8E-894F-4556-8E4F-1A8A46CB59E7}', 'global', '255', 'arrowpar', '2024-04-22 08:00:00', 'Standard voll');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F4822333-D012-4CEE-A9C8-8B9F2953013E}', 'global', '255', 'terrain', '2024-04-22 08:00:00', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7E728FC0-C46F-48DB-BAD3-21D9A77E6EA5}', 'global', '255', 'attrcolpar', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{59DA9621-5EAF-4776-BEA2-D6C837C467C4}', 'global', '255', 'attrcolpar', '2024-04-22 08:00:00', 'act');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CDD47600-80B4-4D5B-9B94-27AFB2C04FEC}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Defaultfarben');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DC1505AA-E540-4069-8E97-4899BB328B00}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Baryt 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B21DA632-660A-4221-9232-D2C24183A000}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Baryt 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6F5432DD-55DE-4ED7-B985-1F038CAE350F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Bestand (voll)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C416BF4B-B6E4-4B44-825B-BBC8AC47A610}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Beton 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B6232559-7C82-47BB-BB48-0989194C62E6}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Beton 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{263FB6EA-312F-4B52-A4BE-31298620F08A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Betonstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{89F5822B-CFCC-4D09-8905-26CCD18F677D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Blähbeton fein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2FEF9854-9DE0-460A-8B6B-9C7F4C9B0AFB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Blähbeton grob');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{252E8214-DEC6-49BD-B211-123977ED6682}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'DV Biber 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{07CB3D04-CDDA-4036-AA62-4A7BB77F7E9D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'DV Biber 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{439EB061-967B-42DD-B5A2-BAF0BA8C6699}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Erdreich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{99C1BC7D-8DCA-4F57-ADF6-317DC572BE80}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fertigt. 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B63435F0-3FB7-41E3-8B82-7458A3981BD1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fertigt. 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{479B9576-DB45-4135-A6F0-1CDD3B46541B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kies fein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CB427E5C-9C8B-4CC2-A8EF-BFBC01043705}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kies grob');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AE476B92-10FA-436B-9BE5-08E7502EB9AF}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Leichtbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{942AF4DC-CC9D-46A2-B84A-B6FECC8CB907}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linie 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AEE10660-5A1A-44C0-876F-1C3637B673E7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linie 1.5 s');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4C6AE5DA-2040-4F98-8DF2-CF4BB4AE4A39}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linie 4.0 s');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3B597121-4006-4A9B-B106-7DF26A4DD9FD}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV DIN 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D73B58AB-9E70-49A4-99BF-AA26D6963F5F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV DIN 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7B11032E-D124-48CA-9945-38CCC5DDFDA3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV Fläm. 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F0AA7B71-E02D-4088-BC57-E23E36DE10E2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV Kreuz 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A1B5EE9D-3BB8-41E2-ACFB-64174B4D2B77}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV Längs 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{50B855F6-5019-4530-A47E-BC5390EC1303}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV Natur 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{77640353-E8D8-424C-ABF0-97057E5DCE76}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'MV Natur 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{261530A1-5E85-4752-A1C1-E7F27AE883C2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Magerbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E304EDFF-F991-4F9D-8867-8451640E9D42}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Porenbeton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FF0D1A8B-7984-4044-9190-18D392247E54}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Punkt ortho 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2347F497-9CF8-4C21-975F-F76EC3E1C1B2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Punkt ortho 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{97850556-8700-480A-A754-3B52ACB3069F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{69E8CA2E-4E21-49D0-814C-6B7E9166E1C3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{26169EAE-0E82-4FF8-9654-73D869616E47}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster 4.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AF3398DF-D12D-4178-B749-97EAF27FC355}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster 4.0 d');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F6C1EC96-1D68-4F5B-BC22-77B1EE949BB5}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Ziegel 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{07FAE596-F616-45F8-8718-F7AAE0D3E517}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Ziegel 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8A6F27E9-2939-404F-9CDE-3D7736B86BEE}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Himmel-Fl');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{26EC264D-7719-4F7C-9F9B-80680D3C7EB9}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D1FF8972-EB51-4004-8309-67C062E1CC8C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linie 0.7 s');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{441D08B5-2FB1-4D92-8CFE-56A1E687CF6B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Standard-3D 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D3A69D30-A99A-427A-B596-39B6BB4E11A3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Standard-3D 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{57E54E93-F069-48BA-BC76-6F151ED1CAC4}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Glas');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{407AD1BB-FE30-4612-9AC7-C59861EBE15D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Naturstein 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F66B7AFB-0FD6-43CB-BEC6-A52D4545BBBB}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Naturstein 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E4E03AD0-5B54-43FE-AE96-BB5620ADEB8B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'grau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0AB229D0-8579-4BC5-9328-3CB2F9912093}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Dämmung_weich');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5ADD1FAF-E696-4EA5-8EB1-9DD15F25AFB3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Dämmung_hart');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F60EC0A6-9936-4865-AC16-F08CD63A25E1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Erde');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E0CFD172-059A-4710-9118-77B976AD851C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Gips');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{34A153F3-EA96-41FD-A1E8-777C78194D38}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Holzwerkstoff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1A5830F5-4503-47E6-839B-E9955C64E49A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kiesbelag');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CD83E822-B195-462A-BF43-8FEA2709572F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Trennlage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB5192FC-2BBA-459E-8BB2-5B18B8F6F608}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Natursteinplatten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{338993A1-9C6B-4B96-9924-D6F5E4587400}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linie 0.4 h');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F2CC4E62-5AAA-41A2-BF54-C94199F8F8F1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Holz 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4462C516-60E7-468B-AACD-A0E683039A07}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Magerbeton 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{183512A2-D03E-4FF5-8372-77D0C96BD2A2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Bimsbaustein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{47AF0E0E-4340-4907-AAE7-48135218DEF7}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Profilblech');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{704079CD-66E7-4AC2-976C-D815F574CBB4}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Wabe 1:25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E27A0589-DC70-403D-8E16-020BEF2586C2}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Wabe 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{854749EB-C55C-4F49-84A6-297E1F592933}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'BWB');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E6194048-8BA2-4124-90F0-89CB311527A5}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Brandwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F943B2D9-6E5B-4F56-9D00-C560EF39874D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'F30-AB');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{25B152F0-E580-4A28-B5ED-1D89BFCA62D8}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'F60-A');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DEF84E78-745C-459A-A6C8-B7F0ABE18438}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'F60-AB');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{39C7EE5D-2DF9-43A1-AF32-DE4CCAB9E614}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'F60-AM');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB930DBF-4379-4D6A-B5B7-21AF1290CF9E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'FB (F90-AB)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9A60928D-91D9-4DDC-A658-7FB38319649B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'FB-NB (F90-A)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F7FEC9D5-8605-41A0-A989-E1A24B21DE8A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'FH-NB (F30-A)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CFB41663-1D3F-4811-BB08-FB71804F851B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Fensterfläche grün');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1116CB82-9B48-42EF-BD47-AA9492BACDA0}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'NB-A1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7F4A7A4D-B97D-4491-A2FA-3BADF75EA56A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'NB-A2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{728E3392-0CED-4249-A0CE-FB45C1F25F5B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'SE-B1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{85963A1F-4A8F-464C-A3D2-9A942349DC4A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'T30-RS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9A047477-768B-4CD8-B289-2EBC8DD97A9F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'T90-RS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7A0A1481-7A95-4041-A247-0E2440DC2D00}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'X-grau');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{112107EA-B817-4AF4-BEE8-E4EF9CA50783}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Umbau/Kanalisat');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{29DDC9FE-1733-4C9B-8BA9-1EA77A944890}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'RAL_DGJ1050_130g');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4F3F0588-4B8E-42D1-989E-45839549A91B}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Schwarz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{84CE6522-1482-41E3-B753-E2643C7BA652}', 'global', '255', 'printpar', '2024-04-22 08:00:00', 'Solid');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{26AA5A50-92FA-4E32-A9DA-9C81DDBAB364}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Dämmung_Linie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BCA5ADE7-DE83-460C-BF04-041C15F32F3E}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Backstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E8BA43A5-EB3B-4BA9-B4E9-609F114D5423}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3C4DD156-C4F6-4758-A985-1FC7584A4997}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kalksandstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2A0BE25E-D265-4FA3-9F17-090BB9695639}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kunststein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F3A6EF30-2E81-4A9C-AE49-7DA2AA844A08}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Naturstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{02001B7A-9289-406F-87E8-5482D49F557B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Zementstein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C74DED96-C7C0-4BBF-973C-F03085568A55}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Bruchstein 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{192B6D5E-78D3-4840-ABE9-C904A66D1899}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Sichtstein 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AD39788C-8DF0-464C-8D24-9EE674ED2D16}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Dämmung_Linie_eng');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BED503D0-BF56-49E1-8938-64FED240B3B1}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linien horizontal 0.4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B7375BD4-1CC8-41DC-A846-32F133BFBA7F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kies_fein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D2A87909-F2AA-4C16-8C6D-096DDFF214BD}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Kies_grob');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E1925465-C2B5-4E64-8594-1A44E9D21F81}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster_2mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DB9D17D3-1E1C-4C6F-B9A9-6C937E85DF0C}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Raster_4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{30DAF67C-E0B3-4483-BD3D-64D9B218DC77}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Sichtstein 1:20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{75029560-E488-4AF7-95BC-400C06A2C31A}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Wellenlinien');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9664D059-B915-410C-9E4F-E5141E9C783F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Calmo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9F811EB8-6E0E-4751-A245-65B7AA966D21}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Unterlagsboden');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{25752EE1-A32B-4AA9-9C05-145D58ABF576}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Standard-3D_100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{154BF8D4-39E0-4636-BCDF-29320642CE28}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'grün_dunkel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1B80F064-7CD3-4FE2-8A05-085072E75C4B}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Standard-3D_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5C64369C-8F89-4EC1-91B8-8DEFA943EB56}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Parallel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{436CC8AE-622C-45CD-9C7E-BD8AD8C24144}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linien vertikal 10mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B6585992-F8C3-48D6-82FF-9B0B9A80D83D}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linien vertikal 4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4451D18F-B433-4FC6-A3DC-3B9CE8AEC7AF}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Linien vertikal 2mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E90DDC3F-E789-4387-A825-8EA470DA220F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Rasen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2D58316F-E799-40F9-8515-B27A3F65500F}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'blau_hell');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{409051E9-30C1-41A6-B857-A4AD3D5BDD24}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Wabe 1:20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{006B0FE5-5373-4F2D-8C12-8880C7ECFFF3}', 'global', '255', 'hatchpar', '2024-04-22 08:00:00', 'Bruchstein 1:100');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A6D665CB-949E-48B0-AFF0-8A51F7F0E0D9}', 'global', '255', 'layerlist', '2024-04-22 08:00:00', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E3606AEF-5546-4427-92AC-AFCF0C929C43}', 'global', '255', 'layerlist', '2024-04-22 08:00:00', 'Standard erweitert');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D1797E6B-CE93-44F1-B40A-B342C8D96905}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Stempel für Schichtaufbau');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{142765C1-7D2E-470B-9D02-E2E10FD5B778}', 'global', '255', 'dormer', '2024-04-22 08:00:00', 'Standard Giebelgaube');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{21F2DD55-2F60-4968-9A58-7A88717B8CC5}', 'global', '255', 'dormer', '2024-04-22 08:00:00', 'Standard Schleppgaube');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2F178AAD-5CC2-427A-BAC6-4321DFCC65B8}', 'global', '255', 'dormer', '2024-04-22 08:00:00', 'Standard Spitzgaube');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5FBADAB4-612A-4BD9-8453-30524EDB6A12}', 'global', '255', 'dormer', '2024-04-22 08:00:00', 'Standard Trapezgaube');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0F6BA49E-3F21-481A-9823-01CB6AC0D573}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Schichtaufbau 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9F3E3E6D-FAAD-47C0-BEF2-28B2A063B090}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Schichtaufbau 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EC4F102A-80D6-4A8F-A9DF-EC6E8C774004}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Schichtaufbau mit Überschrift 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4E39F920-78AC-4D35-AD79-53EFDDF69438}', 'global', '255', 'attrlabel', '2024-04-22 08:00:00', 'Schichtaufbau mit Überschrift 2,5');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{399AF82E-000C-4EAB-8270-21DCC7426B5C}', 'global', '255', 'astairs', '2024-09-24 09:37:33', 'Betontreppe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AAF3C11C-4C01-4A35-81A1-353A8E9E03FB}', 'global', '255', 'astairs', '2024-09-24 09:37:35', 'Wangentreppe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{00CFC213-9779-45C1-98ED-3089C8BB78DD}', 'global', '255', 'astairs', '2024-09-24 09:37:36', 'Stahltreppe');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9799D082-4B95-4E88-8B06-59760554B1C7}', 'global', '255', 'railing', '2024-09-24 09:37:44', 'Drahtseil Typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ACD80E23-32E0-4BE5-A2A7-A27AC0B935F2}', 'global', '255', 'railing', '2024-09-24 09:37:44', 'Drahtseil Typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FD706AC3-1704-4D81-83E2-D91C90D1EAF6}', 'global', '255', 'railing', '2024-09-24 09:37:45', 'Ganzglas');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CA15168D-6765-4139-92E2-752DE5838771}', 'global', '255', 'railing', '2024-09-24 09:37:45', 'Glas');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{50D412EF-7136-40EF-9EA3-982880D5319D}', 'global', '255', 'railing', '2024-09-24 09:37:47', 'Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6E26F8AE-FC14-422D-A5BE-FC53CB260E34}', 'global', '255', 'railing', '2024-09-24 09:37:47', 'Lochblech');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FD71DEFB-0086-4A15-8602-9EDD9EB5FFD5}', 'global', '255', 'railing', '2024-09-24 09:37:48', 'Handlauf');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B70B478B-EA59-4427-91B1-C70B994B56EB}', 'global', '255', 'railing', '2024-09-24 09:37:50', 'Platten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D8E7747C-C259-42CB-B25C-DBEF89222289}', 'global', '255', 'railing', '2024-09-24 09:37:51', 'Staketen Typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C362CAB0-C217-4D7A-979D-136B22626569}', 'global', '255', 'railing', '2024-09-24 09:37:52', 'Staketen Typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2D97F376-87D4-4F59-B0A2-1DF09C0136A5}', 'global', '255', 'railing', '2024-09-24 09:37:52', 'Staketen Typ 3');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1F568D3E-C98A-49C3-8B4A-B6B3F96259C4}', 'global', '255', 'roofcut2d', '2024-09-24 11:21:39', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{282EF7D7-CBED-400F-B522-1081955681D8}', 'global', '255', 'rendering', '2024-10-18 10:12:51', 'einfach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E1CA6F8A-A466-4497-B770-FA49742F633D}', 'global', '255', 'rendering', '2024-10-18 10:12:54', 'gut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{32EAF231-D643-4C63-A122-73FECA16CA6F}', 'global', '255', 'rendering', '2024-10-18 10:12:56', 'optimal');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9A6F105E-3E38-4BBA-A11B-C41AF815F5CF}', 'global', '255', 'attrcolpar', '2024-11-20 11:33:13', 'act');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CEC724CA-FDDF-425F-97D5-0CC5A9BB4873}', 'global', '255', 'attrcolpar', '2024-11-20 11:33:13', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A6865B08-917B-426C-BC09-FB1AF23E5F67}', 'global', '255', 'printpar', '2024-11-20 11:33:13', 'Solid');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B778B182-51C4-4EF8-B9B8-1E7D2C996B8B}', 'global', '255', 'printpar', '2024-11-20 11:33:13', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{13C49F1D-7D15-4AEF-B36C-069506D120F8}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'black');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B6CB775B-F0AD-4F05-9C03-F715D17BB5B6}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Subsoil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6FEE4788-574E-4505-BCA7-B03B128CA7B7}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Subsoil-infill');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BF888495-5967-452C-B158-7F45D1C3929F}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'sky-infill');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D07021DD-1511-4454-AFDB-21515DA2443C}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Stud wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{398BE4DA-4DAE-4BAF-BC8B-27B25121D9D1}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'blue');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FD858B82-C13B-46DD-A8A4-677D9B41BE59}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Raster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DDD157C4-1E9B-4891-A97B-B6B1BF21CD79}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'grey');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9ACB0475-E34C-4E52-B9AD-3375657941DF}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{96BFE789-6ADE-4A5A-8888-50746EB09EF0}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Plasterboard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FEAAC5AB-18D4-445F-9DFA-1CA0545A0198}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Water');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8DA64EB0-E0D8-4A07-9133-D018C23F522D}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Gravel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0F6C195C-D0C9-441B-8BEA-6B5CD013C1B1}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Tiles');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9533475B-770E-4473-ADF6-6EB90872642E}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Natural stone');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CF70FE62-45CC-4BAD-BEF2-4BD3B739B10A}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Sand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B8C59816-47B9-4C24-83DD-516C6DA34D4E}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'grey-dark');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4A835805-840B-41CD-AFFF-372F57C1D277}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'yellow');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BA6B0EC1-F346-4E1A-A146-0A1D58D591FF}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Wood');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AEE16783-56EA-48CF-B4B7-664C9F139228}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Carpet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7EEC086A-5BF1-4FE5-B926-8F03C759EED8}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Shingle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{58978042-D410-416B-B779-B437AE23AEBA}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Soil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C9AD4514-BB6E-48D5-BE4C-7B291B15F5A2}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Artif-stone');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B354B44D-4E4D-4ABA-9F01-938D2DB0BEBE}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Shadow transparent');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6AE91ADD-1558-4BDC-BC40-B71ECCF57B98}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2602198D-A532-448E-B66D-1D3F5D01DD76}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Gravel layer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D985166A-A62A-4695-A573-FDC381364205}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Roof');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{36FC7DFD-A7A6-47B9-A692-A3EE36F7DE4D}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Insulation flex tight');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CC3E34CD-7D7E-4782-95FE-FA762B3D0DE7}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Lean concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9BD76FD7-EDD3-4161-9C07-CE97D61D30F1}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Ground level');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FDBA1957-31B5-494C-B18B-B6AC8B763BBC}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Metal');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AE6D6227-B130-4D14-A5B9-AC393268F4AC}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Fine sand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8147B238-BC68-433F-A30D-9AA16A0F3211}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Insulation line');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BE3769F5-31BC-4C53-BED0-3F2DC99621EA}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Seal sheeting');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{25007526-8F1C-447C-8C26-866E528585F2}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Fibreboard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{35C77E94-3077-4B3B-8F62-55722CDFF702}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Gipsum');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CA5A6707-102C-4BE0-9DBC-D5D16B30A3F0}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Concrete block');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0A7FA813-2A4E-4F9F-997A-599B6E50047D}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Excavation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BEF30627-C10C-4B07-A2F3-4B97B250C5AF}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Shadow');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C7196CC4-7CEF-4F4C-A40D-CBF553605B67}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'red');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5B76AB7F-5A6A-4EFA-84F1-24D983577420}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'green');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2018C700-9A7C-448F-B344-4C49B3E8BAD1}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'grey-light');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3EEAADC3-292D-4259-B1EE-55D4E13A6405}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Cross');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D04CB539-5BE1-4A64-A0FB-64BEBF10DAD3}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Line horizont. 0.4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0677B49D-8175-4AA0-8285-156CECBABFEF}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Standard-3D 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DA176EB3-B7EC-4F20-91EA-2E95E1C355B5}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Lime sand brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4C7AC276-9165-430C-A234-EF862AA0EC1E}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Insulation flex');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A9549C9E-3E85-405A-BF13-8DFE4E87A21F}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Insulation hard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{83B616D5-2C77-41D8-AA7E-7708B5240932}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Screed');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6508C94B-C6FF-41ED-A578-6A8799DD018C}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'Standard-3D 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{604C9A46-4A5C-4871-B9D7-A68F8A58827A}', 'global', '255', 'hatchpar', '2024-11-20 11:33:18', 'invisible');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4FBF6C20-47B5-45EA-A9D0-258109CC8F04}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.0 bold');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4D3876C1-3143-4E76-B67A-12BA885A9A2A}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.5 bold');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F023FB35-044B-4364-8E6F-7A0BFB60CD11}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial_05');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8D2644DF-E68C-4D5D-920B-D7E53E2893B1}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial_10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8A3FD43A-AEA1-4D43-BCBB-1CB613AD33F0}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial_15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{ABF44E6E-07C1-4DC4-9E0F-ECF0C87E5E85}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 1.5 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{45DA5372-B674-4F19-8282-A33E91ACB80D}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{11DA27CA-C022-4C85-95C1-35C7BE0EB246}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C662FC76-5280-451C-A904-E1A9555F5369}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F763A47C-1241-4A2E-8D8E-0813D3689AC9}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{61044AF8-D85B-4939-B168-28D78092479E}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F258F226-EE99-4796-B23E-4CFFF948677D}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{79B17765-284C-4A1D-854C-6EC482F8A25F}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{53B8A1FD-3266-40E1-B211-2A2259ED05EB}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 7.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C8AA3D6E-D6A5-48AE-B014-2F66B21FCB72}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.5 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{11C223BA-90BD-449C-A27A-AC7AE48E1916}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'terrain');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5EC31300-BBD3-4502-A378-F8D6B8095243}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 2.0 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CE1D7D2D-28A9-4B86-A831-C116DC12D526}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'circuit');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A577946C-5F80-49F0-90B1-4410B287CB44}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'chamber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{63BE6F6B-2140-4262-8169-06022E3F5EAA}', 'global', '255', 'textpar', '2024-11-20 11:33:29', 'Arial 7.0 with Frame');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1880153B-4EF4-449F-A32C-8A4C3A5326E8}', 'global', '255', 'dimpar', '2024-11-20 11:33:29', 'height section');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{80870715-19D6-4275-A37A-CA50B4F48DE9}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6AD4B9EB-F4C7-46C7-AF19-165938523898}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{87DBAB44-69D4-45DB-A18B-67F57BB9D797}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F264B260-A514-4ABC-B451-CBE95C3B8047}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.5 L04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0D3454D8-7113-4257-831F-AEC818F662CD}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.5 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{47C83479-6487-4D1A-BB24-BA6ED937D028}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.0 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{EF2C9486-3460-4617-AFFF-2C67A7ED5254}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DFD562CF-A53E-4B62-9824-CB3CCD36A4ED}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 1.5 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{097478F0-A280-45A6-A957-937D38CC235E}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.0 L15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B28D5E0A-B085-4715-BBB8-4EA0C5FDCA2F}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.5 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C0E093A9-9D0E-4165-A4DB-D22B4F7B8413}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 2.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{920A4AA0-DA15-42D0-A3E8-48FB4A041819}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.0 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{49903A00-917D-4065-B383-B9A6D8C01460}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{63163354-359D-47E5-A145-F0BC348BA17E}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.0 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{93EE97F5-C582-4756-948A-4CB5549041FD}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D4F61818-54C7-4DEF-968F-1C57C6615FF5}', 'global', '255', 'dimpar', '2024-11-20 11:33:30', 'Arial 3.5 L40');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2FDDCC64-A344-4956-A713-5C4AF91C36DB}', 'global', '255', 'arrowpar', '2024-11-20 11:33:30', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{27DF790B-08EB-4394-AA82-98CFC889629C}', 'global', '255', 'arrowpar', '2024-11-20 11:33:30', 'Standard circle full');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0AC71781-472F-41D7-8A24-6BEBFBABE96D}', 'global', '255', 'arrowpar', '2024-11-20 11:33:30', 'Standard full');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2BC2FFD5-C3B1-4183-9080-3C2627A31795}', 'global', '255', 'reppar', '2024-11-20 11:33:30', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F4B42321-1707-4A80-9EDD-F6887655BF19}', 'global', '255', 'reppar', '2024-11-20 11:33:30', 'Concrete element');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{418ED439-58A4-4817-BC04-0003ED42665F}', 'global', '255', 'reppar', '2024-11-20 11:33:30', 'Wood');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{151349AE-5E8B-4697-A266-393E1449C03F}', 'global', '255', 'reppar', '2024-11-20 11:33:30', 'Surrounding area');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B3451239-CE76-4E25-9EDF-2CE343E939C4}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8B7E1998-B901-4401-B4BD-E577DD3CBF97}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Insulated concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FA0A47BE-AAFD-406F-B4B1-9E5C38052992}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Natural stone');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E65D6F03-4FEF-4E35-815B-0D3F30377F62}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Lightweight wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6D34445A-2664-4730-8221-C72CB1FE6DE4}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{72A2D68E-D2CA-4180-959B-30A5E06A1287}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Inner wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{493CA513-ECBE-450F-96B4-109574E2EA94}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Ventilated facade');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0B319147-D6EA-4592-8399-833B9FB6996A}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Exterior insulation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F41BDF95-17C5-431F-8193-D8958C0DC6CE}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Outer wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5559DFC2-C13F-4D66-8269-F75614C0A8AD}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Cavity wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{65DE82BB-FACE-406E-BD72-79D23DD2DB9A}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Timber frame');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2C55BE21-A6BC-43EC-BF7E-EAD0416B9DCB}', 'global', '255', 'wall', '2024-11-20 12:59:35', 'Parapet');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8ADBB8A3-F10B-4E51-9334-2F80373F87D9}', 'global', '255', 'layerlist', '2024-11-20 13:00:54', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{49AF0652-CAA6-46E2-86CB-85D9557E20CC}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Standard 3 Rows');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DAE0A76A-6EF0-456B-810E-B94025427FB8}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Standard 5 Rows');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{996B56A1-3CA7-4AC6-8234-6B133ECBC3C1}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Door Number');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{03016701-071C-46B1-AFB2-CA0628BDA719}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Number');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0ACC5641-2427-4D0D-A44D-E0020004C00E}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Room Label for Section');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3151F5AE-8B2B-4ECD-BD30-0FE4A9B06B0C}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Room Label for Section 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9039BCAA-9FD6-46A4-93D4-83B191C6E946}', 'global', '255', 'attrlabel', '2024-11-20 13:16:50', 'Window Number');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{65CE4258-7F69-46DD-9BE4-1103DB0F38AD}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 1.5 half');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5539CD72-D24C-479F-B107-40D3FB97C462}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.5 full');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3E96E1CC-E08A-4E2D-A9B1-76A4E957D4CD}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 1.5 empty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2E704126-E082-45CC-85A7-81537560462E}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 1.5 full');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E53321C3-9ACF-42B2-B5D9-82B39425B6B5}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.0 half');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{23CA2B6D-9595-4BC4-BFF7-BC4D9D3876BB}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.0 empty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2A8DC4CE-D5F3-4E68-8E55-9576C0E7E689}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.0 full');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E2B204E3-C36B-4252-AA4E-22E51BC98848}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.5 empty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{797FDB38-DE35-4305-9CC3-296078C0B597}', 'global', '255', 'ardimlevel', '2024-11-20 13:18:23', 'Arial 2.5 half');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2A9C18CE-F927-40AC-B257-4EDFA80196E8}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.5 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7A0B9500-B5A0-4840-96E8-CFAFC5BFD051}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.5 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{19FD2594-256E-4836-B9AB-9424A022B0D8}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.0 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E85FD44F-CE10-4D24-A04A-AD97793F5B88}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.0 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F15BEAC6-E386-4E22-93BC-BC5967FFC722}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.0 TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2C8309BA-F0AA-474B-B95C-C9B2FF9F2EEF}', 'global', '255', 'argroundlevel', '2024-11-20 13:21:06', 'Arial 2.5 TFS');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2AC0FD0B-AED3-459A-B4A3-CFCFB24BCCD5}', 'global', '255', 'floor', '2024-11-20 14:00:35', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{76616402-1F9B-4146-980A-D1538F87298B}', 'global', '255', 'floor', '2024-11-20 14:00:35', 'Foundation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{729490BE-CA69-4AD0-91FD-08D459B40D4E}', 'global', '255', 'floor', '2024-11-20 14:00:35', 'Wooden slab');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C97D2D36-B8DA-4DCB-A492-8EF1DB403A87}', 'global', '255', 'floor', '2024-11-20 14:00:35', 'Sloped slab');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{598FCBF5-25A8-4469-AFDB-28B65B3F0E51}', 'global', '255', 'flooropen', '2024-11-20 14:01:15', 'Slab opening');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{239E2229-E1C0-48BA-99C2-15CF3BD5D2DF}', 'global', '255', 'flooropen', '2024-11-20 14:01:15', 'Ceiling opening');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F47E0240-08E0-4889-9F94-84AA54EF61B6}', 'global', '255', 'flooropen', '2024-11-20 14:01:15', 'Floor_opening');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8E36777B-B267-4B82-A9B7-1A42FE15A222}', 'global', '255', 'column', '2024-11-20 14:01:32', 'Square');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3F7093BC-0DFA-4C6D-AAD9-1BD370C18AE0}', 'global', '255', 'column', '2024-11-20 14:01:32', 'Rectangular');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B6D79850-E198-422D-9227-2E77BCD2408A}', 'global', '255', 'column', '2024-11-20 14:01:32', 'Round');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{96871A39-1476-4AFE-94EA-E5829AF36D34}', 'global', '255', 'column', '2024-11-20 14:01:32', 'Free form');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{41296782-1C60-496D-B4DB-38882F1DAF94}', 'global', '255', 'grider', '2024-11-20 14:01:42', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C8C1AF3C-3BC7-4763-B3D1-48E9034BB6A0}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'Standard 3-layers');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{60C155EB-CCC2-469B-AF17-25213141A675}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'Sloped roof detailed');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{73324783-C93B-4564-8D80-BF4948F560AC}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'Attic floor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D6F3C07D-52DC-40CB-B298-CF78D972A017}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'Sloped roof raft under insulat');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7BA7600A-5813-4419-92CA-BCFDFA88077A}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'Steild Sparren unter Däm.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{64079FEB-729D-447A-B42E-748350AA350D}', 'global', '255', 'roof', '2024-11-20 14:01:47', 'height limit');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F64E981A-4A95-4BDA-9DB9-982409332D0A}', 'global', '255', 'dormer', '2024-11-20 14:02:02', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DA136AFF-049F-4D5F-B964-8DB396E5121C}', 'global', '255', 'roofopen', '2024-11-20 14:02:14', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{71E2A882-FB77-48E1-9DC6-FA25306ADDA3}', 'global', '255', 'roofstruct', '2024-11-20 14:02:27', 'Truss');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D2883B02-0C65-4882-8B79-866AC48A4BCF}', 'global', '255', 'roofstruct', '2024-11-20 14:02:27', 'Collar');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CCDD680A-BCB9-4A55-90A7-AF31719FCF2A}', 'global', '255', 'chimney', '2024-11-20 14:02:34', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{03850774-5BF3-469D-BADF-5006A424EE90}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Velux flat roof');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{929D96C2-E930-43B5-A956-02C51E3CFAA1}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Velux sloped roof');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{06EB3063-ABB7-4390-B8F9-34D7FEFC8121}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Standard casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{38D58B5B-C8EE-492A-B519-5DD4FF670C7E}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Standard stop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D34F9611-4D44-44DB-A00E-03B342E3C8F0}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Standard door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{38B93B21-2D1D-4615-AAA9-443F940900E5}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Sliding window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A46960D7-AB60-4196-910E-C62AF56D0ED6}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Double hung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5D1A8B5E-D0A1-4BB0-93BD-407A442155C8}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', '2-casement+handle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E2EDFA9A-7E61-4583-AA4D-5C85FC871056}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Robes');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{205475EA-F175-416A-9265-70AD837BC362}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', 'Insulation_Roller shutter');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3FC9070B-769C-4243-8FB0-62C44941D739}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', '1-casement+lintel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A2D2D17E-B8D1-478F-92F2-8EE4E625D1AF}', 'global', '255', 'wallwindow', '2024-11-20 14:02:41', '1-casement+handle');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{63799E9D-D9D6-4567-BFD0-FA3C90EEF40F}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Standard casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CE6650D3-3C30-47AB-B45D-CB15432D3171}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Standard stop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{499AA529-30B9-445A-858B-45292ABEB69A}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Standard door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A6ABADF4-CCF1-4ADC-88C1-9C2C4EF65CF2}', 'global', '255', 'roofwindow', '2024-11-20 14:02:41', 'Sliding window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FE2374A1-9DFD-4ED1-B534-61DA2C36EEC9}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', 'Double hung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C8891CA4-235A-407D-A087-F929AE648B4A}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', '2-casement+handle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D1122D78-E950-43FE-ADF3-33264D9AF418}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', 'Robes');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DBFF35CA-2D08-4C13-8CF5-EF81A523CDCD}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', 'Insulation_Roller shutter');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B33F367C-37BC-422E-9110-5C1E19ED7261}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', '1-casement+lintel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{02F778C0-0317-4DF3-93F7-2B38079FA86E}', 'global', '255', 'roofwindow', '2024-11-20 14:02:42', '1-casement+handle');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{035157EA-5657-4F66-9EA3-D93D0992808C}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Wooden jamb door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{EA879F6E-DB99-4EC4-8729-47661C47E2D2}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CFBE7B40-4206-456D-B21D-8BA65D08A2D3}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Sliding door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{95EEA31A-07DD-4271-969F-6ECCC47358A8}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Corner jamb door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CC8DF695-4FFA-459A-90F0-C7241ACF9E70}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Garage door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1D86E925-FE9A-4C2B-B5F2-72D4F8E54B0E}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'On wall frame');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{39EFB49B-1A52-475C-BC27-4FF3544DF3ED}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Embracing jamb door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A65CC629-54BB-4FDB-A161-19CD0487F065}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Passage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A2B4B633-CBD8-42B1-92E5-1C41B6190BF1}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5B001EAA-B195-4E91-9EA2-83D6D16204E6}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D38656AF-58C3-44C3-8045-2F35A75325D0}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E55B107C-5D2D-4F0B-9657-94F2FFDBE8A9}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door with 2 side panel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0C665DA2-5414-4BC6-A31B-F206FDBBCA3A}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door with side panel 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CF1CBB80-781F-4D05-8F52-D77B4DF560B1}', 'global', '255', 'walldoor', '2024-11-20 14:03:30', 'Entry door with side panel 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0C948242-7D3F-4ECC-B91D-A7CBC821ACE8}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Entry door with side panel 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{514CD883-ABFB-4704-84BA-E30FFC67C8C9}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Entry door with side panel 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9B064AE2-65B5-4AAF-8C61-C8D4B5BDFC31}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Industrie-Sektionaltor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B2B64B45-DCAE-4532-A62F-CA58FF4DFE72}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Inner door 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D3C20EC6-C213-4F2A-A506-00DA2F15D1A5}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Inner door 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BE40DA11-61E7-4E6F-A973-18AAF76EFCAD}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Inner door 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2DECB4DD-4023-4E3D-8C61-88C0F8C59616}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Laboratory door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CD12164D-2414-498F-BEDD-9F0430C68394}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Sectional door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1B5C80AD-1A62-4B19-896B-5CA875DDE797}', 'global', '255', 'walldoor', '2024-11-20 14:03:31', 'Sectional door with glass');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E6DE0428-1B48-4238-BDAB-6552CD207809}', 'global', '255', 'wallopen', '2024-11-20 14:03:59', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{73DA8529-D944-46A1-BEF1-99799C453B44}', 'global', '255', 'astairs', '2024-11-20 14:04:03', 'Stringer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{17F6F21F-C91C-42AA-93DB-224C8235DDC5}', 'global', '255', 'astairs', '2024-11-20 14:04:03', 'Concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9B464625-482C-423A-A09B-60FA9B5FE36B}', 'global', '255', 'astairs', '2024-11-20 14:04:03', 'Steel');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{15440B02-4FCE-4C02-94D3-7DDD58BD8132}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Rods typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4FE9C100-81C3-4ABA-9F22-C0174C216D0D}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Handrail');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0A1573ED-6A7B-4C97-809F-0DAC5A48F038}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Wood');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AF8CBDCC-75ED-4358-83C2-A3079242FAF3}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'All glass');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D957AE64-ACAE-4F24-82A0-6912298EB5F1}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Panels');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DEA35536-E6B9-40D4-AFC6-51F3F4FA922B}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Glass');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{790AAA3B-C545-42E0-B08C-59DC40B64139}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Wire rope typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CFBDF3FE-BC45-4B0F-8291-6DE4B86FD79B}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Wire rope typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DC84BE7E-869C-4CCD-9327-701D425A3907}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Rods typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DE4C3BC3-BD35-41B6-87D3-EEC7D6C78540}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Rods typ 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AAA8378C-E716-4824-8991-7BB0388AA48A}', 'global', '255', 'railing', '2024-11-20 14:04:11', 'Perforated plate');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1C1A577D-BE80-4695-9AB2-0A87B9FFA5DE}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Staircase');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6C62155D-777D-47A2-839B-4FA8D9BD0E2B}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Flat roof');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DE7F8469-32C2-41D4-9D45-EFB048525F53}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Terrace');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{47D5770A-1B6A-4240-BFD4-8F389F74C79E}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Cellar area');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0BA6EFEB-76C9-4343-B0E5-09CFA0370F22}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Living area');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8D1AE63A-0167-40EF-AF48-00C5A2EDF317}', 'global', '255', 'room', '2024-11-20 14:04:39', 'Wet area');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DDA46905-DD03-4398-BE8F-D95B4D144F72}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Screed');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D3638927-5EDF-4CF2-AF78-D900FBF05E97}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Single layer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{01C6F723-C225-4715-99F6-0B73F1FEB821}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Insulated');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{89A58EFC-5AFD-4DF6-83B1-55B7315C322B}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Flat roof paving');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CF2BE0DD-0C65-4D64-9456-CAD92ABF61A2}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Flat roof gravel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{58C28C4D-4114-4C18-AD60-E397113BB050}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Not insulated');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CB6CAE18-AEFD-4C9D-8C48-E507C7AF9515}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Staircase');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A694A599-00F1-4288-8270-4D920F4051AE}', 'global', '255', 'roomfloor', '2024-11-20 14:04:40', 'Gradient via point');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9A38606A-7BEC-4447-A3CA-FB41F23FF6B0}', 'global', '255', 'roomceiling', '2024-11-20 14:04:40', 'Room Ceiling');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{73540E95-B99B-4AAF-9740-C91DF5AA8D96}', 'global', '255', 'roomgroup', '2024-11-20 14:04:54', 'Sum of Rooms');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6971D781-D636-4A39-A3B0-FCDB84785AA9}', 'global', '255', 'roomgroup', '2024-11-20 14:04:54', 'Total');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{71D43CF7-84C3-4FC2-AFA5-25C3A4309DC5}', 'global', '255', 'roomgroup', '2024-11-20 14:04:54', 'Apartment');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{856E15E2-79B5-4FD6-8DF7-7D07A576ACF6}', 'global', '255', 'grid', '2024-11-20 14:51:14', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C30F22EC-FF40-4047-BFCE-F98307B15E96}', 'global', '255', 'grid', '2024-11-20 14:51:14', 'Standard variable');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D24677C3-4ECD-4E13-B95F-9FF5E96AA083}', 'global', '255', 'grid', '2024-11-20 14:51:14', 'Standard variable 2');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{662AB56E-BDA0-4916-AD4D-3E893FBC28B6}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'Standard_Flügel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{37D47626-2A87-489C-BEA2-6D09AEA6A548}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', '2-Flügel+Griff');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9A7205D1-AEC3-408F-A443-1796C52BA546}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'Standard_Anschlag');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DB18B674-F41E-4FD3-A5FB-CF448697C463}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'Gewände');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6874427E-F323-4EDB-BE6D-4B865C18EDF9}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'Schiebefenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DE7EAA15-0745-4653-9438-04606B8D0584}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'WDVS_Rolladen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B72A69B9-9B51-45D6-9FF1-4082F21AD0E9}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', 'Standard_Türe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ECB8E9F0-219D-41B4-8E4F-3C11EFBE317F}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', '1-Flügel+Sturz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A9275981-DF9A-468B-8E02-93DB9D595E3F}', 'global', '255', 'roofwindow', '2024-11-20 15:06:00', '1-Flügel+Griff');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4EA7D85F-224A-425D-B20E-8426D5A5C37B}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Aussendäm_Blende');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6FBAAB11-A4FF-44DC-A0AD-504DB6F10DF1}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Verkleidung_Rolladen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2FD63645-3287-46EE-A41F-C2D3584F246C}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Zweischalen_Blende');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B509E381-27BB-40F2-8AF7-6F3DF6AE3587}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Standard_Tür');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8CF59895-0708-46C6-AD20-F5B2C3E19EC7}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Sektionaltor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{11337378-F497-4F9F-9870-FCE210A0DB33}', 'global', '255', 'roofwindow', '2024-11-20 15:32:24', 'Sektionaltor_mit_Tür');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{17EC8B20-F630-4C75-BD69-6B8A6556DA3C}', 'global', '255', 'walldoor', '2024-11-20 15:32:56', 'Schiebetür');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{ACAD95A2-0315-470D-976B-B633E920EB8E}', 'global', '255', 'printpar', '2024-11-20 15:37:37', 'RAL_DGJ1050_130g');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FE4B7184-EDF3-4868-840C-4C903C22EF5C}', 'global', '255', 'printpar', '2024-11-20 15:37:37', 'Noir');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E4738405-7F19-4E41-BC01-E931B1F4AE71}', 'global', '255', 'printpar', '2024-11-20 15:37:37', 'Solid');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{39BD62B7-68AC-40C4-A253-F541BA3BBB91}', 'global', '255', 'printpar', '2024-11-20 15:37:37', 'Transformation/Canalisati');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3C25AA1B-0D0F-4EE3-B9B4-B9F9B8F8C16D}', 'global', '255', 'printpar', '2024-11-20 15:37:37', 'Réduire');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{90811279-9672-46DC-91A9-E78EFBF55426}', 'global', '255', 'hatchpar', '2024-11-20 15:37:42', 'Moellons_100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8D4BBE18-D161-4634-8D22-812EA93A31E5}', 'global', '255', 'hatchpar', '2024-11-20 15:37:42', 'Béton_100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{29910332-4D98-42BA-8DD9-C09F74B3D05B}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Plot ciment');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3D95896F-47EE-4828-BA63-E7C55C1990C8}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Fibres de bois parallèles');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E1774D7E-48D0-46A2-9E6B-71D8D198A64B}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Gravier_fin');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9887E189-A837-429E-B33E-75C062056AA6}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Terre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{03E0CF7C-77E8-4B15-9C99-D5F51BDC1081}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Plâtre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{97746171-E4F1-47C7-81A9-9259EF84F567}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Gravier_gros');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FD6E9FF0-F12F-4ECF-B6D3-21178EA1B4C4}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Préfabriqué');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B3579085-90CA-4DDB-9EBC-B4176BADD234}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Pierre_natur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E71A98F0-7A63-4EED-8A10-A46FE7677CBA}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Brique_élév_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{53D036AF-7B2C-4887-A635-D5CD190E8FBC}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Brique_élév_20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F3B6D001-8A99-44FB-B868-0A8E4ABF2FFD}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ondulé');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0037A5BF-5698-4280-BEC1-7A69C08CD059}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Tuiles_100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F5EC08B9-74B0-4570-A3B4-5A544FFF2254}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Tuiles_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2F385630-3736-4326-993B-95EAFA825345}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Brique');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{05441204-E9FF-4CC2-BD04-B30A6946E969}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'gris_clair');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9023B4BD-6C89-4028-9A22-7CEE248D019B}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'gris_foncé');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5EA89B2A-0AB9-41E4-B1DA-7D3EABB6A017}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Pointillé_2mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7C663435-EDBE-47A1-A770-A3A924252CBE}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'jaune');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7C867719-8059-437D-ADD3-489A7F66B742}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'noir');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B0032918-6BF0-45C6-9A07-DBF127C4CD3C}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Béton_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7D98AB0D-5497-43E4-BD23-64ADCEA7AB8F}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'rouge');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9A21D6E3-003D-44FA-AABC-0346B01A8CE6}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Pierre_simili');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3ED01569-3B40-4AF9-A90A-93951F67F97B}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{ED6B8EB4-EA0E-4428-9589-B094E586E499}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Fibres de bois transversa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1DDA1F1D-1457-42F6-A5E4-21E06A4AA126}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Toit_2d');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{76BDF9EB-090D-4E84-BD6B-6617C045E44D}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'bleu_clair');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{16F22AEA-FF50-437A-B85A-8C4A17A088B1}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Invisible');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{EFA7A953-E65B-4B07-AF23-C8789ABC94A8}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Béton_maigre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BCBED8F6-48D8-444C-BCF0-BEA6451AD172}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', '90°');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E852EFD5-921F-40E8-99FE-B3099F2DF030}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Tôle profilée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4111B829-D6A3-4DB5-BB2B-B4BB32385B43}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Plancher');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4EACEA36-179B-4A65-8540-E96D6BC39DAF}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ombre transparence');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{63119778-D64B-4D6F-A599-EE0734D6FF7A}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ombre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B61D909E-9942-4B9E-871B-9FFFE86EE75F}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Moellons_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{425215B5-7876-4F76-9F60-F221477C6585}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{AAC906FA-8F6A-4DAA-839D-2E5709D587CD}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'gris');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B2AB15EC-767B-4E79-81F3-133BC696D5D9}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Pointillé_4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{288E4A71-65D8-4BB8-9C4C-9E0881A12F1B}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Carrelage 60x30 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D26D1042-4CFA-4C0A-A30C-6FFC58F68C29}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Carrelage 60x30 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{26497DEB-125D-4A5D-B826-1727E4D9BB0F}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Nid d\'abeille 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{01FFD116-3B39-488B-8A68-498ACD751983}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Carrelage 60x30 déc 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A8BADCAF-52C3-4B0D-B942-BF65C7D283E6}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Carrelage 60x30 déc 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6A507CAE-DA17-4FC5-AD68-7BF38B060A61}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Nid d\'abeille 1:20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4DE940A5-5FBB-4040-BE36-D7577F127BF3}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Terre couleur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DE0F49B6-3D29-475D-8EEC-3DE6141F13B7}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ciel couleur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{85F03A67-2F0D-4F64-8EDB-1EFF2110B000}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Isolation_ligne');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0227E7E6-FA50-4E02-9BD2-1C5EC434B849}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Talus');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9569F401-CAEE-4AF9-83C6-E0B4376E0250}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Standard-3D_100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{470BF8D8-C8BD-4799-8736-25ED02A15027}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Standard-3D_50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A9A5EA97-2F5C-4717-9D3B-661B5E1592AB}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Brique s-c');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{605C2E2E-9AD6-4BC1-B002-D010BF4C1EFC}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Zéro');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CF7BE857-C961-4937-B35E-74F7CB4A99CF}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Isolation_dure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{18ACDE10-C49E-4935-97D4-3ECE4AFE08C5}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Isolation_souple');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{71B17346-B4A4-4432-8540-4A8D82B4DC92}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Isolation_ligne_dense');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5EA01DD9-2E29-47CB-A898-3028B762A0D0}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Excavation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D6A32A76-39C1-4246-B350-4EA84AF6707D}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Argile');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{087099BB-931F-42E0-A5FF-B3FDA9AEF1C0}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Produit-dérivé-bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{73F393ED-8BD1-4E55-A4A5-B726FACEF354}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Gravier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6EA9E5AE-DE42-446A-B326-D8AA5BB7C13A}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Croix');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7B602BFF-3B39-4F7D-862F-F7CA8DC0968E}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ligne_horizont. 0.4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3AD95E28-82D6-4197-BB36-1A16CB846FC2}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ligne_vert. 2mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{80909662-9B9E-4885-A91E-814ED7E9DC88}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ligne_vert. 4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{008E97AC-CD04-477B-9364-F9F5B36EB711}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Ligne_vert. 10mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{27037200-F16B-4F82-A957-AC52BC2FC88F}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Lé_d\'étanchéité');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{44D6BDA6-67EC-4993-96D1-BE1D3C4C1767}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Chape-ciment');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{C33F3FDC-7671-4207-86EC-4668E4840BC9}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'vert foncé');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3CB5A593-4BFE-4CB4-89AF-A3F2C714B43C}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Brique dense');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1439957B-354E-4698-9C19-A9A25DC7D413}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Terrassement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2F94C179-E387-42B9-A928-844BD7DEADD0}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Surface fenêtre bleu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7AD9DD8F-CA6C-4510-B2D8-8AD2046D2939}', 'global', '255', 'hatchpar', '2024-11-20 15:37:43', 'Surface fenêtre gris');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6F9B2EE9-E330-4B49-A323-A506CB19F43E}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_00');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CA519C92-9833-495D-A8E5-0BAE5B81A500}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E7635854-CF86-439B-B063-BBCC3F2F8D5C}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{922852D8-C34F-4D3F-A43A-E39C09EEFF63}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BFD79CCF-9AC2-44D3-82FD-F027754B9F75}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{13278367-66C4-4DD2-B05E-E881EC924CD9}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'conduite');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5EFC71A8-C132-4129-A9AD-34C2091D58EC}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BCD27901-511D-4DAB-948B-48B3452548A1}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_7.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{008C867C-DEE0-4C7E-835A-189DF619B029}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_7.0 avec Cadre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D5148A04-A225-48ED-B2A3-C077166109A2}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{961CBB84-0FCB-4D38-9C08-A248F51B1AF6}', 'global', '255', 'textpar', '2024-11-20 15:37:53', 'Arial_2.0 Justifié');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{78E16F22-298C-48A7-8898-ED92203184DA}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'Arial_2.0 Gras');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{929AF653-4063-4ECF-AB06-3AD57C7B7183}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'Arial_2.5 Justifié');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BF7CADC6-1884-41A8-83D6-18676EF95C76}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'Arial_2.5 Gras');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D8C2D9F6-6990-49D3-9986-375BD3988639}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'Arial_1.5 Justifié');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7067DB30-0747-43F5-BB46-53794AFD0C35}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'regard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0E943A3B-6F5E-49F5-BD7E-607C0136CC9F}', 'global', '255', 'textpar', '2024-11-20 15:37:54', 'terrain');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{ED945A2C-3CB3-4606-BDC4-CFF5A1C8C10F}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Coupe en hauteur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{EFCF3A8C-82AE-4BBB-A249-1B488ED88102}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 3.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D6A38E14-D675-4742-9CE9-D31543264D32}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 2.5 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8FAF0300-5294-42FD-8516-820F71346D84}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{92F850AD-9751-4ACD-BA06-65A33656208E}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{690A3675-93E5-4399-9DF1-B49A37F85D1E}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{AE3C4F09-7E62-48D5-BE22-C99DC06EABA4}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 3.0 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1C98271F-A085-4335-AAFF-0753560ABFBC}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 3.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DFCC0B45-3C3F-4737-B47E-B22C0024E52E}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Niveau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1A22430D-679D-40CD-B7FE-9FB65F0F1F31}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 3.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8DCEAE11-5265-452A-97B1-D9D5BBDA0844}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 2.5 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7B4245A2-3C14-4525-AB0D-640732AE54A8}', 'global', '255', 'dimpar', '2024-11-20 15:37:54', 'Arial 3.0 L30');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{995B11A3-0A2E-4E6D-921A-7CD0B52B933B}', 'global', '255', 'arrowpar', '2024-11-20 15:37:54', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{76FA4D4A-C570-4F2B-9A90-F0523381C05B}', 'global', '255', 'arrowpar', '2024-11-20 15:37:54', 'Standard cercle plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{154A14EE-067E-4D51-B07D-F3111147FAFE}', 'global', '255', 'arrowpar', '2024-11-20 15:37:54', 'Standard plein');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6F7FD776-DA9E-457C-AE3A-ABED45BF5F96}', 'global', '255', 'reppar', '2024-11-20 15:37:54', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3958208C-87D5-4566-96DD-594CC73AEB9A}', 'global', '255', 'reppar', '2024-11-20 15:37:54', 'Béton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{33E41458-637B-45B3-B8A2-34CDA68419E0}', 'global', '255', 'reppar', '2024-11-20 15:37:54', 'Bois de construction');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0735467B-0634-4DFF-B6F3-DE3225D40066}', 'global', '255', 'reppar', '2024-11-20 15:37:54', 'Bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9BFBB2D6-2E61-44D0-8981-7CDDF79E6A49}', 'global', '255', 'reppar', '2024-11-20 15:37:54', 'Terrain');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3BDADC65-720C-4229-9C50-E13F52AE1D1B}', 'global', '255', 'layerlist', '2024-11-20 15:41:50', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{27ED1A2A-60E6-4EAE-93BB-838B951CA334}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Parapet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{97D2F2B4-CF7C-4EDA-B1A7-36282B6BE817}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Biais');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A3BA6F9F-0362-46E7-B134-0CAF37556EAC}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Périphérique');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{40579992-2EE4-4697-A7C9-94081372FA52}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Double-mur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6DE1B7E7-AB58-491A-8EC8-9AB3A1733E9A}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Brique s-c');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{43EA464D-C1E3-4516-A195-6E651C59C9AA}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Paroi-extérieure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7B051A76-9291-4B3D-93A0-749DD7F2EBB3}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Béton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2ED3BACA-6F2D-467C-A111-DDC25E9220B7}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Paroi-intérieure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BF115C71-4A56-49CB-870A-4E1F1760C29D}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Cloison-légère');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D5950B2D-54C2-4379-8009-613EBFBB5295}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Brique t-c');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9636970F-162E-45FA-B1CF-100614D39374}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Revêtement extérieur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{40791695-7EF8-41B9-AD97-E8470F0E5172}', 'global', '255', 'wall', '2024-11-20 15:59:07', 'Cloison-montants-bois');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FAD7C0A4-44CA-4156-9836-FB2AC2311295}', 'global', '255', 'floor', '2024-11-20 15:59:51', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A3CAEEE6-BEA3-4EE5-AA19-A224155A58E1}', 'global', '255', 'floor', '2024-11-20 15:59:51', 'Dalle en biais');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{855CC196-CC9F-4750-A10A-8F78D5D2DDDB}', 'global', '255', 'floor', '2024-11-20 15:59:51', 'Plancher en bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{94C4FF8C-35E3-4199-9CE9-C6C41FD9336B}', 'global', '255', 'floor', '2024-11-20 15:59:51', 'Fondation');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E8B0731E-7C91-4562-B95B-C4AAE37F499A}', 'global', '255', 'flooropen', '2024-11-20 16:01:55', 'Percement de sol');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BC8AFCEC-7A67-4B66-A9B4-E9DB8CD686AE}', 'global', '255', 'flooropen', '2024-11-20 16:01:55', 'Gaine dans dalle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6D5D97A7-E29F-47B8-8713-ECC779E3D624}', 'global', '255', 'flooropen', '2024-11-20 16:01:55', 'Percement de dalle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{62B05AF1-0A58-4FD3-AA9F-61E6FFA03AA6}', 'global', '255', 'flooropen', '2024-11-20 16:01:55', 'Gaine dans plafond');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F343489C-12C9-42DC-8C0E-FF59163A498B}', 'global', '255', 'column', '2024-11-20 16:02:06', 'Forme libre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{233933C7-3CEF-44D1-AAAA-A1C1C2E13D43}', 'global', '255', 'column', '2024-11-20 16:02:06', 'Carré');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BA0743F5-78A4-45CB-8481-5846F4A4E74B}', 'global', '255', 'column', '2024-11-20 16:02:06', 'Rectangle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{EF96EB88-BCA4-4A93-8DCF-675B8AA68C90}', 'global', '255', 'column', '2024-11-20 16:02:06', 'Rond');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{EF061225-0663-4C93-95E4-9C19E53057AF}', 'global', '255', 'grider', '2024-11-20 16:02:17', 'Béton');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A8244ACF-F095-4DC7-A510-4FA561ECF304}', 'global', '255', 'roof', '2024-11-20 16:02:24', 'Toit en pente-3 couches');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{80946A4D-9A65-4B70-9AFD-FCE4D5444ED9}', 'global', '255', 'roof', '2024-11-20 16:02:24', 'Toit en pente-détaillé');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{70647CC3-FF1E-44B3-819B-7A3E177D60C2}', 'global', '255', 'dormer', '2024-11-20 16:02:32', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{10CC07A7-5E39-4C34-A260-22299C43B7A6}', 'global', '255', 'roofopen', '2024-11-20 16:02:40', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2FAAC8EB-B8B4-4FAD-ADBA-1CC4022FF17E}', 'global', '255', 'roofstruct', '2024-11-20 16:02:49', 'Charpente');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0628DC4D-5BC4-4A68-963A-5AFCAEB0BCA5}', 'global', '255', 'roofstruct', '2024-11-20 16:02:49', 'Poutre');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1035BABD-E6FB-4050-8703-270851B781AA}', 'global', '255', 'chimney', '2024-11-20 16:02:55', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{64CE5135-CF1F-4FAB-A1ED-412B9CDA2078}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Velux Fenêtres de toit');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{74C7A5BE-2703-4F6E-AE87-9B38E64A4877}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Velux Fenêtres pour toit plat');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{49B9BDCE-186A-4504-8B49-2FCF987ED81C}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Standard+feuillure+volet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5C42430A-120D-4749-A13B-2952ADE555EA}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Standard+feuillure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8BDEF754-BE3E-4C7E-AE7D-A6130CE07A3D}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Standard+volet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{310D0B3A-F49A-425F-BE50-FEAFDABA3809}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Périphérique+store');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{C09BEA8E-9BEB-4749-82CB-780FA59E7EDB}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Coulissante');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{74CD7CFB-2EC6-4531-AB25-DB7BD5147B88}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{522BAACB-6D6C-4CE3-8302-CED2BB6C34ED}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Pierre de taille');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{77E49C17-A32E-4335-9C65-531461A9E288}', 'global', '255', 'wallwindow', '2024-11-20 16:03:07', 'Double-mure+store');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3BC62B18-02D4-4D95-8E7E-9076E1016402}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Standard+feuillure+volet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{71531091-1730-4849-8BCA-2A4EEFDB0364}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Standard+feuillure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4E33FAEC-21B9-475F-8576-0707F9232478}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Standard+volet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7B6E41DA-F5C6-4794-AF36-9C6B8D6B47C4}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Périphérique+store');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{97AC50ED-F6E4-4875-A881-C34BF5E04748}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Coulissante');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9A5DB782-1454-4F26-B19C-855620ADF10D}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8BC70E69-2D24-4EA4-A453-3227F003DDE2}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Pierre de taille');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{80B641E5-DE93-457F-BE8F-924341520564}', 'global', '255', 'roofwindow', '2024-11-20 16:03:07', 'Double-mure+store');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{27A5EA9E-38D7-42D1-A055-C9E84CE29BD1}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Coulissant');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{531B5C57-D071-422C-82F0-2A77E52968B8}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Port de garage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{AC17EB02-056F-4748-BCFF-48E8713AD5D7}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{31F775CD-4188-4A9C-A91C-299CC4F2EF91}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Extérieur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F05C7DF0-485D-4A7D-ACBA-80CB8835E425}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Cadre embrasure');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A4D21084-0ED0-47D1-AC84-E18ADE38954B}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Huisserie-acier 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4DB651E5-A0F0-4C73-839D-D766B3689266}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Huisserie-acier 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9FDE70A5-C596-4880-96D9-AB349422BA44}', 'global', '255', 'walldoor', '2024-11-20 16:03:46', 'Cadre en applique');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E2AFF567-695D-46C8-A053-C26436558C3E}', 'global', '255', 'wallopen', '2024-11-20 16:04:05', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6C05E9FB-0C94-4394-AFFC-19A86EFEB053}', 'global', '255', 'astairs', '2024-11-20 16:04:09', 'Limon');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3DB50436-AEB5-4FE3-9C3D-F31D213DCB40}', 'global', '255', 'astairs', '2024-11-20 16:04:09', 'Béton');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1B6F8E63-61AD-4476-8394-2F849F1FBC22}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{052DAAB4-F4D7-438B-A0BC-D618796A5ACB}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Câble d\'acier 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B172CB58-2FEE-47D8-BEBE-FAACD1375373}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Câble d\'acier 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{06C3A153-CB69-41C9-AD1E-3054F11C0918}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Balustrade vitrée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F7315607-2454-4FD5-9C85-71608E6B9459}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Vitres');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{71804627-2DEC-44BF-9ACD-A3519A099E1C}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Tôle perforée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D42237F7-FE9E-4578-AB72-06AED4681064}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Panneaux');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6197B15B-F000-4340-A059-9FF3560369B2}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Montants 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CE17501F-7C77-4104-931B-D6EFF9CD0840}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Montants 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FEF8187D-DA05-4F13-A32C-A21F7CC3E193}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Montants 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6F9F4696-21AB-4019-BC93-FF0F6EE8CC7E}', 'global', '255', 'railing', '2024-11-20 16:04:15', 'Main courante');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3E91402E-9F0F-4DA2-8B52-6505CC035EB3}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Espace habitable');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{91A8996C-6F0D-4CD5-A197-F4CE31534480}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Cave');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9DD088FB-C76A-4EAA-8806-9D938161E205}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Salle d\'eau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{C1FB807C-43E7-44D7-A6B0-3D5E73EF423F}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Cage d\'escalier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2CE0EC0F-50DC-4C7E-A2DD-46675F1EC92B}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Toit plat');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3BDF9D27-6AD0-4708-A3C9-A6754227A148}', 'global', '255', 'room', '2024-11-20 16:04:22', 'Terrasse');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BB9A65B5-D96A-4E36-9953-F1382CAE8876}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Toit plat gravier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0656B182-5DE7-44B1-B399-115B3B3C104E}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Non isolé');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6A316BAF-1153-4FB2-9BA8-E01B33A1C56F}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Chape ciment');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{29374934-7DF5-40D2-85D5-3C80FF403682}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Toit plat dallage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{C529B568-CC3C-41AB-B687-24364E96BACF}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Isolé');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{23923C61-90DD-4365-BD72-8F7941A671E9}', 'global', '255', 'roomfloor', '2024-11-20 16:04:23', 'Mono-couche');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{842A9D54-8B29-4DC6-BC2D-A3E3F4175DE4}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 1.5 Vide');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{849B38A6-BCA4-4623-8C05-7DD86FA4BF00}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 1.5 Plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E09B1EAF-3611-4CAB-9EC7-F3EC4FA4D079}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 1.5 Demi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{17EB6B4D-4281-4BA9-B216-9FE69C96A22D}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.0 Demi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{17A52232-3F2F-4658-94DB-E6295225BF9A}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.0 Plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3FFA0623-CF2E-4218-9431-D99BA39E422F}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.0 Vide');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2F6F2AA0-92B0-41DC-B83C-345F61C3B33F}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.5 Demi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8D9FDFB4-1667-4697-B2EA-0157E8D73E05}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.5 Plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{203F241E-9AE7-4CD8-9D44-270177BF826B}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 2.5 Vide');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{48950FBB-5F61-4ACD-8A8F-A5415B6114FA}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.0 Demi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{6B53C89E-94CD-4587-A364-D4838C39FD9E}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.0 Plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E9AD8891-D1B0-4F5A-89DD-B431409B141F}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.0 Vide');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{ADC967FB-645C-43C4-9BAD-83BA3C82781A}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.5 Demi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{90F7B9AB-6E55-41BE-8A48-FBB8E71A3AEE}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.5 Plein');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{2D709948-4C8E-4912-AD9D-2696BD96B96C}', 'global', '255', 'ardimlevel', '2024-11-20 16:04:28', 'Arial 3.5 Vide');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B9B6A75A-99F3-4071-8B5C-E40737C0EF18}', 'global', '255', 'argroundlevel', '2024-11-20 16:04:32', 'Arial 2.5 Fini');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3474D632-5023-4327-A387-349E58FC9448}', 'global', '255', 'argroundlevel', '2024-11-20 16:04:32', 'Arial 2.5 Brut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{08D8C27C-0101-4029-820B-7407F78C2CB1}', 'global', '255', 'argroundlevel', '2024-11-20 16:04:32', 'Arial 2.5 Fini / Brut');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F2CB3E56-9E98-4AA9-9281-119B48228646}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Beton+WDVS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{13950AC7-4C90-40AE-B0FB-2121AF8B7BB4}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Beton+vorgeh.Fassade');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{58DB0DD7-5FE7-4AC6-9385-2A0D2A08D270}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Brüstung 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6C188B8B-F8B3-44CD-AA03-624E77EFFA44}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Trockenbau');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6F22F89F-3EB9-4EB7-8F2E-3A3C5E3AAA2C}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Wand Brüstung Balkon');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D075FF7E-B642-41C6-95B2-8B86D508ACD8}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Wand Holz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{20E2EC5D-2CB7-4628-9FA3-BD088EF62AF8}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Wand Putz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9F95B3BA-C9EE-4920-9A9A-D69E9DB523F6}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Wand_Attika');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D46E14C8-53B7-47D5-9C38-75B1407B4093}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'CK_Wand_Brüstung Terrasse');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{22338E25-1107-4DB6-A2D6-864666564546}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Holzinnenwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F41E7A06-155C-45B9-A1D5-29FA88AA7A6F}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Massivholzwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4A00F87F-0420-4CD2-A553-BCAFC41B60D1}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Trockenbauwand');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EB8AEC65-9AF3-4A7C-AF01-6B32725ACA78}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Ziegel+WDVS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D76CFBC5-4CE1-4656-9594-62C74A417FCE}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Ziegel+WDVS-Brüstung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6993EB6E-C4EA-4E1C-8AF1-5B4AF387EB44}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Ziegel+ZwDä+Ziegel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{378D5245-3DE6-45B0-882C-177320356EC6}', 'global', '255', 'wall', '2024-12-18 09:28:22', 'Ziegel+vorgeh.Fassade');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{007AFE5E-C665-49ED-9362-FE671519F194}', 'global', '255', 'wall', '2024-12-18 09:55:25', 'Ziegel+Vormauerung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A18B9EA5-8933-4FCB-BCD8-C148EBA29E81}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Einzelfundament');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{64D77856-0397-42FE-A818-3783A6CC4A90}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Gefälledecke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{481797D3-5A4F-4E62-AC6A-1491F937CDD4}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Massivholzdecke');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{527C5F43-0AD9-4913-AAA4-2F8493A6F6BE}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Plattenfundament');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{56B77BEF-D8F4-4426-8789-5DBF6B711DEC}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Streifenfundament');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BC67C21E-3B3F-47D3-837F-CF2ECC04CBFA}', 'global', '255', 'floor', '2024-12-18 09:33:35', 'Ziegeldecke');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2C19E7DF-BC79-405D-9CA9-8356E99AA7FD}', 'global', '255', 'column', '2024-12-18 09:35:24', 'Stahl');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{63BB01EE-97A3-430C-8EBB-A3AFC255F5B5}', 'global', '255', 'grider', '2024-12-18 09:35:40', 'Betonträger');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EEF02292-626B-46EB-868E-882E61309B5D}', 'global', '255', 'grider', '2024-12-18 09:35:40', 'Stahlträger');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2A24CA69-0A6E-4623-82B5-16301463BD9B}', 'global', '255', 'grider', '2024-12-18 09:35:40', 'Ziegelträger');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{384C128B-7598-49FA-B1CA-745674B12399}', 'global', '255', 'roof', '2024-12-18 09:36:12', 'Steild. Sparrenunterdämmung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{05FF6021-E013-4984-8D81-6462DBCB30B5}', 'global', '255', 'roof', '2024-12-18 09:36:12', 'Steild. Zwischensparrendämmung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BE1ED558-C014-42A2-A10A-FCC4FE9691C8}', 'global', '255', 'roofopen', '2024-12-18 09:36:46', 'Dachdurchbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6AE6F4E2-CF83-42CA-9E1E-62096268AE6B}', 'global', '255', 'roofopen', '2024-12-18 09:36:46', 'Dachschlitz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2DA19E77-E50A-400D-929E-077469F2409D}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Firstpfette');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5E886BCD-DA4E-4751-B68E-9EBC96D0FBD5}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Fusspfette');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{554C4675-3339-4734-957F-9CA6C871B17B}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Gratsparren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E66CAC4C-3A98-4BD8-807B-C3B64C8C317C}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Kehlsparren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8E304E11-30EA-4810-964A-82A6F1F56140}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Kopfbänder');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{757218F3-0DEF-42D6-965C-888C58364633}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Mittelpfette');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0EA1EC36-B2B8-40E2-BE31-2B75A338876E}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Pfosten');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D65823E6-10D7-4568-AFB5-984FAF1B77D1}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Sparren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F12B4A51-7E9E-4C86-9485-EF19EC50C7F1}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Sparrenwechsel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A2AD1FBE-6C51-4077-A257-2D4483E09497}', 'global', '255', 'roofstruct', '2024-12-18 09:37:07', 'Zangen');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CCE6D2DA-4E92-4E8C-B77E-E3AD5261547B}', 'global', '255', 'chimney', '2024-12-18 09:38:16', 'Fertigteil');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9CC7A61E-2782-4A2D-BD84-CBA53401514B}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Eckfenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{555801F1-710A-4933-BD1A-2863A66847BC}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Fassadenelement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B28BDD15-352D-40FA-854E-5DFB9F5F869F}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Fenster 1 Flügel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4AAA97E1-2595-423C-ADF6-D3EE65398E94}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Fenster 1 Flügel +Kämpfer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D958D7CC-8944-443C-A59C-73273FECE1FE}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Fenster 2 flügelig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EF28DA92-DE9D-4ECB-B9BE-3831A88BC24A}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'CK_Glaselement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9CB4FE75-FFCA-49E7-8786-1FC4A8193345}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'Eckfenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8CC3E24F-1B89-4456-9541-8610CBE1831B}', 'global', '255', 'wallwindow', '2024-12-18 09:38:37', 'Fenster+Rollladen');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{99081349-B2E6-4E21-811D-D3DB66730E84}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Eckfenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EFC085FE-7CFC-48BA-946F-248846339919}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Fassadenelement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E3E4AC17-C6B9-492C-88CC-9A9B44CC88C4}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Fenster 1 Flügel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FD35A630-C5EA-40D0-A930-E00C80E9DA6C}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Fenster 1 Flügel +Kämpfer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{48E59CDA-B670-4C0F-8786-2CCF26B01744}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Fenster 2 flügelig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3E273AAB-FFB8-483B-8AFF-17CC7301E877}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'CK_Glaselement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{456E48D9-6080-4457-94F3-5A02D67F1327}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'Eckfenster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{014200CE-FD74-4EB4-8D6F-D5DABDB15B6E}', 'global', '255', 'roofwindow', '2024-12-18 09:38:37', 'Fenster+Rollladen');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{1A3CE95B-6720-4510-82B0-66147F833837}', 'global', '255', 'walldoor', '2024-12-18 09:41:33', 'CK_Eingangstür');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A8E7630C-7950-45CE-BB90-B6DA5626A1CF}', 'global', '255', 'walldoor', '2024-12-18 09:41:33', 'CK_Lagertüre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{85096477-C05F-4E07-B651-4742E590EBDF}', 'global', '255', 'walldoor', '2024-12-18 09:41:33', 'Rahmenzarge');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A11BA98E-90A5-43D8-96BF-C2A0FB3C2C1B}', 'global', '255', 'wallopen', '2024-12-18 09:46:24', 'Wanddurchbruch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{687DE8AB-E704-4E25-AF13-4972D85B9863}', 'global', '255', 'wallopen', '2024-12-18 09:46:24', 'Wandschlitz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{80B67181-52E6-434C-BEAF-B50469E5AB19}', 'global', '255', 'astairs', '2024-12-18 09:46:38', 'CK_Treppe');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C1962535-FA25-48FC-BED5-C3A2C26B45B7}', 'global', '255', 'railing', '2024-12-18 09:47:01', 'CK_Balkongeländer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8E1DB5F4-2BE9-45E2-8528-589985B9E485}', 'global', '255', 'railing', '2024-12-18 09:47:01', 'CK_Terrassengeländer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A35B6DCA-C0A9-4022-8F42-415C82209C24}', 'global', '255', 'railing', '2024-12-18 09:47:01', 'Ganzglas1');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DFCB9D11-4B35-4B2B-9EC6-4AD6F626BD72}', 'global', '255', 'roomfloor', '2024-12-18 09:48:35', 'ohne Bodenaufbau');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{535D33AD-249B-487C-8BA2-932EAE128E41}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Lightweight wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{15527AFD-729E-43B6-B0CA-A788B5FFDAC2}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Parapet 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A1602472-A5CB-4F64-91A2-19E2185F061C}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Wall attica');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AD041974-6057-41EB-9715-828B7CAE6E90}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Wall parapet balcony');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{05C8926A-3C02-46F2-852B-10AEBA16D342}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Wall plaster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{30827F57-2F73-491D-9870-0AF2987E714B}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Wall wood');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7F43233E-C9B8-4D78-98EA-0DE0EEF44EC2}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'CC_Wall_Parapet terrace');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BB768A63-9E65-43EA-AF29-D5E973EF51D0}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'Insulated brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9CBE91F2-18E0-41A2-8BDE-64832DF228A1}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'Slab edge');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9D595041-1FCD-4228-BDDE-0F0B916C329D}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'Solid wood wall');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B27594A1-DBB8-4F17-BD8E-ECD60124C69A}', 'global', '255', 'wall', '2025-01-20 13:50:02', 'Wooden interior wall');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CE5DA09C-9077-4590-8272-59CB244660B4}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Brick slab');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CFBF0DD2-AEED-4EEB-9973-18D18AA48435}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Floor slab');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F5C660C6-72AE-40B9-96D4-541CD16E1A22}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Foundation Slab');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2BA2260D-D756-4697-A3FE-D3ED872B1F9F}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Foundation block');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CA444DDE-8C49-4855-B323-80E6A12EDD07}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Solid wood slab');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4EE71B56-0612-4242-997E-8DA26827F0CF}', 'global', '255', 'floor', '2025-01-20 13:53:48', 'Strip foundation');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{208737B9-F91C-4C1C-8562-14AE6EDC1A64}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_1-casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D30294F5-4F1A-45DD-85AD-A1C3F7A61827}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_1-casement+division');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{662497E9-9058-4BAF-96BC-3A06D2610408}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_2-casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FE0BF215-E4D7-4ED0-AB26-E75C67D9E54C}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_Corner window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{55E50961-9CA9-478A-AAA6-24EA380F9AF9}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_Facade element');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C6FD7CF5-5863-4700-A5FD-F96632FEE529}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'CC_Glasselement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{86D47275-9948-4E36-9B6F-73ECEC836D18}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'Corner window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7EFFE10D-58D4-40B8-9D1B-387CD9775A68}', 'global', '255', 'wallwindow', '2025-01-20 13:56:48', 'Window+Roller shutter');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DDAF932F-48E3-405C-B720-9DD78B3AF972}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_1-casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3E072F43-39B1-4F44-9088-904035E7DBF4}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_1-casement+division');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B0F0FEB6-CFC8-45F3-A96E-3BC4010A8D82}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_2-casement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C668748D-C0C6-4FB9-A345-C7FC5ACCEE3F}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_Corner window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E15B63B2-6906-4BB0-909A-AEE80DE89FE9}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_Facade element');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F01E9BF4-9049-41D0-91AC-9993CCDB5245}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'CC_Glasselement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{609D779F-3DD9-4DAE-B95B-38CDE6688E28}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'Corner window');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0B2A551D-56FA-4DE3-9D93-027248FB86C2}', 'global', '255', 'roofwindow', '2025-01-20 13:56:48', 'Window+Roller shutter');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{24D7E9E0-2656-4CAD-BA5F-28D4A5CDAC9C}', 'global', '255', 'walldoor', '2025-01-20 13:59:37', 'CC_Entry door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{56A34375-4608-449B-AC66-509E8C30A148}', 'global', '255', 'walldoor', '2025-01-20 13:59:37', 'CC_Storage door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{01878905-20E0-433F-8F43-FB48F10F84BF}', 'global', '255', 'walldoor', '2025-01-20 13:59:37', 'Industry sectional door');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4FC4FB48-A07F-4723-BD94-D73322832BE2}', 'global', '255', 'walldoor', '2025-01-20 13:59:37', 'Plastics door jamb');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A733AFED-DE99-4B40-ACA8-74748D6AF1B0}', 'global', '255', 'astairs', '2025-01-20 14:02:50', 'CC_Stair');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{948311CE-B781-42A7-806B-229235867AD2}', 'global', '255', 'railing', '2025-01-20 14:03:17', 'All glass1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5D408C76-4339-4363-B8F6-C17222DDA147}', 'global', '255', 'railing', '2025-01-20 14:03:17', 'CC_Balcony railing');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{73736E35-DF9B-45D3-9E76-ECDEFB72D699}', 'global', '255', 'railing', '2025-01-20 14:03:17', 'CC_Terrace railing');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{46BD2260-897C-4225-8631-6CC502A5211D}', 'global', '255', 'flooropen', '2025-01-20 14:03:59', 'Ceiling slot');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D703AAB9-1A93-4FBD-9029-5DFE2817FA12}', 'global', '255', 'flooropen', '2025-01-20 14:03:59', 'Slab slot');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{07C6B602-F3EC-43C4-806C-9E6370A9CDFA}', 'global', '255', 'column', '2025-01-20 14:04:01', 'Brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AD125137-7A84-4BE1-B445-8DCF88086AF3}', 'global', '255', 'column', '2025-01-20 14:04:01', 'Concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{41B3466E-7470-45BC-9D01-EE9D654F0551}', 'global', '255', 'column', '2025-01-20 14:04:01', 'Steel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2D4F8309-08E9-46DF-AAB8-699329ACA290}', 'global', '255', 'column', '2025-01-20 14:04:01', 'Wood');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8CA9B885-9334-4373-B24F-52E851B5EB33}', 'global', '255', 'grider', '2025-01-20 14:04:04', 'Brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0D9C15CC-91A1-4848-8CB0-2DF78B0573E4}', 'global', '255', 'grider', '2025-01-20 14:04:04', 'Concrete');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{23ACEB86-1570-4946-95F9-83D948A99991}', 'global', '255', 'grider', '2025-01-20 14:04:04', 'Steel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{ADD85C95-DE20-4112-98D7-C72248442849}', 'global', '255', 'grider', '2025-01-20 14:04:04', 'Wood');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B38F1EE3-8E19-4F41-AC27-080DCC0A9ACC}', 'global', '255', 'roof', '2025-01-20 14:04:09', 'Pitched roof between-rafter insulation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CBE559E9-210C-4073-9BCA-C962D851722A}', 'global', '255', 'roof', '2025-01-20 14:04:09', 'Pitched roof under-rafter insulation');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0511EA7B-E5B8-48B8-8A5D-EC42E13BA49B}', 'global', '255', 'dormer', '2025-01-20 14:04:12', 'Standard Gable dormer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FDA99439-148A-4AEF-BA68-B925F0D8075B}', 'global', '255', 'dormer', '2025-01-20 14:04:12', 'Standard Shed dormer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CF6C284B-E1A6-4DD9-AAB1-C793CA82E8F3}', 'global', '255', 'dormer', '2025-01-20 14:04:12', 'Standard Spiry dormer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{67BD6297-6ABE-4CA7-A7F0-B6FCF08122F7}', 'global', '255', 'dormer', '2025-01-20 14:04:12', 'Standard Trapezial dormer');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{369D64FD-B69F-4B86-80F0-236AAE882904}', 'global', '255', 'roofopen', '2025-01-20 14:04:18', 'Roof opening');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D2974B0B-51D1-4D5A-8197-D5498F4F92AD}', 'global', '255', 'roofopen', '2025-01-20 14:04:18', 'Roof slot');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0210E104-3460-4E93-A762-1C4C09DB02A5}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Beam');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D3A7568D-A98F-475A-A46D-222373D791C0}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Brace');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7F215056-4571-434D-AD18-6F764830D80C}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Center purlin');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6A0135FF-C2BE-41C8-9A83-23C8AFD08D39}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Foot purlin');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{334698F8-8BCD-4FAE-B7E2-6482BB2E626C}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Hip rafter');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{89692B90-CD4C-491A-A8F8-C399B88E010C}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Post');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4A18C32C-DAAC-49FF-AD8C-E2581C50154A}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Rafters');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DD952539-FE45-4FCC-8B5F-3CA57A447EA2}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Ridge purlin');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{43AE7EDB-CB23-486C-AC55-3EFD09B5ABA0}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Trimmer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B34D56ED-BA6B-44EA-A9F3-3BF63B6E84DE}', 'global', '255', 'roofstruct', '2025-01-20 14:04:24', 'Valley rafter');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{49B9D225-DB15-4F4B-97E0-10C14843340B}', 'global', '255', 'chimney', '2025-01-20 14:04:29', 'Brick');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{07D2ED67-13D9-4DE1-9956-EA4217A4FE1E}', 'global', '255', 'chimney', '2025-01-20 14:04:29', 'Concrete');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4C0EE989-7B14-468E-93C1-0B7489EE4F78}', 'global', '255', 'wallopen', '2025-01-20 14:04:41', 'Wall slot');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AF082BE4-97AD-4349-9772-60B8FCFEDAF5}', 'global', '255', 'wallopen', '2025-01-20 14:04:41', 'Wall through hole');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{EE93E09B-D042-4103-86A9-26554A16E06B}', 'global', '255', 'roomfloor', '2025-01-20 14:05:18', 'Flat roof slope');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F94965C6-6DC5-412E-AF1A-014E3E32449B}', 'global', '255', 'roomfloor', '2025-01-20 14:05:18', 'without floor construction');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DC30BC2D-CE9D-49CE-AF66-625092E2FACB}', 'global', '255', 'roomparam', '2025-01-20 14:05:39', 'Construction project');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{64D6CBA2-E34A-4E63-9B30-69A0AA912B91}', 'global', '255', 'roomparam', '2025-01-20 14:05:39', 'Working drawing');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7D0EF05F-89EC-47B1-A988-780E18D3FAA8}', 'global', '255', 'hatchpar', '2025-01-30 11:41:51', 'Kork');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A601F6DC-86B7-4F66-944C-5F1EC2D0DE2C}', 'global', '255', 'roofstruct', '2025-02-03 07:28:33', 'Wechsel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{FD79137E-C7ED-448C-83D3-44AC109F9111}', 'global', '255', 'roofstruct', '2025-02-03 07:28:58', 'Balkenlage');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DFBB4EE1-0344-46F8-895E-67B31F749552}', 'global', '255', 'attrlabel', '2025-02-03 08:19:26', 'Schichtaufbau mit Überschrift 2,5 EPD');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{50594A8E-40C3-4F87-95E3-8245560DABD9}', 'global', '255', 'bs_sewer', '2025-02-03 12:15:05', 'Kontrollschacht');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4109CCED-92F4-43DC-8FFB-4ADAF1351973}', 'global', '255', 'bs_sewer', '2025-02-03 12:15:39', 'Abscheider');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BAE6096B-812C-4231-80EF-028D3528E618}', 'global', '255', 'bs_sewer', '2025-02-03 12:16:21', 'Schlammsammler');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CF680809-7BE0-4DA0-B120-D73C1050C475}', 'global', '255', 'bs_sewer', '2025-02-03 12:16:32', 'Sickerschacht');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4052BBB7-3F84-4FB8-82F2-911FA303A28A}', 'global', '255', 'bs_line', '2025-02-03 12:16:56', 'Schmutzwasser');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3BE8C638-D68B-4371-9B35-F3E89A31584C}', 'global', '255', 'bs_line', '2025-02-03 12:17:12', 'Mischwasser');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{01C53B96-3039-4F3D-8869-907102196054}', 'global', '255', 'bs_line', '2025-02-03 12:17:21', 'Regenwasser');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{13775D9A-BC7B-4E6A-803C-8F7901102CAE}', 'global', '255', 'bs_line', '2025-02-03 12:17:27', 'Sickerleitung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D6FB2948-352F-4AA6-9E69-A7B8FA02A232}', 'global', '255', 'textpar', '2025-02-11 11:44:44', 'Redlining');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{85F1F6D0-2A57-46CA-B7E2-17A4D366CFCD}', 'global', '255', 'textpar', '2025-02-11 11:44:45', 'Arial 1.5 mittig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{82AD22AC-2269-495E-B3A7-BE097E180D45}', 'global', '255', 'textpar', '2025-02-11 11:44:46', 'Arial 2.0 mittig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C476B64F-B8E2-4413-A4CA-55571D2CAF24}', 'global', '255', 'textpar', '2025-02-11 11:44:47', 'Arial 2.5 mittig');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DB2987BB-9AD6-4C1A-B4A9-6854CC4FE0C0}', 'global', '255', 'textpar', '2025-02-11 11:44:48', 'Arial 1.5 block');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B97B7A30-2831-4F98-8D5A-19918D5D57F2}', 'global', '255', 'arrowpar', '2025-02-11 11:44:49', 'Redlining');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{71224F87-41A9-4953-9988-2F0E1FFB4D32}', 'global', '255', 'textpar', '2025-02-11 11:56:32', 'Redlining');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{32A07713-6635-4993-8E50-D3BB007A1700}', 'global', '255', 'arrowpar', '2025-02-11 11:56:33', 'Redlining');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F45061A6-BC82-4DAE-966C-5F0AE6BA1FB5}', 'global', '255', 'attrlabel', '2025-02-17 10:12:17', 'Multi-layer object with header 2,5 and EPD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A907D99C-6BFD-499E-B097-1FE6ACFDA92C}', 'global', '255', 'attrlabel', '2025-02-17 10:12:17', 'Multi-layer objects 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9A67DBA4-2834-4BFF-A5DA-82ADE1B5F4A5}', 'global', '255', 'attrlabel', '2025-02-17 10:12:17', 'Multi-layer objects 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7B1B316B-9729-4D72-81FF-396AD44506EF}', 'global', '255', 'attrlabel', '2025-02-17 10:12:17', 'Multi-layer objects with header 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{92ED7799-CD31-472D-9239-30FF8BEEBB86}', 'global', '255', 'attrlabel', '2025-02-17 10:12:17', 'Multi-layer objects with header 2,5');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E0974B47-5914-4188-8907-BB8571008707}', 'global', '255', 'terrain', '2025-02-17 10:13:08', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{95BB5E5C-83BB-475E-8FF0-972B9204A10F}', 'global', '255', 'wallopen', '2025-02-17 10:22:45', 'Wall opening');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{282D669A-7DA8-4DB6-81C1-AC63584F583D}', 'global', '255', 'bs_sewer', '2025-02-17 10:47:12', 'Inspection shaft');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5CFF1F47-C4BD-4805-B103-3E095B672E70}', 'global', '255', 'bs_sewer', '2025-02-17 10:47:12', 'Mud collector');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8C314F3A-929B-47A7-BF4E-878D2817C43A}', 'global', '255', 'bs_sewer', '2025-02-17 10:47:12', 'Seepage shaft');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{8D11EAC9-CE2D-414F-955D-C1EBD27AEBA2}', 'global', '255', 'bs_sewer', '2025-02-17 10:47:12', 'Separator');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{17CDC765-FD43-42A2-BB80-B63351EC8600}', 'global', '255', 'bs_line', '2025-02-17 10:47:32', 'Comb. waste water');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E425BFBD-F4D6-4EAE-9808-3B54CDCFF5A2}', 'global', '255', 'bs_line', '2025-02-17 10:47:32', 'Drain pipe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A2EA978B-FAD8-41EB-B340-7EED4AABB4EB}', 'global', '255', 'bs_line', '2025-02-17 10:47:32', 'Surface water');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{158FC497-B537-4322-BEFF-CD56522568BA}', 'global', '255', 'bs_line', '2025-02-17 10:47:32', 'Waste water');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0DBDAC2A-D7FC-4ACE-9F5C-9756542B410C}', 'global', '255', 'roofcut2d', '2025-02-17 14:01:44', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E59C9946-47B7-4A14-A153-1336B8262571}', 'global', '255', 'views', '2025-02-17 14:40:42', 'Working drawing');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C23E4850-6773-4350-A1B2-A4F649B71112}', 'global', '255', 'views', '2025-02-17 14:41:55', 'Construction project');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{32E82EE4-85A7-4B53-9FC7-C530CFF7FE2D}', 'global', '255', 'views', '2025-02-18 09:51:47', 'Entwurf');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2576C2DD-7028-44A9-B556-0F903F6EDB80}', 'global', '255', 'views', '2025-02-18 09:52:09', 'Einreichung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F17AC5F6-186E-41E4-B122-F88138393010}', 'global', '255', 'views', '2025-02-18 09:52:22', 'Ausführung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B137A0A4-9AEF-4DC3-A708-A53B0A1B9DAA}', 'global', '255', 'views', '2025-02-18 09:53:40', 'Entwurfsplanung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0F0AF3F3-F947-49E4-8832-A5EAFE2E07FF}', 'global', '255', 'views', '2025-02-18 09:53:49', 'Werkplanung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{59D3330C-7D41-4D36-BF9B-52254D3CD012}', 'global', '255', 'views', '2025-02-18 09:53:58', 'Eingabeplanung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{D0D9A438-0575-41A0-9408-8966AD1FC08C}', 'global', '255', 'views', '2025-02-18 09:55:17', 'Bauprojekt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5689A891-1D66-4D02-946A-0AEE0ECD5531}', 'global', '255', 'views', '2025-02-18 09:55:27', 'Werkplan');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8C3B2488-71FF-4CC1-B2A5-71B5D2649D67}', 'global', '255', 'views', '2025-03-05 10:02:42', 'Projet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CAF099B9-998B-4F56-A777-496853D86AC4}', 'global', '255', 'views', '2025-03-05 10:03:00', 'Exécution');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BA28B462-53CB-4892-A9D4-9C4F4E86B8F0}', 'global', '255', 'wall', '2025-03-05 10:03:44', 'Coffrage de bord de dale');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7CC13FED-1A13-4D0B-BF43-64924F7978E9}', 'global', '255', 'column', '2025-03-05 10:04:41', 'Béton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1570D891-CE79-4F06-BB5D-7992917CC868}', 'global', '255', 'column', '2025-03-05 10:04:55', 'Bois');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A37E1B15-D1C1-41A2-93F5-045DC673CD18}', 'global', '255', 'column', '2025-03-05 10:05:21', 'Acier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FCDB45E8-065B-421F-A0EA-3BB96A56BE3A}', 'global', '255', 'column', '2025-03-05 10:05:38', 'Brique');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8955D2AD-C115-40FE-8C5C-39C5CE28E582}', 'global', '255', 'grider', '2025-03-05 10:05:56', 'Acier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3BE406D7-92A5-45D2-90D4-0C419F68BF12}', 'global', '255', 'grider', '2025-03-05 10:06:11', 'Bois');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F3E62B6F-E439-417B-8D72-CF2091E377E7}', 'global', '255', 'roof', '2025-03-05 10:06:32', 'Limite de hauteur');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{58FFEB3C-C42E-459F-97F6-2FBF6A7292C6}', 'global', '255', 'roofopen', '2025-03-05 10:06:54', 'Standard Trou');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F11C7170-EB52-4510-83E6-A1F19FF7B280}', 'global', '255', 'roofopen', '2025-03-05 10:07:05', 'Standard Saignée');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D413EA92-1038-46E2-82CE-37D23535EF4E}', 'global', '255', 'roofcut2d', '2025-03-05 10:07:27', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{256220AA-69F0-4C05-87E3-391161BD7EF8}', 'global', '255', 'roofstruct', '2025-03-05 10:07:44', 'Chevron');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5A3CCEE6-87AD-48AC-8335-0F832D075C65}', 'global', '255', 'roofstruct', '2025-03-05 10:07:53', 'Alternance');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CD5D4814-BD02-45E6-AC23-662C0F9D9D34}', 'global', '255', 'roofstruct', '2025-03-05 10:08:10', 'Arêtier');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{230FCC01-2EA5-48AC-9CCE-AE21C9B34D68}', 'global', '255', 'roofstruct', '2025-03-05 10:08:20', 'Contrefiches');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{54B792F6-7C9A-42B3-AA94-5CFDBC19D252}', 'global', '255', 'roofstruct', '2025-03-05 10:08:33', 'Faîtière');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{51F27CA4-994F-42E1-B0C9-4502A11CB940}', 'global', '255', 'roofstruct', '2025-03-05 10:08:42', 'Moise');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8AB17619-E539-49DC-A5D2-91E4B96599EF}', 'global', '255', 'roofstruct', '2025-03-05 10:08:52', 'Montant');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{1E48351A-40A8-444A-B6B1-DBF02CD8AB52}', 'global', '255', 'roofstruct', '2025-03-05 10:08:59', 'Noue');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{EFD93758-FA64-4296-9A73-F10C6AB8FD1F}', 'global', '255', 'roofstruct', '2025-03-05 10:09:09', 'Panne');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E919CADA-78ED-439D-8A8A-D20F85F41775}', 'global', '255', 'chimney', '2025-03-05 10:09:28', 'Béton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{B626AB72-9FE3-4716-B42B-07CA5D3D696C}', 'global', '255', 'chimney', '2025-03-05 10:09:39', 'Brique');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7088AC57-2758-403F-85D8-3AAFE424E373}', 'global', '255', 'wallwindow', '2025-03-05 10:10:13', '1-Vantail+Poignée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5BF8BE43-5245-4CE0-A07F-1511250730B1}', 'global', '255', 'wallwindow', '2025-03-05 10:10:26', '2-Vantail+Poignée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{032B4A69-ED25-400B-89BA-8D3E0AEBCFDB}', 'global', '255', 'wallwindow', '2025-03-05 10:10:36', 'Velux Fenêtres de toit');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7F9C68F9-84ED-4C66-BE5E-62C51CED7E04}', 'global', '255', 'wallwindow', '2025-03-05 10:10:45', 'Velux Fenêtres pour toit plat');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{046E8196-DABD-422A-8607-A8CAC69B6AA6}', 'global', '255', 'walldoor', '2025-03-05 10:11:24', 'Extérieur 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{07638D38-0A47-45B3-B13C-4BAA770420B4}', 'global', '255', 'walldoor', '2025-03-05 10:11:31', 'Extérieur 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{345B3E2C-EC10-44EA-AB11-1C0534B487AA}', 'global', '255', 'walldoor', '2025-03-05 10:11:42', 'Extérieur 2 éléments latéraux1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5E1ACCAA-3F07-4AEA-8916-01D9F89235E5}', 'global', '255', 'walldoor', '2025-03-05 10:11:53', 'Extérieur élément latéral 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{70D05640-2B2B-4F08-9AB9-299907A050FF}', 'global', '255', 'walldoor', '2025-03-05 10:12:01', 'Extérieur élément latéral 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D20C31C1-3648-48B4-BB93-6E3A2B7EFEA6}', 'global', '255', 'walldoor', '2025-03-05 10:12:10', 'Extérieur élément latéral 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0E678213-4640-43BF-A04C-F32B10761857}', 'global', '255', 'walldoor', '2025-03-05 10:12:20', 'Extérieur élément latéral 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{15596BA0-347C-4F97-9CD5-4592995B599E}', 'global', '255', 'walldoor', '2025-03-05 10:12:28', 'Intérieure 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4FDAE0A6-8A20-4AD6-A1D9-E0ABF303DA1E}', 'global', '255', 'walldoor', '2025-03-05 10:12:37', 'Intérieure 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7EEBDCA4-BCA0-4840-A1E9-2C459BC1E3C1}', 'global', '255', 'walldoor', '2025-03-05 10:12:50', 'Intérieure 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{96AC34FA-4AA3-4523-A4DB-65679F6A5C61}', 'global', '255', 'walldoor', '2025-03-05 10:12:58', 'Laboratoire');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DDACB209-FCCB-4610-8561-AB4B48E1E0B7}', 'global', '255', 'walldoor', '2025-03-05 10:13:08', 'Porte de garage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9FA51E02-BA22-4323-A4DF-49A10EAC6F78}', 'global', '255', 'walldoor', '2025-03-05 10:13:19', 'Porte sectionnelle 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8FE9B59D-2061-4248-9A1F-1706E22054B5}', 'global', '255', 'walldoor', '2025-03-05 10:13:27', 'Porte sectionnelle 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5603E06F-BFA4-4B28-BE3C-1F8E95BC4868}', 'global', '255', 'walldoor', '2025-03-05 10:13:36', 'Porte sectionnelle industrie');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{57312583-27C0-4D9E-BB4D-F0E1C1F0B060}', 'global', '255', 'astairs', '2025-03-05 10:14:00', 'Acier');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3FB970A9-9F66-4526-854C-08514B234FAE}', 'global', '255', 'roomceiling', '2025-03-05 10:14:56', 'Plafond');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E11FA698-EC4C-4B5F-893D-1185ED910E37}', 'global', '255', 'roomfloor', '2025-03-05 10:15:14', 'Pente vers l\'écoulement');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9771AA86-17A1-4259-819C-6F9D0BD9578B}', 'global', '255', 'roomgroup', '2025-03-05 10:15:44', 'Total');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{A568ED60-573B-427A-85A7-4D67952F3545}', 'global', '255', 'roomgroup', '2025-03-05 10:15:56', 'Appartement');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{990D0112-FD1B-4D00-8481-4CA3E6B5D3DE}', 'global', '255', 'roomgroup', '2025-03-05 10:16:04', 'SUP de l\'étage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{AE0FA7AC-34B2-40F0-B6F5-75706939B921}', 'global', '255', 'roomgroup', '2025-03-05 10:16:12', 'Somme des locaux');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DDE18A29-8877-41D5-A720-9B3D4F256B25}', 'global', '255', 'attrlabel', '2025-03-05 10:17:09', 'Standard 3 lignes');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E3D153F5-A665-4C6B-8489-517E6D04CAAA}', 'global', '255', 'attrlabel', '2025-03-05 10:17:18', 'Construction couches 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FF8B50B8-6656-48AA-8303-93DF7D1EB174}', 'global', '255', 'attrlabel', '2025-03-05 10:17:27', 'Construction couches 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DEB0B772-6DBA-4D38-B746-8467E272C7CE}', 'global', '255', 'attrlabel', '2025-03-05 10:17:44', 'Construction couches titre 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9C222655-995B-4D08-A64E-2E6E6256B15E}', 'global', '255', 'attrlabel', '2025-03-05 10:17:50', 'Construction couches titre 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E28BB2F7-B615-464B-922F-8EF01738629A}', 'global', '255', 'attrlabel', '2025-03-05 10:17:57', 'Construction couches titre 2,5 EPD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{33D7EF10-4DBC-4E12-82CF-37FB6A424D9F}', 'global', '255', 'attrlabel', '2025-03-05 10:18:04', 'Local pour coupe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8BF2F4A6-526F-4BA3-8DEB-A4255A8A8712}', 'global', '255', 'attrlabel', '2025-03-05 10:18:19', 'Local pour coupe 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{8C117D14-DE03-48E0-A29F-A3C9BFB0B9CB}', 'global', '255', 'attrlabel', '2025-03-05 10:18:27', 'Numéro');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{DAF183DC-9C8F-44DA-AAE5-F7AAE922901A}', 'global', '255', 'attrlabel', '2025-03-05 10:18:34', 'Numéro de fenêtre');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0FC4DAD0-9771-4062-BC93-215E489A6310}', 'global', '255', 'attrlabel', '2025-03-05 10:18:40', 'Numéro de porte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{D8B13EEB-9A49-4E27-BBA1-B9B325E7C8E4}', 'global', '255', 'attrlabel', '2025-03-05 10:18:47', 'Standard 5 lignes');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{E1839AD9-87BD-4E60-A2A6-898F65E61A47}', 'global', '255', 'terrain', '2025-03-05 10:19:12', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CE9777E7-4CA7-4BB0-9DEF-F86B9298DC77}', 'global', '255', 'attrcolpar', '2025-03-05 10:19:29', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{9B40A2DF-3D9E-4FED-B913-D5E42EF92509}', 'global', '255', 'formatpar', '2025-03-05 10:20:07', 'A3portrait');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{F5D86279-61AB-4404-B58E-D1CBDE269305}', 'global', '255', 'formatpar', '2025-03-05 10:20:21', 'A4portrait');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{CEF2B1CA-9046-4906-929A-A7235BC5193A}', 'global', '255', 'bs_sewer', '2025-03-05 12:28:40', 'Regard de contrôle');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{25C0CE02-1D00-4D42-BD41-FDB9AB61287E}', 'global', '255', 'bs_sewer', '2025-03-05 12:30:38', 'Séparateur');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{01233966-B56B-41D4-ABE0-A5069E2D0ED2}', 'global', '255', 'bs_sewer', '2025-03-05 12:35:29', 'Dépotoir');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5AAE539B-727B-4A1A-B0B0-DF7B6AB54CA6}', 'global', '255', 'bs_sewer', '2025-03-05 12:35:45', 'Puisard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{794B8E1E-06C2-45DD-A7E9-F367DFA7814A}', 'global', '255', 'bs_line', '2025-03-05 12:37:33', 'Usée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{BD30275E-DF96-406E-9B64-23B99D6F8215}', 'global', '255', 'bs_line', '2025-03-05 12:37:41', 'Polluée');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{49B67C4B-B91B-49D2-881B-AABDC1215B77}', 'global', '255', 'bs_line', '2025-03-05 12:38:31', 'Drainage');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{FF73CB3D-646D-4C2E-AD9D-B90A017AF1DC}', 'global', '255', 'bs_line', '2025-03-05 12:38:46', 'Pluie');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4DDDE473-A51A-4002-B585-EA43B6800542}', 'global', '255', 'argroundlevel', '2025-03-05 13:51:21', 'Arial 2.0 Fini / Brut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{91E9CA2E-4F1A-4443-918C-3B10F8DA97F8}', 'global', '255', 'argroundlevel', '2025-03-05 13:51:44', 'Arial 2.0 Brut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7D357FE1-CFB4-4DB2-8AD5-F51828505B0C}', 'global', '255', 'argroundlevel', '2025-03-05 13:51:51', 'Arial 2.0 Fini');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{ECA92768-EB70-45DC-9CAF-A9C89BB22368}', 'global', '255', 'ardimlevel', '2025-03-05 13:52:22', 'Arial 1.75 Demi abs');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{697D7FDD-FCBE-4766-90AC-3060ACE92454}', 'global', '255', 'ardimlevel', '2025-03-05 13:52:30', 'Arial 3.5 Demi abs');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{84D8CDA9-C721-40FA-8598-25798CFADF2E}', 'global', '255', 'attrcolpar', '2025-03-05 15:27:28', 'act');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{7B57A47F-A399-4DF3-94FF-0AB27FB31666}', 'global', '255', 'dormer', '2025-03-05 15:37:38', 'Lucarne en pointe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{5BDFAACA-7C42-4CB3-8F0D-2F1C981791E2}', 'global', '255', 'dormer', '2025-03-05 15:37:54', 'Lucarne rampante');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4A492C4B-F382-48D5-8C93-6CC7F7254C49}', 'global', '255', 'dormer', '2025-03-05 15:37:59', 'Lucarne trapézoïdale');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{0FB9A90F-7A61-4EBD-BB2C-3E5D052605FA}', 'global', '255', 'dormer', '2025-03-05 15:40:36', 'Lucarne à pignon');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{3E980B7A-8590-44BE-ABD6-8FCBBA98BD20}', 'global', '255', 'grid', '2025-03-06 07:34:53', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{40AD7F4A-B273-4F51-BE03-B8CE6E199211}', 'global', '255', 'grid', '2025-03-06 07:35:07', 'Standard variable');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, fr) VALUES ('TY-{4C304549-142E-4CC7-AED4-419D1D9930D5}', 'global', '255', 'grid', '2025-03-06 07:35:15', 'Standard variable 2');
-- values pl
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A3367E0F-85A8-4259-851B-820F3367020B}', 'global', '255', 'attrcolpar', '2025-03-10 13:43:03', 'act');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E1C17FF2-7FA3-4ABD-B9D8-C7F20D781E5B}', 'global', '255', 'reppar', '2025-03-10 13:44:12', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9BC179FF-90F4-49AD-AB0A-3883CE28F4A7}', 'global', '255', 'views', '2025-03-10 13:44:48', 'Projekt budowlany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BA10CFEC-B2B5-45FE-8BA7-A1A8D7CDEA9A}', 'global', '255', 'views', '2025-03-10 13:47:01', 'Plan budowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D2B01587-C412-4ED4-BACB-7E3728F06160}', 'global', '255', 'wall', '2025-03-10 13:47:51', 'Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DE33EB7E-6570-4981-A4E2-2CD0DF348C3F}', 'global', '255', 'wall', '2025-03-10 13:48:34', 'Beton z izolacją');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6D27E30F-5A65-4A3A-9E01-DC0BE97B6533}', 'global', '255', 'wall', '2025-03-10 13:48:45', 'Cegła');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9BAAEB9E-A861-42A1-99D9-3E3A5F542984}', 'global', '255', 'wall', '2025-03-10 13:48:53', 'Fasada wentylowana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{293AAB31-3048-414A-9DA5-48BDCB81BB94}', 'global', '255', 'wall', '2025-03-10 13:49:01', 'Istniejąca ściana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CD8526DC-2869-4EB0-BE84-DE17B3A83440}', 'global', '255', 'wall', '2025-03-10 13:49:06', 'Izolacja zewnętrzna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8547C8A7-031F-4391-82C3-064A9B79C3B3}', 'global', '255', 'wall', '2025-03-10 13:49:13', 'Izolacja ściany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C2C6CB04-E0EB-4715-96E2-16C4EE886973}', 'global', '255', 'wall', '2025-03-10 13:49:20', 'Izolowany beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{17A6AC39-3B6F-4952-AC7C-481881183531}', 'global', '255', 'wall', '2025-03-10 13:49:26', 'Kamień naturalny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F05A2251-7BB6-4F9E-8074-E448DDB5ACA3}', 'global', '255', 'wall', '2025-03-10 13:49:32', 'Mur ceglany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1086AAFA-6745-4ED5-98D8-63F51648D03F}', 'global', '255', 'wall', '2025-03-10 13:49:39', 'Parapet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BF418B53-05CB-4040-9679-0BAB6BCC4EE1}', 'global', '255', 'wall', '2025-03-10 13:49:47', 'Wentylowana fasada');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F9109F4D-5F7E-4B8B-A928-F2FFF7F4C224}', 'global', '255', 'wall', '2025-03-10 13:49:54', 'Wyburzona ściana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6A5171D4-B450-470B-977B-57B6DCAF5F8C}', 'global', '255', 'wall', '2025-03-10 13:50:00', 'Ściana 10 cm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BCA72629-AF31-4F8E-90F2-7ED48A7C3ADD}', 'global', '255', 'wall', '2025-03-10 13:50:08', 'Ściana betonowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{B21E9C4A-6656-437A-A028-DCACC6838EBB}', 'global', '255', 'wall', '2025-03-10 13:50:14', 'Ściana lekka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1B223823-9320-4AB4-9174-212A6697E66B}', 'global', '255', 'wall', '2025-03-10 13:50:22', 'Ściana przebudowana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5DB80AB1-812E-43BB-88C6-5436A977DBD3}', 'global', '255', 'wall', '2025-03-10 13:50:31', 'Ściana wewnętrzna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E9E8D754-966E-405E-8B2C-9286051EE4CF}', 'global', '255', 'wall', '2025-03-10 13:50:39', 'Ściana z drewnianym szkieletem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4E890ACA-A999-44A2-9820-1D7C351327EE}', 'global', '255', 'wall', '2025-03-10 13:50:47', 'Ściana z pustką');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{57DE7303-14A7-4263-999C-F92B0686ED72}', 'global', '255', 'wall', '2025-03-10 13:50:53', 'Ściana zewnętrzna');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4C999581-BA75-4FC6-AF7B-FFE24FDABFA9}', 'global', '255', 'floor', '2025-03-10 13:51:33', 'Standardowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A427BB4F-AC6C-40A4-92DD-CEA2C37C9E17}', 'global', '255', 'floor', '2025-03-10 13:51:39', 'Podmurówka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8FEFBA7F-2A49-4F5D-8E05-C03CD6A54831}', 'global', '255', 'floor', '2025-03-10 13:51:50', 'Płyta drewniana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C7CFF7ED-C555-4078-BA9F-E524DEB146F3}', 'global', '255', 'floor', '2025-03-10 13:51:58', 'Płyta nachylona');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0866BA59-06D2-4A87-B40F-7D25054D4834}', 'global', '255', 'flooropen', '2025-03-10 13:52:17', 'Otwarcie płyty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{351A2C52-9A3D-495F-A713-756AD7FDD5AB}', 'global', '255', 'flooropen', '2025-03-10 13:52:22', 'Otwarcie podłogi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0AC73B94-4F5C-4D5B-8D26-6153FE883C8C}', 'global', '255', 'flooropen', '2025-03-10 13:52:33', 'Otwór w suficie');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DE3A3AFC-C0CD-400F-BFCB-889682090A39}', 'global', '255', 'column', '2025-03-10 13:52:50', 'Przekrój kwadratowu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E8C974B4-EF0E-4134-8C81-543506F25941}', 'global', '255', 'column', '2025-03-10 13:52:55', 'Dowolny kształt');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C2D94D22-1151-4DB7-9618-1474DFEFA05C}', 'global', '255', 'column', '2025-03-10 13:53:05', 'Przekrój okrągły');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{18210A82-5C27-48D8-984A-8E201142F7B0}', 'global', '255', 'column', '2025-03-10 13:53:12', 'Przekrój prostokątny');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7F1A4790-7B6B-4C1B-9F44-94AEEDE8D823}', 'global', '255', 'grider', '2025-03-10 13:53:36', 'Standardowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4497EED2-A343-4DD6-97B6-A7DE1BAC906A}', 'global', '255', 'roof', '2025-03-10 13:53:49', 'Standardowy 3-warstwowy');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5FC1B567-CF50-4C64-B99B-953A4BEEDDCC}', 'global', '255', 'roof', '2025-03-10 13:53:54', 'Podłgoa poddasza');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9FDD756A-DA7E-4072-8028-5A0CB9E817A2}', 'global', '255', 'roof', '2025-03-10 13:54:03', 'Sufit podwieszany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4CE72EDB-6D74-45FC-83E3-35BF4DF5E319}', 'global', '255', 'roof', '2025-03-10 13:54:11', 'Ścięty dach szczegółowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CF9D1300-8078-4942-9DBB-B1F5D9D7CF92}', 'global', '255', 'dormer', '2025-03-10 13:54:29', 'Standardowa lukarna trójkątna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{73716D8F-619A-491B-83E5-781A7E92E660}', 'global', '255', 'dormer', '2025-03-10 13:55:06', 'Standardowa lukarna dwuspadowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{03DCB793-768C-4D55-BEAA-7E59DC2C45C2}', 'global', '255', 'dormer', '2025-03-10 13:55:22', 'Standardowa lukarna jednospadowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C5195BCA-C292-4926-ABEE-CEB03CC929C4}', 'global', '255', 'dormer', '2025-03-10 13:55:31', 'Standardowalukarna trapezowa');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{454EC116-B9DB-461C-A788-FDD733F44169}', 'global', '255', 'roofopen', '2025-03-10 13:55:47', 'Standardowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{82B41AB2-79B1-46FE-A71D-1D4E5AEACEF2}', 'global', '255', 'roofcut2d', '2025-03-10 13:56:01', 'Standardowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4191F893-6D09-49C8-BB4E-63D02F107B81}', 'global', '255', 'roofstruct', '2025-03-10 13:57:17', 'Kołnierz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{ED5C31A6-0A3F-4C2C-99BC-8443104F6D88}', 'global', '255', 'roofstruct', '2025-03-10 13:57:24', 'Dolna płatew');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{50B5B43C-4491-4CE0-AFB4-2B568FADD67A}', 'global', '255', 'roofstruct', '2025-03-10 13:57:33', 'Jętki');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{59B4CF90-8AB0-40AE-A030-84893EB7D879}', 'global', '255', 'roofstruct', '2025-03-10 13:57:40', 'Kalenica');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F83B1901-0EB1-45FD-AA34-9E7A2E410583}', 'global', '255', 'roofstruct', '2025-03-10 13:57:47', 'Kratownica');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F4025C87-D015-4FE2-B644-01A9190D3330}', 'global', '255', 'roofstruct', '2025-03-10 13:57:52', 'Krokiew koszowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2CA00552-DA20-4975-9793-36971614C082}', 'global', '255', 'roofstruct', '2025-03-10 13:57:59', 'Krokiew narożna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{56CF8187-1884-4D4A-A8BA-FE58258A14C8}', 'global', '255', 'roofstruct', '2025-03-10 13:58:04', 'Krokwie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6D679FC8-9AD1-4A6B-A929-4B5675582570}', 'global', '255', 'roofstruct', '2025-03-10 13:58:10', 'Murłata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C661154A-A5CC-446E-98BB-E70D6E892283}', 'global', '255', 'roofstruct', '2025-03-10 13:58:16', 'Płatew');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E5F8BF1E-DBF3-4352-8735-6EB61289ECF2}', 'global', '255', 'roofstruct', '2025-03-10 13:58:23', 'Stężenie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1D75A6FB-6636-4A3C-A3B4-5E8334556513}', 'global', '255', 'roofstruct', '2025-03-10 13:58:29', 'Słup');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{65A0BEE9-CF2C-4346-AA7E-E7468AC9A1F9}', 'global', '255', 'roofstruct', '2025-03-10 13:58:36', 'Wymian');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{581DAAC3-F112-476A-9917-A4A949515F59}', 'global', '255', 'roofstruct', '2025-03-10 13:58:43', 'Środkowa płatew');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F89FC7D0-183C-45FA-A5BA-F2DCB0DF7548}', 'global', '255', 'chimney', '2025-03-10 13:59:11', 'Standardowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4B58EA28-E212-4EB1-8370-B933CA4709CB}', 'global', '255', 'wallwindow', '2025-03-10 14:00:24', 'Standardowy ogranicznik');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F183AD21-8AA5-4D2C-9973-28D97D7E0545}', 'global', '255', 'wallwindow', '2025-03-10 14:00:33', 'Drzwi standardowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{436C1367-E43B-42CE-AF15-C1A28CF388BD}', 'global', '255', 'wallwindow', '2025-03-10 14:00:48', 'Dwuskrzydłowe z uchwytami');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CD045270-EC63-4BE8-9D7C-70C8E8599FC1}', 'global', '255', 'wallwindow', '2025-03-10 14:00:55', 'Jednoskrzydłowe z nadprożem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2EFD5B87-18C9-48AA-B628-B8A7217DB736}', 'global', '255', 'wallwindow', '2025-03-10 14:01:01', 'Jednoskrzydłowe z uchwytem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D7F82CD7-B178-4049-ABD5-12857183C8CB}', 'global', '255', 'wallwindow', '2025-03-10 14:01:08', 'Kwatera standardowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{443946CA-EB10-4DBA-8C2E-B41A698D6FCE}', 'global', '255', 'wallwindow', '2025-03-10 14:01:15', 'Okno przesuwne');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C0B26A21-2CCF-479C-B794-01348D4B4FDE}', 'global', '255', 'wallwindow', '2025-03-10 14:01:22', 'Podwójnie uchlne');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{3CDF34A2-E409-401F-888D-3D7C63A6624F}', 'global', '255', 'wallwindow', '2025-03-10 14:01:28', 'Roleta z izolacją');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{11F4117A-B866-4345-8175-296A23473250}', 'global', '255', 'wallwindow', '2025-03-10 14:01:35', 'Velux - dach pochyły');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{04ECCB08-72B4-44D3-B032-14A3D7CC7D79}', 'global', '255', 'wallwindow', '2025-03-10 14:01:40', 'Velux - dach płaski');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1EB2A6A9-1E92-429F-9CCE-F22DB2668274}', 'global', '255', 'walldoor', '2025-03-10 14:02:06', 'Wejściowe 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6D6701B6-3240-4015-B379-7A8B76533981}', 'global', '255', 'walldoor', '2025-03-10 14:02:12', 'Brama garażowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0B72C7AA-503D-49EB-BF6D-47D02EC1FBB8}', 'global', '255', 'walldoor', '2025-03-10 14:02:23', 'Brama segmentowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A0B9DB6F-EE82-4EA6-9699-FBAAA4C59C7C}', 'global', '255', 'walldoor', '2025-03-10 14:02:29', 'Brama segmentowa z szybami');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2665A380-1562-42AC-8125-4C65C7B42206}', 'global', '255', 'walldoor', '2025-03-10 14:02:35', 'Drewniane drzwi z ościeżnicą');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{71B73A5A-C7CB-496E-A42D-6F6F61795D78}', 'global', '255', 'walldoor', '2025-03-10 14:02:45', 'Drzwi garażowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{FAFED9FB-FB98-4479-83C3-C53DA377F3C7}', 'global', '255', 'walldoor', '2025-03-10 14:02:51', 'Drzwi laboratotium');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{01DB5C8C-D731-4205-8F0A-DBDB7A0D3E2F}', 'global', '255', 'walldoor', '2025-03-10 14:02:57', 'Drzwi obite');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9E29B2D9-D24B-4A28-8A5D-F65500EB69E5}', 'global', '255', 'walldoor', '2025-03-10 14:03:04', 'Drzwi przechodnie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{092951C4-8DAE-4C11-A313-32D0D926EB88}', 'global', '255', 'walldoor', '2025-03-10 14:03:10', 'Drzwi przesuwne');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A3B2E598-2CA1-49A1-AB93-11A0D646D9D7}', 'global', '255', 'walldoor', '2025-03-10 14:03:16', 'Drzwi w szkieletowej kons.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{314FE53E-A1EE-4708-BDA5-9EDA06402F9B}', 'global', '255', 'walldoor', '2025-03-10 14:03:23', 'Drzwi wejściowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6305A8B6-9B7C-4426-A422-F5F2D9C4A825}', 'global', '255', 'walldoor', '2025-03-10 14:03:31', 'Drzwi z ościeżnicą');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A0A71393-1558-45EC-BDA9-362C467CD34F}', 'global', '255', 'walldoor', '2025-03-10 14:03:37', 'Drzwi z ościeżnicą narożną');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{772EC8BF-F04B-4F0D-B439-C2EF1CC1F1D8}', 'global', '255', 'walldoor', '2025-03-10 14:03:43', 'Przemysłowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5AD12B2F-945B-4BB9-81A2-4BC761C9056B}', 'global', '255', 'walldoor', '2025-03-10 14:03:49', 'Standardowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{EE5B5892-D1E6-40AF-996E-A3CF4146BA29}', 'global', '255', 'walldoor', '2025-03-10 14:03:56', 'Wejściowe 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6EC21E2E-2F0E-421E-A9F5-C83BE3BC0F95}', 'global', '255', 'walldoor', '2025-03-10 14:04:04', 'Wejściowe 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DA601932-79D5-4F27-A82F-57789A6ADD12}', 'global', '255', 'walldoor', '2025-03-10 14:04:12', 'Wejściowe z 1 panelem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9F992487-82AE-47FA-B4BA-9D49AC9E0859}', 'global', '255', 'walldoor', '2025-03-10 14:04:21', 'Wejściowe z 1 panelem 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{976C84EA-A6D6-4637-BB2D-85DC06019A4C}', 'global', '255', 'walldoor', '2025-03-10 14:04:27', 'Wejściowe z 1 panelem 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7F7DFCCA-02DD-499F-BD52-FC872CB364BC}', 'global', '255', 'walldoor', '2025-03-10 14:04:36', 'Wejściowe z 1 panelem 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{3E55EB11-1224-4D90-AF3A-D3FC7D24A258}', 'global', '255', 'walldoor', '2025-03-10 14:04:41', 'Wejściowe z 2 panelami');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F755AA1E-E48D-4406-8DBC-D2667551DDE6}', 'global', '255', 'walldoor', '2025-03-10 14:04:48', 'Wewnętrzne 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BC7747D0-E8B9-4743-A87E-5B452B7719F0}', 'global', '255', 'walldoor', '2025-03-10 14:04:55', 'Wewnętrzne 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{20B6C0D9-BE69-4FBE-A70E-90E300285B2A}', 'global', '255', 'walldoor', '2025-03-10 14:05:02', 'Wewnętrzne 3');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7BB3473B-1A86-4400-A91D-7B5299ED7CDC}', 'global', '255', 'wallopen', '2025-03-10 14:05:18', 'Standardowy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6D12D658-1F49-40E6-9295-99ED73A83810}', 'global', '255', 'astairs', '2025-03-10 14:05:41', 'Betonowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{238B6343-545C-453A-8163-E9F5FC64FE75}', 'global', '255', 'astairs', '2025-03-10 14:05:49', 'Stalowe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{40EB84DB-4851-4369-8F29-D3665B9C4577}', 'global', '255', 'astairs', '2025-03-10 14:05:57', 'Wzdłużny');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2C2FAFE2-44F6-4D6B-BD8F-2F59F03F9BCB}', 'global', '255', 'railing', '2025-03-10 14:06:14', 'Pręty typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{EF596020-8A41-458E-A776-852F3C6AD6D1}', 'global', '255', 'railing', '2025-03-10 14:06:23', 'Drewno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5B21B989-3D49-4D11-A870-2D01AC0B2FF8}', 'global', '255', 'railing', '2025-03-10 14:06:32', 'Linka stalowa typ 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{3AACD1C1-CEBB-4B07-A7AF-13C2F8309C2D}', 'global', '255', 'railing', '2025-03-10 14:06:39', 'Linka stalowa typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{78B995D4-8010-409E-A7E2-E7A5D3A9566C}', 'global', '255', 'railing', '2025-03-10 14:06:45', 'Panele');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6EEC4AA8-E4E5-4F8E-986C-2EDBA38F3ED2}', 'global', '255', 'railing', '2025-03-10 14:06:52', 'Poręcz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E7260A90-F6F1-4E68-8C68-61EA815CA6DD}', 'global', '255', 'railing', '2025-03-10 14:06:57', 'Pręty typ 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{65965F6D-848D-4A32-8E27-6DA154435432}', 'global', '255', 'railing', '2025-03-10 14:07:03', 'Pręty typ 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{51042E51-47AF-436F-BD2B-D03D854248D3}', 'global', '255', 'railing', '2025-03-10 14:07:11', 'Płyta perforowana');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{971F0054-9926-4919-90FF-51B220431168}', 'global', '255', 'railing', '2025-03-10 14:07:17', 'Szklane');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DAF56339-82F6-495C-BD57-93DCFFA47908}', 'global', '255', 'railing', '2025-03-10 14:07:27', 'Szklane 2');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{31043E0A-6C21-4F53-B605-45B6BBF729AD}', 'global', '255', 'room', '2025-03-10 14:07:44', 'Taras');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A6AB82CA-645A-45AA-A352-9917B4FAEEE4}', 'global', '255', 'roomfloor', '2025-03-10 14:07:50', 'Klatka schodowa');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{079E7BB6-631C-4F8E-BC95-CF704053B378}', 'global', '255', 'room', '2025-03-10 14:08:14', 'Powierzchnia salonowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{07D7431B-3F76-49BB-BFF5-C0A04823743F}', 'global', '255', 'room', '2025-03-10 14:09:02', 'Dach płaski');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{FCDB221A-F0D6-4D6E-A2B4-4E7F2AE6F536}', 'global', '255', 'room', '2025-03-10 14:09:09', 'Klatka schodowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8A3A59F1-2C6A-4AAF-890D-E7AB8E5D7788}', 'global', '255', 'room', '2025-03-10 14:09:15', 'Piwnica');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1F317921-CF66-4AE6-9655-25AA82ADFDC3}', 'global', '255', 'room', '2025-03-10 14:09:22', 'Powierzchnia piwnicy');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E053A709-3AA7-4F41-96C8-DC5FB2055A9A}', 'global', '255', 'room', '2025-03-10 14:09:28', 'Powierzchnia użytkowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C0747E32-9894-4E9C-9CDB-2CEF707DA7CB}', 'global', '255', 'room', '2025-03-10 14:09:35', 'Powierzchnia wilgotna');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F992325F-2D98-4292-9BE2-145D7D43E5FC}', 'global', '255', 'roomfloor', '2025-03-10 14:14:13', 'Bez styropianu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A2B91CA5-13C9-4062-A2B5-FA475F940A9D}', 'global', '255', 'roomfloor', '2025-03-10 14:14:21', 'Bruk na dachu płaskim');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{75CF0FF0-1400-4604-A121-63B46B1F4D7D}', 'global', '255', 'roomfloor', '2025-03-10 14:14:27', 'Jednowarstwowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AEB1D532-7691-45DB-A09E-1F72D10ADD36}', 'global', '255', 'roomfloor', '2025-03-10 14:14:33', 'Wylewka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DBDBA348-394A-4E35-8018-9245FE88543A}', 'global', '255', 'roomfloor', '2025-03-10 14:14:39', 'Z izolacją');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{135C173D-C825-4FF9-8757-D22F890C9F50}', 'global', '255', 'roomfloor', '2025-03-10 14:14:45', 'Żwir na dachu płaskim');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AE19F3BB-F2A3-4B45-8C24-9C68D95B5DAA}', 'global', '255', 'roomceiling', '2025-03-10 14:15:19', 'Sufit');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0036AE49-DD56-4E74-B06D-7144480C97D1}', 'global', '255', 'roomgroup', '2025-03-10 14:16:19', 'Total');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{21FCAEDF-FD4D-40FB-B11F-2CAD9CD42F4C}', 'global', '255', 'roomgroup', '2025-03-10 14:16:26', 'Całkowity');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BE0E8673-DA08-4E6B-B44E-E71AE5E7AD63}', 'global', '255', 'roomgroup', '2025-03-10 14:16:38', 'Mieszkanie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9266FDD5-1BB7-41BD-B9C8-624847A4C91A}', 'global', '255', 'roomgroup', '2025-03-10 14:16:46', 'Suma pokoi');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CDCFB5FA-5E51-472E-9B38-D284B39D2A27}', 'global', '255', 'textpar', '2025-03-10 14:34:50', 'teren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7FA4890D-9E62-4D8B-B6B3-5635978E431B}', 'global', '255', 'textpar', '2025-03-10 14:35:06', 'Arial 0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{313FF3E2-C625-4EC7-9521-C430218C252B}', 'global', '255', 'textpar', '2025-03-10 14:35:13', 'Arial 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C1739D76-ACE1-4F3F-B4D6-70A37F9EF355}', 'global', '255', 'textpar', '2025-03-10 14:35:17', 'Arial 1.5 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BFF8BE1B-44C1-4D43-8295-9C2A4D35018B}', 'global', '255', 'textpar', '2025-03-10 14:35:22', 'Arial 1.5 justowany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7516D238-EC7E-43D0-BC03-85966AC3E0E1}', 'global', '255', 'textpar', '2025-03-10 14:35:27', 'Arial 2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{08E2082A-C650-4E92-943E-C0729C5E4986}', 'global', '255', 'textpar', '2025-03-10 14:35:34', 'Arial 2.0 bold');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{FFE51AC2-DBC5-4310-941B-97C066D39F1B}', 'global', '255', 'textpar', '2025-03-10 14:35:39', 'Arial 2.0 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C755C200-8F66-481A-A2B4-0FD2E62F905B}', 'global', '255', 'textpar', '2025-03-10 14:35:46', 'Arial 2.0 justowany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{841A9D67-EACE-4553-90DB-9469DA37AA13}', 'global', '255', 'textpar', '2025-03-10 14:35:53', 'Arial 2.0 pogrubiony');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{91706A1A-ABB8-46B9-927C-076E359842C9}', 'global', '255', 'textpar', '2025-03-10 14:36:00', 'Arial 2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{971BC2B8-F081-4233-B526-02177BE3726E}', 'global', '255', 'textpar', '2025-03-10 14:36:07', 'Arial 2.5 bold');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D53BA0A0-41C1-4C03-B846-003AE1DE81BB}', 'global', '255', 'textpar', '2025-03-10 14:36:16', 'Arial 2.5 justify');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{973469D6-F532-4293-8EF1-CD730CA0961D}', 'global', '255', 'textpar', '2025-03-10 14:36:22', 'Arial 2.5 justowany');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A808B725-B04C-4958-82D7-CE4BDC4A6275}', 'global', '255', 'textpar', '2025-03-10 14:36:29', 'Arial 2.5 pogrubiony');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{244677C5-6B1B-4765-9BBF-695F3D93930D}', 'global', '255', 'textpar', '2025-03-10 14:36:34', 'Arial 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9CD20A48-058C-44A8-9811-3122A9D27427}', 'global', '255', 'textpar', '2025-03-10 14:36:39', 'Arial 3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DE1544FE-3D77-43A1-AAB4-12EC5A42AB18}', 'global', '255', 'textpar', '2025-03-10 14:36:46', 'Arial 5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6A7DC7B2-8838-4C03-9D8E-82F6368A01C7}', 'global', '255', 'textpar', '2025-03-10 14:36:51', 'Arial 7.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C6B8E1B1-E4BD-4626-907A-4C062FD07256}', 'global', '255', 'textpar', '2025-03-10 14:36:56', 'Arial_05');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DE342574-6C25-4511-9ACC-4B8C4C8B92D6}', 'global', '255', 'textpar', '2025-03-10 14:37:00', 'Arial_10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1D4A93CC-2EF1-43BD-8D46-E2D5E6A8433D}', 'global', '255', 'textpar', '2025-03-10 14:37:04', 'Arial_15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CE0F6BB3-1BD2-4FC2-BBA8-7E6E30748CFC}', 'global', '255', 'textpar', '2025-03-10 14:37:09', 'chamber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4ECE916C-70D1-4DD9-B2EB-0A1F7715AF1C}', 'global', '255', 'textpar', '2025-03-10 14:37:15', 'circuit');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2B89B5A7-8195-4C00-93FF-7CA96B72B85D}', 'global', '255', 'textpar', '2025-03-10 14:37:20', 'obwód');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{727F1F39-571F-43ED-AD16-BF44BCA134CE}', 'global', '255', 'textpar', '2025-03-10 14:37:27', 'pomieszczenie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{553F445A-A36B-425F-BAAF-B69351B921E0}', 'global', '255', 'textpar', '2025-03-10 14:37:34', 'terrain');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E047C069-5012-4006-A7D2-D1568EC25A8C}', 'global', '255', 'dimpar', '2025-03-10 14:38:10', 'wysokość sekcji');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{38968489-8574-43AE-AA9A-BC64A6B21393}', 'global', '255', 'dimpar', '2025-03-10 14:38:24', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{00E3B05F-95DD-42F3-A379-92C9E4D8944C}', 'global', '255', 'dimpar', '2025-03-10 14:38:34', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{06984A64-C238-4CDC-B786-799EE1868715}', 'global', '255', 'dimpar', '2025-03-10 14:38:41', 'Arial 2.5 L04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E6B4531E-BAB9-4C8A-94B3-D942D199C2AB}', 'global', '255', 'dimpar', '2025-03-10 14:38:48', 'Arial 2.5 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0F68420D-B617-469F-B5C4-702461460330}', 'global', '255', 'dimpar', '2025-03-10 14:38:54', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{722490A2-5C02-4474-8429-2AD348374C4F}', 'global', '255', 'dimpar', '2025-03-10 14:39:04', 'Arial 3.0 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{384A3919-3261-49F1-95B0-D4EF6A77E436}', 'global', '255', 'dimpar', '2025-03-10 14:39:11', 'Arial 3.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7C9F742D-613C-4838-8EAE-E1DDF3F9F725}', 'global', '255', 'dimpar', '2025-03-10 14:39:16', 'height section');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D60A9B8A-6237-4025-8E0A-F69E7538C0C5}', 'global', '255', 'hatchpar', '2025-03-10 14:40:03', 'żółty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A202AE6E-886D-49A6-9DA6-4B0D549298AD}', 'global', '255', 'hatchpar', '2025-03-10 14:40:16', 'Arkusz uszczelniający');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{258F7077-559C-4AB9-A7B9-B87DDD79C0FD}', 'global', '255', 'hatchpar', '2025-03-10 14:40:23', 'Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6905FB88-CC06-4BF3-BFEF-FCE9752DA762}', 'global', '255', 'hatchpar', '2025-03-10 14:40:32', 'Beton podkładowo-wyrównaw');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A32C0AEE-DE26-47B0-B64F-930FB8AA32A8}', 'global', '255', 'hatchpar', '2025-03-10 14:40:39', 'Blok betonu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E2BF1544-0406-4355-9499-B4B10604D1E6}', 'global', '255', 'hatchpar', '2025-03-10 14:40:43', 'Cegła');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DA86D3C6-98EF-4051-B4DE-62A9D05D7FD2}', 'global', '255', 'hatchpar', '2025-03-10 14:40:51', 'Cegła silikatowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2898D4D3-9C72-44C6-8E03-A9A77451696A}', 'global', '255', 'hatchpar', '2025-03-10 14:40:55', 'Cień');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{08EFB481-CE10-4FDC-AF6E-FF097BF05BC0}', 'global', '255', 'hatchpar', '2025-03-10 14:40:59', 'Cień transparentny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E61AF079-453F-47F9-B5A2-BF151800F107}', 'global', '255', 'hatchpar', '2025-03-10 14:41:03', 'Dach');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8B924140-7984-404D-9354-C18EB0EF657C}', 'global', '255', 'hatchpar', '2025-03-10 14:41:08', 'Drewno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{266BE8D5-7682-4236-85B6-C20AEA509FE3}', 'global', '255', 'hatchpar', '2025-03-10 14:41:12', 'Dywan');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E53FF4D9-5AC2-445D-8DEC-7B5D4863ACF5}', 'global', '255', 'hatchpar', '2025-03-10 14:41:16', 'Gips');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{21F95D31-A45C-4957-828C-110F50410145}', 'global', '255', 'hatchpar', '2025-03-10 14:41:21', 'Gleba');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{80C9B064-C296-4DE5-9D22-26D15708C076}', 'global', '255', 'hatchpar', '2025-03-10 14:41:32', 'Gont');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AA29896E-E59D-4DD1-B92C-3A64D32CDFE5}', 'global', '255', 'hatchpar', '2025-03-10 14:41:38', 'Jastrych');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7A5A6571-B2E4-4CED-A217-75BDDB1C51E8}', 'global', '255', 'hatchpar', '2025-03-10 14:41:44', 'Kamień naturalny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{124E0910-43D9-4F9C-A8B0-E4FF592C7658}', 'global', '255', 'hatchpar', '2025-03-10 14:41:51', 'Kamień sztuczny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{37919367-C99E-40A4-9F2E-F111BE0FA717}', 'global', '255', 'hatchpar', '2025-03-10 14:41:55', 'Krzyż');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DA92C7BF-3E3C-44B9-B811-145DACF09B86}', 'global', '255', 'hatchpar', '2025-03-10 14:41:59', 'Linia izolacji');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{89291E1B-A69E-4326-80D7-308E828D366D}', 'global', '255', 'hatchpar', '2025-03-10 14:42:06', 'Linia pozioma 0.4mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0DAEF8B0-C4A5-4F72-A6DF-BA621C8C4CF1}', 'global', '255', 'hatchpar', '2025-03-10 14:42:10', 'Metal');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{92250EA0-1433-4BE5-B776-0B1C3FB3B244}', 'global', '255', 'hatchpar', '2025-03-10 14:42:15', 'Mocna izolacja');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C41CE38C-4F7A-4F7F-AEEB-612A3E67548E}', 'global', '255', 'hatchpar', '2025-03-10 14:42:19', 'Piasek');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5C9BBE84-AB43-4112-97CE-38DD1F23FB7B}', 'global', '255', 'hatchpar', '2025-03-10 14:42:24', 'Piasek drobny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{278DFFA7-6F21-43A7-9A41-8B793BF0EAE9}', 'global', '255', 'hatchpar', '2025-03-10 14:42:29', 'Podłoże');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A8C26B65-71C4-4C00-989B-72D829BC57DC}', 'global', '255', 'hatchpar', '2025-03-10 14:42:33', 'Poziom gruntu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{656D53B5-420D-4F8D-AAE4-52AFE59615A0}', 'global', '255', 'hatchpar', '2025-03-10 14:42:37', 'Płyta gipsowo-kartonowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{967D835E-1A6F-44E2-8B7B-1BB5CE36D60A}', 'global', '255', 'hatchpar', '2025-03-10 14:42:41', 'Płyta pilśniowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E02386A8-3D1F-405B-9510-81D99A65D250}', 'global', '255', 'hatchpar', '2025-03-10 14:42:45', 'Płytki');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E61352D8-AE94-4167-8E76-E646DADC1F7B}', 'global', '255', 'hatchpar', '2025-03-10 14:42:50', 'Raster');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F43F1006-F73E-4FD5-86D8-43983578962B}', 'global', '255', 'hatchpar', '2025-03-10 14:42:57', 'Standardowy-3D 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5AF7F578-A467-4F04-87B9-497548E73A3F}', 'global', '255', 'hatchpar', '2025-03-10 14:43:01', 'Standardowy-3D 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{41089E2B-DF6F-42F1-BDE4-DA3F0D60590F}', 'global', '255', 'hatchpar', '2025-03-10 14:43:07', 'Taśma izolacyjna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{3BB22C80-AF0E-4C12-97FA-27F8E570F2B1}', 'global', '255', 'hatchpar', '2025-03-10 14:43:12', 'Taśma izolacyjna ciasna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DBEB7EC4-320D-45B6-8436-C3C3C4BF56EC}', 'global', '255', 'hatchpar', '2025-03-10 14:43:16', 'Warstwa żwiru');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{DA317E7A-329F-4D81-85A0-46DA5AE4F91B}', 'global', '255', 'hatchpar', '2025-03-10 14:43:21', 'Woda');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{17F0124E-0B48-4525-A91B-3A77B066ACB8}', 'global', '255', 'hatchpar', '2025-03-10 14:43:37', 'Wykop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6231737F-8DDD-4DC9-82E5-2D8B7FF8D400}', 'global', '255', 'hatchpar', '2025-03-10 14:43:41', 'Wypełnienie podłoża');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1E7D2B10-1A85-42DE-BDA6-4BB667621BB2}', 'global', '255', 'hatchpar', '2025-03-10 14:43:46', 'ciemny szary');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{BE299543-5B3F-4A34-A1B6-031C89900E55}', 'global', '255', 'hatchpar', '2025-03-10 14:43:51', 'czarny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7D6B1DA2-A434-4C62-B1BB-8199893768BE}', 'global', '255', 'hatchpar', '2025-03-10 14:43:55', 'czerwony');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4A06D7FB-B3F8-4E22-A054-B0E77732761D}', 'global', '255', 'hatchpar', '2025-03-10 14:44:00', 'jasny szary');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6465218C-3E93-415E-A2D9-8D8AA0957FC3}', 'global', '255', 'hatchpar', '2025-03-10 14:44:04', 'niebieski');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A4BA0C61-F263-48D4-BBEB-55723AFA2F44}', 'global', '255', 'hatchpar', '2025-03-10 14:44:13', 'szary');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AF55788D-622B-4E63-9CEA-E574C5C019D4}', 'global', '255', 'hatchpar', '2025-03-10 14:44:19', 'wypełnienie nieba');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2228E186-1E95-4736-BF6B-1C994B8ED994}', 'global', '255', 'hatchpar', '2025-03-10 14:44:23', 'zielony');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7C1DE9D3-F825-4E26-BC3A-03B077113425}', 'global', '255', 'hatchpar', '2025-03-10 14:44:27', 'Ściana szkieletowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6A2A87BD-5F25-48CB-93AA-A6A1C6A5D45A}', 'global', '255', 'hatchpar', '2025-03-10 14:44:32', 'Żwir');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{724855BC-8834-4F6F-8A5B-158884E379E3}', 'global', '255', 'attrlabel', '2025-03-10 14:45:02', 'Numer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6826D8DB-CFDA-435F-B21C-1D05EF87A621}', 'global', '255', 'attrlabel', '2025-03-10 14:45:08', 'Obiekt wielowarstwowy z nagłówkiem 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C25BD40B-D043-4655-AFA6-85F5FD838F67}', 'global', '255', 'attrlabel', '2025-03-10 14:45:15', 'Etykieta drzwi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2675A0DC-0384-4C48-964F-5BA14C04A410}', 'global', '255', 'attrlabel', '2025-03-10 14:45:31', 'Etykieta okna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{30839215-C699-4DB9-AB61-4DAD70811BC0}', 'global', '255', 'attrlabel', '2025-03-10 14:45:38', 'Etykieta pom. dla przekroju');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D269761B-FBFF-4158-A0F6-F8FF3AA68C7E}', 'global', '255', 'attrlabel', '2025-03-10 14:45:42', 'Obiekty wielowarstwowe 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0038D40D-BB03-4C76-AC86-6C70EA009243}', 'global', '255', 'attrlabel', '2025-03-10 14:45:45', 'Obiekty wielowarstwowe 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{D9BB553D-A740-4B74-B7D3-21056950BB87}', 'global', '255', 'attrlabel', '2025-03-10 14:45:49', 'Obiekty wielowarstwowe z nagłówkiem 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{04C0B5CB-7FA6-4D64-90E3-84149B757C7E}', 'global', '255', 'attrlabel', '2025-03-10 14:45:53', 'Obiekty wielowarstwowe, nagłówek 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{B313917A-A519-454C-A302-FB1797343028}', 'global', '255', 'attrlabel', '2025-03-10 14:45:57', 'Standard 3 wiersze');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1CF6CE40-AAE4-4976-8596-CD7F6CA43BAB}', 'global', '255', 'attrlabel', '2025-03-10 14:46:02', 'Standard 5 wierszy');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{031CB3DD-0BBD-477A-B91E-DE22F8F85AC0}', 'global', '255', 'arrowpar', '2025-03-10 14:46:19', 'Standardowy');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8DF544DE-F9F1-4393-A8CC-3AC308A24527}', 'global', '255', 'arrowpar', '2025-03-10 14:46:28', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{02CE4344-43D4-49E2-82CD-01EE29557DEF}', 'global', '255', 'attrcolpar', '2025-03-10 14:47:26', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{57B59E8E-73F7-4D33-B4AD-5317BF63F1B1}', 'global', '255', 'printpar', '2025-03-10 14:47:48', 'Solid');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CDD20FC8-D9F8-4EC5-A8D6-360B652C35B1}', 'global', '255', 'printpar', '2025-03-10 14:47:56', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5D11E77F-7507-4951-B995-EC1261705857}', 'global', '255', 'grid', '2025-03-10 14:48:27', 'Standardowa zmienna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{E5357FE8-D26A-4260-A251-0B03238DAE99}', 'global', '255', 'grid', '2025-03-10 14:48:34', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{60179482-D1B5-40BA-B1CF-3425E13450E3}', 'global', '255', 'grid', '2025-03-10 14:48:43', 'Standardowa zmienna 2');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{1CBA128F-F17B-4AB6-98A5-92337B56895B}', 'global', '255', 'bs_sewer', '2025-03-11 07:08:17', 'Szyb przesiąkowy');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{9D2D6586-AF9F-41AC-B097-064703BDE675}', 'global', '255', 'bs_sewer', '2025-03-11 07:09:11', 'Szyb inspekcyjny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{19CDADC5-1952-4FB8-8572-DCD3FEF68C28}', 'global', '255', 'bs_sewer', '2025-03-11 07:09:21', 'Zbieracz błota');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{0FD6A8D2-BD05-4230-A312-3B9A751E97A0}', 'global', '255', 'bs_sewer', '2025-03-11 07:10:57', 'Separator');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{16D94CD2-F33F-47C8-BE08-4D60095B73FB}', 'global', '255', 'bs_line', '2025-03-11 07:09:43', 'Ścieki');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6C715A09-B70C-42B6-A72A-9CC30ACE77DE}', 'global', '255', 'bs_line', '2025-03-11 07:09:50', 'Rura drenażowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F31F3B23-3CCF-4B61-B8EA-A377D70F5AEE}', 'global', '255', 'bs_line', '2025-03-11 07:10:01', 'Woda powierzchniowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{4289B541-30BF-4AD0-B309-DA68DAC1C38C}', 'global', '255', 'bs_line', '2025-03-11 07:10:10', 'Ścieki połączone');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{6B1909F9-784A-436B-B1C2-E3F7CF33C345}', 'global', '255', 'roofwindow', '2025-03-11 08:14:09', 'Velux - dach pochyły');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7FF0B9DF-EC5C-4144-9DC4-61874F204660}', 'global', '255', 'roofwindow', '2025-03-11 08:14:22', 'Velux - dach płaski');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F5DA916C-91C7-42C5-9873-EDB6CD7B7D0F}', 'global', '255', 'layerlist', '2025-03-11 08:25:34', 'Domyślny');
-- values gr
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{536C66B6-D578-48CB-9DA8-FBBB1767C313}', 'global', '255', 'attrcolpar', '2025-03-11 13:26:08', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{806BFD86-20A5-4540-A010-99DE210CF19B}', 'global', '255', 'attrcolpar', '2025-03-11 13:26:08', 'act');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BDAC1A9B-9F04-4B2A-B89D-5CF80B7FE066}', 'global', '255', 'printpar', '2025-03-11 13:26:16', 'Solid');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{43E74DEF-24B0-435D-A075-6E90B9798366}', 'global', '255', 'printpar', '2025-03-11 13:26:16', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{31592189-DD6C-408F-A0ED-1E141DB0F1D2}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Φυσική πέτρα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9E83FD6C-34B1-4E02-8794-49751E657802}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Γκρι σκούρο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{185A12E5-0BBA-454F-AE76-F995F912D81D}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Γκρι ανοιχτό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D720057B-4742-43D6-83DB-D755D50B2022}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Σκυρόδεμα Απλό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{1AD2DB6A-B9DF-458E-A1DA-A3ADC94B73E4}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Τεχνητή πέτρα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{520489CA-DB44-44DD-8B33-E7A44D405C91}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Ουρανός');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{61EB7886-9AA6-456C-A18E-70D012A072B4}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Τούβλο Απλό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{17934C28-2BFD-48B4-BA02-D3EE23588F62}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Μαύρο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C992242E-4BBF-426D-94B9-2B534BBB15E1}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Μέταλλο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2D781F85-2684-43A2-92ED-7A2EE9C708F1}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Ασβεστόλιθος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A66BD054-6CE0-4DC0-A428-AF5A330834A9}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Τούβλο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E4019DC3-4227-4895-B786-93EA123726EA}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κίτρινο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5A8CEA34-A1D1-4F09-A974-7A918B964236}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Ξύλο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0EF7E2DB-BF33-420E-877C-552A04685E7F}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Νερό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7B271894-3A37-493C-ADF2-E49624389B74}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Πλακίδια');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D247BFC0-19A3-4167-A2C0-9749D1833465}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Υπέδαφος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CA8B0734-7180-4F0D-A9B5-D39B273FB6F9}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Υπέδαφος-γέμισμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{EC863FDB-96A6-43EE-AB06-1BB9A1DA12D1}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Τοιχείο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FE8A3F3A-1C34-4B53-A16C-A6316C7D0DDD}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Πέτσωμα στέγης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FB17E724-16E7-42C8-8EC4-9404FA591B3A}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Διάφανη σκιά');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{981D1BF4-AEB8-4E4E-88D2-E9AEB51976CE}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Σκιά');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D7D8780C-20CD-44CA-93E1-76D175F64106}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Χώμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{92340D54-06EB-4BE5-977A-D03CBC332B41}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Στέγη');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F95D3696-E4D6-4E55-9271-1B3C5A522552}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κόκκινο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{DA6A8FFA-FF6F-4EEF-AA5D-A03485C20CB0}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Ράστερ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FF226CA3-1A39-446F-B9BB-FE6AEC0DFB5E}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Γυψοσανίδα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0F60EF5A-F03F-4845-AC02-9DC053393F65}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Μόνωση');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5DA2153F-D4ED-45FD-8C49-100F5A4AE915}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Μπλε');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5049B932-A6DD-4C24-86CE-E2A77F2AEC81}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Εκσκαφή');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7A13C42E-CB84-48C7-B174-EFDB50D3A5B3}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Τάπητας');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{474DC8F7-134B-43FB-87B8-9E8458A9E4FE}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Ψιλή άμμος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{48D3CDA3-BBD6-4080-9124-AEE0A8E8C6EF}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κατασκευή Δαπέδου 10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{86CDCB56-A8C4-45CB-9360-B192C680D22C}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κατασκευή Δαπέδου 12');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CB01F67A-57A3-4E09-8ECB-621F1B81EF99}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κατασκευή Δαπέδου 14');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{66155BEA-6CCE-4FCD-83DE-8ADE39EED92A}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κατασκευή Δαπέδου 16');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{48556EB7-8E6E-485F-A3AA-C27208726213}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Κροκάλες');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B3843FB0-8553-4999-8302-0F64E4C9B624}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Πράσινο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{960C5401-0CD4-4296-B77F-B890B263DA61}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Γκρί');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8A8E17B4-A80E-4B7E-9F73-04665315A3B6}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Έδαφος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{772F086C-E69C-4771-BDDD-E1A6EE451E77}', 'global', '255', 'hatchpar', '2025-03-11 13:26:27', 'Μόνωση-γραμμή');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5451F681-9ABC-4C6B-8570-82EC3DDABB09}', 'global', '255', 'textpar', '2025-03-11 13:26:41', 'Arial 2.5 έντονα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AA9847AC-A914-49DC-BAA1-51E5A386AF77}', 'global', '255', 'textpar', '2025-03-11 13:26:41', 'Arial 1.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3F94C22F-AB8B-4CFB-96B6-9400538504C3}', 'global', '255', 'textpar', '2025-03-11 13:26:41', 'Arial_05');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{DAA0FE2F-C2D4-4B92-AA31-6E746171A42D}', 'global', '255', 'textpar', '2025-03-11 13:26:41', 'Arial_10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7881BAF3-CC2D-4ACC-A180-7627B8F0E95F}', 'global', '255', 'textpar', '2025-03-11 13:26:41', 'Arial_15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AD059D56-2ED3-4B87-96BF-DB7029F8AFA5}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{1DB21F0B-0EE9-420C-882B-292F5A2052AE}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Κείμενο 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0E047A8C-0BDE-433D-BA18-7476F5233E41}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Κείμενο 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F925F7F4-69FD-48A9-BB6A-24AC641D9883}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 2.0 έντονα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B569E9C2-6054-4537-9114-DEEC2BE1AD4D}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 2.0 ευθυγρ.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A65754D6-70E3-4CCF-93FC-DA378F895F99}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B6BD6231-974E-4474-8812-326A22B4D841}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 1.5 ευθυγρ.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2EADE2A5-D69F-483E-A6FB-6A9CD7CF5EF8}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 2.5 ευθυγρ.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{ED4CCD5D-983F-4779-BEA8-6AE3BB02489F}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C14F79B6-7CDF-48E5-B804-BDBCCC3FE9CB}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9A4409B7-F5C1-49F4-98B8-1A571E3E0DCA}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B0B57559-A7B4-4C3E-AEB1-4DCFEB88A803}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A86A9826-B453-4F86-9745-903F6C879B95}', 'global', '255', 'textpar', '2025-03-11 13:26:42', 'Arial 7.0');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5FEA97B9-FB9E-4DBB-9ECC-51DE00AB944B}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{85340244-6FA8-4561-9D24-77CD10A105CC}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'ύψος τομής');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{6D19C467-C7C8-4C5F-BCFD-0C558C6FF5F7}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'στάθμες');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C48A2925-6A28-4B1D-999F-D28884B04DAC}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F51D67B8-E922-4FDB-B611-2135A646523B}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8D451856-FB2D-49B3-834A-48CFFBF0FD44}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 2.5 L04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8C92EAFF-8439-4981-BB6D-61DF7F20A16E}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 2.5 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{08A1EC8A-069F-4508-833D-47C01ED82509}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 3.0 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{23A848DC-8F10-4181-B4A5-BE72DC09A10E}', 'global', '255', 'dimpar', '2025-03-11 13:26:42', 'Arial 3.5 L30');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0DB93B51-6EF5-4643-9C6D-CC0022767DC9}', 'global', '255', 'arrowpar', '2025-03-11 13:26:42', 'Πρότυπο');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{689F73B9-4AD1-47E2-8894-FA7F02BF77A2}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Φυσική πέτρα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{13C14995-4EFE-4593-A94A-6ECC42165568}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Διπλός τοίχος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{46337C9D-7F04-4CF8-A404-8A0FAEF61244}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Διπλός τοίχος χωρίς κενό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3A732FE6-A2EB-4AA4-9414-C6030C6D0E4C}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Εξωτερικής μόνωσης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{22675197-BCAB-4686-8754-10616466F2C5}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Εσωτερικό χώρισμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2975CC12-79CF-4205-A06A-A7AF43603730}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Μονωμένο Σκυρόδεμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{471A5D2D-268A-4228-BDCE-98489B1F11FE}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Πρόσοψη με κενό αέρος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{57FF9DF2-68FE-4029-A1BD-1AA91B0C4796}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Σκυρόδεμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0C8D9233-9D90-4D9C-9CC5-A78F8966FF96}', 'global', '255', 'wall', '2025-03-11 13:28:16', 'Τούβλο');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A4884454-F104-4F8C-AF03-9831403FB470}', 'global', '255', 'floor', '2025-03-11 13:28:29', 'Κεκλιμένη πλάκα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2EEC20EF-1F5B-402C-B238-990100BF85BC}', 'global', '255', 'floor', '2025-03-11 13:28:29', 'Πλάκα_Σκυρόδεμα');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{39D377CE-7133-4C9F-9ADA-6F88BDCE2531}', 'global', '255', 'flooropen', '2025-03-11 13:28:33', 'Άνοιγμα πατώματος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CFDE8ACA-E39A-4DF6-87FD-F5036717825A}', 'global', '255', 'flooropen', '2025-03-11 13:28:33', 'Σχισμή');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{78BC1D66-23EB-42B5-944F-6530B84FFA4A}', 'global', '255', 'column', '2025-03-11 13:28:37', 'Τετράγωνη');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C851297F-A3C1-489C-82C9-FF97407A5C88}', 'global', '255', 'column', '2025-03-11 13:28:37', 'Ελεύθερη διατομή');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{75C037F6-21AF-43B9-A4F1-095374D06FBD}', 'global', '255', 'column', '2025-03-11 13:28:37', 'Ορθογώνια');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{008DBCF4-F4C5-41B4-8439-CE986049D5D5}', 'global', '255', 'column', '2025-03-11 13:28:37', 'Στρογγυλό');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8E4BFDA0-9803-46A2-97C1-C33A85BEC77E}', 'global', '255', 'grider', '2025-03-11 13:28:48', 'Πρότυπος');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8BE21932-2C3E-4404-BB90-35DED79F6AD7}', 'global', '255', 'roof', '2025-03-11 13:28:53', 'Αμφίκλινη δίριχτι στέγη');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{276C59D5-1A46-4184-BC62-A5D7A1BB73B3}', 'global', '255', 'dormer', '2025-03-11 13:28:57', 'Βασικός δίρριχτος φεγγίτης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C0114BDB-FEB3-49CF-B4D2-0EBF6055277E}', 'global', '255', 'dormer', '2025-03-11 13:28:57', 'Βασικός μονόριχτος φεγγίτης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{EED22C49-2236-4254-9DDF-26BDB814027B}', 'global', '255', 'dormer', '2025-03-11 13:28:57', 'Βασικός τραπεζοειδής φεγγίτης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8308FBBB-762B-488E-AA55-51C37B34C46F}', 'global', '255', 'dormer', '2025-03-11 13:28:57', 'Βασικός τριγωνικός φεγγίτης');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{91B7989F-698A-4F09-BBC3-6E5CF0F4A2A1}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Αμείβοντες');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AB596FF9-04CC-452B-9723-AFC503AEBA92}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Αμείβοντες αρνητικής κλίσης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5884F035-1488-455F-96BE-CA03197BAA6F}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Αμείβοντες θετικής κλίσης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{112F17D6-6759-4874-905A-D02DCC49F07B}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Αντηρίδα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A1CC2DC5-78E1-4DD6-A03E-3EA91AF71D0F}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Διακοπτόμενες τεγίδες');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{418B4B94-6229-45F0-8723-9B82D082FFCF}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Δοκάρι');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{6BD800FE-1157-49CB-AA8F-BA3033ABACBD}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Ελκυστήρας');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C74A118B-FF0B-481A-925D-DF233038345E}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Κεντρικό ταμπάνι');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{455F7B69-7898-4CA4-83F5-48537315BD02}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Ορθοστάτης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C23FF9B9-CF59-47CD-A3B8-1ECF445FEB6F}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Ταμπάνι οροφής');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{64281213-A12E-43CA-9CC7-2014E6903A1B}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Ταμπάνι πέλματος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{ED09137A-570D-4B1F-AA1A-FF5E17927B14}', 'global', '255', 'roofstruct', '2025-03-11 13:29:21', 'Πρότυπη');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{EE6C464F-DF1A-46C9-832E-919ED18DD515}', 'global', '255', 'chimney', '2025-03-11 13:29:30', 'Καμινάδα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B36FC9B9-B10C-4477-8573-39F684D84AD0}', 'global', '255', 'chimney', '2025-03-11 13:29:30', 'Καμινάδα_προκάτ');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{99205846-AF6F-43A4-BCFC-C789212FB981}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Πρότυπο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{398846B6-DD9A-46D3-BAE6-D46BBFBE7A97}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Γωνιακό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C9D5DD24-3518-42FF-AFB9-0A5813D76A10}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Πρότυπη μπαλκονόπορτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{904F4A5E-4D35-4328-A35A-6FF2E14C8082}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Πρότυπο δίφυλλο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{591C9C7F-9BEE-43E6-9C16-59F2999EBBDD}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Δίφυλλο με χειρολαβή');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{378275A6-366D-4427-AB96-994DA467658B}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Διπλό κρεμαστό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3AEB2EDF-41C1-4B7F-AFCF-5B86028EEEB2}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Παράθυρο με χειρολαβή');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E8082569-3ADB-451B-A8F0-CAA3544A7237}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Πρότυπη μπαλκονόπορτα 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A7067208-D7B3-4E94-9EB6-8F745D7A373E}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Συρόμενη μπαλκονόπορτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D9CC93C6-70C6-467A-98B7-B9562F983C91}', 'global', '255', 'wallwindow', '2025-03-11 13:29:41', 'Συρόμενη μπαλκονόπορτα 01');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B575A6BE-9CD7-4AF7-AA7E-3D08B85F0A01}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Βιομηχανική πόρτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8842B32E-7EC4-4FE0-8582-4C1B74A46C79}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Γωνιακό κούφωμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8C720EE1-03BE-4ED7-AAD6-126555A4F8EF}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Διαχωριστική πόρτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F4518D1D-C950-4E12-B37D-EA1F010CEB2B}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Διαχωριστική πόρτα με φεγγίτη');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E5C2DA39-E6DE-4099-B029-6AFAE23F07D9}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εισόδου με 2 πλαϊνά πάνελ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2D8EC0E1-633D-4307-874E-1CC93B792485}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εισόδου με πλαϊνό πάνελ 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{78FC47F2-B1F7-428F-B647-B436A0D92E9B}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εισόδου με πλαϊνό πάνελ 02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{4ECB968A-B0C4-4CF4-9722-9A6FD8403749}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εισόδου με πλαϊνό πάνελ 03');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{79341854-7AAC-435D-B251-A824AFF798C8}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εισόδου με πλαϊνό πάνελ 04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7FAC5371-02BB-459A-B124-79055494850A}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Επενδυμένη πόρτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CECE28D3-C692-4D84-ABCE-FE981139672C}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα εισόδου');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E5B25EE4-E7FD-4441-A061-B35256B0B7E5}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πρότυπη');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E6BAA7F0-8506-49BD-8757-EC3A154A9B1E}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εσωτερική πόρτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D8567FFF-D08D-46D5-A27E-70E8C499B348}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εσωτερική πόρτα με σχέδιο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{789B2A63-5351-4F2B-9E23-CABC56B18DDB}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Εσωτερική πόρτα με σχέδιο 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7AA6F8DF-0BC8-43C4-9D78-A280D77B3900}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Κεντρικό κούφωμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9FF83E51-5F86-4AA8-82F9-C4FA4FC913E3}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Ξύλινο πλαίσιο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F540EEDE-7394-4FB3-B729-D3E137347A48}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πέρασμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{08B2AAEE-CB68-4EDF-BC10-978B63CB5572}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πρότυπη 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FB8DA0F9-72B6-4831-8E59-B69A2C452C54}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα γκαράζ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{30119DDE-1D0F-450B-973B-1E3E985E1AA6}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα εισόδου 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BBA7DDBA-02B9-4511-BAD4-82E0D29BA4EB}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα εισόδου 02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{DBE7FE5A-CDAA-4233-92BE-CD37807FA3A2}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα εισόδου 03');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8AF14CA0-C455-44A2-8DF6-69BAE271F0F0}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα με κυκλικό τζάμι');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E408726A-CCAB-4C57-9384-C0CF7B3CB654}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Πόρτα με πλαίσιο στον τοίχο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{05FB28A9-A0FB-4FBF-A40E-77DFAF6FC10E}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Συρόμενη_πόρτα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FC44D6D6-A171-443B-BEDF-3280AA5540A4}', 'global', '255', 'walldoor', '2025-03-11 13:30:14', 'Συρόμενη_πόρτα 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5D1DB87D-A3DE-4005-9176-D5598A0C2604}', 'global', '255', 'walldoor', '2025-03-11 13:30:15', 'Συρόμενη_πόρτα 02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A94CABAC-1574-4FA5-A140-99A923D56A8F}', 'global', '255', 'walldoor', '2025-03-11 13:30:15', 'Συρόμενη_πόρτα 03');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C2B51891-8099-4E58-BA02-359E24DBD3B6}', 'global', '255', 'wallopen', '2025-03-11 13:30:23', 'Πρότυπο');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{58A9AF3A-283F-494E-A04C-E2EEE1FBCB8E}', 'global', '255', 'astairs', '2025-03-11 13:30:27', 'Σπειροειδής');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FC52E29C-6C0E-483E-A84D-F34A3BF601B2}', 'global', '255', 'astairs', '2025-03-11 13:30:27', 'Με βαθμιδοφόρ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BA9C58E0-0610-4146-B363-5448C15858EE}', 'global', '255', 'astairs', '2025-03-11 13:30:27', 'Πρότυπη ευθύγρ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{51433E0E-A77B-4B27-AC66-F2A34E6015E5}', 'global', '255', 'astairs', '2025-03-11 13:30:27', 'Μεταλλική');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{502EB57D-BFC5-4FA5-B6C9-A19BA12C7E23}', 'global', '255', 'astairs', '2025-03-11 13:30:27', 'Ξύλινη');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{4519EF5A-691C-45C0-BD4C-258B1904CD23}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Όλο γυαλί');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F21A22FC-FBF6-467B-8700-80B96CBCAB8E}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Γυάλινο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{1506E30D-1AE6-47E2-80F7-5477670F5E06}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Κάγκελα 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C31EA279-9D89-4E98-9FEA-3BDF093906C5}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Κάγκελα 02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{91B77033-D19A-4201-AD16-D53F6FEA405F}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Κάγκελα 03');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FD71C932-05DE-4CD0-9A52-22ADFD0C9E8D}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Με διάτρητο έλασμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3CEDA842-779D-4D71-975A-92BAF20E4A2B}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Με πάνελ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C63A1BAA-CA61-4B21-ADB4-0719FD30C373}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Ξύλινο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{ECB82019-E356-4657-ADBF-626B5667F021}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Συρματόσχοινο 01');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8934D504-4AA1-4730-87E0-DC95425FDD4C}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Συρματόσχοινο 02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{97022220-B05E-483C-8BC3-A38C39024615}', 'global', '255', 'railing', '2025-03-11 13:30:34', 'Χειρολισθήρας');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8231FA3E-2031-4B55-9685-5E78376D17F8}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Επίπεδη οροφή');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{E0E1AE4F-AD6C-4F61-BEF7-1FD363E1BAF5}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Κλιμακοστάσιο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CFCCDE69-9FA7-4C37-9201-16FA0D0E3195}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Μπάνιο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{4ADC5197-1BC9-47C0-BA3D-E2C51043BC72}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Σαλόνι');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CFB9E039-5E10-42A9-B15F-418EAC417D41}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Ταράτσα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CD832381-7279-458D-93C9-9F1208DB2119}', 'global', '255', 'room', '2025-03-11 13:30:43', 'Υπόγειο');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F30DBE7B-E0D8-49E6-B946-18D4E44ACCD1}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Διαβάθμιση μέσω σημείου');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{64C6FB07-95E7-45DC-99F7-4B5B9ADF3B1E}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Κονίαμα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{23701049-E85A-471C-B8E7-BD8AD5E91A43}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Μονή στρώση');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0F990F74-846E-4A2B-8D8A-27962F3E9BCA}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Μόνωση');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{350FFDFD-55F3-44B6-86B5-BAE480955A7C}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Πλακόστρωση επίπεδης οροφ.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C0409160-EAEF-4266-A85D-9503F85E9799}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Σκάλα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3BA5414F-632E-4BC6-8BDE-DBAF6910AC0A}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Χαλίκι επίπεδης οροφής');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BD9B4257-58C5-4C90-81BF-DE2D21143F91}', 'global', '255', 'roomfloor', '2025-03-11 13:30:45', 'Χωρίς μόνωση');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{6481E02F-C1A5-4C1E-A754-AA855D43C128}', 'global', '255', 'roomceiling', '2025-03-11 13:30:45', 'Οροφή δωματίου');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9542580D-91B4-44A2-B36D-9174BCE89584}', 'global', '255', 'roomparam', '2025-03-11 13:31:09', 'Σχέδια εφαρμογής');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{54E2C469-7871-4DE8-944C-E13723F0E4B0}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αντικείμενο πολλαπλών στρωσεων 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F01169C0-296A-4D97-A81B-BF133517491F}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αντικείμενο πολλαπλών στρωσεων 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{8668BD80-18D5-4D7C-A1A2-6D1E279D8F95}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αντικείμενο πολλαπλών στρωσεων με επικεφαλίδα 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A0DC8380-1F04-4B13-ADC7-D5107E7C1344}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αντικείμενο πολλαπλών στρωσεων με επικεφαλίδα 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7201491A-6D63-4E94-AB93-EC307E7319FD}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αριθμός');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D89E2DB8-C1F6-4FFD-9F7F-7FD043338012}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αριθμός παραθύρου');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{796DD113-B4CA-4A4B-BFAC-FB0E1CD9CE22}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Αριθμός πόρτας');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{446FE137-AAD8-4EB9-B4E5-6F314B102C84}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Ετικέτα δωμ. για τον τομέα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C52DF93D-224C-4166-B976-5661B82A1024}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Ετικέτα δωμ. για τον τομέα 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C846E33F-D37A-4B15-B8D1-31A950547178}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Πρότυπο 3 σειρών');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{81E04E6D-A058-40C0-922E-014E316B9506}', 'global', '255', 'attrlabel', '2025-03-11 13:31:26', 'Πρότυπο 5 σειρών');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0C244705-DE98-4894-A928-363DAB12A74B}', 'global', '255', 'layerlist', '2025-03-11 13:31:55', 'Προεπιλεγμένο');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{65AFDD49-856B-404B-87EF-3900478AC007}', 'global', '255', 'bs_sewer', '2025-03-11 13:34:34', 'Διαχωριστής');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{FB104134-060D-4301-893E-A53A523FA798}', 'global', '255', 'bs_sewer', '2025-03-11 13:34:34', 'Συλλέκτης λάσπης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{118436EB-DB70-4145-A668-5FF7D55D0516}', 'global', '255', 'bs_sewer', '2025-03-11 13:34:34', 'Φρεάτιο αποστράγγισης');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AC36166F-FCD5-4DDD-99C9-AE073780C845}', 'global', '255', 'bs_sewer', '2025-03-11 13:34:34', 'Φρεάτιο επιθεώρησης');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D5831E92-9A4C-4227-9F0E-2948F2DB77D6}', 'global', '255', 'bs_line', '2025-03-11 13:34:41', 'Επιφανειακά νερά');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2B484617-DBB3-4AD6-B30E-98F0A5CA23F7}', 'global', '255', 'bs_line', '2025-03-11 13:34:41', 'Λύματα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{966BC326-DEDC-4371-808C-48A3AAEE1109}', 'global', '255', 'bs_line', '2025-03-11 13:34:41', 'Συνδυασμένα λύματα');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5ECCF1F3-8400-4155-A506-0157AC1F97AC}', 'global', '255', 'bs_line', '2025-03-11 13:34:41', 'Σωλήνας αποστράγγισης');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2F618418-113E-40BF-B19E-698C8CC981AB}', 'global', '255', 'grid', '2025-03-11 13:34:57', 'Πρότυπο');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C2CEA1EB-E93A-43EE-9A4A-53545D12B150}', 'global', '255', 'grid', '2025-03-11 13:34:57', 'Πρότυπο μεταβλητό');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{5668A639-552D-4A57-9BB2-0C9D91F09C8C}', 'global', '255', 'grid', '2025-03-11 13:34:57', 'Πρότυπο μεταβλητό_1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{6DFA8A85-8692-45AD-A215-F15EF64E9C67}', 'global', '255', 'grid', '2025-03-11 13:34:57', 'Πρότυπο_1');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0031634D-BA39-41FD-86B4-2F467CEAB17C}', 'global', '255', 'printpar', '2025-03-13 10:58:56', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{89BEC8B6-9658-4F6B-A0CA-DA943F0A3A66}', 'global', '255', 'attrcolpar', '2025-03-13 10:59:04', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{07E3305E-83D0-4EF7-997B-FF6A7011A889}', 'global', '255', 'attrcolpar', '2025-03-13 10:59:04', 'act');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8766AA84-043A-4572-AEF0-677314E2D8AA}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Les');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B89C385F-3B53-4F21-B562-92A9F87931B4}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Vertikalne črte 10 mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AFC0EC41-8420-4F12-9E15-9D00C96EB480}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Vertikalne črte 4 mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{27FF8D14-879F-4354-B964-0329DBD0871F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Perforirana pločevina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{44B27602-72A2-46C3-AFDE-76018C9AC981}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Vertikalne črte 2 mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{01C376E8-EBB0-480A-B772-8750B3B1E7C0}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Obstoječe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{877B21D0-6081-45F2-A0CA-BA92EA8A551C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0F86327E-9E5A-4379-8D5D-249FFF203915}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Rdeča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4C59B4F9-A801-41F3-B657-18F7EA95C22E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Prodnata obloga');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{ADBA4FEF-83E8-4225-AB9B-FBE15D848074}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 6');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A512CBB9-9040-4D86-87DB-1DA89836A5C4}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Lahek material');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3078171F-CE86-41F4-A04E-E4BF19E9D72C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CD5DBFD4-17EB-40AA-A3E7-6B508D6F926A}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B6CF9AF6-6315-4880-8539-CF44F525EACF}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Suhozid 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CBDCE3B5-BD13-4ADC-8F7B-63AC5C81A1B1}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Suhozid 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4898ED93-98B6-4F41-B1D2-B52ABCBCE61B}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Strešna opeka 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{2829FC94-6128-48D6-AD4C-878DC2615B43}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Strešna opeka 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8D8BD7A6-FFD1-40AA-8249-D095336CC324}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Prodec');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6E9C03CB-456E-4B63-9AD8-2289B1C482CF}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Horizontalne črte 0,4 mm');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E14105A3-243D-4736-972E-DE3F81F9E476}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Izolacija 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{960A52F4-A134-465B-AF45-1B3AC9ED0819}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Izolacija 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{956FB9D5-205A-4793-9C57-C29540F6863D}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Hidroizolacija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1122D309-144E-4D56-89C6-8DB41DA8EF2C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 7');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9ED62C3A-1191-4AC2-91D5-DBA46746E0BC}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Krogci');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{80320BDB-84E5-42AE-94D8-8F1896283571}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 8');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{82C03E2D-5CE0-4627-82E2-4817CB979B43}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 9');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{944DDA85-C48B-404D-B6D8-2051EA3DE1A3}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Marmor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{94843154-E199-4EC8-92DB-54B54301B49F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Opečna stena 10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{463A2A8A-6269-4AA3-AF25-CD6F14DDA401}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Naravni kamen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E50B4CFB-6BEC-4886-9DAC-0F782F3B651C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Nevidno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4FE07364-0291-40E8-BCB3-929DD368692E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Lahek material');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{23472723-E184-4D9A-A3AC-967F9FFA72FD}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Rušitev');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{84464194-9CA7-426A-862F-F490AFED620F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Standard-3D');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C0904864-520A-46EE-B8BA-7058557E7B26}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Standard 3D');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5FD087A2-B903-4AB7-94BA-660973A03D76}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Peščena obloga');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B15FDB67-C500-44E5-9F5D-D3D997021CED}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Obstoječe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9ED81D38-9B10-4F3C-B6DD-E1E0B040F56F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Les');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F074EC0F-D3F0-47E5-A22D-F75D57A52CB5}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Rumeno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DE6B65DD-A29C-47D7-A4F9-07C14C619B55}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Opeka (izolativna)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6DCE2311-62E2-44BB-A2CC-013C7A460121}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Steklo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1B0A90CB-D931-4ED6-B93F-7272A0DDF70C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Plošče iz naravnega kamna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F9597AE3-5D13-49F0-B926-48D5CC528D5E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Opeka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CAE1AF93-8B6E-46F4-98E4-91ED0AB4209D}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Opeka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EA69D377-8E84-4487-BD53-D26931CED2E7}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Senca (prosojna)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0DAB0A1D-6298-46EB-B5A7-6A07A844CDFF}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'Omet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BD490E6D-5BD0-4F38-A388-6A2825EF7DBA}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Armiran beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{27F81EE0-D522-4464-A73A-316BAD02F16D}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Arm. bet. (vodotesen)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D48ED507-7F15-4A73-8AA8-6F1C8417E224}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Opeka (izolativna)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A75C8297-BB97-4C4A-84C4-43E7F3AE2ED6}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Naravni kamen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8FD1C7FA-6408-4431-B475-27996A44EB3C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Arm. bet. (vodonepr.)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{01150803-0C75-4822-BC17-192BEB7AC2DB}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Izolacija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CCDF6A7A-B5D6-41F4-8CEE-112C3678020E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Utrjeno nasutje');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{875F90F4-0655-4740-9D11-82A75B62AE5D}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Trda izolacija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4C0CBBDA-1A6B-4CD6-8747-89ED38C9B02E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Novo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8D69635B-C984-4732-82FC-114043E7ADDF}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Nebo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{485D1E47-AA33-4F67-9E55-02E6BD4A0907}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Lesen material');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{62C9926E-F50C-4A8E-B565-9E7F55A6C05E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Kovina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EA6BE24A-A901-4CAD-86A9-824819205CDA}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Prefabriciran beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A8EEB79E-F9B7-4CB7-B230-D6EEAED7E0EE}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Arm. bet. (vodonepr.)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{29E7CD01-0C3E-4E0A-B802-20EF33AE6487}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Betonski estrih');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C45CBAFF-1C17-4A8D-8415-625FF43C1579}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Mavec');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{719A41CA-4754-4147-859B-4A74436536FB}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'PZI Kovina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9F529D67-B64C-4C6A-A637-C73B5BC98FD0}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Jeklo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DE367776-1A4C-42E4-98A1-84B895CE50B6}', 'global', '255', 'hatchpar', '2025-03-13 10:59:11', 'DGD Teren površina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4534958F-E5C5-4D6C-856B-73888DA856B9}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'DGD Lesen material');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D6EB62D1-BC4F-4597-95C0-8251E6A5EE10}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Izolacija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A909AB3E-EF25-4B7B-A66F-25C95242D2EE}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Prefab. bet., izolat.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6ABC9154-D869-41F6-8263-7A4DE28A8D84}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Razraščen teren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8FAFB57F-D369-4C43-9349-CD9C650D6B02}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Naravni kamen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E2D699F6-1223-454B-86AA-2A25E1DB39BE}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Jeklo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{2DC7E082-6A5C-48D2-9CFF-13B866E70703}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Zemeljski sloj');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{96C0F2A4-176D-4D09-ADBF-264CBF25C03F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Izolativni beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{235735BF-9C3F-4391-82F9-CBC3F3BEBB6F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Črno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B38F6C95-7A4D-4D95-A32C-8A5C924F35C1}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Valovi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{66D73A95-1B98-41C2-859F-FE95DCC9EAC8}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Utrjeno nasutje');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9F60E077-706E-4927-981F-16CA06863B95}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Streha');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FFD2C70C-18E0-49A7-956F-6B663BF94EFE}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'DGD Armiran beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8803CEFE-FA4B-4AC9-B74F-82EE68EA0E96}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Temno sivo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{52CEB772-4211-461A-944C-B7B12B622DAB}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'DGD Prefabriciran beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{60BCFFFB-2841-4C23-A841-7E557CBE1C8E}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'DGD Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{984191F8-158F-43D5-8D47-7B7269C54F8D}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{62DD73CC-92AA-4083-9000-1607B0218BE2}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Rušeno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5684BB3C-791B-49A9-A25D-603192C1B8D9}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'PZI Trda izolacija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{16446550-9166-4101-9584-F35BD2B2F2EF}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'DGD Teren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6B7B414B-2BEC-44FF-85E5-D5B3CF490FE4}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Svetlo sivo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EC54F15F-B47F-48A6-810D-3CB45E7A0A82}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Opečna stena 5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EF12224E-EB0E-4227-BCB7-F3450571980C}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Okenska površina (siva)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{36FD96D0-2016-4664-8987-12F8274BA6E0}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Ploščice 60x30 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A8F17064-1EA3-45E5-94DD-1BC914782FB4}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Lesena obloga (poševna)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CA4F3A21-5878-44B9-BEC9-317A19A2E6B2}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Križ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CD676A94-ACA9-4345-8A75-7D23CAAB7FE0}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Izkop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{41C7E0B7-29D0-42B6-B5F0-4FF1A773AB83}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Estrih');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EF371E2B-E5BC-4AC6-88C7-1C3471D38CF8}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Okenska površina (modra)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F5449C0F-481E-4DE4-BFA4-292FEF5332D6}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Sivo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9BC2F364-E3FC-4650-B58A-1407C4083D4F}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Ploščice 60x30 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{31477D81-E1B2-4302-9675-A470F428F7B4}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Lesena obloga (ravna)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CFB664BE-FE8A-4962-A122-38C58BB65359}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Plošče');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{94799773-E2EC-49AE-AA03-8DC4809A8C6B}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Pike po ISO2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{08CD7169-467C-4823-A076-E552ED734CB7}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Pike po ISO4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{32BEA1D1-46E7-474D-834B-0509501582D2}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Obloga');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FA096FFA-5407-4100-A4DF-58627CF999E5}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Senca');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{46C1D611-127E-4327-ABB6-5CCA784EE667}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Ploščice 60x30 zami 1:100');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3FE1E74F-FF93-4A81-A1B0-D482BF4EF569}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'Ploščice 60x30 zamik 1:50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5C0F928D-7F62-44EC-902E-B852C3E85431}', 'global', '255', 'hatchpar', '2025-03-13 10:59:12', 'MK plošča');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B6DFC018-3EC6-40F1-A3AF-75413203013C}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AD01A996-FBAE-47FD-8931-87410C119BEF}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 1.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AB304092-789C-421E-8F2F-D48D61A8F891}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DD81F1B2-D0F0-40A1-8EE8-CE615ED825EA}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.0 odebeljeno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B22F7E2F-3B37-430B-82EE-E680524A0711}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.5 obojestransko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{482B9229-6F6A-45EB-AF6D-E16456CAD5A1}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5704B6A6-50AC-4CD6-9A48-F202EE607D82}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.5 odebeljeno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BD2D41B2-605F-40B5-8A70-3228E68BA083}', 'global', '255', 'textpar', '2025-03-13 10:59:49', 'Arial 2.5 sredinsko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F0A179CD-113D-41A7-BAFD-E1A9B9ABB847}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 3.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CECC75E6-7EC0-4C25-960A-915972B9122B}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 3.5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{51420E68-F2CF-47BF-BC77-6CA31DCAE50E}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 5.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3C9B4D83-4935-4E9F-83E7-658FAE7B2EDA}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 7.0');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1DE746DA-9FB0-4A9D-A262-973E657D40E2}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial_10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0CA38D06-856A-4DE4-8DC5-F65AEEA359CC}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial_15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C66EBC74-44DC-4DBA-A3B6-F902756DC8A4}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Linijsko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4CA3F391-B265-4A1C-AA71-3715130B5B6D}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Sredinsko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DD00E0F3-9D69-4F87-B392-B3A67D47AA71}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 2.0 obojestransko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1605C6FD-1BF2-4CC2-BCBF-165DCE15E185}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 3.0 sredinsko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F402D3AE-A7B8-40A2-8F75-2DF05ABD970A}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 7.0 v okvirju');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{97D31D04-03E5-4EE7-A966-A5DCE039E96E}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Teren');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F5A3C73E-560B-43CB-82EA-9B6453C7D8BA}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 2.0 sredinsko');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8A039CF5-C90D-40B1-BFB6-DE9E0E0249FC}', 'global', '255', 'textpar', '2025-03-13 10:59:50', 'Arial 1.5 sredinsko');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5706FEFF-2506-41B7-839B-D00EF8CD5F40}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.0 L02');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BEA18CD0-0F2E-4DCB-B244-1205F3B286FB}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{45836B41-F4EE-4558-8FEC-349B4B1813B8}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.0 L15');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0150B424-74E1-42BA-B821-C3EB5DF84F7A}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.5 L04');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{89362747-1020-46F8-86AE-E185F5B9BA61}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.5 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C4499527-01DC-44EB-A8C0-C6335D811556}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.5 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{51B23676-EC67-4F7B-AEF1-8FADC766D2B1}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{07ED2FC3-E4E6-4512-BED0-D848D5D7601C}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Višina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{26391241-CB32-460E-818E-1334B9FFD847}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 2.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6C1C2D99-8D24-4608-A710-FA52FFA7AC51}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.0 L06');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{57489A14-DD14-42BA-AE13-4BD8D41E5752}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.0 L10');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{835C2501-B86C-4AC7-8C2D-4F90A1AAC9C6}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.0 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5B63B87D-34A6-4EA3-97BE-E7D69174A3D4}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.0 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E1EBDD68-0725-434C-9264-403392257503}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.5 L20');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5702AF24-6D62-4520-B3C3-4DEBAD68922C}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.5 L30');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B35ACF4C-6B06-4B95-8569-1236FE8BC8A6}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 3.5 L40');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CB59C1EB-8712-44D5-84DC-21B4B0683165}', 'global', '255', 'dimpar', '2025-03-13 10:59:50', 'Arial 1.5 L02');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{93D60901-3786-418A-AC3A-288EE43D0AFB}', 'global', '255', 'arrowpar', '2025-03-13 10:59:50', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CF73D680-827F-42F8-A468-070F1BC99F46}', 'global', '255', 'arrowpar', '2025-03-13 10:59:50', 'Standard točka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{22BACE85-A83F-4F58-8E3E-F0024B3C9F01}', 'global', '255', 'arrowpar', '2025-03-13 10:59:51', 'Standard polno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5E9BC41C-AABB-47E5-B7C9-3549046F05F6}', 'global', '255', 'arrowpar', '2025-03-13 10:59:51', 'Standard krožec');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{04BAD512-1FDD-447B-B29F-5BB6D5C3B6FC}', 'global', '255', 'reppar', '2025-03-13 10:59:52', 'Les');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D82B8A6F-F643-4476-97BE-0B8230244273}', 'global', '255', 'reppar', '2025-03-13 10:59:52', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5A8B64D6-9EBA-446E-B62B-411C9EC37EFF}', 'global', '255', 'reppar', '2025-03-13 10:59:52', 'Prefabriciran beton');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8BB458C1-6DA3-4B7E-ACE8-DA796772F53C}', 'global', '255', 'reppar', '2025-03-13 10:59:52', 'Teren');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7F94E076-B578-43E4-9CCA-0EB52D739BCD}', 'global', '255', 'views', '2025-03-13 11:47:47', 'Idejna zasnova');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D2D3D8F5-1002-472F-9B3E-C5FEE0A4B5B7}', 'global', '255', 'views', '2025-03-13 11:48:00', 'Dokumentacija za GD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{39B685C0-DF20-414B-9FEC-C720EF6DA3DD}', 'global', '255', 'views', '2025-03-13 11:48:07', 'Projekt za izvedbo');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CEF5B0B7-709F-40A7-A885-980CB1647EA3}', 'global', '255', 'wall', '2025-03-13 11:50:58', 'AB stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7EB7D95D-5AF6-4039-9C0A-C20DFCFE0E51}', 'global', '255', 'wall', '2025-03-13 11:51:55', 'AB stena z izolacijo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F9D5C71E-80E2-4D6A-89B7-2A45D95D7E50}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Betonska stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9A5F5C48-A563-4CDC-A879-21250EF59E90}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Notranja porobetonska stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6BD94ABE-640A-410F-A7A5-08DD5BF16FDE}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Notranja stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{61D3432C-5648-459E-904A-3E598570241D}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opaž roba plošče');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DB0462EC-4243-403A-BB17-CD363CFB56F6}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opečna stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9C45B9F5-A58E-4D3D-91F2-AF876D9531EE}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opečna stena s klinker oblogo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{88208E95-811F-4874-95D8-D5D9D7E99FCA}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opečna stena z izolacijo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{921B1CE0-CA1E-4949-9FF4-C6036871C0FC}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opečna stena z leseno oblogo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5EE8DB25-C019-4F0D-A7AD-BEAE94CB584D}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Opečna stena+izolacija+omet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B81ABE28-821C-4D00-8FE4-B6EF1A89B5CF}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Porobetonska stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1615CA8B-C8E9-4443-9264-7B1A6758DD10}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Porobetonska stena z odprtino');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{817D5228-ED6A-4C28-82A1-D18B93E3EF33}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Prefabricirana betonska stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6DA5B366-92BB-4E11-B0C8-6E53C4414F1E}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Stena');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A1283FC4-A9B9-4217-BF28-686E2F5A9C19}', 'global', '255', 'wall', '2025-03-13 11:51:58', 'Suhomontažna stena');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{75EAAC16-E272-42B6-B076-38C029184692}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Lesena plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C9C7C387-A32C-4671-9AD8-CA229AEE7002}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Plošča z naklonom');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7F791785-AD62-49EF-98D7-5DA1124CD7DA}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Prosta plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1EA544DD-4D9D-4986-BD9B-B7DC8C9622CD}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Spuščen strop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{62F7D313-8DA6-4F5D-BD9C-7845B6F027CE}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{679C0425-22FE-4265-AA9E-DBA260074CED}', 'global', '255', 'floor', '2025-03-13 11:52:07', 'Temeljna plošča');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3E8C37F4-A20C-4245-83BE-2E42B258C997}', 'global', '255', 'flooropen', '2025-03-13 11:52:13', 'Odprtina v plošči');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B1D35E95-22A5-4A8F-9551-44BD7F532694}', 'global', '255', 'flooropen', '2025-03-13 11:52:13', 'Odprtina v stropni plošči');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BB7BFA25-51D0-4861-9CBD-7A6C0862DBFC}', 'global', '255', 'flooropen', '2025-03-13 11:52:13', 'Utor v plošči');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9D7EF53B-3494-4424-A838-68E0FD59B5F5}', 'global', '255', 'flooropen', '2025-03-13 11:52:13', 'Utor v stropni plošči');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7B40059F-A4A5-4C46-A02F-2ED0FCAF44A9}', 'global', '255', 'column', '2025-03-13 11:52:17', 'Betonski steber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{63D2E6ED-E1D1-4819-B4FB-76B540B33BFA}', 'global', '255', 'column', '2025-03-13 11:52:17', 'Lesen steber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FFF3A622-4078-49AB-BA3F-17CC1D5D791D}', 'global', '255', 'column', '2025-03-13 11:52:17', 'Opečni steber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{502A1F7E-8E5C-498E-8B61-96EAD79B31AF}', 'global', '255', 'column', '2025-03-13 11:52:17', 'Prefabriciran betonski steber');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{84F7D655-325A-457B-8446-9E0BBFFA5BEE}', 'global', '255', 'grider', '2025-03-13 11:52:21', 'Lesen nosilec');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0FA4DE99-E76B-457F-9549-2A031BC15819}', 'global', '255', 'grider', '2025-03-13 11:52:21', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D076CF9E-7767-458A-A6C0-F5768DD1C697}', 'global', '255', 'roof', '2025-03-13 11:52:26', 'Mansardna plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E209B424-0069-4F89-80BD-DC517BAB3B77}', 'global', '255', 'roof', '2025-03-13 11:52:26', 'Naklonska streha 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F97553EB-5148-4126-9A07-835CE20EE6D0}', 'global', '255', 'roof', '2025-03-13 11:52:26', 'Naklonska streha 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F7509CD2-5FA1-4C3F-9B52-CB039C83C122}', 'global', '255', 'roof', '2025-03-13 11:52:26', 'Standard 3-slojna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{04927F6B-948D-4AC8-A40A-D9011177DAC7}', 'global', '255', 'roof', '2025-03-13 11:52:26', 'Strešna ravnina');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FCBA9017-D834-44A8-96D1-7F8F3BBC46F2}', 'global', '255', 'dormer', '2025-06-27 05:39:37', 'Frčada s poševno dvokapno streho');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4748BEBA-65C8-4EBD-94E0-94BFE5BBBF3D}', 'global', '255', 'dormer', '2025-06-27 05:39:42', 'Frčada s trapezno streho');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C2E528DA-494E-4DA8-AC29-25CF19D9D20A}', 'global', '255', 'dormer', '2025-06-27 05:39:42', 'Frčada z ravno streho');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AFC9E19D-2989-4A56-BCB3-1C553B2BD37C}', 'global', '255', 'dormer', '2025-06-27 05:39:43', 'Nadstrešek nad vhodom z dvokapno streho');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{958AF8FB-6870-4FFC-89F8-53262EA20252}', 'global', '255', 'roofopen', '2025-03-13 11:52:57', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B19E4145-CE3C-46D4-BA1B-8CA4A16438B1}', 'global', '255', 'roofstruct', '2025-03-13 11:53:06', 'Strešna konstrukcija');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{82579FD3-3D83-4587-A25A-31639646A2E5}', 'global', '255', 'roofstruct', '2025-03-13 11:53:06', 'Špirovec');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8B031579-5FE8-40A4-B647-AF27F7C06614}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Slemenska lega');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7C9922AE-2B42-4566-9D18-BAF0736DBDE8}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Čop');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DB1C5388-BC2A-4C88-B63C-47E158620F6E}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Klešča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{04D8FCBE-F8BA-4D3E-AC4A-729359832DAB}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Ostrešje');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{26CA4EA5-B7C9-4CB7-B35F-3BD10703FFE8}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Ročice');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F3516716-0F6F-419A-97A5-22758BCFB90A}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Kapna lega');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C8449AE7-5A15-4CF8-83D1-1A77AE6A8BC0}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Steber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D901313F-3D99-4F5E-B9A5-B1C0334C518B}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Žlota');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{46FA7BAB-C710-4E54-AB9A-97C6DCCE6666}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Vmesna lega');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{06E65A87-02D7-4936-913A-9897DA2C5B83}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Menjalnik');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{23FF58F7-9380-4594-9B31-A1D2B9BFA513}', 'global', '255', 'roofstruct', '2025-06-30 07:28:38', 'Tram');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7004A701-B7D4-45C4-B2CF-EA1CF4D486D5}', 'global', '255', 'chimney', '2025-03-13 11:53:14', 'Opečni dimnik');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{83826246-1624-488E-84F4-E403CCF4D0D4}', 'global', '255', 'chimney', '2025-03-13 11:53:14', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1EB774A5-A169-4279-895E-B0A9F0362044}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', '1 Okno s preklado');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4F5AC39B-94ED-4FB8-996E-4D59933EA529}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', '1 Oknoz zapiralom');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{08598CFA-4B68-482B-B928-CCB96B6E1BC3}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', '2 Dvokrilno okno z zapiralom');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D5E4BE3E-ABE3-4D1C-97E1-512272F8C974}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', 'Drsno okno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{60A1681D-1B3B-4FD3-B0CA-6E37C9F987C8}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', 'Fiksno okno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{55C3F02E-B746-4472-99E0-8F6C3143B5DB}', 'global', '255', 'wallwindow', '2025-03-13 11:53:24', 'Okno z žaluzijo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3D799E9D-3F92-4AEC-90E5-79F239081971}', 'global', '255', 'wallwindow', '2025-03-13 11:53:25', 'Okvir okna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E63BEB61-54A8-4BAB-936C-644F96F03D67}', 'global', '255', 'wallwindow', '2025-03-13 11:53:25', 'Standardno okno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CF36CC7E-220D-4BE6-92B1-CB4BBC3ED44A}', 'global', '255', 'wallwindow', '2025-03-13 11:53:25', 'Visoko okno');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EE73D309-C53B-4F6F-9727-3073EF208BB1}', 'global', '255', 'roofwindow', '2025-03-13 11:53:24', 'Velux naklonsko strešno okno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0D3BA4AD-9E32-4F9F-B137-71FD1C064FAE}', 'global', '255', 'roofwindow', '2025-03-13 11:53:24', 'Velux strešno okno');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{45623ED0-D8E8-4D00-B942-3F8D42E7D1BF}', 'global', '255', 'walldoor', '2025-03-13 11:53:43', 'Drsna vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9D06AC25-7A46-4B67-9DEA-A142FCAB6D4A}', 'global', '255', 'walldoor', '2025-03-13 11:53:43', 'Garažna vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CB5EDAE5-6C76-4456-AA74-33260FFFCADA}', 'global', '255', 'walldoor', '2025-03-13 11:53:43', 'Industrijska vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{2BA82493-0DD4-4312-8943-0056336B688D}', 'global', '255', 'walldoor', '2025-03-13 11:53:43', 'Notranja vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{05DCBE0E-A1EC-483A-BE33-536ED7D6D39F}', 'global', '255', 'walldoor', '2025-03-13 11:53:43', 'Notranja vrata 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C14A1746-F949-4522-A23D-5C9A10C0E9EA}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Notranja vrata 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{2E5C4F14-8B36-4030-B33C-248AF4CFCA1E}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Notranja vrata 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{323BEB94-EA31-4627-8FB7-04547B5217EC}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Sanitarna vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{798F86A4-6391-46C2-BA01-B31286DB1364}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Sekcijska vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{84BA975F-7F37-4103-B511-457DEAA4917D}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Sekcijska vrata s steklom');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A9F5162A-5B07-476C-AFA7-0C6FFB54E1B5}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Standard');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0C79A2CD-3E76-489D-A89A-428F392ED67C}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Vrata s podbojem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EC8C98EC-1ADF-4459-834B-83B66E502F33}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Vrata s podbojem v ravnini st.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9E9B54C0-77D3-45DB-8BB7-8C1F3A096CA9}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Vrata s slepim podbojem');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8B53D4A8-7246-4FC5-8BE8-3660A752DC95}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Vratna odprtina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{182620C6-B467-4D58-94D8-C197CF6361A9}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0921C9E9-900A-41D6-9A74-34918CB0A719}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{59631194-9FE4-4B88-BDC9-5549BC756472}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FA00AEDF-DDF2-4E91-ABCA-292109061250}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5ED14BBE-9E31-4104-A66D-B1F21B3F6643}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 4');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4F9A1E15-162E-4B5C-8489-44F853FA9702}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DE4CF899-0181-4933-84F5-8357101E78A1}', 'global', '255', 'walldoor', '2025-03-13 11:53:44', 'Zunanja vrata 6');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0D79F72E-69E3-42DF-98FF-EB3502EB704D}', 'global', '255', 'wallopen', '2025-03-13 11:54:06', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1B89B81B-3DE9-4DB3-8DA8-C9118433CFA9}', 'global', '255', 'astairs', '2025-03-13 11:54:13', 'Betonske stopnice');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{ECE80CE7-E601-411B-B594-70B08CEE3FCF}', 'global', '255', 'astairs', '2025-03-13 11:54:13', 'Jeklene stopnice');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8AFEA1E4-E964-448A-A856-A6E9B3422A09}', 'global', '255', 'astairs', '2025-03-13 11:54:13', 'Montažne stopnice');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{75EB6D54-4539-4A25-8120-80CAF670ECE3}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Držalo');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BAEE31AE-078E-4F36-9E4A-FAA0F20488AD}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Kovinska ograja s polnili');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B65D27AE-0C9A-493B-8A64-69F45D13FEBF}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Kovinska ograja s st. polnili');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BC1A6DF7-00A0-46E1-A847-EEB92341798F}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Kovinska perforirana ograja');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{8EE62EE2-4EE4-4582-876C-694A69A8C624}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Lesena ograja');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0CDA8462-8B53-475F-85C6-A22202E6C4E0}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Ograja z jekleno žico 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{60AA99AD-FDF8-44A2-BE98-9E0F5BD048F2}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Ograja z jekleno žico 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{641F0346-4D69-4D6C-B2D5-FA399C34B920}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Skeletna ograja 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CAD83AB3-61E3-4639-B1ED-1A14E8B5EFF4}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Skeletna ograja 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{331E9DC9-D0BD-46BA-AD53-94ECDC910A8F}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Skeletna ograja 3');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F8DAC302-C9E5-432B-8AF3-C4964026A525}', 'global', '255', 'railing', '2025-03-13 11:54:18', 'Steklena ograja');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AE9C14A3-D21D-4C94-B480-32E238C60376}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Bivalni prostor');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{98678B65-78A5-4BA1-B488-39250E12D46D}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Klet');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6266E944-4D72-4310-BA15-B1A5B38EAD2A}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Kopalnica');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C55C5EDA-165B-4957-B1F8-FF1CAECE0DAE}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Ravna streha');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C213DC3C-2F90-4552-95B8-FC921B76B621}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Stopnišče');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D34292CC-F114-4CD9-A19A-5D3F6880F230}', 'global', '255', 'room', '2025-03-13 11:54:26', 'Terasa');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BE4D4500-6952-4C4F-AE73-07F694A7FC53}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Estrih');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5087AB29-ECB0-4AA8-87E3-8FC268BA55C1}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Pod');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C0DB5688-E437-455A-9339-3F52D2E35782}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Ravna streha');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{93FA84FE-5351-4873-8DF4-2D18DAE56932}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Ravna streha s klančino');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{246CC2D3-EAEA-447F-AA0C-F329187E886F}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Ravna streha s klančino 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B8752D6D-2B61-4988-BF46-ECCA97C0ECEE}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Tla');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0597E0A0-EDC3-4E3D-B931-AE984DFDB293}', 'global', '255', 'roomfloor', '2025-03-13 11:54:27', 'Tla s padcem proti odtoku');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{928CDE83-DCA9-4518-AEDA-825ED699FFBF}', 'global', '255', 'roomfloor', '2025-03-13 11:54:28', 'Večslojna tla z izolacijo');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A975B5E0-8B48-4808-83A0-81DED8A21C5B}', 'global', '255', 'roomceiling', '2025-03-13 11:54:29', 'Strop');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A9FEB617-7B4E-4DD0-8B5F-2F9A49E5B630}', 'global', '255', 'roomparam', '2025-03-13 11:54:46', 'Dokumentacija za GD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5CE7D21E-420E-4203-A643-C04570726E64}', 'global', '255', 'roomparam', '2025-03-13 11:54:46', 'Idejna zasnova');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9D9C6323-E8C1-4CD8-8A55-5C5032987F6F}', 'global', '255', 'roomparam', '2025-03-13 11:54:46', 'Projekt za izvedbo');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{168D3BD5-3672-4DFF-A0E2-5E62AEAA3CAA}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Oznaka');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{4ACC941C-ADF0-425B-A649-7ECB53AA37F6}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Oznaka okna');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E94A3479-AB2F-4415-A917-F1BCA8E6CB8D}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Oznaka prostora v prerezu');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AA0112B8-6FC1-4AAA-810D-F0683337DB3D}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Oznaka vrat');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{DF5D9FE1-F6B5-436C-B2E8-2CF68215DAAC}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Standardna oznaka 3 vrstice');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{3DEAC881-29B0-4D0C-8D50-BCA035003B39}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Standardna oznaka 5 vrstic');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{517270C4-7016-4E5B-9593-D4BD0D79D34A}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Struktura plasti 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{09618169-4972-4902-B9B8-27526317D87C}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Struktura plasti 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B8FFA8C2-C197-4D0C-9D41-8B96F6370E28}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Struktura plasti z naslovom 1,25');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{E1C05E80-BC1D-4102-978E-4389BA1F7307}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Struktura plasti z naslovom 2,5');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{D38362C1-5AD8-48A7-9F17-0FFC9F9F3216}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Struktura plasti z naslovom 2,5 EPD');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{54566A03-2F2F-48AD-A929-120AD0BE682D}', 'global', '255', 'attrlabel', '2025-03-13 11:57:19', 'Žig za izdelavo plasti');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{1B370FC6-2D06-4209-AE02-8B6DE751E630}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.25 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{EAABF6B6-AE45-4D6A-8181-83298478FAB9}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.25 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BDFAE20C-6230-423E-BD8A-EDB20DC60FC3}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.5 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{97A56FF3-305A-489A-88D3-0D5E63338123}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.5 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{608B1E65-0687-4E24-AB96-FA5658E0D62C}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.75 nadmorska višina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{166370FC-20AD-4FF1-91F3-42628F19A3A9}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.0 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{596A5858-30B6-4ADE-8F38-A0AC77364ABD}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.0 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{729C3558-B057-41AC-802F-509D35AE7E3D}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.5 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{FA769B3A-A537-45E9-9890-AFC6B25FA4B0}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.5 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C4EA564B-9A30-4EB0-8959-2B6B0B4BE8D7}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.0 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BCDD12A0-B17B-4C2F-AD5F-E128F3D68F70}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.0 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{67DFA1A4-B97F-4346-951A-67D663465587}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.5 Finalna mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{492B5FE5-B9DB-499D-A91F-68258C36D1E8}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.5 Groba mera');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{69CEBC44-6090-4B67-A866-E674EA631E4F}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.5 nadmorska višina');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{45938570-3E7F-402E-9BB2-003721DEAE35}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.25 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BB7019BA-D531-454D-99D3-5E1D9C7B13A5}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 1.5 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BCB60ED0-1B4E-406A-A6D8-8E651DB2E8B5}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.0 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0EBDCF74-0349-462F-B664-302AAC75E2CC}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 2.5 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{F95BE5E9-B152-4970-B721-465932BD09E0}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.0 Halb');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6681BDFC-77E1-4F5D-9F09-52CE472C33E2}', 'global', '255', 'ardimlevel', '2025-03-13 11:57:32', 'Arial 3.5 Halb');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6942CF35-E79B-4037-A919-96AE475BD220}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 1.25 finalno / plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{34534607-7D80-4347-8A43-AC5DA8A38018}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 1.25 zgornji rob finalno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6DEC43F2-58E8-4D2B-8BD3-D4C9F55C469C}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 1.25 zgornji rob plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{BA27866F-DAA8-42A9-B279-77DA91C5F9D2}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.0 finalno / plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0E4F9EFE-0E7D-4271-9DEE-12F852348F4D}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.0 zgornji rob finalno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{5403457E-BA82-47AF-ADBA-798FCDAC022D}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.0 zgornji rob plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{B2F0AA3C-98FB-4865-8671-D30CEC0A5DA2}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.5 finalno / plošča');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7FE5457E-AD96-4D54-AA54-CE781B847047}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.5 zgornji rob finalno');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{7608412A-3C67-438D-8B30-997CEEF4C409}', 'global', '255', 'argroundlevel', '2025-03-13 11:57:37', 'Arial 2.5 zgornji rob plošča');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9E1B5C5D-6E04-4197-8760-0A6233BF628C}', 'global', '255', 'terrain', '2025-03-13 11:58:07', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{A50C9F0B-8F13-4B36-8645-F254E443E7BC}', 'global', '255', 'bs_sewer', '2025-03-13 11:58:59', 'Kontrolna komora');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{AF864057-2A7E-44B0-BCD0-429A8504597A}', 'global', '255', 'bs_sewer', '2025-03-13 11:58:59', 'Ločilnik');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{CBEB373A-E624-4C5E-B5C5-1171E17CDFFD}', 'global', '255', 'bs_sewer', '2025-03-13 11:58:59', 'Vsrkavanje');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{9449CC4E-31C3-4104-9617-5F64D81F808D}', 'global', '255', 'bs_sewer', '2025-03-13 11:58:59', 'Zbiralnik blata');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{40A2B97F-92EE-4999-A9AA-590852F0D244}', 'global', '255', 'bs_line', '2025-03-13 11:59:05', 'Drenaža');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{C95D18DE-5DFC-4AE6-998C-C8A4C1C553F8}', 'global', '255', 'bs_line', '2025-03-13 11:59:05', 'Fekalne vode');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{0A76E292-F874-4D6A-A0AC-AEEF615E1EBC}', 'global', '255', 'bs_line', '2025-03-13 11:59:05', 'Meteorne vode');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{36355EBE-0832-41D9-AE92-BB7CBD4CF04F}', 'global', '255', 'bs_line', '2025-03-13 11:59:05', 'Vodovod');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{6A78CBEA-7982-43EB-95DB-EA9BF642F969}', 'global', '255', 'grid', '2025-03-13 11:59:36', 'Osna mreža 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{58600747-1C89-4899-8C51-3BB4154426EA}', 'global', '255', 'grid', '2025-03-13 11:59:36', 'Osna mreža 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, sl) VALUES ('TY-{67F7D4C8-AF90-4FFC-882E-FAF499209328}', 'global', '255', 'grid', '2025-03-13 11:59:36', 'Standard');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A91CFEC7-388A-46F1-8648-5D6F68271C83}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 1.5 Ήμισυ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C0390E6C-189F-49C1-903C-E560942C980A}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 1.5 Αδειάζω');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{06971256-9419-40DD-97D8-9070E04B074B}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 1.5 Γεμάτος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{6FA691DD-FA71-46B9-BC3B-9982EC8B51FE}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 1.75  Ήμισυ Απολύτως');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A75EA285-7E9D-475B-81B6-B34C6C91C8F2}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.0 Ήμισυ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BE35DBF8-DA41-4AE8-B396-928808B42726}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.0 Αδειάζω');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{CE95BF21-0B46-4956-B0EA-719868F8BC27}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.0 Γεμάτος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{D242413C-3CC2-4A7C-A611-B57AD41ECE75}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.5 Ήμισυ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9C469425-71B8-44EF-8F3F-ED6D86056533}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.5 Αδειάζω');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AEC5AFD2-F7D5-4DD6-86DE-BA35A9AB71C6}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 2.5 Γεμάτος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{31A05D83-4BCA-4AA9-B5BC-49B2C2266F6B}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 3.0 Ήμισυ');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C7832248-8F11-4A72-88DB-2B7E28CFBCBD}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 3.0 Αδειάζω');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{9DE94C63-5EA3-4D49-B1C1-DCFB124476DC}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 3.0 Γεμάτος');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{7A348F56-9FF4-43E6-93BC-53202CCCBEC0}', 'global', '255', 'ardimlevel', '2025-03-27 10:17:09', 'Arial 3.5 Ήμισυ Απολύτως');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{B9F7A0B5-1241-41DD-A835-ED1F18FE3FE0}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 1.5 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{952D6BB7-6086-4D7E-9A00-8B10BE83343D}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 1.5 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{74ABF052-4902-4454-AC2E-BDC54AABF863}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.0 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{F9D225AD-F0BB-42A3-A807-9172D7E62592}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.0 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{2D7AA916-8DC7-4A42-A20C-1A07EF647044}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.0 TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{0ADC6294-4F3F-4914-B025-88FC4E296D92}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.5 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{BA444445-E88E-4469-B2E9-8E427AEF2D10}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.5 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{84604951-1A87-4C70-8BB3-8BE324CD53C9}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.5 FFL / TFS m.a.s.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{A3F7A5D5-2058-4C16-96E2-CD3499B2941D}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.5 FFL m.a.s.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{C4BEEEE9-8058-44FB-9517-948308E173ED}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 2.5 TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{AC99ECF1-7D77-4836-86FD-22FF2852070C}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 3.0 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, gr) VALUES ('TY-{3AD598C1-7701-4492-939D-7027E6BEDEA3}', 'global', '255', 'argroundlevel', '2025-03-27 10:17:16', 'Arial 3.0 FFL / TFS');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F1C15381-F08D-4BD1-9FBE-2DEB46857905}', 'global', '255', 'reppar', '2025-03-27 10:53:26', 'Concrete element');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AD95F9FE-FC4E-409C-AF50-B6B4956CB0DA}', 'global', '255', 'reppar', '2025-03-27 10:53:26', 'Wood');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{87E2D734-32AC-4E36-8422-A4CE243D5169}', 'global', '255', 'reppar', '2025-03-27 10:53:26', 'Surrounding area');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{FAC9ABAE-0331-422F-AABA-ECD1DD2D528F}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:58', 'Arial 1.5 Pełny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{19BA5A5E-255A-4A88-B9F5-2D63132492B9}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:58', 'Arial 1.5 Połowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C21B8A99-01D6-4D2A-8084-C12207B23EB5}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:58', 'Arial 1.5 Pusty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A1816421-9FC0-49AF-8F24-CFC2B3C4BB40}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:58', 'Arial 1.75 Połowa absolutnie');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{C23609DE-9BCE-4C82-B69A-16E23E4D2FBA}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.0 Pełny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{61911201-BA64-479D-A297-680857C42DC9}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.0 Połowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{B2CE9997-BD20-421F-87E1-973B56EE9760}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.0 Pusty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{76C90358-4AED-48D3-A21C-33B49489BE29}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.5 Pełny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{EEC18210-5D32-4442-BA55-5CEC0BE6E88F}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.5 Połowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{F2CD57FD-CC79-4989-8A5A-2BAEB9DEAD32}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 2.5 Pusty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{92440F73-C028-47F3-80EC-0320A920788A}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 3.0 Pełny');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{A448529F-9D18-41EE-B03B-7B70FA4E4E06}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 3.0 Połowa');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{7BAABA0E-A59D-4E6D-A159-56D1AD9EA98E}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 3.0 Pusty');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{949642A3-0853-4874-BDF7-CA3494CB12D0}', 'global', '255', 'ardimlevel', '2025-03-27 10:53:59', 'Arial 3.5 Połowa absolutnie');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{89B04F65-32D3-46CC-9BB2-2994C5829220}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 1.5 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{8C490302-2CD6-4A35-BC87-AB167303C732}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 1.5 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{5849F69E-3131-497D-831C-59C4BDE07B58}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.0 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{B8E080A2-9D8D-4F4D-933A-01E275A053B0}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.0 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{91D250FD-2E93-4E64-9147-A760D7ECE98D}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.0 TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CA6EBEFD-D107-468A-97F0-BC636DE68E7F}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.5 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{2CD13CF2-9CE5-40C5-96FD-D8EA428E7A3C}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.5 FFL / TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{3F22DB7C-A5E9-40BD-BDFF-CF31E93489CE}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.5 FFL / TFS m.a.s.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{FEBF0005-1AB2-4A52-887D-75E904FCEC6C}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.5 FFL m.a.s.');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{AD15691E-F63B-4830-9C31-54D1DB7665EE}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 2.5 TFS');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{769CD0A1-8577-4944-9336-4C864DC9AFEE}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 3.0 FFL');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, pl) VALUES ('TY-{CDE78E4A-F8FF-4131-8C75-89A70FD30241}', 'global', '255', 'argroundlevel', '2025-03-27 10:54:04', 'Arial 3.0 FFL / TFS');
-- values ME
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{45003A65-6B42-475C-98A7-63900AE63630}', 'global', '255', 'screwing', '2025-04-17 13:28:31', 'I-Träger');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8118E1C4-6C68-4F5B-A9DA-6228430BCC3C}', 'global', '255', 'screwing', '2025-04-17 13:29:12', 'Innensechskant');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8F73659E-1549-4D41-A590-A39BAE1BA992}', 'global', '255', 'screwing', '2025-08-29 06:06:59', 'Standard-Pipe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{401F1136-86FB-4425-B9DF-5A2914E10780}', 'global', '255', 'elem', '2025-04-17 13:29:28', '5-Eck');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{38D1BA28-A722-4D43-8DA4-27F1C001CBAD}', 'global', '255', 'elem', '2025-04-17 13:29:28', 'Ellipse');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{69132372-EA9A-4489-9A69-A3A8351F7240}', 'global', '255', 'elem', '2025-04-17 13:29:28', 'Spirale');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{10CDB520-45C8-4708-A345-6EF9C3B608C8}', 'global', '255', 'sheet', '2025-04-17 13:29:46', 'Grundplatte 4 Loch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C97C9293-3BD6-4AF9-AB89-6FCB86825476}', 'global', '255', 'sheet', '2025-04-17 13:29:46', 'Lochscheibe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{7FEE7DDD-3251-4471-84CB-0AEBB8269EF3}', 'global', '255', 'gearwh', '2025-04-17 13:29:49', 'Zahnrad');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DE80933A-02C4-4E0F-AD28-FE4B6F0B10DB}', 'global', '255', 'belt', '2025-04-17 13:29:54', 'Keilriemenscheibe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C06A890F-7B19-4605-A477-816BA719487D}', 'global', '255', 'coup', '2025-04-17 13:30:07', 'Kupplung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E4697476-F9EA-4F98-ABB6-5CA02716068E}', 'global', '255', 'bear', '2025-04-17 13:30:15', 'Stehlager Draufsicht');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C5EE0E5D-9610-489F-A30B-CDD76596D790}', 'global', '255', 'unwind', '2025-04-17 13:30:21', 'Abzeiger konisch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{37DBD8E2-740D-471E-8CD3-E152EF0134EF}', 'global', '255', 'unwind', '2025-04-17 13:30:21', 'Segmentbogen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{ECB05C4D-AE97-4404-AA7D-0D309DA8872E}', 'global', '255', 'unwind', '2025-04-17 13:30:21', 'Y-Stück');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DA871D84-ED6E-4A24-84F5-486EF12FEBAB}', 'global', '255', 'unwind', '2025-04-17 13:30:21', 'Übergang');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4CF0ACBE-6094-475C-893D-702F44061F99}', 'global', '255', 'screw', '2025-04-17 13:30:31', 'Schraube');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{8338275E-5A9A-4694-80BA-6FB997FC6DC6}', 'global', '255', 'nut', '2025-04-17 13:30:37', 'Mutter');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{07C9E587-3390-4A63-A471-54D2DD652A36}', 'global', '255', 'washer', '2025-04-17 13:30:40', 'Scheibe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B9CCD821-DD34-437E-9660-9E444EAF17F1}', 'global', '255', 'prof', '2025-04-17 13:30:43', 'Profile');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2EC56627-3218-4637-B5BF-FE717F825CC4}', 'global', '255', 'stift', '2025-04-17 13:31:09', 'Stifte');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C0DACB46-9478-465F-93E9-EDFD245FEF31}', 'global', '255', 'bearing', '2025-04-17 13:31:15', 'Lager');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F30C4CFC-1466-4FA2-A1F8-02D4F311B622}', 'global', '255', 'einstich', '2025-04-17 13:31:19', 'Sicherungsring');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{606BEE55-5F13-488B-913F-DA848B52C3C0}', 'global', '255', 'flange', '2025-04-17 13:31:23', 'Flansch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{671E2F1C-1DDA-43B7-9523-3F843AE3AC81}', 'global', '255', 'fitting', '2025-04-17 13:31:29', 'T-Stück');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{90C0ED53-0DDF-4F62-A61A-19D111EA8F3A}', 'global', '255', 'extdtube', '2025-04-17 13:31:34', 'Rohrverschraubung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F3BC4E4D-D482-4B51-BA7C-8C08511B2FD1}', 'global', '255', 'tube', '2025-04-17 13:31:42', 'Rohr');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{49D249E2-CB1D-4A7F-A9C3-37ED6E6B29B9}', 'global', '255', 'form', '2025-04-17 13:32:05', 'Formtoleranz');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{25D6E8B1-4C46-4A2D-9F4A-305F1C877F81}', 'global', '255', 'edge', '2025-04-17 13:32:09', 'Kantentoleranz');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B05ECBB3-C3A8-4BC0-B1C5-DD2D8222668B}', 'global', '255', 'surfsymb', '2025-04-17 13:32:12', 'Oberflächensymbol');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E03796C8-1DB7-4194-BD16-D0CA1AEFDA43}', 'global', '255', 'weldsymb', '2025-04-17 13:32:18', 'Schweißzeichen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A19BC83D-795A-407A-B3E4-F52C19144C7B}', 'global', '255', 'sink', '2025-04-17 13:32:45', 'Kernloch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{169E858B-F0CB-441D-A669-3120A7416942}', 'global', '255', 'drill', '2025-04-17 13:33:03', 'Passfedernut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{14EA3A43-7E9A-4436-B1BC-99F7E81E568D}', 'global', '255', 'blend', '2025-04-17 13:33:19', 'D=20/50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{A73DC003-E41B-4807-8135-1918061F5919}', 'global', '255', 'outl', '2025-04-17 13:33:28', 'Abrisslinie D=50');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C08BDF11-4552-4446-826E-F3ED1180BEDC}', 'global', '255', 'hatchpar', '2025-04-17 13:33:29', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E524B86E-ADEA-4D60-83A1-2F267664381F}', 'global', '255', 'hatchpar', '2025-04-17 13:33:29', 'Gummi');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{AB9BA494-2802-4323-9F05-13094036734E}', 'global', '255', 'hatchpar', '2025-04-17 13:33:29', 'Isolierung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0327B102-B726-4330-AAA3-DB7C9E60A787}', 'global', '255', 'hatchpar', '2025-04-17 13:33:29', 'Kiesel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{60B697BA-F9E8-41DF-AE25-C8CFF67137FE}', 'global', '255', 'hatchpar', '2025-04-17 13:33:29', 'Ziegel');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{166940D3-5C8E-419F-BF58-61467D46F1B1}', 'global', '255', 'textpar', '2025-04-17 13:39:18', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{B2DCDBCD-A8B5-4A9D-BE92-482038652649}', 'global', '255', 'textpar', '2025-04-17 13:39:18', 'me_ansicht');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0A2644D5-914C-4C7C-8D50-305435121890}', 'global', '255', 'textpar', '2025-04-17 13:39:18', 'me_pos');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{3CB369F3-F315-4BCD-8CAA-D1B6EEABDEF9}', 'global', '255', 'textpar', '2025-04-17 13:39:18', 'me_attr');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{95C95822-3035-45B1-B88C-1D2A3394608F}', 'global', '255', 'arrowpar', '2025-04-17 13:40:22', 'me_pos');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C66A37C7-E3B3-4B6E-8202-A22C5672D270}', 'global', '255', 'arrowpar', '2025-04-17 13:40:22', 'me');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{839CBDAA-77D6-4DE9-8E0A-941A692E4286}', 'global', '255', 'ardimlevel', '2025-04-17 13:43:40', 'me');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CE9E117D-13C2-4A2F-AE40-CF2E443FBEE5}', 'global', '255', 'astairs', '2025-04-17 13:49:50', 'Treppe 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{2173AB96-D574-4D26-85E1-5520E3D90574}', 'global', '255', 'astairs', '2025-04-17 13:49:51', 'Treppe 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{85B16627-29BF-4786-9D48-0B24493FD634}', 'global', '255', 'astairs', '2025-04-17 13:49:52', 'Treppe 3');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{EAB0149C-F3A1-4621-855E-58878DAFC408}', 'global', '255', 'railing', '2025-04-17 13:50:18', 'Geländer 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{59A406EC-72E4-49D0-A255-B4AD8210A4B7}', 'global', '255', 'railing', '2025-04-17 13:50:18', 'Geländer 2');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{84F3D103-FDBF-45D2-8005-C9CCE2A5BB2B}', 'global', '255', 'attr_param', '2025-04-23 09:44:32', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{DCA79EF2-C2A4-4A1B-9560-3B9586B0AAE1}', 'global', '255', 'attr_param', '2025-04-23 09:44:36', 'me_bez');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{695BCF8E-D0D3-4A87-AC71-DF44F909B4E7}', 'global', '255', 'bs_line', '2025-05-02 10:42:22', 'Ammoniakwasser');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{44DAE0B8-782A-4D4A-8BC5-7477059F44E4}', 'global', '255', 'bs_line', '2025-05-02 10:42:31', 'HD-Dampf');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{CBD3056F-D07D-4D81-B8A5-548263168B67}', 'global', '255', 'bs_armature', '2025-05-02 10:42:50', 'Absperrklappe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{20C822AA-FE0F-493B-9C77-E74B359114A5}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Absperrschieber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{23693269-7EE7-4E0D-8331-638C470C24DC}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Absperrventil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{5AFA3630-EAD4-4E07-AA49-D83ABD68FB27}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Kugelhahn');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{52C19D68-285F-4E4A-829D-BDC09C020974}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Rückschlagklappe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BC9BEC2E-4DB6-40D8-A75B-FEC64649916D}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Rückschlagventil');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{0408065F-EDAC-4A13-8329-137A261DC584}', 'global', '255', 'bs_armature', '2025-05-02 10:42:54', 'Schmutzfänger');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{80883D7D-889F-4A45-8BC7-4EE3C985A7FB}', 'global', '255', 'bs_gasket', '2025-05-02 10:43:08', 'Flachdichtung');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{4F6CC46B-5BFB-481D-9C58-B0490F2FA590}', 'global', '255', 'bs_gasket', '2025-05-02 10:43:08', 'Flachdichtung (Löcher)');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{C01084EA-AB46-408C-AFDE-C5834A1DEDA0}', 'global', '255', 'bs_gasket', '2025-05-02 10:43:08', 'Spiraldichtung');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F59D4698-6652-4C3D-978E-BC9D3383B3BF}', 'global', '255', 'bs_flange', '2025-05-02 10:43:15', 'Blindflansch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{BE84C4FD-8594-451B-ABE9-5896E260DC34}', 'global', '255', 'bs_flange', '2025-05-02 10:43:15', 'Glatter Flansch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{6C21EE3B-AE0A-47A9-A57F-5BF0BBB040D6}', 'global', '255', 'bs_flange', '2025-05-02 10:43:15', 'Vorschweissflansch');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{9FBB1F5A-1F62-4209-8778-B0C6DA541972}', 'global', '255', 'bs_fitting', '2025-05-02 10:43:20', 'Bogen');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{F3DBD1A8-920F-458E-A495-76BDD41737B7}', 'global', '255', 'bs_fitting', '2025-05-02 10:43:20', 'Kappe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{E7130E17-4B4A-405C-9A89-06AC2DB16007}', 'global', '255', 'bs_fitting', '2025-05-02 10:43:20', 'Reduzierstück');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{14864046-6EAA-4277-99F8-86C45CB20C25}', 'global', '255', 'bs_fitting', '2025-05-02 10:43:20', 'Rohr');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{96EE2AF6-3B5F-4F37-88CB-3DA20DC6E947}', 'global', '255', 'bs_fitting', '2025-05-02 10:43:20', 'T-Stück');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{136FC87B-B81A-46A9-A4EA-13F276FAFDEC}', 'global', '255', 'dimpar', '2025-07-31 07:41:53', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{75790D20-8FE2-4230-8A60-DDFA3E2124D4}', 'global', '255', 'dimpar', '2025-07-31 07:41:53', 'me-arial-3.5');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, de) VALUES ('TY-{98935932-ABB4-4471-B2AC-D5FE26ECC352}', 'global', '255', 'pos_para', '2025-08-29 09:19:54', 'me_std');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A5842145-A39D-4EE1-98CA-FB450B028C83}', 'global', '255', 'hatchpar', '2025-10-10 11:12:45', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C7A28A25-7E8E-4924-9575-55AD92D749E6}', 'global', '255', 'hatchpar', '2025-10-10 11:12:45', 'Rubber');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9CA3BA29-67B6-482B-BD10-2D9A2DA97D99}', 'global', '255', 'hatchpar', '2025-10-10 11:12:45', 'Insulation');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F8D229BC-640F-40E7-BE4B-5723B9A0D023}', 'global', '255', 'hatchpar', '2025-10-10 11:12:45', 'Pebble');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{ECA70DA3-1BA7-4240-BEED-8364819CB8FE}', 'global', '255', 'textpar', '2025-10-10 11:12:47', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4597984F-DD15-45E5-9DBC-3347945258D6}', 'global', '255', 'textpar', '2025-10-10 11:12:47', 'me_view');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4801ABB6-0A49-4F1E-B485-B9E3A663B107}', 'global', '255', 'textpar', '2025-10-10 11:12:47', 'me_pos');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{EE231094-5F6B-4FD2-B8D7-366DEDDBF352}', 'global', '255', 'textpar', '2025-10-10 11:12:47', 'me_attr');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9744E51F-6D29-4B44-9EFC-5818FE9C1F86}', 'global', '255', 'dimpar', '2025-10-10 11:12:47', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CBC06316-6DF8-4AFB-AC2C-8E4C74A74D3D}', 'global', '255', 'dimpar', '2025-10-10 11:12:47', 'me-arial-3.5');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{02B4DAF5-1DCA-4B3A-B4CC-473E276752D7}', 'global', '255', 'arrowpar', '2025-10-10 11:12:47', 'me_pos');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4505659D-1276-4C5B-AB8F-DFB2B31D973E}', 'global', '255', 'arrowpar', '2025-10-10 11:12:47', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{87D49BDD-61AB-4A35-84F8-0D5C4F3253D1}', 'global', '255', 'screwing', '2025-10-10 11:12:48', 'I-Beam');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4BD1F822-0666-4E7A-98BC-45105E4FEE5D}', 'global', '255', 'screwing', '2025-10-10 11:12:48', 'Hex socket');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{19EFD920-EA55-466A-8FD7-DD26A2A1ED45}', 'global', '255', 'screwing', '2025-10-10 11:12:48', 'Standard-Pipe');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{912C865C-672A-4795-A253-CB8A4578927B}', 'global', '255', 'attr_param', '2025-10-10 11:17:32', 'me');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BD63545C-4BD6-4994-AD2E-27064C8EF578}', 'global', '255', 'attr_param', '2025-10-10 11:17:32', 'me_name');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{0560D9D9-81EB-4697-842E-33A0DF35D038}', 'global', '255', 'elem', '2025-10-10 11:17:51', 'Pentagon');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5B1419D2-A7D9-4927-8321-4663737247C4}', 'global', '255', 'elem', '2025-10-10 11:17:51', 'Ellipse');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{56F8B76D-F4A2-4EDB-9DDF-0CB845FFBBFA}', 'global', '255', 'elem', '2025-10-10 11:17:51', 'Spiral');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{3DD4BCF4-FE3A-4623-B864-B7857296517E}', 'global', '255', 'sheet', '2025-10-10 11:23:12', 'Base plate 4-hole');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A6F70A3B-AAD2-4237-841D-917EDB7ECB82}', 'global', '255', 'sheet', '2025-10-10 11:23:12', 'Round bored plate');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1F7015A8-58C6-49CB-A0BF-EFDAB4FC0AD4}', 'global', '255', 'gearwh', '2025-10-10 11:23:49', 'Gear wheel');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{C39D67EB-6BEF-4518-9109-0FA62B52693E}', 'global', '255', 'belt', '2025-10-10 11:23:56', 'V-belt pulley');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{38F4F27B-05DF-4C40-9936-354C29A7A3DD}', 'global', '255', 'coup', '2025-10-10 11:24:11', 'Coupling');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{92312EEA-3A8C-4478-854F-04860C2B8C5F}', 'global', '255', 'bear', '2025-10-10 11:24:20', 'Pedestal bearing top view');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{E6037F92-0F21-45EA-8ED3-430BE95923F3}', 'global', '255', 'unwind', '2025-10-10 11:24:28', 'Conical pipe branch');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1E24AFC2-3D7F-44C2-AD2C-14327F321A29}', 'global', '255', 'unwind', '2025-10-10 11:24:28', 'Segment elbow');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4BB2C93F-DA08-45D7-9540-1C98E7933784}', 'global', '255', 'unwind', '2025-10-10 11:24:28', 'Y-Pipe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DFF5D4E6-38A2-4B31-8000-3EAAA2D73B70}', 'global', '255', 'unwind', '2025-10-10 11:24:28', 'Reducer');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{917BA380-1FC1-4AAA-BD87-2BB32CFE3106}', 'global', '255', 'astairs', '2025-10-10 11:24:39', 'Stair 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{22FED5D7-1898-4AEC-9D0B-8EE8C715CFD1}', 'global', '255', 'astairs', '2025-10-10 11:24:39', 'Stair 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{262FC796-E164-4209-9F18-F214D77BE91E}', 'global', '255', 'astairs', '2025-10-10 11:24:39', 'Stair 3');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{57E2F2B1-A07E-423A-A140-CF601C325238}', 'global', '255', 'railing', '2025-10-10 11:25:01', 'Railing 1');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5771481E-DA40-4096-945E-E6C8A7C2DA7B}', 'global', '255', 'railing', '2025-10-10 11:25:01', 'Railing 2');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{09CBE7BA-1809-4A5F-894A-2DBA6A1162A0}', 'global', '255', 'screw', '2025-10-10 11:25:17', 'Screws');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{DC02AE47-94C5-4BA2-A0A3-678234B25C1C}', 'global', '255', 'nut', '2025-10-10 11:25:23', 'Nut');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BB9D0EAD-754D-4C70-AE1E-183D2B1A571A}', 'global', '255', 'washer', '2025-10-10 11:25:29', 'Washer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4A5A459C-B6BB-48BA-A81D-2F77054ECC91}', 'global', '255', 'prof', '2025-10-10 11:26:09', 'Profile');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{44D43C4F-C114-468D-ACA5-FAC71A2F1A73}', 'global', '255', 'stift', '2025-10-10 11:26:27', 'Pin');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{AF9E9F89-7C62-4D47-A469-4D98B2FCB04C}', 'global', '255', 'bearing', '2025-10-10 11:26:32', 'Bearing');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4E58763F-989C-495C-9CFF-A4B0F13749E7}', 'global', '255', 'einstich', '2025-10-10 11:26:37', 'Retaining rings');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A69A4645-4A35-4BF1-857C-76525BC7B48D}', 'global', '255', 'flange', '2025-10-10 11:26:43', 'Flange');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7047F822-16A6-409B-92F1-0799DD535E72}', 'global', '255', 'fitting', '2025-10-10 11:26:48', 'Tee');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{94B1FD25-5235-456F-81D7-E91902F0919B}', 'global', '255', 'tube', '2025-10-10 11:26:58', 'Pipe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D657B983-7BE3-4D36-A966-BEEC2B7E8CD0}', 'global', '255', 'sink', '2025-10-10 11:29:53', 'Core hole');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{2BA79AAF-65E5-4786-BE1D-AC19724F363A}', 'global', '255', 'drill', '2025-10-10 11:30:08', 'Feather key');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{5BE8BD53-5CCD-4441-9813-FF2CE7B00C9E}', 'global', '255', 'blend', '2025-10-10 11:35:21', 'D=20/50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{245979FC-9BDB-47A3-A89E-11DF37992B14}', 'global', '255', 'outl', '2025-10-10 11:35:26', 'Tear Line D=50');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{721C5EB6-7FDA-4DAD-8205-0F85BD7AD958}', 'global', '255', 'form', '2025-10-10 11:35:39', 'Geometric tolerance');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{65737B20-F968-47B2-B0C3-B7FF341CAE5F}', 'global', '255', 'edge', '2025-10-10 11:35:45', 'Edge tolerance');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{BD59B640-C912-4F24-9EFB-B0E7C538AEF8}', 'global', '255', 'surfsymb', '2025-10-10 11:35:50', 'Surface symbol');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9E924E97-680B-4BBE-9CAF-78BDA84512B6}', 'global', '255', 'weldsymb', '2025-10-10 11:36:01', 'Welding symbols');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D004A7A2-AC5D-4918-8B09-D1636F0223C4}', 'global', '255', 'pos_para', '2025-10-10 11:52:12', 'me_std');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{785D27BB-0ED7-4294-8135-AA4CBD3A9171}', 'global', '255', 'bs_line', '2025-10-20 14:15:45', 'Ammonia water');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9226C92C-9B1C-4395-925A-83165C148A7F}', 'global', '255', 'bs_line', '2025-10-20 14:15:45', 'HP-Steam');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{9F2BA660-CD06-404D-A797-8D24DB0FF7E6}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Shutoff damper');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{FECA842E-075C-41E6-B442-6066BCF5C89A}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Slide valve');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B08E6C2A-FFFA-4A12-9197-49E38BC34B1E}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Stop valve');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B138A342-5FE0-4A26-BABA-904CB1D17E6E}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Ball valve');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{B0316AB0-C2F2-42D4-B49E-811B8CABFD50}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Swing check valve');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A77596A5-FE47-4ACE-89AB-9FB2E59697E5}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Check valve');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{4998ED3B-CE07-41AD-A30B-FAE77E9977CB}', 'global', '255', 'bs_armature', '2025-10-20 14:16:01', 'Strainer');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{846F5052-8B3A-4DD4-BF05-9BA427C058C4}', 'global', '255', 'bs_gasket', '2025-10-20 14:16:26', 'Flat gasket');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{CC2C44B3-80BB-4FC4-9193-499DFE206AC7}', 'global', '255', 'bs_gasket', '2025-10-20 14:16:26', 'Flat gasket with holes');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{A9F54162-C66C-40E4-9B48-79FBC144E502}', 'global', '255', 'bs_gasket', '2025-10-20 14:16:26', 'Spiral gasket');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{27D7E316-D32B-4CB7-80CD-DB9D906EAA17}', 'global', '255', 'bs_flange', '2025-10-20 14:16:47', 'Blind flange');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{6E58E64F-4E4E-4D37-BD5A-3533486585E6}', 'global', '255', 'bs_flange', '2025-10-20 14:16:47', 'Flat flange');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7E98C62F-BF41-4B6E-8CBE-184D9E7CF88E}', 'global', '255', 'bs_flange', '2025-10-20 14:16:47', 'Welding neck flange');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{1EA47C42-0BCC-4CA7-A84F-930BF2222D86}', 'global', '255', 'bs_fitting', '2025-10-20 14:17:07', 'Elbow');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{7BE53C13-3911-4706-A66E-47745732B495}', 'global', '255', 'bs_fitting', '2025-10-20 14:17:07', 'Cap');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{30D1B101-C7FB-469F-AD63-D5DE9A38A51E}', 'global', '255', 'bs_fitting', '2025-10-20 14:17:08', 'Reducer');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{D4F8F236-E5D0-48A1-8EB1-5836064B71AA}', 'global', '255', 'bs_fitting', '2025-10-20 14:17:08', 'Pipe');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{F3A29EA3-00F6-4ED1-8C9B-1F6F35FD97C3}', 'global', '255', 'bs_fitting', '2025-10-20 14:17:08', 'Tee');
-- values
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{284D55FD-FFDA-4009-97CB-B47775220199}', 'global', '255', 'layerlist', '2025-10-20 14:19:28', 'Default');
INSERT INTO ecad_guid_info_type (guid, username, mode, add_info, modify_datetime, en) VALUES ('TY-{16551AA3-1740-4E5F-9CCA-03FC9062383E}', 'global', '255', 'extdtube', '2025-10-21 07:49:56', 'Pipe screw fitting');
