/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

DROP DATABASE IF EXISTS `ecad_property`;
CREATE DATABASE IF NOT EXISTS `ecad_property` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `ecad_property`;

DROP TABLE IF EXISTS `ecad_property_def`;
CREATE TABLE IF NOT EXISTS `ecad_property_def` (
  `property_group` int NOT NULL DEFAULT '0',
  `property_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `property_format` bigint NOT NULL,
  `property_editable` int NOT NULL,
  `property_text_de` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_en` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_fr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_gr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_es` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_pl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_ru` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_tr` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  `property_text_sl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci DEFAULT '',
  PRIMARY KEY (`property_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*!40000 ALTER TABLE `ecad_property_def` DISABLE KEYS */;
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AcousticRating', 1095347863557, 0, 'Schallschutzklasse', 'Acoustic Rating', 'IsolationAcoustique', 'Απόδοση Ακουστικής', '', '', 'Шумоподавление', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AcquisitionDate', 1095348322309, 0, 'Erwerbsdatum', 'Acquisition Date', 'Date d\'acquisition', 'Ημερομηνία Απόκτησης', '', '', 'Дата приобретения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AngleBetweenComponentAxes', 6713296486404, 0, 'Winkel zwischen Komponentenachsen', 'Angle Between Component Axes', 'Angle entre les axes des composantes', 'Γωνία μεταξύ αξόνων των Component', '', '', 'Угол между осями компонентов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AngleToFirstAxis', 6713296486404, 0, 'Winkel zur ersten Achse', 'Angle To First Axis', 'Angle par rapport au premier axe', 'Γωνία στον πρώτο άξονα', '', '', 'Угол к первой оси', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ArticleNumber', 1095347929093, 0, 'Artikelnummer', 'Article Number', 'Numéro d\'article', 'Αριθμός άρθρου', '', '', 'Номер артикула', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AssemblyPlace', 1095347863557, 0, 'Montage Platz', 'Assembly Place', 'Emplacement de l\'assemblage', 'Θέση συναρμολόγησης', '', '', 'Место сборки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AssessmentCondition', 1095347863557, 0, 'Bewertungszustand', 'Assessment Condition', 'Condition d\'évaluation', 'Κατάσταση αξιολόγησης', '', '', 'Оценка состояния', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AssessmentDate', 1095348322309, 0, 'Bewertungsdatum', 'Assessment Date', 'Date d\'évaluation', 'Ημερομηνία αξιολόγησης', '', '', 'Дата оценки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AssessmentDescription', 1095347732485, 0, 'Bewertungsbeschreibung', 'Assessment Description', 'Description de l\'évaluation', 'Περιγραφή Αξιολόγησης', '', '', 'Описание оценки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AtmosphericAcidification', 6713298911236, 0, 'Atmosphärische Versauerung', 'Atmospheric Acidification', 'Acidification Atmospherique', 'Οξίνιση της ατμόσφαιρας', '', '', 'Атмосферное подкисление', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'AtmosphericAcidificationPerUnit', 6713298911236, 0, 'Atmosphärische Versauerung pro Einheit', 'Atmospheric Acidification Per Unit', 'Acidification Atmospherique Par Unite', 'Οξίνιση της ατμόσφαιρας ανά μονάδα', '', '', 'Подкисление атмосферы на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'BarAllocationType', 1095347863557, 0, 'Anordnung der Bewehrungsstäbe', 'Bar Allocation Type', 'Mode d\'attribution des barreaux', 'Τύπος κατανομής ράβδων', '', '', 'Тип распределения стержней', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'BarCode', 1095347929093, 0, 'Barcode', 'Bar Code', 'Code à barres', 'Γραμμικός κώδικας', '', '', 'Штрих-код', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'BatchReference', 1095347929093, 0, 'Batchreferenz', 'Batch Reference', 'Référence du lot', 'Αναφορά παρτίδας', '', '', 'Ссылка на пакет', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ClearWidth', 6713296355332, 0, 'Lichte Breite', 'Clear Width', 'Largeur libre', 'Καθαρό πλάτος', '', '', 'Чистая ширина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ClimateChange', 6713298911236, 0, 'Klimawandel', 'Climate Change', 'ChangementClimatique', 'Κλιματική αλλαγή', '', '', 'Изменение климата', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ClimateChangePerUnit', 6713298911236, 0, 'Klimawandel pro Einheit', 'Climate Change Per Unit', 'Changement Climatique Par Unité', 'Κλιματική αλλαγή ανά μονάδα', '', '', 'Изменение климата на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Combustible', 4360503298, 0, 'Brennbares Material', 'Combustible', 'Combustible', 'Καύσιμο', '', '', 'Горючие', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Compartmentation', 4360503298, 0, 'Brandabschnittsdefinierendes Bauteil', 'Compartmentation', 'Compartimentage', 'Διαμερίσματα', '', '', 'Разделение на части', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'CounterSlope', 6713296486404, 0, 'Gegenneigung', 'Counter Slope', 'ContrePente', 'Κλίση μετρητή', '', '', 'Контруклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'CrossingLowerBarPitch', 6713296355332, 0, 'Steigung des unteren Armierungseisen', 'Crossing Lower Bar Pitch', 'Longueur de Traversée de la Barre Inférieure', 'Crossing Lower Bar Pitch', '', '', 'Шаг нижней перекладины', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'CrossingUpperBarPitch', 6713296355332, 0, 'Steigung des oberen Armierungseisen', 'Crossing Upper Bar Pitch', 'Longueur de Traversée de la Barre supérieure', 'Crossing Upper Bar Pitch', '', '', 'Шаг верхней перекладины', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Depth', 6713296355332, 0, 'Tiefe', 'Depth', 'Profondeur', 'Βάθος', '', '', 'Глубина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Description', 1095347732485, 0, 'Beschreibung', 'Description', 'Description', 'Περιγραφή', '', '', 'Описание', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Diameter', 6713296355332, 0, 'Durchmesser', 'Diameter', 'Diamètre', 'Διάμετρος', '', '', 'Диаметр', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'DistanceBetweenComponentAxes', 6713296355332, 0, 'Abstand zwischen Bauteilen', 'Distance Between Component Axes', 'Distance entre les axes du composant', 'Απόσταση μεταξύ αξόνων των component', '', '', 'Расстояние между осями компонентов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'DurabilityRating', 1095347863557, 0, 'Beanspruchungsklasse', 'Durability Rating', 'Durabilité', 'Βαθμολογία αντοχής', '', '', 'Рейтинг долговечности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Duration', 1095348453381, 0, 'Dauer', 'Duration', 'Durée', 'Διάρκεια', '', '', 'Продолжительность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'EdgeDistanceToFirstAxis', 6713296355332, 0, 'Kantenabstand zur ersten Achse', 'Edge Distance To First Axis', 'Distance entre le bord et le premier axe', 'Απόσταση άκρου έως τον πρώτο άξονα', '', '', 'Расстояние от края до первой оси', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Eutrophication', 6713298911236, 0, 'Eutrophierung', 'Eutrophication', 'Eutrophisation', 'Ευτροφισμός', '', '', 'Эвтрофикация', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'EutrophicationPerUnit', 6713298911236, 0, 'Eutrophierung pro Einheit', 'Eutrophication Per Unit', 'Eutrophisation Par Unité', 'Ευτροφισμός ανά μονάδα', '', '', 'Эвтрофикация на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Exclusions', 1095347732485, 0, 'Ausschlüsse', 'Exclusions', 'Exclusions', 'Εξαιρέσεις', '', '', 'Исключения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ExpectedServiceLife', 6713301532676, 0, 'erwartete Lebensdauer', 'Expected Service Life', 'Duree De Vie Typique', 'Αναμενόμενη διάρκεια ζωής', '', '', 'Ожидаемый срок службы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ExtendToStructure', 4360503298, 0, 'Raumhohe Wand', 'Extend To Structure', 'Extension Structure', 'Επέκταση στη δομή', '', '', 'Расширить до структуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Finish', 1095347732485, 0, 'Oberflächengüte', 'Finish', 'Finition', 'Φινίρισμα', '', '', 'Конец', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'FireExit', 4360503298, 0, 'Notausgang', 'Fire Exit', 'Sortie Secours', 'Εξοδος κινδύνου', '', '', 'Пожарный выход', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'FireRating', 1095347863557, 0, 'Feuerwiderstandsklasse', 'Fire Rating', 'Resistance Au Feu', 'Βαθμολογία πυρκαγιάς', '', '', 'Огнестойкость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'FlammabilityRating', 1095347863557, 0, 'Entflammbarkeitsklasse', 'Flammability Rating', 'Inflammabilité', 'Βαθμολογία ευφλεκτότητας', '', '', 'Воспламеняемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'FragilityRating', 1095347863557, 0, 'Fragilitätsklasse', 'Fragility Rating', 'Fragilité', 'Βαθμολογία ευθραυστότητας', '', '', 'Хрупкость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free', 282570199924741, 0, 'Freie Attribute', 'Free Attributes', 'Attributs libres', 'Δωρεάν χαρακτηριστικά', '', '', 'Бесплатные атрибуты', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AcousticRating', 1095347863557, 0, 'Schallschutzklasse', 'Acoustic Rating', 'IsolationAcoustique', 'Απόδοση Ακουστικής', '', '', 'Шумоподавление', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AcquisitionDate', 1095348322309, 0, 'Erwerbsdatum', 'Acquisition Date', 'Date d\'acquisition', 'Ημερομηνία Απόκτησης', '', '', 'Дата приобретения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AngleBetweenComponentAxes', 6713296486404, 0, 'Winkel zwischen Komponentenachsen', 'Angle Between Component Axes', 'Angle entre les axes des composantes', 'Γωνία μεταξύ αξόνων των Component', '', '', 'Угол между осями компонентов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AngleToFirstAxis', 6713296486404, 0, 'Winkel zur ersten Achse', 'Angle To First Axis', 'Angle par rapport au premier axe', 'Γωνία στον πρώτο άξονα', '', '', 'Угол к первой оси', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ArticleNumber', 1095347929093, 0, 'Artikelnummer', 'Article Number', 'Numéro d\'article', 'Αριθμός άρθρου', '', '', 'Номер артикула', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AssemblyPlace', 1095347863557, 0, 'Montage Platz', 'Assembly Place', 'Emplacement de l\'assemblage', 'Θέση συναρμολόγησης', '', '', 'Место сборки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AssessmentCondition', 1095347863557, 0, 'Bewertungszustand', 'Assessment Condition', 'Condition d\'évaluation', 'Κατάσταση αξιολόγησης', '', '', 'Оценка состояния', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AssessmentDate', 1095348322309, 0, 'Bewertungsdatum', 'Assessment Date', 'Date d\'évaluation', 'Ημερομηνία αξιολόγησης', '', '', 'Дата оценки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AssessmentDescription', 1095347732485, 0, 'Bewertungsbeschreibung', 'Assessment Description', 'Description de l\'évaluation', 'Περιγραφή Αξιολόγησης', '', '', 'Описание оценки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AtmosphericAcidification', 6713298911236, 0, 'Atmosphärische Versauerung', 'Atmospheric Acidification', 'Acidification Atmospherique', 'Οξίνιση της ατμόσφαιρας', '', '', 'Атмосферное подкисление', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::AtmosphericAcidificationPerUnit', 6713298911236, 0, 'Atmosphärische Versauerung pro Einheit', 'Atmospheric Acidification Per Unit', 'Acidification Atmospherique Par Unite', 'Οξίνιση της ατμόσφαιρας ανά μονάδα', '', '', 'Подкисление атмосферы на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::BarAllocationType', 1095347863557, 0, 'Anordnung der Bewehrungsstäbe', 'Bar Allocation Type', 'Mode d\'attribution des barreaux', 'Τύπος κατανομής ράβδων', '', '', 'Тип распределения стержней', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::BarCode', 1095347929093, 0, 'Barcode', 'Bar Code', 'Code à barres', 'Γραμμικός κώδικας', '', '', 'Штрих-код', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::BatchReference', 1095347929093, 0, 'Batchreferenz', 'Batch Reference', 'Référence du lot', 'Αναφορά παρτίδας', '', '', 'Ссылка на пакет', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ClearWidth', 6713296355332, 0, 'Lichte Breite', 'Clear Width', 'Largeur libre', 'Καθαρό πλάτος', '', '', 'Чистая ширина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ClimateChange', 6713298911236, 0, 'Klimawandel', 'Climate Change', 'ChangementClimatique', 'Κλιματική αλλαγή', '', '', 'Изменение климата', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ClimateChangePerUnit', 6713298911236, 0, 'Klimawandel pro Einheit', 'Climate Change Per Unit', 'Changement Climatique Par Unité', 'Κλιματική αλλαγή ανά μονάδα', '', '', 'Изменение климата на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Combustible', 4360503298, 0, 'Brennbares Material', 'Combustible', 'Combustible', 'Καύσιμο', '', '', 'Горючие', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Compartmentation', 4360503298, 0, 'Brandabschnittsdefinierendes Bauteil', 'Compartmentation', 'Compartimentage', 'Διαμερίσματα', '', '', 'Разделение на части', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::CompressiveStrength', 282570324443141, 0, 'Druckfestigkeit', 'CompressiveStrength', '', '', '', '', '', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::CounterSlope', 6713296486404, 0, 'Gegenneigung', 'Counter Slope', 'ContrePente', 'Κλίση μετρητή', '', '', 'Контруклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::CrossingLowerBarPitch', 6713296355332, 0, 'Steigung des unteren Armierungseisen', 'Crossing Lower Bar Pitch', 'Longueur de Traversée de la Barre Inférieure', 'Crossing Lower Bar Pitch', '', '', 'Шаг нижней перекладины', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::CrossingUpperBarPitch', 6713296355332, 0, 'Steigung des oberen Armierungseisen', 'Crossing Upper Bar Pitch', 'Longueur de Traversée de la Barre supérieure', 'Crossing Upper Bar Pitch', '', '', 'Шаг верхней перекладины', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Depth', 6713296355332, 0, 'Tiefe', 'Depth', 'Profondeur', 'Βάθος', '', '', 'Глубина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Description', 1095347732485, 0, 'Beschreibung', 'Description', 'Description', 'Περιγραφή', '', '', 'Описание', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Diameter', 6713296355332, 0, 'Durchmesser', 'Diameter', 'Diamètre', 'Διάμετρος', '', '', 'Диаметр', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::DistanceBetweenComponentAxes', 6713296355332, 0, 'Abstand zwischen Komponentenachsen', 'Distance Between Component Axes', 'Distance entre les axes du composant', 'Απόσταση μεταξύ αξόνων των component', '', '', 'Расстояние между осями компонентов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::DurabilityRating', 1095347863557, 0, 'Beanspruchungsklasse', 'Durability Rating', 'Durabilité', 'Βαθμολογία αντοχής', '', '', 'Рейтинг долговечности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Duration', 1095348453381, 0, 'Dauer', 'Duration', 'Durée', 'Διάρκεια', '', '', 'Продолжительность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::EdgeDistanceToFirstAxis', 6713296355332, 0, 'Kantenabstand zur ersten Achse', 'Edge Distance To First Axis', 'Distance entre le bord et le premier axe', 'Απόσταση άκρου έως τον πρώτο άξονα', '', '', 'Расстояние от края до первой оси', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Eutrophication', 6713298911236, 0, 'Eutrophierung', 'Eutrophication', 'Eutrophisation', 'Ευτροφισμός', '', '', 'Эвтрофикация', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::EutrophicationPerUnit', 6713298911236, 0, 'Eutrophierung pro Einheit', 'Eutrophication Per Unit', 'Eutrophisation Par Unité', 'Ευτροφισμός ανά μονάδα', '', '', 'Эвтрофикация на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Exclusions', 1095347732485, 0, 'Ausschlüsse', 'Exclusions', 'Exclusions', 'Εξαιρέσεις', '', '', 'Исключения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ExpectedServiceLife', 6713301532676, 0, 'erwartete Lebensdauer', 'Expected Service Life', 'Duree De Vie Typique', 'Αναμενόμενη διάρκεια ζωής', '', '', 'Ожидаемый срок службы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ExtendToStructure', 4360503298, 0, 'Raumhohe Wand', 'Extend To Structure', 'Extension Structure', 'Επέκταση στη δομή', '', '', 'Расширить до структуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Finish', 1095347732485, 0, 'Oberflächengüte', 'Finish', 'Finition', 'Φινίρισμα', '', '', 'Конец', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::FireExit', 4360503298, 0, 'Notausgang', 'Fire Exit', 'Sortie Secours', 'Εξοδος κινδύνου', '', '', 'Пожарный выход', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::FireRating', 1095347863557, 0, 'Feuerwiderstandsklasse', 'Fire Rating', 'Resistance Au Feu', 'Βαθμολογία πυρκαγιάς', '', '', 'Огнестойкость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::FlammabilityRating', 1095347863557, 0, 'Entflammbarkeitsklasse', 'Flammability Rating', 'Inflammabilité', 'Βαθμολογία ευφλεκτότητας', '', '', 'Воспламеняемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::FragilityRating', 1095347863557, 0, 'Fragilitätsklasse', 'Fragility Rating', 'Fragilité', 'Βαθμολογία ευθραυστότητας', '', '', 'Хрупкость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::FunctionalUnitReference', 1095347863557, 0, 'Funktionale Einheitsreferenz', 'Functional Unit Reference', 'Reference Unite Fonctionnelle', 'Αναφορά λειτουργικής μονάδας', '', '', 'Справочник функциональных единиц', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::GlazingAreaFraction', 29803044274180, 0, 'Glasflächenanteil', 'GlazingAreaFraction', 'Fraction Surface Vitree', 'Υαλοπίνακας', '', '', 'Доля площади остекления', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::GlobalTradeItemNumber', 1095347929093, 0, 'Global Trade Item Number', 'Global Trade Item Number', 'Numéro d\'article du commerce mondial', 'Αριθμός είδους παγκόσμιου εμπορίου', '', '', 'Глобальный номер предмета торговли', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HandicapAccessible', 4360503298, 0, 'Behindertengerecht', 'Handicap Accessible', 'AccessibleHandicapes', 'Προσβάσιμο στο Χάντικαπ', '', '', 'Доступно для инвалидов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HasDrive', 4360503298, 0, 'Antrieb', 'Has Drive', 'Conduit', '', '', '', 'Есть диск', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HasNonSkidSurface', 4360503298, 0, 'Nichtrutschende Oberfläche', 'Has Non Skid Surface', 'AntiDerapant', 'Has Non Skid Surface', '', '', 'Имеет нескользящую поверхность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HasSillExternal', 4360503298, 0, 'Fensterbank aussen', 'Has Sill External', 'Seuil côté extérieur', 'Έχει εξωτερικό περβάζι', '', '', 'Имеет внешний подоконник', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HasSillInternal', 4360503298, 0, 'Fensterbank innen', 'Has Sill Internal', 'Seuil côté intérieur', 'Έχει εσωτερικό περβάζι', '', '', 'Имеет внутренний порог', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HazardousWaste', 6713298911236, 0, 'gefährlicher Abfall', 'Hazardous Waste', 'DechetsDangereux', 'Επικίνδυνα απόβλητα', '', '', 'Опасные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HazardousWastePerUnit', 6713298911236, 0, 'gefährlicher Abfall pro Einheit', 'Hazardous Waste Per Unit', 'DechetsDangereuxParUnite', 'Επικίνδυνα απόβλητα ανά μονάδα', '', '', 'Количество опасных отходов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Headroom', 6713296355332, 0, 'Durchgangshöhe', 'Headroom', 'HauteurPassage', 'Αίθουσα', '', '', 'Габаритная высота', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Height', 6713296355332, 0, 'Höhe', 'Height', 'Hauteur', 'Υψος', '', '', 'Высота', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HoopBarPitch', 6713296355332, 0, 'Reifen Armierungseisen Schlaglänge', 'Hoop Bar Pitch', 'Longueur de l\'Arceau', 'Hoop Bar Pitch', '', '', 'Шаг штанги обруча', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HorizontalBarPitch', 6713296355332, 0, 'Länge des horizontales Armierungseisen ', 'Horizontal Bar Pitch', 'Longueur de la Barre Horizontale', 'Οριζόντια μπάρα', '', '', 'Шаг горизонтальной штанги', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::HygrothermalRating', 1095347863557, 0, 'Klimaklasse', 'Hygrothermal Rating', 'Résistance hygrothermique', 'Υδροθερμική βαθμολογία', '', '', 'Гидротермальность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::InertWaste', 6713298911236, 0, 'Inerte Abfälle', 'Inert Waste', 'DechetsInertes', 'Αδρανή απόβλητα', '', '', 'Инертные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::InertWastePerUnit', 6713298911236, 0, 'Inerte Abfälle pro Einheit', 'Inert Waste Per Unit', 'DechetsInertesParUnite', 'Αδρανή απόβλητα ανά μονάδα', '', '', 'Инертные отходы на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Infiltration', 29803044208644, 0, 'Luftdurchlässigkeit', 'Infiltration', 'TauxInfiltration', 'Διήθηση', '', '', 'Проникновение', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::IsExtendedWarranty', 4360503298, 0, 'Erweiterte Garantie', 'Is Extended Warranty', 'Extension de Garantie', 'Έχει εκτεταμένη εγγύηση', '', '', 'Расширенная гарантия', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::IsExternal', 4360503298, 0, 'Außenbauteil', 'Is External', 'Externe', 'Είναι εξωτερικό', '', '', 'Внешний', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LeadInTime', 1095348453381, 0, 'Einlaufzeit', 'Lead In Time', 'Début d\'Exécution', 'Περίοδος διακοπής', '', '', 'Время выполнения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LeadOutTime', 1095348453381, 0, 'Auslaufzeit', 'Lead Out Time', 'Fin d\'Exécution', 'Χρόνος παράδοσης', '', '', 'Время вывода', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LifeCyclePhase', 1095347863557, 0, 'Lebenszyklusphase', 'Life Cycle Phase', 'Phase Cycle De Vie', 'Φάση κύκλου ζωής', '', '', 'Фаза жизненного цикла', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LoadBearing', 4360503298, 0, 'Tragendes Bauteil', 'Load Bearing', 'Porteur', 'Φέρον φορτίο', '', '', 'Несущая способность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongInsideCenterLowerBarPitch', 6713296355332, 0, 'Innenlänge des langen mittigen oberen Armierungseisen', 'Long Inside Center Lower Bar Pitch', 'Longueur intérieure de la barre inférieure centrale longue', 'Long Inside Center Lower Bar Pitch', '', '', 'Внутренняя длина длинного центрального нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongInsideCenterTopBarPitch', 6713296355332, 0, 'Innenlänge des langen mittigen oberen Armierungseisen', 'Long Inside Center Top Bar Pitch', 'Longueur intérieure de la barre supérieure centrale longue', 'Long Inside Center Top Bar Pitch', '', '', 'Внутренняя длина длинного центрального верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongInsideEndLowerBarPitch', 6713296355332, 0, 'Innenlänge des langen letzten unteren Armierungseisen', 'Long Inside End Lower Bar Pitch', 'Longueur intérieure de la dernière barre inférieure longue', 'Long Inside End Lower Bar Pitch', '', '', 'Внутренняя длина крайней нижней продольной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongInsideEndTopBarPitch', 6713296355332, 0, 'Innenlänge des langen letzten oberen Armierungseisen', 'Long Inside End Top Bar Pitch', 'Longueur intérieure de la dernière barre supérieure longue', 'Long Inside End Top Bar Pitch', '', '', 'Внутренняя длина крайней верхней продольной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongOutsideLowerBarPitch', 6713296355332, 0, 'Aussenlänge des langen unteren Armierungseisen', 'Long Outside Lower Bar Pitch', 'Longueur extérieure de la barre inférieure longue', 'Long Outside Lower Bar Pitch', '', '', 'Наружная длина продольной нижней арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::LongOutsideTopBarPitch', 6713296355332, 0, 'Aussenlänge des langen oberen Armierungseisen', 'Long Outside Top Bar Pitch', 'Longueur extérieure de la barre supérieure longue', 'Long Outside Top Bar Pitch', '', '', 'Внешняя длина продольной верхней арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Manufacturer', 1095347863557, 0, 'Hersteller', 'Manufacturer', 'Fabricant', 'Κατασκευαστής', '', '', 'Производитель', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::MeanTimeBetweenFailure', 1095348453381, 0, 'Durchschnittliche Fehlerfreie Betriebszeit', 'Mean Time Between Failure', 'Temps Moyen Entre Pannes', 'Μέσος χρόνος μεταξύ αστοχίας', '', '', 'Среднее время наработки на отказ', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::MechanicalLoadRating', 1095347863557, 0, 'Mechanische Tragfähigkeit', 'Mechanical Load Rating', 'Charge Mécanique Nominale', 'Βαθμός μηχανικού φορτίου', '', '', 'Номинальная механическая нагрузка', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::MechanicalOperated', 4360503298, 0, 'Mechanisch', 'Mechanical Operated', 'Actionné Mécaniquement', 'Μηχανική λειτουργία', '', '', 'Механический привод', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ModelLabel', 1095347863557, 0, 'Modelletikett', 'Model Label', 'Etiquette du Modèle', 'Ετικέτα μοντέλου', '', '', 'Этикетка модели', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ModelReference', 1095347863557, 0, 'Modellreferenz', 'Model Reference', 'Référence du Modèle', 'Μοντέλο αναφορά', '', '', 'Ссылка на модель', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NominalThickness', 6713296355332, 0, 'Nenndicke', 'Nominal Thickness', 'Epaisseur Nominale', 'Ονομαστικό πάχος', '', '', 'Номинальная толщина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NominalToppingThickness', 6713296355332, 0, 'nominelle Plattenstärke', 'Nominal Topping Thickness', 'Epaisseur Nominale de la Garniture', 'Ονομαστικό πάχος κάλυψης', '', '', 'Номинальная толщина покрытия', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NonHazardousWaste', 6713298911236, 0, 'Ungefährliche Abfälle', 'Non Hazardous Waste', 'DechetsNonDangereux', 'Μη επικίνδυνα απόβλητα', '', '', 'Неопасные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NonHazardousWastePerUnit', 6713298911236, 0, 'Ungefährliche Abfälle pro Einheit', 'Non Hazardous Waste Per Unit', 'DechetsNonDangereuxParUnite', 'Μη επικίνδυνα απόβλητα ανά μονάδα', '', '', 'Неопасные отходы на единицу продукции', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NonRenewableEnergyConsumption', 6713297534980, 0, 'Nicht erneuerbarer Energieverbrauch', 'Non Renewable Energy Consumption', 'ConsommationEnergieNonRenouvelable', 'Κατανάλωση μη ανανεώσιμης ενέργειας', '', '', 'Невозобновляемое потребление энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NonRenewableEnergyConsumptionPerUnit', 6713297534980, 0, 'Nicht erneuerbarer Energieverbrauch pro Einheit', 'Non Renewable Energy Consumption Per Unit', 'ConsommationEnergieNonRenouvelableParUnite', 'Κατανάλωση μη ανανεώσιμης ενέργειας ανά μονάδα', '', '', 'Потребление невозобновляемой энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NosingLength', 6713296289796, 0, 'Überstand', 'Nosing Length', 'Hauteur de passage requise', 'Απαιτούμενο ύψος διέλευσης', '', '', 'Длина окантовки ступени', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Number', 282570324443141, 0, 'Nummer', 'Number', '', '', '', '', '', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NumberOfDrafts', 86096084994, 0, 'Zügigkeit', 'Number Of Drafts', 'Nombre de conduits', 'Αριθμός σχεδίων', '', '', 'Количество маршев', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NumberOfRiser', 86096084994, 0, 'Anzahl der Steigungen', 'Number Of Riser', 'NombreContreMarches', 'Αριθμός κλίσεων', '', '', 'Количество подъемов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::NumberOfTreads', 86096084994, 0, 'Anzahl der Auftritte', 'Number Of Treads', 'NombreGirons', 'Αριθμός εμφανίσεων', '', '', 'Количество ступеней', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::PhotochemicalOzoneFormation', 6713298911236, 0, 'Photochemische Ozonbildung', 'Photochemical Ozone Formation', 'FormationOzonePhotochimique', 'Φωτοχημικός σχηματισμός όζοντος', '', '', 'Фотохимическое образование озона', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::PhotochemicalOzoneFormationPerUnit', 6713298911236, 0, 'Photochemische Ozonbildung pro Einheit', 'Photochemical Ozone Formation Per Unit', 'FormationOzonePhotochimiqueParUnite', 'Φωτοχημικός σχηματισμός όζοντος ανά μονάδα', '', '', 'Фотохимическое образование озона на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::PitchAngle', 6713296486404, 0, 'Dachflächenneigung', 'Pitch Angle', 'AngleInclinaison', 'Κλίση οροφής', '', '', 'Наклон крыши', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::PointOfContact', 1095347863557, 0, 'Kontaktstelle', 'Point Of Contact', 'Point de Contact', 'Σημείο επαφής', '', '', 'Точка касания', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ProductionYear', 1095347863557, 0, 'Produktionsjahr', 'Production Year', 'Année de Fabrication', 'Έτος παραγωγής', '', '', 'Год выпуска', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RadioactiveWaste', 6713298911236, 0, 'Radioaktiver Abfall', 'Radioactive Waste', 'DechetsRadioactifs', 'Ραδιενεργά απόβλητα', '', '', 'Радиоактивные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RadioactiveWastePerUnit', 6713298911236, 0, 'Radioaktiver Abfall pro Einheit', 'Radioactive Waste Per Unit', 'DechetsRadioactifsParUnite', 'Ραδιενεργά απόβλητα ανά μονάδα', '', '', 'Радиоактивных отходов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Reference', 1095347929093, 0, 'Bauteiltyp', 'Reference', 'Reference', 'Αναφορά', '', '', 'Тип компонента', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ReinforcementBarType', 1095347863557, 0, 'Betonstahltyp', 'ReinforcementBarType', 'Type d\'Acier à Béton', 'Τύπος ενίσχυσης', '', '', 'Тип арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RenewableEnergyConsumption', 6713297534980, 0, 'Erneuerbarer Energieverbrauch', 'Renewable Energy Consumption', 'ConsommationEnergieRenouvelable', 'Κατανάλωση ανανεώσιμων πηγών ενέργειας', '', '', 'Потребление возобновляемой энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RenewableEnergyConsumptionPerUnit', 6713297534980, 0, 'Erneuerbarer Energieverbrauch pro Einheit', 'Renewable Energy Consumption Per Unit', 'ConsommationEnergieRenouvelableParUnite', 'Κατανάλωση ανανεώσιμης ενέργειας ανά μονάδα', '', '', 'Потребление возобновляемой энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RequiredHeadroom', 6713296355332, 0, 'erforderliche Durchgangshöhe', 'Required Headroom', 'HauteurPassageRequise', 'Απαιτούμενο ύψος διέλευσης', '', '', 'Требуемый запас по высоте', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RequiredSlope', 6713296486404, 0, 'erforderliche Neigung', 'Required Slope', 'InclinaisonRequise', 'Απαιτούμενη κλίση', '', '', 'Требуемый уклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ResourceDepletion', 6713298911236, 0, 'Rohstoffserschöpfung', 'Resource Depletion', 'EpuisementRessources', 'Εξάντληση πόρων', '', '', 'Истощение ресурсов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ResourceDepletionPerUnit', 6713298911236, 0, 'Rohstoffserschöpfung pro Einheit', 'Resource Depletion Per Unit', 'EpuisementRessourcesParUnite', 'Εξάντληση πόρων ανά μονάδα', '', '', 'Истощение ресурсов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::RiserHeight', 6713296355332, 0, 'Steigung', 'Riser Height', 'HauteurContreMarche', 'Υψηλότερο ύψος', '', '', 'Высота подъема', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Roll', 6713296486404, 0, 'Kippwinkel', 'Roll', 'Rotation Autour Axe Longitudinal', 'Περιστροφή γύρω από τον διαμήκη άξονα', '', '', 'Рулон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Roughness', 1095347863557, 0, 'Rauheit der Oberfläche', 'Roughness', 'Rugosité', 'Τραχύτητα', '', '', 'Шероховатость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SecurityRating', 1095347863557, 0, 'Sicherheitsklasse', 'Security Rating', 'NiveauSecurite', 'Βαθμός ασφάλειας', '', '', 'Безопастность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SelfClosing', 4360503298, 0, 'Selbstschliessend', 'Self Closing', 'FermetureAutomatique', 'Αυτόματο κλείσιμο', '', '', 'Самозакрывающийся', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SerialNumber', 1095347929093, 0, 'Seriennummer', 'Serial Number', 'Numéro de série', 'Σειριακός αριθμός', '', '', 'Серийный номер', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ServiceLifeDuration', 1095348453381, 0, 'Lebensdauer', 'Service Life Duration', 'Durée du service', 'Διάρκεια ζωής υπηρεσίας', '', '', 'Срока службы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShadingDeviceType', 1095347863557, 0, 'Sonnenschutztyp', 'ShadingDeviceType', 'Type de protection solaire', 'Τύπος ηλιοπροστασίας', '', '', 'Тип затеняющего устройства', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Shape', 1095347863557, 0, 'Form', 'Shape', 'Forme', 'Σχήμα', '', '', 'Форма', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortInsideCenterLowerBarPitch', 6713296355332, 0, 'Innenlänge des kurzen mittleren unteren Armierungseisen', 'Short Inside Center Lower Bar Pitch', 'Longueur intérieure de la barre inférieure centrale courte', 'Short Inside Center Lower Bar Pitch', '', '', 'Внутренняя длина короткого среднего нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortInsideCenterTopBarPitch', 6713296355332, 0, 'Innenlänge des kurzen mittleren oberen Armierungseisen', 'Short Inside Center Top Bar Pitch', 'Longueur intérieure de la barre supérieure centrale courte', 'Short Inside Center Top Bar Pitch', '', '', 'Внутренняя длина короткого среднего верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortInsideEndLowerBarPitch', 6713296355332, 0, 'Innenlänge des kurzen letzten unteren Armierungseisen', 'Short Inside End Lower Bar Pitch', 'Longueur intérieure de la dernière barre inférieure courte', 'Short Inside End Lower Bar Pitch', '', '', 'Внутренняя длина короткого последнего нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortInsideEndTopBarPitch', 6713296355332, 0, 'Innenlänge des kurzen letzten oberen Armierungseisen', 'Short Inside End Top Bar Pitch', 'Longueur intérieure de la dernière barre supérieure courte', 'Short Inside End Top Bar Pitch', '', '', 'Внутренняя длина короткого последнего верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortOutsideLowerBarPitch', 6713296355332, 0, 'Außenlänge des kurzen unteren Armierungseisen', 'Short Outside Lower Bar Pitch', 'Longueur extérieure de la barre inférieure courte', 'Short Outside Lower Bar Pitch', '', '', 'Внешняя длина короткого нижнего арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ShortOutsideTopBarPitch', 6713296355332, 0, 'Außenlänge des kurzen oberen Armierungseisen', 'Short Outside Top Bar Pitch', 'Longueur extérieure de la barre supérieure courte', 'Short Outside Top Bar Pitch', '', '', 'Внешняя длина короткого верхнего арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Slope', 6713296486404, 0, 'Neigungswinkel', 'Slope', 'Inclinaison', 'Κλίση', '', '', 'Наклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SmokeStop', 4360503298, 0, 'Rauchschutz', 'Smoke Stop', 'CoupeFumee', 'Διακοπή καπνού', '', '', 'Защита от дыма', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SolarReflectance', 29803044274180, 0, 'Strahlungsreflectionsgrad', 'Solar Reflectance', 'Reflexion du rayonnement solaire', 'Ηλιακή Αντανάκλαση', '', '', 'Солнечное отражение', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SolarTransmittance', 29803044274180, 0, 'Strahlungstransmissionsgrad', 'Solar Transmittance', 'Transmission du rayonnement solaire', 'Ηλιακή μετάδοση', '', '', 'Солнечная пропускаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SpacingBarPitch', 6713296355332, 0, 'Länge des Armierungseisen', 'Spacing Bar Pitch', 'Expacement des barres', 'Μήκος της ράβδου', '', '', 'Шаг распорки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Span', 6713296355332, 0, 'Spannweite', 'Span', 'Portée Libre', 'Άνοιγμα', '', '', 'Ширина пролета', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::StirrupBarPitch', 6713296355332, 0, 'Länge des Armierungseisen-Bügel ', 'Stirrup Bar Pitch', 'Longueur de l\'étrier', 'Κλίση συνδετήρων ', '', '', 'Шаг хомутов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::StratosphericOzoneLayerDestruction', 6713298911236, 0, 'Zerstörung der stratosphärischen Ozonschicht', 'Stratospheric Ozone Layer Destruction', 'DestructionCoucheOzoneStartospherique', 'Καταστροφή στρωματοσφαιρικού στρώματος όζοντος', '', '', 'Разрушение стратосферного озонового слоя', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::StratosphericOzoneLayerDestructionPerUnit', 6713298911236, 0, 'Zerstörung der stratosphärischen Ozonschicht pro Einheit', 'Stratospheric Ozone Layer Destruction Per Unit', 'DestructionCoucheOzoneStartospheriqueParUnite', 'Καταστροφή στρωματοσφαιρικού στρώματος όζοντος ανά μονάδα', '', '', 'Разрушение стратосферного озонового слоя на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SurfaceColor', 1095347863557, 0, 'Oberflächenfarbe', 'Surface Color', 'Couleur surface', 'Χρώμα επιφάνειας', '', '', 'Цвет поверхности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::SurfaceSpreadOfFlame', 1095347863557, 0, 'Brandverhalten', 'Surface Spread Of Flame', 'SurfacePropagationFlamme', 'Επιφάνεια διάδοσης φλόγας', '', '', 'Распространение пламени по поверхности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::System', 1095347863557, 0, 'Anlage', 'System', 'Système', 'Σύστημα', '', '', 'Система', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ThermalTransmittance', 6713301401604, 0, 'U-Wert', 'Thermal Transmittance', 'Transmission thermique surfacique', 'Θερμική μετάδοση', '', '', 'Тепловая проницаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::ToppingType', 1095347863557, 0, 'Plattentyp', 'Topping Type', 'Type de garniture', 'Τύπος κορυφής', '', '', 'Тип плиты', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TotalPrimaryEnergyConsumption', 6713297534980, 0, 'Gesamter Primärenergieverbrauch', 'Total Primary Energy Consumption', 'ConsommationTotaleEnergiePrimaire', 'Συνολική κατανάλωση πρωτογενούς ενέργειας', '', '', 'Общее потребление первичной энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TotalPrimaryEnergyConsumptionPerUnit', 6713297534980, 0, 'Gesamter Primärenergieverbrauch pro Einheit', 'Total Primary Energy Consumption Per Unit', 'ConsommationTotaleEnergiePrimaireParUnite', 'Συνολική κατανάλωση πρωτογενούς ενέργειας ανά μονάδα', '', '', 'Общее потребление первичной энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TreadLength', 6713296355332, 0, 'Auftritt', 'Tread Length', 'Longueur du Giron', 'Μήκος πέλματος', '', '', 'Длина ступени', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TreadLengthAtInnerSide', 6713296355332, 0, 'minimaler Auftritt an der Innenseite', 'Tread Length At Inner Side', 'Longueur intérieure du Giron', 'Μήκος πέλματος στην εσωτερική πλευρά', '', '', 'Длина ступени с внутренней стороны', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TreadLengthAtOffset', 6713296355332, 0, 'Auftritt an der Lauflinie', 'Tread Length At Offset', 'Longueur extérieure du Giron', 'Μήκος πέλματος σε μετατόπιση', '', '', 'Длина ступени со смещением', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::TypeDesignator', 1095347863557, 0, 'Typ Bezeichner', 'Type Designator', 'Indicateur de Type', 'Τύπος προσδιοριστής', '', '', 'Обозначение типа', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Unit', 1095347732485, 0, 'Einheit', 'Unit', 'Unité', 'Μονάδα', '', '', 'Единица измерения (ед. изм.)', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::VerticalBarPitch', 6713296355332, 0, 'Länge des vertikalen Armierungseisen ', 'Vertical Bar Pitch', 'Espacement Vertical de la Barre', 'Μήκος κατακόρυφης ράβδου', '', '', 'Шаг вертикальной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::VisibleLightReflectance', 29803044274180, 0, 'Reflektionsgrad für sichtbares Licht', 'Visible Light Reflectance', 'Reflexion du rayonnement visible', 'Βαθμός ανάκλασης για ορατό φως', '', '', 'Отражение видимого света', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::VisibleLightTransmittance', 29803044274180, 0, 'Transmissionsgrad für sichtbares Licht', 'Visible Light Transmittance', 'Transmittance du rayonnement visible', 'Ορατή μετάδοση ακτινοβολίας', '', '', 'Пропускание видимого света', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WaistThickness', 6713296355332, 0, 'minimale Dicke des Treppenplatte', 'Waist Thickness', 'Epaisseur minimale', 'Πάχος μέσης', '', '', 'Минимальная толщина лестничной плиты', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WalkingLineOffset', 6713296355332, 0, 'Abstand der Lauflinie', 'Walking Line Offset', 'Ligne de foulée', 'Μετατόπιση γραμμής κίνησης', '', '', 'Смещение бегущей строки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WarrantyContent', 1095347732485, 0, 'Garantieinhalt', 'Warranty Content', 'Limites de garantie', 'Περιεχόμενο εγγύησης', '', '', 'Гарантия Содержание', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WarrantyEndDate', 1095348322309, 0, 'Garantie-Enddatum', 'Warranty End Date', 'Fin de garantie', 'Ημερομηνία λήξης εγγύησης', '', '', 'Дата окончания гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WarrantyIdentifier', 1095347929093, 0, 'Garantiekennung', 'Warranty Identifier', 'Identifiant de garantie', 'Αναγνωριστικό εγγύησης', '', '', 'Идентификатор гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WarrantyPeriod', 1095348453381, 0, 'Garantiezeit', 'Warranty Period', 'Période de garantie', 'Περίοδος εγγύησης', '', '', 'Гарантийный срок', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WarrantyStartDate', 1095348322309, 0, 'Garantie-Startdatum', 'Warranty Start Date', 'Début de garantie', 'Ημερομηνία έναρξης εγγύησης', '', '', 'Дата начала гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WaterConsumption', 6713296420868, 0, 'Wasserverbrauch', 'Water Consumption', 'ConsommationEau', 'Κατανάλωση νερού', '', '', 'Расход воды', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WaterConsumptionPerUnit', 6713296420868, 0, 'Wasserverbrauch pro Einheit', 'Water Consumption Per Unit', 'ConsommationEauParUnite', 'Κατανάλωση νερού ανά μονάδα', '', '', 'Расход воды на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WaterTightnessRating', 1095347863557, 0, 'Wasserdichtheitsklasse', 'Water Tightness Rating', 'Indice d\'étanchéité', 'Βαθμολογία στεγανότητας νερού', '', '', 'Водонепроницаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::Width', 6713296355332, 0, 'Breite', 'Width', 'Largeur', 'Πλάτος', '', '', 'Ширина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::WindLoadRating', 1095347863557, 0, 'Windlastklasse', 'Wind Load Rating', 'Indice de résistance au vent', 'Βαθμός φορτίου ανέμου', '', '', 'Ветровая нагрузка', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::XDirectionLowerBarCount', 86095953922, 0, 'Anzahl unterer Träger in X Richtung', 'X-Direction Lower Bar Count', 'Nombre de barres inférieures dans la direction X', 'Αριθμός κάτω ράβδων στην διεύθυνση X', '', '', 'Количество нижних стержней в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::XDirectionTieHoopBarPitch', 6713296355332, 0, 'Länge der Bindugsreifen Armierungseisen in X-Richtung ', 'X-Direction Tie Hoop Bar Pitch', 'Longueur des arceaux  dans le sens X ', 'X-Direction Tie Hoop Bar Pitch', '', '', 'Длина соединительных шин стержней направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::XDirectionTieHoopCount', 86095953922, 0, 'Anzahl  Bindungsreifen in X-Richtung', 'X-Direction Tie Hoop Count', 'Nombre d\'arceaux  dans le sens X', 'Πλήθος X-Direction Tie Hoop', '', '', 'Количество связующих шин в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::XDirectionUpperBarCount', 86095953922, 0, 'Anzahl oberer Träger in X Richtung', 'X-Direction Upper Bar Count', 'Nombre de barres supérieures dans la direction X', 'Αριθμός άνω ράβδων στην διεύθυνση X', '', '', 'Количество верхних стержней в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::YDirectionLowerBarCount', 86095953922, 0, 'Anzahl unterer Träger in Y Richtung', 'Y-Direction Lower Bar Count', 'Nombre de barres inférieures dans la direction Y', 'Αριθμός κάτω ράβδων στην διεύθυνση Υ', '', '', 'Количество нижних стержней в направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::YDirectionTieHoopBarPitch', 6713296355332, 0, 'Länge der Bindungsreifen Armierungseisen in Y-Richtung', 'Y-Direction Tie Hoop Bar Pitch', 'Longueur des arceaux  dans le sens Y ', 'Y-Direction Tie Hoop Bar Pitch', '', '', 'Длина соединительных шин стержней направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::YDirectionTieHoopCount', 86095953922, 0, 'Anzahl Bindungsreifen in Y-Richtung ', 'Y-Direction Tie Hoop Count', 'Nombre d\'arceaux  dans le sens Y ', 'Y-Direction Tie Hoop Count', '', '', 'Количество связующих шин в направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(1, 'free::YDirectionUpperBarCount', 86095953922, 0, 'Anzahl oberer Träger in Y Richtung', 'Y-Direction Upper Bar Count', 'Nombre de barres supérieures dans la direction Y', 'Αριθμός άνω ράβδων στην διεύθυνση Υ', '', '', 'Количество верхних стержней в направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'FunctionalUnitReference', 1095347863557, 0, 'Funktionale Einheitsreferenz', 'Functional Unit Reference', 'Reference Unite Fonctionnelle', 'Αναφορά λειτουργικής μονάδας', '', '', 'Справочник функциональных единиц', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'GlazingAreaFraction', 29803044274180, 0, 'Glasflächenanteil', 'GlazingAreaFraction', 'Fraction Surface Vitree', 'Υαλοπίνακας', '', '', 'Доля площади остекления', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'GlobalTradeItemNumber', 1095347929093, 0, 'Global Trade Item Number', 'Global Trade Item Number', 'Numéro d\'article du commerce mondial', 'Αριθμός είδους παγκόσμιου εμπορίου', '', '', 'Глобальный номер предмета торговли', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HandicapAccessible', 4360503298, 0, 'Behindertengerecht', 'Handicap Accessible', 'AccessibleHandicapes', 'Προσβάσιμο στο Χάντικαπ', '', '', 'Доступно для инвалидов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HasDrive', 4360503298, 0, 'Antrieb', 'Has Drive', 'Conduit', '', '', '', 'Есть диск', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HasNonSkidSurface', 4360503298, 0, 'Nichtrutschende Oberfläche', 'Has Non Skid Surface', 'AntiDerapant', 'Has Non Skid Surface', '', '', 'Имеет нескользящую поверхность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HasSillExternal', 4360503298, 0, 'Fensterbank aussen', 'Has Sill External', 'Seuil côté extérieur', 'Έχει εξωτερικό περβάζι', '', '', 'Имеет внешний подоконник', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HasSillInternal', 4360503298, 0, 'Fensterbank innen', 'Has Sill Internal', 'Seuil côté intérieur', 'Έχει εσωτερικό περβάζι', '', '', 'Имеет внутренний порог', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HazardousWaste', 6713298911236, 0, 'gefährlicher Abfall', 'Hazardous Waste', 'DechetsDangereux', 'Επικίνδυνα απόβλητα', '', '', 'Опасные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HazardousWastePerUnit', 6713298911236, 0, 'gefährlicher Abfall pro Einheit', 'Hazardous Waste Per Unit', 'DechetsDangereuxParUnite', 'Επικίνδυνα απόβλητα ανά μονάδα', '', '', 'Количество опасных отходов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Headroom', 6713296355332, 0, 'Durchgangshöhe', 'Headroom', 'HauteurPassage', 'Αίθουσα', '', '', 'Габаритная высота', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Height', 6713296355332, 0, 'Höhe', 'Height', 'Hauteur', 'Υψος', '', '', 'Высота', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HoopBarPitch', 6713296355332, 0, 'Reifen Armierungseisen Schlaglänge', 'Hoop Bar Pitch', 'Longueur de l\'Arceau', 'Hoop Bar Pitch', '', '', 'Шаг штанги обруча', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HorizontalBarPitch', 6713296355332, 0, 'Länge des horizontales Armierungseisen ', 'Horizontal Bar Pitch', 'Longueur de la Barre Horizontale', 'Οριζόντια μπάρα', '', '', 'Шаг горизонтальной штанги', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'HygrothermalRating', 1095347863557, 0, 'Klimaklasse', 'Hygrothermal Rating', 'Résistance hygrothermique', 'Υδροθερμική βαθμολογία', '', '', 'Гидротермальность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'InertWaste', 6713298911236, 0, 'Inerte Abfälle', 'Inert Waste', 'DechetsInertes', 'Αδρανή απόβλητα', '', '', 'Инертные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'InertWastePerUnit', 6713298911236, 0, 'Inerte Abfälle pro Einheit', 'Inert Waste Per Unit', 'DechetsInertesParUnite', 'Αδρανή απόβλητα ανά μονάδα', '', '', 'Инертные отходы на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Infiltration', 29803044208644, 0, 'Luftdurchlässigkeit', 'Infiltration', 'TauxInfiltration', 'Διήθηση', '', '', 'Проникновение', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'IsExtendedWarranty', 4360503298, 0, 'Erweiterte Garantie', 'Is Extended Warranty', 'Extension de Garantie', 'Έχει εκτεταμένη εγγύηση', '', '', 'Расширенная гарантия', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'IsExternal', 4360503298, 0, 'Außenbauteil', 'Is External', 'Externe', 'Είναι εξωτερικό', '', '', 'Внешний', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LeadInTime', 1095348453381, 0, 'Einlaufzeit', 'Lead In Time', 'Début d\'Exécution', 'Περίοδος διακοπής', '', '', 'Время выполнения', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LeadOutTime', 1095348453381, 0, 'Auslaufzeit', 'Lead Out Time', 'Fin d\'Exécution', 'Χρόνος παράδοσης', '', '', 'Время вывода', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LifeCyclePhase', 1095347863557, 0, 'Lebenszyklusphase', 'Life Cycle Phase', 'Phase Cycle De Vie', 'Φάση κύκλου ζωής', '', '', 'Фаза жизненного цикла', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LoadBearing', 4360503298, 0, 'Tragendes Bauteil', 'Load Bearing', 'Porteur', 'Φέρον φορτίο', '', '', 'Несущая способность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongInsideCenterLowerBarPitch', 6713296355332, 0, 'Innenlänge des langen mittigen oberen Armierungseisen', 'Long Inside Center Lower Bar Pitch', 'Longueur intérieure de la barre inférieure centrale longue', 'Long Inside Center Lower Bar Pitch', '', '', 'Внутренняя длина длинного центрального нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongInsideCenterTopBarPitch', 6713296355332, 0, 'Innenlänge des langen mittigen oberen Armierungseisen', 'Long Inside Center Top Bar Pitch', 'Longueur intérieure de la barre supérieure centrale longue', 'Long Inside Center Top Bar Pitch', '', '', 'Внутренняя длина длинного центрального верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongInsideEndLowerBarPitch', 6713296355332, 0, 'Innenlänge des langen letzten unteren Armierungseisen', 'Long Inside End Lower Bar Pitch', 'Longueur intérieure de la dernière barre inférieure longue', 'Long Inside End Lower Bar Pitch', '', '', 'Внутренняя длина крайней нижней продольной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongInsideEndTopBarPitch', 6713296355332, 0, 'Innenlänge des langen letzten oberen Armierungseisen', 'Long Inside End Top Bar Pitch', 'Longueur intérieure de la dernière barre supérieure longue', 'Long Inside End Top Bar Pitch', '', '', 'Внутренняя длина крайней верхней продольной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongOutsideLowerBarPitch', 6713296355332, 0, 'Aussenlänge des langen unteren Armierungseisen', 'Long Outside Lower Bar Pitch', 'Longueur extérieure de la barre inférieure longue', 'Long Outside Lower Bar Pitch', '', '', 'Наружная длина продольной нижней арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'LongOutsideTopBarPitch', 6713296355332, 0, 'Aussenlänge des langen oberen Armierungseisen', 'Long Outside Top Bar Pitch', 'Longueur extérieure de la barre supérieure longue', 'Long Outside Top Bar Pitch', '', '', 'Внешняя длина продольной верхней арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Manufacturer', 1095347863557, 0, 'Hersteller', 'Manufacturer', 'Fabricant', 'Κατασκευαστής', '', '', 'Производитель', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'MeanTimeBetweenFailure', 1095348453381, 0, 'Durchschnittliche Fehlerfreie Betriebszeit', 'Mean Time Between Failure', 'Temps Moyen Entre Pannes', 'Μέσος χρόνος μεταξύ αστοχίας', '', '', 'Среднее время наработки на отказ', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'MechanicalLoadRating', 1095347863557, 0, 'Mechanische Tragfähigkeit', 'Mechanical Load Rating', 'Charge Mécanique Nominale', 'Βαθμός μηχανικού φορτίου', '', '', 'Номинальная механическая нагрузка', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'MechanicalOperated', 4360503298, 0, 'Mechanisch', 'Mechanical Operated', 'Actionné Mécaniquement', 'Μηχανική λειτουργία', '', '', 'Механический привод', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ModelLabel', 1095347863557, 0, 'Modelletikett', 'Model Label', 'Etiquette du Modèle', 'Ετικέτα μοντέλου', '', '', 'Этикетка модели', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ModelReference', 1095347863557, 0, 'Modellreferenz', 'Model Reference', 'Référence du Modèle', 'Μοντέλο αναφορά', '', '', 'Ссылка на модель', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NominalThickness', 6713296355332, 0, 'Nenndicke', 'Nominal Thickness', 'Epaisseur Nominale', 'Ονομαστικό πάχος', '', '', 'Номинальная толщина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NominalToppingThickness', 6713296355332, 0, 'nominelle Plattenstärke', 'Nominal Topping Thickness', 'Epaisseur Nominale de la Garniture', 'Ονομαστικό πάχος κάλυψης', '', '', 'Номинальная толщина покрытия', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NonHazardousWaste', 6713298911236, 0, 'Ungefährliche Abfälle', 'Non Hazardous Waste', 'DechetsNonDangereux', 'Μη επικίνδυνα απόβλητα', '', '', 'Неопасные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NonHazardousWastePerUnit', 6713298911236, 0, 'Ungefährliche Abfälle pro Einheit', 'Non Hazardous Waste Per Unit', 'DechetsNonDangereuxParUnite', 'Μη επικίνδυνα απόβλητα ανά μονάδα', '', '', 'Неопасные отходы на единицу продукции', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NonRenewableEnergyConsumption', 6713297534980, 0, 'Nicht erneuerbarer Energieverbrauch', 'Non Renewable Energy Consumption', 'ConsommationEnergieNonRenouvelable', 'Κατανάλωση μη ανανεώσιμης ενέργειας', '', '', 'Невозобновляемое потребление энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NonRenewableEnergyConsumptionPerUnit', 6713297534980, 0, 'Nicht erneuerbarer Energieverbrauch pro Einheit', 'Non Renewable Energy Consumption Per Unit', 'ConsommationEnergieNonRenouvelableParUnite', 'Κατανάλωση μη ανανεώσιμης ενέργειας ανά μονάδα', '', '', 'Потребление невозобновляемой энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NosingLength', 6713296289796, 0, 'Überstand', 'Nosing Length', 'Hauteur de passage requise', 'Απαιτούμενο ύψος διέλευσης', '', '', 'Длина окантовки ступени', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NumberOfDrafts', 86096084994, 0, 'Zügigkeit', 'Number Of Drafts', 'Nombre de conduits', 'Αριθμός σχεδίων', '', '', 'Количество маршев', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NumberOfRiser', 86096084994, 0, 'Anzahl der Steigungen', 'Number Of Riser', 'NombreContreMarches', 'Αριθμός κλίσεων', '', '', 'Количество подъемов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'NumberOfTreads', 86096084994, 0, 'Anzahl der Auftritte', 'Number Of Treads', 'NombreGirons', 'Αριθμός εμφανίσεων', '', '', 'Количество ступеней', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'PhotochemicalOzoneFormation', 6713298911236, 0, 'Photochemische Ozonbildung', 'Photochemical Ozone Formation', 'FormationOzonePhotochimique', 'Φωτοχημικός σχηματισμός όζοντος', '', '', 'Фотохимическое образование озона', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'PhotochemicalOzoneFormationPerUnit', 6713298911236, 0, 'Photochemische Ozonbildung pro Einheit', 'Photochemical Ozone Formation Per Unit', 'FormationOzonePhotochimiqueParUnite', 'Φωτοχημικός σχηματισμός όζοντος ανά μονάδα', '', '', 'Фотохимическое образование озона на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'PitchAngle', 6713296486404, 0, 'Dachflächenneigung', 'Pitch Angle', 'AngleInclinaison', 'Κλίση οροφής', '', '', 'Наклон крыши', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'PointOfContact', 1095347863557, 0, 'Kontaktstelle', 'Point Of Contact', 'Point de Contact', 'Σημείο επαφής', '', '', 'Точка касания', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ProductionYear', 1095347863557, 0, 'Produktionsjahr', 'Production Year', 'Année de Fabrication', 'Έτος παραγωγής', '', '', 'Год выпуска', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RadioactiveWaste', 6713298911236, 0, 'Radioaktiver Abfall', 'Radioactive Waste', 'DechetsRadioactifs', 'Ραδιενεργά απόβλητα', '', '', 'Радиоактивные отходы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RadioactiveWastePerUnit', 6713298911236, 0, 'Radioaktiver Abfall pro Einheit', 'Radioactive Waste Per Unit', 'DechetsRadioactifsParUnite', 'Ραδιενεργά απόβλητα ανά μονάδα', '', '', 'Радиоактивных отходов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Reference', 1095347929093, 0, 'Bauteiltyp', 'Reference', 'Reference', 'Αναφορά', '', '', 'Тип компонента', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ReinforcementBarType', 1095347863557, 0, 'Betonstahltyp', 'ReinforcementBarType', 'Type d\'Acier à Béton', 'Τύπος ενίσχυσης', '', '', 'Тип арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RenewableEnergyConsumption', 6713297534980, 0, 'Erneuerbarer Energieverbrauch', 'Renewable Energy Consumption', 'ConsommationEnergieRenouvelable', 'Κατανάλωση ανανεώσιμων πηγών ενέργειας', '', '', 'Потребление возобновляемой энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RenewableEnergyConsumptionPerUnit', 6713297534980, 0, 'Erneuerbarer Energieverbrauch pro Einheit', 'Renewable Energy Consumption Per Unit', 'ConsommationEnergieRenouvelableParUnite', 'Κατανάλωση ανανεώσιμης ενέργειας ανά μονάδα', '', '', 'Потребление возобновляемой энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RequiredHeadroom', 6713296355332, 0, 'erforderliche Durchgangshöhe', 'Required Headroom', 'HauteurPassageRequise', 'Απαιτούμενο ύψος διέλευσης', '', '', 'Требуемый запас по высоте', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RequiredSlope', 6713296486404, 0, 'erforderliche Neigung', 'Required Slope', 'InclinaisonRequise', 'Απαιτούμενη κλίση', '', '', 'Требуемый уклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ResourceDepletion', 6713298911236, 0, 'Rohstoffserschöpfung', 'Resource Depletion', 'EpuisementRessources', 'Εξάντληση πόρων', '', '', 'Истощение ресурсов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ResourceDepletionPerUnit', 6713298911236, 0, 'Rohstoffserschöpfung pro Einheit', 'Resource Depletion Per Unit', 'EpuisementRessourcesParUnite', 'Εξάντληση πόρων ανά μονάδα', '', '', 'Истощение ресурсов на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'RiserHeight', 6713296355332, 0, 'Steigung', 'Riser Height', 'HauteurContreMarche', 'Υψηλότερο ύψος', '', '', 'Высота подъема', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Roll', 6713296486404, 0, 'Kippwinkel', 'Roll', 'Rotation Autour Axe Longitudinal', 'Περιστροφή γύρω από τον διαμήκη άξονα', '', '', 'Рулон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Roughness', 1095347863557, 0, 'Rauheit der Oberfläche', 'Roughness', 'Rugosité', 'Τραχύτητα', '', '', 'Шероховатость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SecurityRating', 1095347863557, 0, 'Sicherheitsklasse', 'Security Rating', 'NiveauSecurite', 'Βαθμός ασφάλειας', '', '', 'Безопастность', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SelfClosing', 4360503298, 0, 'Selbstschliessend', 'Self Closing', 'FermetureAutomatique', 'Αυτόματο κλείσιμο', '', '', 'Самозакрывающийся', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SerialNumber', 1095347929093, 0, 'Seriennummer', 'Serial Number', 'Numéro de série', 'Σειριακός αριθμός', '', '', 'Серийный номер', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ServiceLifeDuration', 1095348453381, 0, 'Lebensdauer', 'Service Life Duration', 'Durée du service', 'Διάρκεια ζωής υπηρεσίας', '', '', 'Срока службы', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShadingDeviceType', 1095347863557, 0, 'Sonnenschutztyp', 'ShadingDeviceType', 'Type de protection solaire', 'Τύπος ηλιοπροστασίας', '', '', 'Тип затеняющего устройства', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Shape', 1095347863557, 0, 'Form', 'Shape', 'Forme', 'Σχήμα', '', '', 'Форма', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortInsideCenterLowerBarPitch', 6713296355332, 0, 'Innenlänge des kurzen mittleren unteren Armierungseisen', 'Short Inside Center Lower Bar Pitch', 'Longueur intérieure de la barre inférieure centrale courte', 'Short Inside Center Lower Bar Pitch', '', '', 'Внутренняя длина короткого среднего нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortInsideCenterTopBarPitch', 6713296355332, 0, 'Innenlänge des kurzen mittleren oberen Armierungseisen', 'Short Inside Center Top Bar Pitch', 'Longueur intérieure de la barre supérieure centrale courte', 'Short Inside Center Top Bar Pitch', '', '', 'Внутренняя длина короткого среднего верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortInsideEndLowerBarPitch', 6713296355332, 0, 'Innenlänge des kurzen letzten unteren Armierungseisen', 'Short Inside End Lower Bar Pitch', 'Longueur intérieure de la dernière barre inférieure courte', 'Short Inside End Lower Bar Pitch', '', '', 'Внутренняя длина короткого последнего нижнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortInsideEndTopBarPitch', 6713296355332, 0, 'Innenlänge des kurzen letzten oberen Armierungseisen', 'Short Inside End Top Bar Pitch', 'Longueur intérieure de la dernière barre supérieure courte', 'Short Inside End Top Bar Pitch', '', '', 'Внутренняя длина короткого последнего верхнего стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortOutsideLowerBarPitch', 6713296355332, 0, 'Außenlänge des kurzen unteren Armierungseisen', 'Short Outside Lower Bar Pitch', 'Longueur extérieure de la barre inférieure courte', 'Short Outside Lower Bar Pitch', '', '', 'Внешняя длина короткого нижнего арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ShortOutsideTopBarPitch', 6713296355332, 0, 'Außenlänge des kurzen oberen Armierungseisen', 'Short Outside Top Bar Pitch', 'Longueur extérieure de la barre supérieure courte', 'Short Outside Top Bar Pitch', '', '', 'Внешняя длина короткого верхнего арматурного стержня', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Slope', 6713296486404, 0, 'Neigungswinkel', 'Slope', 'Inclinaison', 'Κλίση', '', '', 'Наклон', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SmokeStop', 4360503298, 0, 'Rauchschutz', 'Smoke Stop', 'CoupeFumee', 'Διακοπή καπνού', '', '', 'Защита от дыма', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SolarReflectance', 29803044274180, 0, 'Strahlungsreflectionsgrad', 'Solar Reflectance', 'Reflexion du rayonnement solaire', 'Ηλιακή Αντανάκλαση', '', '', 'Солнечное отражение', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SolarTransmittance', 29803044274180, 0, 'Strahlungstransmissionsgrad', 'Solar Transmittance', 'Transmission du rayonnement solaire', 'Ηλιακή μετάδοση', '', '', 'Солнечная пропускаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SpacingBarPitch', 6713296355332, 0, 'Länge des Armierungseisen', 'Spacing Bar Pitch', 'Expacement des barres', 'Μήκος της ράβδου', '', '', 'Шаг распорки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Span', 6713296355332, 0, 'Spannweite', 'Span', 'Portée Libre', 'Άνοιγμα', '', '', 'Ширина пролета', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'StirrupBarPitch', 6713296355332, 0, 'Länge des Armierungseisen-Bügel ', 'Stirrup Bar Pitch', 'Longueur de l\'étrier', 'Κλίση συνδετήρων ', '', '', 'Шаг хомутов', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'StratosphericOzoneLayerDestruction', 6713298911236, 0, 'Zerstörung der stratosphärischen Ozonschicht', 'Stratospheric Ozone Layer Destruction', 'DestructionCoucheOzoneStartospherique', 'Καταστροφή στρωματοσφαιρικού στρώματος όζοντος', '', '', 'Разрушение стратосферного озонового слоя', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'StratosphericOzoneLayerDestructionPerUnit', 6713298911236, 0, 'Zerstörung der stratosphärischen Ozonschicht pro Einheit', 'Stratospheric Ozone Layer Destruction Per Unit', 'DestructionCoucheOzoneStartospheriqueParUnite', 'Καταστροφή στρωματοσφαιρικού στρώματος όζοντος ανά μονάδα', '', '', 'Разрушение стратосферного озонового слоя на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SurfaceColor', 1095347863557, 0, 'Oberflächenfarbe', 'Surface Color', 'Couleur surface', 'Χρώμα επιφάνειας', '', '', 'Цвет поверхности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'SurfaceSpreadOfFlame', 1095347863557, 0, 'Brandverhalten', 'Surface Spread Of Flame', 'SurfacePropagationFlamme', 'Επιφάνεια διάδοσης φλόγας', '', '', 'Распространение пламени по поверхности', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'System', 1095347863557, 0, 'Anlage', 'System', 'Système', 'Σύστημα', '', '', 'Система', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ThermalTransmittance', 6713301401604, 0, 'U-Wert', 'Thermal Transmittance', 'Transmission thermique surfacique', 'Θερμική μετάδοση', '', '', 'Тепловая проницаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'ToppingType', 1095347863557, 0, 'Plattentyp', 'Topping Type', 'Type de garniture', 'Τύπος κορυφής', '', '', 'Тип плиты', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TotalPrimaryEnergyConsumption', 6713297534980, 0, 'Gesamter Primärenergieverbrauch', 'Total Primary Energy Consumption', 'ConsommationTotaleEnergiePrimaire', 'Συνολική κατανάλωση πρωτογενούς ενέργειας', '', '', 'Общее потребление первичной энергии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TotalPrimaryEnergyConsumptionPerUnit', 6713297534980, 0, 'Gesamter Primärenergieverbrauch pro Einheit', 'Total Primary Energy Consumption Per Unit', 'ConsommationTotaleEnergiePrimaireParUnite', 'Συνολική κατανάλωση πρωτογενούς ενέργειας ανά μονάδα', '', '', 'Общее потребление первичной энергии на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TreadLength', 6713296355332, 0, 'Auftritt', 'Tread Length', 'Longueur du Giron', 'Μήκος πέλματος', '', '', 'Длина ступени', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TreadLengthAtInnerSide', 6713296355332, 0, 'minimaler Auftritt an der Innenseite', 'Tread Length At Inner Side', 'Longueur intérieure du Giron', 'Μήκος πέλματος στην εσωτερική πλευρά', '', '', 'Длина ступени с внутренней стороны', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TreadLengthAtOffset', 6713296355332, 0, 'Auftritt an der Lauflinie', 'Tread Length At Offset', 'Longueur extérieure du Giron', 'Μήκος πέλματος σε μετατόπιση', '', '', 'Длина ступени со смещением', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'TypeDesignator', 1095347863557, 0, 'Typ Bezeichner', 'Type Designator', 'Indicateur de Type', 'Τύπος προσδιοριστής', '', '', 'Обозначение типа', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Unit', 1095347732485, 0, 'Einheit', 'Unit', 'Unité', 'Μονάδα', '', '', 'Единица измерения (ед. изм.)', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'VerticalBarPitch', 6713296355332, 0, 'Länge des vertikalen Armierungseisen ', 'Vertical Bar Pitch', 'Espacement Vertical de la Barre', 'Μήκος κατακόρυφης ράβδου', '', '', 'Шаг вертикальной арматуры', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'VisibleLightReflectance', 29803044274180, 0, 'Reflektionsgrad für sichtbares Licht', 'Visible Light Reflectance', 'Reflexion du rayonnement visible', 'Βαθμός ανάκλασης για ορατό φως', '', '', 'Отражение видимого света', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'VisibleLightTransmittance', 29803044274180, 0, 'Transmissionsgrad für sichtbares Licht', 'Visible Light Transmittance', 'Transmittance du rayonnement visible', 'Ορατή μετάδοση ακτινοβολίας', '', '', 'Пропускание видимого света', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WaistThickness', 6713296355332, 0, 'minimale Dicke des Treppenplatte', 'Waist Thickness', 'Epaisseur minimale', 'Πάχος μέσης', '', '', 'Минимальная толщина лестничной плиты', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WalkingLineOffset', 6713296355332, 0, 'Abstand der Lauflinie', 'Walking Line Offset', 'Ligne de foulée', 'Μετατόπιση γραμμής κίνησης', '', '', 'Смещение бегущей строки', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WarrantyContent', 1095347732485, 0, 'Garantieinhalt', 'Warranty Content', 'Limites de garantie', 'Περιεχόμενο εγγύησης', '', '', 'Гарантия Содержание', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WarrantyEndDate', 1095348322309, 0, 'Garantie-Enddatum', 'Warranty End Date', 'Fin de garantie', 'Ημερομηνία λήξης εγγύησης', '', '', 'Дата окончания гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WarrantyIdentifier', 1095347929093, 0, 'Garantiekennung', 'Warranty Identifier', 'Identifiant de garantie', 'Αναγνωριστικό εγγύησης', '', '', 'Идентификатор гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WarrantyPeriod', 1095348453381, 0, 'Garantiezeit', 'Warranty Period', 'Période de garantie', 'Περίοδος εγγύησης', '', '', 'Гарантийный срок', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WarrantyStartDate', 1095348322309, 0, 'Garantie-Startdatum', 'Warranty Start Date', 'Début de garantie', 'Ημερομηνία έναρξης εγγύησης', '', '', 'Дата начала гарантии', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WaterConsumption', 6713296420868, 0, 'Wasserverbrauch', 'Water Consumption', 'ConsommationEau', 'Κατανάλωση νερού', '', '', 'Расход воды', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WaterConsumptionPerUnit', 6713296420868, 0, 'Wasserverbrauch pro Einheit', 'Water Consumption Per Unit', 'ConsommationEauParUnite', 'Κατανάλωση νερού ανά μονάδα', '', '', 'Расход воды на единицу', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WaterTightnessRating', 1095347863557, 0, 'Wasserdichtheitsklasse', 'Water Tightness Rating', 'Indice d\'étanchéité', 'Βαθμολογία στεγανότητας νερού', '', '', 'Водонепроницаемость', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'Width', 6713296355332, 0, 'Breite', 'Width', 'Largeur', 'Πλάτος', '', '', 'Ширина', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'WindLoadRating', 1095347863557, 0, 'Windlastklasse', 'Wind Load Rating', 'Indice de résistance au vent', 'Βαθμός φορτίου ανέμου', '', '', 'Ветровая нагрузка', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'XDirectionLowerBarCount', 86095953922, 0, 'Anzahl unterer Träger in X Richtung', 'X-Direction Lower Bar Count', 'Nombre de barres inférieures dans la direction X', 'Αριθμός κάτω ράβδων στην διεύθυνση X', '', '', 'Количество нижних стержней в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'XDirectionTieHoopBarPitch', 6713296355332, 0, 'Länge der Bindugsreifen Armierungseisen in X-Richtung ', 'X-Direction Tie Hoop Bar Pitch', 'Longueur des arceaux  dans le sens X ', 'X-Direction Tie Hoop Bar Pitch', '', '', 'Длина соединительных шин стержней направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'XDirectionTieHoopCount', 86095953922, 0, 'Anzahl Bindungsreifen in X-Richtung', 'X-Direction Tie Hoop Count', 'Nombre d\'arceaux  dans le sens X', 'Πλήθος X-Direction Tie Hoop', '', '', 'Количество связующих шин в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'XDirectionUpperBarCount', 86095953922, 0, 'Anzahl oberer Träger in X Richtung', 'X-Direction Upper Bar Count', 'Nombre de barres supérieures dans la direction X', 'Αριθμός άνω ράβδων στην διεύθυνση X', '', '', 'Количество верхних стержней в направлении X', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'YDirectionLowerBarCount', 86095953922, 0, 'Anzahl unterer Träger in Y Richtung', 'Y-Direction Lower Bar Count', 'Nombre de barres inférieures dans la direction Y', 'Αριθμός κάτω ράβδων στην διεύθυνση Υ', '', '', 'Количество нижних стержней в направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'YDirectionTieHoopBarPitch', 6713296355332, 0, 'Länge der Bindungsreifen Armierungseisen in Y-Richtung', 'Y-Direction Tie Hoop Bar Pitch', 'Longueur des arceaux  dans le sens Y ', 'Y-Direction Tie Hoop Bar Pitch', '', '', 'Длина соединительных шин стержней направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'YDirectionTieHoopCount', 86095953922, 0, 'Anzahl Bindungsreifen in Y-Richtung ', 'Y-Direction Tie Hoop Count', 'Nombre d\'arceaux  dans le sens Y ', 'Y-Direction Tie Hoop Count', '', '', 'Количество связующих шин в направлении Y', '');
INSERT INTO `ecad_property_def` (`property_group`, `property_name`, `property_format`, `property_editable`, `property_text_de`, `property_text_en`, `property_text_fr`, `property_text_gr`, `property_text_es`, `property_text_pl`, `property_text_ru`, `property_text_tr`) VALUES
	(2, 'YDirectionUpperBarCount', 86095953922, 0, 'Anzahl oberer Träger in Y Richtung', 'Y-Direction Upper Bar Count', 'Nombre de barres supérieures dans la direction Y', 'Αριθμός άνω ράβδων στην διεύθυνση Υ', '', '', 'Количество верхних стержней в направлении Y', '');
/*!40000 ALTER TABLE `ecad_property_def` ENABLE KEYS */;

DROP TABLE IF EXISTS `ecad_property_info`;
CREATE TABLE IF NOT EXISTS `ecad_property_info` (
  `db_name` varchar(128) NOT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `version` int DEFAULT NULL,
  `migrated` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`db_name`,`region`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*!40000 ALTER TABLE `ecad_property_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecad_property_info` ENABLE KEYS */;

DROP TABLE IF EXISTS `ecad_property_mapping`;
CREATE TABLE IF NOT EXISTS `ecad_property_mapping` (
  `free_property_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ifc_pset` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `ifc_property_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `active` int NOT NULL DEFAULT '0',
  `editable` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`free_property_name`,`ifc_pset`,`ifc_property_name`,`active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*!40000 ALTER TABLE `ecad_property_mapping` DISABLE KEYS */;
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_CoveringCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_CurtainWallCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_DoorCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_PlateCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_RoofCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_SlabCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_WallCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcousticRating', 'Pset_WindowCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AcquisitionDate', 'Pset_ManufacturerOccurrence', 'AcquisitionDate', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AngleBetweenComponentAxes', 'Pset_PrecastSlab', 'AngleBetweenComponentAxes', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AngleToFirstAxis', 'Pset_PrecastSlab', 'AngleToFirstAxis', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ArticleNumber', 'Pset_ManufacturerTypeInformation', 'ArticleNumber', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AssemblyPlace', 'Pset_ManufacturerOccurrence', 'AssemblyPlace', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AssemblyPlace', 'Pset_ManufacturerTypeInformation', 'AssemblyPlace', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AssessmentCondition', 'Pset_Condition', 'AssessmentCondition', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AssessmentDate', 'Pset_Condition', 'AssessmentDate', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AssessmentDescription', 'Pset_Condition', 'AssessmentDescription', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AtmosphericAcidification', 'Pset_EnvironmentalImpactValues', 'AtmosphericAcidification', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::AtmosphericAcidificationPerUnit', 'Pset_EnvironmentalImpactIndicators', 'AtmosphericAcidificationPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::BarAllocationType', 'Pset_ReinforcementBarPitchOfWall', 'BarAllocationType', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::BarCode', 'Pset_ManufacturerOccurrence', 'BarCode', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::BatchReference', 'Pset_ManufacturerOccurrence', 'BatchReference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ClearWidth', 'Pset_RampFlightCommon', 'ClearWidth', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ClimateChange', 'Pset_EnvironmentalImpactValues', 'ClimateChange', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ClimateChangePerUnit', 'Pset_EnvironmentalImpactIndicators', 'ClimateChangePerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Combustible', 'Pset_CoveringCommon', 'Combustible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Combustible', 'Pset_CurtainWallCommon', 'Combustible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Combustible', 'Pset_SlabCommon', 'Combustible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Combustible', 'Pset_WallCommon', 'Combustible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Compartmentation', 'Pset_SlabCommon', 'Compartmentation', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Compartmentation', 'Pset_WallCommon', 'Compartmentation', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::CounterSlope', 'Pset_RampFlightCommon', 'CounterSlope', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::CrossingLowerBarPitch', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'CrossingLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::CrossingUpperBarPitch', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'CrossingUpperBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Depth', 'Pset_BuildingElementProxyProvisionForVoid', 'Depth', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarCountOfIndependentFooting', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarPitchOfBeam', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarPitchOfColumn', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarPitchOfSlab', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Description', 'Pset_ReinforcementBarPitchOfWall', 'Description', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Diameter', 'Pset_BuildingElementProxyProvisionForVoid', 'Diameter', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Diameter', 'Pset_RailingCommon', 'Diameter', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::DistanceBetweenComponentAxes', 'Pset_PrecastSlab', 'DistanceBetweenComponentAxes', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::DurabilityRating', 'Pset_DoorCommon', 'DurabilityRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Duration', 'Pset_EnvironmentalImpactValues', 'Duration', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::EdgeDistanceToFirstAxis', 'Pset_PrecastSlab', 'EdgeDistanceToFirstAxis', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Eutrophication', 'Pset_EnvironmentalImpactValues', 'Eutrophication', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::EutrophicationPerUnit', 'Pset_EnvironmentalImpactIndicators', 'EutrophicationPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Exclusions', 'Pset_Warranty', 'Exclusions', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ExpectedServiceLife', 'Pset_EnvironmentalImpactIndicators', 'ExpectedServiceLife', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ExtendToStructure', 'Pset_WallCommon', 'ExtendToStructure', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireExit', 'Pset_DoorCommon', 'FireExit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireExit', 'Pset_RampCommon', 'FireExit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireExit', 'Pset_StairCommon', 'FireExit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireExit', 'Pset_WindowCommon', 'FireExit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_BeamCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_BuildingElementProxyCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_ChimneyCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_ColumnCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_CoveringCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_CurtainWallCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_DoorCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_FootingCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_MemberCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_PlateCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_RampCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_RoofCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_SlabCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_StairCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_WallCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FireRating', 'Pset_WindowCommon', 'FireRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FlammabilityRating', 'Pset_CoveringCommon', 'FlammabilityRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FragilityRating', 'Pset_CoveringCommon', 'FragilityRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::FunctionalUnitReference', 'Pset_EnvironmentalImpactIndicators', 'FunctionalUnitReference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::GlazingAreaFraction', 'Pset_DoorCommon', 'GlazingAreaFraction', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::GlazingAreaFraction', 'Pset_WindowCommon', 'GlazingAreaFraction', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::GlobalTradeItemNumber', 'Pset_ManufacturerTypeInformation', 'GlobalTradeItemNumber', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HandicapAccessible', 'Pset_DoorCommon', 'HandicapAccessible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HandicapAccessible', 'Pset_RampCommon', 'HandicapAccessible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HandicapAccessible', 'Pset_StairCommon', 'HandicapAccessible', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasDrive', 'Pset_DoorCommon', 'HasDrive', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasDrive', 'Pset_WindowCommon', 'HasDrive', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasNonSkidSurface', 'Pset_RampCommon', 'HasNonSkidSurface', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasNonSkidSurface', 'Pset_StairCommon', 'HasNonSkidSurface', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasSillExternal', 'Pset_WindowCommon', 'HasSillExternal', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HasSillInternal', 'Pset_WindowCommon', 'HasSillInternal', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HazardousWaste', 'Pset_EnvironmentalImpactValues', 'HazardousWaste', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HazardousWastePerUnit', 'Pset_EnvironmentalImpactIndicators', 'HazardousWastePerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Headroom', 'Pset_RampFlightCommon', 'Headroom', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Headroom', 'Pset_StairFlightCommon', 'Headroom', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Height', 'Pset_BuildingElementProxyProvisionForVoid', 'Height', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Height', 'Pset_RailingCommon', 'Height', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HoopBarPitch', 'Pset_ReinforcementBarPitchOfColumn', 'HoopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HorizontalBarPitch', 'Pset_ReinforcementBarPitchOfWall', 'HorizontalBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::HygrothermalRating', 'Pset_DoorCommon', 'HygrothermalRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::InertWaste', 'Pset_EnvironmentalImpactValues', 'InertWaste', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::InertWastePerUnit', 'Pset_EnvironmentalImpactIndicators', 'InertWastePerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Infiltration', 'Pset_DoorCommon', 'Infiltration', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Infiltration', 'Pset_WindowCommon', 'Infiltration', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::IsExtendedWarranty', 'Pset_Warranty', 'IsExtendedWarranty', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::IsExternal', 'Pset_BuildingElementProxyCommon', 'IsExternal', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LeadInTime', 'Pset_EnvironmentalImpactValues', 'LeadInTime', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LeadOutTime', 'Pset_EnvironmentalImpactValues', 'LeadOutTime', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LifeCyclePhase', 'Pset_EnvironmentalImpactIndicators', 'LifeCyclePhase', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LoadBearing', 'Pset_BuildingElementProxyCommon', 'LoadBearing', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongInsideCenterLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongInsideCenterLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongInsideCenterTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongInsideCenterTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongInsideEndLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongInsideEndLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongInsideEndTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongInsideEndTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongOutsideLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongOutsideLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::LongOutsideTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'LongOutsideTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Manufacturer', 'Pset_ManufacturerTypeInformation', 'Manufacturer', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::MeanTimeBetweenFailure', 'Pset_ServiceLife', 'MeanTimeBetweenFailure', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::MechanicalLoadRating', 'Pset_DoorCommon', 'MechanicalLoadRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::MechanicalLoadRating', 'Pset_WindowCommon', 'MechanicalLoadRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::MechanicalOperated', 'Pset_ShadingDeviceCommon', 'MechanicalOperated', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ModelLabel', 'Pset_ManufacturerTypeInformation', 'ModelLabel', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ModelReference', 'Pset_ManufacturerTypeInformation', 'ModelReference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NominalThickness', 'Pset_PrecastSlab', 'NominalThickness', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NominalToppingThickness', 'Pset_PrecastSlab', 'NominalToppingThickness', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NonHazardousWaste', 'Pset_EnvironmentalImpactValues', 'NonHazardousWaste', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NonHazardousWastePerUnit', 'Pset_EnvironmentalImpactIndicators', 'NonHazardousWastePerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NonRenewableEnergyConsumption', 'Pset_EnvironmentalImpactValues', 'NonRenewableEnergyConsumption', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NonRenewableEnergyConsumptionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'NonRenewableEnergyConsumptionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NosingLength', 'Pset_StairCommon', 'NosingLength', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NosingLength', 'Pset_StairFlightCommon', 'NosingLength', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NumberOfDrafts', 'Pset_ChimneyCommon', 'NumberOfDrafts', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NumberOfRiser', 'Pset_StairCommon', 'NumberOfRiser', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NumberOfRiser', 'Pset_StairFlightCommon', 'NumberOfRiser', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NumberOfTreads', 'Pset_StairCommon', 'NumberOfTreads', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::NumberOfTreads', 'Pset_StairFlightCommon', 'NumberOfTreads', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::PhotochemicalOzoneFormation', 'Pset_EnvironmentalImpactValues', 'PhotochemicalOzoneFormation', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::PhotochemicalOzoneFormationPerUnit', 'Pset_EnvironmentalImpactIndicators', 'PhotochemicalOzoneFormationPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::PitchAngle', 'Pset_SlabCommon', 'PitchAngle', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::PointOfContact', 'Pset_Warranty', 'PointOfContact', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ProductionYear', 'Pset_ManufacturerTypeInformation', 'ProductionYear', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RadioactiveWaste', 'Pset_EnvironmentalImpactValues', 'RadioactiveWaste', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RadioactiveWastePerUnit', 'Pset_EnvironmentalImpactIndicators', 'RadioactiveWastePerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_BeamCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_BuildingElementProxyCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ChimneyCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ColumnCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_CoveringCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_CurtainWallCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_DoorCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_EnvironmentalImpactIndicators', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_FootingCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_MemberCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_PileCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_PlateCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_RailingCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_RampCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_RampFlightCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarCountOfIndependentFooting', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarPitchOfBeam', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarPitchOfColumn', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarPitchOfSlab', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ReinforcementBarPitchOfWall', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_RoofCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_ShadingDeviceCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_SlabCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_StairCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_StairFlightCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_WallCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Reference', 'Pset_WindowCommon', 'Reference', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ReinforcementBarType', 'Pset_ReinforcementBarPitchOfColumn', 'ReinforcementBarType', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RenewableEnergyConsumption', 'Pset_EnvironmentalImpactValues', 'RenewableEnergyConsumption', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RenewableEnergyConsumptionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'RenewableEnergyConsumptionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RequiredHeadroom', 'Pset_RampCommon', 'RequiredHeadroom', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RequiredHeadroom', 'Pset_StairCommon', 'RequiredHeadroom', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RequiredSlope', 'Pset_RampCommon', 'RequiredSlope', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ResourceDepletion', 'Pset_EnvironmentalImpactValues', 'ResourceDepletion', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ResourceDepletionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'ResourceDepletionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RiserHeight', 'Pset_StairCommon', 'RiserHeight', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::RiserHeight', 'Pset_StairFlightCommon', 'RiserHeight', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Roughness', 'Pset_ShadingDeviceCommon', 'Roughness', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SecurityRating', 'Pset_DoorCommon', 'SecurityRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SecurityRating', 'Pset_WindowCommon', 'SecurityRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SelfClosing', 'Pset_DoorCommon', 'SelfClosing', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SerialNumber', 'Pset_ManufacturerOccurrence', 'SerialNumber', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ServiceLifeDuration', 'Pset_ServiceLife', 'ServiceLifeDuration', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShadingDeviceType', 'Pset_ShadingDeviceCommon', 'ShadingDeviceType', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Shape', 'Pset_BuildingElementProxyProvisionForVoid', 'Shape', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortInsideCenterLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortInsideCenterLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortInsideCenterTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortInsideCenterTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortInsideEndLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortInsideEndLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortInsideEndTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortInsideEndTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortOutsideLowerBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortOutsideLowerBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ShortOutsideTopBarPitch', 'Pset_ReinforcementBarPitchOfSlab', 'ShortOutsideTopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SmokeStop', 'Pset_DoorCommon', 'SmokeStop', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SmokeStop', 'Pset_WindowCommon', 'SmokeStop', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SolarReflectance', 'Pset_ShadingDeviceCommon', 'SolarReflectance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SolarTransmittance', 'Pset_ShadingDeviceCommon', 'SolarTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SpacingBarPitch', 'Pset_ReinforcementBarPitchOfBeam', 'SpacingBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SpacingBarPitch', 'Pset_ReinforcementBarPitchOfWall', 'SpacingBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SpecialAcousticRating', 'Pset_WallCommon', 'AcousticRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::StirrupBarPitch', 'Pset_ReinforcementBarPitchOfBeam', 'StirrupBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::StratosphericOzoneLayerDestruction', 'Pset_EnvironmentalImpactValues', 'StratosphericOzoneLayerDestruction', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::StratosphericOzoneLayerDestructionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'StratosphericOzoneLayerDestructionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SurfaceColor', 'Pset_ShadingDeviceCommon', 'SurfaceColor', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SurfaceSpreadOfFlame', 'Pset_CoveringCommon', 'SurfaceSpreadOfFlame', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SurfaceSpreadOfFlame', 'Pset_CurtainWallCommon', 'SurfaceSpreadOfFlame', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SurfaceSpreadOfFlame', 'Pset_SlabCommon', 'SurfaceSpreadOfFlame', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::SurfaceSpreadOfFlame', 'Pset_WallCommon', 'SurfaceSpreadOfFlame', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::System', 'Pset_BuildingElementProxyProvisionForVoid', 'System', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_BeamCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_BuildingElementProxyCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_ChimneyCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_ColumnCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_CoveringCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_CurtainWallCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_DoorCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_MemberCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_PlateCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_RampCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_RoofCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_ShadingDeviceCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_SlabCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_StairCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_WallCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ThermalTransmittance', 'Pset_WindowCommon', 'ThermalTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::ToppingType', 'Pset_PrecastSlab', 'ToppingType', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TotalPrimaryEnergyConsumption', 'Pset_EnvironmentalImpactValues', 'TotalPrimaryEnergyConsumption', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TotalPrimaryEnergyConsumptionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'TotalPrimaryEnergyConsumptionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLength', 'Pset_StairCommon', 'TreadLength', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLength', 'Pset_StairFlightCommon', 'TreadLength', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLengthAtInnerSide', 'Pset_StairCommon', 'TreadLengthAtInnerSide', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLengthAtInnerSide', 'Pset_StairFlightCommon', 'TreadLengthAtInnerSide', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLengthAtOffset', 'Pset_StairCommon', 'TreadLengthAtOffset', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TreadLengthAtOffset', 'Pset_StairFlightCommon', 'TreadLengthAtOffset', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::TypeDesignator', 'Pset_PrecastSlab', 'TypeDesignator', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::VerticalBarPitch', 'Pset_ReinforcementBarPitchOfWall', 'VerticalBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::VisibleLightReflectance', 'Pset_ShadingDeviceCommon', 'VisibleLightReflectance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::VisibleLightTransmittance', 'Pset_ShadingDeviceCommon', 'VisibleLightTransmittance', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaistThickness', 'Pset_StairCommon', 'WaistThickness', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaistThickness', 'Pset_StairFlightCommon', 'WaistThickness', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WalkingLineOffset', 'Pset_StairCommon', 'WalkingLineOffset', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WalkingLineOffset', 'Pset_StairFlightCommon', 'WalkingLineOffset', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WarrantyContent', 'Pset_Warranty', 'WarrantyContent', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WarrantyEndDate', 'Pset_Warranty', 'WarrantyEndDate', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WarrantyIdentifier', 'Pset_Warranty', 'WarrantyIdentifier', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WarrantyPeriod', 'Pset_Warranty', 'WarrantyPeriod', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WarrantyStartDate', 'Pset_Warranty', 'WarrantyStartDate', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaterConsumption', 'Pset_EnvironmentalImpactValues', 'WaterConsumption', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaterConsumptionPerUnit', 'Pset_EnvironmentalImpactIndicators', 'WaterConsumptionPerUnit', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaterTightnessRating', 'Pset_DoorCommon', 'WaterTightnessRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WaterTightnessRating', 'Pset_WindowCommon', 'WaterTightnessRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::Width', 'Pset_BuildingElementProxyProvisionForVoid', 'Width', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WindLoadRating', 'Pset_DoorCommon', 'WindLoadRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::WindLoadRating', 'Pset_WindowCommon', 'WindLoadRating', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::XDirectionLowerBarCount', 'Pset_ReinforcementBarCountOfIndependentFooting', 'XDirectionLowerBarCount', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::XDirectionTieHoopBarPitch', 'Pset_ReinforcementBarPitchOfColumn', 'XDirectionTieHoopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::XDirectionTieHoopCount', 'Pset_ReinforcementBarPitchOfColumn', 'XDirectionTieHoopCount', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::XDirectionUpperBarCount', 'Pset_ReinforcementBarCountOfIndependentFooting', 'XDirectionUpperBarCount', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::YDirectionLowerBarCount', 'Pset_ReinforcementBarCountOfIndependentFooting', 'YDirectionLowerBarCount', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::YDirectionTieHoopBarPitch', 'Pset_ReinforcementBarPitchOfColumn', 'YDirectionTieHoopBarPitch', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::YDirectionTieHoopCount', 'Pset_ReinforcementBarPitchOfColumn', 'YDirectionTieHoopCount', 1, 0);
INSERT INTO `ecad_property_mapping` (`free_property_name`, `ifc_pset`, `ifc_property_name`, `active`, `editable`) VALUES
	('free::YDirectionUpperBarCount', 'Pset_ReinforcementBarCountOfIndependentFooting', 'YDirectionUpperBarCount', 1, 0);
/*!40000 ALTER TABLE `ecad_property_mapping` ENABLE KEYS */;

DROP TABLE IF EXISTS `ecad_property_records`;
CREATE TABLE IF NOT EXISTS `ecad_property_records` (
  `property_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `property_value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `property_record` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `property_region` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`property_name`,`property_record`,`property_region`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

/*!40000 ALTER TABLE `ecad_property_records` DISABLE KEYS */;
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ChimneyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_Condition', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ELITECAD_Custom', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_FootingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_PileCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_PlateCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_RailingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarPitchOfBeam', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_RoofCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ServiceLife', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_PlateCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_RoofCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcousticRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AcquisitionDate', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AngleBetweenComponentAxes', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AngleToFirstAxis', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ArticleNumber', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AssemblyPlace', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AssemblyPlace', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AssessmentCondition', '0', 'Pset_Condition', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AssessmentDate', '0', 'Pset_Condition', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AssessmentDescription', '0', 'Pset_Condition', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AtmosphericAcidification', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::AtmosphericAcidificationPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::BarAllocationType', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::BarCode', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::BatchReference', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ClearWidth', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ClimateChange', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ClimateChangePerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Combustible', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Combustible', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Combustible', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Combustible', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Compartmentation', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Compartmentation', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::CompressiveStrength', '0', 'Pset_ELITECAD_Custom', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::CounterSlope', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::CrossingLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::CrossingUpperBarPitch', '0', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Depth', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarPitchOfBeam', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Description', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Diameter', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Diameter', '0', 'Pset_RailingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::DistanceBetweenComponentAxes', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::DurabilityRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Duration', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::EdgeDistanceToFirstAxis', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Eutrophication', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::EutrophicationPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Exclusions', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ExpectedServiceLife', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ExtendToStructure', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Finish', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireExit', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireExit', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireExit', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireExit', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_ChimneyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_PlateCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_RoofCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FireRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FlammabilityRating', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FragilityRating', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::FunctionalUnitReference', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::GlazingAreaFraction', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::GlazingAreaFraction', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::GlobalTradeItemNumber', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HandicapAccessible', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HandicapAccessible', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HandicapAccessible', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasDrive', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasDrive', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasNonSkidSurface', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasNonSkidSurface', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasSillExternal', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HasSillInternal', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HazardousWaste', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HazardousWastePerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Headroom', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Headroom', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Height', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Height', '0', 'Pset_RailingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HoopBarPitch', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HorizontalBarPitch', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::HygrothermalRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::InertWaste', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::InertWastePerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Infiltration', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Infiltration', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::IsExtendedWarranty', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::IsExternal', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LeadInTime', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LeadOutTime', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LifeCyclePhase', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LoadBearing', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongInsideCenterLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongInsideCenterTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongInsideEndLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongInsideEndTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongOutsideLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::LongOutsideTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Manufacturer', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::MeanTimeBetweenFailure', '0', 'Pset_ServiceLife', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::MechanicalLoadRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::MechanicalLoadRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::MechanicalOperated', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ModelLabel', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ModelReference', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NominalThickness', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NominalToppingThickness', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NonHazardousWaste', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NonHazardousWastePerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NonRenewableEnergyConsumption', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NonRenewableEnergyConsumptionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NosingLength', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NosingLength', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Number', '0', 'Pset_ELITECAD_Custom', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NumberOfDrafts', '0', 'Pset_ChimneyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NumberOfRiser', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NumberOfRiser', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NumberOfTreads', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::NumberOfTreads', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::PhotochemicalOzoneFormation', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::PhotochemicalOzoneFormationPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::PitchAngle', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::PointOfContact', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ProductionYear', '0', 'Pset_ManufacturerTypeInformation', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RadioactiveWaste', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RadioactiveWastePerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ChimneyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_FootingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_PileCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_PlateCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_RailingCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarPitchOfBeam', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarPitchOfContinuousFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_RoofCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Reference', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ReinforcementBarType', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RenewableEnergyConsumption', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RenewableEnergyConsumptionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RequiredHeadroom', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RequiredHeadroom', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RequiredSlope', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ResourceDepletion', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ResourceDepletionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RiserHeight', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::RiserHeight', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Roll', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Roll', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Roll', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Roughness', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SecurityRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SecurityRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SelfClosing', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SerialNumber', '0', 'Pset_ManufacturerOccurrence', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ServiceLifeDuration', '0', 'Pset_ServiceLife', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShadingDeviceType', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Shape', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortInsideCenterLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortInsideCenterTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortInsideEndLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortInsideEndTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortOutsideLowerBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ShortOutsideTopBarPitch', '0', 'Pset_ReinforcementBarPitchOfSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Slope', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Slope', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Slope', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Slope', '0', 'Pset_RampFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SmokeStop', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SmokeStop', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SolarReflectance', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SolarTransmittance', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SpacingBarPitch', '0', 'Pset_ReinforcementBarPitchOfBeam', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SpacingBarPitch', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Span', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Span', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::StirrupBarPitch', '0', 'Pset_ReinforcementBarPitchOfBeam', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::StratosphericOzoneLayerDestruction', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::StratosphericOzoneLayerDestructionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SurfaceColor', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SurfaceSpreadOfFlame', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SurfaceSpreadOfFlame', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SurfaceSpreadOfFlame', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::SurfaceSpreadOfFlame', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::System', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_BeamCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_BuildingElementProxyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_ChimneyCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_ColumnCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_CoveringCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_CurtainWallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_MemberCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_PlateCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_RampCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_RoofCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_SlabCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_WallCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ThermalTransmittance', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::ToppingType', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TotalPrimaryEnergyConsumption', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TotalPrimaryEnergyConsumptionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLength', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLength', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLengthAtInnerSide', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLengthAtInnerSide', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLengthAtOffset', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TreadLengthAtOffset', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::TypeDesignator', '0', 'Pset_PrecastSlab', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Unit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::VerticalBarPitch', '0', 'Pset_ReinforcementBarPitchOfWall', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::VisibleLightReflectance', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::VisibleLightTransmittance', '0', 'Pset_ShadingDeviceCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaistThickness', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaistThickness', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WalkingLineOffset', '0', 'Pset_StairCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WalkingLineOffset', '0', 'Pset_StairFlightCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WarrantyContent', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WarrantyEndDate', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WarrantyIdentifier', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WarrantyPeriod', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WarrantyStartDate', '0', 'Pset_Warranty', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaterConsumption', '0', 'Pset_EnvironmentalImpactValues', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaterConsumptionPerUnit', '0', 'Pset_EnvironmentalImpactIndicators', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaterTightnessRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WaterTightnessRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::Width', '0', 'Pset_BuildingElementProxyProvisionForVoid', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WindLoadRating', '0', 'Pset_DoorCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::WindLoadRating', '0', 'Pset_WindowCommon', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::XDirectionLowerBarCount', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::XDirectionTieHoopBarPitch', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::XDirectionTieHoopCount', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::XDirectionUpperBarCount', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::YDirectionLowerBarCount', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::YDirectionTieHoopBarPitch', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::YDirectionTieHoopCount', '0', 'Pset_ReinforcementBarPitchOfColumn', 'global');
INSERT INTO `ecad_property_records` (`property_name`, `property_value`, `property_record`, `property_region`) VALUES
	('free::YDirectionUpperBarCount', '0', 'Pset_ReinforcementBarCountOfIndependentFooting', 'global');
/*!40000 ALTER TABLE `ecad_property_records` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
