#line 1 "S:\\v17_branches\\AR-Release\\p\\1700\\dxf\\go\\win\\Trans.sg"

WINDOW DxfTrans
{
  x=40;
  y=120;
  title = MSGGET("cad_msg.txt",6229,"DXF - TRANSFER");
  decoration="border,title,menu";
  type = dialogGroup;

  ON CREATE DO macro WITH "DxfInit.cm";

  ON SHOW EXECUTE
  {

    CALL DxfGetDxd;
    CALL DxfTransDialogInit;
  }

  GROUP g_config
  {
    col=2.3;
    row=1.5;
    frame=none;

     LABEL showfolder
     { labelString = MSGGET("cad_msg.txt",6230,"Gewhlte Konfiguration:");
       visible ="true";}

    COMBOBOX dxd_input
    {
      row = 1.6;
      colLen = 44;
			columns = 256;
    }
  }

  GROUP g_transfer
  {
    col = 2.3;
    row = 3.0;
    frame=none;

    RADIOBOX r_func
    {
      !col = 1;
      !row=1.05;
      width=320;

      ITEM { labelString = MSGGET("cad_msg.txt",6231,"DXF / DWG - IMPORT"); id = "Import";}
      ITEM { labelString = MSGGET("cad_msg.txt",6232,"DXF / DWG - EXPORT"); id = "Export";}

      ON MODIFY EXECUTE
      {
        COMMON DxfTransData
        INTEGER DxfFileAnz,DrawFileAnz;
        STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        INTEGER rc;
        STRING Quelle,line, H1, H2;

        DxfFunc=@.DxfTrans.g_transfer.r_func.;
        H1 = MSGGET( "cad_msg.txt", 2674, "Auswahl");
        H2 = MSGGET( "cad_msg.txt", 4312, "Dateien");

        IF DxfFunc=="Import" THEN

          DxfSource="";
          line= H1 + ": " + STR(DxfFileAnz) + " " + H2;
          @.DxfTrans.g_import.l_select.labelString=line;
          @.DxfTrans.g_export.visible = "false";
          @.DxfTrans.g_import.visible = "true";

        ELSE

          Quelle=@.DxfTrans.g_export.r_Quelle.;
          DxfSource=Quelle;

          !# PRINT "Quelle",Quelle;
          IF Quelle=="file" THEN
            line= H1 + STR(DrawFileAnz) + H2;
            !#PRINT "line",line;
            @.DxfTrans.g_export.l_select.labelString=line;
          ELSE
            @.DxfTrans.g_export.l_select.labelString=" ";
          END IF

          DxfFunc="Export";

          @.DxfTrans.g_import.visible = "false";
          @.DxfTrans.g_export.visible = "true";

        END IF

      }
    }
  }

  GROUP g_export
  {
    row=5.3; col=2.3;
    frame=none;

    SEPARATOR  !! alle
    {
      col = 1;
      row = 1;
      rowLen = 4.32;
      colLen = 38.9;
			labelString = MSGGET("cad_msg.txt",6235,"DXF/DWG Export");
		}

    LABEL l_select{ 
			col=3.8; 
			row=1.8; 
			labelString=" ";
			alignment=begin;
			width=280;
		}

     RADIOBOX r_Quelle
     {
       row=2.85;
       col=3;
       width=140;

      ITEM { labelString = MSGGET("cad_msg.txt",675,"Datei"); id = "file";}
      ITEM { labelString = MSGGET("cad_msg.txt",2161,"Bildschirm"); id = "screen";}

      ON MODIFY EXECUTE
      {
        COMMON DxfTransData
          INTEGER DxfFileAnz,DrawFileAnz;
          STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        INTEGER rc;
        STRING Quelle,line, H1, H2;

        rc=CFNCadMacGetVarReal("&FileListAnz",DrawFileAnz);

        Quelle=@.DxfTrans.g_export.r_Quelle.;
        DxfSource=Quelle;

        !#PRINT "Quelle:",Quelle;

        IF Quelle=="file" THEN
          H1 = MSGGET( "cad_msg.txt", 2674, "Auswahl");
          H2 = MSGGET( "cad_msg.txt", 4312, "Dateien");
					line= H1 + ": " + STR(DrawFileAnz) + " " + H2;
          @.DxfTrans.g_export.l_select.labelString=line;
          @.DxfTrans.g_export.b_list.visible = "true";
        ELSE
          @.DxfTrans.g_export.l_select.labelString="";
          @.DxfTrans.g_export.b_list.visible = "false";
        END IF
      }

    }

    LABEL l_Quelle { 
			col=3.8; 
			row=2.5; 
			labelString = MSGGET("cad_msg.txt",6236,"Datenquelle"); 
		}

    BUTTON b_list
    {
      row=3.3;
      col=16.8;
      labelString="..."
      tip= MSGGET("cad_msg.txt",6239,"Dateiauswahl");

      ON ACTIVATE EXECUTE
      {
        COMMON DxfTransData
          INTEGER DxfFileAnz,DrawFileAnz;
          STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        STRING FileListType,FileListTitle,FileAnzLabel,Quelle;
        INTEGER rc,FileListAnz;

        Quelle=@.DxfTrans.g_export.r_Quelle.;
        rc= CFNCadMacGetVarString("$FileListType",FileListType);
        IF FileListType <> "DRAW" THEN
          FileListType="DRAW";
          FileListTitle = MSGGET("cad_msg.txt", 6249, "Dateiauswahl - ELITECAD");
          rc=CFNCadMacPutVarReal("&FileListAnz",0);
          DrawFileAnz=0;
          DxfFileAnz=0;
        END IF

        FileAnzLabel="DxfTrans.g_export.l_select";
        rc=CFNCadMacPutVarString("$FileListType",FileListType);
        rc=CFNCadMacPutVarString("$FileListTitle",FileListTitle);
        rc=CFNCadMacPutVarString("$FileAnzLabel",FileAnzLabel);

        CALL DxfTransListShow;
      }
    }

    RADIOBOX r_annex
    { row=2.85; col=21.0; width=140;

      ITEM { labelString = MSGGET("cad_msg.txt",4999,"DXF"); id = "dxf";}
      ITEM { labelString = MSGGET("cad_msg.txt",4435,"DWG"); id = "dwg";}

      ON MODIFY EXECUTE
      {
        COMMON DxfTransData
          INTEGER DxfFileAnz,DrawFileAnz;
          STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        INTEGER rc;

        DxfFormat=@.DxfTrans.g_export.r_annex.;
      }

    }

    LABEL l_annex { 
			col=21.8; 
			row=2.5;
			labelString = MSGGET("cad_msg.txt",6255,"Dateiformat");
		}

  }


  GROUP g_import
  {
    !col=26.5;
    !row=2.5;
    row=5.3; col=2.3;
    frame=none;

    SEPARATOR  !! alle
    {
      col = 1;
      row = 1;
      rowLen = 4.32;
      colLen = 38.9;
			labelString = MSGGET("cad_msg.txt",6237,"DXF/DWG Import");
		}

    LABEL l_select{ 
			col=3.8; 
			row=1.8; 
			labelString=" ";
			alignment=begin;
			width=280;
		}
    LABEL l_Quelle { 
			col=3.8; 
			row=2.5; 
			labelString = MSGGET("cad_msg.txt",6236,"Datenquelle");
		}
    LABEL l_list { col=5.8; row=3.3; labelString = MSGGET("cad_msg.txt",675,"Datei"); }

    BUTTON b_list
    {
      row=3.3;
      col=16.8;
      labelString="..."
      tip= MSGGET("cad_msg.txt",6239,"Dateiauswahl");

      ON ACTIVATE EXECUTE
      {
        COMMON DxfTransData
          INTEGER DxfFileAnz,DrawFileAnz;
          STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        STRING FileListType,FileListTitle,FileAnzLabel;
        INTEGER rc,FileListAnz;

        rc= CFNCadMacGetVarString("$FileListType",FileListType);
        IF FileListType <> "DXF" THEN

          FileListType="DXF";
          FileListTitle = MSGGET( "cad_msg.txt", 6238, "Dateiauswahl - DXF/DWG");
          rc=CFNCadMacPutVarReal("&FileListAnz",0);
          DrawFileAnz=0;
          DxfFileAnz=0;
        END IF

        FileAnzLabel="DxfTrans.g_import.l_select";
        rc=CFNCadMacPutVarString("$FileListType",FileListType);
        rc=CFNCadMacPutVarString("$FileListTitle",FileListTitle);
        rc=CFNCadMacPutVarString("$FileAnzLabel",FileAnzLabel);

        !#PRINT " Vor DxfTransShow";

        CALL DxfTransListShow;

      }
    }


    SEPARATOR  !! alle
    {
      col = 3.0;
      row = 2.8;
      rowLen = 2.15;
      orientation=vertical;
      colLen = 17;
    }
  }


  GROUP buttons
  {
    col=2.3;
    row=10.0;

    BUTTON ok
    {
       col = 6;
       row = 1;
       colLen = 11;
       labelString = MSGGET("cad_msg.txt",255,"OK");

       ON ACTIVATE EXECUTE
       {
        COMMON DxfTransData
          INTEGER DxfFileAnz,DrawFileAnz;
          STRING DxfFunc, DxfSource, DxfFormat;
        END COMMON

        INTEGER rc;  STRING DxfTransConfig;

        IF DxfFunc=="Import" THEN
          rc=CFNCadMacPutVarString("$DxfTransFunc",DxfFunc);
          rc=CFNCadMacPutVarString("$DxfTransSource","");
          rc=CFNCadMacPutVarString("$DxfTransFormat","");
        ELSE
          rc=CFNCadMacPutVarString("$DxfTransFunc",DxfFunc);
          rc=CFNCadMacPutVarString("$DxfTransSource",DxfSource);
          rc=CFNCadMacPutVarString("$DxfTransFormat",DxfFormat);
        END IF

        DxfTransConfig=@.DxfTrans.g_config.dxd_input.;
        rc=CFNCadMacPutVarString("$DxfTransConfig",DxfTransConfig);
				CFNCadMacPutVarReal("&DxfParseExt", 1.0);

        CALL ExecMacro($HD_U+"/"+$HD_VE+"/int/dxf/mac/Trans.m");
      }
      ON ACTIVATE DO quit;
        }

     BUTTON cancel
     {
       col = 24;
       row = 1;
       colLen = 11;
       labelString = MSGGET("cad_msg.txt",333,"Abbrechen");
       ON ACTIVATE DO cancel;
    }
  }

}

