@REM@ Makro zum Speichern und Lesen von Dxf-Dateien
@REM@ Datei: DxfTrans.m
@REM@ Erstellt: Unger Gerhard 	am: 11.06.2003
@REM@ Copyright: HD-Engineering

@REM@ Vorraussetzungen

@REM@ $DxfTransConfig .......... 	gewhlte dxd-Datei fr Dxf-Transfer
@REM@ $DxfTransFunc   .......... 	Dxf-Transfer-Funktion (Import/Export)
@REM@ $DxfTransSource	.......... 	Quelle fr Dxf-Export ("file" oder "screen")
@REM@ $DxfTransFormat	.......... 	Format fr Dxf-Export ("dxf" oder "dwg")
@REM@ &FileListAnz		.......... 	Anzahl der ausgewhlten Dateien
@REM@ $FileListOut		..........  Dateiname FileListe inkl. Pfad

$MacPath=MACINFO$("P")\006\x

$DxfPath=""\006\x
$DxfName=""\006\x
$DxfConfig=""\006\x

@IF@DEFINED("&FileListAnz")==0
	&FileListAnz=0\006\x
@ENDIF@
@IF@DEFINED("$FileListType")==0
	$FileListType=""\006\x
@ENDIF@

&MUSTATUS=0\006\x
@REM@ Zeichnung zuerst speichern und Lschen
@IF@(($DxfTransFunc=="Export")AND($DxfTransSource=="file"))OR($DxfTransFunc=="Import")

	&MUMACUTIL=20\006\x
	@1439@
	@IF@&MUSTATUS==0
		@REM@ @O21@Vor DxfStore.m@$hugo
		$GOUTLMCNM= $HD_U&&"/"&&$HD_VE&&"/int/dxf/macro/TransStoreDraw.cm"\006\x
		@gomakro@

		@REM@ @O21@ Test DxfStore@&DxfStore
		@IF@&DxfStore==1
			@N21@
			@E21@
			@IF@&CAD_STAT==0
				@Q7@
				@S10@j\006\r
			@ENDIF@
		@ENDIF@
		@IF@&DxfStore==2
			@Q7@
			@S10@j\006\r
		@ENDIF@
	@ENDIF@

	@REM@ Test ob Muster vorhanden --> abgebrochen
	&MUMACUTIL=20\006\x
	@1439@
	@IF@&MUSTATUS==0
		&MUSTATUS=-1\006\x
	@ELSE@
		&MUSTATUS=0\006\x
	@ENDIF@
		
@ELSE@
	@IF@($F_PATH=="unbenannt.d")OR($F_PATH=="")
		@N21@
		@E21@			
		
		@IF@&CAD_STAT<>0
			&MUSTATUS=-1\006\x
		@ELSE@
			&MUSTATUS=0\006\x
		@ENDIF@
	@ENDIF@
@ENDIF@

ABORT("D")\006\x

@IF@&MUSTATUS==0

	@REM@ Infofenster lschen
	@S19@

	@IF@$DxfTransFunc=="Export"
		@REM@ Dxf-Speichern
	
		@IF@$DxfTransSource=="file"
			@REM@ Quelle ist Dateiliste
			@IF@&FileListAnz>0 
			
				FCLOSE($FileListOut)\006\x
				$line=FREAD$($FileListOut,0)\006\x
				@REPEAT@
					@Q7@
					@S10@
					@d9@

					$DxfConfig=$DxfTransConfig\006\x

					@REM@ Datei laden
					@J20@$line\006\x\r

					$DxfName=SPLIT$($line,"/",-1)\006\x
					$DxfPath=SUBSTR$($line,1,LEN($line)-LEN($DxfName))\006\x
									
					PRINT(" ")\006\x
          $h= MSGGET$("cad_msg.txt",6252,"gelesen")\006\x 
					PRINT($line&&" "&& $h)\006\x

					@M21@$MacPath&&"/TransExport.m"\006\x\r
										
					$line=FREAD$($FileListOut,1)\006\x
				@UNTIL@$line==CHR$(4)
				FCLOSE($FileListOut)\006\x

				@Q7@
				@S10@
				@d9@

			@ELSE@
        $h= MSGGET$("cad_msg.txt",6253,"Keine Dateien ausgewhlt ")\006\x 
				PRINT($h)\006\x
			@ENDIF@
		@ELSE@
			@REM@ Quelle ist Bildschirm
		
			$line=$F_PATH\006\x
			&anz=POS($line,CHR$(92))\006\x
			@WHILE@&anz > 0
				@IF@&anz<LEN($line)
					$line=SUBSTR$($line,1,&anz-1)&&CHR$(47)&&SUBSTR$($line,&anz+1,0)\006\x
				@ELSE@
					$line=SUBSTR$($line,1,&anz-1)&&CHR$(47)\006\x
				@ENDIF@
				&anz=POS($line,CHR$(92))\006\x
			@ENDWHILE@
			PRINT($line)\006\x

			$DxfConfig=$DxfTransConfig\006\x

			$DxfName=SPLIT$($line,"/",-1)\006\x
			$DxfPath=SUBSTR$($line,1,LEN($line)-LEN($DxfName))\006\x
			$DxfName=SPLIT$($DxfName,".",1)\006\x
			$DxfName=$DxfName&&".d"\006\x
			
			PRINT($DxfPath&&$DxfName)\006\x
	
			@M21@$MacPath&&"/TransExport.m"\006\x\r
		@ENDIF@

	@ELSE@
		@REM@ Dxf-Lesen

		@IF@&FileListAnz>0 
			FCLOSE($FileListOut)\006\x
			$line=FREAD$($FileListOut,0)\006\x
			@REPEAT@
				@Q7@
				@S10@
				@d9@

				$DxfConfig=$DxfTransConfig\006\x

				@J20@$line\006\x\r

				PRINT(" ")\006\x
				@IF@ &DxfStat<>0
				  $h2= " - " && VAL$(&DxfStat)\006\x
        @ELSE@
          $h2= ""\006\x
        @ENDIF@
        $h= MSGGET$("cad_msg.txt",6252,"gelesen") && $h2\006\x 
				PRINT($line&&" "&& $h)\006\x

				@REM@ Datei laden
				$DxfName=SPLIT$($line,"/",-1)\006\x
				$DxfPath=SUBSTR$($line,1,LEN($line)-LEN($DxfName))\006\x
				
				@M21@$MacPath&&"/TransImport.m"\006\x\r
										
				$line=FREAD$($FileListOut,1)\006\x
			
			@UNTIL@$line==CHR$(4)
			FCLOSE($FileListOut)\006\x

			@Q7@
			@S10@
			@d9@
		@ELSE@
      $h= MSGGET$("cad_msg.txt",6253,"Keine Dateien ausgewhlt ")\006\x 
			PRINT($h)\006\x
		@ENDIF@
	@ENDIF@

@ENDIF@

$DxfPath=""\006\x
$DxfName=""\006\x
$DxfConfig=""\006\x

ABORT("E")\006\x
